/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import org.apache.sling.auth.oauth_client.impl.OAuthCookieValue;
import org.apache.sling.auth.oauth_client.impl.RedirectTarget;
import org.apache.sling.auth.oauth_client.impl.ResolvedConnection;
import org.apache.sling.commons.crypto.CryptoService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RedirectHelper {
    static final String PARAMETER_NAME_REDIRECT = "redirect";
    private static final int COOKIE_MAX_AGE_SECONDS = 300;
    private static final Logger logger = LoggerFactory.getLogger(RedirectHelper.class);

    private RedirectHelper() {
    }

    @NotNull
    static RedirectTarget buildRedirectTarget(@NotNull String[] paths, @NotNull URI callbackUri, @NotNull ResolvedConnection conn, @NotNull OAuthCookieValue oAuthCookieValue, @NotNull CryptoService cryptoService) {
        String path = RedirectHelper.findLongestPathMatching(paths, callbackUri.getPath());
        Cookie requestKeyCookie = RedirectHelper.buildCookie(path, "sling.oauth-request-key", cryptoService.encrypt(oAuthCookieValue.getValue()));
        URI authorizationEndpointUri = URI.create(conn.authorizationEndpoint());
        Scope scopes = new Scope(conn.scopes().toArray(new String[0]));
        AuthenticationRequest.Builder authRequestBuilder = new AuthenticationRequest.Builder(ResponseType.CODE, scopes, new ClientID(conn.clientId()), callbackUri).endpointURI(authorizationEndpointUri).state(oAuthCookieValue.getState());
        if (oAuthCookieValue.nonce() != null) {
            authRequestBuilder.nonce(oAuthCookieValue.nonce());
        }
        if (oAuthCookieValue.codeVerifier() != null) {
            CodeVerifier codeVerifier = oAuthCookieValue.codeVerifier();
            authRequestBuilder.codeChallenge(codeVerifier, CodeChallengeMethod.S256);
        }
        List parameters = conn.additionalAuthorizationParameters().stream().map(s -> s.split("=")).filter(p -> ((String[])p).length == 2).collect(Collectors.toList());
        for (String[] p2 : parameters) {
            authRequestBuilder.customParameter(p2[0], new String[]{p2[1]});
        }
        URI uri = authRequestBuilder.build().toURI();
        return new RedirectTarget(uri, requestKeyCookie);
    }

    @NotNull
    private static Cookie buildCookie(@Nullable String path, @NotNull String name, @NotNull String value) {
        Cookie cookie = new Cookie(name, value);
        cookie.setHttpOnly(true);
        cookie.setSecure(true);
        cookie.setMaxAge(300);
        if (path != null) {
            cookie.setPath(path);
        }
        return cookie;
    }

    @Nullable
    static String findLongestPathMatching(@NotNull String[] paths, @Nullable String url) {
        String urlPath;
        if (url == null || url.isEmpty() || paths.length == 0) {
            return null;
        }
        try {
            urlPath = new URI(url).getPath();
        }
        catch (URISyntaxException e) {
            logger.debug("findLongestPathMatching: Invalid URL {}", (Object)url, (Object)e);
            return null;
        }
        if (urlPath == null || urlPath.isEmpty()) {
            return null;
        }
        String longestPath = null;
        for (String p : paths) {
            if (!RedirectHelper.isDescendantOrEqual(p, urlPath) || longestPath != null && p.length() <= longestPath.length()) continue;
            longestPath = p;
        }
        return longestPath;
    }

    private static boolean isDescendantOrEqual(String path, String descendant) {
        if (path.equals(descendant)) {
            return true;
        }
        Object pattern = path.endsWith("/") ? path : path + "/";
        return descendant.startsWith((String)pattern);
    }
}

