/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.nav.model;

import de.pdark.decentxml.Element;
import java.util.HashSet;
import org.apache.sling.ide.eclipse.ui.nav.model.JcrNode;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;

public class DirNode
extends JcrNode {
    static String encode(String name) {
        int colon = name.indexOf(":");
        if (colon == -1) {
            return name;
        }
        return "_" + name.substring(0, colon) + "_" + name.substring(colon + 1);
    }

    static String decode(String name) {
        if (((String)name).endsWith(".dir")) {
            return ((String)name).substring(0, ((String)name).length() - 4);
        }
        if (!((String)name).startsWith("_")) {
            return null;
        }
        int pos = ((String)(name = ((String)name).substring(1))).indexOf("_");
        if (pos == -1) {
            return null;
        }
        name = ((String)name).substring(0, pos) + ":" + ((String)name).substring(pos + 1);
        return name;
    }

    static boolean isDirNode(IResource resource) {
        IResource peerNode;
        if (resource == null) {
            return false;
        }
        if (!(resource instanceof IFolder)) {
            return false;
        }
        IFolder folder = (IFolder)resource;
        String resourceName = resource.getName();
        String decodedName = DirNode.decode(resourceName);
        if (decodedName == null) {
            return false;
        }
        IContainer container = folder.getParent();
        if (container == null || !container.exists()) {
            return false;
        }
        return !resourceName.endsWith(".dir") || (peerNode = container.findMember(decodedName)) != null && peerNode.exists();
    }

    DirNode(JcrNode parent, Element domNode, IResource resource) {
        super(parent, domNode, resource);
        if (!DirNode.isDirNode(resource)) {
            throw new IllegalArgumentException("resource is not a DirNode: " + String.valueOf(resource));
        }
    }

    private String getDecodedName() {
        String name = this.getResource().getName();
        String decodedName = DirNode.decode(name);
        if (decodedName == null) {
            throw new IllegalStateException("Cannot decode node named '" + name + "'");
        }
        return decodedName;
    }

    @Override
    String getJcrPathName() {
        return this.getDecodedName();
    }

    @Override
    protected void addChild(JcrNode jcrNode) {
        JcrNode effectiveSibling = this.getEffectiveSibling();
        if (effectiveSibling != this && effectiveSibling != null) {
            effectiveSibling.addChild(jcrNode);
            effectiveSibling.getParent().hide(this);
            return;
        }
        super.addChild(jcrNode);
    }

    JcrNode getEffectiveSibling() {
        String decodedName = this.getDecodedName();
        JcrNode nonDirNodeParent = this.parent;
        block0: while (nonDirNodeParent != null && nonDirNodeParent instanceof DirNode) {
            DirNode dirNodeParent = (DirNode)nonDirNodeParent;
            String decodedParentName = dirNodeParent.getDecodedName();
            HashSet<JcrNode> c = new HashSet<JcrNode>(nonDirNodeParent.parent.children);
            for (JcrNode node : c) {
                if (!node.getName().equals(decodedParentName)) continue;
                nonDirNodeParent = node;
                continue block0;
            }
            nonDirNodeParent = nonDirNodeParent.parent;
        }
        return nonDirNodeParent.getChild(decodedName);
    }

    @Override
    public IFile getFileForEditor() {
        return null;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public boolean canBeDeleted() {
        return true;
    }

    @Override
    public String getLabel() {
        return this.getDecodedName();
    }
}

