/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.tomcat.thread.pool;

import org.apache.skywalking.apm.agent.core.meter.Gauge;
import org.apache.skywalking.apm.agent.core.meter.MeterFactory;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;

public class TomcatThreadExecutorInterceptor
implements InstanceConstructorInterceptor {
    private static final String METER_NAME = "thread_pool";
    private static final String METRIC_POOL_NAME_TAG_NAME = "pool_name";
    private static final String THREAD_POOL_NAME = "tomcat_execute_pool";
    private static final String METRIC_TYPE_TAG_NAME = "metric_type";

    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) throws Throwable {
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)objInst;
        ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, () -> threadPoolExecutor.getCorePoolSize()).tag(METRIC_POOL_NAME_TAG_NAME, THREAD_POOL_NAME)).tag(METRIC_TYPE_TAG_NAME, "core_pool_size")).build();
        ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, () -> threadPoolExecutor.getMaximumPoolSize()).tag(METRIC_POOL_NAME_TAG_NAME, THREAD_POOL_NAME)).tag(METRIC_TYPE_TAG_NAME, "max_pool_size")).build();
        ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, () -> threadPoolExecutor.getPoolSize()).tag(METRIC_POOL_NAME_TAG_NAME, THREAD_POOL_NAME)).tag(METRIC_TYPE_TAG_NAME, "pool_size")).build();
        ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, () -> threadPoolExecutor.getQueue().size()).tag(METRIC_POOL_NAME_TAG_NAME, THREAD_POOL_NAME)).tag(METRIC_TYPE_TAG_NAME, "queue_size")).build();
        ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, () -> threadPoolExecutor.getActiveCount()).tag(METRIC_POOL_NAME_TAG_NAME, THREAD_POOL_NAME)).tag(METRIC_TYPE_TAG_NAME, "active_size")).build();
    }
}

