/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.skywalking.apm.testcase.dubbo3.services.impl;

import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.skywalking.apm.testcase.dubbo3.services.ExceptionService;
import org.apache.skywalking.apm.testcase.dubbo3.services.GreetService;

public class GreetServiceImpl implements GreetService {

    private RegistryConfig registryConfig = new RegistryConfig("zookeeper://127.0.0.1:2181");

    @Override
    public String doBusiness(String s) {
        try {
            ReferenceConfig<ExceptionService> referenceConfig = new ReferenceConfig<>();
            referenceConfig.setRegistry(registryConfig);
            referenceConfig.setInterface(ExceptionService.class);
            referenceConfig.setScope("remote");
            referenceConfig.setInjvm(false);
            referenceConfig.setTimeout(500000);
            referenceConfig.setAsync(false);
            referenceConfig.setCheck(false);

            ExceptionService exceptionService = referenceConfig.get();
            exceptionService.exceptionCall();
        } catch (Exception e) {
            // do nothing
            e.printStackTrace();
        }
        return "{name:'" + s + "'}";
    }
}
