/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.lightweight;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.servicecomb.registry.lightweight.Message;
import org.apache.servicecomb.registry.lightweight.MessageType;
import org.apache.servicecomb.registry.lightweight.RegisterRequest;
import org.apache.servicecomb.registry.lightweight.Self;
import org.apache.servicecomb.registry.lightweight.StoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageExecutor.class);
    private final Self self;
    private final StoreService storeService;
    private final Map<MessageType, Consumer<?>> messageProcessors = new HashMap();
    private final ScheduledExecutorService taskExecutor = Executors.newSingleThreadScheduledExecutor(runnable -> new Thread(runnable, "lightweight-message-executor"));

    public MessageExecutor(Self self, StoreService storeService) {
        this.self = self;
        this.storeService = storeService;
        this.addMessageProcessor(MessageType.REGISTER, this::register);
        this.addMessageProcessor(MessageType.UNREGISTER, storeService::unregister);
    }

    public void startCheckDeadInstances(Duration interval) {
        this.taskExecutor.scheduleAtFixedRate(() -> this.storeService.deleteDeadInstances(interval), 0L, interval.getSeconds(), TimeUnit.SECONDS);
    }

    private void register(RegisterRequest request) {
        if (request.isCrossApp() || Objects.equals(request.getAppId(), this.self.getAppId())) {
            this.storeService.register(request);
        }
    }

    private <T> void addMessageProcessor(MessageType messageType, Consumer<T> messageProcessor) {
        this.messageProcessors.put(messageType, messageProcessor);
    }

    public <T> void processMessage(Message<T> message) {
        Consumer<?> consumer = this.messageProcessors.get((Object)message.getType());
        this.taskExecutor.execute(() -> {
            try {
                consumer.accept(message.getBody());
            }
            catch (Throwable e) {
                LOGGER.error("process message error. ", e);
            }
        });
    }
}

