/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.scalar;

import io.protostuff.OutputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import org.apache.servicecomb.foundation.common.utils.bean.DoubleGetter;
import org.apache.servicecomb.foundation.common.utils.bean.Getter;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;

public class DoubleWriteSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        if (Double.TYPE.equals(propertyDescriptor.getJavaType().getRawClass())) {
            return new DoublePrimitiveSchema(protoField, propertyDescriptor);
        }
        if (Double.class.equals((Object)propertyDescriptor.getJavaType().getRawClass())) {
            return new DoubleSchema(protoField, propertyDescriptor);
        }
        return new DoubleSchema(protoField, propertyDescriptor);
    }

    private static class DoublePrimitiveSchema<T>
    extends DoubleDynamicSchema<T> {
        private final DoubleGetter<T> primitiveGetter;

        public DoublePrimitiveSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
            this.primitiveGetter = (DoubleGetter)propertyDescriptor.getGetter();
        }

        @Override
        public final void getAndWriteTo(OutputEx output, T message) throws IOException {
            double value = this.primitiveGetter.get(message);
            output.writeScalarDouble(this.tag, this.tagSize, value);
        }
    }

    private static class DoubleSchema<T>
    extends DoubleDynamicSchema<T> {
        protected final Getter<T, Object> getter;

        public DoubleSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
            this.getter = (Getter)propertyDescriptor.getGetter();
        }

        @Override
        public final void getAndWriteTo(OutputEx output, T message) throws IOException {
            Object value = this.getter.get(message);
            if (value != null) {
                this.writeTo(output, value);
            }
        }
    }

    private static class DoubleDynamicSchema<T>
    extends FieldSchema<T> {
        public DoubleDynamicSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
        }

        @Override
        public final void writeTo(OutputEx output, Object value) throws IOException {
            if (value instanceof Number) {
                output.writeScalarDouble(this.tag, this.tagSize, ((Number)value).doubleValue());
                return;
            }
            if (value instanceof String[]) {
                if (((String[])value).length == 0) {
                    return;
                }
                double parsedValue = Double.parseDouble(((String[])value)[0]);
                output.writeScalarDouble(this.tag, this.tagSize, parsedValue);
                return;
            }
            if (value instanceof String) {
                double parsedValue = Double.parseDouble((String)value);
                output.writeScalarDouble(this.tag, this.tagSize, parsedValue);
                return;
            }
            ProtoUtils.throwNotSupportWrite(this.protoField, value);
        }
    }
}

