/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.java.hints.jdk;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Map.Entry;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;

/**
 *
 * @author lahvac
 */
public class ConvertToDiamondBulkHintPanel extends javax.swing.JPanel {

    private final Map<String, JCheckBox> settings = new TreeMap<>();

    public ConvertToDiamondBulkHintPanel(final Preferences p) {
        initComponents();

        settings.put("initializer", initializer);
        settings.put("assignment", assignment);
        settings.put("return", returnStatement);
        settings.put("argument", argument);
        settings.put("other", other);

        ActionListener toggle = new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent ev) {
                StringBuilder res = new StringBuilder();

                for (Entry<String, JCheckBox> e : settings.entrySet()) {
                    if (!e.getValue().isSelected()) continue;
                    if (res.length() > 0) res.append(",");
                    res.append(e.getKey());
                }

                ConvertToDiamondBulkHint.putConfiguration(p, res.toString());
            }
        };

        for (Entry<String, JCheckBox> e : settings.entrySet()) {
            e.getValue().setSelected(ConvertToDiamondBulkHint.isEnabled(p, e.getKey()));
            e.getValue().addActionListener(toggle);
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        initializer = new javax.swing.JCheckBox();
        assignment = new javax.swing.JCheckBox();
        returnStatement = new javax.swing.JCheckBox();
        argument = new javax.swing.JCheckBox();
        other = new javax.swing.JCheckBox();
        jLabel1 = new javax.swing.JLabel();

        initializer.setText(org.openide.util.NbBundle.getMessage(ConvertToDiamondBulkHintPanel.class, "ConvertToDiamondBulkHintPanel.initializer.text")); // NOI18N

        assignment.setText(org.openide.util.NbBundle.getMessage(ConvertToDiamondBulkHintPanel.class, "ConvertToDiamondBulkHintPanel.assignment.text")); // NOI18N

        returnStatement.setText(org.openide.util.NbBundle.getMessage(ConvertToDiamondBulkHintPanel.class, "ConvertToDiamondBulkHintPanel.returnStatement.text")); // NOI18N

        argument.setText(org.openide.util.NbBundle.getMessage(ConvertToDiamondBulkHintPanel.class, "ConvertToDiamondBulkHintPanel.argument.text")); // NOI18N

        other.setText(org.openide.util.NbBundle.getMessage(ConvertToDiamondBulkHintPanel.class, "ConvertToDiamondBulkHintPanel.other.text")); // NOI18N

        jLabel1.setText(org.openide.util.NbBundle.getMessage(ConvertToDiamondBulkHintPanel.class, "ConvertToDiamondBulkHintPanel.jLabel1.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(initializer)
                    .addComponent(assignment)
                    .addComponent(returnStatement)
                    .addComponent(argument)
                    .addComponent(other)
                    .addComponent(jLabel1))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(initializer)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(assignment)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(returnStatement)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(argument)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(other)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox argument;
    private javax.swing.JCheckBox assignment;
    private javax.swing.JCheckBox initializer;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JCheckBox other;
    private javax.swing.JCheckBox returnStatement;
    // End of variables declaration//GEN-END:variables
}
