/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jul.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Level;

public final class LevelConverter {
    static final Level FINEST = Level.forName((String)"FINEST", (int)(Level.TRACE.intLevel() + 100));
    static final Level CONFIG = Level.forName((String)"CONFIG", (int)(Level.INFO.intLevel() + 50));
    private static final java.util.logging.Level JUL_FATAL = new CustomJulLevel("FATAL", java.util.logging.Level.SEVERE.intValue() + 100);
    private static final Map<java.util.logging.Level, Level> julToLog4j = new ConcurrentHashMap<java.util.logging.Level, Level>();
    private static final Map<Level, java.util.logging.Level> log4jToJul = new ConcurrentHashMap<Level, java.util.logging.Level>();

    private LevelConverter() {
    }

    static int log4jToJulIntLevel(int log4jLevel) {
        if (log4jLevel <= Level.OFF.intLevel()) {
            return java.util.logging.Level.OFF.intValue();
        }
        if (log4jLevel <= Level.INFO.intLevel()) {
            return java.util.logging.Level.INFO.intValue() + (Level.INFO.intLevel() - log4jLevel);
        }
        if (log4jLevel <= CONFIG.intLevel()) {
            return java.util.logging.Level.CONFIG.intValue() + 2 * (CONFIG.intLevel() - log4jLevel);
        }
        if (log4jLevel <= Level.DEBUG.intLevel()) {
            return java.util.logging.Level.FINE.intValue() + 4 * (Level.DEBUG.intLevel() - log4jLevel);
        }
        if (log4jLevel != Level.ALL.intLevel()) {
            return java.util.logging.Level.FINE.intValue() + (Level.DEBUG.intLevel() - log4jLevel);
        }
        return Level.ALL.intLevel();
    }

    static int julToLog4jIntLevel(int julLevel) {
        if (julLevel <= java.util.logging.Level.FINE.intValue() + (Level.DEBUG.intLevel() - Level.ALL.intLevel())) {
            return Level.ALL.intLevel();
        }
        if (julLevel <= java.util.logging.Level.FINE.intValue()) {
            return Level.DEBUG.intLevel() + (java.util.logging.Level.FINE.intValue() - julLevel);
        }
        if (julLevel <= java.util.logging.Level.CONFIG.intValue()) {
            return CONFIG.intLevel() + (java.util.logging.Level.CONFIG.intValue() - julLevel) / 4;
        }
        if (julLevel <= java.util.logging.Level.INFO.intValue()) {
            return Level.INFO.intLevel() + (java.util.logging.Level.INFO.intValue() - julLevel) / 2;
        }
        if (julLevel <= java.util.logging.Level.INFO.intValue() + (Level.INFO.intLevel() - 1)) {
            return Level.INFO.intLevel() + (java.util.logging.Level.INFO.intValue() - julLevel);
        }
        return Level.OFF.intLevel();
    }

    public static java.util.logging.Level toJulLevel(Level log4jLevel) {
        return log4jLevel != null ? log4jToJul.computeIfAbsent(log4jLevel, l -> new CustomJulLevel(l.name(), LevelConverter.log4jToJulIntLevel(l.intLevel()))) : null;
    }

    public static Level toLog4jLevel(java.util.logging.Level julLevel) {
        return julLevel != null ? julToLog4j.computeIfAbsent(julLevel, l -> Level.forName((String)l.getName(), (int)LevelConverter.julToLog4jIntLevel(l.intValue()))) : null;
    }

    static {
        Map<Level, java.util.logging.Level> log4jtoJul = Map.of(Level.OFF, java.util.logging.Level.OFF, Level.FATAL, JUL_FATAL, Level.ERROR, java.util.logging.Level.SEVERE, Level.WARN, java.util.logging.Level.WARNING, Level.INFO, java.util.logging.Level.INFO, CONFIG, java.util.logging.Level.CONFIG, Level.DEBUG, java.util.logging.Level.FINE, Level.TRACE, java.util.logging.Level.FINER, FINEST, java.util.logging.Level.FINEST, Level.ALL, java.util.logging.Level.ALL);
        log4jToJul.putAll(log4jtoJul);
        for (Map.Entry<Level, java.util.logging.Level> entry : log4jtoJul.entrySet()) {
            julToLog4j.put(entry.getValue(), entry.getKey());
        }
    }

    private static class CustomJulLevel
    extends java.util.logging.Level {
        private CustomJulLevel(String name, int value) {
            super(name, value);
        }
    }
}

