/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;

public abstract class AbstractCompressAction
extends AbstractAction {
    protected static final int BUF_SIZE = 8192;
    private final Path source;
    private final Path destination;

    public AbstractCompressAction(Path source, Path destination) {
        this.source = Objects.requireNonNull(source, "source");
        this.destination = Objects.requireNonNull(destination, "destination");
    }

    protected abstract String getAlgorithmName();

    protected abstract OutputStream wrapOutputStream(OutputStream var1) throws IOException;

    @Override
    public boolean execute() throws IOException {
        if (Files.exists(this.source, new LinkOption[0])) {
            LOGGER.debug("Starting {} compression from {} to {}.", (Object)this.getAlgorithmName(), (Object)this.source, (Object)this.destination);
            try (OutputStream output = this.wrapOutputStream(Files.newOutputStream(this.destination, new OpenOption[0]));){
                Files.copy(this.source, output);
            }
            LOGGER.debug("Finished {} compression from {} to {}.", (Object)this.getAlgorithmName(), (Object)this.source, (Object)this.destination);
            try {
                Files.delete(this.source);
                LOGGER.debug("File {} deleted successfully.", (Object)this.source);
            }
            catch (IOException ioe) {
                LOGGER.warn("Unable to delete {}.", (Object)this.source, (Object)ioe);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void reportException(Exception ex) {
        LOGGER.warn("Exception during compression of '{}'.", (Object)this.source, (Object)ex);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.source + " to " + this.destination + "]";
    }
}

