/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.kit.env.internal;

import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.kit.env.PropertyEnvironment;
import org.apache.logging.log4j.kit.env.internal.DefaultPropertyMappingParser;
import org.apache.logging.log4j.kit.env.internal.PropertyMapping;
import org.apache.logging.log4j.kit.env.support.BasicPropertyEnvironment;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.jspecify.annotations.Nullable;

public class PropertiesUtilPropertyEnvironment
extends BasicPropertyEnvironment {
    private static final String PREFIX = "log4j.";
    private static final String PROPERTY_MAPPING_RESOURCE = "META-INF/log4j/propertyMapping.json";
    public static final PropertyEnvironment INSTANCE = new PropertiesUtilPropertyEnvironment(PropertiesUtil.getProperties(), (Logger)StatusLogger.getLogger());
    private final PropertiesUtil propsUtil;
    private final PropertyMapping propertyMapping;

    public PropertiesUtilPropertyEnvironment(PropertiesUtil propsUtil, Logger statusLogger) {
        this(propsUtil, statusLogger, PropertiesUtilPropertyEnvironment.getPropertyMapping(statusLogger));
    }

    PropertiesUtilPropertyEnvironment(PropertiesUtil propsUtil, Logger statusLogger, PropertyMapping propertyMapping) {
        super(statusLogger);
        this.propsUtil = propsUtil;
        this.propertyMapping = propertyMapping;
    }

    private static PropertyMapping getPropertyMapping(Logger statusLogger) {
        try {
            return DefaultPropertyMappingParser.parse(PROPERTY_MAPPING_RESOURCE);
        }
        catch (IOException | IllegalArgumentException e) {
            statusLogger.error("Unable to load legacy property mappings.", (Throwable)e);
            return PropertyMapping.EMPTY;
        }
    }

    @Override
    public @Nullable String getProperty(String name) {
        String value = this.propsUtil.getStringProperty(PREFIX + name);
        if (value == null) {
            List<? extends String> legacyKeys = this.propertyMapping.getLegacyKeys(name);
            for (int i = 0; value == null && i < legacyKeys.size(); ++i) {
                value = this.propsUtil.getStringProperty(legacyKeys.get(i));
            }
        }
        return value;
    }
}

