/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.internal;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import org.apache.logging.log4j.core.test.internal.GcPressureGenerator;
import org.junit.jupiter.api.function.ThrowingSupplier;

public final class GcHelper {
    private GcHelper() {
    }

    public static void awaitGarbageCollection(ThrowingSupplier<?> valueSupplier) throws InterruptedException {
        ReferenceQueue refQueue = new ReferenceQueue();
        try {
            Object value = valueSupplier.get();
            PhantomReference<Object> ref = new PhantomReference<Object>(value, refQueue);
        }
        catch (Throwable error) {
            throw new RuntimeException("failed obtaining value", error);
        }
        try (GcPressureGenerator ignored = GcPressureGenerator.ofStarted();){
            Reference removedRef = refQueue.remove(30000L);
            if (removedRef == null) {
                throw new AssertionError((Object)"garbage collector did not reclaim the value");
            }
        }
    }
}

