/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolver;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.StackTraceElementResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.StackTraceElementResolverFactory;
import org.apache.logging.log4j.layout.template.json.resolver.StackTraceElementResolverStringSubstitutor;
import org.apache.logging.log4j.layout.template.json.resolver.StackTraceObjectResolver;
import org.apache.logging.log4j.layout.template.json.resolver.StackTraceStringResolver;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolver;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverConfig;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolvers;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;
import org.apache.logging.log4j.status.StatusLogger;

public class ExceptionResolver
implements EventResolver {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final EventResolver NULL_RESOLVER = (ignored, jsonGenerator) -> jsonGenerator.writeNull();
    private final boolean stackTraceEnabled;
    private final EventResolver internalResolver;
    private static final Map<String, StackTraceElementResolverFactory> STACK_TRACE_ELEMENT_RESOLVER_FACTORY_BY_NAME;

    ExceptionResolver(EventResolverContext context, TemplateResolverConfig config) {
        this.stackTraceEnabled = context.isStackTraceEnabled();
        this.internalResolver = this.createInternalResolver(context, config);
    }

    EventResolver createInternalResolver(EventResolverContext context, TemplateResolverConfig config) {
        String fieldName = config.getString("field");
        if ("className".equals(fieldName)) {
            return this.createClassNameResolver();
        }
        if ("message".equals(fieldName)) {
            return this.createMessageResolver();
        }
        if ("stackTrace".equals(fieldName)) {
            return this.createStackTraceResolver(context, config);
        }
        throw new IllegalArgumentException("unknown field: " + config);
    }

    private EventResolver createClassNameResolver() {
        return (logEvent, jsonWriter) -> {
            Throwable exception = this.extractThrowable((LogEvent)logEvent);
            if (exception == null) {
                jsonWriter.writeNull();
            } else {
                String exceptionClassName = exception.getClass().getCanonicalName();
                jsonWriter.writeString(exceptionClassName);
            }
        };
    }

    private EventResolver createMessageResolver() {
        return (logEvent, jsonWriter) -> {
            Throwable exception = this.extractThrowable((LogEvent)logEvent);
            if (exception == null) {
                jsonWriter.writeNull();
            } else {
                String exceptionMessage = exception.getMessage();
                jsonWriter.writeString(exceptionMessage);
            }
        };
    }

    private EventResolver createStackTraceResolver(EventResolverContext context, TemplateResolverConfig config) {
        if (!context.isStackTraceEnabled()) {
            return NULL_RESOLVER;
        }
        boolean stringified = ExceptionResolver.isStackTraceStringified(config);
        return stringified ? this.createStackTraceStringResolver(context, config) : this.createStackTraceObjectResolver(context, config);
    }

    private static boolean isStackTraceStringified(TemplateResolverConfig config) {
        Boolean stringifiedOld = config.getBoolean("stringified");
        if (stringifiedOld != null) {
            LOGGER.warn("\"stringified\" flag at the root level of an exception [root cause] resolver is deprecated in favor of \"stackTrace.stringified\"");
        }
        Object stringifiedNew = config.getObject(new String[]{"stackTrace", "stringified"});
        if (stringifiedOld == null && stringifiedNew == null) {
            return false;
        }
        if (stringifiedNew == null) {
            return stringifiedOld;
        }
        return !(stringifiedNew instanceof Boolean) || (Boolean)stringifiedNew != false;
    }

    private EventResolver createStackTraceStringResolver(EventResolverContext context, TemplateResolverConfig config) {
        String truncationSuffix = ExceptionResolver.readTruncationSuffix(context, config);
        List<String> truncationPointMatcherStrings = ExceptionResolver.readTruncationPointMatcherStrings(config);
        List<String> truncationPointMatcherRegexes = ExceptionResolver.readTruncationPointMatcherRegexes(config);
        StackTraceStringResolver resolver = new StackTraceStringResolver(context, truncationSuffix, truncationPointMatcherStrings, truncationPointMatcherRegexes);
        return (logEvent, jsonWriter) -> {
            Throwable exception = this.extractThrowable((LogEvent)logEvent);
            if (exception == null) {
                jsonWriter.writeNull();
            } else {
                resolver.resolve(exception, jsonWriter);
            }
        };
    }

    private static String readTruncationSuffix(EventResolverContext context, TemplateResolverConfig config) {
        String suffix = config.getString(new String[]{"stackTrace", "stringified", "truncation", "suffix"});
        return suffix != null ? suffix : context.getTruncatedStringSuffix();
    }

    private static List<String> readTruncationPointMatcherStrings(TemplateResolverConfig config) {
        List<String> strings = config.getList(new String[]{"stackTrace", "stringified", "truncation", "pointMatcherStrings"}, String.class);
        if (strings == null) {
            strings = Collections.emptyList();
        }
        return strings;
    }

    private static List<String> readTruncationPointMatcherRegexes(TemplateResolverConfig config) {
        List<String> regexes = config.getList(new String[]{"stackTrace", "stringified", "truncation", "pointMatcherRegexes"}, String.class);
        if (regexes == null) {
            regexes = Collections.emptyList();
        }
        for (int i = 0; i < regexes.size(); ++i) {
            String regex = regexes.get(i);
            try {
                Pattern.compile(regex);
                continue;
            }
            catch (PatternSyntaxException error) {
                String message = String.format("invalid truncation point matcher regex at index %d: %s", i, regex);
                throw new IllegalArgumentException(message, error);
            }
        }
        return regexes;
    }

    private EventResolver createStackTraceObjectResolver(EventResolverContext context, TemplateResolverConfig config) {
        TemplateResolver<StackTraceElement> stackTraceElementResolver = ExceptionResolver.createStackTraceElementResolver(context, config);
        StackTraceObjectResolver stackTraceResolver = new StackTraceObjectResolver(stackTraceElementResolver);
        return (logEvent, jsonWriter) -> {
            Throwable throwable = this.extractThrowable((LogEvent)logEvent);
            if (throwable == null) {
                jsonWriter.writeNull();
            } else {
                stackTraceResolver.resolve(throwable, jsonWriter);
            }
        };
    }

    private static TemplateResolver<StackTraceElement> createStackTraceElementResolver(EventResolverContext context, TemplateResolverConfig config) {
        StackTraceElementResolverStringSubstitutor substitutor = new StackTraceElementResolverStringSubstitutor(context.getSubstitutor().getInternalSubstitutor());
        StackTraceElementResolverContext stackTraceElementResolverContext = StackTraceElementResolverContext.newBuilder().setResolverFactoryByName(STACK_TRACE_ELEMENT_RESOLVER_FACTORY_BY_NAME).setSubstitutor(substitutor).setJsonWriter(context.getJsonWriter()).setDefaults(config.getDefaults()).build();
        String stackTraceElementTemplate = ExceptionResolver.findEffectiveStackTraceElementTemplate(context, config);
        return TemplateResolvers.ofTemplate(stackTraceElementResolverContext, stackTraceElementTemplate);
    }

    private static String findEffectiveStackTraceElementTemplate(EventResolverContext context, TemplateResolverConfig config) {
        Object stackTraceElementTemplateObject = config.getObject(new String[]{"stackTrace", "elementTemplate"});
        if (stackTraceElementTemplateObject != null) {
            JsonWriter jsonWriter = context.getJsonWriter();
            return jsonWriter.use(() -> jsonWriter.writeValue(stackTraceElementTemplateObject));
        }
        return context.getStackTraceElementTemplate();
    }

    Throwable extractThrowable(LogEvent logEvent) {
        return logEvent.getThrown();
    }

    static String getName() {
        return "exception";
    }

    @Override
    public boolean isResolvable() {
        return this.stackTraceEnabled;
    }

    @Override
    public boolean isResolvable(LogEvent logEvent) {
        return this.stackTraceEnabled && logEvent.getThrown() != null;
    }

    @Override
    public void resolve(LogEvent logEvent, JsonWriter jsonWriter) {
        this.internalResolver.resolve(logEvent, jsonWriter);
    }

    static {
        StackTraceElementResolverFactory stackTraceElementResolverFactory = StackTraceElementResolverFactory.getInstance();
        STACK_TRACE_ELEMENT_RESOLVER_FACTORY_BY_NAME = Collections.singletonMap(stackTraceElementResolverFactory.getName(), stackTraceElementResolverFactory);
    }
}

