/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vacation.api;

import com.google.common.base.Preconditions;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.util.ValuePatch;
import org.apache.james.vacation.api.Vacation;

public class VacationPatch {
    private final ValuePatch<String> subject;
    private final ValuePatch<String> textBody;
    private final ValuePatch<String> htmlBody;
    private final ValuePatch<ZonedDateTime> toDate;
    private final ValuePatch<ZonedDateTime> fromDate;
    private final ValuePatch<Boolean> isEnabled;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFrom(Vacation vacation) {
        return VacationPatch.builder().subject(ValuePatch.ofOptional(vacation.getSubject())).textBody(ValuePatch.ofOptional(vacation.getTextBody())).htmlBody(ValuePatch.ofOptional(vacation.getHtmlBody())).fromDate(ValuePatch.ofOptional(vacation.getFromDate())).toDate(ValuePatch.ofOptional(vacation.getToDate())).isEnabled(ValuePatch.modifyTo(vacation.isEnabled()));
    }

    private VacationPatch(ValuePatch<String> subject, ValuePatch<String> textBody, ValuePatch<String> htmlBody, ValuePatch<ZonedDateTime> toDate, ValuePatch<ZonedDateTime> fromDate, ValuePatch<Boolean> isEnabled) {
        Preconditions.checkState(!isEnabled.isRemoved());
        this.subject = subject;
        this.textBody = textBody;
        this.htmlBody = htmlBody;
        this.toDate = toDate;
        this.fromDate = fromDate;
        this.isEnabled = isEnabled;
    }

    public ValuePatch<String> getSubject() {
        return this.subject;
    }

    public ValuePatch<String> getTextBody() {
        return this.textBody;
    }

    public ValuePatch<String> getHtmlBody() {
        return this.htmlBody;
    }

    public ValuePatch<ZonedDateTime> getToDate() {
        return this.toDate;
    }

    public ValuePatch<ZonedDateTime> getFromDate() {
        return this.fromDate;
    }

    public ValuePatch<Boolean> getIsEnabled() {
        return this.isEnabled;
    }

    public Vacation patch(Vacation vacation) {
        return Vacation.builder().subject(this.subject.notKeptOrElse(vacation.getSubject())).fromDate(this.fromDate.notKeptOrElse(vacation.getFromDate())).toDate(this.toDate.notKeptOrElse(vacation.getToDate())).textBody(this.textBody.notKeptOrElse(vacation.getTextBody())).htmlBody(this.htmlBody.notKeptOrElse(vacation.getHtmlBody())).enabled(this.isEnabled.notKeptOrElse(Optional.of(vacation.isEnabled())).get()).build();
    }

    public boolean isIdentity() {
        return this.subject.isKept() && this.textBody.isKept() && this.htmlBody.isKept() && this.toDate.isKept() && this.fromDate.isKept() && this.isEnabled.isKept();
    }

    public boolean equals(Object o) {
        if (o instanceof VacationPatch) {
            VacationPatch that = (VacationPatch)o;
            return Objects.equals(this.subject, that.subject) && Objects.equals(this.textBody, that.textBody) && Objects.equals(this.htmlBody, that.htmlBody) && Objects.equals(this.toDate, that.toDate) && Objects.equals(this.fromDate, that.fromDate) && Objects.equals(this.isEnabled, that.isEnabled);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.textBody, this.htmlBody, this.toDate, this.fromDate, this.isEnabled);
    }

    public static class Builder {
        private ValuePatch<String> subject = ValuePatch.keep();
        private ValuePatch<String> textBody = ValuePatch.keep();
        private ValuePatch<String> htmlBody = ValuePatch.keep();
        private ValuePatch<ZonedDateTime> toDate = ValuePatch.keep();
        private ValuePatch<ZonedDateTime> fromDate = ValuePatch.keep();
        private ValuePatch<Boolean> isEnabled = ValuePatch.keep();

        public Builder subject(ValuePatch<String> subject) {
            Preconditions.checkNotNull(subject);
            this.subject = subject;
            return this;
        }

        public Builder subject(String subject) {
            this.subject = ValuePatch.modifyTo(subject);
            return this;
        }

        public Builder textBody(ValuePatch<String> textBody) {
            Preconditions.checkNotNull(textBody);
            this.textBody = textBody;
            return this;
        }

        public Builder textBody(String textBody) {
            this.textBody = ValuePatch.modifyTo(textBody);
            return this;
        }

        public Builder htmlBody(ValuePatch<String> htmlBody) {
            Preconditions.checkNotNull(htmlBody);
            this.htmlBody = htmlBody;
            return this;
        }

        public Builder htmlBody(String htmlBody) {
            this.htmlBody = ValuePatch.modifyTo(htmlBody);
            return this;
        }

        public Builder toDate(ValuePatch<ZonedDateTime> toDate) {
            Preconditions.checkNotNull(toDate);
            this.toDate = toDate;
            return this;
        }

        public Builder toDate(ZonedDateTime toDate) {
            this.toDate = ValuePatch.modifyTo(toDate);
            return this;
        }

        public Builder fromDate(ValuePatch<ZonedDateTime> fromDate) {
            Preconditions.checkNotNull(fromDate);
            this.fromDate = fromDate;
            return this;
        }

        public Builder fromDate(ZonedDateTime fromDate) {
            this.fromDate = ValuePatch.modifyTo(fromDate);
            return this;
        }

        public Builder isEnabled(ValuePatch<Boolean> isEnabled) {
            Preconditions.checkNotNull(isEnabled);
            this.isEnabled = isEnabled;
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = ValuePatch.modifyTo(isEnabled);
            return this;
        }

        public Builder addAll(Builder other) {
            return VacationPatch.builder().isEnabled(this.isEnabled.merge(other.isEnabled)).fromDate(this.fromDate.merge(other.fromDate)).toDate(this.toDate.merge(other.toDate)).subject(this.subject.merge(other.subject)).htmlBody(this.htmlBody.merge(other.htmlBody)).textBody(this.textBody.merge(other.textBody));
        }

        public VacationPatch build() {
            return new VacationPatch(this.subject, this.textBody, this.htmlBody, this.toDate, this.fromDate, this.isEnabled);
        }
    }
}

