/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common.block.column;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.ColumnEncoder;
import org.apache.tsfile.read.common.block.column.FloatColumn;
import org.apache.tsfile.read.common.block.column.IntColumn;

public class Int32ArrayColumnEncoder
implements ColumnEncoder {
    @Override
    public Column readColumn(ByteBuffer input, TSDataType dataType, int positionCount) {
        boolean[] nullIndicators = ColumnEncoder.deserializeNullIndicators(input, positionCount);
        switch (dataType) {
            case INT32: 
            case DATE: {
                int[] intValues = new int[positionCount];
                if (nullIndicators == null) {
                    for (int i = 0; i < positionCount; ++i) {
                        intValues[i] = input.getInt();
                    }
                } else {
                    for (int i = 0; i < positionCount; ++i) {
                        if (nullIndicators[i]) continue;
                        intValues[i] = input.getInt();
                    }
                }
                return new IntColumn(0, positionCount, nullIndicators, intValues);
            }
            case FLOAT: {
                float[] floatValues = new float[positionCount];
                if (nullIndicators == null) {
                    for (int i = 0; i < positionCount; ++i) {
                        floatValues[i] = Float.intBitsToFloat(input.getInt());
                    }
                } else {
                    for (int i = 0; i < positionCount; ++i) {
                        if (nullIndicators[i]) continue;
                        floatValues[i] = Float.intBitsToFloat(input.getInt());
                    }
                }
                return new FloatColumn(0, positionCount, nullIndicators, floatValues);
            }
        }
        throw new IllegalArgumentException("Invalid data type: " + dataType);
    }

    @Override
    public void writeColumn(DataOutputStream output, Column column) throws IOException {
        ColumnEncoder.serializeNullIndicators(output, column);
        TSDataType dataType = column.getDataType();
        int positionCount = column.getPositionCount();
        switch (dataType) {
            case INT32: 
            case DATE: {
                if (column.mayHaveNull()) {
                    for (int i = 0; i < positionCount; ++i) {
                        if (column.isNull(i)) continue;
                        output.writeInt(column.getInt(i));
                    }
                } else {
                    for (int i = 0; i < positionCount; ++i) {
                        output.writeInt(column.getInt(i));
                    }
                }
                break;
            }
            case FLOAT: {
                if (column.mayHaveNull()) {
                    for (int i = 0; i < positionCount; ++i) {
                        if (column.isNull(i)) continue;
                        output.writeInt(Float.floatToIntBits(column.getFloat(i)));
                    }
                } else {
                    for (int i = 0; i < positionCount; ++i) {
                        output.writeInt(Float.floatToIntBits(column.getFloat(i)));
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid data type: " + dataType);
            }
        }
    }
}

