/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.cluster;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridBaselineCommandResponse
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private boolean active;
    private long topVer;
    private Collection<String> baseline;
    private Collection<String> srvs;

    private static Collection<String> consistentIds(Collection<? extends BaselineNode> nodes) {
        return nodes.stream().map(n -> String.valueOf(n.consistentId())).collect(Collectors.toList());
    }

    public GridBaselineCommandResponse() {
    }

    GridBaselineCommandResponse(boolean active, long topVer, Collection<? extends BaselineNode> baseline, Collection<? extends BaselineNode> srvs) {
        this.active = active;
        this.topVer = topVer;
        this.baseline = GridBaselineCommandResponse.consistentIds(baseline);
        this.srvs = GridBaselineCommandResponse.consistentIds(srvs);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public long getTopologyVersion() {
        return this.topVer;
    }

    public void setTopologyVersion(long topVer) {
        this.topVer = topVer;
    }

    public Collection<String> getBaseline() {
        return this.baseline;
    }

    public void setBaseline(Collection<String> baseline) {
        this.baseline = baseline;
    }

    public Collection<String> getServers() {
        return this.srvs;
    }

    public void setServers(Collection<String> srvs) {
        this.srvs = srvs;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.active);
        out.writeLong(this.topVer);
        U.writeCollection(out, this.baseline);
        U.writeCollection(out, this.srvs);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.active = in.readBoolean();
        this.topVer = in.readLong();
        this.baseline = U.readCollection(in);
        this.srvs = U.readCollection(in);
    }

    public String toString() {
        return S.toString(GridBaselineCommandResponse.class, this);
    }
}

