/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.apache.ignite.internal.util.typedef.internal.U;

public class JdbcClob
implements Clob {
    private String chars;

    public JdbcClob(String chars) {
        this.chars = chars;
    }

    @Override
    public long length() throws SQLException {
        this.ensureNotClosed();
        return this.chars.length();
    }

    @Override
    public String getSubString(long pos, int len) throws SQLException {
        this.ensureNotClosed();
        long zeroBasedPos = pos - 1L;
        if (zeroBasedPos < 0L || len < 0 || zeroBasedPos + (long)len > (long)this.chars.length()) {
            throw new SQLException("Invalid argument. Position should be greater than 0. Length should not be negative. Position + length should be less than CLOB size [pos=" + pos + ", length=" + len + "]");
        }
        return this.getSubStringInternal((int)zeroBasedPos, len);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.ensureNotClosed();
        return new StringReader(this.chars);
    }

    @Override
    public Reader getCharacterStream(long pos, long len) throws SQLException {
        return new StringReader(this.getSubString(pos, (int)len));
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.ensureNotClosed();
        return new Utf8EncodedStringInputStream(this.chars);
    }

    @Override
    public long position(String searchStr, long start) throws SQLException {
        this.ensureNotClosed();
        if (start < 1L) {
            throw new SQLException("Invalid argument. Start position should be greater than zero [start=" + start + "]");
        }
        long zeroBasedIdx = this.positionInternal(searchStr, start - 1L);
        return zeroBasedIdx == -1L ? -1L : zeroBasedIdx + 1L;
    }

    @Override
    public long position(Clob searchStr, long start) throws SQLException {
        return this.position(searchStr.getSubString(1L, (int)searchStr.length()), start);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        this.ensureNotClosed();
        long zeroBasedPos = pos - 1L;
        if (zeroBasedPos < 0L || str == null || zeroBasedPos > (long)this.chars.length()) {
            throw new SQLException("Invalid argument. Position should be greater than zero. Position should not exceed CLOB length+1. Source string should not be null [pos=" + pos + ", str=" + str + "]");
        }
        return this.setStringInternal((int)zeroBasedPos, str);
    }

    @Override
    public int setString(long pos, String str, int off, int len) throws SQLException {
        this.ensureNotClosed();
        long zeroBasedPos = pos - 1L;
        if (zeroBasedPos < 0L || str == null || zeroBasedPos > (long)this.chars.length() || off < 0 || len < 0 || off + len > str.length()) {
            throw new SQLException("Invalid argument. Position should be greater than zero. Position should not exceed CLOB length+1. Source string should not be null.  Offset and length shouldn't be negative. Offset + length should not exceed source string length [pos=" + pos + ", str=" + str + ", offset=" + off + ", len=" + len + "]");
        }
        return this.setStringInternal((int)zeroBasedPos, str, off, len);
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.ensureNotClosed();
        if (len < 0L || len > (long)this.chars.length()) {
            throw new SQLException("Invalid argument. Truncation length should not be negative. Truncation length should not exceed data length [len=" + len + "]");
        }
        this.chars = this.chars.substring(0, (int)len);
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void free() throws SQLException {
        this.chars = null;
    }

    private void ensureNotClosed() throws SQLException {
        if (this.chars == null) {
            throw new SQLException("Clob instance can't be used after free() has been called.");
        }
    }

    private String getSubStringInternal(int zeroBasedPos, int len) {
        return this.chars.substring(zeroBasedPos, zeroBasedPos + len);
    }

    private long positionInternal(String searchStr, long zeroBasedStart) {
        return this.chars.indexOf(searchStr, (int)zeroBasedStart);
    }

    private int setStringInternal(int zeroBasedPos, String str) {
        StringBuilder strBuilder = new StringBuilder(this.chars);
        if (zeroBasedPos + str.length() > this.chars.length()) {
            strBuilder.setLength(zeroBasedPos + str.length());
        }
        strBuilder.replace(zeroBasedPos, zeroBasedPos + str.length(), str);
        this.chars = strBuilder.toString();
        return str.length();
    }

    private int setStringInternal(int zeroBasedPos, String str, int off, int len) {
        StringBuilder strBuilder = new StringBuilder(this.chars);
        if (zeroBasedPos + str.length() > this.chars.length()) {
            strBuilder.setLength(zeroBasedPos + str.length());
        }
        String replaceStr = str.substring(off, off + len);
        strBuilder.replace(zeroBasedPos, zeroBasedPos + replaceStr.length(), replaceStr);
        this.chars = strBuilder.toString();
        return replaceStr.length();
    }

    private static class Utf8EncodedStringInputStream
    extends InputStream {
        private final String chars;
        private final int length;
        private int charsPos;
        private static final int DEFAULT_CHUNK_SIZE = 8192;
        private byte[] buf;
        private int bufPos;

        Utf8EncodedStringInputStream(String chars) {
            this.chars = chars;
            this.length = chars.length();
            this.charsPos = 0;
        }

        @Override
        public synchronized int read() {
            if (this.buf == null || this.buf.length == 0 || this.bufPos >= this.buf.length) {
                if (this.charsPos >= this.length) {
                    return -1;
                }
                this.bufPos = 0;
                this.encodeNextChunk();
            }
            return this.buf[this.bufPos++] & 0xFF;
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) {
            int i;
            int encodedChunkSize;
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException(String.format("Range [%s, %<s + %s) out of bounds for length %s", off, len, b.length));
            }
            if (len == 0) {
                return 0;
            }
            for (i = 0; i < len; i += encodedChunkSize) {
                if (this.buf == null || this.buf.length == 0 || this.bufPos >= this.buf.length) {
                    if (this.charsPos >= this.length) {
                        return i > 0 ? i : -1;
                    }
                    this.bufPos = 0;
                    this.encodeNextChunk();
                }
                encodedChunkSize = Math.min(len - i, this.buf.length - this.bufPos);
                U.arrayCopy(this.buf, this.bufPos, b, off + i, encodedChunkSize);
                this.bufPos += encodedChunkSize;
            }
            return i;
        }

        private void encodeNextChunk() {
            int remainingSize = this.chars.length() - this.charsPos;
            assert (remainingSize > 0);
            int chunkSize = remainingSize <= 8192 ? remainingSize : (Character.isHighSurrogate(this.chars.charAt(this.charsPos + 8192 - 1)) ? 8193 : 8192);
            String subs = this.chars.substring(this.charsPos, this.charsPos + chunkSize);
            this.buf = subs.getBytes(StandardCharsets.UTF_8);
            this.charsPos += chunkSize;
        }
    }
}

