/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.types;

import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.NumericInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.FloatIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.NumericIndexKey;
import org.apache.ignite.internal.pagemem.PageUtils;

public class FloatInlineIndexKeyType
extends NumericInlineIndexKeyType<FloatIndexKey> {
    public FloatInlineIndexKeyType() {
        super(IndexKeyType.FLOAT, (short)4);
    }

    @Override
    public int compare0(long pageAddr, int off, IndexKey key) {
        float val = Float.intBitsToFloat(PageUtils.getInt(pageAddr, off + 1));
        return -Integer.signum(((NumericIndexKey)key).compareTo(val));
    }

    @Override
    protected int put0(long pageAddr, int off, FloatIndexKey key, int maxSize) {
        PageUtils.putByte(pageAddr, off, (byte)this.type().code());
        PageUtils.putInt(pageAddr, off + 1, Float.floatToIntBits(((Float)key.key()).floatValue()));
        return this.keySize + 1;
    }

    @Override
    protected FloatIndexKey get0(long pageAddr, int off) {
        float key = Float.intBitsToFloat(PageUtils.getInt(pageAddr, off + 1));
        return new FloatIndexKey(key);
    }
}

