/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import java.util.Objects;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.raft.jraft.rpc.GetFileRequestBuilder;
import org.apache.ignite3.raft.jraft.rpc.GetFileRequestSerializer;
import org.apache.ignite3.raft.jraft.rpc.RpcRequests;

public class GetFileRequestImpl
implements RpcRequests.GetFileRequest,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 3010;
    @IgniteToStringInclude
    private final long count;
    @IgniteToStringInclude
    private final String filename;
    @IgniteToStringInclude
    private final long offset;
    @IgniteToStringInclude
    private final boolean readPartly;
    @IgniteToStringInclude
    private final long readerId;

    private GetFileRequestImpl(long count, String filename, long offset, boolean readPartly, long readerId) {
        this.count = count;
        this.filename = filename;
        this.offset = offset;
        this.readPartly = readPartly;
        this.readerId = readerId;
    }

    @Override
    public long count() {
        return this.count;
    }

    @Override
    public String filename() {
        return this.filename;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public boolean readPartly() {
        return this.readPartly;
    }

    @Override
    public long readerId() {
        return this.readerId;
    }

    public MessageSerializer serializer() {
        return GetFileRequestSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(GetFileRequestImpl.class, this);
    }

    @Override
    public short messageType() {
        return 3010;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GetFileRequestImpl otherMessage = (GetFileRequestImpl)other;
        return Objects.equals(this.filename, otherMessage.filename) && this.count == otherMessage.count && this.offset == otherMessage.offset && this.readPartly == otherMessage.readPartly && this.readerId == otherMessage.readerId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.count, this.offset, this.readPartly, this.readerId, this.filename);
        return result;
    }

    @Override
    public GetFileRequestImpl clone() {
        try {
            return (GetFileRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static GetFileRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements GetFileRequestBuilder {
        private long count;
        private String filename;
        private long offset;
        private boolean readPartly;
        private long readerId;

        private Builder() {
        }

        @Override
        public GetFileRequestBuilder count(long count) {
            this.count = count;
            return this;
        }

        @Override
        public GetFileRequestBuilder filename(String filename) {
            Objects.requireNonNull(filename, "filename is not marked @Nullable");
            this.filename = filename;
            return this;
        }

        @Override
        public GetFileRequestBuilder offset(long offset) {
            this.offset = offset;
            return this;
        }

        @Override
        public GetFileRequestBuilder readPartly(boolean readPartly) {
            this.readPartly = readPartly;
            return this;
        }

        @Override
        public GetFileRequestBuilder readerId(long readerId) {
            this.readerId = readerId;
            return this;
        }

        @Override
        public long count() {
            return this.count;
        }

        @Override
        public String filename() {
            return this.filename;
        }

        @Override
        public long offset() {
            return this.offset;
        }

        @Override
        public boolean readPartly() {
            return this.readPartly;
        }

        @Override
        public long readerId() {
            return this.readerId;
        }

        @Override
        public RpcRequests.GetFileRequest build() {
            return new GetFileRequestImpl(this.count, Objects.requireNonNull(this.filename, "filename is not marked @Nullable"), this.offset, this.readPartly, this.readerId);
        }
    }
}

