/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.rpc.AppendEntriesResponseBuilder;
import org.apache.ignite3.raft.jraft.rpc.RpcRequests;

class AppendEntriesResponseDeserializer
implements MessageDeserializer<RpcRequests.AppendEntriesResponse> {
    private final AppendEntriesResponseBuilder msg;

    AppendEntriesResponseDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.appendEntriesResponse();
    }

    @Override
    public Class<RpcRequests.AppendEntriesResponse> klass() {
        return RpcRequests.AppendEntriesResponse.class;
    }

    @Override
    public RpcRequests.AppendEntriesResponse getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readInt("errorCode");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.errorCode(tmp);
                reader.incrementState();
            }
            case 1: {
                String tmp = reader.readString("errorMsg");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.errorMsg(tmp);
                reader.incrementState();
            }
            case 2: {
                long tmp = reader.readLong("lastLogIndex");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.lastLogIndex(tmp);
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readString("leaderId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.leaderId((String)tmp);
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readBoxedLong("maxObservableSafeTimeViolatedValue");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.maxObservableSafeTimeViolatedValue((Long)tmp);
                reader.incrementState();
            }
            case 5: {
                boolean tmp = reader.readBoolean("success");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.success(tmp);
                reader.incrementState();
            }
            case 6: {
                long tmp = reader.readLong("term");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.term(tmp);
                reader.incrementState();
            }
            case 7: {
                HybridTimestamp tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.timestamp(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RpcRequests.AppendEntriesResponse.class);
    }
}

