/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.schema;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.ignite3.internal.sql.engine.schema.IgniteDataSource;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteSchema
extends AbstractSchema {
    private final String name;
    private final int catalogVersion;
    private final Map<String, IgniteDataSource> tableByName;
    private final Int2ObjectMap<IgniteDataSource> tableById;

    public IgniteSchema(String name, int catalogVersion, Collection<? extends IgniteDataSource> tables) {
        this.name = name;
        this.catalogVersion = catalogVersion;
        this.tableByName = tables.stream().collect(Collectors.toMap(IgniteDataSource::name, Function.identity()));
        this.tableById = tables.stream().collect(CollectionUtils.toIntMapCollector(IgniteDataSource::id, Function.identity()));
    }

    public String getName() {
        return this.name;
    }

    public int catalogVersion() {
        return this.catalogVersion;
    }

    protected Map<String, Table> getTableMap() {
        return Collections.unmodifiableMap(this.tableByName);
    }

    @Nullable
    IgniteTable tableByIdOpt(int tableId) {
        IgniteDataSource dataSource = (IgniteDataSource)this.tableById.get(tableId);
        if (!(dataSource instanceof IgniteTable)) {
            return null;
        }
        return (IgniteTable)dataSource;
    }
}

