/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.fsm;

import java.time.Instant;
import java.util.UUID;
import org.apache.ignite3.internal.sql.engine.SqlQueryType;
import org.apache.ignite3.internal.sql.engine.exec.fsm.ExecutionPhase;
import org.apache.ignite3.internal.sql.engine.exec.fsm.Query;
import org.apache.ignite3.internal.sql.engine.sql.ParsedResult;
import org.apache.ignite3.internal.sql.engine.tx.QueryTransactionWrapper;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class QueryInfo {
    private final UUID id;
    @Nullable
    private final UUID parentId;
    private final String schema;
    private final String sql;
    private final Instant startTime;
    private final ExecutionPhase phase;
    @Nullable
    private final SqlQueryType queryType;
    @Nullable
    private final UUID transactionId;
    private final int statementNum;
    private final boolean script;
    @Nullable
    private final Throwable error;

    QueryInfo(Query query) {
        this.id = query.id;
        this.parentId = query.parentId;
        this.statementNum = query.statementNum;
        this.schema = query.properties.defaultSchema();
        this.sql = query.sql;
        this.startTime = query.createdAt;
        this.phase = query.currentPhase();
        this.queryType = QueryInfo.deriveQueryType(query.parsedResult);
        this.transactionId = QueryInfo.deriveTxId(query);
        this.error = query.error.get();
        this.script = query.parsedScript != null;
    }

    @Nullable
    private static SqlQueryType deriveQueryType(@Nullable ParsedResult parsedResult) {
        return parsedResult == null ? null : parsedResult.queryType();
    }

    @Nullable
    private static UUID deriveTxId(Query query) {
        QueryTransactionWrapper explicit = query.txContext.explicitTx();
        if (explicit != null) {
            return explicit.unwrap().id();
        }
        QueryTransactionWrapper tx = query.usedTransaction;
        return tx != null ? tx.unwrap().id() : null;
    }

    public boolean script() {
        return this.script;
    }

    public UUID id() {
        return this.id;
    }

    @Nullable
    public UUID parentId() {
        return this.parentId;
    }

    public String schema() {
        return this.schema;
    }

    public String sql() {
        return this.sql;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public ExecutionPhase phase() {
        return this.phase;
    }

    @Nullable
    public SqlQueryType queryType() {
        return this.queryType;
    }

    @Nullable
    public UUID transactionId() {
        return this.transactionId;
    }

    public int statementNum() {
        return this.statementNum;
    }

    @Nullable
    public Throwable error() {
        return this.error;
    }

    public String toString() {
        return S.toString(this);
    }
}

