/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Error;
import org.apache.ignite3.internal.rest.api.Problem;
import org.apache.ignite3.internal.rest.constants.HttpCode;
import org.apache.ignite3.internal.rest.problem.HttpProblemResponse;

@Controller
public class GeneralErrorsController {
    @Error(status=HttpStatus.NOT_FOUND, global=true)
    public HttpResponse<? extends Problem> notFound(HttpRequest<?> request) {
        return HttpProblemResponse.from(Problem.fromHttpCode(HttpCode.NOT_FOUND).detail("Requested resource not found: " + request.getPath()));
    }

    @Error(status=HttpStatus.METHOD_NOT_ALLOWED, global=true)
    public HttpResponse<? extends Problem> methodNotAllowed(HttpRequest<?> request) {
        return HttpProblemResponse.from(Problem.fromHttpCode(HttpCode.METHOD_NOT_ALLOWED).detail("Method not allowed: " + request.getMethodName()));
    }

    @Error(status=HttpStatus.UNSUPPORTED_MEDIA_TYPE, global=true)
    public HttpResponse<? extends Problem> unsupportedMediaType(HttpRequest<?> request) {
        return HttpProblemResponse.from(Problem.fromHttpCode(HttpCode.UNSUPPORTED_MEDIA_TYPE).detail("Unsupported media type: " + (String)request.getContentType().map(MediaType::getName).orElse(null)));
    }

    @Error(status=HttpStatus.CONNECTION_TIMED_OUT, global=true)
    public HttpResponse<? extends Problem> connectionTimedOut(HttpRequest<?> request) {
        return HttpProblemResponse.from(Problem.fromHttpCode(HttpCode.CONNECTION_TIMED_OUT).detail("Connection timed out: " + request.getPath()));
    }
}

