/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.command;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.partition.replicator.network.command.BuildIndexCommand;
import org.apache.ignite3.internal.partition.replicator.network.command.BuildIndexCommandBuilder;
import org.apache.ignite3.internal.partition.replicator.network.command.BuildIndexCommandSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class BuildIndexCommandImpl
implements BuildIndexCommand,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 44;
    @IgniteToStringInclude
    private final boolean finish;
    @IgniteToStringInclude
    private final int indexId;
    @IgniteToStringInclude
    private int requiredCatalogVersion;
    @IgniteToStringInclude
    private final List<UUID> rowIds;

    private BuildIndexCommandImpl(boolean finish, int indexId, int requiredCatalogVersion, List<UUID> rowIds) {
        this.finish = finish;
        this.indexId = indexId;
        this.requiredCatalogVersion = requiredCatalogVersion;
        this.rowIds = rowIds;
    }

    @Override
    public boolean finish() {
        return this.finish;
    }

    @Override
    public int indexId() {
        return this.indexId;
    }

    @Override
    public void requiredCatalogVersion(int requiredCatalogVersion) {
        this.requiredCatalogVersion = requiredCatalogVersion;
    }

    @Override
    public int requiredCatalogVersion() {
        return this.requiredCatalogVersion;
    }

    @Override
    public List<UUID> rowIds() {
        return this.rowIds;
    }

    public MessageSerializer serializer() {
        return BuildIndexCommandSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(BuildIndexCommandImpl.class, this);
    }

    @Override
    public short messageType() {
        return 44;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BuildIndexCommandImpl otherMessage = (BuildIndexCommandImpl)other;
        return Objects.equals(this.rowIds, otherMessage.rowIds) && this.finish == otherMessage.finish && this.indexId == otherMessage.indexId && this.requiredCatalogVersion == otherMessage.requiredCatalogVersion;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.finish, this.indexId, this.requiredCatalogVersion, this.rowIds);
        return result;
    }

    @Override
    public BuildIndexCommandImpl clone() {
        try {
            return (BuildIndexCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static BuildIndexCommandBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements BuildIndexCommandBuilder {
        private boolean finish;
        private int indexId;
        private int requiredCatalogVersion;
        private List<UUID> rowIds;

        private Builder() {
        }

        @Override
        public BuildIndexCommandBuilder finish(boolean finish) {
            this.finish = finish;
            return this;
        }

        @Override
        public BuildIndexCommandBuilder indexId(int indexId) {
            this.indexId = indexId;
            return this;
        }

        @Override
        public BuildIndexCommandBuilder requiredCatalogVersion(int requiredCatalogVersion) {
            this.requiredCatalogVersion = requiredCatalogVersion;
            return this;
        }

        @Override
        public BuildIndexCommandBuilder rowIds(List<UUID> rowIds) {
            Objects.requireNonNull(rowIds, "rowIds is not marked @Nullable");
            this.rowIds = rowIds;
            return this;
        }

        @Override
        public boolean finish() {
            return this.finish;
        }

        @Override
        public int indexId() {
            return this.indexId;
        }

        @Override
        public int requiredCatalogVersion() {
            return this.requiredCatalogVersion;
        }

        @Override
        public List<UUID> rowIds() {
            return this.rowIds;
        }

        @Override
        public BuildIndexCommand build() {
            return new BuildIndexCommandImpl(this.finish, this.indexId, this.requiredCatalogVersion, Objects.requireNonNull(this.rowIds, "rowIds is not marked @Nullable"));
        }
    }
}

