/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.serialization.marshal;

import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import org.apache.ignite3.internal.network.serialization.ClassDescriptor;
import org.apache.ignite3.internal.network.serialization.FieldDescriptor;
import org.apache.ignite3.internal.network.serialization.marshal.ProtocolMarshalling;
import org.jetbrains.annotations.Nullable;

abstract class NullsBitsetWriter {
    NullsBitsetWriter() {
    }

    @Nullable
    BitSet writeNullsBitSet(Object object, ClassDescriptor descriptor, DataOutput output) throws IOException {
        if (descriptor.fieldIndexInNullsBitmapSize() == 0) {
            return null;
        }
        BitSet nullsBitSet = new BitSet(descriptor.fieldIndexInNullsBitmapSize());
        for (FieldDescriptor fieldDescriptor : descriptor.fields()) {
            Object fieldValue;
            int indexInBitmap = descriptor.fieldIndexInNullsBitmap(fieldDescriptor.name());
            if (indexInBitmap < 0 || (fieldValue = this.getFieldValue(object, fieldDescriptor)) != null) continue;
            nullsBitSet.set(indexInBitmap);
        }
        ProtocolMarshalling.writeFixedLengthBitSet(nullsBitSet, descriptor.fieldIndexInNullsBitmapSize(), output);
        return nullsBitSet;
    }

    abstract Object getFieldValue(Object var1, FieldDescriptor var2);
}

