/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogValidationException;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.descriptors.CatalogHashIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSortedIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.tostring.S;

public class RenameIndexEntry
implements UpdateEntry {
    private final int indexId;
    private final String newIndexName;

    public RenameIndexEntry(int indexId, String newIndexName) {
        this.indexId = indexId;
        this.newIndexName = newIndexName;
    }

    public int indexId() {
        return this.indexId;
    }

    public String newIndexName() {
        return this.newIndexName;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.RENAME_INDEX.id();
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, HybridTimestamp timestamp) {
        CatalogIndexDescriptor indexDescriptor = CatalogUtils.indexOrThrow(catalog, this.indexId);
        CatalogTableDescriptor tableDescriptor = CatalogUtils.tableOrThrow(catalog, indexDescriptor.tableId());
        CatalogSchemaDescriptor schemaDescriptor = CatalogUtils.schemaOrThrow(catalog, tableDescriptor.schemaId());
        CatalogIndexDescriptor newIndexDescriptor = this.changeIndexName(indexDescriptor, timestamp);
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), CatalogUtils.replaceSchema(CatalogUtils.replaceIndex(schemaDescriptor, newIndexDescriptor), catalog.schemas()), CatalogUtils.defaultZoneIdOpt(catalog));
    }

    private CatalogIndexDescriptor changeIndexName(CatalogIndexDescriptor indexDescriptor, HybridTimestamp timestamp) {
        CatalogIndexDescriptor newIndexDescriptor;
        if (indexDescriptor instanceof CatalogHashIndexDescriptor) {
            newIndexDescriptor = this.changeHashIndexName((CatalogHashIndexDescriptor)indexDescriptor);
        } else if (indexDescriptor instanceof CatalogSortedIndexDescriptor) {
            newIndexDescriptor = this.changeSortedIndexName((CatalogSortedIndexDescriptor)indexDescriptor);
        } else {
            throw new CatalogValidationException("Unsupported index type '{}' {}", indexDescriptor.id(), indexDescriptor);
        }
        newIndexDescriptor.updateTimestamp(timestamp);
        return newIndexDescriptor;
    }

    private CatalogIndexDescriptor changeHashIndexName(CatalogHashIndexDescriptor index) {
        return new CatalogHashIndexDescriptor(index.id(), this.newIndexName, index.tableId(), index.unique(), index.status(), index.columns(), index.isCreatedWithTable());
    }

    private CatalogIndexDescriptor changeSortedIndexName(CatalogSortedIndexDescriptor index) {
        return new CatalogSortedIndexDescriptor(index.id(), this.newIndexName, index.tableId(), index.unique(), index.status(), index.columns(), index.isCreatedWithTable());
    }

    public String toString() {
        return S.toString(this);
    }
}

