/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.descriptors;

import java.io.IOException;
import java.util.List;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableSchemaVersions;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializationUtils;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;

public class CatalogTableVersionSerializers {

    @CatalogSerializer(version=2, since="3.1.0")
    static class TableVersionSerializerV2
    implements CatalogObjectSerializer<CatalogTableSchemaVersions.TableVersion> {
        TableVersionSerializerV2() {
        }

        @Override
        public CatalogTableSchemaVersions.TableVersion readFrom(CatalogObjectDataInput input) throws IOException {
            List<CatalogTableColumnDescriptor> columns = input.readEntryList(CatalogTableColumnDescriptor.class);
            return new CatalogTableSchemaVersions.TableVersion(columns);
        }

        @Override
        public void writeTo(CatalogTableSchemaVersions.TableVersion tableVersion, CatalogObjectDataOutput output) throws IOException {
            output.writeEntryList(tableVersion.columns());
        }
    }

    @CatalogSerializer(version=1, since="3.0.0")
    static class TableVersionSerializerV1
    implements CatalogObjectSerializer<CatalogTableSchemaVersions.TableVersion> {
        private final CatalogEntrySerializerProvider serializers;

        public TableVersionSerializerV1(CatalogEntrySerializerProvider serializers) {
            this.serializers = serializers;
        }

        @Override
        public CatalogTableSchemaVersions.TableVersion readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogObjectSerializer serializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_TABLE_COLUMN.id());
            List<CatalogTableColumnDescriptor> columns = CatalogSerializationUtils.readList(serializer, input);
            return new CatalogTableSchemaVersions.TableVersion(columns);
        }

        @Override
        public void writeTo(CatalogTableSchemaVersions.TableVersion tableVersion, CatalogObjectDataOutput output) throws IOException {
            CatalogObjectSerializer serializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_TABLE_COLUMN.id());
            CatalogSerializationUtils.writeList(tableVersion.columns(), serializer, output);
        }
    }
}

