/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.descriptors;

import java.util.List;
import java.util.Objects;
import org.apache.ignite3.internal.catalog.CatalogManager;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexColumnDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.tostring.S;

public class CatalogSortedIndexDescriptor
extends CatalogIndexDescriptor {
    private final List<CatalogIndexColumnDescriptor> columns;

    public CatalogSortedIndexDescriptor(int id, String name, int tableId, boolean unique, List<CatalogIndexColumnDescriptor> columns) {
        this(id, name, tableId, unique, CatalogIndexStatus.REGISTERED, columns, false);
    }

    public CatalogSortedIndexDescriptor(int id, String name, int tableId, boolean unique, CatalogIndexStatus status, List<CatalogIndexColumnDescriptor> columns, boolean isCreatedWithTable) {
        this(id, name, tableId, unique, status, columns, CatalogManager.INITIAL_TIMESTAMP, isCreatedWithTable);
    }

    CatalogSortedIndexDescriptor(int id, String name, int tableId, boolean unique, CatalogIndexStatus status, List<CatalogIndexColumnDescriptor> columns, HybridTimestamp timestamp, boolean isCreatedWithTable) {
        super(CatalogIndexDescriptor.CatalogIndexDescriptorType.SORTED, id, name, tableId, unique, status, timestamp, isCreatedWithTable);
        this.columns = Objects.requireNonNull(columns, "columns");
    }

    public List<CatalogIndexColumnDescriptor> columns() {
        return this.columns;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DESCRIPTOR_SORTED_INDEX.id();
    }

    @Override
    public String toString() {
        return S.toString(CatalogSortedIndexDescriptor.class, this, super.toString());
    }
}

