/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.proto;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.client.proto.ColumnTypeConverter;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.NativeTypeSpec;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.MarshallerException;
import org.apache.ignite.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public class ClientBinaryTupleUtils {
    @Nullable
    public static Object readObject(BinaryTupleReader reader, int index) {
        if (reader.hasNullValue(index)) {
            return null;
        }
        int typeId = reader.intValue(index);
        ColumnType type = ColumnTypeConverter.fromIdOrThrow(typeId);
        int valIdx = index + 2;
        switch (type) {
            case INT8: {
                return reader.byteValue(valIdx);
            }
            case INT16: {
                return reader.shortValue(valIdx);
            }
            case INT32: {
                return reader.intValue(valIdx);
            }
            case INT64: {
                return reader.longValue(valIdx);
            }
            case FLOAT: {
                return Float.valueOf(reader.floatValue(valIdx));
            }
            case DOUBLE: {
                return reader.doubleValue(valIdx);
            }
            case DECIMAL: {
                return reader.decimalValue(valIdx, reader.intValue(index + 1));
            }
            case UUID: {
                return reader.uuidValue(valIdx);
            }
            case STRING: {
                return reader.stringValue(valIdx);
            }
            case BYTE_ARRAY: {
                return reader.bytesValue(valIdx);
            }
            case DATE: {
                return reader.dateValue(valIdx);
            }
            case TIME: {
                return reader.timeValue(valIdx);
            }
            case DATETIME: {
                return reader.dateTimeValue(valIdx);
            }
            case TIMESTAMP: {
                return reader.timestampValue(valIdx);
            }
            case BOOLEAN: {
                return reader.byteValue(valIdx) != 0;
            }
            case DURATION: {
                return reader.durationValue(valIdx);
            }
            case PERIOD: {
                return reader.periodValue(valIdx);
            }
        }
        throw ClientBinaryTupleUtils.unsupportedTypeException(typeId);
    }

    private static Function<Integer, Object> readerForType(BinaryTupleReader binTuple, ColumnType type) {
        switch (type) {
            case INT8: {
                return arg_0 -> ((BinaryTupleReader)binTuple).byteValue(arg_0);
            }
            case INT16: {
                return arg_0 -> ((BinaryTupleReader)binTuple).shortValue(arg_0);
            }
            case INT32: {
                return arg_0 -> ((BinaryTupleReader)binTuple).intValue(arg_0);
            }
            case INT64: {
                return arg_0 -> ((BinaryTupleReader)binTuple).longValue(arg_0);
            }
            case FLOAT: {
                return arg_0 -> ((BinaryTupleReader)binTuple).floatValue(arg_0);
            }
            case DOUBLE: {
                return arg_0 -> ((BinaryTupleReader)binTuple).doubleValue(arg_0);
            }
            case DECIMAL: {
                return idx -> binTuple.decimalValue(idx.intValue(), -1);
            }
            case UUID: {
                return arg_0 -> ((BinaryTupleReader)binTuple).uuidValue(arg_0);
            }
            case STRING: {
                return arg_0 -> ((BinaryTupleReader)binTuple).stringValue(arg_0);
            }
            case BYTE_ARRAY: {
                return arg_0 -> ((BinaryTupleReader)binTuple).bytesValue(arg_0);
            }
            case DATE: {
                return arg_0 -> ((BinaryTupleReader)binTuple).dateValue(arg_0);
            }
            case TIME: {
                return arg_0 -> ((BinaryTupleReader)binTuple).timeValue(arg_0);
            }
            case DATETIME: {
                return arg_0 -> ((BinaryTupleReader)binTuple).dateTimeValue(arg_0);
            }
            case TIMESTAMP: {
                return arg_0 -> ((BinaryTupleReader)binTuple).timestampValue(arg_0);
            }
            case BOOLEAN: {
                return idx -> binTuple.byteValue(idx.intValue()) != 0;
            }
            case DURATION: {
                return arg_0 -> ((BinaryTupleReader)binTuple).durationValue(arg_0);
            }
            case PERIOD: {
                return arg_0 -> ((BinaryTupleReader)binTuple).periodValue(arg_0);
            }
        }
        throw ClientBinaryTupleUtils.unsupportedTypeException(type.id());
    }

    public static <T> void appendObject(BinaryTupleBuilder builder, @Nullable T obj) {
        if (obj == null) {
            builder.appendNull();
            builder.appendNull();
            builder.appendNull();
        } else if (obj instanceof Boolean) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.BOOLEAN);
            builder.appendBoolean((Boolean)obj);
        } else if (obj instanceof Byte) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.INT8);
            builder.appendByte((Byte)obj);
        } else if (obj instanceof Short) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.INT16);
            builder.appendShort((Short)obj);
        } else if (obj instanceof Integer) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.INT32);
            builder.appendInt((Integer)obj);
        } else if (obj instanceof Long) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.INT64);
            builder.appendLong((Long)obj);
        } else if (obj instanceof Float) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.FLOAT);
            builder.appendFloat((Float)obj);
        } else if (obj instanceof Double) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.DOUBLE);
            builder.appendDouble((Double)obj);
        } else if (obj instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)obj;
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.DECIMAL, bigDecimal.scale());
            builder.appendDecimal(bigDecimal, bigDecimal.scale());
        } else if (obj instanceof UUID) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.UUID);
            builder.appendUuid((UUID)obj);
        } else if (obj instanceof String) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.STRING);
            builder.appendString((String)obj);
        } else if (obj instanceof byte[]) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.BYTE_ARRAY);
            builder.appendBytes((byte[])obj);
        } else if (obj instanceof LocalDate) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.DATE);
            builder.appendDate((LocalDate)obj);
        } else if (obj instanceof LocalTime) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.TIME);
            builder.appendTime((LocalTime)obj);
        } else if (obj instanceof LocalDateTime) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.DATETIME);
            builder.appendDateTime((LocalDateTime)obj);
        } else if (obj instanceof Instant) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.TIMESTAMP);
            builder.appendTimestamp((Instant)obj);
        } else if (obj instanceof Duration) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.DURATION);
            builder.appendDuration((Duration)obj);
        } else if (obj instanceof Period) {
            ClientBinaryTupleUtils.appendTypeAndScale(builder, ColumnType.PERIOD);
            builder.appendPeriod((Period)obj);
        } else {
            throw ClientBinaryTupleUtils.unsupportedTypeException(obj.getClass());
        }
    }

    static <T> void appendCollectionToBinaryTuple(BinaryTupleBuilder builder, Collection<T> items) {
        assert (items != null) : "items can't be null";
        assert (!items.isEmpty()) : "items can't be empty";
        assert (builder != null) : "builder can't be null";
        T firstItem = items.iterator().next();
        Objects.requireNonNull(firstItem);
        Class<?> type = firstItem.getClass();
        Consumer<T> appender = ClientBinaryTupleUtils.appendTypeAndGetAppender(builder, firstItem);
        builder.appendInt(items.size());
        for (T item : items) {
            Objects.requireNonNull(item);
            if (!type.equals(item.getClass())) {
                throw new IllegalArgumentException("All items must have the same type. First item: " + String.valueOf(type) + ", current item: " + String.valueOf(item.getClass()));
            }
            appender.accept(item);
        }
    }

    static <R> List<R> readCollectionFromBinaryTuple(BinaryTupleReader reader, int readerIndex) {
        int typeId = reader.intValue(readerIndex++);
        ColumnType type = ColumnTypeConverter.fromIdOrThrow(typeId);
        Function<Integer, Object> itemReader = ClientBinaryTupleUtils.readerForType(reader, type);
        int itemsCount = reader.intValue(readerIndex++);
        ArrayList<Object> items = new ArrayList<Object>(itemsCount);
        for (int i = 0; i < itemsCount; ++i) {
            items.add(itemReader.apply(readerIndex++));
        }
        return items;
    }

    private static <T> Consumer<T> appendTypeAndGetAppender(BinaryTupleBuilder builder, Object obj) {
        assert (obj != null) : "Object is null";
        if (obj instanceof Boolean) {
            builder.appendInt(ColumnType.BOOLEAN.id());
            return v -> builder.appendBoolean((Boolean)v);
        }
        if (obj instanceof Byte) {
            builder.appendInt(ColumnType.INT8.id());
            return v -> builder.appendByte((Byte)v);
        }
        if (obj instanceof Short) {
            builder.appendInt(ColumnType.INT16.id());
            return v -> builder.appendShort((Short)v);
        }
        if (obj instanceof Integer) {
            builder.appendInt(ColumnType.INT32.id());
            return v -> builder.appendInt((Integer)v);
        }
        if (obj instanceof Long) {
            builder.appendInt(ColumnType.INT64.id());
            return v -> builder.appendLong((Long)v);
        }
        if (obj instanceof Float) {
            builder.appendInt(ColumnType.FLOAT.id());
            return v -> builder.appendFloat((Float)v);
        }
        if (obj instanceof Double) {
            builder.appendInt(ColumnType.DOUBLE.id());
            return v -> builder.appendDouble((Double)v);
        }
        if (obj instanceof BigDecimal) {
            builder.appendInt(ColumnType.DECIMAL.id());
            return v -> builder.appendDecimal((BigDecimal)v, ((BigDecimal)v).scale());
        }
        if (obj instanceof UUID) {
            builder.appendInt(ColumnType.UUID.id());
            return v -> builder.appendUuid((UUID)v);
        }
        if (obj instanceof String) {
            builder.appendInt(ColumnType.STRING.id());
            return v -> builder.appendString((String)v);
        }
        if (obj instanceof byte[]) {
            builder.appendInt(ColumnType.BYTE_ARRAY.id());
            return v -> builder.appendBytes((byte[])v);
        }
        if (obj instanceof LocalDate) {
            builder.appendInt(ColumnType.DATE.id());
            return v -> builder.appendDate((LocalDate)v);
        }
        if (obj instanceof LocalTime) {
            builder.appendInt(ColumnType.TIME.id());
            return v -> builder.appendTime((LocalTime)v);
        }
        if (obj instanceof LocalDateTime) {
            builder.appendInt(ColumnType.DATETIME.id());
            return v -> builder.appendDateTime((LocalDateTime)v);
        }
        if (obj instanceof Instant) {
            builder.appendInt(ColumnType.TIMESTAMP.id());
            return v -> builder.appendTimestamp((Instant)v);
        }
        if (obj instanceof Duration) {
            builder.appendInt(ColumnType.DURATION.id());
            return v -> builder.appendDuration((Duration)v);
        }
        if (obj instanceof Period) {
            builder.appendInt(ColumnType.PERIOD.id());
            return v -> builder.appendPeriod((Period)v);
        }
        throw ClientBinaryTupleUtils.unsupportedTypeException(obj.getClass());
    }

    public static void appendValue(BinaryTupleBuilder builder, ColumnType type, String name, int scale, @Nullable Object v) {
        if (v == null) {
            builder.appendNull();
            return;
        }
        try {
            switch (type) {
                case BOOLEAN: {
                    builder.appendBoolean(((Boolean)v).booleanValue());
                    return;
                }
                case INT8: {
                    builder.appendByte(((Byte)v).byteValue());
                    return;
                }
                case INT16: {
                    builder.appendShort(((Short)v).shortValue());
                    return;
                }
                case INT32: {
                    builder.appendInt(((Integer)v).intValue());
                    return;
                }
                case INT64: {
                    builder.appendLong(((Long)v).longValue());
                    return;
                }
                case FLOAT: {
                    builder.appendFloat(((Float)v).floatValue());
                    return;
                }
                case DOUBLE: {
                    builder.appendDouble(((Double)v).doubleValue());
                    return;
                }
                case DECIMAL: {
                    builder.appendDecimalNotNull((BigDecimal)v, scale);
                    return;
                }
                case UUID: {
                    builder.appendUuidNotNull((UUID)v);
                    return;
                }
                case STRING: {
                    builder.appendStringNotNull((String)v);
                    return;
                }
                case BYTE_ARRAY: {
                    builder.appendBytesNotNull((byte[])v);
                    return;
                }
                case DATE: {
                    builder.appendDateNotNull((LocalDate)v);
                    return;
                }
                case TIME: {
                    builder.appendTimeNotNull((LocalTime)v);
                    return;
                }
                case DATETIME: {
                    builder.appendDateTimeNotNull((LocalDateTime)v);
                    return;
                }
                case TIMESTAMP: {
                    builder.appendTimestampNotNull((Instant)v);
                    return;
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
        }
        catch (ClassCastException e) {
            NativeType nativeType = NativeTypes.fromObject((Object)v);
            if (nativeType == null) {
                throw new MarshallerException(UUID.randomUUID(), ErrorGroups.Marshalling.COMMON_ERR, String.format("Invalid value type provided for column [name='%s', expected='%s', actual='%s']", name, type.javaClass().getName(), v.getClass().getName()), (Throwable)e);
            }
            NativeTypeSpec actualType = nativeType.spec();
            NativeTypeSpec expectedType = NativeTypeSpec.fromColumnType((ColumnType)type);
            String error = IgniteStringFormatter.format((String)"Value type does not match [column='{}', expected={}, actual={}]", (Object[])new Object[]{name, expectedType.name(), actualType.name()});
            throw new IgniteException(ErrorGroups.Client.PROTOCOL_ERR, error, (Throwable)e);
        }
    }

    private static void appendTypeAndScale(BinaryTupleBuilder builder, ColumnType type, int scale) {
        builder.appendInt(type.id());
        builder.appendInt(scale);
    }

    private static void appendTypeAndScale(BinaryTupleBuilder builder, ColumnType type) {
        builder.appendInt(type.id());
        builder.appendInt(0);
    }

    private static IgniteException unsupportedTypeException(int dataType) {
        return new IgniteException(ErrorGroups.Client.PROTOCOL_ERR, "Unsupported type: " + dataType);
    }

    private static IgniteException unsupportedTypeException(Class<?> cls) {
        return new IgniteException(ErrorGroups.Client.PROTOCOL_ERR, "Unsupported type: " + String.valueOf(cls));
    }
}

