<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

# OSGi

The driver is available as an [OSGi] bundle. More specifically, 
the following Maven artifacts are actually valid OSGi bundles:

- `driver-core`
- `driver-mapping`
- `driver-extras`

## Including the driver in your OSGi application

We have complete examples demonstrating usage of the driver in an OSGi
environment; please refer to our [OSGi examples repository].

[OSGi examples repository]:https://github.com/apache/cassandra-java-driver-examples-osgi

## Troubleshooting OSGi applications

Please read our [OSGi-specific FAQ section](../../faq/osgi/) to find tips
for troubleshooting OSGi applications.

[OSGi]:https://www.osgi.org
