/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

namespace Apache.NMS.ActiveMQ.Commands
{
    public class ActiveMQBlobMessage : ActiveMQMessage
    {
        public const byte ID_ACTIVEMQBLOBMESSAGE = 29;

        public override byte GetDataStructureType()
        {
            return ID_ACTIVEMQBLOBMESSAGE;
        }

        public string RemoteBlobUrl
        {
            get { return ""; }
            set {}
        }

        public string MimeType
        {
            get { return ""; }
            set {}
        }

        public string Name
        {
            get { return ""; }
            set {}
        }

        public bool DeletedByBroker
        {
            get { return false; }
            set {}
        }

    }
}

