/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Edge;
import att.grappa.Element;
import att.grappa.Graph;
import att.grappa.GraphIterator;
import att.grappa.Grappa;
import att.grappa.GrappaBox;
import att.grappa.GrappaConstants;
import att.grappa.GrappaNexus;
import att.grappa.GrappaPanel;
import att.grappa.Node;
import att.grappa.Parser;
import att.grappa.Subgraph;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JViewport;

public abstract class GrappaSupport
implements GrappaConstants {
    private static final short CN = 1;
    private static final short WS = 2;
    private static final short SP = 4;
    private static final short PU = 8;
    private static final short DG = 16;
    private static final short OD = 32;
    private static final short UC = 64;
    private static final short HD = 128;
    private static final short LC = 256;
    private static final short[] ctype = new short[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 48, 48, 48, 48, 48, 48, 48, 48, 16, 16, 8, 8, 8, 8, 8, 8, 8, 192, 192, 192, 192, 192, 192, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 8, 8, 8, 8, 8, 8, 384, 384, 384, 384, 384, 384, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 8, 8, 8, 8, 1};
    private static final short ALPHA = 320;
    private static final short ALNUM = 336;
    private static final short GRAPH = 344;
    private static final short PRINT = 348;
    private static final short ODIGIT = 32;
    private static final short XDIGIT = 144;
    private static final short LOWERTOUPPER = -32;
    private static final short UPPERTOLOWER = 32;

    static boolean isalnum(int ch) {
        return GrappaSupport.isascii(ch) && (ctype[ch] & 0x150) != 0;
    }

    static boolean isalpha(int ch) {
        return GrappaSupport.isascii(ch) && (ctype[ch] & 0x140) != 0;
    }

    static boolean isascii(int ch) {
        return ch >= 0 && ch < 128;
    }

    static boolean iscntrl(int ch) {
        return GrappaSupport.isascii(ch) && (ctype[ch] & 1) != 0;
    }

    static boolean isdigit(int ch) {
        return GrappaSupport.isascii(ch) && (ctype[ch] & 0x10) != 0;
    }

    static boolean isgraph(int ch) {
        return GrappaSupport.isascii(ch) && (ctype[ch] & 0x10) != 0;
    }

    static boolean islower(int ch) {
        return GrappaSupport.isascii(ch) && (ctype[ch] & 0x100) != 0;
    }

    static boolean isoctal(int ch) {
        return GrappaSupport.isascii(ch) && (ctype[ch] & 0x20) != 0;
    }

    static boolean isprint(int ch) {
        return GrappaSupport.isascii(ch) && (ctype[ch] & 0x15C) != 0;
    }

    static boolean ispunct(int ch) {
        return GrappaSupport.isascii(ch) && (ctype[ch] & 8) != 0;
    }

    static boolean isspace(int ch) {
        return GrappaSupport.isascii(ch) && (ctype[ch] & 2) != 0;
    }

    static boolean isupper(int ch) {
        return GrappaSupport.isascii(ch) && (ctype[ch] & 0x40) != 0;
    }

    static boolean isxdigit(int ch) {
        return GrappaSupport.isascii(ch) && (ctype[ch] & 0x90) != 0;
    }

    static int tolower(int ch) {
        return GrappaSupport.isupper(ch) ? ch + 32 : ch;
    }

    static int toupper(int ch) {
        return GrappaSupport.islower(ch) ? ch + -32 : ch;
    }

    static String[] strsplit(String tuple) throws IllegalArgumentException {
        if (tuple == null) {
            throw new IllegalArgumentException("supplied split string is null");
        }
        StringTokenizer st = new StringTokenizer(tuple, ",", false);
        String[] array = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            array[i++] = st.nextToken();
        }
        return array;
    }

    static float[] floatArrayForTuple(String tuple) throws IllegalArgumentException, NumberFormatException {
        if (tuple == null) {
            throw new IllegalArgumentException("supplied tuple string is null");
        }
        StringTokenizer st = new StringTokenizer(tuple, ", \t", false);
        float[] array = new float[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            array[i++] = Float.valueOf(st.nextToken()).floatValue();
        }
        return array;
    }

    static double[] arrayForTuple(String tuple) throws IllegalArgumentException, NumberFormatException {
        if (tuple == null) {
            throw new IllegalArgumentException("supplied tuple string is null");
        }
        StringTokenizer st = new StringTokenizer(tuple, ", \t", false);
        double[] array = new double[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            array[i++] = Double.valueOf(st.nextToken());
        }
        return array;
    }

    public static int xlateDirString(String direction) {
        if (direction != null) {
            String dir = GrappaSupport.canonize(direction);
            if (dir.equals("forward")) {
                return 2;
            }
            if (dir.equals("back")) {
                return 1;
            }
            if (dir.equals("both")) {
                return 3;
            }
        }
        return 0;
    }

    public static String xlateDir(int direction) {
        String retstr = null;
        retstr = direction == 2 ? "forward" : (direction == 1 ? "back" : (direction == 3 ? "both" : "none"));
        return retstr;
    }

    public static int xlateFontStyleString(String fontstyle) {
        if (fontstyle != null) {
            String style = GrappaSupport.canonize(fontstyle);
            if (style.equals("italic")) {
                return 2;
            }
            if (style.equals("bold")) {
                return 1;
            }
            if (style.equals("bolditalic")) {
                return 3;
            }
        }
        return 0;
    }

    public static String xlateFontStyle(int fontstyle) {
        String retstr = null;
        retstr = fontstyle == 2 ? "italic" : (fontstyle == 1 ? "bold" : (fontstyle == 3 ? "bolditalic" : "normal"));
        return retstr;
    }

    public static String canonize(String input) {
        if (input == null) {
            return null;
        }
        char[] array = input.toCharArray();
        int pos = 0;
        for (int i = 0; i < array.length; ++i) {
            if (!Character.isLetterOrDigit(array[i])) continue;
            array[pos++] = Character.toLowerCase(array[i]);
        }
        if (pos == 0) {
            return "";
        }
        return new String(array, 0, pos);
    }

    public static GrappaBox boxFromCorners(double x1, double y1, double x2, double y2) {
        return GrappaSupport.boxFromCorners(null, x1, y1, x2, y2);
    }

    public static GrappaBox boxFromCorners(GrappaBox box, double x1, double y1, double x2, double y2) {
        if (box == null) {
            box = new GrappaBox();
        }
        box.x = x1 < x2 ? x1 : x2;
        box.y = y1 < y2 ? y1 : y2;
        box.width = x1 < x2 ? x2 - x1 : x1 - x2;
        box.height = y1 < y2 ? y2 - y1 : y1 - y2;
        return box;
    }

    public static Element findContainingElement(Subgraph subg, Point2D pt) {
        Element elem = null;
        Rectangle2D bb = subg.getBoundingBox();
        GrappaNexus grappaNexus = null;
        if (bb.contains(pt)) {
            elem = subg;
            Element subelem = null;
            Iterator<Element> enm = subg.subgraphElements();
            while (enm.hasNext()) {
                subelem = GrappaSupport.findContainingElement(enm.next(), pt);
                if (subelem == null) continue;
                elem = subelem;
            }
            enm = subg.edgeElements();
            while (enm.hasNext()) {
                Edge edge = (Edge)enm.next();
                grappaNexus = edge.grappaNexus;
                if (grappaNexus == null || !grappaNexus.rawBounds2D().contains(pt) || !grappaNexus.contains(pt)) continue;
                elem = edge;
            }
            enm = subg.nodeElements();
            while (enm.hasNext()) {
                Node node = (Node)enm.next();
                grappaNexus = node.grappaNexus;
                if (grappaNexus == null || !grappaNexus.rawBounds2D().contains(pt) || !grappaNexus.contains(pt)) continue;
                elem = node;
            }
        }
        return elem;
    }

    public static List findContainedElements(Subgraph subg, GrappaBox box) {
        ArrayList<Element> elems = null;
        Rectangle2D bb = subg.getBoundingBox();
        GrappaNexus grappaNexus = null;
        if (box.contains(bb)) {
            return subg.listOfElements(7);
        }
        if (box.intersects(bb)) {
            List subelems = null;
            Iterator<Subgraph> enm = subg.subgraphElements();
            while (enm.hasNext()) {
                subelems = GrappaSupport.findContainedElements(enm.next(), box);
                if (subelems == null) continue;
                if (elems == null) {
                    elems = new ArrayList<Element>();
                }
                elems.add((Element)((Object)subelems));
            }
            Iterator<Edge> enmg = subg.edgeElements();
            while (enmg.hasNext()) {
                Edge edge = enmg.next();
                grappaNexus = edge.grappaNexus;
                if (grappaNexus == null || !box.contains(grappaNexus.rawBounds2D())) continue;
                if (elems == null) {
                    elems = new ArrayList();
                }
                elems.add(edge);
            }
            Iterator<Node> enmn = subg.nodeElements();
            while (enmn.hasNext()) {
                Node node = enmn.next();
                grappaNexus = node.grappaNexus;
                if (grappaNexus == null || !box.contains(grappaNexus.rawBounds2D())) continue;
                if (elems == null) {
                    elems = new ArrayList();
                }
                elems.add(node);
            }
        }
        return elems;
    }

    public static void setHighlight(Element elem, int mode, int setting) {
        block16: {
            block15: {
                block17: {
                    if (elem == null) {
                        return;
                    }
                    if (mode != 0) break block15;
                    boolean wasDelete = (elem.highlight & 2) == 2;
                    elem.highlight = 0;
                    if (!wasDelete) break block16;
                    if (!elem.isNode()) break block17;
                    Node.Iterator<Edge> enm = ((Node)elem).edgeElements();
                    while (enm.hasNext()) {
                        ((Element)enm.next()).highlight = 0;
                    }
                    break block16;
                }
                if (!elem.isSubgraph()) break block16;
                GraphIterator enm = ((Subgraph)elem).elements();
                while (enm.hasNext()) {
                    ((Element)enm.next()).highlight = 0;
                }
                break block16;
            }
            elem.highlight = setting == 16 ? (elem.highlight ^= mode) : (setting == 4 ? (elem.highlight |= mode) : (elem.highlight &= ~(mode &= 3)));
            if ((mode & 2) == 2) {
                if (elem.isNode()) {
                    if ((elem.highlight & 2) == 2) {
                        Node.Iterator<Edge> enm = ((Node)elem).edgeElements();
                        while (enm.hasNext()) {
                            ((Element)enm.next()).highlight |= 2;
                        }
                    } else {
                        Node.Iterator<Edge> enm = ((Node)elem).edgeElements();
                        while (enm.hasNext()) {
                            ((Element)enm.next()).highlight &= 0xFFFFFFFD;
                        }
                    }
                } else if (elem.isSubgraph()) {
                    if ((elem.highlight & 2) == 2) {
                        GraphIterator enm = ((Subgraph)elem).elements();
                        while (enm.hasNext()) {
                            ((Element)enm.next()).highlight |= 2;
                        }
                    } else {
                        GraphIterator enm = ((Subgraph)elem).elements();
                        while (enm.hasNext()) {
                            ((Element)enm.next()).highlight &= 0xFFFFFFFD;
                        }
                    }
                }
            }
        }
    }

    public static boolean filterGraph(Graph graph, Object connector) {
        return GrappaSupport.filterGraph(graph, connector, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean filterGraph(Graph graph, Object connector, String preamble) {
        StringBuilder newGraph;
        BufferedReader fromFilter;
        boolean status;
        String content;
        block34: {
            InputStream fromFilterRaw;
            block33: {
                OutputStream toFilterRaw;
                block31: {
                    if (connector == null) {
                        return false;
                    }
                    toFilterRaw = null;
                    try {
                        if (connector instanceof Process) {
                            toFilterRaw = ((Process)connector).getOutputStream();
                            break block31;
                        }
                        if (connector instanceof URLConnection) {
                            toFilterRaw = ((URLConnection)connector).getOutputStream();
                            break block31;
                        }
                        return false;
                    }
                    catch (IOException ioex) {
                        Grappa.displayException(ioex);
                        return false;
                    }
                }
                BufferedWriter toFilter = new BufferedWriter(new OutputStreamWriter(toFilterRaw));
                content = null;
                status = true;
                graph.filterMode = true;
                try {
                    StringWriter theGraph = new StringWriter();
                    graph.printGraph(theGraph);
                    theGraph.flush();
                    content = theGraph.toString();
                    theGraph.close();
                }
                catch (Exception ex) {
                    Grappa.displayException(ex);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    graph.filterMode = false;
                }
                try {
                    if (preamble != null) {
                        toFilter.write(preamble, 0, preamble.length());
                        toFilter.flush();
                    }
                    toFilter.write(content, 0, content.length());
                    toFilter.flush();
                    toFilter.close();
                }
                catch (Exception ex) {
                    Grappa.displayException(ex);
                    return false;
                }
                fromFilterRaw = null;
                try {
                    if (connector instanceof Process) {
                        fromFilterRaw = ((Process)connector).getInputStream();
                        break block33;
                    }
                    if (connector instanceof URLConnection) {
                        fromFilterRaw = ((URLConnection)connector).getInputStream();
                        break block33;
                    }
                    return false;
                }
                catch (IOException ioex) {
                    Grappa.displayException(ioex);
                    return false;
                }
            }
            fromFilter = new BufferedReader(new InputStreamReader(fromFilterRaw));
            newGraph = new StringBuilder(content.length() + 128);
            try {
                String line = null;
                while ((line = fromFilter.readLine()) != null) {
                    newGraph.append(line);
                    if (!line.equals("}") && !line.equals("}\r")) {
                        newGraph.append(Grappa.NEW_LINE);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                Grappa.displayException(ex);
                status = false;
                if (newGraph.length() != 0) break block34;
                newGraph.append(content);
                content = null;
            }
        }
        try {
            fromFilter.close();
        }
        catch (IOException io) {
            // empty catch block
        }
        StringReader fromReader = null;
        try {
            fromReader = new StringReader(newGraph.toString());
        }
        catch (Exception ex) {
            Grappa.displayException(ex);
            return false;
        }
        graph.reset();
        Parser program = new Parser(fromReader, graph.getErrorWriter(), graph);
        try {
            program.parse();
        }
        catch (Exception ex) {
            Grappa.displayException(ex);
            status = false;
            try {
                ((Reader)fromReader).close();
                fromReader = new StringReader(content);
            }
            catch (Exception ex2) {
                Grappa.displayException(ex2);
                return false;
            }
            program = new Parser(fromReader, graph.getErrorWriter(), graph);
            try {
                program.parse();
            }
            catch (Exception ex2) {
                Grappa.displayException(ex2);
                return false;
            }
        }
        return status;
    }

    public static boolean centerPanel(Point2D cpt, GrappaPanel gpanel) {
        if (cpt == null || gpanel == null) {
            return false;
        }
        if (!gpanel.getSubgraph().getBoundingBox().contains(cpt.getX(), cpt.getY())) {
            return false;
        }
        Container prnt = gpanel.getParent();
        if (!(prnt instanceof JViewport)) {
            Grappa.displayException(new RuntimeException("the parent of the supplied GrappaPanel is not a JViewport"));
            return false;
        }
        JViewport vport = (JViewport)prnt;
        Rectangle b = gpanel.getBounds();
        Dimension d = vport.getExtentSize();
        AffineTransform transform = gpanel.getTransform();
        if (transform == null) {
            return false;
        }
        Point2D p = transform.transform(cpt, null);
        Rectangle2D r = new Rectangle2D.Double(p.getX() + (double)b.x - (double)d.width / 2.0, p.getY() + (double)b.y - (double)d.height / 2.0, d.width, d.height);
        r = r.createIntersection(b);
        vport.scrollRectToVisible(r.getBounds());
        return true;
    }
}

