/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.AttributeHandler;
import att.grappa.Edge;
import att.grappa.Element;
import att.grappa.Graph;
import att.grappa.Grappa;
import att.grappa.GrappaBox;
import att.grappa.GrappaColor;
import att.grappa.GrappaConstants;
import att.grappa.GrappaLine;
import att.grappa.GrappaPoint;
import att.grappa.GrappaSize;
import att.grappa.GrappaStyle;
import att.grappa.GrappaSupport;
import att.grappa.GrappaSupportPrintf;
import att.grappa.IGrappaObjectListener;
import att.grappa.Node;
import att.grappa.Subgraph;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public final class Attribute
implements AttributeHandler,
GrappaConstants {
    private static AttributeHandler specialHandler = null;
    ArrayList<IGrappaObjectListener> listeners = null;
    private String name;
    private String stringValue;
    private Object value;
    private int elementType;
    private int attributeType;
    private int nameHash;
    boolean hasChanged = false;

    public static AttributeHandler setAttributeHandler(AttributeHandler newHandler) {
        AttributeHandler oldHandler = specialHandler;
        specialHandler = newHandler;
        return oldHandler;
    }

    public Attribute(int elemType, String attrName, Object attrValue) {
        if (attrName == null) {
            throw new IllegalArgumentException("the name of an Attribute pair cannot be null");
        }
        this.attributeType = Attribute.attributeType(elemType, attrName);
        this.elementType = elemType;
        this.name = attrName;
        this.nameHash = this.name.hashCode();
        this.setValue(attrValue);
    }

    public void addListener(IGrappaObjectListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(3);
        }
        this.listeners.add(listener);
    }

    public void removeListener(IGrappaObjectListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void removeListeners() {
        this.listeners = null;
    }

    public void notifyListeners(Object args) {
        if (this.listeners != null) {
            for (IGrappaObjectListener listener : this.listeners) {
                listener.update(this, args);
            }
        }
    }

    public Attribute(Attribute attr) {
        this(attr.getElementType(), attr.getName(), attr.getValue());
    }

    public final int getElementType() {
        return this.elementType;
    }

    public final int getAttributeType() {
        return this.attributeType;
    }

    public final String getName() {
        return this.name;
    }

    public final Object getValue() {
        if (this.value == null && this.stringValue != null) {
            this.value = this.convertStringValue(this.elementType, this.name, this.stringValue, this.attributeType);
        }
        return this.value;
    }

    public final String getStringValue() {
        switch (this.attributeType) {
            case 6: {
                this.stringValue = null;
            }
        }
        if (this.stringValue == null && this.value != null) {
            this.stringValue = this.convertValue(this.elementType, this.name, this.value, this.attributeType);
        }
        return this.stringValue;
    }

    public final Object setValue(Object attrValue) {
        boolean changed = false;
        boolean isString = false;
        Object oldValue = null;
        if (attrValue != null && attrValue instanceof String) {
            isString = true;
            oldValue = this.getStringValue();
            attrValue = ((String)attrValue).trim();
        } else {
            oldValue = this.getValue();
        }
        if (attrValue != null) {
            if (isString) {
                changed = this.stringValue == null || !attrValue.equals(this.stringValue);
                if (changed) {
                    this.stringValue = (String)attrValue;
                    this.value = null;
                }
            } else {
                changed = this.value == null || !attrValue.equals(this.value);
                if (changed) {
                    this.value = this.copyValue(this.elementType, this.name, attrValue, this.attributeType);
                    this.stringValue = null;
                }
            }
        } else {
            changed = this.value != null;
            if (changed) {
                this.value = null;
                this.stringValue = null;
            }
        }
        if (changed) {
            this.setChanged();
        }
        return oldValue;
    }

    public final boolean equals(Attribute attr) {
        if (attr == null) {
            return false;
        }
        if (this == attr) {
            return true;
        }
        if (this.nameHash != attr.getNameHash() || !attr.getName().equals(this.name)) {
            return false;
        }
        String attrValue = attr.getStringValue();
        if (attrValue == this.getStringValue()) {
            return true;
        }
        if (attrValue == null) {
            return false;
        }
        return attrValue.equals(this.stringValue);
    }

    public final boolean equalsValue(Attribute attr) {
        if (attr == null) {
            return false;
        }
        if (this == attr) {
            return true;
        }
        String attrValue = attr.getStringValue();
        if (attrValue == this.getStringValue()) {
            return true;
        }
        if (attrValue == null) {
            return false;
        }
        return attrValue.equals(this.stringValue);
    }

    public final int getNameHash() {
        return this.nameHash;
    }

    public final void setChanged() {
        this.hasChanged = true;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public final void clearChanged() {
        this.hasChanged = false;
    }

    public String toString() {
        return this.getClass().getName() + "[name=\"" + this.name + "\",value=\"" + this.getStringValue() + "\"]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertValue(int type, String name, Object value, int attrtype) {
        String stringValue = null;
        switch (attrtype) {
            case 1: {
                if (value instanceof GrappaBox) {
                    stringValue = ((GrappaBox)value).toAttributeString();
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of GrappaBox");
            }
            case 2: {
                if (value instanceof Color) {
                    stringValue = GrappaColor.getColorName((Color)value);
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of Color");
            }
            case 3: {
                if (value instanceof Integer) {
                    stringValue = GrappaSupport.xlateDir((Integer)value);
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of Integer");
            }
            case 4: {
                if (value instanceof Double) {
                    stringValue = GrappaSupportPrintf.sprintf(new Object[]{"%g", value});
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of Double");
            }
            case 5: {
                if (value instanceof Integer) {
                    stringValue = GrappaSupport.xlateFontStyle((Integer)value);
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of Integer");
            }
            case 6: {
                if (value instanceof HashMap) {
                    StringBuilder strbuf = new StringBuilder();
                    Iterator keys = ((HashMap)value).keySet().iterator();
                    StringBuilder stringBuilder = strbuf;
                    synchronized (stringBuilder) {
                        while (keys.hasNext()) {
                            if (strbuf.length() > 0) {
                                strbuf.append(',');
                            }
                            strbuf.append((String)keys.next());
                        }
                        stringValue = strbuf.toString();
                        break;
                    }
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of Hashtable");
            }
            case 7: {
                if (value instanceof Integer) {
                    stringValue = ((Integer)value).toString();
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of Integer");
            }
            case 8: {
                if (value instanceof GrappaLine) {
                    stringValue = ((GrappaLine)value).toAttributeString();
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of GrappaLine");
            }
            case 9: {
                if (value instanceof GrappaPoint) {
                    stringValue = ((GrappaPoint)value).toAttributeString();
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of GrappaPoint");
            }
            case 10: {
                if (value instanceof Integer) {
                    stringValue = Grappa.shapeToKey.get(value);
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of Integer");
            }
            case 11: {
                if (value instanceof GrappaSize) {
                    stringValue = ((GrappaSize)value).toAttributeString();
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of GrappaSize");
            }
            case 12: {
                if (value instanceof String) {
                    stringValue = (String)value;
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of String");
            }
            case 13: {
                if (value instanceof GrappaStyle) {
                    stringValue = ((GrappaStyle)value).toAttributeString();
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of GrappaStyle");
            }
            default: {
                if (specialHandler != null) {
                    stringValue = specialHandler.convertValue(type, name, value, attrtype);
                    break;
                }
                throw new RuntimeException(Element.typeString(type, true) + " attribute (" + name + ") needs a special handler");
            }
        }
        if (stringValue == null && value != null) {
            if (value instanceof String) {
                stringValue = (String)value;
            } else {
                throw new RuntimeException("AttributeHandler needed to perform conversion of attribute \"" + name + "\", please supply one via Attribute.setAttributeHandler()");
            }
        }
        return stringValue;
    }

    public Object convertStringValue(int type, String name, String stringValue, int attrtype) {
        Object value = null;
        if (stringValue == null || stringValue != null && attrtype != 12 && stringValue.trim().length() == 0) {
            value = null;
            stringValue = null;
        } else {
            switch (attrtype) {
                case 1: {
                    value = new GrappaBox(stringValue, false);
                    break;
                }
                case 2: {
                    value = GrappaColor.getColor(stringValue, null);
                    break;
                }
                case 3: {
                    value = new Integer(GrappaSupport.xlateDirString(stringValue));
                    break;
                }
                case 4: {
                    try {
                        value = Double.valueOf(stringValue);
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException("bad number format (" + stringValue + ") for attribute \"" + name + "\"");
                    }
                }
                case 5: {
                    value = new Integer(GrappaSupport.xlateFontStyleString(stringValue));
                    break;
                }
                case 6: {
                    String[] listvals = GrappaSupport.strsplit(stringValue);
                    if (this.value != null && this.value instanceof HashMap) {
                        value = this.value;
                        ((HashMap)value).clear();
                    } else {
                        value = new HashMap();
                    }
                    for (int i = 0; i < listvals.length; ++i) {
                        ((HashMap)value).put(listvals[i], listvals[i]);
                    }
                    break;
                }
                case 7: {
                    try {
                        value = Integer.valueOf(stringValue);
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException("bad integer format (" + stringValue + ") for attribute \"" + name + "\"");
                    }
                }
                case 8: {
                    value = new GrappaLine(stringValue);
                    break;
                }
                case 9: {
                    value = new GrappaPoint(stringValue);
                    break;
                }
                case 10: {
                    Attribute attr;
                    value = Grappa.keyToShape.get(stringValue);
                    if (value != null || (attr = Graph.getGlobalAttribute(1, "shape")) != null && (value = Grappa.keyToShape.get(attr.getValue())) != null) break;
                    throw new InternalError("could not provide default when unkown shape (" + stringValue + ") supplied for attribute \"" + name + "\"");
                }
                case 11: {
                    value = new GrappaSize(stringValue);
                    break;
                }
                case 12: {
                    value = stringValue;
                    break;
                }
                case 13: {
                    value = new GrappaStyle(this.elementType, stringValue);
                    break;
                }
                default: {
                    if (specialHandler != null) {
                        value = specialHandler.convertStringValue(type, name, stringValue, attrtype);
                        break;
                    }
                    throw new RuntimeException(Element.typeString(type, true) + " attribute (" + name + ") needs a special handler");
                }
            }
            if (value == null && stringValue != null) {
                value = stringValue;
            }
        }
        return value;
    }

    public Object copyValue(int type, String name, Object value, int attrtype) {
        Object copy_value = null;
        switch (attrtype) {
            case 1: {
                if (value instanceof GrappaBox) {
                    copy_value = ((GrappaBox)value).clone();
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of GrappaBox");
            }
            case 2: {
                if (value instanceof Color) {
                    copy_value = value;
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of Color");
            }
            case 3: {
                if (value instanceof Integer) {
                    copy_value = value;
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of Integer");
            }
            case 4: {
                if (value instanceof Double) {
                    copy_value = value;
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of Double");
            }
            case 5: {
                if (value instanceof Integer) {
                    copy_value = value;
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of Integer");
            }
            case 6: {
                if (value instanceof HashMap) {
                    copy_value = ((HashMap)value).clone();
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of Integer");
            }
            case 7: {
                if (value instanceof Integer) {
                    copy_value = value;
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of Integer");
            }
            case 8: {
                if (value instanceof GrappaLine) {
                    copy_value = ((GrappaLine)value).clone();
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of GrappaLine");
            }
            case 9: {
                if (value instanceof GrappaPoint) {
                    copy_value = ((GrappaPoint)value).clone();
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of GrappaPoint");
            }
            case 10: {
                if (value instanceof Integer) {
                    copy_value = value;
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of Integer");
            }
            case 11: {
                if (value instanceof GrappaSize) {
                    copy_value = ((GrappaSize)value).clone();
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of GrappaSize");
            }
            case 12: {
                if (value instanceof String) {
                    copy_value = value;
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of String");
            }
            case 13: {
                if (value instanceof GrappaStyle) {
                    copy_value = ((GrappaStyle)value).clone();
                    break;
                }
                throw new IllegalArgumentException("value of attribute \"" + name + "\" is not an instance of GrappaPoint");
            }
            default: {
                if (specialHandler != null) {
                    copy_value = specialHandler.copyValue(type, name, value, attrtype);
                    break;
                }
                throw new RuntimeException(Element.typeString(type, true) + " attribute (" + name + ") needs a special handler");
            }
        }
        if (copy_value == null && value != null) {
            if (value instanceof String) {
                copy_value = value;
            } else {
                throw new RuntimeException("AttributeHandler needed to perform copy of attribute \"" + name + "\", please supply one via Attribute.setAttributeHandler()");
            }
        }
        return copy_value;
    }

    public static int attributeType(int elemType, String attrName) {
        int attrType = 0;
        switch (elemType) {
            case 1: {
                attrType = Node.attributeType(attrName);
                break;
            }
            case 2: {
                attrType = Edge.attributeType(attrName);
                break;
            }
            case 4: {
                attrType = Subgraph.attributeType(attrName);
                break;
            }
            case 8: {
                attrType = Graph.attributeType(attrName);
                break;
            }
            default: {
                throw new IllegalArgumentException("type of attribute \"" + attrName + "\" must be one of Grappa.NODE, Grappa.EDGE or Grappa.SUBGRAPH");
            }
        }
        return attrType;
    }
}

