/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse;

import com.parctechnologies.eclipse.Atom;
import com.parctechnologies.eclipse.CompoundTerm;
import com.parctechnologies.eclipse.CompoundTermImpl;
import com.parctechnologies.eclipse.EXDRInputStream;
import com.parctechnologies.eclipse.EXDROutputStream;
import com.parctechnologies.eclipse.EclipseConnection;
import com.parctechnologies.eclipse.EclipseConnectionImpl;
import com.parctechnologies.eclipse.EclipseException;
import com.parctechnologies.eclipse.EclipseTerminatedException;
import com.parctechnologies.eclipse.FromEclipseQueue;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class RemoteEclipse
extends EclipseConnectionImpl
implements EclipseConnection {
    private Socket control;
    private Socket rpc;
    private String connectionName;
    private EXDRInputStream controlEXDRInput;
    private EXDRInputStream rpcEXDRInput;
    private EXDROutputStream controlEXDROutput;
    private EXDROutputStream rpcEXDROutput;
    private static final Atom resumeAtom = new Atom("resume");
    private static final Atom rpcAtom = new Atom("rpc");
    private static final Atom yieldAtom = new Atom("yield");
    private static final Atom disconnectAtom = new Atom("disconnect");
    private static final Atom disconnectYieldAtom = new Atom("disconnect_yield");
    private static final Atom disconnectResumeAtom = new Atom("disconnect_resume");
    private static final Atom syncAtom = new Atom("sync");
    private static final Atom asyncAtom = new Atom("async");
    private static final Atom fromecAtom = new Atom("fromec");
    private static final Atom toecAtom = new Atom("toec");
    private static final Atom bidirectAtom = new Atom("bidirect");
    private static final Atom emptyAtom = new Atom("");
    private static final Atom failAtom = new Atom("fail");
    private static final Atom successAtom = new Atom("success");
    private Map queueInfo = new HashMap();
    private InetAddress hostAddress;
    private static final int PROTOCOL_VERSION_NUMBER = 1;
    public static final int DEFAULT_TIMEOUT_MILLIS = 30000;
    boolean shouldDisconnect = false;

    public RemoteEclipse(InetAddress inetAddress, int n, String string) throws IOException {
        this(inetAddress, n, string, 30000);
    }

    public RemoteEclipse(InetAddress inetAddress, int n) throws IOException {
        this(inetAddress, n, "", 30000);
    }

    public RemoteEclipse(InetAddress inetAddress, int n, int n2) throws IOException {
        this(inetAddress, n, "", n2);
    }

    private void setUpControl(InetAddress inetAddress, int n) throws IOException {
        this.control = new Socket(inetAddress, n);
        this.controlEXDRInput = new EXDRInputStream(this.control.getInputStream());
        this.controlEXDROutput = new EXDROutputStream(this.control.getOutputStream());
    }

    private void setUpRPC(InetAddress inetAddress, int n) throws IOException {
        this.rpc = new Socket(inetAddress, n);
        this.rpcEXDRInput = new EXDRInputStream(this.rpc.getInputStream());
        this.rpcEXDROutput = new EXDROutputStream(this.rpc.getOutputStream());
    }

    public RemoteEclipse(InetAddress inetAddress, int n, String string, int n2) throws IOException {
        this.hostAddress = inetAddress;
        this.setUpControl(inetAddress, n);
        CompoundTermImpl compoundTermImpl = new CompoundTermImpl("remote_protocol", new Integer(1));
        this.writeControl(compoundTermImpl);
        Object object = this.readControl();
        if (!object.equals("yes")) {
            this.control.close();
            throw new IOException("Remote protocol error: protocol version unsupported.");
        }
        this.writeControl(string);
        this.connectionName = ((Atom)this.readControlTimeout(n2)).functor();
        this.writeControl("java");
        this.setUpRPC(inetAddress, n);
        if (!this.connectionName.equals(((Atom)this.readRPCTimeout(n2)).functor())) {
            throw new IOException("Remote protocol error.");
        }
        this.setPeerName(new Atom(this.connectionName));
    }

    public void unilateralDisconnect() throws EclipseTerminatedException {
        this.shouldDisconnect = false;
        this.testTerminated();
        try {
            this.controlEXDROutput.write(disconnectResumeAtom);
            this.controlEXDROutput.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.terminateJavaSide();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void disconnect() throws IOException {
        this.testTerminated();
        this.writeControl(disconnectAtom);
        Object object = null;
        try {
            object = this.readControl();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (object != null && !object.equals(disconnectYieldAtom)) {
            throw new IOException("Remote protocol error.");
        }
        this.terminateJavaSide();
    }

    private void terminateJavaSide() throws IOException {
        this.terminated = true;
        this.closeAllQueues(false);
        try {
            this.control.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.rpc.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void resume() throws IOException {
        this.testTerminated();
        this.waitForEclipse(true);
    }

    @Override
    void setupFromEclipseQueue(String string) throws EclipseException, IOException {
        Atom atom = new Atom(string);
        CompoundTerm compoundTerm = null;
        this.writeControl(new CompoundTermImpl("queue_create", atom, syncAtom, fromecAtom, emptyAtom));
        try {
            compoundTerm = (CompoundTerm)this.readControl();
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Remote interface protocol error.");
        }
        if (compoundTerm.equals(yieldAtom)) {
            throw new EclipseException("Could not create ECLiPSe side of queue.");
        }
        if (!(compoundTerm.functor().equals("socket_client") && compoundTerm.arity() == 4 && compoundTerm.arg(1) instanceof Integer && compoundTerm.arg(2) instanceof Atom && compoundTerm.arg(3) instanceof Atom && compoundTerm.arg(4) instanceof Atom && ((Atom)compoundTerm.arg(2)).equals(atom) && ((Atom)compoundTerm.arg(3)).functor().equals("sync") && ((Atom)compoundTerm.arg(4)).functor().equals("fromec"))) {
            throw new IOException("Remote interface protocol error.");
        }
        int n = (Integer)compoundTerm.arg(1);
        this.setupRemoteFromecQueue(atom, n);
        this.resume();
    }

    private void setupRemoteFromecQueue(Atom atom, int n) throws IOException {
        Socket socket;
        CompoundTerm compoundTerm = null;
        try {
            socket = new Socket(this.hostAddress, n);
        }
        catch (IOException iOException) {
            this.writeControl(new CompoundTermImpl("socket_connect", atom, failAtom));
            throw iOException;
        }
        this.writeControl(new CompoundTermImpl("socket_connect", atom, successAtom));
        try {
            compoundTerm = (CompoundTerm)this.readControl();
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Remote interface protocol error.");
        }
        if (!(compoundTerm.functor().equals("socket_accept") && compoundTerm.arity() == 2 && compoundTerm.arg(1) instanceof Atom && compoundTerm.arg(2) instanceof Integer && ((Atom)compoundTerm.arg(1)).equals(atom))) {
            throw new IOException("Remote interface protocol error.");
        }
        Integer n2 = (Integer)compoundTerm.arg(2);
        int n3 = n2;
        this.setupFromecInfo(n3, socket);
    }

    @Override
    void setupToEclipseQueue(String string) throws EclipseException, IOException {
        Atom atom = new Atom(string);
        CompoundTerm compoundTerm = null;
        this.writeControl(new CompoundTermImpl("queue_create", atom, syncAtom, toecAtom, emptyAtom));
        try {
            compoundTerm = (CompoundTerm)this.readControl();
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Remote interface protocol error.");
        }
        if (compoundTerm.equals(yieldAtom)) {
            throw new EclipseException("Could not create ECLiPSe side of queue.");
        }
        if (!(compoundTerm.functor().equals("socket_client") && compoundTerm.arity() == 4 && compoundTerm.arg(1) instanceof Integer && compoundTerm.arg(2) instanceof Atom && compoundTerm.arg(3) instanceof Atom && compoundTerm.arg(4) instanceof Atom && ((Atom)compoundTerm.arg(2)).equals(atom) && ((Atom)compoundTerm.arg(3)).functor().equals("sync") && ((Atom)compoundTerm.arg(4)).functor().equals("toec"))) {
            throw new IOException("Remote interface protocol error.");
        }
        int n = (Integer)compoundTerm.arg(1);
        this.setupRemoteToecQueue(atom, n);
        this.resume();
    }

    private void setupRemoteToecQueue(Atom atom, int n) throws IOException {
        Socket socket;
        CompoundTerm compoundTerm = null;
        try {
            socket = new Socket(this.hostAddress, n);
        }
        catch (IOException iOException) {
            this.writeControl(new CompoundTermImpl("socket_connect", atom, failAtom));
            throw iOException;
        }
        this.writeControl(new CompoundTermImpl("socket_connect", atom, successAtom));
        try {
            compoundTerm = (CompoundTerm)this.readControl();
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Remote interface protocol error.");
        }
        if (!(compoundTerm.functor().equals("socket_accept") && compoundTerm.arity() == 2 && compoundTerm.arg(1) instanceof Atom && compoundTerm.arg(2) instanceof Integer && ((Atom)compoundTerm.arg(1)).equals(atom))) {
            throw new IOException("Remote interface protocol error.");
        }
        Integer n2 = (Integer)compoundTerm.arg(2);
        int n3 = n2;
        this.setupToecInfo(n3, socket);
    }

    @Override
    void setupAsyncEclipseQueue(String string) throws EclipseException, IOException {
        Atom atom = new Atom(string);
        CompoundTerm compoundTerm = null;
        this.writeControl(new CompoundTermImpl("queue_create", atom, asyncAtom, bidirectAtom, emptyAtom));
        try {
            compoundTerm = (CompoundTerm)this.readControl();
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Remote interface protocol error.");
        }
        if (compoundTerm.equals(yieldAtom)) {
            throw new EclipseException("Could not create ECLiPSe side of queue.");
        }
        if (!(compoundTerm.functor().equals("socket_client") && compoundTerm.arity() == 4 && compoundTerm.arg(1) instanceof Integer && compoundTerm.arg(2) instanceof Atom && compoundTerm.arg(3) instanceof Atom && compoundTerm.arg(4) instanceof Atom && ((Atom)compoundTerm.arg(2)).equals(atom) && ((Atom)compoundTerm.arg(3)).functor().equals("async") && ((Atom)compoundTerm.arg(4)).functor().equals("bidirect"))) {
            throw new IOException("Remote interface protocol error.");
        }
        int n = (Integer)compoundTerm.arg(1);
        this.setupRemoteAsyncecQueue(atom, n);
        this.resume();
    }

    private void setupRemoteAsyncecQueue(Atom atom, int n) throws IOException {
        Socket socket;
        CompoundTerm compoundTerm = null;
        try {
            socket = new Socket(this.hostAddress, n);
        }
        catch (IOException iOException) {
            this.writeControl(new CompoundTermImpl("socket_connect", atom, failAtom));
            throw iOException;
        }
        this.writeControl(new CompoundTermImpl("socket_connect", atom, successAtom));
        try {
            compoundTerm = (CompoundTerm)this.readControl();
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Remote interface protocol error.");
        }
        if (!(compoundTerm.functor().equals("socket_accept") && compoundTerm.arity() == 2 && compoundTerm.arg(1) instanceof Atom && compoundTerm.arg(2) instanceof Integer && ((Atom)compoundTerm.arg(1)).equals(atom))) {
            throw new IOException("Remote interface protocol error.");
        }
        Integer n2 = (Integer)compoundTerm.arg(2);
        int n3 = n2;
        this.setupAsyncecInfo(n3, socket);
    }

    @Override
    void testTerminated() throws EclipseTerminatedException {
        if (this.shouldDisconnect) {
            this.unilateralDisconnect();
        }
        super.testTerminated();
    }

    @Override
    synchronized void flushStream(int n) throws IOException {
        this.writeControl(new CompoundTermImpl("rem_flushio", new Integer(n), new Integer(this.getBytesBuffered(n))));
        this.getOutputStream(n).flush();
        this.setBytesBuffered(n, 0);
        this.waitForEclipse(false);
    }

    @Override
    synchronized void writeByteToStream(int n, byte by) throws IOException {
        this.getOutputStream(n).write(0xFF & by);
        this.setBytesBuffered(n, this.getBytesBuffered(n) + 1);
    }

    @Override
    synchronized int writeToStream(int n, byte[] byArray, int n2, int n3) throws IOException {
        this.getOutputStream(n).write(byArray, n2, n3);
        this.setBytesBuffered(n, this.getBytesBuffered(n) + n3);
        return n3;
    }

    @Override
    synchronized int availableOnStream(int n) {
        return this.availableInBuffer(n);
    }

    @Override
    synchronized int readByteFromStream(int n) throws IOException {
        return this.readByteFromBuffer(n);
    }

    @Override
    synchronized int readFromStream(int n, int n2, int n3, byte[] byArray) throws IOException {
        return this.readBytesFromBuffer(n, byArray, n2, n3);
    }

    @Override
    EclipseConnectionImpl.ControlSignal getNextControlSignal(boolean bl, boolean bl2) throws IOException {
        CompoundTerm compoundTerm;
        if (bl2 || !bl) {
            this.writeControl(resumeAtom);
        }
        if (this.signalsYield(compoundTerm = this.getNextControlTerm())) {
            return new EclipseConnectionImpl.YieldSignal();
        }
        if (this.signalsMultilateralDisconnect(compoundTerm)) {
            return new MultilateralDisconnectSignal();
        }
        if (this.signalsUnilateralDisconnect(compoundTerm)) {
            return new UnilateralDisconnectSignal();
        }
        if (this.signalsFlushIO(compoundTerm)) {
            return new FlushIOSignal((Integer)compoundTerm.arg(1), (Integer)compoundTerm.arg(2));
        }
        if (this.signalsWaitIO(compoundTerm)) {
            return new EclipseConnectionImpl.WaitIOSignal((Integer)compoundTerm.arg(1));
        }
        if (this.signalsCloseQueue(compoundTerm)) {
            return new CloseQueueSignal((Integer)compoundTerm.arg(1));
        }
        if (this.signalsOpenQueue(compoundTerm)) {
            return new RemoteOpenQueueSignal((Integer)compoundTerm.arg(1), (Atom)compoundTerm.arg(2), (Atom)compoundTerm.arg(3), (Atom)compoundTerm.arg(4));
        }
        return null;
    }

    @Override
    void sendGoal(Object object) throws IOException {
        this.writeControl(rpcAtom);
        this.writeRPC(object);
    }

    @Override
    Object receiveGoal() throws IOException {
        return this.rpcEXDRInput.readTerm();
    }

    @Override
    void closeFromEclipseStreamJavaSide(int n) throws IOException {
        super.closeFromEclipseStreamJavaSide(n);
        this.closeFromecSocket(n);
        this.removeInfo(n);
    }

    @Override
    void closeToEclipseStreamJavaSide(int n) throws IOException {
        super.closeToEclipseStreamJavaSide(n);
        this.getOutputStream(n).close();
        this.closeToecSocket(n);
        this.setBytesBuffered(n, 0);
    }

    @Override
    void closeFromEclipseStreamEclipseSide(int n) throws IOException {
        super.closeFromEclipseStreamEclipseSide(n);
        this.writeControl(new CompoundTermImpl("queue_close", new Integer(n)));
        Object object = this.readControl();
        if (!object.equals(yieldAtom)) {
            throw new IOException("Remote protocol error.");
        }
    }

    @Override
    void closeToEclipseStreamEclipseSide(int n) throws IOException {
        super.closeToEclipseStreamEclipseSide(n);
        this.writeControl(new CompoundTermImpl("queue_close", new Integer(n)));
        Object object = this.readControl();
        if (!object.equals(yieldAtom)) {
            throw new IOException("Remote protocol error.");
        }
    }

    @Override
    void closeAsyncEclipseStreamEclipseSide(int n) throws IOException {
        super.closeAsyncEclipseStreamEclipseSide(n);
        this.writeControl(new CompoundTermImpl("queue_close", new Integer(n)));
        Object object = this.readControl();
        if (!object.equals(yieldAtom)) {
            throw new IOException("Remote protocol error.");
        }
    }

    private void writeControl(Object object) throws IOException {
        try {
            this.controlEXDROutput.write(object);
            this.controlEXDROutput.flush();
        }
        catch (SocketException socketException) {
            this.unilateralDisconnect();
            throw new EclipseTerminatedException();
        }
    }

    private void writeRPC(Object object) throws IOException {
        try {
            this.rpcEXDROutput.write(object);
            this.rpcEXDROutput.flush();
        }
        catch (SocketException socketException) {
            this.unilateralDisconnect();
            throw new EclipseTerminatedException();
        }
    }

    private Object readControl() throws IOException {
        try {
            return this.controlEXDRInput.readTerm();
        }
        catch (EOFException eOFException) {
            this.unilateralDisconnect();
            throw new EclipseTerminatedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readControlTimeout(int n) throws IOException {
        int n2 = this.control.getSoTimeout();
        try {
            this.control.setSoTimeout(n);
            Object object = this.readControl();
            return object;
        }
        finally {
            this.control.setSoTimeout(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readRPCTimeout(int n) throws IOException {
        int n2 = this.rpc.getSoTimeout();
        try {
            this.rpc.setSoTimeout(n);
            Object object = this.readRPC();
            return object;
        }
        finally {
            this.rpc.setSoTimeout(n2);
        }
    }

    private Object readRPC() throws IOException {
        try {
            return this.rpcEXDRInput.readTerm();
        }
        catch (EOFException eOFException) {
            this.unilateralDisconnect();
            throw new EclipseTerminatedException();
        }
    }

    protected void finalize() throws IOException, EclipseException {
        this.unilateralDisconnect();
    }

    private CompoundTerm getNextControlTerm() throws IOException {
        Object object = this.readControl();
        if (!(object instanceof CompoundTerm)) {
            throw new IOException("Remote interface protocol error: control object not CompoundTerm");
        }
        return (CompoundTerm)object;
    }

    private boolean signalsYield(CompoundTerm compoundTerm) {
        return compoundTerm.equals(yieldAtom);
    }

    private boolean signalsMultilateralDisconnect(CompoundTerm compoundTerm) {
        return compoundTerm.equals(disconnectAtom);
    }

    private boolean signalsUnilateralDisconnect(CompoundTerm compoundTerm) {
        return compoundTerm.equals(disconnectYieldAtom);
    }

    private boolean signalsFlushIO(CompoundTerm compoundTerm) {
        return compoundTerm.functor().equals("ec_flushio") && compoundTerm.arity() == 2 && compoundTerm.arg(1) instanceof Integer && compoundTerm.arg(2) instanceof Integer;
    }

    private boolean signalsWaitIO(CompoundTerm compoundTerm) {
        return compoundTerm.functor().equals("ec_waitio") && compoundTerm.arity() == 1 && compoundTerm.arg(1) instanceof Integer;
    }

    private boolean signalsCloseQueue(CompoundTerm compoundTerm) {
        return compoundTerm.functor().equals("queue_close") && compoundTerm.arity() == 1 && compoundTerm.arg(1) instanceof Integer;
    }

    private boolean signalsOpenQueue(CompoundTerm compoundTerm) {
        return compoundTerm.functor().equals("socket_client") && compoundTerm.arity() == 4 && compoundTerm.arg(1) instanceof Integer && compoundTerm.arg(2) instanceof Atom && compoundTerm.arg(3) instanceof Atom && compoundTerm.arg(4) instanceof Atom;
    }

    private void respondMultilateralDisconnect() throws IOException {
        this.writeControl(disconnectResumeAtom);
        this.terminateJavaSide();
        throw new EclipseTerminatedException();
    }

    private void respondUnilateralDisconnect() throws IOException {
        this.terminateJavaSide();
        throw new EclipseTerminatedException();
    }

    private void respondFlushIO(Integer n, Integer n2) throws IOException {
        FromEclipseQueue fromEclipseQueue = this.lookupFromEclipseQueue(n);
        if (fromEclipseQueue == null) {
            System.err.println("ECLiPSe yielded after flushing stream " + n + " which is not registered as FromEclipseQueue.");
        } else {
            this.bufferBytesFromSocket(n, n2);
            fromEclipseQueue.notifyAvailable();
        }
    }

    @Override
    void respondWaitIO(Integer n) throws IOException {
        super.respondWaitIO(n);
        this.writeControl(new CompoundTermImpl("rem_flushio", n, new Integer(0)));
        this.waitForEclipse(false);
    }

    private void respondRemoteOpenQueue(Integer n, Atom atom, Atom atom2, Atom atom3) throws IOException {
        if (atom2.equals(syncAtom)) {
            if (atom3.equals(toecAtom)) {
                this.setupRemoteToecQueue(atom, n);
                this.createToEclipseQueue(atom.functor());
                return;
            }
            if (atom3.equals(fromecAtom)) {
                this.setupRemoteFromecQueue(atom, n);
                this.createFromEclipseQueue(atom.functor());
                return;
            }
            throw new IOException("Remote interface protocol error: queue direction not recognised.");
        }
        if (atom2.equals(asyncAtom)) {
            if (atom3.equals(bidirectAtom)) {
                this.setupRemoteAsyncecQueue(atom, n);
                this.createAsyncEclipseQueue(atom.functor());
                return;
            }
            throw new IOException("Remote interface protocol error: queue direction not recognised.");
        }
        throw new IOException("Remote interface protocol error: queue type not recognised.");
    }

    private FromEclipseQueueInfo getFromecInfo(int n) {
        return (FromEclipseQueueInfo)this.queueInfo.get(new Integer(n));
    }

    private void bufferBytesFromSocket(int n, int n2) throws IOException {
        try {
            this.getFromecInfo(n).getBuffer().readBytesFromSocket(n2);
        }
        catch (EOFException eOFException) {
            this.unilateralDisconnect();
            throw new EclipseTerminatedException();
        }
    }

    private void closeFromecSocket(int n) throws IOException {
        this.getFromecInfo(n).getSocket().close();
    }

    private void removeInfo(int n) {
        this.queueInfo.remove(new Integer(n));
    }

    private void setupFromecInfo(int n, Socket socket) throws IOException {
        this.queueInfo.put(new Integer(n), new FromEclipseQueueInfo(socket));
    }

    private int readByteFromBuffer(int n) {
        return this.getFromecInfo(n).readByteFromBuffer();
    }

    private int readBytesFromBuffer(int n, byte[] byArray, int n2, int n3) {
        return this.getFromecInfo(n).readBytesFromBuffer(byArray, n2, n3);
    }

    private int availableInBuffer(int n) {
        return this.getFromecInfo(n).availableInBuffer();
    }

    private AsyncEclipseQueueInfo getAsyncecInfo(int n) {
        return (AsyncEclipseQueueInfo)this.queueInfo.get(new Integer(n));
    }

    private void closeAsyncecSocket(int n) throws IOException {
        this.getAsyncecInfo(n).getSocket().close();
    }

    private void setupAsyncecInfo(int n, Socket socket) throws IOException {
        this.queueInfo.put(new Integer(n), new AsyncEclipseQueueInfo(socket));
    }

    @Override
    InputStream getAsyncInputStream(int n) throws IOException {
        return this.getAsyncecInfo(n).getInputStream();
    }

    @Override
    OutputStream getAsyncOutputStream(int n) throws IOException {
        return this.getAsyncecInfo(n).getOutputStream();
    }

    @Override
    void closeAsyncEclipseStreamJavaSide(int n) throws IOException {
        super.closeAsyncEclipseStreamJavaSide(n);
        this.closeAsyncecSocket(n);
    }

    private ToEclipseQueueInfo getToecInfo(int n) {
        return (ToEclipseQueueInfo)this.queueInfo.get(new Integer(n));
    }

    private void closeToecSocket(int n) throws IOException {
        this.getToecInfo(n).getSocket().close();
    }

    private void setupToecInfo(int n, Socket socket) throws IOException {
        this.queueInfo.put(new Integer(n), new ToEclipseQueueInfo(socket));
    }

    private void setBytesBuffered(int n, int n2) {
        this.getToecInfo(n).setBytesBuffered(n2);
    }

    private int getBytesBuffered(int n) {
        return this.getToecInfo(n).getBytesBuffered();
    }

    private OutputStream getOutputStream(int n) {
        return this.getToecInfo(n).getOutputStream();
    }

    class MultilateralDisconnectSignal
    extends EclipseConnectionImpl.ControlSignal {
        MultilateralDisconnectSignal() {
        }

        @Override
        void respond() throws IOException {
            RemoteEclipse.this.respondMultilateralDisconnect();
        }
    }

    class UnilateralDisconnectSignal
    extends EclipseConnectionImpl.ControlSignal {
        UnilateralDisconnectSignal() {
        }

        @Override
        void respond() throws IOException {
            RemoteEclipse.this.respondUnilateralDisconnect();
        }
    }

    class FlushIOSignal
    extends EclipseConnectionImpl.ControlSignal {
        private Integer streamID;
        private Integer bytesFlushed;

        FlushIOSignal(Integer n, Integer n2) {
            this.streamID = n;
            this.bytesFlushed = n2;
        }

        @Override
        void respond() throws IOException {
            RemoteEclipse.this.respondFlushIO(this.streamID, this.bytesFlushed);
        }
    }

    class CloseQueueSignal
    extends EclipseConnectionImpl.ControlSignal {
        private Integer streamID;

        CloseQueueSignal(Integer n) {
            this.streamID = n;
        }

        @Override
        void respond() throws IOException {
            RemoteEclipse.this.respondCloseQueue(this.streamID);
        }
    }

    class RemoteOpenQueueSignal
    extends EclipseConnectionImpl.ControlSignal {
        private Integer port;
        private Atom nameAtom;
        private Atom type;
        private Atom direction;

        RemoteOpenQueueSignal(Integer n, Atom atom, Atom atom2, Atom atom3) {
            this.port = n;
            this.nameAtom = atom;
            this.type = atom2;
            this.direction = atom3;
        }

        @Override
        void respond() throws IOException {
            RemoteEclipse.this.respondRemoteOpenQueue(this.port, this.nameAtom, this.type, this.direction);
        }
    }

    private class FromEclipseQueueInfo {
        private Socket socket;
        private FromEclipseQueueBuffer fromEclipseQueueBuffer;

        FromEclipseQueueInfo(Socket socket) throws IOException {
            this.socket = socket;
            this.fromEclipseQueueBuffer = new FromEclipseQueueBuffer(socket.getInputStream());
        }

        FromEclipseQueueBuffer getBuffer() {
            return this.fromEclipseQueueBuffer;
        }

        Socket getSocket() {
            return this.socket;
        }

        int readByteFromBuffer() {
            return this.fromEclipseQueueBuffer.readByte();
        }

        int readBytesFromBuffer(byte[] byArray, int n, int n2) {
            return this.fromEclipseQueueBuffer.readBytes(byArray, n, n2);
        }

        int availableInBuffer() {
            return this.fromEclipseQueueBuffer.available();
        }
    }

    private class FromEclipseQueueBuffer {
        private int available;
        private DataInputStream socketInputStream;
        private Vector byteChunkVector;
        private byte[] currentByteChunk;
        private int readFromCurrentByteChunk;

        FromEclipseQueueBuffer(InputStream inputStream) {
            this.socketInputStream = new DataInputStream(inputStream);
            this.available = 0;
            this.byteChunkVector = new Vector();
            this.readFromCurrentByteChunk = 0;
            this.currentByteChunk = null;
        }

        int available() {
            return this.available;
        }

        private void nextChunk() {
            this.currentByteChunk = (byte[])(this.byteChunkVector.size() > 0 ? (byte[])this.byteChunkVector.remove(0) : null);
            this.readFromCurrentByteChunk = 0;
        }

        int readByte() {
            byte by;
            if (this.available == 0) {
                return -1;
            }
            if (this.readFromCurrentByteChunk == this.currentByteChunk.length) {
                this.nextChunk();
            }
            --this.available;
            if ((by = this.currentByteChunk[this.readFromCurrentByteChunk++]) < 0) {
                return by + 256;
            }
            return by;
        }

        int readBytes(byte[] byArray, int n, int n2) {
            int n3 = 0;
            while (n3 < n2 && this.available > 0) {
                int n4 = this.currentByteChunk.length - this.readFromCurrentByteChunk;
                int n5 = n2 - n3;
                if (n4 < n5) {
                    System.arraycopy(this.currentByteChunk, this.readFromCurrentByteChunk, byArray, n + n3, n4);
                    this.available -= n4;
                    n3 += n4;
                    this.nextChunk();
                    continue;
                }
                System.arraycopy(this.currentByteChunk, this.readFromCurrentByteChunk, byArray, n + n3, n5);
                this.available -= n5;
                n3 += n5;
                this.readFromCurrentByteChunk += n5;
            }
            return n3;
        }

        void readBytesFromSocket(int n) throws IOException {
            if (n == 0) {
                return;
            }
            byte[] byArray = new byte[n];
            this.socketInputStream.readFully(byArray);
            this.byteChunkVector.add(byArray);
            if (this.currentByteChunk == null) {
                this.nextChunk();
            }
            this.available += n;
        }
    }

    private class AsyncEclipseQueueInfo {
        private Socket socket;

        AsyncEclipseQueueInfo(Socket socket) throws IOException {
            this.socket = socket;
        }

        Socket getSocket() {
            return this.socket;
        }

        InputStream getInputStream() throws IOException {
            return this.socket.getInputStream();
        }

        OutputStream getOutputStream() throws IOException {
            return this.socket.getOutputStream();
        }
    }

    private class ToEclipseQueueInfo {
        private Socket socket;
        private int bytesBuffered;
        private OutputStream outputStream;

        void setBytesBuffered(int n) {
            this.bytesBuffered = n;
        }

        int getBytesBuffered() {
            return this.bytesBuffered;
        }

        OutputStream getOutputStream() {
            return this.outputStream;
        }

        ToEclipseQueueInfo(Socket socket) throws IOException {
            this.socket = socket;
            this.outputStream = new NonBlockingOutputStream(socket.getOutputStream());
            this.bytesBuffered = 0;
        }

        Socket getSocket() {
            return this.socket;
        }
    }

    private class NonBlockingOutputStream
    extends OutputStream {
        private OutputStream underlying_stream;
        private ByteArrayOutputStream bufferStream;
        private CopierThread copierThread;
        private IOException thrownException = null;
        private ByteChunkQueue byteChunkQueue;

        NonBlockingOutputStream(OutputStream outputStream) {
            this.underlying_stream = outputStream;
            this.bufferStream = new ByteArrayOutputStream();
            this.byteChunkQueue = new ByteChunkQueue();
            this.copierThread = new CopierThread();
            this.copierThread.start();
        }

        private void throwLastIOException() throws IOException {
            if (this.thrownException != null) {
                throw this.thrownException;
            }
        }

        @Override
        public void write(int n) throws IOException {
            this.throwLastIOException();
            this.bufferStream.write(n);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.throwLastIOException();
            this.bufferStream.write(byArray);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.throwLastIOException();
            this.bufferStream.write(byArray, n, n2);
        }

        private byte[] getByteArrayAndReset() {
            byte[] byArray = this.bufferStream.toByteArray();
            this.bufferStream.reset();
            return byArray;
        }

        private void copyAndFlush() {
            byte[] byArray = this.byteChunkQueue.retrieveChunk();
            try {
                this.underlying_stream.write(byArray);
                this.underlying_stream.flush();
            }
            catch (IOException iOException) {
                this.thrownException = iOException;
                RemoteEclipse.this.shouldDisconnect = true;
            }
        }

        @Override
        public void flush() throws IOException {
            this.throwLastIOException();
            if (this.bufferStream.size() > 0) {
                byte[] byArray = this.getByteArrayAndReset();
                this.byteChunkQueue.addChunk(byArray);
                this.copierThread.wake();
            }
        }

        @Override
        public void close() throws IOException {
            this.throwLastIOException();
            this.copierThread.terminate();
            this.copierThread.interrupt();
            while (this.copierThread.isAlive()) {
                try {
                    Thread.currentThread();
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.underlying_stream.close();
        }

        private class ByteChunkQueue {
            Vector queue = new Vector();

            ByteChunkQueue() {
            }

            synchronized boolean isEmpty() {
                return this.queue.isEmpty();
            }

            synchronized void waitUntilEmpty() {
                while (!this.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }

            synchronized void addChunk(byte[] byArray) {
                this.queue.add(byArray);
            }

            synchronized byte[] retrieveChunk() {
                byte[] byArray = (byte[])this.queue.remove(0);
                this.notifyAll();
                return byArray;
            }
        }

        private class CopierThread
        extends Thread {
            private boolean active = true;

            public CopierThread() {
                this.setDaemon(true);
            }

            synchronized void waitWoken() {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }

            synchronized void terminate() {
                this.active = false;
                this.notifyAll();
            }

            synchronized void wake() {
                this.notifyAll();
            }

            @Override
            public void run() {
                while (this.active) {
                    if (!NonBlockingOutputStream.this.byteChunkQueue.isEmpty()) {
                        NonBlockingOutputStream.this.copyAndFlush();
                        continue;
                    }
                    this.waitWoken();
                }
            }
        }
    }
}

