/*
 * Decompiled with CFR 0.152.
 */
package ie.ucc.cccc.viz;

import ie.ucc.cccc.viz.Box;
import ie.ucc.cccc.viz.Layout;
import ie.ucc.cccc.viz.State;
import ie.ucc.cccc.viz.Tools;
import ie.ucc.cccc.viz.Tree;
import ie.ucc.cccc.viz.TreeGraph;
import ie.ucc.cccc.viz.TreeValues;

public class Tool {
    private Tools tools;
    private String show;
    private String type;
    private String display;
    private String repeat;
    private int width;
    private int height;
    private String fileroot;

    public String toString() {
        return "Tool " + this.show + " type " + this.type + " display " + this.display + " repeat " + this.repeat + " width " + this.width + " height " + this.height + " fileroot " + this.fileroot;
    }

    public Tool(Tools tools, String string, String string2, String string3, String string4, int n, int n2, String string5) {
        this.tools = tools;
        this.show = string;
        this.type = string2;
        this.display = string3;
        this.repeat = string4;
        this.width = n;
        this.height = n2;
        this.fileroot = string5;
    }

    public void handleTree(Tree tree) {
        if (this.show.equals("tree") && this.type.equals("layout")) {
            boolean bl = this.display.equals("compact");
            if (this.repeat.equals("final")) {
                Layout layout = Layout.layoutNode(tree.getRootNode(), bl, tree.getNrNodes() + 1, 1);
                layout.draw(this, layout.getBox(), bl, tree.getNrNodes() + 1, this.getFileroot() + ".svg");
            } else if (this.repeat.equals("all")) {
                for (int i = 0; i < tree.getNrNodes(); ++i) {
                    Layout layout = Layout.layoutNode(tree.getRootNode(), bl, i, 1);
                    layout.draw(this, layout.getBox(), bl, i, this.getFileroot() + i + ".svg");
                }
            } else {
                int n = Integer.parseInt(this.repeat);
                if (n < 0) {
                    for (int i = 0; i < Math.min(-n, tree.getNrNodes()); ++i) {
                        Layout layout = Layout.layoutNode(tree.getRootNode(), bl, i, 1);
                        layout.draw(this, layout.getBox(), bl, i, this.getFileroot() + i + ".svg");
                    }
                } else {
                    Layout layout = Layout.layoutNode(tree.getRootNode(), bl, n, 1);
                    layout.draw(this, layout.getBox(), bl, n, this.getFileroot() + ".svg");
                }
            }
        } else if (this.show.equals("tree") && this.type.equals("graph")) {
            TreeGraph treeGraph = TreeGraph.graph(tree.getRootNode());
            treeGraph.plot(this.getDirectory(), this.getFileroot() + ".dat");
        } else if (this.show.equals("tree") && this.type.equals("values")) {
            TreeValues treeValues = TreeValues.graph(tree.getRootNode());
            treeValues.plot(this.getDirectory(), this.getFileroot() + ".tm3");
        } else {
            System.out.println("skip tool " + String.valueOf(this));
        }
    }

    public void handleState(State state, Box box) {
        if (this.show.equals("viz") && this.type.equals("layout")) {
            state.draw(this, box);
        } else {
            System.out.println("Skipping tool " + String.valueOf(this));
        }
    }

    public String getShow() {
        return this.show;
    }

    public String getType() {
        return this.type;
    }

    public String getDisplay() {
        return this.display;
    }

    public String getRepeat() {
        return this.repeat;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getDirectory() {
        return this.tools.getDirectory();
    }

    public String getFileroot() {
        return this.fileroot;
    }
}

