/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse;

import com.parctechnologies.eclipse.Atom;
import com.parctechnologies.eclipse.CompoundTermImpl;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;

public class EXDRInputStream
extends DataInputStream {
    private ArrayList stringList = null;

    public EXDRInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public synchronized Object readTerm() throws IOException {
        byte by = this.readByte();
        byte by2 = this.readByte();
        if (by == 86 && by2 < 3) {
            this.stringList = null;
            Object object = this.readSubTerm();
            this.stringList = null;
            return object;
        }
        throw new IOException("EXDR protocol error: bad version " + by + " " + by2);
    }

    private Object readSubTerm() throws IOException {
        byte by = this.readByte();
        switch (by) {
            case 67: {
                this.stringList = new ArrayList();
                return this.readSubTerm();
            }
            case 66: {
                return new Integer(this.readByte());
            }
            case 73: {
                return new Integer(this.readInt());
            }
            case 74: {
                return new Long(this.readLong());
            }
            case 68: {
                return new Double(this.readDouble());
            }
            case 95: {
                return null;
            }
            case 82: {
                if (this.stringList == null) {
                    throw new IOException("EXDR protocol error: String compression disabled, but reference found");
                }
                return this.stringList.get(this.readNat());
            }
            case 83: {
                return this.readString();
            }
            case 70: {
                int n = this.readNat();
                if (n == 0) {
                    return new Atom((String)this.readSubTerm());
                }
                Object[] objectArray = new Object[n + 1];
                for (int i = 0; i < n + 1; ++i) {
                    objectArray[i] = this.readSubTerm();
                }
                return new CompoundTermImpl(objectArray);
            }
            case 91: {
                LinkedList<Object> linkedList = new LinkedList<Object>();
                linkedList.add(this.readSubTerm());
                while (true) {
                    if ((by = this.readByte()) == 93) {
                        return linkedList;
                    }
                    if (by != 91) break;
                    linkedList.add(this.readSubTerm());
                }
                throw new IOException("EXDR protocol error: unexpected list separator " + by);
            }
            case 93: {
                return Collections.EMPTY_LIST;
            }
        }
        throw new IOException("EXDR protocol error: unrecognized EXDR code = " + by);
    }

    private int readNat() throws IOException {
        byte by = this.readByte();
        if ((by & 0x80) != 0) {
            return by & 0x7F;
        }
        return (by & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    private String readString() throws IOException {
        byte[] byArray = new byte[this.readNat()];
        this.readFully(byArray);
        String string = new String(byArray).intern();
        if (this.stringList != null) {
            this.stringList.add(string);
        }
        return string;
    }
}

