/*
 * Decompiled with CFR 0.152.
 */
package ie.ucc.cccc.viz;

import ie.ucc.cccc.viz.Box;
import ie.ucc.cccc.viz.Colors;
import ie.ucc.cccc.viz.InvariantType;
import ie.ucc.cccc.viz.Tool;
import ie.ucc.cccc.viz.VisualState;
import ie.ucc.cccc.viz.Viz;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class State {
    private State parent;
    private int id;
    private int treeNode;
    private List<VisualState> visualStates;

    public State(int n, int n2, State state) {
        this.id = n;
        this.treeNode = n2;
        this.parent = state;
        this.visualStates = new ArrayList<VisualState>();
    }

    public int getId() {
        return this.id;
    }

    public int getTreeNode() {
        return this.treeNode;
    }

    public List<VisualState> getVisualStates() {
        return this.visualStates;
    }

    public State getParent() {
        return this.parent;
    }

    public void addVisualizerState(VisualState visualState) {
        this.visualStates.add(visualState);
    }

    /*
     * WARNING - void declaration
     */
    public void draw(Tool tool, Box box) {
        void var4_7;
        for (VisualState object2 : this.visualStates) {
            box.expandBox(object2.getVisualizer().getBox());
        }
        PrintWriter printWriter = box.svgPrefix(tool, tool.getFileroot() + this.id + ".svg");
        for (VisualState visualState : this.visualStates) {
            visualState.draw(printWriter);
        }
        InvariantType invariantType = InvariantType.TRUE;
        block9: for (VisualState visualState : this.visualStates) {
            InvariantType invariantType2 = visualState.invariant(printWriter);
            InvariantType invariantType3 = var4_7.update(invariantType2);
            switch (invariantType2) {
                case TRUE: {
                    continue block9;
                }
                case MISSING_PROPAGATION: {
                    visualState.drawBox(printWriter, Colors.MISSING_PROPAGATION_COLOR);
                    continue block9;
                }
                case INCONSISTENT: {
                    visualState.drawBox(printWriter, Colors.INCONSISTENT_COLOR);
                    continue block9;
                }
                case INTERESTING: {
                    visualState.drawBox(printWriter, Colors.INTERESTING_COLOR);
                    continue block9;
                }
                case FALSE: {
                    visualState.drawBox(printWriter, Colors.FALSE_COLOR);
                    continue block9;
                }
            }
            System.out.println("UNKNOWN invariant type");
        }
        if (var4_7 != InvariantType.TRUE) {
            Viz.markTreeNode((InvariantType)var4_7, this.getTreeNode());
        }
        box.svgPostfix(printWriter);
    }
}

