#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 2332
#define LARGE_STATE_COUNT 165
#define SYMBOL_COUNT 246
#define ALIAS_COUNT 5
#define TOKEN_COUNT 106
#define EXTERNAL_TOKEN_COUNT 10
#define FIELD_COUNT 32
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 130

enum {
  sym_identifier = 1,
  anon_sym_SEMI = 2,
  anon_sym_import = 3,
  anon_sym_DOT = 4,
  anon_sym_from = 5,
  anon_sym___future__ = 6,
  anon_sym_LPAREN = 7,
  anon_sym_RPAREN = 8,
  anon_sym_COMMA = 9,
  anon_sym_as = 10,
  anon_sym_STAR = 11,
  anon_sym_print = 12,
  anon_sym_GT_GT = 13,
  anon_sym_assert = 14,
  anon_sym_COLON_EQ = 15,
  anon_sym_return = 16,
  anon_sym_del = 17,
  anon_sym_raise = 18,
  anon_sym_pass = 19,
  anon_sym_break = 20,
  anon_sym_continue = 21,
  anon_sym_if = 22,
  anon_sym_COLON = 23,
  anon_sym_elif = 24,
  anon_sym_else = 25,
  anon_sym_match = 26,
  anon_sym_case = 27,
  anon_sym_async = 28,
  anon_sym_for = 29,
  anon_sym_in = 30,
  anon_sym_while = 31,
  anon_sym_try = 32,
  anon_sym_except = 33,
  anon_sym_except_STAR = 34,
  anon_sym_finally = 35,
  anon_sym_with = 36,
  anon_sym_def = 37,
  anon_sym_DASH_GT = 38,
  anon_sym_STAR_STAR = 39,
  anon_sym_global = 40,
  anon_sym_nonlocal = 41,
  anon_sym_exec = 42,
  anon_sym_class = 43,
  anon_sym_AT = 44,
  anon_sym_LBRACK = 45,
  anon_sym_RBRACK = 46,
  anon_sym_EQ = 47,
  anon_sym_not = 48,
  anon_sym_and = 49,
  anon_sym_or = 50,
  anon_sym_PLUS = 51,
  anon_sym_DASH = 52,
  anon_sym_SLASH = 53,
  anon_sym_PERCENT = 54,
  anon_sym_SLASH_SLASH = 55,
  anon_sym_PIPE = 56,
  anon_sym_AMP = 57,
  anon_sym_CARET = 58,
  anon_sym_LT_LT = 59,
  anon_sym_TILDE = 60,
  anon_sym_LT = 61,
  anon_sym_LT_EQ = 62,
  anon_sym_EQ_EQ = 63,
  anon_sym_BANG_EQ = 64,
  anon_sym_GT_EQ = 65,
  anon_sym_GT = 66,
  anon_sym_LT_GT = 67,
  anon_sym_is = 68,
  anon_sym_lambda = 69,
  anon_sym_PLUS_EQ = 70,
  anon_sym_DASH_EQ = 71,
  anon_sym_STAR_EQ = 72,
  anon_sym_SLASH_EQ = 73,
  anon_sym_AT_EQ = 74,
  anon_sym_SLASH_SLASH_EQ = 75,
  anon_sym_PERCENT_EQ = 76,
  anon_sym_STAR_STAR_EQ = 77,
  anon_sym_GT_GT_EQ = 78,
  anon_sym_LT_LT_EQ = 79,
  anon_sym_AMP_EQ = 80,
  anon_sym_CARET_EQ = 81,
  anon_sym_PIPE_EQ = 82,
  anon_sym_yield = 83,
  sym_ellipsis = 84,
  anon_sym_LBRACE = 85,
  anon_sym_RBRACE = 86,
  sym__escape_interpolation = 87,
  sym_escape_sequence = 88,
  sym__not_escape_sequence = 89,
  aux_sym_format_specifier_token1 = 90,
  sym_type_conversion = 91,
  sym_integer = 92,
  sym_float = 93,
  anon_sym_await = 94,
  sym_true = 95,
  sym_false = 96,
  sym_none = 97,
  sym_comment = 98,
  sym_line_continuation = 99,
  sym__newline = 100,
  sym__indent = 101,
  sym__dedent = 102,
  sym_string_start = 103,
  sym__string_content = 104,
  sym_string_end = 105,
  sym_module = 106,
  sym__statement = 107,
  sym__simple_statements = 108,
  sym_import_statement = 109,
  sym_import_prefix = 110,
  sym_relative_import = 111,
  sym_future_import_statement = 112,
  sym_import_from_statement = 113,
  sym__import_list = 114,
  sym_aliased_import = 115,
  sym_wildcard_import = 116,
  sym_print_statement = 117,
  sym_chevron = 118,
  sym_assert_statement = 119,
  sym_expression_statement = 120,
  sym_named_expression = 121,
  sym__named_expression_lhs = 122,
  sym_return_statement = 123,
  sym_delete_statement = 124,
  sym_raise_statement = 125,
  sym_pass_statement = 126,
  sym_break_statement = 127,
  sym_continue_statement = 128,
  sym_if_statement = 129,
  sym_elif_clause = 130,
  sym_else_clause = 131,
  sym_match_statement = 132,
  sym__match_block = 133,
  sym_case_clause = 134,
  sym_for_statement = 135,
  sym_while_statement = 136,
  sym_try_statement = 137,
  sym_except_clause = 138,
  sym_except_group_clause = 139,
  sym_finally_clause = 140,
  sym_with_statement = 141,
  sym_with_clause = 142,
  sym_with_item = 143,
  sym_function_definition = 144,
  sym_parameters = 145,
  sym_lambda_parameters = 146,
  sym_list_splat = 147,
  sym_dictionary_splat = 148,
  sym_global_statement = 149,
  sym_nonlocal_statement = 150,
  sym_exec_statement = 151,
  sym_class_definition = 152,
  sym_parenthesized_list_splat = 153,
  sym_argument_list = 154,
  sym_decorated_definition = 155,
  sym_decorator = 156,
  sym_block = 157,
  sym_expression_list = 158,
  sym_dotted_name = 159,
  sym__parameters = 160,
  sym__patterns = 161,
  sym_parameter = 162,
  sym_pattern = 163,
  sym_tuple_pattern = 164,
  sym_list_pattern = 165,
  sym_default_parameter = 166,
  sym_typed_default_parameter = 167,
  sym_list_splat_pattern = 168,
  sym_dictionary_splat_pattern = 169,
  sym_as_pattern = 170,
  sym__expression_within_for_in_clause = 171,
  sym_expression = 172,
  sym_primary_expression = 173,
  sym_not_operator = 174,
  sym_boolean_operator = 175,
  sym_binary_operator = 176,
  sym_unary_operator = 177,
  sym_comparison_operator = 178,
  sym_lambda = 179,
  sym_lambda_within_for_in_clause = 180,
  sym_assignment = 181,
  sym_augmented_assignment = 182,
  sym_pattern_list = 183,
  sym__right_hand_side = 184,
  sym_yield = 185,
  sym_attribute = 186,
  sym_subscript = 187,
  sym_slice = 188,
  sym_call = 189,
  sym_typed_parameter = 190,
  sym_type = 191,
  sym_keyword_argument = 192,
  sym_list = 193,
  sym_set = 194,
  sym_tuple = 195,
  sym_dictionary = 196,
  sym_pair = 197,
  sym_list_comprehension = 198,
  sym_dictionary_comprehension = 199,
  sym_set_comprehension = 200,
  sym_generator_expression = 201,
  sym__comprehension_clauses = 202,
  sym_parenthesized_expression = 203,
  sym__collection_elements = 204,
  sym_for_in_clause = 205,
  sym_if_clause = 206,
  sym_conditional_expression = 207,
  sym_concatenated_string = 208,
  sym_string = 209,
  sym_string_content = 210,
  sym_interpolation = 211,
  sym__f_expression = 212,
  sym_format_specifier = 213,
  sym_await = 214,
  sym_positional_separator = 215,
  sym_keyword_separator = 216,
  aux_sym_module_repeat1 = 217,
  aux_sym__simple_statements_repeat1 = 218,
  aux_sym_import_prefix_repeat1 = 219,
  aux_sym__import_list_repeat1 = 220,
  aux_sym_print_statement_repeat1 = 221,
  aux_sym_assert_statement_repeat1 = 222,
  aux_sym_if_statement_repeat1 = 223,
  aux_sym_match_statement_repeat1 = 224,
  aux_sym__match_block_repeat1 = 225,
  aux_sym_case_clause_repeat1 = 226,
  aux_sym_try_statement_repeat1 = 227,
  aux_sym_try_statement_repeat2 = 228,
  aux_sym_with_clause_repeat1 = 229,
  aux_sym_global_statement_repeat1 = 230,
  aux_sym_argument_list_repeat1 = 231,
  aux_sym_decorated_definition_repeat1 = 232,
  aux_sym_dotted_name_repeat1 = 233,
  aux_sym__parameters_repeat1 = 234,
  aux_sym__patterns_repeat1 = 235,
  aux_sym_comparison_operator_repeat1 = 236,
  aux_sym_subscript_repeat1 = 237,
  aux_sym_dictionary_repeat1 = 238,
  aux_sym__comprehension_clauses_repeat1 = 239,
  aux_sym__collection_elements_repeat1 = 240,
  aux_sym_for_in_clause_repeat1 = 241,
  aux_sym_concatenated_string_repeat1 = 242,
  aux_sym_string_repeat1 = 243,
  aux_sym_string_content_repeat1 = 244,
  aux_sym_format_specifier_repeat1 = 245,
  alias_sym_as_pattern_target = 246,
  alias_sym_case_pattern = 247,
  alias_sym_format_expression = 248,
  anon_alias_sym_isnot = 249,
  anon_alias_sym_notin = 250,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_SEMI] = ";",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [anon_sym_from] = "from",
  [anon_sym___future__] = "__future__",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COMMA] = ",",
  [anon_sym_as] = "as",
  [anon_sym_STAR] = "*",
  [anon_sym_print] = "print",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_assert] = "assert",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_return] = "return",
  [anon_sym_del] = "del",
  [anon_sym_raise] = "raise",
  [anon_sym_pass] = "pass",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_if] = "if",
  [anon_sym_COLON] = ":",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_match] = "match",
  [anon_sym_case] = "case",
  [anon_sym_async] = "async",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_while] = "while",
  [anon_sym_try] = "try",
  [anon_sym_except] = "except",
  [anon_sym_except_STAR] = "except*",
  [anon_sym_finally] = "finally",
  [anon_sym_with] = "with",
  [anon_sym_def] = "def",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_global] = "global",
  [anon_sym_nonlocal] = "nonlocal",
  [anon_sym_exec] = "exec",
  [anon_sym_class] = "class",
  [anon_sym_AT] = "@",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_EQ] = "=",
  [anon_sym_not] = "not",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_TILDE] = "~",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_is] = "is",
  [anon_sym_lambda] = "lambda",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_AT_EQ] = "@=",
  [anon_sym_SLASH_SLASH_EQ] = "//=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_yield] = "yield",
  [sym_ellipsis] = "ellipsis",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [sym__escape_interpolation] = "_escape_interpolation",
  [sym_escape_sequence] = "escape_sequence",
  [sym__not_escape_sequence] = "_not_escape_sequence",
  [aux_sym_format_specifier_token1] = "format_specifier_token1",
  [sym_type_conversion] = "type_conversion",
  [sym_integer] = "integer",
  [sym_float] = "float",
  [anon_sym_await] = "await",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_none] = "none",
  [sym_comment] = "comment",
  [sym_line_continuation] = "line_continuation",
  [sym__newline] = "_newline",
  [sym__indent] = "_indent",
  [sym__dedent] = "_dedent",
  [sym_string_start] = "string_start",
  [sym__string_content] = "_string_content",
  [sym_string_end] = "string_end",
  [sym_module] = "module",
  [sym__statement] = "_statement",
  [sym__simple_statements] = "_simple_statements",
  [sym_import_statement] = "import_statement",
  [sym_import_prefix] = "import_prefix",
  [sym_relative_import] = "relative_import",
  [sym_future_import_statement] = "future_import_statement",
  [sym_import_from_statement] = "import_from_statement",
  [sym__import_list] = "_import_list",
  [sym_aliased_import] = "aliased_import",
  [sym_wildcard_import] = "wildcard_import",
  [sym_print_statement] = "print_statement",
  [sym_chevron] = "chevron",
  [sym_assert_statement] = "assert_statement",
  [sym_expression_statement] = "expression_statement",
  [sym_named_expression] = "named_expression",
  [sym__named_expression_lhs] = "_named_expression_lhs",
  [sym_return_statement] = "return_statement",
  [sym_delete_statement] = "delete_statement",
  [sym_raise_statement] = "raise_statement",
  [sym_pass_statement] = "pass_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_if_statement] = "if_statement",
  [sym_elif_clause] = "elif_clause",
  [sym_else_clause] = "else_clause",
  [sym_match_statement] = "match_statement",
  [sym__match_block] = "block",
  [sym_case_clause] = "case_clause",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_try_statement] = "try_statement",
  [sym_except_clause] = "except_clause",
  [sym_except_group_clause] = "except_group_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_with_statement] = "with_statement",
  [sym_with_clause] = "with_clause",
  [sym_with_item] = "with_item",
  [sym_function_definition] = "function_definition",
  [sym_parameters] = "parameters",
  [sym_lambda_parameters] = "lambda_parameters",
  [sym_list_splat] = "list_splat",
  [sym_dictionary_splat] = "dictionary_splat",
  [sym_global_statement] = "global_statement",
  [sym_nonlocal_statement] = "nonlocal_statement",
  [sym_exec_statement] = "exec_statement",
  [sym_class_definition] = "class_definition",
  [sym_parenthesized_list_splat] = "parenthesized_list_splat",
  [sym_argument_list] = "argument_list",
  [sym_decorated_definition] = "decorated_definition",
  [sym_decorator] = "decorator",
  [sym_block] = "block",
  [sym_expression_list] = "expression_list",
  [sym_dotted_name] = "dotted_name",
  [sym__parameters] = "_parameters",
  [sym__patterns] = "_patterns",
  [sym_parameter] = "parameter",
  [sym_pattern] = "pattern",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym_list_pattern] = "list_pattern",
  [sym_default_parameter] = "default_parameter",
  [sym_typed_default_parameter] = "typed_default_parameter",
  [sym_list_splat_pattern] = "list_splat_pattern",
  [sym_dictionary_splat_pattern] = "dictionary_splat_pattern",
  [sym_as_pattern] = "as_pattern",
  [sym__expression_within_for_in_clause] = "_expression_within_for_in_clause",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_not_operator] = "not_operator",
  [sym_boolean_operator] = "boolean_operator",
  [sym_binary_operator] = "binary_operator",
  [sym_unary_operator] = "unary_operator",
  [sym_comparison_operator] = "comparison_operator",
  [sym_lambda] = "lambda",
  [sym_lambda_within_for_in_clause] = "lambda",
  [sym_assignment] = "assignment",
  [sym_augmented_assignment] = "augmented_assignment",
  [sym_pattern_list] = "pattern_list",
  [sym__right_hand_side] = "_right_hand_side",
  [sym_yield] = "yield",
  [sym_attribute] = "attribute",
  [sym_subscript] = "subscript",
  [sym_slice] = "slice",
  [sym_call] = "call",
  [sym_typed_parameter] = "typed_parameter",
  [sym_type] = "type",
  [sym_keyword_argument] = "keyword_argument",
  [sym_list] = "list",
  [sym_set] = "set",
  [sym_tuple] = "tuple",
  [sym_dictionary] = "dictionary",
  [sym_pair] = "pair",
  [sym_list_comprehension] = "list_comprehension",
  [sym_dictionary_comprehension] = "dictionary_comprehension",
  [sym_set_comprehension] = "set_comprehension",
  [sym_generator_expression] = "generator_expression",
  [sym__comprehension_clauses] = "_comprehension_clauses",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym__collection_elements] = "_collection_elements",
  [sym_for_in_clause] = "for_in_clause",
  [sym_if_clause] = "if_clause",
  [sym_conditional_expression] = "conditional_expression",
  [sym_concatenated_string] = "concatenated_string",
  [sym_string] = "string",
  [sym_string_content] = "string_content",
  [sym_interpolation] = "interpolation",
  [sym__f_expression] = "_f_expression",
  [sym_format_specifier] = "format_specifier",
  [sym_await] = "await",
  [sym_positional_separator] = "positional_separator",
  [sym_keyword_separator] = "keyword_separator",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym__simple_statements_repeat1] = "_simple_statements_repeat1",
  [aux_sym_import_prefix_repeat1] = "import_prefix_repeat1",
  [aux_sym__import_list_repeat1] = "_import_list_repeat1",
  [aux_sym_print_statement_repeat1] = "print_statement_repeat1",
  [aux_sym_assert_statement_repeat1] = "assert_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_match_statement_repeat1] = "match_statement_repeat1",
  [aux_sym__match_block_repeat1] = "_match_block_repeat1",
  [aux_sym_case_clause_repeat1] = "case_clause_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_try_statement_repeat2] = "try_statement_repeat2",
  [aux_sym_with_clause_repeat1] = "with_clause_repeat1",
  [aux_sym_global_statement_repeat1] = "global_statement_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_decorated_definition_repeat1] = "decorated_definition_repeat1",
  [aux_sym_dotted_name_repeat1] = "dotted_name_repeat1",
  [aux_sym__parameters_repeat1] = "_parameters_repeat1",
  [aux_sym__patterns_repeat1] = "_patterns_repeat1",
  [aux_sym_comparison_operator_repeat1] = "comparison_operator_repeat1",
  [aux_sym_subscript_repeat1] = "subscript_repeat1",
  [aux_sym_dictionary_repeat1] = "dictionary_repeat1",
  [aux_sym__comprehension_clauses_repeat1] = "_comprehension_clauses_repeat1",
  [aux_sym__collection_elements_repeat1] = "_collection_elements_repeat1",
  [aux_sym_for_in_clause_repeat1] = "for_in_clause_repeat1",
  [aux_sym_concatenated_string_repeat1] = "concatenated_string_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_content_repeat1] = "string_content_repeat1",
  [aux_sym_format_specifier_repeat1] = "format_specifier_repeat1",
  [alias_sym_as_pattern_target] = "as_pattern_target",
  [alias_sym_case_pattern] = "case_pattern",
  [alias_sym_format_expression] = "format_expression",
  [anon_alias_sym_isnot] = "is not",
  [anon_alias_sym_notin] = "not in",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_from] = anon_sym_from,
  [anon_sym___future__] = anon_sym___future__,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_print] = anon_sym_print,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_del] = anon_sym_del,
  [anon_sym_raise] = anon_sym_raise,
  [anon_sym_pass] = anon_sym_pass,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_elif] = anon_sym_elif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_match] = anon_sym_match,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_except] = anon_sym_except,
  [anon_sym_except_STAR] = anon_sym_except_STAR,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_def] = anon_sym_def,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_nonlocal] = anon_sym_nonlocal,
  [anon_sym_exec] = anon_sym_exec,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_lambda] = anon_sym_lambda,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_AT_EQ] = anon_sym_AT_EQ,
  [anon_sym_SLASH_SLASH_EQ] = anon_sym_SLASH_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_yield] = anon_sym_yield,
  [sym_ellipsis] = sym_ellipsis,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [sym__escape_interpolation] = sym__escape_interpolation,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym__not_escape_sequence] = sym__not_escape_sequence,
  [aux_sym_format_specifier_token1] = aux_sym_format_specifier_token1,
  [sym_type_conversion] = sym_type_conversion,
  [sym_integer] = sym_integer,
  [sym_float] = sym_float,
  [anon_sym_await] = anon_sym_await,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_none] = sym_none,
  [sym_comment] = sym_comment,
  [sym_line_continuation] = sym_line_continuation,
  [sym__newline] = sym__newline,
  [sym__indent] = sym__indent,
  [sym__dedent] = sym__dedent,
  [sym_string_start] = sym_string_start,
  [sym__string_content] = sym__string_content,
  [sym_string_end] = sym_string_end,
  [sym_module] = sym_module,
  [sym__statement] = sym__statement,
  [sym__simple_statements] = sym__simple_statements,
  [sym_import_statement] = sym_import_statement,
  [sym_import_prefix] = sym_import_prefix,
  [sym_relative_import] = sym_relative_import,
  [sym_future_import_statement] = sym_future_import_statement,
  [sym_import_from_statement] = sym_import_from_statement,
  [sym__import_list] = sym__import_list,
  [sym_aliased_import] = sym_aliased_import,
  [sym_wildcard_import] = sym_wildcard_import,
  [sym_print_statement] = sym_print_statement,
  [sym_chevron] = sym_chevron,
  [sym_assert_statement] = sym_assert_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_named_expression] = sym_named_expression,
  [sym__named_expression_lhs] = sym__named_expression_lhs,
  [sym_return_statement] = sym_return_statement,
  [sym_delete_statement] = sym_delete_statement,
  [sym_raise_statement] = sym_raise_statement,
  [sym_pass_statement] = sym_pass_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_elif_clause] = sym_elif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_match_statement] = sym_match_statement,
  [sym__match_block] = sym_block,
  [sym_case_clause] = sym_case_clause,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_except_clause] = sym_except_clause,
  [sym_except_group_clause] = sym_except_group_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_with_statement] = sym_with_statement,
  [sym_with_clause] = sym_with_clause,
  [sym_with_item] = sym_with_item,
  [sym_function_definition] = sym_function_definition,
  [sym_parameters] = sym_parameters,
  [sym_lambda_parameters] = sym_lambda_parameters,
  [sym_list_splat] = sym_list_splat,
  [sym_dictionary_splat] = sym_dictionary_splat,
  [sym_global_statement] = sym_global_statement,
  [sym_nonlocal_statement] = sym_nonlocal_statement,
  [sym_exec_statement] = sym_exec_statement,
  [sym_class_definition] = sym_class_definition,
  [sym_parenthesized_list_splat] = sym_parenthesized_list_splat,
  [sym_argument_list] = sym_argument_list,
  [sym_decorated_definition] = sym_decorated_definition,
  [sym_decorator] = sym_decorator,
  [sym_block] = sym_block,
  [sym_expression_list] = sym_expression_list,
  [sym_dotted_name] = sym_dotted_name,
  [sym__parameters] = sym__parameters,
  [sym__patterns] = sym__patterns,
  [sym_parameter] = sym_parameter,
  [sym_pattern] = sym_pattern,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym_list_pattern] = sym_list_pattern,
  [sym_default_parameter] = sym_default_parameter,
  [sym_typed_default_parameter] = sym_typed_default_parameter,
  [sym_list_splat_pattern] = sym_list_splat_pattern,
  [sym_dictionary_splat_pattern] = sym_dictionary_splat_pattern,
  [sym_as_pattern] = sym_as_pattern,
  [sym__expression_within_for_in_clause] = sym__expression_within_for_in_clause,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_not_operator] = sym_not_operator,
  [sym_boolean_operator] = sym_boolean_operator,
  [sym_binary_operator] = sym_binary_operator,
  [sym_unary_operator] = sym_unary_operator,
  [sym_comparison_operator] = sym_comparison_operator,
  [sym_lambda] = sym_lambda,
  [sym_lambda_within_for_in_clause] = sym_lambda,
  [sym_assignment] = sym_assignment,
  [sym_augmented_assignment] = sym_augmented_assignment,
  [sym_pattern_list] = sym_pattern_list,
  [sym__right_hand_side] = sym__right_hand_side,
  [sym_yield] = sym_yield,
  [sym_attribute] = sym_attribute,
  [sym_subscript] = sym_subscript,
  [sym_slice] = sym_slice,
  [sym_call] = sym_call,
  [sym_typed_parameter] = sym_typed_parameter,
  [sym_type] = sym_type,
  [sym_keyword_argument] = sym_keyword_argument,
  [sym_list] = sym_list,
  [sym_set] = sym_set,
  [sym_tuple] = sym_tuple,
  [sym_dictionary] = sym_dictionary,
  [sym_pair] = sym_pair,
  [sym_list_comprehension] = sym_list_comprehension,
  [sym_dictionary_comprehension] = sym_dictionary_comprehension,
  [sym_set_comprehension] = sym_set_comprehension,
  [sym_generator_expression] = sym_generator_expression,
  [sym__comprehension_clauses] = sym__comprehension_clauses,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym__collection_elements] = sym__collection_elements,
  [sym_for_in_clause] = sym_for_in_clause,
  [sym_if_clause] = sym_if_clause,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_concatenated_string] = sym_concatenated_string,
  [sym_string] = sym_string,
  [sym_string_content] = sym_string_content,
  [sym_interpolation] = sym_interpolation,
  [sym__f_expression] = sym__f_expression,
  [sym_format_specifier] = sym_format_specifier,
  [sym_await] = sym_await,
  [sym_positional_separator] = sym_positional_separator,
  [sym_keyword_separator] = sym_keyword_separator,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym__simple_statements_repeat1] = aux_sym__simple_statements_repeat1,
  [aux_sym_import_prefix_repeat1] = aux_sym_import_prefix_repeat1,
  [aux_sym__import_list_repeat1] = aux_sym__import_list_repeat1,
  [aux_sym_print_statement_repeat1] = aux_sym_print_statement_repeat1,
  [aux_sym_assert_statement_repeat1] = aux_sym_assert_statement_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_match_statement_repeat1] = aux_sym_match_statement_repeat1,
  [aux_sym__match_block_repeat1] = aux_sym__match_block_repeat1,
  [aux_sym_case_clause_repeat1] = aux_sym_case_clause_repeat1,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym_try_statement_repeat2] = aux_sym_try_statement_repeat2,
  [aux_sym_with_clause_repeat1] = aux_sym_with_clause_repeat1,
  [aux_sym_global_statement_repeat1] = aux_sym_global_statement_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_decorated_definition_repeat1] = aux_sym_decorated_definition_repeat1,
  [aux_sym_dotted_name_repeat1] = aux_sym_dotted_name_repeat1,
  [aux_sym__parameters_repeat1] = aux_sym__parameters_repeat1,
  [aux_sym__patterns_repeat1] = aux_sym__patterns_repeat1,
  [aux_sym_comparison_operator_repeat1] = aux_sym_comparison_operator_repeat1,
  [aux_sym_subscript_repeat1] = aux_sym_subscript_repeat1,
  [aux_sym_dictionary_repeat1] = aux_sym_dictionary_repeat1,
  [aux_sym__comprehension_clauses_repeat1] = aux_sym__comprehension_clauses_repeat1,
  [aux_sym__collection_elements_repeat1] = aux_sym__collection_elements_repeat1,
  [aux_sym_for_in_clause_repeat1] = aux_sym_for_in_clause_repeat1,
  [aux_sym_concatenated_string_repeat1] = aux_sym_concatenated_string_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_content_repeat1] = aux_sym_string_content_repeat1,
  [aux_sym_format_specifier_repeat1] = aux_sym_format_specifier_repeat1,
  [alias_sym_as_pattern_target] = alias_sym_as_pattern_target,
  [alias_sym_case_pattern] = alias_sym_case_pattern,
  [alias_sym_format_expression] = alias_sym_format_expression,
  [anon_alias_sym_isnot] = anon_alias_sym_isnot,
  [anon_alias_sym_notin] = anon_alias_sym_notin,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___future__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_print] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_del] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_raise] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pass] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_except] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_except_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_def] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nonlocal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lambda] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [sym_ellipsis] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym__escape_interpolation] = {
    .visible = false,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym__not_escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_format_specifier_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_type_conversion] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_none] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_line_continuation] = {
    .visible = true,
    .named = true,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym_string_start] = {
    .visible = true,
    .named = true,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym_string_end] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__simple_statements] = {
    .visible = false,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_prefix] = {
    .visible = true,
    .named = true,
  },
  [sym_relative_import] = {
    .visible = true,
    .named = true,
  },
  [sym_future_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_from_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__import_list] = {
    .visible = false,
    .named = true,
  },
  [sym_aliased_import] = {
    .visible = true,
    .named = true,
  },
  [sym_wildcard_import] = {
    .visible = true,
    .named = true,
  },
  [sym_print_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_chevron] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_named_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__named_expression_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_raise_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_pass_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_match_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__match_block] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_except_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_except_group_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_with_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_list_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_global_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_nonlocal_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_exec_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_class_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_list_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_decorated_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_dotted_name] = {
    .visible = true,
    .named = true,
  },
  [sym__parameters] = {
    .visible = false,
    .named = true,
  },
  [sym__patterns] = {
    .visible = false,
    .named = true,
  },
  [sym_parameter] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_list_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_as_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_within_for_in_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_not_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_within_for_in_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_augmented_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_list] = {
    .visible = true,
    .named = true,
  },
  [sym__right_hand_side] = {
    .visible = false,
    .named = true,
  },
  [sym_yield] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_slice] = {
    .visible = true,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_set] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_list_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_set_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__comprehension_clauses] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__collection_elements] = {
    .visible = false,
    .named = true,
  },
  [sym_for_in_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenated_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string_content] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym__f_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_format_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_await] = {
    .visible = true,
    .named = true,
  },
  [sym_positional_separator] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_separator] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__simple_statements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_prefix_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__import_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_print_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_assert_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_match_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__match_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_with_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_global_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_decorated_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dotted_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__patterns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_comparison_operator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subscript_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dictionary_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__comprehension_clauses_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__collection_elements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_in_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenated_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_format_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_as_pattern_target] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_case_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_format_expression] = {
    .visible = true,
    .named = true,
  },
  [anon_alias_sym_isnot] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_notin] = {
    .visible = true,
    .named = false,
  },
};

enum {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_attribute = 5,
  field_body = 6,
  field_cause = 7,
  field_code = 8,
  field_condition = 9,
  field_consequence = 10,
  field_definition = 11,
  field_expression = 12,
  field_format_specifier = 13,
  field_function = 14,
  field_guard = 15,
  field_key = 16,
  field_left = 17,
  field_module_name = 18,
  field_name = 19,
  field_object = 20,
  field_operator = 21,
  field_operators = 22,
  field_parameters = 23,
  field_pattern = 24,
  field_return_type = 25,
  field_right = 26,
  field_subject = 27,
  field_subscript = 28,
  field_superclasses = 29,
  field_type = 30,
  field_type_conversion = 31,
  field_value = 32,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_cause] = "cause",
  [field_code] = "code",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_definition] = "definition",
  [field_expression] = "expression",
  [field_format_specifier] = "format_specifier",
  [field_function] = "function",
  [field_guard] = "guard",
  [field_key] = "key",
  [field_left] = "left",
  [field_module_name] = "module_name",
  [field_name] = "name",
  [field_object] = "object",
  [field_operator] = "operator",
  [field_operators] = "operators",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_subject] = "subject",
  [field_subscript] = "subscript",
  [field_superclasses] = "superclasses",
  [field_type] = "type",
  [field_type_conversion] = "type_conversion",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [3] = {.index = 0, .length = 1},
  [4] = {.index = 1, .length = 1},
  [6] = {.index = 2, .length = 1},
  [7] = {.index = 3, .length = 1},
  [8] = {.index = 4, .length = 1},
  [9] = {.index = 5, .length = 2},
  [10] = {.index = 7, .length = 2},
  [11] = {.index = 9, .length = 1},
  [12] = {.index = 10, .length = 1},
  [13] = {.index = 11, .length = 2},
  [14] = {.index = 13, .length = 1},
  [15] = {.index = 14, .length = 2},
  [16] = {.index = 16, .length = 1},
  [17] = {.index = 17, .length = 1},
  [18] = {.index = 18, .length = 2},
  [19] = {.index = 20, .length = 2},
  [20] = {.index = 22, .length = 2},
  [21] = {.index = 24, .length = 3},
  [22] = {.index = 27, .length = 1},
  [23] = {.index = 28, .length = 2},
  [24] = {.index = 30, .length = 1},
  [25] = {.index = 31, .length = 2},
  [26] = {.index = 33, .length = 1},
  [27] = {.index = 34, .length = 1},
  [28] = {.index = 35, .length = 2},
  [29] = {.index = 37, .length = 2},
  [30] = {.index = 39, .length = 1},
  [31] = {.index = 40, .length = 2},
  [32] = {.index = 42, .length = 1},
  [34] = {.index = 43, .length = 1},
  [35] = {.index = 44, .length = 2},
  [36] = {.index = 46, .length = 1},
  [37] = {.index = 47, .length = 2},
  [38] = {.index = 49, .length = 1},
  [39] = {.index = 50, .length = 3},
  [40] = {.index = 53, .length = 2},
  [41] = {.index = 55, .length = 2},
  [42] = {.index = 17, .length = 1},
  [43] = {.index = 57, .length = 1},
  [44] = {.index = 58, .length = 2},
  [45] = {.index = 60, .length = 1},
  [46] = {.index = 61, .length = 2},
  [47] = {.index = 63, .length = 2},
  [48] = {.index = 65, .length = 2},
  [49] = {.index = 67, .length = 2},
  [50] = {.index = 67, .length = 2},
  [52] = {.index = 69, .length = 2},
  [53] = {.index = 71, .length = 2},
  [54] = {.index = 73, .length = 1},
  [55] = {.index = 74, .length = 3},
  [56] = {.index = 77, .length = 3},
  [57] = {.index = 80, .length = 3},
  [58] = {.index = 83, .length = 3},
  [59] = {.index = 86, .length = 4},
  [60] = {.index = 90, .length = 1},
  [61] = {.index = 91, .length = 3},
  [62] = {.index = 94, .length = 3},
  [63] = {.index = 97, .length = 2},
  [64] = {.index = 99, .length = 2},
  [65] = {.index = 101, .length = 3},
  [66] = {.index = 104, .length = 3},
  [67] = {.index = 107, .length = 3},
  [68] = {.index = 110, .length = 3},
  [69] = {.index = 18, .length = 2},
  [70] = {.index = 113, .length = 1},
  [71] = {.index = 114, .length = 3},
  [72] = {.index = 117, .length = 2},
  [73] = {.index = 119, .length = 2},
  [74] = {.index = 121, .length = 2},
  [75] = {.index = 123, .length = 3},
  [76] = {.index = 126, .length = 1},
  [77] = {.index = 127, .length = 2},
  [78] = {.index = 129, .length = 2},
  [79] = {.index = 131, .length = 4},
  [80] = {.index = 135, .length = 2},
  [81] = {.index = 137, .length = 4},
  [82] = {.index = 141, .length = 4},
  [83] = {.index = 145, .length = 1},
  [84] = {.index = 146, .length = 4},
  [85] = {.index = 150, .length = 2},
  [86] = {.index = 152, .length = 3},
  [87] = {.index = 155, .length = 3},
  [88] = {.index = 158, .length = 4},
  [90] = {.index = 162, .length = 4},
  [91] = {.index = 166, .length = 4},
  [92] = {.index = 170, .length = 3},
  [93] = {.index = 173, .length = 3},
  [94] = {.index = 176, .length = 2},
  [95] = {.index = 178, .length = 3},
  [96] = {.index = 181, .length = 5},
  [97] = {.index = 186, .length = 3},
  [98] = {.index = 189, .length = 4},
  [99] = {.index = 193, .length = 4},
  [100] = {.index = 197, .length = 4},
  [102] = {.index = 201, .length = 4},
  [103] = {.index = 205, .length = 3},
  [104] = {.index = 208, .length = 1},
  [105] = {.index = 209, .length = 2},
  [106] = {.index = 211, .length = 2},
  [107] = {.index = 213, .length = 4},
  [108] = {.index = 217, .length = 4},
  [109] = {.index = 221, .length = 4},
  [110] = {.index = 225, .length = 5},
  [111] = {.index = 230, .length = 5},
  [112] = {.index = 235, .length = 2},
  [113] = {.index = 237, .length = 3},
  [114] = {.index = 240, .length = 3},
  [115] = {.index = 243, .length = 3},
  [116] = {.index = 246, .length = 5},
  [117] = {.index = 251, .length = 5},
  [119] = {.index = 256, .length = 3},
  [120] = {.index = 259, .length = 3},
  [121] = {.index = 262, .length = 4},
  [122] = {.index = 266, .length = 3},
  [123] = {.index = 269, .length = 4},
  [124] = {.index = 273, .length = 4},
  [125] = {.index = 277, .length = 4},
  [126] = {.index = 281, .length = 4},
  [127] = {.index = 285, .length = 4},
  [128] = {.index = 289, .length = 5},
  [129] = {.index = 294, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1, .inherited = true},
  [1] =
    {field_name, 0},
  [2] =
    {field_argument, 1},
  [3] =
    {field_value, 0},
  [4] =
    {field_code, 1},
  [5] =
    {field_argument, 1},
    {field_operator, 0},
  [7] =
    {field_arguments, 1},
    {field_function, 0},
  [9] =
    {field_operators, 1, .inherited = true},
  [10] =
    {field_definition, 1},
  [11] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
  [13] =
    {field_argument, 2, .inherited = true},
  [14] =
    {field_argument, 1},
    {field_argument, 2, .inherited = true},
  [16] =
    {field_cause, 2},
  [17] =
    {field_body, 2},
  [18] =
    {field_name, 0},
    {field_value, 2},
  [20] =
    {field_left, 0},
    {field_type, 2},
  [22] =
    {field_left, 0},
    {field_right, 2},
  [24] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [27] =
    {field_alias, 2},
  [28] =
    {field_attribute, 2},
    {field_object, 0},
  [30] =
    {field_operators, 0},
  [31] =
    {field_operators, 0, .inherited = true},
    {field_operators, 1, .inherited = true},
  [33] =
    {field_expression, 1},
  [34] =
    {field_name, 1},
  [35] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [37] =
    {field_alias, 2},
    {field_name, 0},
  [39] =
    {field_name, 3, .inherited = true},
  [40] =
    {field_module_name, 1},
    {field_name, 3, .inherited = true},
  [42] =
    {field_module_name, 1},
  [43] =
    {field_body, 1},
  [44] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [46] =
    {field_cause, 3},
  [47] =
    {field_condition, 1},
    {field_consequence, 3},
  [49] =
    {field_subject, 1},
  [50] =
    {field_alternative, 3, .inherited = true},
    {field_body, 3},
    {field_subject, 1},
  [53] =
    {field_subject, 0, .inherited = true},
    {field_subject, 1, .inherited = true},
  [55] =
    {field_body, 3},
    {field_condition, 1},
  [57] =
    {field_body, 3},
  [58] =
    {field_body, 3},
    {field_name, 1},
  [60] =
    {field_type, 2},
  [61] =
    {field_body, 3},
    {field_parameters, 1},
  [63] =
    {field_key, 0},
    {field_value, 2},
  [65] =
    {field_subscript, 2},
    {field_value, 0},
  [67] =
    {field_operators, 0},
    {field_operators, 1},
  [69] =
    {field_expression, 1},
    {field_type_conversion, 2},
  [71] =
    {field_expression, 1},
    {field_format_specifier, 2},
  [73] =
    {field_alternative, 0},
  [74] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 3},
  [77] =
    {field_alternative, 4, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
  [80] =
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [83] =
    {field_alternative, 4, .inherited = true},
    {field_body, 4},
    {field_subject, 1},
  [86] =
    {field_alternative, 4, .inherited = true},
    {field_body, 4},
    {field_subject, 1},
    {field_subject, 2, .inherited = true},
  [90] =
    {field_body, 4},
  [91] =
    {field_alternative, 4},
    {field_body, 3},
    {field_condition, 1},
  [94] =
    {field_body, 3},
    {field_body, 4},
    {field_condition, 1},
  [97] =
    {field_body, 2},
    {field_body, 3},
  [99] =
    {field_body, 3},
    {field_body, 4},
  [101] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 2},
  [104] =
    {field_body, 3},
    {field_body, 4},
    {field_name, 1},
  [107] =
    {field_body, 4},
    {field_name, 1},
    {field_superclasses, 2},
  [110] =
    {field_left, 0},
    {field_right, 4},
    {field_type, 2},
  [113] =
    {field_subscript, 1},
  [114] =
    {field_subscript, 2},
    {field_subscript, 3, .inherited = true},
    {field_value, 0},
  [117] =
    {field_subscript, 0, .inherited = true},
    {field_subscript, 1, .inherited = true},
  [119] =
    {field_expression, 1},
    {field_type_conversion, 3},
  [121] =
    {field_expression, 1},
    {field_format_specifier, 3},
  [123] =
    {field_expression, 1},
    {field_format_specifier, 3},
    {field_type_conversion, 2},
  [126] =
    {field_name, 4, .inherited = true},
  [127] =
    {field_module_name, 1},
    {field_name, 4, .inherited = true},
  [129] =
    {field_left, 1},
    {field_right, 3},
  [131] =
    {field_alternative, 4, .inherited = true},
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
  [135] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
  [137] =
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [141] =
    {field_alternative, 5, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [145] =
    {field_alternative, 1, .inherited = true},
  [146] =
    {field_alternative, 5, .inherited = true},
    {field_body, 5},
    {field_subject, 1},
    {field_subject, 2, .inherited = true},
  [150] =
    {field_body, 4},
    {field_body, 5},
  [152] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 3},
  [155] =
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [158] =
    {field_alternative, 5},
    {field_body, 3},
    {field_body, 4},
    {field_condition, 1},
  [162] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 2},
  [166] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_superclasses, 2},
  [170] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 4},
  [173] =
    {field_expression, 1},
    {field_format_specifier, 4},
    {field_type_conversion, 3},
  [176] =
    {field_left, 2},
    {field_right, 4},
  [178] =
    {field_left, 1},
    {field_right, 3},
    {field_right, 4},
  [181] =
    {field_alternative, 5, .inherited = true},
    {field_alternative, 6},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [186] =
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [189] =
    {field_body, 5},
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 3},
  [193] =
    {field_alternative, 6},
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [197] =
    {field_body, 5},
    {field_body, 6},
    {field_left, 1},
    {field_right, 3},
  [201] =
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [205] =
    {field_left, 2},
    {field_right, 4},
    {field_right, 5},
  [208] =
    {field_pattern, 1},
  [209] =
    {field_consequence, 3},
    {field_pattern, 1},
  [211] =
    {field_pattern, 0, .inherited = true},
    {field_pattern, 1, .inherited = true},
  [213] =
    {field_alternative, 7},
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [217] =
    {field_body, 6},
    {field_body, 7},
    {field_left, 2},
    {field_right, 4},
  [221] =
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [225] =
    {field_alternative, 7},
    {field_body, 5},
    {field_body, 6},
    {field_left, 1},
    {field_right, 3},
  [230] =
    {field_body, 6},
    {field_body, 7},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [235] =
    {field_consequence, 4},
    {field_pattern, 1},
  [237] =
    {field_consequence, 3},
    {field_consequence, 4},
    {field_pattern, 1},
  [240] =
    {field_consequence, 4},
    {field_guard, 2},
    {field_pattern, 1},
  [243] =
    {field_consequence, 4},
    {field_pattern, 1},
    {field_pattern, 2, .inherited = true},
  [246] =
    {field_alternative, 8},
    {field_body, 6},
    {field_body, 7},
    {field_left, 2},
    {field_right, 4},
  [251] =
    {field_body, 7},
    {field_body, 8},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [256] =
    {field_consequence, 4},
    {field_consequence, 5},
    {field_pattern, 1},
  [259] =
    {field_consequence, 5},
    {field_guard, 3},
    {field_pattern, 1},
  [262] =
    {field_consequence, 4},
    {field_consequence, 5},
    {field_guard, 2},
    {field_pattern, 1},
  [266] =
    {field_consequence, 5},
    {field_pattern, 1},
    {field_pattern, 2, .inherited = true},
  [269] =
    {field_consequence, 4},
    {field_consequence, 5},
    {field_pattern, 1},
    {field_pattern, 2, .inherited = true},
  [273] =
    {field_consequence, 5},
    {field_guard, 3},
    {field_pattern, 1},
    {field_pattern, 2, .inherited = true},
  [277] =
    {field_consequence, 5},
    {field_consequence, 6},
    {field_guard, 3},
    {field_pattern, 1},
  [281] =
    {field_consequence, 5},
    {field_consequence, 6},
    {field_pattern, 1},
    {field_pattern, 2, .inherited = true},
  [285] =
    {field_consequence, 6},
    {field_guard, 4},
    {field_pattern, 1},
    {field_pattern, 2, .inherited = true},
  [289] =
    {field_consequence, 5},
    {field_consequence, 6},
    {field_guard, 3},
    {field_pattern, 1},
    {field_pattern, 2, .inherited = true},
  [294] =
    {field_consequence, 6},
    {field_consequence, 7},
    {field_guard, 4},
    {field_pattern, 1},
    {field_pattern, 2, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [2] = {
    [0] = sym_list_splat,
  },
  [5] = {
    [1] = sym_identifier,
  },
  [22] = {
    [2] = alias_sym_as_pattern_target,
  },
  [33] = {
    [1] = sym_parenthesized_expression,
  },
  [37] = {
    [3] = sym_block,
  },
  [41] = {
    [3] = sym_block,
  },
  [42] = {
    [2] = sym_block,
  },
  [43] = {
    [3] = sym_block,
  },
  [44] = {
    [3] = sym_block,
  },
  [49] = {
    [0] = anon_alias_sym_notin,
    [1] = anon_alias_sym_notin,
  },
  [50] = {
    [0] = anon_alias_sym_isnot,
    [1] = anon_alias_sym_isnot,
  },
  [51] = {
    [0] = alias_sym_format_expression,
  },
  [55] = {
    [3] = sym_block,
  },
  [56] = {
    [3] = sym_block,
  },
  [60] = {
    [4] = sym_block,
  },
  [61] = {
    [3] = sym_block,
  },
  [65] = {
    [4] = sym_block,
  },
  [67] = {
    [4] = sym_block,
  },
  [69] = {
    [0] = sym_identifier,
  },
  [79] = {
    [3] = sym_block,
  },
  [86] = {
    [5] = sym_block,
  },
  [87] = {
    [5] = sym_block,
  },
  [89] = {
    [2] = sym_block,
  },
  [97] = {
    [6] = sym_block,
  },
  [99] = {
    [5] = sym_block,
  },
  [101] = {
    [3] = sym_block,
  },
  [102] = {
    [6] = sym_block,
  },
  [104] = {
    [1] = alias_sym_case_pattern,
  },
  [105] = {
    [1] = alias_sym_case_pattern,
    [3] = sym_block,
  },
  [107] = {
    [6] = sym_block,
  },
  [109] = {
    [7] = sym_block,
  },
  [112] = {
    [1] = alias_sym_case_pattern,
    [4] = sym_block,
  },
  [113] = {
    [1] = alias_sym_case_pattern,
  },
  [114] = {
    [1] = alias_sym_case_pattern,
    [4] = sym_block,
  },
  [115] = {
    [1] = alias_sym_case_pattern,
    [4] = sym_block,
  },
  [118] = {
    [5] = sym_block,
  },
  [119] = {
    [1] = alias_sym_case_pattern,
  },
  [120] = {
    [1] = alias_sym_case_pattern,
    [5] = sym_block,
  },
  [121] = {
    [1] = alias_sym_case_pattern,
  },
  [122] = {
    [1] = alias_sym_case_pattern,
    [5] = sym_block,
  },
  [123] = {
    [1] = alias_sym_case_pattern,
  },
  [124] = {
    [1] = alias_sym_case_pattern,
    [5] = sym_block,
  },
  [125] = {
    [1] = alias_sym_case_pattern,
  },
  [126] = {
    [1] = alias_sym_case_pattern,
  },
  [127] = {
    [1] = alias_sym_case_pattern,
    [6] = sym_block,
  },
  [128] = {
    [1] = alias_sym_case_pattern,
  },
  [129] = {
    [1] = alias_sym_case_pattern,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__simple_statements, 2,
    sym__simple_statements,
    sym_block,
  sym_parenthesized_list_splat, 2,
    sym_parenthesized_list_splat,
    sym_parenthesized_expression,
  sym_list_splat_pattern, 2,
    sym_list_splat_pattern,
    sym_list_splat,
  sym_expression, 3,
    sym_expression,
    alias_sym_as_pattern_target,
    alias_sym_case_pattern,
  sym_interpolation, 2,
    sym_interpolation,
    alias_sym_format_expression,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 7,
  [11] = 8,
  [12] = 12,
  [13] = 12,
  [14] = 14,
  [15] = 3,
  [16] = 9,
  [17] = 6,
  [18] = 18,
  [19] = 2,
  [20] = 20,
  [21] = 21,
  [22] = 14,
  [23] = 23,
  [24] = 20,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 5,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 18,
  [36] = 36,
  [37] = 4,
  [38] = 33,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 25,
  [45] = 34,
  [46] = 26,
  [47] = 31,
  [48] = 32,
  [49] = 36,
  [50] = 23,
  [51] = 28,
  [52] = 52,
  [53] = 53,
  [54] = 53,
  [55] = 53,
  [56] = 53,
  [57] = 53,
  [58] = 53,
  [59] = 59,
  [60] = 53,
  [61] = 59,
  [62] = 53,
  [63] = 63,
  [64] = 64,
  [65] = 64,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 67,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 77,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 76,
  [87] = 68,
  [88] = 88,
  [89] = 89,
  [90] = 88,
  [91] = 80,
  [92] = 79,
  [93] = 93,
  [94] = 94,
  [95] = 84,
  [96] = 96,
  [97] = 97,
  [98] = 73,
  [99] = 66,
  [100] = 74,
  [101] = 75,
  [102] = 69,
  [103] = 103,
  [104] = 97,
  [105] = 89,
  [106] = 106,
  [107] = 107,
  [108] = 103,
  [109] = 96,
  [110] = 85,
  [111] = 111,
  [112] = 83,
  [113] = 72,
  [114] = 114,
  [115] = 115,
  [116] = 115,
  [117] = 114,
  [118] = 114,
  [119] = 115,
  [120] = 114,
  [121] = 114,
  [122] = 115,
  [123] = 114,
  [124] = 115,
  [125] = 114,
  [126] = 115,
  [127] = 115,
  [128] = 115,
  [129] = 114,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 132,
  [134] = 131,
  [135] = 135,
  [136] = 135,
  [137] = 137,
  [138] = 132,
  [139] = 135,
  [140] = 135,
  [141] = 141,
  [142] = 142,
  [143] = 142,
  [144] = 132,
  [145] = 131,
  [146] = 142,
  [147] = 135,
  [148] = 142,
  [149] = 141,
  [150] = 141,
  [151] = 132,
  [152] = 131,
  [153] = 135,
  [154] = 137,
  [155] = 155,
  [156] = 132,
  [157] = 135,
  [158] = 135,
  [159] = 142,
  [160] = 142,
  [161] = 142,
  [162] = 142,
  [163] = 155,
  [164] = 132,
  [165] = 165,
  [166] = 165,
  [167] = 167,
  [168] = 168,
  [169] = 168,
  [170] = 165,
  [171] = 165,
  [172] = 168,
  [173] = 167,
  [174] = 167,
  [175] = 175,
  [176] = 167,
  [177] = 168,
  [178] = 165,
  [179] = 168,
  [180] = 165,
  [181] = 168,
  [182] = 165,
  [183] = 167,
  [184] = 168,
  [185] = 167,
  [186] = 186,
  [187] = 165,
  [188] = 165,
  [189] = 167,
  [190] = 175,
  [191] = 191,
  [192] = 167,
  [193] = 165,
  [194] = 194,
  [195] = 168,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 198,
  [200] = 200,
  [201] = 197,
  [202] = 202,
  [203] = 200,
  [204] = 196,
  [205] = 205,
  [206] = 206,
  [207] = 200,
  [208] = 200,
  [209] = 200,
  [210] = 200,
  [211] = 200,
  [212] = 200,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 213,
  [219] = 214,
  [220] = 215,
  [221] = 216,
  [222] = 213,
  [223] = 223,
  [224] = 224,
  [225] = 214,
  [226] = 223,
  [227] = 217,
  [228] = 216,
  [229] = 213,
  [230] = 216,
  [231] = 217,
  [232] = 215,
  [233] = 224,
  [234] = 215,
  [235] = 216,
  [236] = 217,
  [237] = 215,
  [238] = 216,
  [239] = 216,
  [240] = 215,
  [241] = 213,
  [242] = 217,
  [243] = 215,
  [244] = 224,
  [245] = 214,
  [246] = 223,
  [247] = 213,
  [248] = 223,
  [249] = 224,
  [250] = 224,
  [251] = 214,
  [252] = 224,
  [253] = 223,
  [254] = 217,
  [255] = 213,
  [256] = 214,
  [257] = 215,
  [258] = 216,
  [259] = 214,
  [260] = 217,
  [261] = 213,
  [262] = 223,
  [263] = 223,
  [264] = 217,
  [265] = 223,
  [266] = 214,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 155,
  [273] = 273,
  [274] = 268,
  [275] = 275,
  [276] = 276,
  [277] = 273,
  [278] = 278,
  [279] = 267,
  [280] = 275,
  [281] = 278,
  [282] = 268,
  [283] = 278,
  [284] = 275,
  [285] = 269,
  [286] = 267,
  [287] = 273,
  [288] = 269,
  [289] = 289,
  [290] = 205,
  [291] = 291,
  [292] = 289,
  [293] = 291,
  [294] = 289,
  [295] = 205,
  [296] = 291,
  [297] = 297,
  [298] = 291,
  [299] = 289,
  [300] = 289,
  [301] = 301,
  [302] = 297,
  [303] = 289,
  [304] = 291,
  [305] = 289,
  [306] = 205,
  [307] = 289,
  [308] = 291,
  [309] = 291,
  [310] = 297,
  [311] = 291,
  [312] = 312,
  [313] = 313,
  [314] = 312,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 132,
  [320] = 313,
  [321] = 312,
  [322] = 313,
  [323] = 313,
  [324] = 315,
  [325] = 313,
  [326] = 315,
  [327] = 327,
  [328] = 315,
  [329] = 312,
  [330] = 312,
  [331] = 315,
  [332] = 313,
  [333] = 315,
  [334] = 312,
  [335] = 313,
  [336] = 315,
  [337] = 313,
  [338] = 315,
  [339] = 339,
  [340] = 312,
  [341] = 271,
  [342] = 313,
  [343] = 343,
  [344] = 315,
  [345] = 312,
  [346] = 346,
  [347] = 312,
  [348] = 276,
  [349] = 313,
  [350] = 312,
  [351] = 315,
  [352] = 352,
  [353] = 353,
  [354] = 354,
  [355] = 353,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 359,
  [364] = 359,
  [365] = 359,
  [366] = 276,
  [367] = 357,
  [368] = 359,
  [369] = 359,
  [370] = 361,
  [371] = 359,
  [372] = 271,
  [373] = 359,
  [374] = 374,
  [375] = 375,
  [376] = 155,
  [377] = 377,
  [378] = 378,
  [379] = 361,
  [380] = 380,
  [381] = 132,
  [382] = 382,
  [383] = 353,
  [384] = 346,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 357,
  [389] = 389,
  [390] = 390,
  [391] = 386,
  [392] = 377,
  [393] = 271,
  [394] = 354,
  [395] = 378,
  [396] = 359,
  [397] = 155,
  [398] = 398,
  [399] = 276,
  [400] = 400,
  [401] = 380,
  [402] = 402,
  [403] = 377,
  [404] = 354,
  [405] = 359,
  [406] = 155,
  [407] = 407,
  [408] = 408,
  [409] = 276,
  [410] = 410,
  [411] = 410,
  [412] = 412,
  [413] = 413,
  [414] = 407,
  [415] = 408,
  [416] = 416,
  [417] = 412,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 420,
  [425] = 419,
  [426] = 416,
  [427] = 271,
  [428] = 422,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 429,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 439,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 430,
  [444] = 444,
  [445] = 441,
  [446] = 446,
  [447] = 447,
  [448] = 430,
  [449] = 449,
  [450] = 441,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 431,
  [458] = 442,
  [459] = 459,
  [460] = 460,
  [461] = 438,
  [462] = 436,
  [463] = 435,
  [464] = 442,
  [465] = 454,
  [466] = 451,
  [467] = 453,
  [468] = 430,
  [469] = 469,
  [470] = 456,
  [471] = 432,
  [472] = 430,
  [473] = 459,
  [474] = 474,
  [475] = 475,
  [476] = 454,
  [477] = 454,
  [478] = 475,
  [479] = 451,
  [480] = 436,
  [481] = 451,
  [482] = 482,
  [483] = 459,
  [484] = 475,
  [485] = 435,
  [486] = 430,
  [487] = 442,
  [488] = 453,
  [489] = 430,
  [490] = 436,
  [491] = 449,
  [492] = 452,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 435,
  [497] = 475,
  [498] = 451,
  [499] = 494,
  [500] = 435,
  [501] = 454,
  [502] = 431,
  [503] = 435,
  [504] = 504,
  [505] = 459,
  [506] = 442,
  [507] = 431,
  [508] = 475,
  [509] = 509,
  [510] = 493,
  [511] = 511,
  [512] = 512,
  [513] = 441,
  [514] = 453,
  [515] = 432,
  [516] = 456,
  [517] = 435,
  [518] = 447,
  [519] = 432,
  [520] = 520,
  [521] = 459,
  [522] = 446,
  [523] = 436,
  [524] = 441,
  [525] = 451,
  [526] = 453,
  [527] = 430,
  [528] = 454,
  [529] = 451,
  [530] = 482,
  [531] = 475,
  [532] = 454,
  [533] = 453,
  [534] = 534,
  [535] = 459,
  [536] = 442,
  [537] = 441,
  [538] = 456,
  [539] = 453,
  [540] = 432,
  [541] = 541,
  [542] = 435,
  [543] = 475,
  [544] = 459,
  [545] = 441,
  [546] = 442,
  [547] = 442,
  [548] = 459,
  [549] = 454,
  [550] = 436,
  [551] = 451,
  [552] = 439,
  [553] = 504,
  [554] = 554,
  [555] = 453,
  [556] = 556,
  [557] = 444,
  [558] = 475,
  [559] = 441,
  [560] = 512,
  [561] = 561,
  [562] = 562,
  [563] = 563,
  [564] = 564,
  [565] = 565,
  [566] = 566,
  [567] = 567,
  [568] = 568,
  [569] = 569,
  [570] = 570,
  [571] = 571,
  [572] = 572,
  [573] = 573,
  [574] = 574,
  [575] = 575,
  [576] = 574,
  [577] = 575,
  [578] = 578,
  [579] = 565,
  [580] = 568,
  [581] = 581,
  [582] = 582,
  [583] = 564,
  [584] = 584,
  [585] = 585,
  [586] = 586,
  [587] = 573,
  [588] = 588,
  [589] = 588,
  [590] = 590,
  [591] = 591,
  [592] = 592,
  [593] = 593,
  [594] = 590,
  [595] = 595,
  [596] = 596,
  [597] = 593,
  [598] = 598,
  [599] = 599,
  [600] = 600,
  [601] = 591,
  [602] = 602,
  [603] = 603,
  [604] = 590,
  [605] = 591,
  [606] = 595,
  [607] = 607,
  [608] = 607,
  [609] = 598,
  [610] = 592,
  [611] = 603,
  [612] = 595,
  [613] = 613,
  [614] = 596,
  [615] = 600,
  [616] = 616,
  [617] = 613,
  [618] = 618,
  [619] = 591,
  [620] = 600,
  [621] = 595,
  [622] = 591,
  [623] = 602,
  [624] = 595,
  [625] = 618,
  [626] = 616,
  [627] = 600,
  [628] = 618,
  [629] = 197,
  [630] = 618,
  [631] = 599,
  [632] = 600,
  [633] = 618,
  [634] = 600,
  [635] = 618,
  [636] = 590,
  [637] = 590,
  [638] = 196,
  [639] = 591,
  [640] = 595,
  [641] = 590,
  [642] = 642,
  [643] = 643,
  [644] = 644,
  [645] = 645,
  [646] = 646,
  [647] = 647,
  [648] = 648,
  [649] = 649,
  [650] = 650,
  [651] = 646,
  [652] = 652,
  [653] = 653,
  [654] = 643,
  [655] = 647,
  [656] = 644,
  [657] = 653,
  [658] = 652,
  [659] = 648,
  [660] = 645,
  [661] = 650,
  [662] = 649,
  [663] = 642,
  [664] = 664,
  [665] = 665,
  [666] = 666,
  [667] = 664,
  [668] = 665,
  [669] = 666,
  [670] = 670,
  [671] = 671,
  [672] = 672,
  [673] = 673,
  [674] = 674,
  [675] = 675,
  [676] = 671,
  [677] = 677,
  [678] = 678,
  [679] = 679,
  [680] = 680,
  [681] = 681,
  [682] = 670,
  [683] = 683,
  [684] = 684,
  [685] = 685,
  [686] = 686,
  [687] = 687,
  [688] = 688,
  [689] = 689,
  [690] = 690,
  [691] = 691,
  [692] = 692,
  [693] = 693,
  [694] = 694,
  [695] = 692,
  [696] = 696,
  [697] = 697,
  [698] = 698,
  [699] = 699,
  [700] = 700,
  [701] = 701,
  [702] = 702,
  [703] = 703,
  [704] = 689,
  [705] = 688,
  [706] = 706,
  [707] = 690,
  [708] = 708,
  [709] = 693,
  [710] = 687,
  [711] = 711,
  [712] = 685,
  [713] = 713,
  [714] = 675,
  [715] = 674,
  [716] = 673,
  [717] = 717,
  [718] = 718,
  [719] = 677,
  [720] = 717,
  [721] = 713,
  [722] = 722,
  [723] = 723,
  [724] = 724,
  [725] = 725,
  [726] = 726,
  [727] = 678,
  [728] = 728,
  [729] = 729,
  [730] = 697,
  [731] = 718,
  [732] = 708,
  [733] = 733,
  [734] = 734,
  [735] = 735,
  [736] = 734,
  [737] = 729,
  [738] = 700,
  [739] = 728,
  [740] = 740,
  [741] = 722,
  [742] = 733,
  [743] = 683,
  [744] = 726,
  [745] = 703,
  [746] = 684,
  [747] = 196,
  [748] = 711,
  [749] = 679,
  [750] = 680,
  [751] = 681,
  [752] = 686,
  [753] = 735,
  [754] = 706,
  [755] = 691,
  [756] = 694,
  [757] = 725,
  [758] = 693,
  [759] = 708,
  [760] = 702,
  [761] = 197,
  [762] = 701,
  [763] = 740,
  [764] = 723,
  [765] = 672,
  [766] = 696,
  [767] = 724,
  [768] = 698,
  [769] = 699,
  [770] = 770,
  [771] = 770,
  [772] = 770,
  [773] = 770,
  [774] = 770,
  [775] = 770,
  [776] = 776,
  [777] = 776,
  [778] = 778,
  [779] = 778,
  [780] = 778,
  [781] = 778,
  [782] = 778,
  [783] = 778,
  [784] = 778,
  [785] = 778,
  [786] = 786,
  [787] = 787,
  [788] = 788,
  [789] = 789,
  [790] = 790,
  [791] = 791,
  [792] = 792,
  [793] = 793,
  [794] = 786,
  [795] = 793,
  [796] = 787,
  [797] = 786,
  [798] = 798,
  [799] = 786,
  [800] = 800,
  [801] = 801,
  [802] = 802,
  [803] = 803,
  [804] = 803,
  [805] = 802,
  [806] = 801,
  [807] = 800,
  [808] = 798,
  [809] = 791,
  [810] = 790,
  [811] = 789,
  [812] = 786,
  [813] = 788,
  [814] = 787,
  [815] = 788,
  [816] = 787,
  [817] = 789,
  [818] = 790,
  [819] = 791,
  [820] = 803,
  [821] = 788,
  [822] = 802,
  [823] = 801,
  [824] = 800,
  [825] = 798,
  [826] = 787,
  [827] = 786,
  [828] = 786,
  [829] = 786,
  [830] = 793,
  [831] = 788,
  [832] = 788,
  [833] = 786,
  [834] = 793,
  [835] = 789,
  [836] = 786,
  [837] = 790,
  [838] = 790,
  [839] = 791,
  [840] = 803,
  [841] = 791,
  [842] = 803,
  [843] = 802,
  [844] = 801,
  [845] = 789,
  [846] = 790,
  [847] = 788,
  [848] = 800,
  [849] = 798,
  [850] = 787,
  [851] = 791,
  [852] = 802,
  [853] = 793,
  [854] = 801,
  [855] = 800,
  [856] = 786,
  [857] = 798,
  [858] = 803,
  [859] = 802,
  [860] = 793,
  [861] = 801,
  [862] = 800,
  [863] = 798,
  [864] = 789,
  [865] = 790,
  [866] = 791,
  [867] = 786,
  [868] = 803,
  [869] = 802,
  [870] = 801,
  [871] = 798,
  [872] = 800,
  [873] = 800,
  [874] = 801,
  [875] = 802,
  [876] = 787,
  [877] = 803,
  [878] = 791,
  [879] = 798,
  [880] = 793,
  [881] = 786,
  [882] = 789,
  [883] = 793,
  [884] = 790,
  [885] = 792,
  [886] = 788,
  [887] = 789,
  [888] = 787,
  [889] = 889,
  [890] = 890,
  [891] = 891,
  [892] = 889,
  [893] = 891,
  [894] = 894,
  [895] = 890,
  [896] = 891,
  [897] = 889,
  [898] = 890,
  [899] = 894,
  [900] = 894,
  [901] = 894,
  [902] = 902,
  [903] = 903,
  [904] = 890,
  [905] = 891,
  [906] = 567,
  [907] = 891,
  [908] = 908,
  [909] = 909,
  [910] = 910,
  [911] = 903,
  [912] = 581,
  [913] = 571,
  [914] = 902,
  [915] = 889,
  [916] = 584,
  [917] = 586,
  [918] = 563,
  [919] = 910,
  [920] = 920,
  [921] = 921,
  [922] = 922,
  [923] = 923,
  [924] = 924,
  [925] = 925,
  [926] = 909,
  [927] = 920,
  [928] = 924,
  [929] = 929,
  [930] = 921,
  [931] = 909,
  [932] = 922,
  [933] = 923,
  [934] = 890,
  [935] = 910,
  [936] = 920,
  [937] = 908,
  [938] = 891,
  [939] = 924,
  [940] = 925,
  [941] = 890,
  [942] = 903,
  [943] = 889,
  [944] = 929,
  [945] = 902,
  [946] = 922,
  [947] = 921,
  [948] = 923,
  [949] = 889,
  [950] = 585,
  [951] = 925,
  [952] = 929,
  [953] = 894,
  [954] = 908,
  [955] = 894,
  [956] = 908,
  [957] = 923,
  [958] = 958,
  [959] = 894,
  [960] = 922,
  [961] = 902,
  [962] = 921,
  [963] = 891,
  [964] = 925,
  [965] = 965,
  [966] = 903,
  [967] = 967,
  [968] = 968,
  [969] = 903,
  [970] = 902,
  [971] = 971,
  [972] = 922,
  [973] = 923,
  [974] = 924,
  [975] = 924,
  [976] = 925,
  [977] = 929,
  [978] = 921,
  [979] = 889,
  [980] = 958,
  [981] = 889,
  [982] = 908,
  [983] = 894,
  [984] = 929,
  [985] = 910,
  [986] = 921,
  [987] = 929,
  [988] = 988,
  [989] = 989,
  [990] = 925,
  [991] = 991,
  [992] = 924,
  [993] = 923,
  [994] = 922,
  [995] = 902,
  [996] = 903,
  [997] = 909,
  [998] = 958,
  [999] = 890,
  [1000] = 561,
  [1001] = 890,
  [1002] = 920,
  [1003] = 967,
  [1004] = 988,
  [1005] = 909,
  [1006] = 965,
  [1007] = 967,
  [1008] = 988,
  [1009] = 920,
  [1010] = 890,
  [1011] = 891,
  [1012] = 909,
  [1013] = 908,
  [1014] = 910,
  [1015] = 920,
  [1016] = 910,
  [1017] = 965,
  [1018] = 562,
  [1019] = 1019,
  [1020] = 1020,
  [1021] = 1020,
  [1022] = 561,
  [1023] = 890,
  [1024] = 1024,
  [1025] = 1025,
  [1026] = 1026,
  [1027] = 991,
  [1028] = 989,
  [1029] = 1029,
  [1030] = 1030,
  [1031] = 569,
  [1032] = 1032,
  [1033] = 1033,
  [1034] = 1034,
  [1035] = 988,
  [1036] = 1036,
  [1037] = 1037,
  [1038] = 1038,
  [1039] = 1039,
  [1040] = 958,
  [1041] = 1041,
  [1042] = 1042,
  [1043] = 1043,
  [1044] = 562,
  [1045] = 1045,
  [1046] = 1046,
  [1047] = 570,
  [1048] = 569,
  [1049] = 910,
  [1050] = 908,
  [1051] = 1051,
  [1052] = 1052,
  [1053] = 1053,
  [1054] = 903,
  [1055] = 902,
  [1056] = 922,
  [1057] = 923,
  [1058] = 924,
  [1059] = 925,
  [1060] = 929,
  [1061] = 921,
  [1062] = 1053,
  [1063] = 1052,
  [1064] = 1064,
  [1065] = 1065,
  [1066] = 909,
  [1067] = 920,
  [1068] = 1029,
  [1069] = 570,
  [1070] = 890,
  [1071] = 563,
  [1072] = 586,
  [1073] = 584,
  [1074] = 571,
  [1075] = 585,
  [1076] = 581,
  [1077] = 910,
  [1078] = 908,
  [1079] = 567,
  [1080] = 903,
  [1081] = 902,
  [1082] = 563,
  [1083] = 586,
  [1084] = 922,
  [1085] = 923,
  [1086] = 1086,
  [1087] = 924,
  [1088] = 925,
  [1089] = 929,
  [1090] = 921,
  [1091] = 585,
  [1092] = 909,
  [1093] = 920,
  [1094] = 570,
  [1095] = 890,
  [1096] = 1019,
  [1097] = 1086,
  [1098] = 1065,
  [1099] = 1064,
  [1100] = 1051,
  [1101] = 1046,
  [1102] = 1045,
  [1103] = 1043,
  [1104] = 1042,
  [1105] = 1041,
  [1106] = 1039,
  [1107] = 584,
  [1108] = 1038,
  [1109] = 1037,
  [1110] = 567,
  [1111] = 571,
  [1112] = 581,
  [1113] = 1036,
  [1114] = 1034,
  [1115] = 562,
  [1116] = 1033,
  [1117] = 1032,
  [1118] = 1030,
  [1119] = 1026,
  [1120] = 581,
  [1121] = 571,
  [1122] = 584,
  [1123] = 988,
  [1124] = 561,
  [1125] = 1029,
  [1126] = 965,
  [1127] = 586,
  [1128] = 563,
  [1129] = 1025,
  [1130] = 967,
  [1131] = 1024,
  [1132] = 967,
  [1133] = 965,
  [1134] = 1020,
  [1135] = 1019,
  [1136] = 1086,
  [1137] = 1065,
  [1138] = 1064,
  [1139] = 1051,
  [1140] = 1046,
  [1141] = 1045,
  [1142] = 1043,
  [1143] = 1042,
  [1144] = 1041,
  [1145] = 1039,
  [1146] = 1038,
  [1147] = 958,
  [1148] = 991,
  [1149] = 989,
  [1150] = 1037,
  [1151] = 1036,
  [1152] = 1034,
  [1153] = 1033,
  [1154] = 1032,
  [1155] = 1030,
  [1156] = 570,
  [1157] = 958,
  [1158] = 1026,
  [1159] = 965,
  [1160] = 967,
  [1161] = 567,
  [1162] = 1052,
  [1163] = 1053,
  [1164] = 1025,
  [1165] = 1024,
  [1166] = 572,
  [1167] = 569,
  [1168] = 988,
  [1169] = 578,
  [1170] = 582,
  [1171] = 585,
  [1172] = 566,
  [1173] = 566,
  [1174] = 570,
  [1175] = 1019,
  [1176] = 1043,
  [1177] = 1086,
  [1178] = 569,
  [1179] = 1025,
  [1180] = 1042,
  [1181] = 1038,
  [1182] = 1041,
  [1183] = 1039,
  [1184] = 1041,
  [1185] = 1042,
  [1186] = 1043,
  [1187] = 967,
  [1188] = 965,
  [1189] = 1045,
  [1190] = 1039,
  [1191] = 1046,
  [1192] = 1030,
  [1193] = 1037,
  [1194] = 988,
  [1195] = 1038,
  [1196] = 1026,
  [1197] = 1020,
  [1198] = 1065,
  [1199] = 958,
  [1200] = 1053,
  [1201] = 1052,
  [1202] = 1065,
  [1203] = 1030,
  [1204] = 1032,
  [1205] = 1036,
  [1206] = 578,
  [1207] = 566,
  [1208] = 582,
  [1209] = 1024,
  [1210] = 1033,
  [1211] = 1086,
  [1212] = 1029,
  [1213] = 1034,
  [1214] = 1034,
  [1215] = 1036,
  [1216] = 1033,
  [1217] = 569,
  [1218] = 570,
  [1219] = 1019,
  [1220] = 1064,
  [1221] = 572,
  [1222] = 1222,
  [1223] = 1025,
  [1224] = 1029,
  [1225] = 1024,
  [1226] = 585,
  [1227] = 1037,
  [1228] = 1032,
  [1229] = 1045,
  [1230] = 570,
  [1231] = 563,
  [1232] = 586,
  [1233] = 1051,
  [1234] = 1052,
  [1235] = 1053,
  [1236] = 584,
  [1237] = 571,
  [1238] = 581,
  [1239] = 971,
  [1240] = 1038,
  [1241] = 968,
  [1242] = 1037,
  [1243] = 1039,
  [1244] = 567,
  [1245] = 1041,
  [1246] = 1042,
  [1247] = 1043,
  [1248] = 988,
  [1249] = 1045,
  [1250] = 1046,
  [1251] = 567,
  [1252] = 1020,
  [1253] = 569,
  [1254] = 958,
  [1255] = 1026,
  [1256] = 1051,
  [1257] = 1025,
  [1258] = 1064,
  [1259] = 1065,
  [1260] = 581,
  [1261] = 571,
  [1262] = 584,
  [1263] = 1086,
  [1264] = 1019,
  [1265] = 586,
  [1266] = 563,
  [1267] = 1026,
  [1268] = 578,
  [1269] = 1064,
  [1270] = 566,
  [1271] = 570,
  [1272] = 578,
  [1273] = 1029,
  [1274] = 965,
  [1275] = 967,
  [1276] = 582,
  [1277] = 585,
  [1278] = 572,
  [1279] = 572,
  [1280] = 582,
  [1281] = 1024,
  [1282] = 570,
  [1283] = 1036,
  [1284] = 1052,
  [1285] = 1020,
  [1286] = 1034,
  [1287] = 1051,
  [1288] = 1053,
  [1289] = 1030,
  [1290] = 1032,
  [1291] = 1046,
  [1292] = 1033,
  [1293] = 1086,
  [1294] = 1019,
  [1295] = 569,
  [1296] = 1024,
  [1297] = 1025,
  [1298] = 1026,
  [1299] = 991,
  [1300] = 989,
  [1301] = 1042,
  [1302] = 1030,
  [1303] = 1026,
  [1304] = 1029,
  [1305] = 991,
  [1306] = 989,
  [1307] = 989,
  [1308] = 991,
  [1309] = 1038,
  [1310] = 1032,
  [1311] = 1036,
  [1312] = 1052,
  [1313] = 570,
  [1314] = 1020,
  [1315] = 1033,
  [1316] = 1053,
  [1317] = 1034,
  [1318] = 1034,
  [1319] = 1036,
  [1320] = 585,
  [1321] = 1037,
  [1322] = 1041,
  [1323] = 1038,
  [1324] = 1039,
  [1325] = 1041,
  [1326] = 1033,
  [1327] = 1029,
  [1328] = 1053,
  [1329] = 1042,
  [1330] = 1045,
  [1331] = 1020,
  [1332] = 1052,
  [1333] = 1032,
  [1334] = 563,
  [1335] = 586,
  [1336] = 584,
  [1337] = 571,
  [1338] = 1030,
  [1339] = 569,
  [1340] = 1025,
  [1341] = 1046,
  [1342] = 581,
  [1343] = 1024,
  [1344] = 585,
  [1345] = 1043,
  [1346] = 1037,
  [1347] = 567,
  [1348] = 570,
  [1349] = 567,
  [1350] = 1065,
  [1351] = 1043,
  [1352] = 1064,
  [1353] = 1051,
  [1354] = 1064,
  [1355] = 1039,
  [1356] = 563,
  [1357] = 586,
  [1358] = 1019,
  [1359] = 1086,
  [1360] = 584,
  [1361] = 571,
  [1362] = 581,
  [1363] = 1051,
  [1364] = 1065,
  [1365] = 1045,
  [1366] = 1046,
  [1367] = 566,
  [1368] = 571,
  [1369] = 570,
  [1370] = 569,
  [1371] = 563,
  [1372] = 572,
  [1373] = 1222,
  [1374] = 570,
  [1375] = 586,
  [1376] = 584,
  [1377] = 570,
  [1378] = 581,
  [1379] = 567,
  [1380] = 582,
  [1381] = 578,
  [1382] = 570,
  [1383] = 585,
  [1384] = 1222,
  [1385] = 582,
  [1386] = 566,
  [1387] = 572,
  [1388] = 578,
  [1389] = 1389,
  [1390] = 1389,
  [1391] = 1391,
  [1392] = 1391,
  [1393] = 1389,
  [1394] = 1391,
  [1395] = 1391,
  [1396] = 569,
  [1397] = 1389,
  [1398] = 1398,
  [1399] = 1389,
  [1400] = 1391,
  [1401] = 1391,
  [1402] = 1402,
  [1403] = 1403,
  [1404] = 570,
  [1405] = 1405,
  [1406] = 1389,
  [1407] = 566,
  [1408] = 1408,
  [1409] = 1222,
  [1410] = 1389,
  [1411] = 1411,
  [1412] = 1222,
  [1413] = 1408,
  [1414] = 569,
  [1415] = 1415,
  [1416] = 1408,
  [1417] = 566,
  [1418] = 1408,
  [1419] = 1408,
  [1420] = 1391,
  [1421] = 1421,
  [1422] = 1389,
  [1423] = 578,
  [1424] = 1222,
  [1425] = 572,
  [1426] = 1426,
  [1427] = 572,
  [1428] = 582,
  [1429] = 1408,
  [1430] = 1408,
  [1431] = 572,
  [1432] = 578,
  [1433] = 1402,
  [1434] = 1391,
  [1435] = 570,
  [1436] = 1403,
  [1437] = 582,
  [1438] = 566,
  [1439] = 578,
  [1440] = 1408,
  [1441] = 1408,
  [1442] = 1408,
  [1443] = 582,
  [1444] = 1444,
  [1445] = 1445,
  [1446] = 1445,
  [1447] = 1411,
  [1448] = 1448,
  [1449] = 1426,
  [1450] = 1445,
  [1451] = 1405,
  [1452] = 1445,
  [1453] = 1415,
  [1454] = 1454,
  [1455] = 1445,
  [1456] = 1448,
  [1457] = 1445,
  [1458] = 1454,
  [1459] = 1445,
  [1460] = 1454,
  [1461] = 1421,
  [1462] = 1445,
  [1463] = 1398,
  [1464] = 1464,
  [1465] = 1465,
  [1466] = 1466,
  [1467] = 1467,
  [1468] = 1467,
  [1469] = 1466,
  [1470] = 1470,
  [1471] = 1470,
  [1472] = 1472,
  [1473] = 1472,
  [1474] = 1472,
  [1475] = 1472,
  [1476] = 1472,
  [1477] = 1472,
  [1478] = 1472,
  [1479] = 1472,
  [1480] = 1480,
  [1481] = 1481,
  [1482] = 1480,
  [1483] = 1481,
  [1484] = 1480,
  [1485] = 1480,
  [1486] = 1481,
  [1487] = 1481,
  [1488] = 1488,
  [1489] = 1481,
  [1490] = 1480,
  [1491] = 1488,
  [1492] = 1488,
  [1493] = 1488,
  [1494] = 1481,
  [1495] = 1488,
  [1496] = 1481,
  [1497] = 1480,
  [1498] = 1488,
  [1499] = 1481,
  [1500] = 1488,
  [1501] = 1480,
  [1502] = 1480,
  [1503] = 1488,
  [1504] = 1504,
  [1505] = 1505,
  [1506] = 1506,
  [1507] = 1506,
  [1508] = 1505,
  [1509] = 1505,
  [1510] = 1506,
  [1511] = 1506,
  [1512] = 1505,
  [1513] = 1506,
  [1514] = 1514,
  [1515] = 1506,
  [1516] = 1505,
  [1517] = 1506,
  [1518] = 1506,
  [1519] = 1519,
  [1520] = 1505,
  [1521] = 1505,
  [1522] = 1506,
  [1523] = 1505,
  [1524] = 1524,
  [1525] = 1505,
  [1526] = 1526,
  [1527] = 1526,
  [1528] = 1528,
  [1529] = 1529,
  [1530] = 1530,
  [1531] = 1530,
  [1532] = 1532,
  [1533] = 1533,
  [1534] = 1534,
  [1535] = 1535,
  [1536] = 1528,
  [1537] = 1537,
  [1538] = 1538,
  [1539] = 1539,
  [1540] = 1539,
  [1541] = 1541,
  [1542] = 1535,
  [1543] = 1535,
  [1544] = 1528,
  [1545] = 1541,
  [1546] = 1534,
  [1547] = 1541,
  [1548] = 1526,
  [1549] = 1533,
  [1550] = 1532,
  [1551] = 1539,
  [1552] = 1530,
  [1553] = 1534,
  [1554] = 1532,
  [1555] = 1533,
  [1556] = 1541,
  [1557] = 1557,
  [1558] = 1558,
  [1559] = 1532,
  [1560] = 1557,
  [1561] = 1561,
  [1562] = 1557,
  [1563] = 1535,
  [1564] = 1534,
  [1565] = 1532,
  [1566] = 1533,
  [1567] = 1541,
  [1568] = 1568,
  [1569] = 1569,
  [1570] = 1534,
  [1571] = 1557,
  [1572] = 1558,
  [1573] = 1557,
  [1574] = 1574,
  [1575] = 1561,
  [1576] = 1514,
  [1577] = 1541,
  [1578] = 1539,
  [1579] = 1579,
  [1580] = 1580,
  [1581] = 1539,
  [1582] = 1569,
  [1583] = 1574,
  [1584] = 1532,
  [1585] = 1585,
  [1586] = 1586,
  [1587] = 1533,
  [1588] = 1557,
  [1589] = 1528,
  [1590] = 1533,
  [1591] = 1591,
  [1592] = 1535,
  [1593] = 1528,
  [1594] = 1558,
  [1595] = 1530,
  [1596] = 1557,
  [1597] = 1534,
  [1598] = 1557,
  [1599] = 1599,
  [1600] = 1530,
  [1601] = 1579,
  [1602] = 1526,
  [1603] = 1569,
  [1604] = 1530,
  [1605] = 1605,
  [1606] = 1539,
  [1607] = 1537,
  [1608] = 1608,
  [1609] = 1528,
  [1610] = 1574,
  [1611] = 1611,
  [1612] = 1557,
  [1613] = 1557,
  [1614] = 1526,
  [1615] = 1535,
  [1616] = 1526,
  [1617] = 1617,
  [1618] = 1568,
  [1619] = 1619,
  [1620] = 1535,
  [1621] = 1621,
  [1622] = 1526,
  [1623] = 1534,
  [1624] = 1533,
  [1625] = 1625,
  [1626] = 1621,
  [1627] = 1532,
  [1628] = 1514,
  [1629] = 1629,
  [1630] = 1621,
  [1631] = 1631,
  [1632] = 1632,
  [1633] = 1633,
  [1634] = 1633,
  [1635] = 1541,
  [1636] = 1539,
  [1637] = 1637,
  [1638] = 1632,
  [1639] = 1639,
  [1640] = 1640,
  [1641] = 1641,
  [1642] = 1625,
  [1643] = 1643,
  [1644] = 1632,
  [1645] = 1645,
  [1646] = 1646,
  [1647] = 1528,
  [1648] = 1530,
  [1649] = 1649,
  [1650] = 1625,
  [1651] = 1651,
  [1652] = 1652,
  [1653] = 1539,
  [1654] = 1645,
  [1655] = 1625,
  [1656] = 1528,
  [1657] = 1657,
  [1658] = 1530,
  [1659] = 1625,
  [1660] = 1541,
  [1661] = 1645,
  [1662] = 1514,
  [1663] = 1637,
  [1664] = 1625,
  [1665] = 1649,
  [1666] = 1532,
  [1667] = 1533,
  [1668] = 1534,
  [1669] = 1637,
  [1670] = 1526,
  [1671] = 1625,
  [1672] = 1649,
  [1673] = 1625,
  [1674] = 1535,
  [1675] = 1675,
  [1676] = 1643,
  [1677] = 1675,
  [1678] = 1678,
  [1679] = 1679,
  [1680] = 1680,
  [1681] = 1681,
  [1682] = 1585,
  [1683] = 1683,
  [1684] = 1684,
  [1685] = 1685,
  [1686] = 1405,
  [1687] = 1687,
  [1688] = 1688,
  [1689] = 1689,
  [1690] = 1690,
  [1691] = 1691,
  [1692] = 1529,
  [1693] = 1681,
  [1694] = 1537,
  [1695] = 1695,
  [1696] = 1696,
  [1697] = 1696,
  [1698] = 1685,
  [1699] = 1699,
  [1700] = 1700,
  [1701] = 1678,
  [1702] = 1702,
  [1703] = 1703,
  [1704] = 1704,
  [1705] = 1681,
  [1706] = 1684,
  [1707] = 1703,
  [1708] = 1708,
  [1709] = 1529,
  [1710] = 1710,
  [1711] = 1689,
  [1712] = 1712,
  [1713] = 1713,
  [1714] = 1714,
  [1715] = 1715,
  [1716] = 1716,
  [1717] = 1696,
  [1718] = 1702,
  [1719] = 1719,
  [1720] = 1537,
  [1721] = 1721,
  [1722] = 1722,
  [1723] = 1691,
  [1724] = 1724,
  [1725] = 1529,
  [1726] = 1690,
  [1727] = 1727,
  [1728] = 1691,
  [1729] = 1685,
  [1730] = 1689,
  [1731] = 1724,
  [1732] = 1732,
  [1733] = 1733,
  [1734] = 1398,
  [1735] = 1735,
  [1736] = 1724,
  [1737] = 1537,
  [1738] = 1702,
  [1739] = 1739,
  [1740] = 1739,
  [1741] = 1741,
  [1742] = 1742,
  [1743] = 1743,
  [1744] = 1744,
  [1745] = 1704,
  [1746] = 1746,
  [1747] = 1680,
  [1748] = 1748,
  [1749] = 1749,
  [1750] = 1744,
  [1751] = 1751,
  [1752] = 1752,
  [1753] = 1746,
  [1754] = 1754,
  [1755] = 1755,
  [1756] = 1756,
  [1757] = 1757,
  [1758] = 1744,
  [1759] = 1744,
  [1760] = 1760,
  [1761] = 1751,
  [1762] = 1426,
  [1763] = 1763,
  [1764] = 1764,
  [1765] = 1765,
  [1766] = 1744,
  [1767] = 1767,
  [1768] = 1744,
  [1769] = 1411,
  [1770] = 1751,
  [1771] = 1771,
  [1772] = 1715,
  [1773] = 1415,
  [1774] = 1744,
  [1775] = 1744,
  [1776] = 1776,
  [1777] = 1777,
  [1778] = 1778,
  [1779] = 1765,
  [1780] = 1780,
  [1781] = 1781,
  [1782] = 1757,
  [1783] = 1421,
  [1784] = 1754,
  [1785] = 1752,
  [1786] = 1771,
  [1787] = 1778,
  [1788] = 1788,
  [1789] = 1789,
  [1790] = 1649,
  [1791] = 1791,
  [1792] = 1765,
  [1793] = 1683,
  [1794] = 1776,
  [1795] = 1757,
  [1796] = 1679,
  [1797] = 1797,
  [1798] = 1756,
  [1799] = 1799,
  [1800] = 1800,
  [1801] = 1748,
  [1802] = 1802,
  [1803] = 1800,
  [1804] = 1804,
  [1805] = 1805,
  [1806] = 1806,
  [1807] = 1807,
  [1808] = 1808,
  [1809] = 1809,
  [1810] = 1810,
  [1811] = 1811,
  [1812] = 1763,
  [1813] = 1813,
  [1814] = 1814,
  [1815] = 1815,
  [1816] = 1816,
  [1817] = 1817,
  [1818] = 1797,
  [1819] = 1811,
  [1820] = 1820,
  [1821] = 1788,
  [1822] = 1822,
  [1823] = 1823,
  [1824] = 1755,
  [1825] = 1825,
  [1826] = 1826,
  [1827] = 1827,
  [1828] = 1828,
  [1829] = 1829,
  [1830] = 1830,
  [1831] = 1831,
  [1832] = 1832,
  [1833] = 1833,
  [1834] = 1834,
  [1835] = 1835,
  [1836] = 1836,
  [1837] = 1837,
  [1838] = 1838,
  [1839] = 600,
  [1840] = 1840,
  [1841] = 1841,
  [1842] = 1842,
  [1843] = 1843,
  [1844] = 1844,
  [1845] = 1845,
  [1846] = 1846,
  [1847] = 1847,
  [1848] = 1841,
  [1849] = 1714,
  [1850] = 618,
  [1851] = 1851,
  [1852] = 1716,
  [1853] = 1704,
  [1854] = 1854,
  [1855] = 1679,
  [1856] = 1743,
  [1857] = 1857,
  [1858] = 1858,
  [1859] = 1859,
  [1860] = 1860,
  [1861] = 1861,
  [1862] = 1741,
  [1863] = 1863,
  [1864] = 1844,
  [1865] = 1865,
  [1866] = 958,
  [1867] = 1867,
  [1868] = 1844,
  [1869] = 1869,
  [1870] = 1715,
  [1871] = 1871,
  [1872] = 1872,
  [1873] = 1873,
  [1874] = 1874,
  [1875] = 1843,
  [1876] = 1860,
  [1877] = 1834,
  [1878] = 1840,
  [1879] = 1704,
  [1880] = 1865,
  [1881] = 1881,
  [1882] = 988,
  [1883] = 1835,
  [1884] = 1884,
  [1885] = 1411,
  [1886] = 1735,
  [1887] = 1887,
  [1888] = 1887,
  [1889] = 1854,
  [1890] = 1823,
  [1891] = 1884,
  [1892] = 1835,
  [1893] = 1893,
  [1894] = 1704,
  [1895] = 1895,
  [1896] = 1829,
  [1897] = 1897,
  [1898] = 1898,
  [1899] = 590,
  [1900] = 1683,
  [1901] = 595,
  [1902] = 1902,
  [1903] = 1874,
  [1904] = 1904,
  [1905] = 1843,
  [1906] = 1836,
  [1907] = 1841,
  [1908] = 1398,
  [1909] = 1909,
  [1910] = 1910,
  [1911] = 1858,
  [1912] = 1834,
  [1913] = 1913,
  [1914] = 1854,
  [1915] = 1915,
  [1916] = 1898,
  [1917] = 1897,
  [1918] = 1918,
  [1919] = 1841,
  [1920] = 1920,
  [1921] = 1887,
  [1922] = 1922,
  [1923] = 1713,
  [1924] = 1898,
  [1925] = 1854,
  [1926] = 1897,
  [1927] = 591,
  [1928] = 1834,
  [1929] = 1887,
  [1930] = 1874,
  [1931] = 1838,
  [1932] = 1932,
  [1933] = 1933,
  [1934] = 1863,
  [1935] = 1863,
  [1936] = 1898,
  [1937] = 1897,
  [1938] = 1867,
  [1939] = 1895,
  [1940] = 1857,
  [1941] = 1893,
  [1942] = 1942,
  [1943] = 1909,
  [1944] = 1944,
  [1945] = 1834,
  [1946] = 1887,
  [1947] = 1867,
  [1948] = 1884,
  [1949] = 1835,
  [1950] = 1405,
  [1951] = 1835,
  [1952] = 1884,
  [1953] = 1834,
  [1954] = 1954,
  [1955] = 1887,
  [1956] = 1898,
  [1957] = 1897,
  [1958] = 1902,
  [1959] = 1913,
  [1960] = 1867,
  [1961] = 1893,
  [1962] = 1863,
  [1963] = 1895,
  [1964] = 1895,
  [1965] = 1897,
  [1966] = 1898,
  [1967] = 1854,
  [1968] = 1841,
  [1969] = 1893,
  [1970] = 1846,
  [1971] = 1872,
  [1972] = 1808,
  [1973] = 1973,
  [1974] = 1974,
  [1975] = 1975,
  [1976] = 1873,
  [1977] = 1898,
  [1978] = 1978,
  [1979] = 1841,
  [1980] = 1897,
  [1981] = 1895,
  [1982] = 1398,
  [1983] = 1732,
  [1984] = 1893,
  [1985] = 1854,
  [1986] = 1863,
  [1987] = 1987,
  [1988] = 1887,
  [1989] = 1989,
  [1990] = 1884,
  [1991] = 1835,
  [1992] = 1834,
  [1993] = 1867,
  [1994] = 1863,
  [1995] = 1995,
  [1996] = 1867,
  [1997] = 1837,
  [1998] = 1867,
  [1999] = 1863,
  [2000] = 1989,
  [2001] = 1854,
  [2002] = 1841,
  [2003] = 1954,
  [2004] = 1987,
  [2005] = 1715,
  [2006] = 1974,
  [2007] = 1944,
  [2008] = 1898,
  [2009] = 1973,
  [2010] = 1898,
  [2011] = 1835,
  [2012] = 1884,
  [2013] = 1831,
  [2014] = 1893,
  [2015] = 1887,
  [2016] = 1845,
  [2017] = 1871,
  [2018] = 1895,
  [2019] = 1897,
  [2020] = 1893,
  [2021] = 1895,
  [2022] = 1895,
  [2023] = 1712,
  [2024] = 1897,
  [2025] = 1898,
  [2026] = 1893,
  [2027] = 1680,
  [2028] = 1863,
  [2029] = 1834,
  [2030] = 1884,
  [2031] = 1884,
  [2032] = 1865,
  [2033] = 1851,
  [2034] = 1867,
  [2035] = 1871,
  [2036] = 1830,
  [2037] = 1861,
  [2038] = 1841,
  [2039] = 1897,
  [2040] = 2040,
  [2041] = 1887,
  [2042] = 1828,
  [2043] = 1854,
  [2044] = 1715,
  [2045] = 1835,
  [2046] = 1873,
  [2047] = 1398,
  [2048] = 1887,
  [2049] = 1872,
  [2050] = 2050,
  [2051] = 1426,
  [2052] = 618,
  [2053] = 2053,
  [2054] = 591,
  [2055] = 1847,
  [2056] = 2056,
  [2057] = 2057,
  [2058] = 1842,
  [2059] = 2059,
  [2060] = 2060,
  [2061] = 1749,
  [2062] = 1749,
  [2063] = 2063,
  [2064] = 2064,
  [2065] = 2065,
  [2066] = 2066,
  [2067] = 2067,
  [2068] = 2068,
  [2069] = 2069,
  [2070] = 2070,
  [2071] = 2071,
  [2072] = 595,
  [2073] = 2073,
  [2074] = 2074,
  [2075] = 2075,
  [2076] = 2076,
  [2077] = 2077,
  [2078] = 1748,
  [2079] = 2079,
  [2080] = 2080,
  [2081] = 2081,
  [2082] = 2082,
  [2083] = 2083,
  [2084] = 2084,
  [2085] = 2085,
  [2086] = 2086,
  [2087] = 2087,
  [2088] = 2088,
  [2089] = 2089,
  [2090] = 1415,
  [2091] = 2081,
  [2092] = 2092,
  [2093] = 2093,
  [2094] = 2094,
  [2095] = 2095,
  [2096] = 2096,
  [2097] = 2097,
  [2098] = 2098,
  [2099] = 1421,
  [2100] = 1411,
  [2101] = 2074,
  [2102] = 2102,
  [2103] = 1426,
  [2104] = 2098,
  [2105] = 2105,
  [2106] = 590,
  [2107] = 2107,
  [2108] = 1415,
  [2109] = 2077,
  [2110] = 2110,
  [2111] = 2111,
  [2112] = 2074,
  [2113] = 2089,
  [2114] = 2114,
  [2115] = 2115,
  [2116] = 2116,
  [2117] = 2117,
  [2118] = 2118,
  [2119] = 2119,
  [2120] = 2120,
  [2121] = 1421,
  [2122] = 2122,
  [2123] = 2123,
  [2124] = 2124,
  [2125] = 2067,
  [2126] = 2070,
  [2127] = 2075,
  [2128] = 2081,
  [2129] = 2065,
  [2130] = 2107,
  [2131] = 2131,
  [2132] = 2077,
  [2133] = 2076,
  [2134] = 2134,
  [2135] = 600,
  [2136] = 2136,
  [2137] = 1749,
  [2138] = 1922,
  [2139] = 2093,
  [2140] = 2140,
  [2141] = 2141,
  [2142] = 2142,
  [2143] = 2143,
  [2144] = 2144,
  [2145] = 2145,
  [2146] = 2146,
  [2147] = 2147,
  [2148] = 2148,
  [2149] = 2149,
  [2150] = 2150,
  [2151] = 2151,
  [2152] = 2152,
  [2153] = 2148,
  [2154] = 2154,
  [2155] = 2155,
  [2156] = 2145,
  [2157] = 2157,
  [2158] = 2158,
  [2159] = 2159,
  [2160] = 2147,
  [2161] = 2161,
  [2162] = 2142,
  [2163] = 2141,
  [2164] = 2158,
  [2165] = 2165,
  [2166] = 2166,
  [2167] = 2142,
  [2168] = 2149,
  [2169] = 2165,
  [2170] = 2170,
  [2171] = 2171,
  [2172] = 2172,
  [2173] = 2173,
  [2174] = 2166,
  [2175] = 2175,
  [2176] = 2175,
  [2177] = 2177,
  [2178] = 2172,
  [2179] = 2179,
  [2180] = 2173,
  [2181] = 2172,
  [2182] = 2165,
  [2183] = 2183,
  [2184] = 2149,
  [2185] = 2141,
  [2186] = 2142,
  [2187] = 2159,
  [2188] = 2166,
  [2189] = 2189,
  [2190] = 2190,
  [2191] = 2158,
  [2192] = 2192,
  [2193] = 2193,
  [2194] = 2147,
  [2195] = 2195,
  [2196] = 2147,
  [2197] = 2197,
  [2198] = 2166,
  [2199] = 2159,
  [2200] = 2158,
  [2201] = 2170,
  [2202] = 2172,
  [2203] = 2145,
  [2204] = 2149,
  [2205] = 2146,
  [2206] = 2206,
  [2207] = 2158,
  [2208] = 2166,
  [2209] = 2170,
  [2210] = 2173,
  [2211] = 2211,
  [2212] = 2148,
  [2213] = 2175,
  [2214] = 2214,
  [2215] = 2215,
  [2216] = 2145,
  [2217] = 2141,
  [2218] = 2173,
  [2219] = 2146,
  [2220] = 2172,
  [2221] = 2147,
  [2222] = 2148,
  [2223] = 2192,
  [2224] = 2141,
  [2225] = 2165,
  [2226] = 2226,
  [2227] = 2149,
  [2228] = 2142,
  [2229] = 2166,
  [2230] = 2144,
  [2231] = 2166,
  [2232] = 2177,
  [2233] = 2155,
  [2234] = 2141,
  [2235] = 2235,
  [2236] = 2170,
  [2237] = 2237,
  [2238] = 2238,
  [2239] = 2145,
  [2240] = 2240,
  [2241] = 2147,
  [2242] = 2206,
  [2243] = 2214,
  [2244] = 2238,
  [2245] = 2159,
  [2246] = 2246,
  [2247] = 2215,
  [2248] = 2189,
  [2249] = 2158,
  [2250] = 2166,
  [2251] = 2190,
  [2252] = 2179,
  [2253] = 2171,
  [2254] = 2142,
  [2255] = 2175,
  [2256] = 2240,
  [2257] = 2237,
  [2258] = 2145,
  [2259] = 2175,
  [2260] = 2173,
  [2261] = 2146,
  [2262] = 2172,
  [2263] = 2235,
  [2264] = 2165,
  [2265] = 2206,
  [2266] = 2149,
  [2267] = 2179,
  [2268] = 2157,
  [2269] = 2142,
  [2270] = 2166,
  [2271] = 2149,
  [2272] = 2165,
  [2273] = 2141,
  [2274] = 2148,
  [2275] = 2165,
  [2276] = 2172,
  [2277] = 2277,
  [2278] = 2147,
  [2279] = 2279,
  [2280] = 2280,
  [2281] = 2159,
  [2282] = 2282,
  [2283] = 2158,
  [2284] = 2173,
  [2285] = 2170,
  [2286] = 2175,
  [2287] = 2287,
  [2288] = 2157,
  [2289] = 2145,
  [2290] = 2146,
  [2291] = 2287,
  [2292] = 2159,
  [2293] = 2159,
  [2294] = 2173,
  [2295] = 2148,
  [2296] = 2154,
  [2297] = 2175,
  [2298] = 2175,
  [2299] = 2173,
  [2300] = 2300,
  [2301] = 2172,
  [2302] = 2302,
  [2303] = 2303,
  [2304] = 2304,
  [2305] = 2165,
  [2306] = 2149,
  [2307] = 2148,
  [2308] = 2142,
  [2309] = 2166,
  [2310] = 2310,
  [2311] = 2141,
  [2312] = 2312,
  [2313] = 2302,
  [2314] = 2314,
  [2315] = 2315,
  [2316] = 2316,
  [2317] = 2300,
  [2318] = 2147,
  [2319] = 2159,
  [2320] = 2158,
  [2321] = 2316,
  [2322] = 2151,
  [2323] = 2235,
  [2324] = 2195,
  [2325] = 2280,
  [2326] = 2326,
  [2327] = 2145,
  [2328] = 2211,
  [2329] = 2326,
  [2330] = 2148,
  [2331] = 2326,
};

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 931
            ? (c < 748
              ? (c < 192
                ? (c < 170
                  ? (c < 'a'
                    ? (c >= 'A' && c <= '_')
                    : c <= 'z')
                  : (c <= 170 || (c < 186
                    ? c == 181
                    : c <= 186)))
                : (c <= 214 || (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))))
              : (c <= 748 || (c < 895
                ? (c < 886
                  ? (c < 880
                    ? c == 750
                    : c <= 884)
                  : (c <= 887 || (c >= 891 && c <= 893)))
                : (c <= 895 || (c < 908
                  ? (c < 904
                    ? c == 902
                    : c <= 906)
                  : (c <= 908 || (c >= 910 && c <= 929)))))))
            : (c <= 1013 || (c < 1649
              ? (c < 1376
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1327)
                  : (c <= 1366 || c == 1369))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 910
            ? (c < 736
              ? (c < 186
                ? (c < 'a'
                  ? (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= '_')
                  : (c <= 'z' || (c < 181
                    ? c == 170
                    : c <= 181)))
                : (c <= 186 || (c < 248
                  ? (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))))
              : (c <= 740 || (c < 891
                ? (c < 880
                  ? (c < 750
                    ? c == 748
                    : c <= 750)
                  : (c <= 884 || (c >= 886 && c <= 887)))
                : (c <= 893 || (c < 904
                  ? (c < 902
                    ? c == 895
                    : c <= 902)
                  : (c <= 906 || c == 908))))))
            : (c <= 929 || (c < 1649
              ? (c < 1376
                ? (c < 1162
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1327 || (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_3(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2748
        ? (c < 2045
          ? (c < 1015
            ? (c < 710
              ? (c < 181
                ? (c < '_'
                  ? (c < 'A'
                    ? (c >= '0' && c <= '9')
                    : c <= 'Z')
                  : (c <= '_' || (c < 170
                    ? (c >= 'a' && c <= 'z')
                    : c <= 170)))
                : (c <= 181 || (c < 192
                  ? (c < 186
                    ? c == 183
                    : c <= 186)
                  : (c <= 214 || (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)))))
              : (c <= 721 || (c < 891
                ? (c < 750
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)
                  : (c <= 750 || (c < 886
                    ? (c >= 768 && c <= 884)
                    : c <= 887)))
                : (c <= 893 || (c < 908
                  ? (c < 902
                    ? c == 895
                    : c <= 906)
                  : (c <= 908 || (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)))))))
            : (c <= 1153 || (c < 1519
              ? (c < 1425
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1155 && c <= 1159)
                    : c <= 1327)
                  : (c <= 1366 || (c < 1376
                    ? c == 1369
                    : c <= 1416)))
                : (c <= 1469 || (c < 1476
                  ? (c < 1473
                    ? c == 1471
                    : c <= 1474)
                  : (c <= 1477 || (c < 1488
                    ? c == 1479
                    : c <= 1514)))))
              : (c <= 1522 || (c < 1770
                ? (c < 1646
                  ? (c < 1568
                    ? (c >= 1552 && c <= 1562)
                    : c <= 1641)
                  : (c <= 1747 || (c < 1759
                    ? (c >= 1749 && c <= 1756)
                    : c <= 1768)))
                : (c <= 1788 || (c < 1869
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1866)
                  : (c <= 1969 || (c < 2042
                    ? (c >= 1984 && c <= 2037)
                    : c <= 2042)))))))))
          : (c <= 2045 || (c < 2558
            ? (c < 2451
              ? (c < 2200
                ? (c < 2144
                  ? (c < 2112
                    ? (c >= 2048 && c <= 2093)
                    : c <= 2139)
                  : (c <= 2154 || (c < 2185
                    ? (c >= 2160 && c <= 2183)
                    : c <= 2190)))
                : (c <= 2273 || (c < 2417
                  ? (c < 2406
                    ? (c >= 2275 && c <= 2403)
                    : c <= 2415)
                  : (c <= 2435 || (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)))))
              : (c <= 2472 || (c < 2507
                ? (c < 2486
                  ? (c < 2482
                    ? (c >= 2474 && c <= 2480)
                    : c <= 2482)
                  : (c <= 2489 || (c < 2503
                    ? (c >= 2492 && c <= 2500)
                    : c <= 2504)))
                : (c <= 2510 || (c < 2527
                  ? (c < 2524
                    ? c == 2519
                    : c <= 2525)
                  : (c <= 2531 || (c < 2556
                    ? (c >= 2534 && c <= 2545)
                    : c <= 2556)))))))
            : (c <= 2558 || (c < 2635
              ? (c < 2610
                ? (c < 2575
                  ? (c < 2565
                    ? (c >= 2561 && c <= 2563)
                    : c <= 2570)
                  : (c <= 2576 || (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)))
                : (c <= 2611 || (c < 2620
                  ? (c < 2616
                    ? (c >= 2613 && c <= 2614)
                    : c <= 2617)
                  : (c <= 2620 || (c < 2631
                    ? (c >= 2622 && c <= 2626)
                    : c <= 2632)))))
              : (c <= 2637 || (c < 2693
                ? (c < 2654
                  ? (c < 2649
                    ? c == 2641
                    : c <= 2652)
                  : (c <= 2654 || (c < 2689
                    ? (c >= 2662 && c <= 2677)
                    : c <= 2691)))
                : (c <= 2701 || (c < 2730
                  ? (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)
                  : (c <= 2736 || (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)))))))))))
        : (c <= 2757 || (c < 3168
          ? (c < 2958
            ? (c < 2866
              ? (c < 2809
                ? (c < 2768
                  ? (c < 2763
                    ? (c >= 2759 && c <= 2761)
                    : c <= 2765)
                  : (c <= 2768 || (c < 2790
                    ? (c >= 2784 && c <= 2787)
                    : c <= 2799)))
                : (c <= 2815 || (c < 2831
                  ? (c < 2821
                    ? (c >= 2817 && c <= 2819)
                    : c <= 2828)
                  : (c <= 2832 || (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)))))
              : (c <= 2867 || (c < 2908
                ? (c < 2887
                  ? (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)
                  : (c <= 2888 || (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : c <= 2903)))
                : (c <= 2909 || (c < 2929
                  ? (c < 2918
                    ? (c >= 2911 && c <= 2915)
                    : c <= 2927)
                  : (c <= 2929 || (c < 2949
                    ? (c >= 2946 && c <= 2947)
                    : c <= 2954)))))))
            : (c <= 2960 || (c < 3031
              ? (c < 2984
                ? (c < 2972
                  ? (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)
                  : (c <= 2972 || (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)))
                : (c <= 2986 || (c < 3014
                  ? (c < 3006
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3010)
                  : (c <= 3016 || (c < 3024
                    ? (c >= 3018 && c <= 3021)
                    : c <= 3024)))))
              : (c <= 3031 || (c < 3132
                ? (c < 3086
                  ? (c < 3072
                    ? (c >= 3046 && c <= 3055)
                    : c <= 3084)
                  : (c <= 3088 || (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)))
                : (c <= 3140 || (c < 3157
                  ? (c < 3146
                    ? (c >= 3142 && c <= 3144)
                    : c <= 3149)
                  : (c <= 3158 || (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)))))))))
          : (c <= 3171 || (c < 3450
            ? (c < 3293
              ? (c < 3242
                ? (c < 3205
                  ? (c < 3200
                    ? (c >= 3174 && c <= 3183)
                    : c <= 3203)
                  : (c <= 3212 || (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)))
                : (c <= 3251 || (c < 3270
                  ? (c < 3260
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3268)
                  : (c <= 3272 || (c < 3285
                    ? (c >= 3274 && c <= 3277)
                    : c <= 3286)))))
              : (c <= 3294 || (c < 3346
                ? (c < 3313
                  ? (c < 3302
                    ? (c >= 3296 && c <= 3299)
                    : c <= 3311)
                  : (c <= 3314 || (c < 3342
                    ? (c >= 3328 && c <= 3340)
                    : c <= 3344)))
                : (c <= 3396 || (c < 3412
                  ? (c < 3402
                    ? (c >= 3398 && c <= 3400)
                    : c <= 3406)
                  : (c <= 3415 || (c < 3430
                    ? (c >= 3423 && c <= 3427)
                    : c <= 3439)))))))
            : (c <= 3455 || (c < 3570
              ? (c < 3520
                ? (c < 3482
                  ? (c < 3461
                    ? (c >= 3457 && c <= 3459)
                    : c <= 3478)
                  : (c <= 3505 || (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)))
                : (c <= 3526 || (c < 3542
                  ? (c < 3535
                    ? c == 3530
                    : c <= 3540)
                  : (c <= 3542 || (c < 3558
                    ? (c >= 3544 && c <= 3551)
                    : c <= 3567)))))
              : (c <= 3571 || (c < 3718
                ? (c < 3664
                  ? (c < 3648
                    ? (c >= 3585 && c <= 3642)
                    : c <= 3662)
                  : (c <= 3673 || (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)))
                : (c <= 3722 || (c < 3751
                  ? (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(60);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(56)
      if (lookahead == '\r') SKIP(56)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '#') ADVANCE(172);
      if (lookahead == '%') ADVANCE(96);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '(') ADVANCE(64);
      if (lookahead == ')') ADVANCE(65);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(89);
      if (lookahead == ',') ADVANCE(66);
      if (lookahead == '-') ADVANCE(92);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == '0') ADVANCE(145);
      if (lookahead == ':') ADVANCE(75);
      if (lookahead == ';') ADVANCE(61);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(116);
      if (lookahead == '@') ADVANCE(83);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(138);
      if (lookahead == ']') ADVANCE(85);
      if (lookahead == '^') ADVANCE(104);
      if (lookahead == 'e') ADVANCE(168);
      if (lookahead == '{') ADVANCE(133);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '}') ADVANCE(135);
      if (lookahead == '~') ADVANCE(107);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(144);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(171);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(173);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(137);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(3)
      if (lookahead == '\r') ADVANCE(140);
      if (lookahead == '#') ADVANCE(141);
      if (lookahead == '\\') ADVANCE(139);
      if (lookahead == '{') ADVANCE(133);
      if (lookahead == '}') ADVANCE(135);
      if (lookahead == '\t' ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(140);
      if (lookahead != 0) ADVANCE(141);
      END_STATE();
    case 4:
      if (lookahead == '.') ADVANCE(5);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(151);
      END_STATE();
    case 5:
      if (lookahead == '.') ADVANCE(132);
      END_STATE();
    case 6:
      if (lookahead == '/') ADVANCE(16);
      if (lookahead == '=') ADVANCE(122);
      END_STATE();
    case 7:
      if (lookahead == '<') ADVANCE(17);
      END_STATE();
    case 8:
      if (lookahead == '=') ADVANCE(113);
      END_STATE();
    case 9:
      if (lookahead == '=') ADVANCE(113);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 10:
      if (lookahead == '=') ADVANCE(125);
      END_STATE();
    case 11:
      if (lookahead == '=') ADVANCE(129);
      END_STATE();
    case 12:
      if (lookahead == '=') ADVANCE(123);
      END_STATE();
    case 13:
      if (lookahead == '=') ADVANCE(130);
      END_STATE();
    case 14:
      if (lookahead == '=') ADVANCE(131);
      END_STATE();
    case 15:
      if (lookahead == '=') ADVANCE(126);
      END_STATE();
    case 16:
      if (lookahead == '=') ADVANCE(124);
      END_STATE();
    case 17:
      if (lookahead == '=') ADVANCE(128);
      END_STATE();
    case 18:
      if (lookahead == '=') ADVANCE(127);
      END_STATE();
    case 19:
      if (lookahead == '>') ADVANCE(79);
      END_STATE();
    case 20:
      if (lookahead == '>') ADVANCE(18);
      END_STATE();
    case 21:
      if (lookahead == '_') ADVANCE(29);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(147);
      END_STATE();
    case 22:
      if (lookahead == '_') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(148);
      END_STATE();
    case 23:
      if (lookahead == '_') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(149);
      END_STATE();
    case 24:
      if (lookahead == '{') ADVANCE(55);
      END_STATE();
    case 25:
      if (lookahead == '}') ADVANCE(137);
      if (lookahead != 0) ADVANCE(25);
      END_STATE();
    case 26:
      if (lookahead == '}') ADVANCE(136);
      END_STATE();
    case 27:
      if (lookahead == 0 ||
          lookahead == '\n') ADVANCE(173);
      if (lookahead == '\r') ADVANCE(1);
      END_STATE();
    case 28:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(44);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(152);
      END_STATE();
    case 29:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(147);
      END_STATE();
    case 30:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(30)
      if (lookahead == '\r') SKIP(30)
      if (lookahead == '!') ADVANCE(8);
      if (lookahead == '#') ADVANCE(172);
      if (lookahead == '%') ADVANCE(96);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '(') ADVANCE(64);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(89);
      if (lookahead == ',') ADVANCE(66);
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == '0') ADVANCE(145);
      if (lookahead == ':') ADVANCE(75);
      if (lookahead == ';') ADVANCE(61);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(116);
      if (lookahead == '@') ADVANCE(83);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == '^') ADVANCE(104);
      if (lookahead == '{') ADVANCE(133);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '~') ADVANCE(107);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(144);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(171);
      END_STATE();
    case 31:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(31)
      if (lookahead == '\r') SKIP(31)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '#') ADVANCE(172);
      if (lookahead == '%') ADVANCE(95);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '(') ADVANCE(64);
      if (lookahead == ')') ADVANCE(65);
      if (lookahead == '*') ADVANCE(69);
      if (lookahead == '+') ADVANCE(88);
      if (lookahead == ',') ADVANCE(66);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '/') ADVANCE(94);
      if (lookahead == '0') ADVANCE(145);
      if (lookahead == ':') ADVANCE(74);
      if (lookahead == ';') ADVANCE(61);
      if (lookahead == '<') ADVANCE(109);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(117);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(85);
      if (lookahead == '^') ADVANCE(103);
      if (lookahead == '{') ADVANCE(133);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '}') ADVANCE(135);
      if (lookahead == '~') ADVANCE(107);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(144);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(171);
      END_STATE();
    case 32:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(32)
      if (lookahead == '\r') SKIP(32)
      if (lookahead == '#') ADVANCE(172);
      if (lookahead == '%') ADVANCE(10);
      if (lookahead == '&') ADVANCE(11);
      if (lookahead == '(') ADVANCE(64);
      if (lookahead == '*') ADVANCE(70);
      if (lookahead == '+') ADVANCE(89);
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '.') ADVANCE(4);
      if (lookahead == '/') ADVANCE(6);
      if (lookahead == '0') ADVANCE(145);
      if (lookahead == ':') ADVANCE(74);
      if (lookahead == ';') ADVANCE(61);
      if (lookahead == '<') ADVANCE(7);
      if (lookahead == '=') ADVANCE(86);
      if (lookahead == '>') ADVANCE(20);
      if (lookahead == '@') ADVANCE(12);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == '^') ADVANCE(13);
      if (lookahead == '{') ADVANCE(133);
      if (lookahead == '|') ADVANCE(14);
      if (lookahead == '~') ADVANCE(107);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(144);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(171);
      END_STATE();
    case 33:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(33)
      if (lookahead == '\r') SKIP(33)
      if (lookahead == '!') ADVANCE(8);
      if (lookahead == '#') ADVANCE(172);
      if (lookahead == '%') ADVANCE(96);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '(') ADVANCE(64);
      if (lookahead == ')') ADVANCE(65);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(89);
      if (lookahead == ',') ADVANCE(66);
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '.') ADVANCE(62);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == ':') ADVANCE(75);
      if (lookahead == ';') ADVANCE(61);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(116);
      if (lookahead == '@') ADVANCE(83);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == '^') ADVANCE(104);
      if (lookahead == '|') ADVANCE(100);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(171);
      END_STATE();
    case 34:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(34)
      if (lookahead == '\r') SKIP(34)
      if (lookahead == '!') ADVANCE(8);
      if (lookahead == '#') ADVANCE(172);
      if (lookahead == '%') ADVANCE(96);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '(') ADVANCE(64);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(89);
      if (lookahead == ',') ADVANCE(66);
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '.') ADVANCE(62);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == ':') ADVANCE(74);
      if (lookahead == ';') ADVANCE(61);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(116);
      if (lookahead == '@') ADVANCE(83);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == '^') ADVANCE(104);
      if (lookahead == '|') ADVANCE(100);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(171);
      END_STATE();
    case 35:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(35)
      if (lookahead == '\r') SKIP(35)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '#') ADVANCE(172);
      if (lookahead == '%') ADVANCE(95);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '(') ADVANCE(64);
      if (lookahead == ')') ADVANCE(65);
      if (lookahead == '*') ADVANCE(69);
      if (lookahead == '+') ADVANCE(88);
      if (lookahead == ',') ADVANCE(66);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead == '.') ADVANCE(62);
      if (lookahead == '/') ADVANCE(94);
      if (lookahead == ':') ADVANCE(74);
      if (lookahead == ';') ADVANCE(61);
      if (lookahead == '<') ADVANCE(109);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(117);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(85);
      if (lookahead == '^') ADVANCE(103);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '}') ADVANCE(135);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(171);
      END_STATE();
    case 36:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(37)
      if (lookahead == '\r') SKIP(37)
      if (lookahead == '#') ADVANCE(172);
      if (lookahead == '\\') ADVANCE(138);
      if (lookahead == '{') ADVANCE(134);
      if (lookahead == '}') ADVANCE(26);
      END_STATE();
    case 37:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(37)
      if (lookahead == '\r') SKIP(37)
      if (lookahead == '#') ADVANCE(172);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == '{') ADVANCE(133);
      END_STATE();
    case 38:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(38)
      if (lookahead == '\r') SKIP(38)
      if (lookahead == '#') ADVANCE(172);
      if (lookahead == '-') ADVANCE(19);
      if (lookahead == ':') ADVANCE(74);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == 'e') ADVANCE(168);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(171);
      END_STATE();
    case 39:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(39)
      if (lookahead == '\r') SKIP(39)
      if (lookahead == '!') ADVANCE(8);
      if (lookahead == '#') ADVANCE(172);
      if (lookahead == '%') ADVANCE(96);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '(') ADVANCE(64);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(89);
      if (lookahead == ',') ADVANCE(66);
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == '0') ADVANCE(145);
      if (lookahead == ':') ADVANCE(74);
      if (lookahead == ';') ADVANCE(61);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(116);
      if (lookahead == '@') ADVANCE(83);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == '^') ADVANCE(104);
      if (lookahead == '{') ADVANCE(133);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '~') ADVANCE(107);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(144);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(171);
      END_STATE();
    case 40:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(40)
      if (lookahead == '\r') SKIP(40)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '#') ADVANCE(172);
      if (lookahead == '%') ADVANCE(95);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '(') ADVANCE(64);
      if (lookahead == ')') ADVANCE(65);
      if (lookahead == '*') ADVANCE(69);
      if (lookahead == '+') ADVANCE(88);
      if (lookahead == ',') ADVANCE(66);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '/') ADVANCE(94);
      if (lookahead == '0') ADVANCE(145);
      if (lookahead == ':') ADVANCE(75);
      if (lookahead == ';') ADVANCE(61);
      if (lookahead == '<') ADVANCE(109);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(117);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(85);
      if (lookahead == '^') ADVANCE(103);
      if (lookahead == '{') ADVANCE(133);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '}') ADVANCE(135);
      if (lookahead == '~') ADVANCE(107);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(144);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(171);
      END_STATE();
    case 41:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(41)
      if (lookahead == '\r') SKIP(41)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '#') ADVANCE(172);
      if (lookahead == '%') ADVANCE(95);
      if (lookahead == '&') ADVANCE(101);
      if (lookahead == '(') ADVANCE(64);
      if (lookahead == ')') ADVANCE(65);
      if (lookahead == '*') ADVANCE(69);
      if (lookahead == '+') ADVANCE(88);
      if (lookahead == ',') ADVANCE(66);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead == '.') ADVANCE(62);
      if (lookahead == '/') ADVANCE(94);
      if (lookahead == ':') ADVANCE(75);
      if (lookahead == ';') ADVANCE(61);
      if (lookahead == '<') ADVANCE(109);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(117);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(85);
      if (lookahead == '^') ADVANCE(103);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '}') ADVANCE(135);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(171);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(148);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(137);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(152);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(43);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(137);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(149);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(50);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(53);
      END_STATE();
    case 55:
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(25);
      END_STATE();
    case 56:
      if (eof) ADVANCE(60);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(56)
      if (lookahead == '\r') SKIP(56)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '#') ADVANCE(172);
      if (lookahead == '%') ADVANCE(96);
      if (lookahead == '&') ADVANCE(102);
      if (lookahead == '(') ADVANCE(64);
      if (lookahead == ')') ADVANCE(65);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '+') ADVANCE(89);
      if (lookahead == ',') ADVANCE(66);
      if (lookahead == '-') ADVANCE(92);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == '0') ADVANCE(145);
      if (lookahead == ':') ADVANCE(75);
      if (lookahead == ';') ADVANCE(61);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(116);
      if (lookahead == '@') ADVANCE(83);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(85);
      if (lookahead == '^') ADVANCE(104);
      if (lookahead == 'e') ADVANCE(168);
      if (lookahead == '{') ADVANCE(133);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '}') ADVANCE(135);
      if (lookahead == '~') ADVANCE(107);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(144);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(171);
      END_STATE();
    case 57:
      if (eof) ADVANCE(60);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(57)
      if (lookahead == '\r') SKIP(57)
      if (lookahead == '!') ADVANCE(9);
      if (lookahead == '#') ADVANCE(172);
      if (lookahead == '(') ADVANCE(64);
      if (lookahead == ')') ADVANCE(65);
      if (lookahead == '*') ADVANCE(67);
      if (lookahead == '+') ADVANCE(88);
      if (lookahead == ',') ADVANCE(66);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead == '.') ADVANCE(4);
      if (lookahead == '0') ADVANCE(145);
      if (lookahead == ':') ADVANCE(74);
      if (lookahead == ';') ADVANCE(61);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '=') ADVANCE(87);
      if (lookahead == '>') ADVANCE(115);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(85);
      if (lookahead == '{') ADVANCE(133);
      if (lookahead == '}') ADVANCE(135);
      if (lookahead == '~') ADVANCE(107);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(144);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(171);
      END_STATE();
    case 58:
      if (eof) ADVANCE(60);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(58)
      if (lookahead == '\r') SKIP(58)
      if (lookahead == '#') ADVANCE(172);
      if (lookahead == '(') ADVANCE(64);
      if (lookahead == '*') ADVANCE(67);
      if (lookahead == '+') ADVANCE(88);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead == '.') ADVANCE(4);
      if (lookahead == '0') ADVANCE(145);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == 'e') ADVANCE(169);
      if (lookahead == '{') ADVANCE(133);
      if (lookahead == '~') ADVANCE(107);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(144);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(171);
      END_STATE();
    case 59:
      if (eof) ADVANCE(60);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(59)
      if (lookahead == '\r') SKIP(59)
      if (lookahead == '#') ADVANCE(172);
      if (lookahead == '(') ADVANCE(64);
      if (lookahead == '*') ADVANCE(67);
      if (lookahead == '+') ADVANCE(88);
      if (lookahead == '-') ADVANCE(90);
      if (lookahead == '.') ADVANCE(4);
      if (lookahead == '0') ADVANCE(145);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == '[') ADVANCE(84);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == 'e') ADVANCE(170);
      if (lookahead == '{') ADVANCE(133);
      if (lookahead == '~') ADVANCE(107);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(144);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(171);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(5);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(151);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(81);
      if (lookahead == '=') ADVANCE(121);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(80);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(15);
      if (lookahead == '=') ADVANCE(121);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(127);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(73);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_except);
      if (lookahead == '*') ADVANCE(78);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(171);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_except);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(171);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_except_STAR);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(126);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '=') ADVANCE(123);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(112);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(120);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(120);
      if (lookahead == '>') ADVANCE(79);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(98);
      if (lookahead == '=') ADVANCE(122);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(97);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(125);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead == '=') ADVANCE(124);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(131);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '=') ADVANCE(129);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(130);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(128);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(106);
      if (lookahead == '=') ADVANCE(111);
      if (lookahead == '>') ADVANCE(118);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(105);
      if (lookahead == '=') ADVANCE(111);
      if (lookahead == '>') ADVANCE(118);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(111);
      if (lookahead == '>') ADVANCE(118);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(114);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(114);
      if (lookahead == '>') ADVANCE(72);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(114);
      if (lookahead == '>') ADVANCE(71);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_AT_EQ);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_EQ);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_ellipsis);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '{') ADVANCE(136);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym__escape_interpolation);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym__not_escape_sequence);
      if (lookahead == 0) ADVANCE(173);
      if (lookahead == '\n') ADVANCE(137);
      if (lookahead == '\r') ADVANCE(2);
      if (lookahead == 'N') ADVANCE(24);
      if (lookahead == 'U') ADVANCE(54);
      if (lookahead == 'u') ADVANCE(50);
      if (lookahead == 'x') ADVANCE(48);
      if (lookahead == '"' ||
          lookahead == '\'' ||
          lookahead == '\\' ||
          lookahead == 'a' ||
          lookahead == 'b' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          ('t' <= lookahead && lookahead <= 'v')) ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(45);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead == 0) ADVANCE(141);
      if (lookahead == '\r') ADVANCE(141);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(141);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead == '\r') ADVANCE(140);
      if (lookahead == '#') ADVANCE(141);
      if (lookahead == '\\') ADVANCE(139);
      if (lookahead == '\t' ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(140);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(141);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(141);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_type_conversion);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_integer);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(153);
      if (lookahead == '_') ADVANCE(146);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(28);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(143);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(144);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(153);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(21);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(22);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(23);
      if (lookahead == '_') ADVANCE(146);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(28);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(143);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(144);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(153);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(28);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(143);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(144);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(29);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(143);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(147);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(42);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(143);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(148);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(47);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(143);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(149);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_float);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(153);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(28);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(151);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(154);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(152);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(28);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(151);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(152);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '*') ADVANCE(78);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(171);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(159);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(171);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(160);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(171);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(161);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(171);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(162);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(171);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(163);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(171);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(164);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(171);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(165);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(171);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(166);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(171);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(167);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(171);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(76);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(171);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(155);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(171);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(77);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(171);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'x') ADVANCE(156);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(171);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'x') ADVANCE(157);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(171);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'x') ADVANCE(158);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(171);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_identifier);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(171);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_line_continuation);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      if (lookahead == '\r') SKIP(0)
      if (lookahead == 'F') ADVANCE(1);
      if (lookahead == 'N') ADVANCE(2);
      if (lookahead == 'T') ADVANCE(3);
      if (lookahead == '_') ADVANCE(4);
      if (lookahead == 'a') ADVANCE(5);
      if (lookahead == 'b') ADVANCE(6);
      if (lookahead == 'c') ADVANCE(7);
      if (lookahead == 'd') ADVANCE(8);
      if (lookahead == 'e') ADVANCE(9);
      if (lookahead == 'f') ADVANCE(10);
      if (lookahead == 'g') ADVANCE(11);
      if (lookahead == 'i') ADVANCE(12);
      if (lookahead == 'l') ADVANCE(13);
      if (lookahead == 'm') ADVANCE(14);
      if (lookahead == 'n') ADVANCE(15);
      if (lookahead == 'o') ADVANCE(16);
      if (lookahead == 'p') ADVANCE(17);
      if (lookahead == 'r') ADVANCE(18);
      if (lookahead == 't') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      if (lookahead == 'y') ADVANCE(21);
      END_STATE();
    case 1:
      if (lookahead == 'a') ADVANCE(22);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(23);
      END_STATE();
    case 3:
      if (lookahead == 'r') ADVANCE(24);
      END_STATE();
    case 4:
      if (lookahead == '_') ADVANCE(25);
      END_STATE();
    case 5:
      if (lookahead == 'n') ADVANCE(26);
      if (lookahead == 's') ADVANCE(27);
      if (lookahead == 'w') ADVANCE(28);
      END_STATE();
    case 6:
      if (lookahead == 'r') ADVANCE(29);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(30);
      if (lookahead == 'l') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(32);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(33);
      END_STATE();
    case 9:
      if (lookahead == 'l') ADVANCE(34);
      if (lookahead == 'x') ADVANCE(35);
      END_STATE();
    case 10:
      if (lookahead == 'i') ADVANCE(36);
      if (lookahead == 'o') ADVANCE(37);
      if (lookahead == 'r') ADVANCE(38);
      END_STATE();
    case 11:
      if (lookahead == 'l') ADVANCE(39);
      END_STATE();
    case 12:
      if (lookahead == 'f') ADVANCE(40);
      if (lookahead == 'm') ADVANCE(41);
      if (lookahead == 'n') ADVANCE(42);
      if (lookahead == 's') ADVANCE(43);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(44);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(45);
      END_STATE();
    case 15:
      if (lookahead == 'o') ADVANCE(46);
      END_STATE();
    case 16:
      if (lookahead == 'r') ADVANCE(47);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(48);
      if (lookahead == 'r') ADVANCE(49);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(50);
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 19:
      if (lookahead == 'r') ADVANCE(52);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(53);
      if (lookahead == 'i') ADVANCE(54);
      END_STATE();
    case 21:
      if (lookahead == 'i') ADVANCE(55);
      END_STATE();
    case 22:
      if (lookahead == 'l') ADVANCE(56);
      END_STATE();
    case 23:
      if (lookahead == 'n') ADVANCE(57);
      END_STATE();
    case 24:
      if (lookahead == 'u') ADVANCE(58);
      END_STATE();
    case 25:
      if (lookahead == 'f') ADVANCE(59);
      END_STATE();
    case 26:
      if (lookahead == 'd') ADVANCE(60);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(61);
      if (lookahead == 'y') ADVANCE(62);
      END_STATE();
    case 28:
      if (lookahead == 'a') ADVANCE(63);
      END_STATE();
    case 29:
      if (lookahead == 'e') ADVANCE(64);
      END_STATE();
    case 30:
      if (lookahead == 's') ADVANCE(65);
      END_STATE();
    case 31:
      if (lookahead == 'a') ADVANCE(66);
      END_STATE();
    case 32:
      if (lookahead == 'n') ADVANCE(67);
      END_STATE();
    case 33:
      if (lookahead == 'f') ADVANCE(68);
      if (lookahead == 'l') ADVANCE(69);
      END_STATE();
    case 34:
      if (lookahead == 'i') ADVANCE(70);
      if (lookahead == 's') ADVANCE(71);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(72);
      END_STATE();
    case 36:
      if (lookahead == 'n') ADVANCE(73);
      END_STATE();
    case 37:
      if (lookahead == 'r') ADVANCE(74);
      END_STATE();
    case 38:
      if (lookahead == 'o') ADVANCE(75);
      END_STATE();
    case 39:
      if (lookahead == 'o') ADVANCE(76);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 41:
      if (lookahead == 'p') ADVANCE(77);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 44:
      if (lookahead == 'm') ADVANCE(78);
      END_STATE();
    case 45:
      if (lookahead == 't') ADVANCE(79);
      END_STATE();
    case 46:
      if (lookahead == 'n') ADVANCE(80);
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 48:
      if (lookahead == 's') ADVANCE(82);
      END_STATE();
    case 49:
      if (lookahead == 'i') ADVANCE(83);
      END_STATE();
    case 50:
      if (lookahead == 'i') ADVANCE(84);
      END_STATE();
    case 51:
      if (lookahead == 't') ADVANCE(85);
      END_STATE();
    case 52:
      if (lookahead == 'y') ADVANCE(86);
      END_STATE();
    case 53:
      if (lookahead == 'i') ADVANCE(87);
      END_STATE();
    case 54:
      if (lookahead == 't') ADVANCE(88);
      END_STATE();
    case 55:
      if (lookahead == 'e') ADVANCE(89);
      END_STATE();
    case 56:
      if (lookahead == 's') ADVANCE(90);
      END_STATE();
    case 57:
      if (lookahead == 'e') ADVANCE(91);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 59:
      if (lookahead == 'u') ADVANCE(93);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 61:
      if (lookahead == 'e') ADVANCE(94);
      END_STATE();
    case 62:
      if (lookahead == 'n') ADVANCE(95);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(96);
      END_STATE();
    case 64:
      if (lookahead == 'a') ADVANCE(97);
      END_STATE();
    case 65:
      if (lookahead == 'e') ADVANCE(98);
      END_STATE();
    case 66:
      if (lookahead == 's') ADVANCE(99);
      END_STATE();
    case 67:
      if (lookahead == 't') ADVANCE(100);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_def);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_del);
      END_STATE();
    case 70:
      if (lookahead == 'f') ADVANCE(101);
      END_STATE();
    case 71:
      if (lookahead == 'e') ADVANCE(102);
      END_STATE();
    case 72:
      if (lookahead == 'c') ADVANCE(103);
      END_STATE();
    case 73:
      if (lookahead == 'a') ADVANCE(104);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 75:
      if (lookahead == 'm') ADVANCE(105);
      END_STATE();
    case 76:
      if (lookahead == 'b') ADVANCE(106);
      END_STATE();
    case 77:
      if (lookahead == 'o') ADVANCE(107);
      END_STATE();
    case 78:
      if (lookahead == 'b') ADVANCE(108);
      END_STATE();
    case 79:
      if (lookahead == 'c') ADVANCE(109);
      END_STATE();
    case 80:
      if (lookahead == 'l') ADVANCE(110);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 82:
      if (lookahead == 's') ADVANCE(111);
      END_STATE();
    case 83:
      if (lookahead == 'n') ADVANCE(112);
      END_STATE();
    case 84:
      if (lookahead == 's') ADVANCE(113);
      END_STATE();
    case 85:
      if (lookahead == 'u') ADVANCE(114);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 87:
      if (lookahead == 'l') ADVANCE(115);
      END_STATE();
    case 88:
      if (lookahead == 'h') ADVANCE(116);
      END_STATE();
    case 89:
      if (lookahead == 'l') ADVANCE(117);
      END_STATE();
    case 90:
      if (lookahead == 'e') ADVANCE(118);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_none);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 93:
      if (lookahead == 't') ADVANCE(119);
      END_STATE();
    case 94:
      if (lookahead == 'r') ADVANCE(120);
      END_STATE();
    case 95:
      if (lookahead == 'c') ADVANCE(121);
      END_STATE();
    case 96:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 97:
      if (lookahead == 'k') ADVANCE(123);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 99:
      if (lookahead == 's') ADVANCE(124);
      END_STATE();
    case 100:
      if (lookahead == 'i') ADVANCE(125);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_exec);
      END_STATE();
    case 104:
      if (lookahead == 'l') ADVANCE(126);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 106:
      if (lookahead == 'a') ADVANCE(127);
      END_STATE();
    case 107:
      if (lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 108:
      if (lookahead == 'd') ADVANCE(129);
      END_STATE();
    case 109:
      if (lookahead == 'h') ADVANCE(130);
      END_STATE();
    case 110:
      if (lookahead == 'o') ADVANCE(131);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_pass);
      END_STATE();
    case 112:
      if (lookahead == 't') ADVANCE(132);
      END_STATE();
    case 113:
      if (lookahead == 'e') ADVANCE(133);
      END_STATE();
    case 114:
      if (lookahead == 'r') ADVANCE(134);
      END_STATE();
    case 115:
      if (lookahead == 'e') ADVANCE(135);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 117:
      if (lookahead == 'd') ADVANCE(136);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 119:
      if (lookahead == 'u') ADVANCE(137);
      END_STATE();
    case 120:
      if (lookahead == 't') ADVANCE(138);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 125:
      if (lookahead == 'n') ADVANCE(139);
      END_STATE();
    case 126:
      if (lookahead == 'l') ADVANCE(140);
      END_STATE();
    case 127:
      if (lookahead == 'l') ADVANCE(141);
      END_STATE();
    case 128:
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 129:
      if (lookahead == 'a') ADVANCE(143);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_match);
      END_STATE();
    case 131:
      if (lookahead == 'c') ADVANCE(144);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_print);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_raise);
      END_STATE();
    case 134:
      if (lookahead == 'n') ADVANCE(145);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 137:
      if (lookahead == 'r') ADVANCE(146);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 139:
      if (lookahead == 'u') ADVANCE(147);
      END_STATE();
    case 140:
      if (lookahead == 'y') ADVANCE(148);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_lambda);
      END_STATE();
    case 144:
      if (lookahead == 'a') ADVANCE(149);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 146:
      if (lookahead == 'e') ADVANCE(150);
      END_STATE();
    case 147:
      if (lookahead == 'e') ADVANCE(151);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 149:
      if (lookahead == 'l') ADVANCE(152);
      END_STATE();
    case 150:
      if (lookahead == '_') ADVANCE(153);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_nonlocal);
      END_STATE();
    case 153:
      if (lookahead == '_') ADVANCE(154);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym___future__);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 57, .external_lex_state = 2},
  [2] = {.lex_state = 57, .external_lex_state = 3},
  [3] = {.lex_state = 57, .external_lex_state = 3},
  [4] = {.lex_state = 57, .external_lex_state = 3},
  [5] = {.lex_state = 57, .external_lex_state = 3},
  [6] = {.lex_state = 57, .external_lex_state = 3},
  [7] = {.lex_state = 57, .external_lex_state = 3},
  [8] = {.lex_state = 57, .external_lex_state = 3},
  [9] = {.lex_state = 57, .external_lex_state = 3},
  [10] = {.lex_state = 57, .external_lex_state = 3},
  [11] = {.lex_state = 57, .external_lex_state = 3},
  [12] = {.lex_state = 57, .external_lex_state = 3},
  [13] = {.lex_state = 57, .external_lex_state = 3},
  [14] = {.lex_state = 57, .external_lex_state = 3},
  [15] = {.lex_state = 57, .external_lex_state = 3},
  [16] = {.lex_state = 57, .external_lex_state = 3},
  [17] = {.lex_state = 57, .external_lex_state = 3},
  [18] = {.lex_state = 57, .external_lex_state = 3},
  [19] = {.lex_state = 57, .external_lex_state = 3},
  [20] = {.lex_state = 57, .external_lex_state = 3},
  [21] = {.lex_state = 57, .external_lex_state = 3},
  [22] = {.lex_state = 57, .external_lex_state = 3},
  [23] = {.lex_state = 57, .external_lex_state = 3},
  [24] = {.lex_state = 57, .external_lex_state = 3},
  [25] = {.lex_state = 57, .external_lex_state = 3},
  [26] = {.lex_state = 57, .external_lex_state = 3},
  [27] = {.lex_state = 57, .external_lex_state = 3},
  [28] = {.lex_state = 57, .external_lex_state = 3},
  [29] = {.lex_state = 57, .external_lex_state = 3},
  [30] = {.lex_state = 57, .external_lex_state = 3},
  [31] = {.lex_state = 57, .external_lex_state = 3},
  [32] = {.lex_state = 57, .external_lex_state = 3},
  [33] = {.lex_state = 57, .external_lex_state = 3},
  [34] = {.lex_state = 57, .external_lex_state = 3},
  [35] = {.lex_state = 57, .external_lex_state = 3},
  [36] = {.lex_state = 57, .external_lex_state = 3},
  [37] = {.lex_state = 57, .external_lex_state = 3},
  [38] = {.lex_state = 57, .external_lex_state = 3},
  [39] = {.lex_state = 57, .external_lex_state = 3},
  [40] = {.lex_state = 57, .external_lex_state = 3},
  [41] = {.lex_state = 57, .external_lex_state = 3},
  [42] = {.lex_state = 57, .external_lex_state = 3},
  [43] = {.lex_state = 57, .external_lex_state = 3},
  [44] = {.lex_state = 57, .external_lex_state = 3},
  [45] = {.lex_state = 57, .external_lex_state = 3},
  [46] = {.lex_state = 57, .external_lex_state = 3},
  [47] = {.lex_state = 57, .external_lex_state = 3},
  [48] = {.lex_state = 57, .external_lex_state = 3},
  [49] = {.lex_state = 57, .external_lex_state = 3},
  [50] = {.lex_state = 57, .external_lex_state = 3},
  [51] = {.lex_state = 57, .external_lex_state = 3},
  [52] = {.lex_state = 57, .external_lex_state = 2},
  [53] = {.lex_state = 57, .external_lex_state = 3},
  [54] = {.lex_state = 57, .external_lex_state = 3},
  [55] = {.lex_state = 57, .external_lex_state = 3},
  [56] = {.lex_state = 57, .external_lex_state = 3},
  [57] = {.lex_state = 57, .external_lex_state = 3},
  [58] = {.lex_state = 57, .external_lex_state = 3},
  [59] = {.lex_state = 57, .external_lex_state = 2},
  [60] = {.lex_state = 57, .external_lex_state = 3},
  [61] = {.lex_state = 57, .external_lex_state = 3},
  [62] = {.lex_state = 57, .external_lex_state = 3},
  [63] = {.lex_state = 30, .external_lex_state = 4},
  [64] = {.lex_state = 30, .external_lex_state = 4},
  [65] = {.lex_state = 30, .external_lex_state = 4},
  [66] = {.lex_state = 57, .external_lex_state = 5},
  [67] = {.lex_state = 57, .external_lex_state = 5},
  [68] = {.lex_state = 57, .external_lex_state = 5},
  [69] = {.lex_state = 57, .external_lex_state = 5},
  [70] = {.lex_state = 57, .external_lex_state = 5},
  [71] = {.lex_state = 57, .external_lex_state = 5},
  [72] = {.lex_state = 57, .external_lex_state = 5},
  [73] = {.lex_state = 57, .external_lex_state = 5},
  [74] = {.lex_state = 57, .external_lex_state = 5},
  [75] = {.lex_state = 57, .external_lex_state = 5},
  [76] = {.lex_state = 57, .external_lex_state = 5},
  [77] = {.lex_state = 57, .external_lex_state = 5},
  [78] = {.lex_state = 57, .external_lex_state = 5},
  [79] = {.lex_state = 57, .external_lex_state = 5},
  [80] = {.lex_state = 57, .external_lex_state = 5},
  [81] = {.lex_state = 57, .external_lex_state = 5},
  [82] = {.lex_state = 57, .external_lex_state = 5},
  [83] = {.lex_state = 57, .external_lex_state = 5},
  [84] = {.lex_state = 57, .external_lex_state = 5},
  [85] = {.lex_state = 57, .external_lex_state = 5},
  [86] = {.lex_state = 57, .external_lex_state = 5},
  [87] = {.lex_state = 57, .external_lex_state = 5},
  [88] = {.lex_state = 57, .external_lex_state = 5},
  [89] = {.lex_state = 57, .external_lex_state = 5},
  [90] = {.lex_state = 57, .external_lex_state = 5},
  [91] = {.lex_state = 57, .external_lex_state = 5},
  [92] = {.lex_state = 57, .external_lex_state = 5},
  [93] = {.lex_state = 57, .external_lex_state = 5},
  [94] = {.lex_state = 57, .external_lex_state = 5},
  [95] = {.lex_state = 57, .external_lex_state = 5},
  [96] = {.lex_state = 57, .external_lex_state = 5},
  [97] = {.lex_state = 57, .external_lex_state = 5},
  [98] = {.lex_state = 57, .external_lex_state = 5},
  [99] = {.lex_state = 57, .external_lex_state = 5},
  [100] = {.lex_state = 57, .external_lex_state = 5},
  [101] = {.lex_state = 57, .external_lex_state = 5},
  [102] = {.lex_state = 57, .external_lex_state = 5},
  [103] = {.lex_state = 57, .external_lex_state = 5},
  [104] = {.lex_state = 57, .external_lex_state = 5},
  [105] = {.lex_state = 57, .external_lex_state = 5},
  [106] = {.lex_state = 57, .external_lex_state = 5},
  [107] = {.lex_state = 57, .external_lex_state = 5},
  [108] = {.lex_state = 57, .external_lex_state = 5},
  [109] = {.lex_state = 57, .external_lex_state = 5},
  [110] = {.lex_state = 57, .external_lex_state = 5},
  [111] = {.lex_state = 57, .external_lex_state = 5},
  [112] = {.lex_state = 57, .external_lex_state = 5},
  [113] = {.lex_state = 57, .external_lex_state = 5},
  [114] = {.lex_state = 57, .external_lex_state = 4},
  [115] = {.lex_state = 57, .external_lex_state = 4},
  [116] = {.lex_state = 57, .external_lex_state = 4},
  [117] = {.lex_state = 57, .external_lex_state = 4},
  [118] = {.lex_state = 57, .external_lex_state = 4},
  [119] = {.lex_state = 57, .external_lex_state = 4},
  [120] = {.lex_state = 57, .external_lex_state = 4},
  [121] = {.lex_state = 57, .external_lex_state = 4},
  [122] = {.lex_state = 57, .external_lex_state = 4},
  [123] = {.lex_state = 57, .external_lex_state = 4},
  [124] = {.lex_state = 57, .external_lex_state = 4},
  [125] = {.lex_state = 57, .external_lex_state = 4},
  [126] = {.lex_state = 57, .external_lex_state = 4},
  [127] = {.lex_state = 57, .external_lex_state = 4},
  [128] = {.lex_state = 57, .external_lex_state = 4},
  [129] = {.lex_state = 57, .external_lex_state = 4},
  [130] = {.lex_state = 57, .external_lex_state = 2},
  [131] = {.lex_state = 30, .external_lex_state = 4},
  [132] = {.lex_state = 39, .external_lex_state = 4},
  [133] = {.lex_state = 31, .external_lex_state = 6},
  [134] = {.lex_state = 40, .external_lex_state = 6},
  [135] = {.lex_state = 40, .external_lex_state = 4},
  [136] = {.lex_state = 40, .external_lex_state = 6},
  [137] = {.lex_state = 40, .external_lex_state = 7},
  [138] = {.lex_state = 31, .external_lex_state = 4},
  [139] = {.lex_state = 40, .external_lex_state = 6},
  [140] = {.lex_state = 40, .external_lex_state = 2},
  [141] = {.lex_state = 40, .external_lex_state = 6},
  [142] = {.lex_state = 31, .external_lex_state = 6},
  [143] = {.lex_state = 31, .external_lex_state = 4},
  [144] = {.lex_state = 31, .external_lex_state = 2},
  [145] = {.lex_state = 40, .external_lex_state = 7},
  [146] = {.lex_state = 31, .external_lex_state = 2},
  [147] = {.lex_state = 40, .external_lex_state = 7},
  [148] = {.lex_state = 31, .external_lex_state = 6},
  [149] = {.lex_state = 40, .external_lex_state = 7},
  [150] = {.lex_state = 40, .external_lex_state = 8},
  [151] = {.lex_state = 31, .external_lex_state = 7},
  [152] = {.lex_state = 40, .external_lex_state = 8},
  [153] = {.lex_state = 40, .external_lex_state = 8},
  [154] = {.lex_state = 40, .external_lex_state = 7},
  [155] = {.lex_state = 39, .external_lex_state = 4},
  [156] = {.lex_state = 31, .external_lex_state = 8},
  [157] = {.lex_state = 40, .external_lex_state = 7},
  [158] = {.lex_state = 40, .external_lex_state = 8},
  [159] = {.lex_state = 31, .external_lex_state = 7},
  [160] = {.lex_state = 31, .external_lex_state = 8},
  [161] = {.lex_state = 31, .external_lex_state = 7},
  [162] = {.lex_state = 31, .external_lex_state = 8},
  [163] = {.lex_state = 39, .external_lex_state = 2},
  [164] = {.lex_state = 39, .external_lex_state = 2},
  [165] = {.lex_state = 57, .external_lex_state = 8},
  [166] = {.lex_state = 57, .external_lex_state = 8},
  [167] = {.lex_state = 57, .external_lex_state = 7},
  [168] = {.lex_state = 31, .external_lex_state = 6},
  [169] = {.lex_state = 31, .external_lex_state = 6},
  [170] = {.lex_state = 57, .external_lex_state = 8},
  [171] = {.lex_state = 57, .external_lex_state = 8},
  [172] = {.lex_state = 31, .external_lex_state = 6},
  [173] = {.lex_state = 57, .external_lex_state = 7},
  [174] = {.lex_state = 57, .external_lex_state = 7},
  [175] = {.lex_state = 57, .external_lex_state = 7},
  [176] = {.lex_state = 57, .external_lex_state = 7},
  [177] = {.lex_state = 31, .external_lex_state = 6},
  [178] = {.lex_state = 57, .external_lex_state = 8},
  [179] = {.lex_state = 31, .external_lex_state = 6},
  [180] = {.lex_state = 57, .external_lex_state = 8},
  [181] = {.lex_state = 31, .external_lex_state = 6},
  [182] = {.lex_state = 57, .external_lex_state = 8},
  [183] = {.lex_state = 57, .external_lex_state = 7},
  [184] = {.lex_state = 31, .external_lex_state = 6},
  [185] = {.lex_state = 57, .external_lex_state = 7},
  [186] = {.lex_state = 57, .external_lex_state = 2},
  [187] = {.lex_state = 57, .external_lex_state = 8},
  [188] = {.lex_state = 57, .external_lex_state = 8},
  [189] = {.lex_state = 57, .external_lex_state = 7},
  [190] = {.lex_state = 57, .external_lex_state = 7},
  [191] = {.lex_state = 57, .external_lex_state = 2},
  [192] = {.lex_state = 57, .external_lex_state = 7},
  [193] = {.lex_state = 57, .external_lex_state = 8},
  [194] = {.lex_state = 57, .external_lex_state = 2},
  [195] = {.lex_state = 31, .external_lex_state = 6},
  [196] = {.lex_state = 32, .external_lex_state = 4},
  [197] = {.lex_state = 32, .external_lex_state = 4},
  [198] = {.lex_state = 57, .external_lex_state = 2},
  [199] = {.lex_state = 57, .external_lex_state = 2},
  [200] = {.lex_state = 31, .external_lex_state = 7},
  [201] = {.lex_state = 32, .external_lex_state = 2},
  [202] = {.lex_state = 31, .external_lex_state = 7},
  [203] = {.lex_state = 31, .external_lex_state = 7},
  [204] = {.lex_state = 32, .external_lex_state = 2},
  [205] = {.lex_state = 57, .external_lex_state = 6},
  [206] = {.lex_state = 57, .external_lex_state = 7},
  [207] = {.lex_state = 31, .external_lex_state = 7},
  [208] = {.lex_state = 31, .external_lex_state = 7},
  [209] = {.lex_state = 31, .external_lex_state = 7},
  [210] = {.lex_state = 31, .external_lex_state = 7},
  [211] = {.lex_state = 31, .external_lex_state = 7},
  [212] = {.lex_state = 31, .external_lex_state = 7},
  [213] = {.lex_state = 31, .external_lex_state = 7},
  [214] = {.lex_state = 57, .external_lex_state = 8},
  [215] = {.lex_state = 31, .external_lex_state = 7},
  [216] = {.lex_state = 31, .external_lex_state = 7},
  [217] = {.lex_state = 31, .external_lex_state = 7},
  [218] = {.lex_state = 31, .external_lex_state = 7},
  [219] = {.lex_state = 57, .external_lex_state = 8},
  [220] = {.lex_state = 31, .external_lex_state = 7},
  [221] = {.lex_state = 31, .external_lex_state = 7},
  [222] = {.lex_state = 31, .external_lex_state = 7},
  [223] = {.lex_state = 57, .external_lex_state = 7},
  [224] = {.lex_state = 57, .external_lex_state = 7},
  [225] = {.lex_state = 57, .external_lex_state = 8},
  [226] = {.lex_state = 57, .external_lex_state = 7},
  [227] = {.lex_state = 31, .external_lex_state = 7},
  [228] = {.lex_state = 31, .external_lex_state = 7},
  [229] = {.lex_state = 31, .external_lex_state = 7},
  [230] = {.lex_state = 31, .external_lex_state = 7},
  [231] = {.lex_state = 31, .external_lex_state = 7},
  [232] = {.lex_state = 31, .external_lex_state = 7},
  [233] = {.lex_state = 57, .external_lex_state = 7},
  [234] = {.lex_state = 31, .external_lex_state = 7},
  [235] = {.lex_state = 31, .external_lex_state = 7},
  [236] = {.lex_state = 31, .external_lex_state = 7},
  [237] = {.lex_state = 31, .external_lex_state = 7},
  [238] = {.lex_state = 31, .external_lex_state = 7},
  [239] = {.lex_state = 31, .external_lex_state = 7},
  [240] = {.lex_state = 31, .external_lex_state = 7},
  [241] = {.lex_state = 31, .external_lex_state = 7},
  [242] = {.lex_state = 31, .external_lex_state = 7},
  [243] = {.lex_state = 31, .external_lex_state = 7},
  [244] = {.lex_state = 57, .external_lex_state = 7},
  [245] = {.lex_state = 57, .external_lex_state = 8},
  [246] = {.lex_state = 57, .external_lex_state = 7},
  [247] = {.lex_state = 31, .external_lex_state = 7},
  [248] = {.lex_state = 57, .external_lex_state = 7},
  [249] = {.lex_state = 57, .external_lex_state = 7},
  [250] = {.lex_state = 57, .external_lex_state = 7},
  [251] = {.lex_state = 57, .external_lex_state = 8},
  [252] = {.lex_state = 57, .external_lex_state = 7},
  [253] = {.lex_state = 57, .external_lex_state = 7},
  [254] = {.lex_state = 31, .external_lex_state = 7},
  [255] = {.lex_state = 31, .external_lex_state = 7},
  [256] = {.lex_state = 57, .external_lex_state = 8},
  [257] = {.lex_state = 31, .external_lex_state = 7},
  [258] = {.lex_state = 31, .external_lex_state = 7},
  [259] = {.lex_state = 57, .external_lex_state = 8},
  [260] = {.lex_state = 31, .external_lex_state = 7},
  [261] = {.lex_state = 31, .external_lex_state = 7},
  [262] = {.lex_state = 57, .external_lex_state = 7},
  [263] = {.lex_state = 57, .external_lex_state = 7},
  [264] = {.lex_state = 31, .external_lex_state = 7},
  [265] = {.lex_state = 57, .external_lex_state = 7},
  [266] = {.lex_state = 57, .external_lex_state = 8},
  [267] = {.lex_state = 57, .external_lex_state = 7},
  [268] = {.lex_state = 57, .external_lex_state = 7},
  [269] = {.lex_state = 57, .external_lex_state = 8},
  [270] = {.lex_state = 31, .external_lex_state = 2},
  [271] = {.lex_state = 57, .external_lex_state = 6},
  [272] = {.lex_state = 31, .external_lex_state = 6},
  [273] = {.lex_state = 57, .external_lex_state = 7},
  [274] = {.lex_state = 57, .external_lex_state = 8},
  [275] = {.lex_state = 57, .external_lex_state = 7},
  [276] = {.lex_state = 57, .external_lex_state = 6},
  [277] = {.lex_state = 57, .external_lex_state = 6},
  [278] = {.lex_state = 57, .external_lex_state = 7},
  [279] = {.lex_state = 57, .external_lex_state = 6},
  [280] = {.lex_state = 57, .external_lex_state = 6},
  [281] = {.lex_state = 57, .external_lex_state = 6},
  [282] = {.lex_state = 57, .external_lex_state = 6},
  [283] = {.lex_state = 57, .external_lex_state = 8},
  [284] = {.lex_state = 57, .external_lex_state = 8},
  [285] = {.lex_state = 57, .external_lex_state = 7},
  [286] = {.lex_state = 57, .external_lex_state = 8},
  [287] = {.lex_state = 57, .external_lex_state = 8},
  [288] = {.lex_state = 57, .external_lex_state = 6},
  [289] = {.lex_state = 31, .external_lex_state = 6},
  [290] = {.lex_state = 57, .external_lex_state = 7},
  [291] = {.lex_state = 31, .external_lex_state = 6},
  [292] = {.lex_state = 31, .external_lex_state = 6},
  [293] = {.lex_state = 31, .external_lex_state = 6},
  [294] = {.lex_state = 31, .external_lex_state = 6},
  [295] = {.lex_state = 57, .external_lex_state = 4},
  [296] = {.lex_state = 31, .external_lex_state = 6},
  [297] = {.lex_state = 57, .external_lex_state = 2},
  [298] = {.lex_state = 31, .external_lex_state = 6},
  [299] = {.lex_state = 31, .external_lex_state = 6},
  [300] = {.lex_state = 31, .external_lex_state = 6},
  [301] = {.lex_state = 57, .external_lex_state = 4},
  [302] = {.lex_state = 57, .external_lex_state = 2},
  [303] = {.lex_state = 31, .external_lex_state = 6},
  [304] = {.lex_state = 31, .external_lex_state = 6},
  [305] = {.lex_state = 31, .external_lex_state = 6},
  [306] = {.lex_state = 57, .external_lex_state = 8},
  [307] = {.lex_state = 31, .external_lex_state = 6},
  [308] = {.lex_state = 31, .external_lex_state = 6},
  [309] = {.lex_state = 31, .external_lex_state = 6},
  [310] = {.lex_state = 57, .external_lex_state = 2},
  [311] = {.lex_state = 31, .external_lex_state = 6},
  [312] = {.lex_state = 57, .external_lex_state = 8},
  [313] = {.lex_state = 57, .external_lex_state = 8},
  [314] = {.lex_state = 57, .external_lex_state = 8},
  [315] = {.lex_state = 57, .external_lex_state = 8},
  [316] = {.lex_state = 31, .external_lex_state = 2},
  [317] = {.lex_state = 57, .external_lex_state = 8},
  [318] = {.lex_state = 57, .external_lex_state = 2},
  [319] = {.lex_state = 31, .external_lex_state = 7},
  [320] = {.lex_state = 57, .external_lex_state = 8},
  [321] = {.lex_state = 57, .external_lex_state = 8},
  [322] = {.lex_state = 57, .external_lex_state = 8},
  [323] = {.lex_state = 57, .external_lex_state = 8},
  [324] = {.lex_state = 57, .external_lex_state = 8},
  [325] = {.lex_state = 57, .external_lex_state = 8},
  [326] = {.lex_state = 57, .external_lex_state = 8},
  [327] = {.lex_state = 57, .external_lex_state = 2},
  [328] = {.lex_state = 57, .external_lex_state = 8},
  [329] = {.lex_state = 57, .external_lex_state = 8},
  [330] = {.lex_state = 57, .external_lex_state = 8},
  [331] = {.lex_state = 57, .external_lex_state = 8},
  [332] = {.lex_state = 57, .external_lex_state = 8},
  [333] = {.lex_state = 57, .external_lex_state = 8},
  [334] = {.lex_state = 57, .external_lex_state = 8},
  [335] = {.lex_state = 57, .external_lex_state = 8},
  [336] = {.lex_state = 57, .external_lex_state = 8},
  [337] = {.lex_state = 57, .external_lex_state = 8},
  [338] = {.lex_state = 57, .external_lex_state = 8},
  [339] = {.lex_state = 57, .external_lex_state = 4},
  [340] = {.lex_state = 57, .external_lex_state = 8},
  [341] = {.lex_state = 57, .external_lex_state = 4},
  [342] = {.lex_state = 57, .external_lex_state = 8},
  [343] = {.lex_state = 57, .external_lex_state = 8},
  [344] = {.lex_state = 57, .external_lex_state = 8},
  [345] = {.lex_state = 57, .external_lex_state = 8},
  [346] = {.lex_state = 31, .external_lex_state = 7},
  [347] = {.lex_state = 57, .external_lex_state = 8},
  [348] = {.lex_state = 57, .external_lex_state = 4},
  [349] = {.lex_state = 57, .external_lex_state = 8},
  [350] = {.lex_state = 57, .external_lex_state = 8},
  [351] = {.lex_state = 57, .external_lex_state = 8},
  [352] = {.lex_state = 57, .external_lex_state = 4},
  [353] = {.lex_state = 57, .external_lex_state = 2},
  [354] = {.lex_state = 57, .external_lex_state = 2},
  [355] = {.lex_state = 57, .external_lex_state = 2},
  [356] = {.lex_state = 57, .external_lex_state = 4},
  [357] = {.lex_state = 57, .external_lex_state = 2},
  [358] = {.lex_state = 57, .external_lex_state = 4},
  [359] = {.lex_state = 57, .external_lex_state = 2},
  [360] = {.lex_state = 57, .external_lex_state = 2},
  [361] = {.lex_state = 57, .external_lex_state = 2},
  [362] = {.lex_state = 57, .external_lex_state = 8},
  [363] = {.lex_state = 57, .external_lex_state = 2},
  [364] = {.lex_state = 57, .external_lex_state = 2},
  [365] = {.lex_state = 57, .external_lex_state = 2},
  [366] = {.lex_state = 57, .external_lex_state = 8},
  [367] = {.lex_state = 57, .external_lex_state = 2},
  [368] = {.lex_state = 57, .external_lex_state = 2},
  [369] = {.lex_state = 57, .external_lex_state = 2},
  [370] = {.lex_state = 57, .external_lex_state = 2},
  [371] = {.lex_state = 57, .external_lex_state = 2},
  [372] = {.lex_state = 57, .external_lex_state = 8},
  [373] = {.lex_state = 57, .external_lex_state = 2},
  [374] = {.lex_state = 57, .external_lex_state = 8},
  [375] = {.lex_state = 57, .external_lex_state = 2},
  [376] = {.lex_state = 31, .external_lex_state = 8},
  [377] = {.lex_state = 57, .external_lex_state = 2},
  [378] = {.lex_state = 57, .external_lex_state = 2},
  [379] = {.lex_state = 57, .external_lex_state = 2},
  [380] = {.lex_state = 57, .external_lex_state = 2},
  [381] = {.lex_state = 31, .external_lex_state = 2},
  [382] = {.lex_state = 57, .external_lex_state = 4},
  [383] = {.lex_state = 57, .external_lex_state = 2},
  [384] = {.lex_state = 31, .external_lex_state = 2},
  [385] = {.lex_state = 57, .external_lex_state = 8},
  [386] = {.lex_state = 33, .external_lex_state = 9},
  [387] = {.lex_state = 57, .external_lex_state = 7},
  [388] = {.lex_state = 57, .external_lex_state = 2},
  [389] = {.lex_state = 57, .external_lex_state = 7},
  [390] = {.lex_state = 57, .external_lex_state = 2},
  [391] = {.lex_state = 33, .external_lex_state = 9},
  [392] = {.lex_state = 57, .external_lex_state = 2},
  [393] = {.lex_state = 57, .external_lex_state = 7},
  [394] = {.lex_state = 57, .external_lex_state = 2},
  [395] = {.lex_state = 57, .external_lex_state = 2},
  [396] = {.lex_state = 57, .external_lex_state = 2},
  [397] = {.lex_state = 31, .external_lex_state = 2},
  [398] = {.lex_state = 57, .external_lex_state = 4},
  [399] = {.lex_state = 57, .external_lex_state = 7},
  [400] = {.lex_state = 33, .external_lex_state = 4},
  [401] = {.lex_state = 57, .external_lex_state = 2},
  [402] = {.lex_state = 57, .external_lex_state = 4},
  [403] = {.lex_state = 57, .external_lex_state = 2},
  [404] = {.lex_state = 57, .external_lex_state = 2},
  [405] = {.lex_state = 57, .external_lex_state = 2},
  [406] = {.lex_state = 31, .external_lex_state = 7},
  [407] = {.lex_state = 57, .external_lex_state = 2},
  [408] = {.lex_state = 57, .external_lex_state = 2},
  [409] = {.lex_state = 57, .external_lex_state = 2},
  [410] = {.lex_state = 57, .external_lex_state = 2},
  [411] = {.lex_state = 57, .external_lex_state = 2},
  [412] = {.lex_state = 57, .external_lex_state = 2},
  [413] = {.lex_state = 57, .external_lex_state = 2},
  [414] = {.lex_state = 57, .external_lex_state = 2},
  [415] = {.lex_state = 57, .external_lex_state = 2},
  [416] = {.lex_state = 57, .external_lex_state = 2},
  [417] = {.lex_state = 57, .external_lex_state = 2},
  [418] = {.lex_state = 57, .external_lex_state = 2},
  [419] = {.lex_state = 57, .external_lex_state = 2},
  [420] = {.lex_state = 57, .external_lex_state = 2},
  [421] = {.lex_state = 57, .external_lex_state = 2},
  [422] = {.lex_state = 57, .external_lex_state = 2},
  [423] = {.lex_state = 57, .external_lex_state = 2},
  [424] = {.lex_state = 57, .external_lex_state = 2},
  [425] = {.lex_state = 57, .external_lex_state = 2},
  [426] = {.lex_state = 57, .external_lex_state = 2},
  [427] = {.lex_state = 57, .external_lex_state = 2},
  [428] = {.lex_state = 57, .external_lex_state = 2},
  [429] = {.lex_state = 57, .external_lex_state = 2},
  [430] = {.lex_state = 57, .external_lex_state = 2},
  [431] = {.lex_state = 57, .external_lex_state = 2},
  [432] = {.lex_state = 57, .external_lex_state = 2},
  [433] = {.lex_state = 57, .external_lex_state = 2},
  [434] = {.lex_state = 57, .external_lex_state = 2},
  [435] = {.lex_state = 57, .external_lex_state = 2},
  [436] = {.lex_state = 57, .external_lex_state = 2},
  [437] = {.lex_state = 57, .external_lex_state = 2},
  [438] = {.lex_state = 57, .external_lex_state = 2},
  [439] = {.lex_state = 57, .external_lex_state = 2},
  [440] = {.lex_state = 57, .external_lex_state = 2},
  [441] = {.lex_state = 57, .external_lex_state = 2},
  [442] = {.lex_state = 57, .external_lex_state = 2},
  [443] = {.lex_state = 57, .external_lex_state = 2},
  [444] = {.lex_state = 57, .external_lex_state = 2},
  [445] = {.lex_state = 57, .external_lex_state = 2},
  [446] = {.lex_state = 58, .external_lex_state = 2},
  [447] = {.lex_state = 59, .external_lex_state = 2},
  [448] = {.lex_state = 57, .external_lex_state = 2},
  [449] = {.lex_state = 57, .external_lex_state = 2},
  [450] = {.lex_state = 57, .external_lex_state = 2},
  [451] = {.lex_state = 57, .external_lex_state = 2},
  [452] = {.lex_state = 57, .external_lex_state = 2},
  [453] = {.lex_state = 57, .external_lex_state = 2},
  [454] = {.lex_state = 57, .external_lex_state = 2},
  [455] = {.lex_state = 57, .external_lex_state = 2},
  [456] = {.lex_state = 57, .external_lex_state = 2},
  [457] = {.lex_state = 57, .external_lex_state = 2},
  [458] = {.lex_state = 57, .external_lex_state = 2},
  [459] = {.lex_state = 57, .external_lex_state = 2},
  [460] = {.lex_state = 57, .external_lex_state = 2},
  [461] = {.lex_state = 57, .external_lex_state = 2},
  [462] = {.lex_state = 57, .external_lex_state = 2},
  [463] = {.lex_state = 57, .external_lex_state = 2},
  [464] = {.lex_state = 57, .external_lex_state = 2},
  [465] = {.lex_state = 57, .external_lex_state = 2},
  [466] = {.lex_state = 57, .external_lex_state = 2},
  [467] = {.lex_state = 57, .external_lex_state = 2},
  [468] = {.lex_state = 57, .external_lex_state = 2},
  [469] = {.lex_state = 57, .external_lex_state = 2},
  [470] = {.lex_state = 57, .external_lex_state = 2},
  [471] = {.lex_state = 57, .external_lex_state = 2},
  [472] = {.lex_state = 57, .external_lex_state = 2},
  [473] = {.lex_state = 57, .external_lex_state = 2},
  [474] = {.lex_state = 57, .external_lex_state = 2},
  [475] = {.lex_state = 57, .external_lex_state = 2},
  [476] = {.lex_state = 57, .external_lex_state = 2},
  [477] = {.lex_state = 57, .external_lex_state = 2},
  [478] = {.lex_state = 57, .external_lex_state = 2},
  [479] = {.lex_state = 57, .external_lex_state = 2},
  [480] = {.lex_state = 57, .external_lex_state = 2},
  [481] = {.lex_state = 57, .external_lex_state = 2},
  [482] = {.lex_state = 57, .external_lex_state = 2},
  [483] = {.lex_state = 57, .external_lex_state = 2},
  [484] = {.lex_state = 57, .external_lex_state = 2},
  [485] = {.lex_state = 57, .external_lex_state = 2},
  [486] = {.lex_state = 57, .external_lex_state = 2},
  [487] = {.lex_state = 57, .external_lex_state = 2},
  [488] = {.lex_state = 57, .external_lex_state = 2},
  [489] = {.lex_state = 57, .external_lex_state = 2},
  [490] = {.lex_state = 57, .external_lex_state = 2},
  [491] = {.lex_state = 57, .external_lex_state = 2},
  [492] = {.lex_state = 57, .external_lex_state = 2},
  [493] = {.lex_state = 59, .external_lex_state = 2},
  [494] = {.lex_state = 58, .external_lex_state = 2},
  [495] = {.lex_state = 57, .external_lex_state = 2},
  [496] = {.lex_state = 57, .external_lex_state = 2},
  [497] = {.lex_state = 57, .external_lex_state = 2},
  [498] = {.lex_state = 57, .external_lex_state = 2},
  [499] = {.lex_state = 58, .external_lex_state = 3},
  [500] = {.lex_state = 57, .external_lex_state = 2},
  [501] = {.lex_state = 57, .external_lex_state = 2},
  [502] = {.lex_state = 57, .external_lex_state = 2},
  [503] = {.lex_state = 57, .external_lex_state = 2},
  [504] = {.lex_state = 57, .external_lex_state = 2},
  [505] = {.lex_state = 57, .external_lex_state = 2},
  [506] = {.lex_state = 57, .external_lex_state = 2},
  [507] = {.lex_state = 57, .external_lex_state = 2},
  [508] = {.lex_state = 57, .external_lex_state = 2},
  [509] = {.lex_state = 57, .external_lex_state = 2},
  [510] = {.lex_state = 59, .external_lex_state = 3},
  [511] = {.lex_state = 57, .external_lex_state = 2},
  [512] = {.lex_state = 57, .external_lex_state = 2},
  [513] = {.lex_state = 57, .external_lex_state = 2},
  [514] = {.lex_state = 57, .external_lex_state = 2},
  [515] = {.lex_state = 57, .external_lex_state = 2},
  [516] = {.lex_state = 57, .external_lex_state = 2},
  [517] = {.lex_state = 57, .external_lex_state = 2},
  [518] = {.lex_state = 59, .external_lex_state = 3},
  [519] = {.lex_state = 57, .external_lex_state = 2},
  [520] = {.lex_state = 57, .external_lex_state = 2},
  [521] = {.lex_state = 57, .external_lex_state = 2},
  [522] = {.lex_state = 58, .external_lex_state = 3},
  [523] = {.lex_state = 57, .external_lex_state = 2},
  [524] = {.lex_state = 57, .external_lex_state = 2},
  [525] = {.lex_state = 57, .external_lex_state = 2},
  [526] = {.lex_state = 57, .external_lex_state = 2},
  [527] = {.lex_state = 57, .external_lex_state = 2},
  [528] = {.lex_state = 57, .external_lex_state = 2},
  [529] = {.lex_state = 57, .external_lex_state = 2},
  [530] = {.lex_state = 57, .external_lex_state = 2},
  [531] = {.lex_state = 57, .external_lex_state = 2},
  [532] = {.lex_state = 57, .external_lex_state = 2},
  [533] = {.lex_state = 57, .external_lex_state = 2},
  [534] = {.lex_state = 57, .external_lex_state = 2},
  [535] = {.lex_state = 57, .external_lex_state = 2},
  [536] = {.lex_state = 57, .external_lex_state = 2},
  [537] = {.lex_state = 57, .external_lex_state = 2},
  [538] = {.lex_state = 57, .external_lex_state = 2},
  [539] = {.lex_state = 57, .external_lex_state = 2},
  [540] = {.lex_state = 57, .external_lex_state = 2},
  [541] = {.lex_state = 57, .external_lex_state = 2},
  [542] = {.lex_state = 57, .external_lex_state = 2},
  [543] = {.lex_state = 57, .external_lex_state = 2},
  [544] = {.lex_state = 57, .external_lex_state = 2},
  [545] = {.lex_state = 57, .external_lex_state = 2},
  [546] = {.lex_state = 57, .external_lex_state = 2},
  [547] = {.lex_state = 57, .external_lex_state = 2},
  [548] = {.lex_state = 57, .external_lex_state = 2},
  [549] = {.lex_state = 57, .external_lex_state = 2},
  [550] = {.lex_state = 57, .external_lex_state = 2},
  [551] = {.lex_state = 57, .external_lex_state = 2},
  [552] = {.lex_state = 57, .external_lex_state = 2},
  [553] = {.lex_state = 57, .external_lex_state = 2},
  [554] = {.lex_state = 57, .external_lex_state = 2},
  [555] = {.lex_state = 57, .external_lex_state = 2},
  [556] = {.lex_state = 57, .external_lex_state = 2},
  [557] = {.lex_state = 57, .external_lex_state = 2},
  [558] = {.lex_state = 57, .external_lex_state = 2},
  [559] = {.lex_state = 57, .external_lex_state = 2},
  [560] = {.lex_state = 57, .external_lex_state = 2},
  [561] = {.lex_state = 33, .external_lex_state = 9},
  [562] = {.lex_state = 33, .external_lex_state = 9},
  [563] = {.lex_state = 34, .external_lex_state = 9},
  [564] = {.lex_state = 59, .external_lex_state = 2},
  [565] = {.lex_state = 57, .external_lex_state = 3},
  [566] = {.lex_state = 34, .external_lex_state = 9},
  [567] = {.lex_state = 34, .external_lex_state = 9},
  [568] = {.lex_state = 57, .external_lex_state = 2},
  [569] = {.lex_state = 34, .external_lex_state = 9},
  [570] = {.lex_state = 34, .external_lex_state = 9},
  [571] = {.lex_state = 34, .external_lex_state = 9},
  [572] = {.lex_state = 34, .external_lex_state = 9},
  [573] = {.lex_state = 57, .external_lex_state = 2},
  [574] = {.lex_state = 57, .external_lex_state = 2},
  [575] = {.lex_state = 58, .external_lex_state = 3},
  [576] = {.lex_state = 57, .external_lex_state = 3},
  [577] = {.lex_state = 58, .external_lex_state = 2},
  [578] = {.lex_state = 34, .external_lex_state = 9},
  [579] = {.lex_state = 57, .external_lex_state = 2},
  [580] = {.lex_state = 57, .external_lex_state = 3},
  [581] = {.lex_state = 34, .external_lex_state = 9},
  [582] = {.lex_state = 34, .external_lex_state = 9},
  [583] = {.lex_state = 59, .external_lex_state = 3},
  [584] = {.lex_state = 34, .external_lex_state = 9},
  [585] = {.lex_state = 34, .external_lex_state = 9},
  [586] = {.lex_state = 34, .external_lex_state = 9},
  [587] = {.lex_state = 57, .external_lex_state = 3},
  [588] = {.lex_state = 57, .external_lex_state = 2},
  [589] = {.lex_state = 57, .external_lex_state = 3},
  [590] = {.lex_state = 57, .external_lex_state = 3},
  [591] = {.lex_state = 59, .external_lex_state = 3},
  [592] = {.lex_state = 59, .external_lex_state = 3},
  [593] = {.lex_state = 59, .external_lex_state = 2},
  [594] = {.lex_state = 57, .external_lex_state = 2},
  [595] = {.lex_state = 57, .external_lex_state = 3},
  [596] = {.lex_state = 58, .external_lex_state = 2},
  [597] = {.lex_state = 59, .external_lex_state = 3},
  [598] = {.lex_state = 59, .external_lex_state = 2},
  [599] = {.lex_state = 58, .external_lex_state = 3},
  [600] = {.lex_state = 58, .external_lex_state = 3},
  [601] = {.lex_state = 58, .external_lex_state = 2},
  [602] = {.lex_state = 59, .external_lex_state = 2},
  [603] = {.lex_state = 59, .external_lex_state = 3},
  [604] = {.lex_state = 58, .external_lex_state = 3},
  [605] = {.lex_state = 58, .external_lex_state = 3},
  [606] = {.lex_state = 57, .external_lex_state = 2},
  [607] = {.lex_state = 58, .external_lex_state = 3},
  [608] = {.lex_state = 58, .external_lex_state = 2},
  [609] = {.lex_state = 59, .external_lex_state = 3},
  [610] = {.lex_state = 59, .external_lex_state = 2},
  [611] = {.lex_state = 59, .external_lex_state = 2},
  [612] = {.lex_state = 58, .external_lex_state = 3},
  [613] = {.lex_state = 59, .external_lex_state = 2},
  [614] = {.lex_state = 58, .external_lex_state = 3},
  [615] = {.lex_state = 59, .external_lex_state = 3},
  [616] = {.lex_state = 58, .external_lex_state = 2},
  [617] = {.lex_state = 59, .external_lex_state = 3},
  [618] = {.lex_state = 57, .external_lex_state = 2},
  [619] = {.lex_state = 57, .external_lex_state = 2},
  [620] = {.lex_state = 59, .external_lex_state = 2},
  [621] = {.lex_state = 59, .external_lex_state = 2},
  [622] = {.lex_state = 59, .external_lex_state = 2},
  [623] = {.lex_state = 59, .external_lex_state = 3},
  [624] = {.lex_state = 58, .external_lex_state = 2},
  [625] = {.lex_state = 57, .external_lex_state = 3},
  [626] = {.lex_state = 58, .external_lex_state = 3},
  [627] = {.lex_state = 57, .external_lex_state = 3},
  [628] = {.lex_state = 58, .external_lex_state = 2},
  [629] = {.lex_state = 57, .external_lex_state = 6},
  [630] = {.lex_state = 59, .external_lex_state = 2},
  [631] = {.lex_state = 58, .external_lex_state = 2},
  [632] = {.lex_state = 58, .external_lex_state = 2},
  [633] = {.lex_state = 58, .external_lex_state = 3},
  [634] = {.lex_state = 57, .external_lex_state = 2},
  [635] = {.lex_state = 59, .external_lex_state = 3},
  [636] = {.lex_state = 58, .external_lex_state = 2},
  [637] = {.lex_state = 59, .external_lex_state = 2},
  [638] = {.lex_state = 57, .external_lex_state = 6},
  [639] = {.lex_state = 57, .external_lex_state = 3},
  [640] = {.lex_state = 59, .external_lex_state = 3},
  [641] = {.lex_state = 59, .external_lex_state = 3},
  [642] = {.lex_state = 57, .external_lex_state = 2},
  [643] = {.lex_state = 57, .external_lex_state = 3},
  [644] = {.lex_state = 57, .external_lex_state = 2},
  [645] = {.lex_state = 57, .external_lex_state = 2},
  [646] = {.lex_state = 57, .external_lex_state = 2},
  [647] = {.lex_state = 57, .external_lex_state = 2},
  [648] = {.lex_state = 57, .external_lex_state = 2},
  [649] = {.lex_state = 57, .external_lex_state = 2},
  [650] = {.lex_state = 57, .external_lex_state = 2},
  [651] = {.lex_state = 57, .external_lex_state = 3},
  [652] = {.lex_state = 57, .external_lex_state = 3},
  [653] = {.lex_state = 57, .external_lex_state = 3},
  [654] = {.lex_state = 57, .external_lex_state = 2},
  [655] = {.lex_state = 57, .external_lex_state = 3},
  [656] = {.lex_state = 57, .external_lex_state = 3},
  [657] = {.lex_state = 57, .external_lex_state = 2},
  [658] = {.lex_state = 57, .external_lex_state = 2},
  [659] = {.lex_state = 57, .external_lex_state = 3},
  [660] = {.lex_state = 57, .external_lex_state = 3},
  [661] = {.lex_state = 57, .external_lex_state = 3},
  [662] = {.lex_state = 57, .external_lex_state = 3},
  [663] = {.lex_state = 57, .external_lex_state = 3},
  [664] = {.lex_state = 57, .external_lex_state = 3},
  [665] = {.lex_state = 57, .external_lex_state = 7},
  [666] = {.lex_state = 57, .external_lex_state = 2},
  [667] = {.lex_state = 57, .external_lex_state = 2},
  [668] = {.lex_state = 57, .external_lex_state = 7},
  [669] = {.lex_state = 57, .external_lex_state = 3},
  [670] = {.lex_state = 57, .external_lex_state = 2},
  [671] = {.lex_state = 57, .external_lex_state = 3},
  [672] = {.lex_state = 57, .external_lex_state = 2},
  [673] = {.lex_state = 57, .external_lex_state = 3},
  [674] = {.lex_state = 57, .external_lex_state = 3},
  [675] = {.lex_state = 57, .external_lex_state = 3},
  [676] = {.lex_state = 57, .external_lex_state = 2},
  [677] = {.lex_state = 57, .external_lex_state = 2},
  [678] = {.lex_state = 57, .external_lex_state = 2},
  [679] = {.lex_state = 57, .external_lex_state = 3},
  [680] = {.lex_state = 57, .external_lex_state = 3},
  [681] = {.lex_state = 57, .external_lex_state = 3},
  [682] = {.lex_state = 57, .external_lex_state = 3},
  [683] = {.lex_state = 57, .external_lex_state = 2},
  [684] = {.lex_state = 57, .external_lex_state = 2},
  [685] = {.lex_state = 57, .external_lex_state = 3},
  [686] = {.lex_state = 57, .external_lex_state = 3},
  [687] = {.lex_state = 57, .external_lex_state = 3},
  [688] = {.lex_state = 57, .external_lex_state = 2},
  [689] = {.lex_state = 57, .external_lex_state = 2},
  [690] = {.lex_state = 57, .external_lex_state = 7},
  [691] = {.lex_state = 57, .external_lex_state = 3},
  [692] = {.lex_state = 57, .external_lex_state = 3},
  [693] = {.lex_state = 57, .external_lex_state = 2},
  [694] = {.lex_state = 57, .external_lex_state = 3},
  [695] = {.lex_state = 57, .external_lex_state = 2},
  [696] = {.lex_state = 57, .external_lex_state = 3},
  [697] = {.lex_state = 57, .external_lex_state = 2},
  [698] = {.lex_state = 57, .external_lex_state = 3},
  [699] = {.lex_state = 57, .external_lex_state = 3},
  [700] = {.lex_state = 57, .external_lex_state = 2},
  [701] = {.lex_state = 57, .external_lex_state = 3},
  [702] = {.lex_state = 57, .external_lex_state = 3},
  [703] = {.lex_state = 57, .external_lex_state = 2},
  [704] = {.lex_state = 57, .external_lex_state = 3},
  [705] = {.lex_state = 57, .external_lex_state = 3},
  [706] = {.lex_state = 57, .external_lex_state = 3},
  [707] = {.lex_state = 57, .external_lex_state = 8},
  [708] = {.lex_state = 57, .external_lex_state = 2},
  [709] = {.lex_state = 57, .external_lex_state = 2},
  [710] = {.lex_state = 57, .external_lex_state = 2},
  [711] = {.lex_state = 57, .external_lex_state = 2},
  [712] = {.lex_state = 57, .external_lex_state = 2},
  [713] = {.lex_state = 57, .external_lex_state = 3},
  [714] = {.lex_state = 57, .external_lex_state = 2},
  [715] = {.lex_state = 57, .external_lex_state = 2},
  [716] = {.lex_state = 57, .external_lex_state = 2},
  [717] = {.lex_state = 57, .external_lex_state = 3},
  [718] = {.lex_state = 57, .external_lex_state = 2},
  [719] = {.lex_state = 57, .external_lex_state = 3},
  [720] = {.lex_state = 57, .external_lex_state = 2},
  [721] = {.lex_state = 57, .external_lex_state = 2},
  [722] = {.lex_state = 57, .external_lex_state = 2},
  [723] = {.lex_state = 57, .external_lex_state = 2},
  [724] = {.lex_state = 57, .external_lex_state = 2},
  [725] = {.lex_state = 57, .external_lex_state = 2},
  [726] = {.lex_state = 57, .external_lex_state = 2},
  [727] = {.lex_state = 57, .external_lex_state = 3},
  [728] = {.lex_state = 57, .external_lex_state = 2},
  [729] = {.lex_state = 57, .external_lex_state = 2},
  [730] = {.lex_state = 57, .external_lex_state = 3},
  [731] = {.lex_state = 57, .external_lex_state = 3},
  [732] = {.lex_state = 57, .external_lex_state = 2},
  [733] = {.lex_state = 57, .external_lex_state = 3},
  [734] = {.lex_state = 57, .external_lex_state = 2},
  [735] = {.lex_state = 57, .external_lex_state = 7},
  [736] = {.lex_state = 57, .external_lex_state = 3},
  [737] = {.lex_state = 57, .external_lex_state = 3},
  [738] = {.lex_state = 57, .external_lex_state = 3},
  [739] = {.lex_state = 57, .external_lex_state = 3},
  [740] = {.lex_state = 57, .external_lex_state = 2},
  [741] = {.lex_state = 57, .external_lex_state = 3},
  [742] = {.lex_state = 57, .external_lex_state = 2},
  [743] = {.lex_state = 57, .external_lex_state = 3},
  [744] = {.lex_state = 57, .external_lex_state = 3},
  [745] = {.lex_state = 57, .external_lex_state = 3},
  [746] = {.lex_state = 57, .external_lex_state = 3},
  [747] = {.lex_state = 57, .external_lex_state = 2},
  [748] = {.lex_state = 57, .external_lex_state = 3},
  [749] = {.lex_state = 57, .external_lex_state = 2},
  [750] = {.lex_state = 57, .external_lex_state = 2},
  [751] = {.lex_state = 57, .external_lex_state = 2},
  [752] = {.lex_state = 57, .external_lex_state = 2},
  [753] = {.lex_state = 57, .external_lex_state = 8},
  [754] = {.lex_state = 57, .external_lex_state = 2},
  [755] = {.lex_state = 57, .external_lex_state = 2},
  [756] = {.lex_state = 57, .external_lex_state = 2},
  [757] = {.lex_state = 57, .external_lex_state = 3},
  [758] = {.lex_state = 57, .external_lex_state = 2},
  [759] = {.lex_state = 57, .external_lex_state = 2},
  [760] = {.lex_state = 57, .external_lex_state = 2},
  [761] = {.lex_state = 57, .external_lex_state = 2},
  [762] = {.lex_state = 57, .external_lex_state = 2},
  [763] = {.lex_state = 57, .external_lex_state = 2},
  [764] = {.lex_state = 57, .external_lex_state = 3},
  [765] = {.lex_state = 57, .external_lex_state = 3},
  [766] = {.lex_state = 57, .external_lex_state = 2},
  [767] = {.lex_state = 57, .external_lex_state = 2},
  [768] = {.lex_state = 57, .external_lex_state = 2},
  [769] = {.lex_state = 57, .external_lex_state = 2},
  [770] = {.lex_state = 57, .external_lex_state = 2},
  [771] = {.lex_state = 57, .external_lex_state = 2},
  [772] = {.lex_state = 57, .external_lex_state = 2},
  [773] = {.lex_state = 57, .external_lex_state = 2},
  [774] = {.lex_state = 57, .external_lex_state = 2},
  [775] = {.lex_state = 57, .external_lex_state = 2},
  [776] = {.lex_state = 57, .external_lex_state = 7},
  [777] = {.lex_state = 57, .external_lex_state = 2},
  [778] = {.lex_state = 57, .external_lex_state = 2},
  [779] = {.lex_state = 57, .external_lex_state = 2},
  [780] = {.lex_state = 57, .external_lex_state = 2},
  [781] = {.lex_state = 57, .external_lex_state = 2},
  [782] = {.lex_state = 57, .external_lex_state = 2},
  [783] = {.lex_state = 57, .external_lex_state = 2},
  [784] = {.lex_state = 57, .external_lex_state = 2},
  [785] = {.lex_state = 57, .external_lex_state = 2},
  [786] = {.lex_state = 57, .external_lex_state = 2},
  [787] = {.lex_state = 57, .external_lex_state = 2},
  [788] = {.lex_state = 57, .external_lex_state = 2},
  [789] = {.lex_state = 57, .external_lex_state = 2},
  [790] = {.lex_state = 57, .external_lex_state = 2},
  [791] = {.lex_state = 57, .external_lex_state = 2},
  [792] = {.lex_state = 57, .external_lex_state = 2},
  [793] = {.lex_state = 57, .external_lex_state = 2},
  [794] = {.lex_state = 57, .external_lex_state = 2},
  [795] = {.lex_state = 57, .external_lex_state = 2},
  [796] = {.lex_state = 57, .external_lex_state = 2},
  [797] = {.lex_state = 57, .external_lex_state = 2},
  [798] = {.lex_state = 57, .external_lex_state = 2},
  [799] = {.lex_state = 57, .external_lex_state = 2},
  [800] = {.lex_state = 57, .external_lex_state = 2},
  [801] = {.lex_state = 57, .external_lex_state = 2},
  [802] = {.lex_state = 57, .external_lex_state = 2},
  [803] = {.lex_state = 57, .external_lex_state = 2},
  [804] = {.lex_state = 57, .external_lex_state = 2},
  [805] = {.lex_state = 57, .external_lex_state = 2},
  [806] = {.lex_state = 57, .external_lex_state = 2},
  [807] = {.lex_state = 57, .external_lex_state = 2},
  [808] = {.lex_state = 57, .external_lex_state = 2},
  [809] = {.lex_state = 57, .external_lex_state = 2},
  [810] = {.lex_state = 57, .external_lex_state = 2},
  [811] = {.lex_state = 57, .external_lex_state = 2},
  [812] = {.lex_state = 57, .external_lex_state = 2},
  [813] = {.lex_state = 57, .external_lex_state = 2},
  [814] = {.lex_state = 57, .external_lex_state = 2},
  [815] = {.lex_state = 57, .external_lex_state = 2},
  [816] = {.lex_state = 57, .external_lex_state = 2},
  [817] = {.lex_state = 57, .external_lex_state = 2},
  [818] = {.lex_state = 57, .external_lex_state = 2},
  [819] = {.lex_state = 57, .external_lex_state = 2},
  [820] = {.lex_state = 57, .external_lex_state = 2},
  [821] = {.lex_state = 57, .external_lex_state = 2},
  [822] = {.lex_state = 57, .external_lex_state = 2},
  [823] = {.lex_state = 57, .external_lex_state = 2},
  [824] = {.lex_state = 57, .external_lex_state = 2},
  [825] = {.lex_state = 57, .external_lex_state = 2},
  [826] = {.lex_state = 57, .external_lex_state = 2},
  [827] = {.lex_state = 57, .external_lex_state = 2},
  [828] = {.lex_state = 57, .external_lex_state = 2},
  [829] = {.lex_state = 57, .external_lex_state = 2},
  [830] = {.lex_state = 57, .external_lex_state = 2},
  [831] = {.lex_state = 57, .external_lex_state = 2},
  [832] = {.lex_state = 57, .external_lex_state = 2},
  [833] = {.lex_state = 57, .external_lex_state = 2},
  [834] = {.lex_state = 57, .external_lex_state = 2},
  [835] = {.lex_state = 57, .external_lex_state = 2},
  [836] = {.lex_state = 57, .external_lex_state = 2},
  [837] = {.lex_state = 57, .external_lex_state = 2},
  [838] = {.lex_state = 57, .external_lex_state = 2},
  [839] = {.lex_state = 57, .external_lex_state = 2},
  [840] = {.lex_state = 57, .external_lex_state = 2},
  [841] = {.lex_state = 57, .external_lex_state = 2},
  [842] = {.lex_state = 57, .external_lex_state = 2},
  [843] = {.lex_state = 57, .external_lex_state = 2},
  [844] = {.lex_state = 57, .external_lex_state = 2},
  [845] = {.lex_state = 57, .external_lex_state = 2},
  [846] = {.lex_state = 57, .external_lex_state = 2},
  [847] = {.lex_state = 57, .external_lex_state = 2},
  [848] = {.lex_state = 57, .external_lex_state = 2},
  [849] = {.lex_state = 57, .external_lex_state = 2},
  [850] = {.lex_state = 57, .external_lex_state = 2},
  [851] = {.lex_state = 57, .external_lex_state = 2},
  [852] = {.lex_state = 57, .external_lex_state = 2},
  [853] = {.lex_state = 57, .external_lex_state = 2},
  [854] = {.lex_state = 57, .external_lex_state = 2},
  [855] = {.lex_state = 57, .external_lex_state = 2},
  [856] = {.lex_state = 57, .external_lex_state = 2},
  [857] = {.lex_state = 57, .external_lex_state = 2},
  [858] = {.lex_state = 57, .external_lex_state = 2},
  [859] = {.lex_state = 57, .external_lex_state = 2},
  [860] = {.lex_state = 57, .external_lex_state = 2},
  [861] = {.lex_state = 57, .external_lex_state = 2},
  [862] = {.lex_state = 57, .external_lex_state = 2},
  [863] = {.lex_state = 57, .external_lex_state = 2},
  [864] = {.lex_state = 57, .external_lex_state = 2},
  [865] = {.lex_state = 57, .external_lex_state = 2},
  [866] = {.lex_state = 57, .external_lex_state = 2},
  [867] = {.lex_state = 57, .external_lex_state = 2},
  [868] = {.lex_state = 57, .external_lex_state = 2},
  [869] = {.lex_state = 57, .external_lex_state = 2},
  [870] = {.lex_state = 57, .external_lex_state = 2},
  [871] = {.lex_state = 57, .external_lex_state = 2},
  [872] = {.lex_state = 57, .external_lex_state = 2},
  [873] = {.lex_state = 57, .external_lex_state = 2},
  [874] = {.lex_state = 57, .external_lex_state = 2},
  [875] = {.lex_state = 57, .external_lex_state = 2},
  [876] = {.lex_state = 57, .external_lex_state = 2},
  [877] = {.lex_state = 57, .external_lex_state = 2},
  [878] = {.lex_state = 57, .external_lex_state = 2},
  [879] = {.lex_state = 57, .external_lex_state = 2},
  [880] = {.lex_state = 57, .external_lex_state = 2},
  [881] = {.lex_state = 57, .external_lex_state = 2},
  [882] = {.lex_state = 57, .external_lex_state = 2},
  [883] = {.lex_state = 57, .external_lex_state = 2},
  [884] = {.lex_state = 57, .external_lex_state = 2},
  [885] = {.lex_state = 57, .external_lex_state = 2},
  [886] = {.lex_state = 57, .external_lex_state = 2},
  [887] = {.lex_state = 57, .external_lex_state = 2},
  [888] = {.lex_state = 57, .external_lex_state = 2},
  [889] = {.lex_state = 35, .external_lex_state = 6},
  [890] = {.lex_state = 35, .external_lex_state = 10},
  [891] = {.lex_state = 35, .external_lex_state = 4},
  [892] = {.lex_state = 35, .external_lex_state = 6},
  [893] = {.lex_state = 35, .external_lex_state = 6},
  [894] = {.lex_state = 35, .external_lex_state = 6},
  [895] = {.lex_state = 35, .external_lex_state = 10},
  [896] = {.lex_state = 35, .external_lex_state = 6},
  [897] = {.lex_state = 35, .external_lex_state = 4},
  [898] = {.lex_state = 35, .external_lex_state = 9},
  [899] = {.lex_state = 35, .external_lex_state = 4},
  [900] = {.lex_state = 35, .external_lex_state = 6},
  [901] = {.lex_state = 35, .external_lex_state = 2},
  [902] = {.lex_state = 35, .external_lex_state = 10},
  [903] = {.lex_state = 35, .external_lex_state = 10},
  [904] = {.lex_state = 35, .external_lex_state = 11},
  [905] = {.lex_state = 35, .external_lex_state = 8},
  [906] = {.lex_state = 35, .external_lex_state = 10},
  [907] = {.lex_state = 35, .external_lex_state = 7},
  [908] = {.lex_state = 35, .external_lex_state = 10},
  [909] = {.lex_state = 35, .external_lex_state = 9},
  [910] = {.lex_state = 35, .external_lex_state = 10},
  [911] = {.lex_state = 35, .external_lex_state = 10},
  [912] = {.lex_state = 35, .external_lex_state = 10},
  [913] = {.lex_state = 35, .external_lex_state = 10},
  [914] = {.lex_state = 35, .external_lex_state = 10},
  [915] = {.lex_state = 35, .external_lex_state = 7},
  [916] = {.lex_state = 35, .external_lex_state = 10},
  [917] = {.lex_state = 35, .external_lex_state = 10},
  [918] = {.lex_state = 35, .external_lex_state = 10},
  [919] = {.lex_state = 35, .external_lex_state = 9},
  [920] = {.lex_state = 35, .external_lex_state = 9},
  [921] = {.lex_state = 35, .external_lex_state = 9},
  [922] = {.lex_state = 35, .external_lex_state = 10},
  [923] = {.lex_state = 35, .external_lex_state = 10},
  [924] = {.lex_state = 35, .external_lex_state = 10},
  [925] = {.lex_state = 35, .external_lex_state = 10},
  [926] = {.lex_state = 35, .external_lex_state = 10},
  [927] = {.lex_state = 35, .external_lex_state = 10},
  [928] = {.lex_state = 35, .external_lex_state = 9},
  [929] = {.lex_state = 35, .external_lex_state = 10},
  [930] = {.lex_state = 35, .external_lex_state = 10},
  [931] = {.lex_state = 35, .external_lex_state = 10},
  [932] = {.lex_state = 35, .external_lex_state = 10},
  [933] = {.lex_state = 35, .external_lex_state = 10},
  [934] = {.lex_state = 35, .external_lex_state = 12},
  [935] = {.lex_state = 35, .external_lex_state = 10},
  [936] = {.lex_state = 35, .external_lex_state = 10},
  [937] = {.lex_state = 35, .external_lex_state = 10},
  [938] = {.lex_state = 35, .external_lex_state = 2},
  [939] = {.lex_state = 35, .external_lex_state = 10},
  [940] = {.lex_state = 35, .external_lex_state = 10},
  [941] = {.lex_state = 35, .external_lex_state = 13},
  [942] = {.lex_state = 35, .external_lex_state = 9},
  [943] = {.lex_state = 35, .external_lex_state = 2},
  [944] = {.lex_state = 35, .external_lex_state = 10},
  [945] = {.lex_state = 35, .external_lex_state = 9},
  [946] = {.lex_state = 35, .external_lex_state = 9},
  [947] = {.lex_state = 35, .external_lex_state = 10},
  [948] = {.lex_state = 35, .external_lex_state = 9},
  [949] = {.lex_state = 35, .external_lex_state = 8},
  [950] = {.lex_state = 35, .external_lex_state = 10},
  [951] = {.lex_state = 35, .external_lex_state = 9},
  [952] = {.lex_state = 35, .external_lex_state = 9},
  [953] = {.lex_state = 35, .external_lex_state = 8},
  [954] = {.lex_state = 35, .external_lex_state = 9},
  [955] = {.lex_state = 35, .external_lex_state = 7},
  [956] = {.lex_state = 35, .external_lex_state = 12},
  [957] = {.lex_state = 35, .external_lex_state = 11},
  [958] = {.lex_state = 35, .external_lex_state = 6},
  [959] = {.lex_state = 35, .external_lex_state = 7},
  [960] = {.lex_state = 35, .external_lex_state = 11},
  [961] = {.lex_state = 35, .external_lex_state = 11},
  [962] = {.lex_state = 35, .external_lex_state = 13},
  [963] = {.lex_state = 35, .external_lex_state = 8},
  [964] = {.lex_state = 35, .external_lex_state = 11},
  [965] = {.lex_state = 41, .external_lex_state = 10},
  [966] = {.lex_state = 35, .external_lex_state = 11},
  [967] = {.lex_state = 41, .external_lex_state = 10},
  [968] = {.lex_state = 41, .external_lex_state = 12},
  [969] = {.lex_state = 35, .external_lex_state = 12},
  [970] = {.lex_state = 35, .external_lex_state = 12},
  [971] = {.lex_state = 41, .external_lex_state = 12},
  [972] = {.lex_state = 35, .external_lex_state = 12},
  [973] = {.lex_state = 35, .external_lex_state = 12},
  [974] = {.lex_state = 35, .external_lex_state = 12},
  [975] = {.lex_state = 35, .external_lex_state = 11},
  [976] = {.lex_state = 35, .external_lex_state = 12},
  [977] = {.lex_state = 35, .external_lex_state = 12},
  [978] = {.lex_state = 35, .external_lex_state = 12},
  [979] = {.lex_state = 35, .external_lex_state = 8},
  [980] = {.lex_state = 35, .external_lex_state = 6},
  [981] = {.lex_state = 35, .external_lex_state = 7},
  [982] = {.lex_state = 35, .external_lex_state = 11},
  [983] = {.lex_state = 35, .external_lex_state = 8},
  [984] = {.lex_state = 35, .external_lex_state = 11},
  [985] = {.lex_state = 35, .external_lex_state = 11},
  [986] = {.lex_state = 35, .external_lex_state = 11},
  [987] = {.lex_state = 35, .external_lex_state = 13},
  [988] = {.lex_state = 35, .external_lex_state = 4},
  [989] = {.lex_state = 41, .external_lex_state = 10},
  [990] = {.lex_state = 35, .external_lex_state = 13},
  [991] = {.lex_state = 41, .external_lex_state = 10},
  [992] = {.lex_state = 35, .external_lex_state = 13},
  [993] = {.lex_state = 35, .external_lex_state = 13},
  [994] = {.lex_state = 35, .external_lex_state = 13},
  [995] = {.lex_state = 35, .external_lex_state = 13},
  [996] = {.lex_state = 35, .external_lex_state = 13},
  [997] = {.lex_state = 35, .external_lex_state = 12},
  [998] = {.lex_state = 35, .external_lex_state = 4},
  [999] = {.lex_state = 35, .external_lex_state = 11},
  [1000] = {.lex_state = 41, .external_lex_state = 10},
  [1001] = {.lex_state = 35, .external_lex_state = 12},
  [1002] = {.lex_state = 35, .external_lex_state = 12},
  [1003] = {.lex_state = 41, .external_lex_state = 9},
  [1004] = {.lex_state = 35, .external_lex_state = 6},
  [1005] = {.lex_state = 35, .external_lex_state = 11},
  [1006] = {.lex_state = 41, .external_lex_state = 10},
  [1007] = {.lex_state = 41, .external_lex_state = 10},
  [1008] = {.lex_state = 35, .external_lex_state = 6},
  [1009] = {.lex_state = 35, .external_lex_state = 11},
  [1010] = {.lex_state = 35, .external_lex_state = 9},
  [1011] = {.lex_state = 35, .external_lex_state = 7},
  [1012] = {.lex_state = 35, .external_lex_state = 13},
  [1013] = {.lex_state = 35, .external_lex_state = 13},
  [1014] = {.lex_state = 35, .external_lex_state = 13},
  [1015] = {.lex_state = 35, .external_lex_state = 13},
  [1016] = {.lex_state = 35, .external_lex_state = 12},
  [1017] = {.lex_state = 41, .external_lex_state = 9},
  [1018] = {.lex_state = 41, .external_lex_state = 10},
  [1019] = {.lex_state = 35, .external_lex_state = 9},
  [1020] = {.lex_state = 35, .external_lex_state = 10},
  [1021] = {.lex_state = 35, .external_lex_state = 9},
  [1022] = {.lex_state = 41, .external_lex_state = 12},
  [1023] = {.lex_state = 35, .external_lex_state = 10},
  [1024] = {.lex_state = 35, .external_lex_state = 9},
  [1025] = {.lex_state = 35, .external_lex_state = 9},
  [1026] = {.lex_state = 35, .external_lex_state = 9},
  [1027] = {.lex_state = 41, .external_lex_state = 12},
  [1028] = {.lex_state = 41, .external_lex_state = 12},
  [1029] = {.lex_state = 35, .external_lex_state = 10},
  [1030] = {.lex_state = 35, .external_lex_state = 9},
  [1031] = {.lex_state = 35, .external_lex_state = 9},
  [1032] = {.lex_state = 35, .external_lex_state = 9},
  [1033] = {.lex_state = 35, .external_lex_state = 9},
  [1034] = {.lex_state = 35, .external_lex_state = 9},
  [1035] = {.lex_state = 35, .external_lex_state = 2},
  [1036] = {.lex_state = 35, .external_lex_state = 9},
  [1037] = {.lex_state = 35, .external_lex_state = 9},
  [1038] = {.lex_state = 35, .external_lex_state = 9},
  [1039] = {.lex_state = 35, .external_lex_state = 9},
  [1040] = {.lex_state = 35, .external_lex_state = 2},
  [1041] = {.lex_state = 35, .external_lex_state = 9},
  [1042] = {.lex_state = 35, .external_lex_state = 9},
  [1043] = {.lex_state = 35, .external_lex_state = 9},
  [1044] = {.lex_state = 41, .external_lex_state = 11},
  [1045] = {.lex_state = 35, .external_lex_state = 9},
  [1046] = {.lex_state = 35, .external_lex_state = 9},
  [1047] = {.lex_state = 35, .external_lex_state = 10},
  [1048] = {.lex_state = 35, .external_lex_state = 10},
  [1049] = {.lex_state = 35, .external_lex_state = 11},
  [1050] = {.lex_state = 35, .external_lex_state = 11},
  [1051] = {.lex_state = 35, .external_lex_state = 9},
  [1052] = {.lex_state = 35, .external_lex_state = 10},
  [1053] = {.lex_state = 35, .external_lex_state = 10},
  [1054] = {.lex_state = 35, .external_lex_state = 11},
  [1055] = {.lex_state = 35, .external_lex_state = 11},
  [1056] = {.lex_state = 35, .external_lex_state = 11},
  [1057] = {.lex_state = 35, .external_lex_state = 11},
  [1058] = {.lex_state = 35, .external_lex_state = 11},
  [1059] = {.lex_state = 35, .external_lex_state = 11},
  [1060] = {.lex_state = 35, .external_lex_state = 11},
  [1061] = {.lex_state = 35, .external_lex_state = 11},
  [1062] = {.lex_state = 35, .external_lex_state = 10},
  [1063] = {.lex_state = 35, .external_lex_state = 10},
  [1064] = {.lex_state = 35, .external_lex_state = 9},
  [1065] = {.lex_state = 35, .external_lex_state = 9},
  [1066] = {.lex_state = 35, .external_lex_state = 11},
  [1067] = {.lex_state = 35, .external_lex_state = 11},
  [1068] = {.lex_state = 35, .external_lex_state = 10},
  [1069] = {.lex_state = 35, .external_lex_state = 10},
  [1070] = {.lex_state = 35, .external_lex_state = 11},
  [1071] = {.lex_state = 35, .external_lex_state = 10},
  [1072] = {.lex_state = 35, .external_lex_state = 10},
  [1073] = {.lex_state = 35, .external_lex_state = 10},
  [1074] = {.lex_state = 35, .external_lex_state = 10},
  [1075] = {.lex_state = 35, .external_lex_state = 9},
  [1076] = {.lex_state = 35, .external_lex_state = 10},
  [1077] = {.lex_state = 35, .external_lex_state = 12},
  [1078] = {.lex_state = 35, .external_lex_state = 12},
  [1079] = {.lex_state = 35, .external_lex_state = 10},
  [1080] = {.lex_state = 35, .external_lex_state = 12},
  [1081] = {.lex_state = 35, .external_lex_state = 12},
  [1082] = {.lex_state = 35, .external_lex_state = 12},
  [1083] = {.lex_state = 35, .external_lex_state = 12},
  [1084] = {.lex_state = 35, .external_lex_state = 12},
  [1085] = {.lex_state = 35, .external_lex_state = 12},
  [1086] = {.lex_state = 35, .external_lex_state = 9},
  [1087] = {.lex_state = 35, .external_lex_state = 12},
  [1088] = {.lex_state = 35, .external_lex_state = 12},
  [1089] = {.lex_state = 35, .external_lex_state = 12},
  [1090] = {.lex_state = 35, .external_lex_state = 12},
  [1091] = {.lex_state = 35, .external_lex_state = 10},
  [1092] = {.lex_state = 35, .external_lex_state = 12},
  [1093] = {.lex_state = 35, .external_lex_state = 12},
  [1094] = {.lex_state = 35, .external_lex_state = 10},
  [1095] = {.lex_state = 35, .external_lex_state = 12},
  [1096] = {.lex_state = 35, .external_lex_state = 10},
  [1097] = {.lex_state = 35, .external_lex_state = 10},
  [1098] = {.lex_state = 35, .external_lex_state = 10},
  [1099] = {.lex_state = 35, .external_lex_state = 10},
  [1100] = {.lex_state = 35, .external_lex_state = 10},
  [1101] = {.lex_state = 35, .external_lex_state = 10},
  [1102] = {.lex_state = 35, .external_lex_state = 10},
  [1103] = {.lex_state = 35, .external_lex_state = 10},
  [1104] = {.lex_state = 35, .external_lex_state = 10},
  [1105] = {.lex_state = 35, .external_lex_state = 10},
  [1106] = {.lex_state = 35, .external_lex_state = 10},
  [1107] = {.lex_state = 35, .external_lex_state = 12},
  [1108] = {.lex_state = 35, .external_lex_state = 10},
  [1109] = {.lex_state = 35, .external_lex_state = 10},
  [1110] = {.lex_state = 35, .external_lex_state = 9},
  [1111] = {.lex_state = 35, .external_lex_state = 12},
  [1112] = {.lex_state = 35, .external_lex_state = 12},
  [1113] = {.lex_state = 35, .external_lex_state = 10},
  [1114] = {.lex_state = 35, .external_lex_state = 10},
  [1115] = {.lex_state = 41, .external_lex_state = 12},
  [1116] = {.lex_state = 35, .external_lex_state = 10},
  [1117] = {.lex_state = 35, .external_lex_state = 10},
  [1118] = {.lex_state = 35, .external_lex_state = 10},
  [1119] = {.lex_state = 35, .external_lex_state = 10},
  [1120] = {.lex_state = 35, .external_lex_state = 9},
  [1121] = {.lex_state = 35, .external_lex_state = 9},
  [1122] = {.lex_state = 35, .external_lex_state = 9},
  [1123] = {.lex_state = 35, .external_lex_state = 7},
  [1124] = {.lex_state = 41, .external_lex_state = 11},
  [1125] = {.lex_state = 35, .external_lex_state = 9},
  [1126] = {.lex_state = 41, .external_lex_state = 13},
  [1127] = {.lex_state = 35, .external_lex_state = 9},
  [1128] = {.lex_state = 35, .external_lex_state = 9},
  [1129] = {.lex_state = 35, .external_lex_state = 10},
  [1130] = {.lex_state = 41, .external_lex_state = 13},
  [1131] = {.lex_state = 35, .external_lex_state = 10},
  [1132] = {.lex_state = 41, .external_lex_state = 11},
  [1133] = {.lex_state = 41, .external_lex_state = 11},
  [1134] = {.lex_state = 35, .external_lex_state = 10},
  [1135] = {.lex_state = 35, .external_lex_state = 10},
  [1136] = {.lex_state = 35, .external_lex_state = 10},
  [1137] = {.lex_state = 35, .external_lex_state = 10},
  [1138] = {.lex_state = 35, .external_lex_state = 10},
  [1139] = {.lex_state = 35, .external_lex_state = 10},
  [1140] = {.lex_state = 35, .external_lex_state = 10},
  [1141] = {.lex_state = 35, .external_lex_state = 10},
  [1142] = {.lex_state = 35, .external_lex_state = 10},
  [1143] = {.lex_state = 35, .external_lex_state = 10},
  [1144] = {.lex_state = 35, .external_lex_state = 10},
  [1145] = {.lex_state = 35, .external_lex_state = 10},
  [1146] = {.lex_state = 35, .external_lex_state = 10},
  [1147] = {.lex_state = 35, .external_lex_state = 7},
  [1148] = {.lex_state = 41, .external_lex_state = 11},
  [1149] = {.lex_state = 41, .external_lex_state = 11},
  [1150] = {.lex_state = 35, .external_lex_state = 10},
  [1151] = {.lex_state = 35, .external_lex_state = 10},
  [1152] = {.lex_state = 35, .external_lex_state = 10},
  [1153] = {.lex_state = 35, .external_lex_state = 10},
  [1154] = {.lex_state = 35, .external_lex_state = 10},
  [1155] = {.lex_state = 35, .external_lex_state = 10},
  [1156] = {.lex_state = 35, .external_lex_state = 9},
  [1157] = {.lex_state = 35, .external_lex_state = 8},
  [1158] = {.lex_state = 35, .external_lex_state = 10},
  [1159] = {.lex_state = 41, .external_lex_state = 12},
  [1160] = {.lex_state = 41, .external_lex_state = 12},
  [1161] = {.lex_state = 35, .external_lex_state = 12},
  [1162] = {.lex_state = 35, .external_lex_state = 9},
  [1163] = {.lex_state = 35, .external_lex_state = 9},
  [1164] = {.lex_state = 35, .external_lex_state = 10},
  [1165] = {.lex_state = 35, .external_lex_state = 10},
  [1166] = {.lex_state = 35, .external_lex_state = 10},
  [1167] = {.lex_state = 35, .external_lex_state = 10},
  [1168] = {.lex_state = 35, .external_lex_state = 8},
  [1169] = {.lex_state = 35, .external_lex_state = 10},
  [1170] = {.lex_state = 35, .external_lex_state = 10},
  [1171] = {.lex_state = 35, .external_lex_state = 12},
  [1172] = {.lex_state = 35, .external_lex_state = 10},
  [1173] = {.lex_state = 34, .external_lex_state = 9},
  [1174] = {.lex_state = 35, .external_lex_state = 12},
  [1175] = {.lex_state = 35, .external_lex_state = 12},
  [1176] = {.lex_state = 35, .external_lex_state = 12},
  [1177] = {.lex_state = 35, .external_lex_state = 12},
  [1178] = {.lex_state = 35, .external_lex_state = 12},
  [1179] = {.lex_state = 35, .external_lex_state = 11},
  [1180] = {.lex_state = 35, .external_lex_state = 12},
  [1181] = {.lex_state = 35, .external_lex_state = 13},
  [1182] = {.lex_state = 35, .external_lex_state = 12},
  [1183] = {.lex_state = 35, .external_lex_state = 13},
  [1184] = {.lex_state = 35, .external_lex_state = 13},
  [1185] = {.lex_state = 35, .external_lex_state = 13},
  [1186] = {.lex_state = 35, .external_lex_state = 13},
  [1187] = {.lex_state = 41, .external_lex_state = 11},
  [1188] = {.lex_state = 41, .external_lex_state = 11},
  [1189] = {.lex_state = 35, .external_lex_state = 13},
  [1190] = {.lex_state = 35, .external_lex_state = 12},
  [1191] = {.lex_state = 35, .external_lex_state = 13},
  [1192] = {.lex_state = 35, .external_lex_state = 13},
  [1193] = {.lex_state = 35, .external_lex_state = 13},
  [1194] = {.lex_state = 35, .external_lex_state = 7},
  [1195] = {.lex_state = 35, .external_lex_state = 12},
  [1196] = {.lex_state = 35, .external_lex_state = 11},
  [1197] = {.lex_state = 35, .external_lex_state = 12},
  [1198] = {.lex_state = 35, .external_lex_state = 12},
  [1199] = {.lex_state = 35, .external_lex_state = 7},
  [1200] = {.lex_state = 35, .external_lex_state = 11},
  [1201] = {.lex_state = 35, .external_lex_state = 11},
  [1202] = {.lex_state = 35, .external_lex_state = 13},
  [1203] = {.lex_state = 35, .external_lex_state = 11},
  [1204] = {.lex_state = 35, .external_lex_state = 11},
  [1205] = {.lex_state = 35, .external_lex_state = 13},
  [1206] = {.lex_state = 35, .external_lex_state = 12},
  [1207] = {.lex_state = 35, .external_lex_state = 12},
  [1208] = {.lex_state = 35, .external_lex_state = 12},
  [1209] = {.lex_state = 35, .external_lex_state = 13},
  [1210] = {.lex_state = 35, .external_lex_state = 11},
  [1211] = {.lex_state = 35, .external_lex_state = 13},
  [1212] = {.lex_state = 35, .external_lex_state = 13},
  [1213] = {.lex_state = 35, .external_lex_state = 13},
  [1214] = {.lex_state = 35, .external_lex_state = 11},
  [1215] = {.lex_state = 35, .external_lex_state = 11},
  [1216] = {.lex_state = 35, .external_lex_state = 13},
  [1217] = {.lex_state = 35, .external_lex_state = 13},
  [1218] = {.lex_state = 35, .external_lex_state = 12},
  [1219] = {.lex_state = 35, .external_lex_state = 13},
  [1220] = {.lex_state = 35, .external_lex_state = 12},
  [1221] = {.lex_state = 35, .external_lex_state = 12},
  [1222] = {.lex_state = 34, .external_lex_state = 9},
  [1223] = {.lex_state = 35, .external_lex_state = 13},
  [1224] = {.lex_state = 35, .external_lex_state = 11},
  [1225] = {.lex_state = 35, .external_lex_state = 12},
  [1226] = {.lex_state = 35, .external_lex_state = 13},
  [1227] = {.lex_state = 35, .external_lex_state = 11},
  [1228] = {.lex_state = 35, .external_lex_state = 13},
  [1229] = {.lex_state = 35, .external_lex_state = 12},
  [1230] = {.lex_state = 35, .external_lex_state = 13},
  [1231] = {.lex_state = 35, .external_lex_state = 11},
  [1232] = {.lex_state = 35, .external_lex_state = 11},
  [1233] = {.lex_state = 35, .external_lex_state = 12},
  [1234] = {.lex_state = 35, .external_lex_state = 13},
  [1235] = {.lex_state = 35, .external_lex_state = 13},
  [1236] = {.lex_state = 35, .external_lex_state = 11},
  [1237] = {.lex_state = 35, .external_lex_state = 11},
  [1238] = {.lex_state = 35, .external_lex_state = 11},
  [1239] = {.lex_state = 41, .external_lex_state = 12},
  [1240] = {.lex_state = 35, .external_lex_state = 11},
  [1241] = {.lex_state = 41, .external_lex_state = 12},
  [1242] = {.lex_state = 35, .external_lex_state = 12},
  [1243] = {.lex_state = 35, .external_lex_state = 11},
  [1244] = {.lex_state = 35, .external_lex_state = 11},
  [1245] = {.lex_state = 35, .external_lex_state = 11},
  [1246] = {.lex_state = 35, .external_lex_state = 11},
  [1247] = {.lex_state = 35, .external_lex_state = 11},
  [1248] = {.lex_state = 35, .external_lex_state = 8},
  [1249] = {.lex_state = 35, .external_lex_state = 11},
  [1250] = {.lex_state = 35, .external_lex_state = 11},
  [1251] = {.lex_state = 35, .external_lex_state = 13},
  [1252] = {.lex_state = 35, .external_lex_state = 11},
  [1253] = {.lex_state = 35, .external_lex_state = 11},
  [1254] = {.lex_state = 35, .external_lex_state = 8},
  [1255] = {.lex_state = 35, .external_lex_state = 13},
  [1256] = {.lex_state = 35, .external_lex_state = 11},
  [1257] = {.lex_state = 35, .external_lex_state = 12},
  [1258] = {.lex_state = 35, .external_lex_state = 11},
  [1259] = {.lex_state = 35, .external_lex_state = 11},
  [1260] = {.lex_state = 35, .external_lex_state = 13},
  [1261] = {.lex_state = 35, .external_lex_state = 13},
  [1262] = {.lex_state = 35, .external_lex_state = 13},
  [1263] = {.lex_state = 35, .external_lex_state = 11},
  [1264] = {.lex_state = 35, .external_lex_state = 11},
  [1265] = {.lex_state = 35, .external_lex_state = 13},
  [1266] = {.lex_state = 35, .external_lex_state = 13},
  [1267] = {.lex_state = 35, .external_lex_state = 12},
  [1268] = {.lex_state = 35, .external_lex_state = 11},
  [1269] = {.lex_state = 35, .external_lex_state = 13},
  [1270] = {.lex_state = 35, .external_lex_state = 11},
  [1271] = {.lex_state = 35, .external_lex_state = 11},
  [1272] = {.lex_state = 34, .external_lex_state = 9},
  [1273] = {.lex_state = 35, .external_lex_state = 12},
  [1274] = {.lex_state = 41, .external_lex_state = 12},
  [1275] = {.lex_state = 41, .external_lex_state = 12},
  [1276] = {.lex_state = 34, .external_lex_state = 9},
  [1277] = {.lex_state = 35, .external_lex_state = 11},
  [1278] = {.lex_state = 34, .external_lex_state = 9},
  [1279] = {.lex_state = 35, .external_lex_state = 11},
  [1280] = {.lex_state = 35, .external_lex_state = 11},
  [1281] = {.lex_state = 35, .external_lex_state = 11},
  [1282] = {.lex_state = 35, .external_lex_state = 11},
  [1283] = {.lex_state = 35, .external_lex_state = 12},
  [1284] = {.lex_state = 35, .external_lex_state = 12},
  [1285] = {.lex_state = 35, .external_lex_state = 13},
  [1286] = {.lex_state = 35, .external_lex_state = 12},
  [1287] = {.lex_state = 35, .external_lex_state = 13},
  [1288] = {.lex_state = 35, .external_lex_state = 12},
  [1289] = {.lex_state = 35, .external_lex_state = 12},
  [1290] = {.lex_state = 35, .external_lex_state = 12},
  [1291] = {.lex_state = 35, .external_lex_state = 12},
  [1292] = {.lex_state = 35, .external_lex_state = 12},
  [1293] = {.lex_state = 35, .external_lex_state = 12},
  [1294] = {.lex_state = 35, .external_lex_state = 12},
  [1295] = {.lex_state = 35, .external_lex_state = 11},
  [1296] = {.lex_state = 35, .external_lex_state = 11},
  [1297] = {.lex_state = 35, .external_lex_state = 11},
  [1298] = {.lex_state = 35, .external_lex_state = 11},
  [1299] = {.lex_state = 41, .external_lex_state = 12},
  [1300] = {.lex_state = 41, .external_lex_state = 12},
  [1301] = {.lex_state = 35, .external_lex_state = 12},
  [1302] = {.lex_state = 35, .external_lex_state = 11},
  [1303] = {.lex_state = 35, .external_lex_state = 12},
  [1304] = {.lex_state = 35, .external_lex_state = 12},
  [1305] = {.lex_state = 41, .external_lex_state = 11},
  [1306] = {.lex_state = 41, .external_lex_state = 11},
  [1307] = {.lex_state = 41, .external_lex_state = 10},
  [1308] = {.lex_state = 41, .external_lex_state = 10},
  [1309] = {.lex_state = 35, .external_lex_state = 12},
  [1310] = {.lex_state = 35, .external_lex_state = 11},
  [1311] = {.lex_state = 35, .external_lex_state = 12},
  [1312] = {.lex_state = 35, .external_lex_state = 12},
  [1313] = {.lex_state = 35, .external_lex_state = 11},
  [1314] = {.lex_state = 35, .external_lex_state = 12},
  [1315] = {.lex_state = 35, .external_lex_state = 11},
  [1316] = {.lex_state = 35, .external_lex_state = 12},
  [1317] = {.lex_state = 35, .external_lex_state = 11},
  [1318] = {.lex_state = 35, .external_lex_state = 12},
  [1319] = {.lex_state = 35, .external_lex_state = 11},
  [1320] = {.lex_state = 35, .external_lex_state = 12},
  [1321] = {.lex_state = 35, .external_lex_state = 11},
  [1322] = {.lex_state = 35, .external_lex_state = 12},
  [1323] = {.lex_state = 35, .external_lex_state = 11},
  [1324] = {.lex_state = 35, .external_lex_state = 11},
  [1325] = {.lex_state = 35, .external_lex_state = 11},
  [1326] = {.lex_state = 35, .external_lex_state = 12},
  [1327] = {.lex_state = 35, .external_lex_state = 11},
  [1328] = {.lex_state = 35, .external_lex_state = 11},
  [1329] = {.lex_state = 35, .external_lex_state = 11},
  [1330] = {.lex_state = 35, .external_lex_state = 11},
  [1331] = {.lex_state = 35, .external_lex_state = 11},
  [1332] = {.lex_state = 35, .external_lex_state = 11},
  [1333] = {.lex_state = 35, .external_lex_state = 12},
  [1334] = {.lex_state = 35, .external_lex_state = 11},
  [1335] = {.lex_state = 35, .external_lex_state = 11},
  [1336] = {.lex_state = 35, .external_lex_state = 11},
  [1337] = {.lex_state = 35, .external_lex_state = 11},
  [1338] = {.lex_state = 35, .external_lex_state = 12},
  [1339] = {.lex_state = 35, .external_lex_state = 12},
  [1340] = {.lex_state = 35, .external_lex_state = 12},
  [1341] = {.lex_state = 35, .external_lex_state = 11},
  [1342] = {.lex_state = 35, .external_lex_state = 11},
  [1343] = {.lex_state = 35, .external_lex_state = 12},
  [1344] = {.lex_state = 35, .external_lex_state = 11},
  [1345] = {.lex_state = 35, .external_lex_state = 12},
  [1346] = {.lex_state = 35, .external_lex_state = 12},
  [1347] = {.lex_state = 35, .external_lex_state = 12},
  [1348] = {.lex_state = 35, .external_lex_state = 12},
  [1349] = {.lex_state = 35, .external_lex_state = 11},
  [1350] = {.lex_state = 35, .external_lex_state = 12},
  [1351] = {.lex_state = 35, .external_lex_state = 11},
  [1352] = {.lex_state = 35, .external_lex_state = 12},
  [1353] = {.lex_state = 35, .external_lex_state = 11},
  [1354] = {.lex_state = 35, .external_lex_state = 11},
  [1355] = {.lex_state = 35, .external_lex_state = 12},
  [1356] = {.lex_state = 35, .external_lex_state = 12},
  [1357] = {.lex_state = 35, .external_lex_state = 12},
  [1358] = {.lex_state = 35, .external_lex_state = 11},
  [1359] = {.lex_state = 35, .external_lex_state = 11},
  [1360] = {.lex_state = 35, .external_lex_state = 12},
  [1361] = {.lex_state = 35, .external_lex_state = 12},
  [1362] = {.lex_state = 35, .external_lex_state = 12},
  [1363] = {.lex_state = 35, .external_lex_state = 12},
  [1364] = {.lex_state = 35, .external_lex_state = 11},
  [1365] = {.lex_state = 35, .external_lex_state = 12},
  [1366] = {.lex_state = 35, .external_lex_state = 12},
  [1367] = {.lex_state = 34, .external_lex_state = 13},
  [1368] = {.lex_state = 34, .external_lex_state = 13},
  [1369] = {.lex_state = 35, .external_lex_state = 10},
  [1370] = {.lex_state = 34, .external_lex_state = 13},
  [1371] = {.lex_state = 34, .external_lex_state = 13},
  [1372] = {.lex_state = 34, .external_lex_state = 13},
  [1373] = {.lex_state = 34, .external_lex_state = 13},
  [1374] = {.lex_state = 35, .external_lex_state = 11},
  [1375] = {.lex_state = 34, .external_lex_state = 13},
  [1376] = {.lex_state = 34, .external_lex_state = 13},
  [1377] = {.lex_state = 35, .external_lex_state = 12},
  [1378] = {.lex_state = 34, .external_lex_state = 13},
  [1379] = {.lex_state = 34, .external_lex_state = 13},
  [1380] = {.lex_state = 34, .external_lex_state = 13},
  [1381] = {.lex_state = 34, .external_lex_state = 13},
  [1382] = {.lex_state = 34, .external_lex_state = 13},
  [1383] = {.lex_state = 34, .external_lex_state = 13},
  [1384] = {.lex_state = 35, .external_lex_state = 10},
  [1385] = {.lex_state = 35, .external_lex_state = 10},
  [1386] = {.lex_state = 35, .external_lex_state = 10},
  [1387] = {.lex_state = 35, .external_lex_state = 10},
  [1388] = {.lex_state = 35, .external_lex_state = 10},
  [1389] = {.lex_state = 57, .external_lex_state = 9},
  [1390] = {.lex_state = 57, .external_lex_state = 10},
  [1391] = {.lex_state = 57, .external_lex_state = 10},
  [1392] = {.lex_state = 57, .external_lex_state = 9},
  [1393] = {.lex_state = 57, .external_lex_state = 10},
  [1394] = {.lex_state = 57, .external_lex_state = 10},
  [1395] = {.lex_state = 57, .external_lex_state = 11},
  [1396] = {.lex_state = 35, .external_lex_state = 12},
  [1397] = {.lex_state = 57, .external_lex_state = 11},
  [1398] = {.lex_state = 39, .external_lex_state = 9},
  [1399] = {.lex_state = 57, .external_lex_state = 12},
  [1400] = {.lex_state = 57, .external_lex_state = 13},
  [1401] = {.lex_state = 57, .external_lex_state = 12},
  [1402] = {.lex_state = 35, .external_lex_state = 12},
  [1403] = {.lex_state = 35, .external_lex_state = 12},
  [1404] = {.lex_state = 35, .external_lex_state = 12},
  [1405] = {.lex_state = 39, .external_lex_state = 9},
  [1406] = {.lex_state = 57, .external_lex_state = 13},
  [1407] = {.lex_state = 35, .external_lex_state = 11},
  [1408] = {.lex_state = 35, .external_lex_state = 13},
  [1409] = {.lex_state = 35, .external_lex_state = 11},
  [1410] = {.lex_state = 57, .external_lex_state = 11},
  [1411] = {.lex_state = 39, .external_lex_state = 9},
  [1412] = {.lex_state = 35, .external_lex_state = 13},
  [1413] = {.lex_state = 35, .external_lex_state = 13},
  [1414] = {.lex_state = 35, .external_lex_state = 13},
  [1415] = {.lex_state = 39, .external_lex_state = 9},
  [1416] = {.lex_state = 35, .external_lex_state = 13},
  [1417] = {.lex_state = 35, .external_lex_state = 13},
  [1418] = {.lex_state = 35, .external_lex_state = 13},
  [1419] = {.lex_state = 35, .external_lex_state = 13},
  [1420] = {.lex_state = 57, .external_lex_state = 11},
  [1421] = {.lex_state = 39, .external_lex_state = 9},
  [1422] = {.lex_state = 57, .external_lex_state = 12},
  [1423] = {.lex_state = 35, .external_lex_state = 13},
  [1424] = {.lex_state = 35, .external_lex_state = 12},
  [1425] = {.lex_state = 35, .external_lex_state = 11},
  [1426] = {.lex_state = 39, .external_lex_state = 9},
  [1427] = {.lex_state = 35, .external_lex_state = 12},
  [1428] = {.lex_state = 35, .external_lex_state = 11},
  [1429] = {.lex_state = 35, .external_lex_state = 13},
  [1430] = {.lex_state = 35, .external_lex_state = 13},
  [1431] = {.lex_state = 35, .external_lex_state = 13},
  [1432] = {.lex_state = 35, .external_lex_state = 11},
  [1433] = {.lex_state = 35, .external_lex_state = 13},
  [1434] = {.lex_state = 57, .external_lex_state = 12},
  [1435] = {.lex_state = 35, .external_lex_state = 13},
  [1436] = {.lex_state = 35, .external_lex_state = 13},
  [1437] = {.lex_state = 35, .external_lex_state = 12},
  [1438] = {.lex_state = 35, .external_lex_state = 12},
  [1439] = {.lex_state = 35, .external_lex_state = 12},
  [1440] = {.lex_state = 35, .external_lex_state = 13},
  [1441] = {.lex_state = 35, .external_lex_state = 13},
  [1442] = {.lex_state = 35, .external_lex_state = 13},
  [1443] = {.lex_state = 35, .external_lex_state = 13},
  [1444] = {.lex_state = 39, .external_lex_state = 9},
  [1445] = {.lex_state = 31, .external_lex_state = 13},
  [1446] = {.lex_state = 31, .external_lex_state = 13},
  [1447] = {.lex_state = 39, .external_lex_state = 13},
  [1448] = {.lex_state = 39, .external_lex_state = 13},
  [1449] = {.lex_state = 39, .external_lex_state = 13},
  [1450] = {.lex_state = 31, .external_lex_state = 13},
  [1451] = {.lex_state = 39, .external_lex_state = 13},
  [1452] = {.lex_state = 31, .external_lex_state = 13},
  [1453] = {.lex_state = 39, .external_lex_state = 13},
  [1454] = {.lex_state = 31, .external_lex_state = 13},
  [1455] = {.lex_state = 31, .external_lex_state = 13},
  [1456] = {.lex_state = 39, .external_lex_state = 13},
  [1457] = {.lex_state = 31, .external_lex_state = 13},
  [1458] = {.lex_state = 31, .external_lex_state = 13},
  [1459] = {.lex_state = 31, .external_lex_state = 13},
  [1460] = {.lex_state = 31, .external_lex_state = 13},
  [1461] = {.lex_state = 39, .external_lex_state = 13},
  [1462] = {.lex_state = 31, .external_lex_state = 13},
  [1463] = {.lex_state = 39, .external_lex_state = 13},
  [1464] = {.lex_state = 31, .external_lex_state = 12},
  [1465] = {.lex_state = 39, .external_lex_state = 13},
  [1466] = {.lex_state = 31, .external_lex_state = 13},
  [1467] = {.lex_state = 31, .external_lex_state = 13},
  [1468] = {.lex_state = 31, .external_lex_state = 12},
  [1469] = {.lex_state = 31, .external_lex_state = 12},
  [1470] = {.lex_state = 31, .external_lex_state = 13},
  [1471] = {.lex_state = 31, .external_lex_state = 13},
  [1472] = {.lex_state = 57, .external_lex_state = 10},
  [1473] = {.lex_state = 57, .external_lex_state = 10},
  [1474] = {.lex_state = 57, .external_lex_state = 10},
  [1475] = {.lex_state = 57, .external_lex_state = 10},
  [1476] = {.lex_state = 57, .external_lex_state = 10},
  [1477] = {.lex_state = 57, .external_lex_state = 10},
  [1478] = {.lex_state = 57, .external_lex_state = 10},
  [1479] = {.lex_state = 57, .external_lex_state = 10},
  [1480] = {.lex_state = 57, .external_lex_state = 12},
  [1481] = {.lex_state = 57, .external_lex_state = 12},
  [1482] = {.lex_state = 57, .external_lex_state = 12},
  [1483] = {.lex_state = 57, .external_lex_state = 12},
  [1484] = {.lex_state = 57, .external_lex_state = 12},
  [1485] = {.lex_state = 57, .external_lex_state = 12},
  [1486] = {.lex_state = 57, .external_lex_state = 12},
  [1487] = {.lex_state = 57, .external_lex_state = 12},
  [1488] = {.lex_state = 57, .external_lex_state = 11},
  [1489] = {.lex_state = 57, .external_lex_state = 12},
  [1490] = {.lex_state = 57, .external_lex_state = 12},
  [1491] = {.lex_state = 57, .external_lex_state = 11},
  [1492] = {.lex_state = 57, .external_lex_state = 11},
  [1493] = {.lex_state = 57, .external_lex_state = 11},
  [1494] = {.lex_state = 57, .external_lex_state = 12},
  [1495] = {.lex_state = 57, .external_lex_state = 11},
  [1496] = {.lex_state = 57, .external_lex_state = 12},
  [1497] = {.lex_state = 57, .external_lex_state = 12},
  [1498] = {.lex_state = 57, .external_lex_state = 11},
  [1499] = {.lex_state = 57, .external_lex_state = 12},
  [1500] = {.lex_state = 57, .external_lex_state = 11},
  [1501] = {.lex_state = 57, .external_lex_state = 12},
  [1502] = {.lex_state = 57, .external_lex_state = 12},
  [1503] = {.lex_state = 57, .external_lex_state = 11},
  [1504] = {.lex_state = 57, .external_lex_state = 12},
  [1505] = {.lex_state = 36, .external_lex_state = 14},
  [1506] = {.lex_state = 36, .external_lex_state = 14},
  [1507] = {.lex_state = 36, .external_lex_state = 14},
  [1508] = {.lex_state = 36, .external_lex_state = 14},
  [1509] = {.lex_state = 36, .external_lex_state = 14},
  [1510] = {.lex_state = 36, .external_lex_state = 14},
  [1511] = {.lex_state = 36, .external_lex_state = 14},
  [1512] = {.lex_state = 36, .external_lex_state = 14},
  [1513] = {.lex_state = 36, .external_lex_state = 14},
  [1514] = {.lex_state = 57, .external_lex_state = 10},
  [1515] = {.lex_state = 36, .external_lex_state = 14},
  [1516] = {.lex_state = 36, .external_lex_state = 14},
  [1517] = {.lex_state = 36, .external_lex_state = 14},
  [1518] = {.lex_state = 36, .external_lex_state = 14},
  [1519] = {.lex_state = 57, .external_lex_state = 10},
  [1520] = {.lex_state = 36, .external_lex_state = 14},
  [1521] = {.lex_state = 36, .external_lex_state = 14},
  [1522] = {.lex_state = 36, .external_lex_state = 14},
  [1523] = {.lex_state = 36, .external_lex_state = 14},
  [1524] = {.lex_state = 36, .external_lex_state = 14},
  [1525] = {.lex_state = 36, .external_lex_state = 14},
  [1526] = {.lex_state = 57, .external_lex_state = 10},
  [1527] = {.lex_state = 57, .external_lex_state = 9},
  [1528] = {.lex_state = 57, .external_lex_state = 10},
  [1529] = {.lex_state = 57, .external_lex_state = 10},
  [1530] = {.lex_state = 57, .external_lex_state = 10},
  [1531] = {.lex_state = 57, .external_lex_state = 9},
  [1532] = {.lex_state = 57, .external_lex_state = 9},
  [1533] = {.lex_state = 57, .external_lex_state = 9},
  [1534] = {.lex_state = 57, .external_lex_state = 9},
  [1535] = {.lex_state = 57, .external_lex_state = 10},
  [1536] = {.lex_state = 57, .external_lex_state = 10},
  [1537] = {.lex_state = 57, .external_lex_state = 10},
  [1538] = {.lex_state = 57, .external_lex_state = 9},
  [1539] = {.lex_state = 57, .external_lex_state = 9},
  [1540] = {.lex_state = 57, .external_lex_state = 10},
  [1541] = {.lex_state = 57, .external_lex_state = 9},
  [1542] = {.lex_state = 57, .external_lex_state = 10},
  [1543] = {.lex_state = 57, .external_lex_state = 9},
  [1544] = {.lex_state = 57, .external_lex_state = 9},
  [1545] = {.lex_state = 57, .external_lex_state = 10},
  [1546] = {.lex_state = 57, .external_lex_state = 10},
  [1547] = {.lex_state = 57, .external_lex_state = 10},
  [1548] = {.lex_state = 57, .external_lex_state = 10},
  [1549] = {.lex_state = 57, .external_lex_state = 10},
  [1550] = {.lex_state = 57, .external_lex_state = 10},
  [1551] = {.lex_state = 57, .external_lex_state = 10},
  [1552] = {.lex_state = 57, .external_lex_state = 10},
  [1553] = {.lex_state = 57, .external_lex_state = 10},
  [1554] = {.lex_state = 57, .external_lex_state = 10},
  [1555] = {.lex_state = 57, .external_lex_state = 10},
  [1556] = {.lex_state = 57, .external_lex_state = 13},
  [1557] = {.lex_state = 57, .external_lex_state = 11},
  [1558] = {.lex_state = 57, .external_lex_state = 10},
  [1559] = {.lex_state = 57, .external_lex_state = 11},
  [1560] = {.lex_state = 57, .external_lex_state = 11},
  [1561] = {.lex_state = 38, .external_lex_state = 13},
  [1562] = {.lex_state = 57, .external_lex_state = 11},
  [1563] = {.lex_state = 57, .external_lex_state = 12},
  [1564] = {.lex_state = 57, .external_lex_state = 11},
  [1565] = {.lex_state = 57, .external_lex_state = 13},
  [1566] = {.lex_state = 57, .external_lex_state = 13},
  [1567] = {.lex_state = 57, .external_lex_state = 12},
  [1568] = {.lex_state = 57, .external_lex_state = 13},
  [1569] = {.lex_state = 57, .external_lex_state = 10},
  [1570] = {.lex_state = 57, .external_lex_state = 13},
  [1571] = {.lex_state = 57, .external_lex_state = 11},
  [1572] = {.lex_state = 57, .external_lex_state = 11},
  [1573] = {.lex_state = 57, .external_lex_state = 11},
  [1574] = {.lex_state = 57, .external_lex_state = 11},
  [1575] = {.lex_state = 38, .external_lex_state = 13},
  [1576] = {.lex_state = 57, .external_lex_state = 9},
  [1577] = {.lex_state = 57, .external_lex_state = 11},
  [1578] = {.lex_state = 57, .external_lex_state = 11},
  [1579] = {.lex_state = 38, .external_lex_state = 13},
  [1580] = {.lex_state = 57, .external_lex_state = 9},
  [1581] = {.lex_state = 57, .external_lex_state = 13},
  [1582] = {.lex_state = 57, .external_lex_state = 11},
  [1583] = {.lex_state = 57, .external_lex_state = 12},
  [1584] = {.lex_state = 57, .external_lex_state = 12},
  [1585] = {.lex_state = 57, .external_lex_state = 10},
  [1586] = {.lex_state = 57, .external_lex_state = 13},
  [1587] = {.lex_state = 57, .external_lex_state = 11},
  [1588] = {.lex_state = 57, .external_lex_state = 11},
  [1589] = {.lex_state = 57, .external_lex_state = 11},
  [1590] = {.lex_state = 57, .external_lex_state = 12},
  [1591] = {.lex_state = 57, .external_lex_state = 9},
  [1592] = {.lex_state = 57, .external_lex_state = 11},
  [1593] = {.lex_state = 57, .external_lex_state = 12},
  [1594] = {.lex_state = 57, .external_lex_state = 12},
  [1595] = {.lex_state = 57, .external_lex_state = 11},
  [1596] = {.lex_state = 57, .external_lex_state = 11},
  [1597] = {.lex_state = 57, .external_lex_state = 12},
  [1598] = {.lex_state = 57, .external_lex_state = 11},
  [1599] = {.lex_state = 57, .external_lex_state = 9},
  [1600] = {.lex_state = 57, .external_lex_state = 12},
  [1601] = {.lex_state = 38, .external_lex_state = 13},
  [1602] = {.lex_state = 57, .external_lex_state = 13},
  [1603] = {.lex_state = 57, .external_lex_state = 12},
  [1604] = {.lex_state = 57, .external_lex_state = 13},
  [1605] = {.lex_state = 57, .external_lex_state = 9},
  [1606] = {.lex_state = 57, .external_lex_state = 12},
  [1607] = {.lex_state = 57, .external_lex_state = 9},
  [1608] = {.lex_state = 57, .external_lex_state = 9},
  [1609] = {.lex_state = 57, .external_lex_state = 13},
  [1610] = {.lex_state = 57, .external_lex_state = 10},
  [1611] = {.lex_state = 57, .external_lex_state = 9},
  [1612] = {.lex_state = 57, .external_lex_state = 11},
  [1613] = {.lex_state = 57, .external_lex_state = 11},
  [1614] = {.lex_state = 57, .external_lex_state = 12},
  [1615] = {.lex_state = 57, .external_lex_state = 13},
  [1616] = {.lex_state = 57, .external_lex_state = 11},
  [1617] = {.lex_state = 57, .external_lex_state = 9},
  [1618] = {.lex_state = 57, .external_lex_state = 13},
  [1619] = {.lex_state = 57, .external_lex_state = 13},
  [1620] = {.lex_state = 57, .external_lex_state = 11},
  [1621] = {.lex_state = 57, .external_lex_state = 10},
  [1622] = {.lex_state = 57, .external_lex_state = 11},
  [1623] = {.lex_state = 57, .external_lex_state = 11},
  [1624] = {.lex_state = 57, .external_lex_state = 11},
  [1625] = {.lex_state = 57, .external_lex_state = 10},
  [1626] = {.lex_state = 57, .external_lex_state = 11},
  [1627] = {.lex_state = 57, .external_lex_state = 11},
  [1628] = {.lex_state = 57, .external_lex_state = 11},
  [1629] = {.lex_state = 36, .external_lex_state = 14},
  [1630] = {.lex_state = 57, .external_lex_state = 12},
  [1631] = {.lex_state = 57, .external_lex_state = 9},
  [1632] = {.lex_state = 57, .external_lex_state = 13},
  [1633] = {.lex_state = 57, .external_lex_state = 13},
  [1634] = {.lex_state = 57, .external_lex_state = 13},
  [1635] = {.lex_state = 57, .external_lex_state = 11},
  [1636] = {.lex_state = 57, .external_lex_state = 12},
  [1637] = {.lex_state = 57, .external_lex_state = 10},
  [1638] = {.lex_state = 57, .external_lex_state = 9},
  [1639] = {.lex_state = 57, .external_lex_state = 11},
  [1640] = {.lex_state = 57, .external_lex_state = 12},
  [1641] = {.lex_state = 57, .external_lex_state = 11},
  [1642] = {.lex_state = 57, .external_lex_state = 10},
  [1643] = {.lex_state = 57, .external_lex_state = 13},
  [1644] = {.lex_state = 57, .external_lex_state = 12},
  [1645] = {.lex_state = 57, .external_lex_state = 10},
  [1646] = {.lex_state = 33, .external_lex_state = 13},
  [1647] = {.lex_state = 57, .external_lex_state = 11},
  [1648] = {.lex_state = 57, .external_lex_state = 11},
  [1649] = {.lex_state = 57, .external_lex_state = 10},
  [1650] = {.lex_state = 57, .external_lex_state = 10},
  [1651] = {.lex_state = 57, .external_lex_state = 9},
  [1652] = {.lex_state = 57, .external_lex_state = 11},
  [1653] = {.lex_state = 57, .external_lex_state = 11},
  [1654] = {.lex_state = 57, .external_lex_state = 12},
  [1655] = {.lex_state = 57, .external_lex_state = 10},
  [1656] = {.lex_state = 57, .external_lex_state = 12},
  [1657] = {.lex_state = 36, .external_lex_state = 14},
  [1658] = {.lex_state = 57, .external_lex_state = 12},
  [1659] = {.lex_state = 57, .external_lex_state = 10},
  [1660] = {.lex_state = 57, .external_lex_state = 12},
  [1661] = {.lex_state = 57, .external_lex_state = 11},
  [1662] = {.lex_state = 57, .external_lex_state = 12},
  [1663] = {.lex_state = 57, .external_lex_state = 11},
  [1664] = {.lex_state = 57, .external_lex_state = 10},
  [1665] = {.lex_state = 57, .external_lex_state = 11},
  [1666] = {.lex_state = 57, .external_lex_state = 12},
  [1667] = {.lex_state = 57, .external_lex_state = 12},
  [1668] = {.lex_state = 57, .external_lex_state = 12},
  [1669] = {.lex_state = 57, .external_lex_state = 12},
  [1670] = {.lex_state = 57, .external_lex_state = 12},
  [1671] = {.lex_state = 57, .external_lex_state = 10},
  [1672] = {.lex_state = 57, .external_lex_state = 12},
  [1673] = {.lex_state = 57, .external_lex_state = 10},
  [1674] = {.lex_state = 57, .external_lex_state = 12},
  [1675] = {.lex_state = 57, .external_lex_state = 13},
  [1676] = {.lex_state = 57, .external_lex_state = 13},
  [1677] = {.lex_state = 57, .external_lex_state = 13},
  [1678] = {.lex_state = 57, .external_lex_state = 12},
  [1679] = {.lex_state = 33, .external_lex_state = 9},
  [1680] = {.lex_state = 33, .external_lex_state = 9},
  [1681] = {.lex_state = 57, .external_lex_state = 12},
  [1682] = {.lex_state = 57, .external_lex_state = 10},
  [1683] = {.lex_state = 33, .external_lex_state = 9},
  [1684] = {.lex_state = 57, .external_lex_state = 12},
  [1685] = {.lex_state = 57, .external_lex_state = 10},
  [1686] = {.lex_state = 57, .external_lex_state = 10},
  [1687] = {.lex_state = 57, .external_lex_state = 9},
  [1688] = {.lex_state = 57, .external_lex_state = 12},
  [1689] = {.lex_state = 57, .external_lex_state = 11},
  [1690] = {.lex_state = 57, .external_lex_state = 12},
  [1691] = {.lex_state = 57, .external_lex_state = 11},
  [1692] = {.lex_state = 57, .external_lex_state = 11},
  [1693] = {.lex_state = 57, .external_lex_state = 11},
  [1694] = {.lex_state = 57, .external_lex_state = 13},
  [1695] = {.lex_state = 57, .external_lex_state = 13},
  [1696] = {.lex_state = 57, .external_lex_state = 10},
  [1697] = {.lex_state = 57, .external_lex_state = 11},
  [1698] = {.lex_state = 57, .external_lex_state = 11},
  [1699] = {.lex_state = 57, .external_lex_state = 12},
  [1700] = {.lex_state = 57, .external_lex_state = 11},
  [1701] = {.lex_state = 57, .external_lex_state = 10},
  [1702] = {.lex_state = 57, .external_lex_state = 10},
  [1703] = {.lex_state = 57, .external_lex_state = 13},
  [1704] = {.lex_state = 57, .external_lex_state = 10},
  [1705] = {.lex_state = 57, .external_lex_state = 10},
  [1706] = {.lex_state = 57, .external_lex_state = 13},
  [1707] = {.lex_state = 57, .external_lex_state = 13},
  [1708] = {.lex_state = 57, .external_lex_state = 13},
  [1709] = {.lex_state = 57, .external_lex_state = 9},
  [1710] = {.lex_state = 57, .external_lex_state = 13},
  [1711] = {.lex_state = 57, .external_lex_state = 12},
  [1712] = {.lex_state = 36, .external_lex_state = 14},
  [1713] = {.lex_state = 36, .external_lex_state = 14},
  [1714] = {.lex_state = 36, .external_lex_state = 14},
  [1715] = {.lex_state = 57, .external_lex_state = 10},
  [1716] = {.lex_state = 36, .external_lex_state = 14},
  [1717] = {.lex_state = 57, .external_lex_state = 12},
  [1718] = {.lex_state = 57, .external_lex_state = 12},
  [1719] = {.lex_state = 57, .external_lex_state = 11},
  [1720] = {.lex_state = 57, .external_lex_state = 12},
  [1721] = {.lex_state = 57, .external_lex_state = 9},
  [1722] = {.lex_state = 57, .external_lex_state = 13},
  [1723] = {.lex_state = 57, .external_lex_state = 10},
  [1724] = {.lex_state = 57, .external_lex_state = 12},
  [1725] = {.lex_state = 57, .external_lex_state = 12},
  [1726] = {.lex_state = 57, .external_lex_state = 13},
  [1727] = {.lex_state = 57, .external_lex_state = 12},
  [1728] = {.lex_state = 57, .external_lex_state = 12},
  [1729] = {.lex_state = 57, .external_lex_state = 12},
  [1730] = {.lex_state = 57, .external_lex_state = 10},
  [1731] = {.lex_state = 57, .external_lex_state = 10},
  [1732] = {.lex_state = 36, .external_lex_state = 14},
  [1733] = {.lex_state = 57, .external_lex_state = 11},
  [1734] = {.lex_state = 57, .external_lex_state = 10},
  [1735] = {.lex_state = 36, .external_lex_state = 14},
  [1736] = {.lex_state = 57, .external_lex_state = 11},
  [1737] = {.lex_state = 57, .external_lex_state = 11},
  [1738] = {.lex_state = 57, .external_lex_state = 11},
  [1739] = {.lex_state = 57, .external_lex_state = 12},
  [1740] = {.lex_state = 57, .external_lex_state = 13},
  [1741] = {.lex_state = 36, .external_lex_state = 14},
  [1742] = {.lex_state = 57, .external_lex_state = 13},
  [1743] = {.lex_state = 36, .external_lex_state = 14},
  [1744] = {.lex_state = 57, .external_lex_state = 13},
  [1745] = {.lex_state = 57, .external_lex_state = 9},
  [1746] = {.lex_state = 57, .external_lex_state = 10},
  [1747] = {.lex_state = 33, .external_lex_state = 12},
  [1748] = {.lex_state = 33, .external_lex_state = 9},
  [1749] = {.lex_state = 57, .external_lex_state = 10},
  [1750] = {.lex_state = 57, .external_lex_state = 13},
  [1751] = {.lex_state = 57, .external_lex_state = 11},
  [1752] = {.lex_state = 57, .external_lex_state = 13},
  [1753] = {.lex_state = 57, .external_lex_state = 10},
  [1754] = {.lex_state = 57, .external_lex_state = 13},
  [1755] = {.lex_state = 57, .external_lex_state = 9},
  [1756] = {.lex_state = 57, .external_lex_state = 9},
  [1757] = {.lex_state = 57, .external_lex_state = 11},
  [1758] = {.lex_state = 57, .external_lex_state = 13},
  [1759] = {.lex_state = 57, .external_lex_state = 13},
  [1760] = {.lex_state = 57, .external_lex_state = 13},
  [1761] = {.lex_state = 57, .external_lex_state = 10},
  [1762] = {.lex_state = 57, .external_lex_state = 10},
  [1763] = {.lex_state = 57, .external_lex_state = 9},
  [1764] = {.lex_state = 3, .external_lex_state = 10},
  [1765] = {.lex_state = 57, .external_lex_state = 10},
  [1766] = {.lex_state = 57, .external_lex_state = 13},
  [1767] = {.lex_state = 57, .external_lex_state = 9},
  [1768] = {.lex_state = 57, .external_lex_state = 13},
  [1769] = {.lex_state = 57, .external_lex_state = 10},
  [1770] = {.lex_state = 57, .external_lex_state = 12},
  [1771] = {.lex_state = 57, .external_lex_state = 13},
  [1772] = {.lex_state = 57, .external_lex_state = 9},
  [1773] = {.lex_state = 57, .external_lex_state = 10},
  [1774] = {.lex_state = 57, .external_lex_state = 13},
  [1775] = {.lex_state = 57, .external_lex_state = 13},
  [1776] = {.lex_state = 57, .external_lex_state = 13},
  [1777] = {.lex_state = 57, .external_lex_state = 13},
  [1778] = {.lex_state = 57, .external_lex_state = 13},
  [1779] = {.lex_state = 57, .external_lex_state = 11},
  [1780] = {.lex_state = 57, .external_lex_state = 13},
  [1781] = {.lex_state = 57, .external_lex_state = 13},
  [1782] = {.lex_state = 57, .external_lex_state = 12},
  [1783] = {.lex_state = 57, .external_lex_state = 10},
  [1784] = {.lex_state = 57, .external_lex_state = 13},
  [1785] = {.lex_state = 57, .external_lex_state = 13},
  [1786] = {.lex_state = 57, .external_lex_state = 13},
  [1787] = {.lex_state = 57, .external_lex_state = 13},
  [1788] = {.lex_state = 57, .external_lex_state = 9},
  [1789] = {.lex_state = 3, .external_lex_state = 10},
  [1790] = {.lex_state = 57, .external_lex_state = 13},
  [1791] = {.lex_state = 3, .external_lex_state = 10},
  [1792] = {.lex_state = 57, .external_lex_state = 12},
  [1793] = {.lex_state = 33, .external_lex_state = 12},
  [1794] = {.lex_state = 57, .external_lex_state = 13},
  [1795] = {.lex_state = 57, .external_lex_state = 10},
  [1796] = {.lex_state = 33, .external_lex_state = 12},
  [1797] = {.lex_state = 57, .external_lex_state = 10},
  [1798] = {.lex_state = 57, .external_lex_state = 12},
  [1799] = {.lex_state = 57, .external_lex_state = 9},
  [1800] = {.lex_state = 57, .external_lex_state = 15},
  [1801] = {.lex_state = 33, .external_lex_state = 12},
  [1802] = {.lex_state = 57, .external_lex_state = 9},
  [1803] = {.lex_state = 57, .external_lex_state = 15},
  [1804] = {.lex_state = 57, .external_lex_state = 13},
  [1805] = {.lex_state = 57, .external_lex_state = 9},
  [1806] = {.lex_state = 57, .external_lex_state = 9},
  [1807] = {.lex_state = 57, .external_lex_state = 13},
  [1808] = {.lex_state = 57, .external_lex_state = 12},
  [1809] = {.lex_state = 57, .external_lex_state = 9},
  [1810] = {.lex_state = 57, .external_lex_state = 9},
  [1811] = {.lex_state = 57, .external_lex_state = 15},
  [1812] = {.lex_state = 57, .external_lex_state = 12},
  [1813] = {.lex_state = 57, .external_lex_state = 9},
  [1814] = {.lex_state = 57, .external_lex_state = 9},
  [1815] = {.lex_state = 33, .external_lex_state = 13},
  [1816] = {.lex_state = 57, .external_lex_state = 9},
  [1817] = {.lex_state = 57, .external_lex_state = 9},
  [1818] = {.lex_state = 57, .external_lex_state = 10},
  [1819] = {.lex_state = 57, .external_lex_state = 15},
  [1820] = {.lex_state = 57, .external_lex_state = 13},
  [1821] = {.lex_state = 57, .external_lex_state = 12},
  [1822] = {.lex_state = 57, .external_lex_state = 9},
  [1823] = {.lex_state = 57, .external_lex_state = 9},
  [1824] = {.lex_state = 57, .external_lex_state = 12},
  [1825] = {.lex_state = 57, .external_lex_state = 13},
  [1826] = {.lex_state = 57, .external_lex_state = 13},
  [1827] = {.lex_state = 33, .external_lex_state = 13},
  [1828] = {.lex_state = 57, .external_lex_state = 9},
  [1829] = {.lex_state = 57, .external_lex_state = 9},
  [1830] = {.lex_state = 57, .external_lex_state = 9},
  [1831] = {.lex_state = 57, .external_lex_state = 9},
  [1832] = {.lex_state = 57, .external_lex_state = 9},
  [1833] = {.lex_state = 57, .external_lex_state = 15},
  [1834] = {.lex_state = 57, .external_lex_state = 10},
  [1835] = {.lex_state = 57, .external_lex_state = 12},
  [1836] = {.lex_state = 57, .external_lex_state = 16},
  [1837] = {.lex_state = 57, .external_lex_state = 13},
  [1838] = {.lex_state = 57, .external_lex_state = 13},
  [1839] = {.lex_state = 38, .external_lex_state = 13},
  [1840] = {.lex_state = 57, .external_lex_state = 11},
  [1841] = {.lex_state = 57, .external_lex_state = 9},
  [1842] = {.lex_state = 57, .external_lex_state = 9},
  [1843] = {.lex_state = 57, .external_lex_state = 13},
  [1844] = {.lex_state = 57, .external_lex_state = 12},
  [1845] = {.lex_state = 57, .external_lex_state = 16},
  [1846] = {.lex_state = 57, .external_lex_state = 12},
  [1847] = {.lex_state = 57, .external_lex_state = 9},
  [1848] = {.lex_state = 57, .external_lex_state = 9},
  [1849] = {.lex_state = 3, .external_lex_state = 10},
  [1850] = {.lex_state = 38, .external_lex_state = 13},
  [1851] = {.lex_state = 57, .external_lex_state = 11},
  [1852] = {.lex_state = 3, .external_lex_state = 10},
  [1853] = {.lex_state = 57, .external_lex_state = 12},
  [1854] = {.lex_state = 57, .external_lex_state = 12},
  [1855] = {.lex_state = 33, .external_lex_state = 13},
  [1856] = {.lex_state = 3, .external_lex_state = 10},
  [1857] = {.lex_state = 57, .external_lex_state = 12},
  [1858] = {.lex_state = 57, .external_lex_state = 12},
  [1859] = {.lex_state = 57, .external_lex_state = 13},
  [1860] = {.lex_state = 57, .external_lex_state = 16},
  [1861] = {.lex_state = 57, .external_lex_state = 10},
  [1862] = {.lex_state = 3, .external_lex_state = 10},
  [1863] = {.lex_state = 57, .external_lex_state = 10},
  [1864] = {.lex_state = 57, .external_lex_state = 11},
  [1865] = {.lex_state = 57, .external_lex_state = 12},
  [1866] = {.lex_state = 57, .external_lex_state = 9},
  [1867] = {.lex_state = 57, .external_lex_state = 9},
  [1868] = {.lex_state = 57, .external_lex_state = 10},
  [1869] = {.lex_state = 57, .external_lex_state = 12},
  [1870] = {.lex_state = 57, .external_lex_state = 13},
  [1871] = {.lex_state = 57, .external_lex_state = 11},
  [1872] = {.lex_state = 57, .external_lex_state = 12},
  [1873] = {.lex_state = 57, .external_lex_state = 12},
  [1874] = {.lex_state = 57, .external_lex_state = 13},
  [1875] = {.lex_state = 57, .external_lex_state = 13},
  [1876] = {.lex_state = 57, .external_lex_state = 16},
  [1877] = {.lex_state = 57, .external_lex_state = 10},
  [1878] = {.lex_state = 57, .external_lex_state = 12},
  [1879] = {.lex_state = 57, .external_lex_state = 11},
  [1880] = {.lex_state = 57, .external_lex_state = 11},
  [1881] = {.lex_state = 57, .external_lex_state = 13},
  [1882] = {.lex_state = 57, .external_lex_state = 9},
  [1883] = {.lex_state = 57, .external_lex_state = 12},
  [1884] = {.lex_state = 57, .external_lex_state = 12},
  [1885] = {.lex_state = 57, .external_lex_state = 12},
  [1886] = {.lex_state = 3, .external_lex_state = 10},
  [1887] = {.lex_state = 57, .external_lex_state = 11},
  [1888] = {.lex_state = 57, .external_lex_state = 11},
  [1889] = {.lex_state = 57, .external_lex_state = 12},
  [1890] = {.lex_state = 57, .external_lex_state = 12},
  [1891] = {.lex_state = 57, .external_lex_state = 12},
  [1892] = {.lex_state = 57, .external_lex_state = 12},
  [1893] = {.lex_state = 57, .external_lex_state = 12},
  [1894] = {.lex_state = 57, .external_lex_state = 13},
  [1895] = {.lex_state = 57, .external_lex_state = 12},
  [1896] = {.lex_state = 57, .external_lex_state = 12},
  [1897] = {.lex_state = 57, .external_lex_state = 11},
  [1898] = {.lex_state = 57, .external_lex_state = 11},
  [1899] = {.lex_state = 38, .external_lex_state = 13},
  [1900] = {.lex_state = 33, .external_lex_state = 13},
  [1901] = {.lex_state = 38, .external_lex_state = 13},
  [1902] = {.lex_state = 57, .external_lex_state = 13},
  [1903] = {.lex_state = 57, .external_lex_state = 13},
  [1904] = {.lex_state = 57, .external_lex_state = 11},
  [1905] = {.lex_state = 57, .external_lex_state = 13},
  [1906] = {.lex_state = 57, .external_lex_state = 16},
  [1907] = {.lex_state = 57, .external_lex_state = 9},
  [1908] = {.lex_state = 57, .external_lex_state = 12},
  [1909] = {.lex_state = 57, .external_lex_state = 13},
  [1910] = {.lex_state = 57, .external_lex_state = 9},
  [1911] = {.lex_state = 57, .external_lex_state = 13},
  [1912] = {.lex_state = 57, .external_lex_state = 10},
  [1913] = {.lex_state = 57, .external_lex_state = 12},
  [1914] = {.lex_state = 57, .external_lex_state = 12},
  [1915] = {.lex_state = 57, .external_lex_state = 9},
  [1916] = {.lex_state = 57, .external_lex_state = 11},
  [1917] = {.lex_state = 57, .external_lex_state = 11},
  [1918] = {.lex_state = 57, .external_lex_state = 12},
  [1919] = {.lex_state = 57, .external_lex_state = 9},
  [1920] = {.lex_state = 57, .external_lex_state = 9},
  [1921] = {.lex_state = 57, .external_lex_state = 11},
  [1922] = {.lex_state = 57, .external_lex_state = 12},
  [1923] = {.lex_state = 3, .external_lex_state = 10},
  [1924] = {.lex_state = 57, .external_lex_state = 11},
  [1925] = {.lex_state = 57, .external_lex_state = 12},
  [1926] = {.lex_state = 57, .external_lex_state = 11},
  [1927] = {.lex_state = 38, .external_lex_state = 13},
  [1928] = {.lex_state = 57, .external_lex_state = 10},
  [1929] = {.lex_state = 57, .external_lex_state = 11},
  [1930] = {.lex_state = 57, .external_lex_state = 13},
  [1931] = {.lex_state = 57, .external_lex_state = 13},
  [1932] = {.lex_state = 57, .external_lex_state = 9},
  [1933] = {.lex_state = 57, .external_lex_state = 13},
  [1934] = {.lex_state = 57, .external_lex_state = 10},
  [1935] = {.lex_state = 57, .external_lex_state = 10},
  [1936] = {.lex_state = 57, .external_lex_state = 11},
  [1937] = {.lex_state = 57, .external_lex_state = 11},
  [1938] = {.lex_state = 57, .external_lex_state = 9},
  [1939] = {.lex_state = 57, .external_lex_state = 12},
  [1940] = {.lex_state = 57, .external_lex_state = 13},
  [1941] = {.lex_state = 57, .external_lex_state = 12},
  [1942] = {.lex_state = 57, .external_lex_state = 9},
  [1943] = {.lex_state = 57, .external_lex_state = 13},
  [1944] = {.lex_state = 57, .external_lex_state = 13},
  [1945] = {.lex_state = 57, .external_lex_state = 10},
  [1946] = {.lex_state = 57, .external_lex_state = 11},
  [1947] = {.lex_state = 57, .external_lex_state = 9},
  [1948] = {.lex_state = 57, .external_lex_state = 12},
  [1949] = {.lex_state = 57, .external_lex_state = 12},
  [1950] = {.lex_state = 57, .external_lex_state = 13},
  [1951] = {.lex_state = 57, .external_lex_state = 12},
  [1952] = {.lex_state = 57, .external_lex_state = 12},
  [1953] = {.lex_state = 57, .external_lex_state = 10},
  [1954] = {.lex_state = 57, .external_lex_state = 10},
  [1955] = {.lex_state = 57, .external_lex_state = 11},
  [1956] = {.lex_state = 57, .external_lex_state = 11},
  [1957] = {.lex_state = 57, .external_lex_state = 11},
  [1958] = {.lex_state = 57, .external_lex_state = 13},
  [1959] = {.lex_state = 57, .external_lex_state = 13},
  [1960] = {.lex_state = 57, .external_lex_state = 9},
  [1961] = {.lex_state = 57, .external_lex_state = 12},
  [1962] = {.lex_state = 57, .external_lex_state = 10},
  [1963] = {.lex_state = 57, .external_lex_state = 12},
  [1964] = {.lex_state = 57, .external_lex_state = 12},
  [1965] = {.lex_state = 57, .external_lex_state = 11},
  [1966] = {.lex_state = 57, .external_lex_state = 11},
  [1967] = {.lex_state = 57, .external_lex_state = 12},
  [1968] = {.lex_state = 57, .external_lex_state = 9},
  [1969] = {.lex_state = 57, .external_lex_state = 12},
  [1970] = {.lex_state = 57, .external_lex_state = 13},
  [1971] = {.lex_state = 57, .external_lex_state = 12},
  [1972] = {.lex_state = 57, .external_lex_state = 13},
  [1973] = {.lex_state = 57, .external_lex_state = 13},
  [1974] = {.lex_state = 57, .external_lex_state = 13},
  [1975] = {.lex_state = 57, .external_lex_state = 13},
  [1976] = {.lex_state = 57, .external_lex_state = 12},
  [1977] = {.lex_state = 57, .external_lex_state = 11},
  [1978] = {.lex_state = 57, .external_lex_state = 12},
  [1979] = {.lex_state = 57, .external_lex_state = 9},
  [1980] = {.lex_state = 57, .external_lex_state = 11},
  [1981] = {.lex_state = 57, .external_lex_state = 12},
  [1982] = {.lex_state = 57, .external_lex_state = 11},
  [1983] = {.lex_state = 3, .external_lex_state = 10},
  [1984] = {.lex_state = 57, .external_lex_state = 12},
  [1985] = {.lex_state = 57, .external_lex_state = 12},
  [1986] = {.lex_state = 57, .external_lex_state = 10},
  [1987] = {.lex_state = 57, .external_lex_state = 16},
  [1988] = {.lex_state = 57, .external_lex_state = 11},
  [1989] = {.lex_state = 57, .external_lex_state = 13},
  [1990] = {.lex_state = 57, .external_lex_state = 12},
  [1991] = {.lex_state = 57, .external_lex_state = 12},
  [1992] = {.lex_state = 57, .external_lex_state = 10},
  [1993] = {.lex_state = 57, .external_lex_state = 9},
  [1994] = {.lex_state = 57, .external_lex_state = 10},
  [1995] = {.lex_state = 57, .external_lex_state = 10},
  [1996] = {.lex_state = 57, .external_lex_state = 9},
  [1997] = {.lex_state = 57, .external_lex_state = 13},
  [1998] = {.lex_state = 57, .external_lex_state = 9},
  [1999] = {.lex_state = 57, .external_lex_state = 10},
  [2000] = {.lex_state = 57, .external_lex_state = 13},
  [2001] = {.lex_state = 57, .external_lex_state = 12},
  [2002] = {.lex_state = 57, .external_lex_state = 9},
  [2003] = {.lex_state = 57, .external_lex_state = 10},
  [2004] = {.lex_state = 57, .external_lex_state = 16},
  [2005] = {.lex_state = 57, .external_lex_state = 11},
  [2006] = {.lex_state = 57, .external_lex_state = 12},
  [2007] = {.lex_state = 57, .external_lex_state = 12},
  [2008] = {.lex_state = 57, .external_lex_state = 11},
  [2009] = {.lex_state = 57, .external_lex_state = 12},
  [2010] = {.lex_state = 57, .external_lex_state = 11},
  [2011] = {.lex_state = 57, .external_lex_state = 12},
  [2012] = {.lex_state = 57, .external_lex_state = 12},
  [2013] = {.lex_state = 57, .external_lex_state = 12},
  [2014] = {.lex_state = 57, .external_lex_state = 12},
  [2015] = {.lex_state = 57, .external_lex_state = 11},
  [2016] = {.lex_state = 57, .external_lex_state = 16},
  [2017] = {.lex_state = 57, .external_lex_state = 10},
  [2018] = {.lex_state = 57, .external_lex_state = 12},
  [2019] = {.lex_state = 57, .external_lex_state = 11},
  [2020] = {.lex_state = 57, .external_lex_state = 12},
  [2021] = {.lex_state = 57, .external_lex_state = 12},
  [2022] = {.lex_state = 57, .external_lex_state = 12},
  [2023] = {.lex_state = 3, .external_lex_state = 10},
  [2024] = {.lex_state = 57, .external_lex_state = 11},
  [2025] = {.lex_state = 57, .external_lex_state = 11},
  [2026] = {.lex_state = 57, .external_lex_state = 12},
  [2027] = {.lex_state = 33, .external_lex_state = 13},
  [2028] = {.lex_state = 57, .external_lex_state = 10},
  [2029] = {.lex_state = 57, .external_lex_state = 10},
  [2030] = {.lex_state = 57, .external_lex_state = 12},
  [2031] = {.lex_state = 57, .external_lex_state = 12},
  [2032] = {.lex_state = 57, .external_lex_state = 10},
  [2033] = {.lex_state = 57, .external_lex_state = 12},
  [2034] = {.lex_state = 57, .external_lex_state = 9},
  [2035] = {.lex_state = 57, .external_lex_state = 12},
  [2036] = {.lex_state = 57, .external_lex_state = 12},
  [2037] = {.lex_state = 57, .external_lex_state = 10},
  [2038] = {.lex_state = 57, .external_lex_state = 9},
  [2039] = {.lex_state = 57, .external_lex_state = 11},
  [2040] = {.lex_state = 3, .external_lex_state = 10},
  [2041] = {.lex_state = 57, .external_lex_state = 11},
  [2042] = {.lex_state = 57, .external_lex_state = 12},
  [2043] = {.lex_state = 57, .external_lex_state = 12},
  [2044] = {.lex_state = 57, .external_lex_state = 12},
  [2045] = {.lex_state = 57, .external_lex_state = 12},
  [2046] = {.lex_state = 57, .external_lex_state = 12},
  [2047] = {.lex_state = 57, .external_lex_state = 13},
  [2048] = {.lex_state = 57, .external_lex_state = 11},
  [2049] = {.lex_state = 57, .external_lex_state = 12},
  [2050] = {.lex_state = 57, .external_lex_state = 15},
  [2051] = {.lex_state = 57, .external_lex_state = 11},
  [2052] = {.lex_state = 57, .external_lex_state = 15},
  [2053] = {.lex_state = 57, .external_lex_state = 15},
  [2054] = {.lex_state = 57, .external_lex_state = 15},
  [2055] = {.lex_state = 57, .external_lex_state = 12},
  [2056] = {.lex_state = 57, .external_lex_state = 9},
  [2057] = {.lex_state = 57, .external_lex_state = 9},
  [2058] = {.lex_state = 57, .external_lex_state = 12},
  [2059] = {.lex_state = 57, .external_lex_state = 9},
  [2060] = {.lex_state = 57, .external_lex_state = 9},
  [2061] = {.lex_state = 57, .external_lex_state = 12},
  [2062] = {.lex_state = 57, .external_lex_state = 11},
  [2063] = {.lex_state = 57, .external_lex_state = 9},
  [2064] = {.lex_state = 57, .external_lex_state = 15},
  [2065] = {.lex_state = 57, .external_lex_state = 13},
  [2066] = {.lex_state = 57, .external_lex_state = 15},
  [2067] = {.lex_state = 57, .external_lex_state = 13},
  [2068] = {.lex_state = 57, .external_lex_state = 15},
  [2069] = {.lex_state = 57, .external_lex_state = 9},
  [2070] = {.lex_state = 57, .external_lex_state = 12},
  [2071] = {.lex_state = 57, .external_lex_state = 15},
  [2072] = {.lex_state = 57, .external_lex_state = 15},
  [2073] = {.lex_state = 57, .external_lex_state = 15},
  [2074] = {.lex_state = 57, .external_lex_state = 12},
  [2075] = {.lex_state = 57, .external_lex_state = 12},
  [2076] = {.lex_state = 57, .external_lex_state = 12},
  [2077] = {.lex_state = 57, .external_lex_state = 12},
  [2078] = {.lex_state = 33, .external_lex_state = 13},
  [2079] = {.lex_state = 57, .external_lex_state = 9},
  [2080] = {.lex_state = 57, .external_lex_state = 15},
  [2081] = {.lex_state = 57, .external_lex_state = 12},
  [2082] = {.lex_state = 57, .external_lex_state = 15},
  [2083] = {.lex_state = 57, .external_lex_state = 15},
  [2084] = {.lex_state = 57, .external_lex_state = 9},
  [2085] = {.lex_state = 38, .external_lex_state = 13},
  [2086] = {.lex_state = 57, .external_lex_state = 15},
  [2087] = {.lex_state = 57, .external_lex_state = 15},
  [2088] = {.lex_state = 57, .external_lex_state = 13},
  [2089] = {.lex_state = 57, .external_lex_state = 12},
  [2090] = {.lex_state = 57, .external_lex_state = 11},
  [2091] = {.lex_state = 57, .external_lex_state = 11},
  [2092] = {.lex_state = 57, .external_lex_state = 15},
  [2093] = {.lex_state = 57, .external_lex_state = 12},
  [2094] = {.lex_state = 57, .external_lex_state = 15},
  [2095] = {.lex_state = 57, .external_lex_state = 15},
  [2096] = {.lex_state = 57, .external_lex_state = 9},
  [2097] = {.lex_state = 57, .external_lex_state = 15},
  [2098] = {.lex_state = 38, .external_lex_state = 13},
  [2099] = {.lex_state = 57, .external_lex_state = 12},
  [2100] = {.lex_state = 57, .external_lex_state = 11},
  [2101] = {.lex_state = 57, .external_lex_state = 11},
  [2102] = {.lex_state = 57, .external_lex_state = 15},
  [2103] = {.lex_state = 57, .external_lex_state = 12},
  [2104] = {.lex_state = 38, .external_lex_state = 13},
  [2105] = {.lex_state = 57, .external_lex_state = 9},
  [2106] = {.lex_state = 57, .external_lex_state = 15},
  [2107] = {.lex_state = 38, .external_lex_state = 13},
  [2108] = {.lex_state = 57, .external_lex_state = 12},
  [2109] = {.lex_state = 57, .external_lex_state = 11},
  [2110] = {.lex_state = 57, .external_lex_state = 9},
  [2111] = {.lex_state = 57, .external_lex_state = 15},
  [2112] = {.lex_state = 57, .external_lex_state = 10},
  [2113] = {.lex_state = 57, .external_lex_state = 13},
  [2114] = {.lex_state = 57, .external_lex_state = 12},
  [2115] = {.lex_state = 57, .external_lex_state = 12},
  [2116] = {.lex_state = 57, .external_lex_state = 15},
  [2117] = {.lex_state = 57, .external_lex_state = 9},
  [2118] = {.lex_state = 57, .external_lex_state = 9},
  [2119] = {.lex_state = 57, .external_lex_state = 9},
  [2120] = {.lex_state = 38, .external_lex_state = 13},
  [2121] = {.lex_state = 57, .external_lex_state = 11},
  [2122] = {.lex_state = 57, .external_lex_state = 9},
  [2123] = {.lex_state = 57, .external_lex_state = 11},
  [2124] = {.lex_state = 57, .external_lex_state = 15},
  [2125] = {.lex_state = 57, .external_lex_state = 13},
  [2126] = {.lex_state = 57, .external_lex_state = 13},
  [2127] = {.lex_state = 57, .external_lex_state = 13},
  [2128] = {.lex_state = 57, .external_lex_state = 10},
  [2129] = {.lex_state = 57, .external_lex_state = 13},
  [2130] = {.lex_state = 38, .external_lex_state = 13},
  [2131] = {.lex_state = 57, .external_lex_state = 10},
  [2132] = {.lex_state = 57, .external_lex_state = 10},
  [2133] = {.lex_state = 57, .external_lex_state = 13},
  [2134] = {.lex_state = 57, .external_lex_state = 9},
  [2135] = {.lex_state = 57, .external_lex_state = 15},
  [2136] = {.lex_state = 57, .external_lex_state = 15},
  [2137] = {.lex_state = 57, .external_lex_state = 9},
  [2138] = {.lex_state = 57, .external_lex_state = 13},
  [2139] = {.lex_state = 57, .external_lex_state = 13},
  [2140] = {.lex_state = 57, .external_lex_state = 9},
  [2141] = {.lex_state = 57, .external_lex_state = 10},
  [2142] = {.lex_state = 57, .external_lex_state = 13},
  [2143] = {.lex_state = 57, .external_lex_state = 13},
  [2144] = {.lex_state = 57, .external_lex_state = 13},
  [2145] = {.lex_state = 57, .external_lex_state = 12},
  [2146] = {.lex_state = 57, .external_lex_state = 12},
  [2147] = {.lex_state = 57, .external_lex_state = 10},
  [2148] = {.lex_state = 30, .external_lex_state = 13},
  [2149] = {.lex_state = 57, .external_lex_state = 12},
  [2150] = {.lex_state = 57, .external_lex_state = 13},
  [2151] = {.lex_state = 57, .external_lex_state = 13},
  [2152] = {.lex_state = 57, .external_lex_state = 13},
  [2153] = {.lex_state = 30, .external_lex_state = 13},
  [2154] = {.lex_state = 57, .external_lex_state = 13},
  [2155] = {.lex_state = 57, .external_lex_state = 13},
  [2156] = {.lex_state = 57, .external_lex_state = 12},
  [2157] = {.lex_state = 57, .external_lex_state = 13},
  [2158] = {.lex_state = 57, .external_lex_state = 11},
  [2159] = {.lex_state = 57, .external_lex_state = 13},
  [2160] = {.lex_state = 57, .external_lex_state = 10},
  [2161] = {.lex_state = 57, .external_lex_state = 12},
  [2162] = {.lex_state = 57, .external_lex_state = 13},
  [2163] = {.lex_state = 57, .external_lex_state = 10},
  [2164] = {.lex_state = 57, .external_lex_state = 11},
  [2165] = {.lex_state = 57, .external_lex_state = 11},
  [2166] = {.lex_state = 57, .external_lex_state = 13},
  [2167] = {.lex_state = 57, .external_lex_state = 13},
  [2168] = {.lex_state = 57, .external_lex_state = 12},
  [2169] = {.lex_state = 57, .external_lex_state = 11},
  [2170] = {.lex_state = 57, .external_lex_state = 11},
  [2171] = {.lex_state = 57, .external_lex_state = 10},
  [2172] = {.lex_state = 57, .external_lex_state = 10},
  [2173] = {.lex_state = 57, .external_lex_state = 10},
  [2174] = {.lex_state = 57, .external_lex_state = 13},
  [2175] = {.lex_state = 57, .external_lex_state = 12},
  [2176] = {.lex_state = 57, .external_lex_state = 12},
  [2177] = {.lex_state = 57, .external_lex_state = 10},
  [2178] = {.lex_state = 57, .external_lex_state = 10},
  [2179] = {.lex_state = 57, .external_lex_state = 13},
  [2180] = {.lex_state = 57, .external_lex_state = 10},
  [2181] = {.lex_state = 57, .external_lex_state = 10},
  [2182] = {.lex_state = 57, .external_lex_state = 11},
  [2183] = {.lex_state = 57, .external_lex_state = 12},
  [2184] = {.lex_state = 57, .external_lex_state = 12},
  [2185] = {.lex_state = 57, .external_lex_state = 10},
  [2186] = {.lex_state = 57, .external_lex_state = 13},
  [2187] = {.lex_state = 57, .external_lex_state = 13},
  [2188] = {.lex_state = 57, .external_lex_state = 13},
  [2189] = {.lex_state = 57, .external_lex_state = 13},
  [2190] = {.lex_state = 57, .external_lex_state = 13},
  [2191] = {.lex_state = 57, .external_lex_state = 11},
  [2192] = {.lex_state = 57, .external_lex_state = 13},
  [2193] = {.lex_state = 57, .external_lex_state = 12},
  [2194] = {.lex_state = 57, .external_lex_state = 10},
  [2195] = {.lex_state = 57, .external_lex_state = 13},
  [2196] = {.lex_state = 57, .external_lex_state = 10},
  [2197] = {.lex_state = 57, .external_lex_state = 13},
  [2198] = {.lex_state = 57, .external_lex_state = 13},
  [2199] = {.lex_state = 57, .external_lex_state = 13},
  [2200] = {.lex_state = 57, .external_lex_state = 11},
  [2201] = {.lex_state = 57, .external_lex_state = 11},
  [2202] = {.lex_state = 57, .external_lex_state = 10},
  [2203] = {.lex_state = 57, .external_lex_state = 12},
  [2204] = {.lex_state = 57, .external_lex_state = 12},
  [2205] = {.lex_state = 57, .external_lex_state = 12},
  [2206] = {.lex_state = 57, .external_lex_state = 13},
  [2207] = {.lex_state = 57, .external_lex_state = 11},
  [2208] = {.lex_state = 57, .external_lex_state = 13},
  [2209] = {.lex_state = 57, .external_lex_state = 11},
  [2210] = {.lex_state = 57, .external_lex_state = 10},
  [2211] = {.lex_state = 57, .external_lex_state = 13},
  [2212] = {.lex_state = 30, .external_lex_state = 13},
  [2213] = {.lex_state = 57, .external_lex_state = 12},
  [2214] = {.lex_state = 57, .external_lex_state = 13},
  [2215] = {.lex_state = 57, .external_lex_state = 10},
  [2216] = {.lex_state = 57, .external_lex_state = 12},
  [2217] = {.lex_state = 57, .external_lex_state = 10},
  [2218] = {.lex_state = 57, .external_lex_state = 10},
  [2219] = {.lex_state = 57, .external_lex_state = 12},
  [2220] = {.lex_state = 57, .external_lex_state = 10},
  [2221] = {.lex_state = 57, .external_lex_state = 10},
  [2222] = {.lex_state = 30, .external_lex_state = 13},
  [2223] = {.lex_state = 57, .external_lex_state = 13},
  [2224] = {.lex_state = 57, .external_lex_state = 10},
  [2225] = {.lex_state = 57, .external_lex_state = 11},
  [2226] = {.lex_state = 57, .external_lex_state = 13},
  [2227] = {.lex_state = 57, .external_lex_state = 12},
  [2228] = {.lex_state = 57, .external_lex_state = 13},
  [2229] = {.lex_state = 57, .external_lex_state = 13},
  [2230] = {.lex_state = 57, .external_lex_state = 13},
  [2231] = {.lex_state = 57, .external_lex_state = 13},
  [2232] = {.lex_state = 57, .external_lex_state = 10},
  [2233] = {.lex_state = 57, .external_lex_state = 13},
  [2234] = {.lex_state = 57, .external_lex_state = 10},
  [2235] = {.lex_state = 57, .external_lex_state = 13},
  [2236] = {.lex_state = 57, .external_lex_state = 11},
  [2237] = {.lex_state = 57, .external_lex_state = 13},
  [2238] = {.lex_state = 57, .external_lex_state = 13},
  [2239] = {.lex_state = 57, .external_lex_state = 12},
  [2240] = {.lex_state = 57, .external_lex_state = 13},
  [2241] = {.lex_state = 57, .external_lex_state = 10},
  [2242] = {.lex_state = 57, .external_lex_state = 13},
  [2243] = {.lex_state = 57, .external_lex_state = 13},
  [2244] = {.lex_state = 57, .external_lex_state = 13},
  [2245] = {.lex_state = 57, .external_lex_state = 13},
  [2246] = {.lex_state = 57, .external_lex_state = 13},
  [2247] = {.lex_state = 57, .external_lex_state = 10},
  [2248] = {.lex_state = 57, .external_lex_state = 13},
  [2249] = {.lex_state = 57, .external_lex_state = 11},
  [2250] = {.lex_state = 57, .external_lex_state = 13},
  [2251] = {.lex_state = 57, .external_lex_state = 13},
  [2252] = {.lex_state = 57, .external_lex_state = 13},
  [2253] = {.lex_state = 57, .external_lex_state = 10},
  [2254] = {.lex_state = 57, .external_lex_state = 13},
  [2255] = {.lex_state = 57, .external_lex_state = 12},
  [2256] = {.lex_state = 57, .external_lex_state = 13},
  [2257] = {.lex_state = 57, .external_lex_state = 13},
  [2258] = {.lex_state = 57, .external_lex_state = 12},
  [2259] = {.lex_state = 57, .external_lex_state = 12},
  [2260] = {.lex_state = 57, .external_lex_state = 10},
  [2261] = {.lex_state = 57, .external_lex_state = 12},
  [2262] = {.lex_state = 57, .external_lex_state = 10},
  [2263] = {.lex_state = 57, .external_lex_state = 13},
  [2264] = {.lex_state = 57, .external_lex_state = 11},
  [2265] = {.lex_state = 57, .external_lex_state = 13},
  [2266] = {.lex_state = 57, .external_lex_state = 12},
  [2267] = {.lex_state = 57, .external_lex_state = 13},
  [2268] = {.lex_state = 57, .external_lex_state = 13},
  [2269] = {.lex_state = 57, .external_lex_state = 13},
  [2270] = {.lex_state = 57, .external_lex_state = 13},
  [2271] = {.lex_state = 57, .external_lex_state = 12},
  [2272] = {.lex_state = 57, .external_lex_state = 11},
  [2273] = {.lex_state = 57, .external_lex_state = 10},
  [2274] = {.lex_state = 30, .external_lex_state = 13},
  [2275] = {.lex_state = 57, .external_lex_state = 11},
  [2276] = {.lex_state = 57, .external_lex_state = 10},
  [2277] = {.lex_state = 57, .external_lex_state = 13},
  [2278] = {.lex_state = 57, .external_lex_state = 10},
  [2279] = {.lex_state = 57, .external_lex_state = 13},
  [2280] = {.lex_state = 57, .external_lex_state = 13},
  [2281] = {.lex_state = 57, .external_lex_state = 13},
  [2282] = {.lex_state = 57, .external_lex_state = 13},
  [2283] = {.lex_state = 57, .external_lex_state = 11},
  [2284] = {.lex_state = 57, .external_lex_state = 10},
  [2285] = {.lex_state = 57, .external_lex_state = 11},
  [2286] = {.lex_state = 57, .external_lex_state = 12},
  [2287] = {.lex_state = 57, .external_lex_state = 10},
  [2288] = {.lex_state = 57, .external_lex_state = 13},
  [2289] = {.lex_state = 57, .external_lex_state = 12},
  [2290] = {.lex_state = 57, .external_lex_state = 12},
  [2291] = {.lex_state = 57, .external_lex_state = 10},
  [2292] = {.lex_state = 57, .external_lex_state = 13},
  [2293] = {.lex_state = 57, .external_lex_state = 13},
  [2294] = {.lex_state = 57, .external_lex_state = 10},
  [2295] = {.lex_state = 30, .external_lex_state = 13},
  [2296] = {.lex_state = 57, .external_lex_state = 13},
  [2297] = {.lex_state = 57, .external_lex_state = 12},
  [2298] = {.lex_state = 57, .external_lex_state = 12},
  [2299] = {.lex_state = 57, .external_lex_state = 10},
  [2300] = {.lex_state = 57, .external_lex_state = 13},
  [2301] = {.lex_state = 57, .external_lex_state = 10},
  [2302] = {.lex_state = 57, .external_lex_state = 13},
  [2303] = {.lex_state = 57, .external_lex_state = 13},
  [2304] = {.lex_state = 57, .external_lex_state = 13},
  [2305] = {.lex_state = 57, .external_lex_state = 11},
  [2306] = {.lex_state = 57, .external_lex_state = 12},
  [2307] = {.lex_state = 30, .external_lex_state = 13},
  [2308] = {.lex_state = 57, .external_lex_state = 13},
  [2309] = {.lex_state = 57, .external_lex_state = 13},
  [2310] = {.lex_state = 57, .external_lex_state = 13},
  [2311] = {.lex_state = 57, .external_lex_state = 10},
  [2312] = {.lex_state = 57, .external_lex_state = 13},
  [2313] = {.lex_state = 57, .external_lex_state = 13},
  [2314] = {.lex_state = 57, .external_lex_state = 13},
  [2315] = {.lex_state = 57, .external_lex_state = 13},
  [2316] = {.lex_state = 57, .external_lex_state = 13},
  [2317] = {.lex_state = 57, .external_lex_state = 13},
  [2318] = {.lex_state = 57, .external_lex_state = 10},
  [2319] = {.lex_state = 57, .external_lex_state = 13},
  [2320] = {.lex_state = 57, .external_lex_state = 11},
  [2321] = {.lex_state = 57, .external_lex_state = 13},
  [2322] = {.lex_state = 57, .external_lex_state = 13},
  [2323] = {.lex_state = 57, .external_lex_state = 13},
  [2324] = {.lex_state = 57, .external_lex_state = 13},
  [2325] = {.lex_state = 57, .external_lex_state = 13},
  [2326] = {.lex_state = 57, .external_lex_state = 13},
  [2327] = {.lex_state = 57, .external_lex_state = 12},
  [2328] = {.lex_state = 57, .external_lex_state = 13},
  [2329] = {.lex_state = 57, .external_lex_state = 13},
  [2330] = {.lex_state = 30, .external_lex_state = 13},
  [2331] = {.lex_state = 57, .external_lex_state = 13},
};

enum {
  ts_external_token__newline = 0,
  ts_external_token__indent = 1,
  ts_external_token__dedent = 2,
  ts_external_token_string_start = 3,
  ts_external_token__string_content = 4,
  ts_external_token_string_end = 5,
  ts_external_token_comment = 6,
  ts_external_token_RBRACK = 7,
  ts_external_token_RPAREN = 8,
  ts_external_token_RBRACE = 9,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__newline] = sym__newline,
  [ts_external_token__indent] = sym__indent,
  [ts_external_token__dedent] = sym__dedent,
  [ts_external_token_string_start] = sym_string_start,
  [ts_external_token__string_content] = sym__string_content,
  [ts_external_token_string_end] = sym_string_end,
  [ts_external_token_comment] = sym_comment,
  [ts_external_token_RBRACK] = anon_sym_RBRACK,
  [ts_external_token_RPAREN] = anon_sym_RPAREN,
  [ts_external_token_RBRACE] = anon_sym_RBRACE,
};

static const bool ts_external_scanner_states[17][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__newline] = true,
    [ts_external_token__indent] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token_string_start] = true,
    [ts_external_token__string_content] = true,
    [ts_external_token_string_end] = true,
    [ts_external_token_comment] = true,
    [ts_external_token_RBRACK] = true,
    [ts_external_token_RPAREN] = true,
    [ts_external_token_RBRACE] = true,
  },
  [2] = {
    [ts_external_token_string_start] = true,
    [ts_external_token_comment] = true,
  },
  [3] = {
    [ts_external_token__dedent] = true,
    [ts_external_token_string_start] = true,
    [ts_external_token_comment] = true,
  },
  [4] = {
    [ts_external_token__newline] = true,
    [ts_external_token_string_start] = true,
    [ts_external_token_comment] = true,
  },
  [5] = {
    [ts_external_token__newline] = true,
    [ts_external_token__indent] = true,
    [ts_external_token_string_start] = true,
    [ts_external_token_comment] = true,
  },
  [6] = {
    [ts_external_token_string_start] = true,
    [ts_external_token_comment] = true,
    [ts_external_token_RBRACE] = true,
  },
  [7] = {
    [ts_external_token_string_start] = true,
    [ts_external_token_comment] = true,
    [ts_external_token_RPAREN] = true,
  },
  [8] = {
    [ts_external_token_string_start] = true,
    [ts_external_token_comment] = true,
    [ts_external_token_RBRACK] = true,
  },
  [9] = {
    [ts_external_token__newline] = true,
    [ts_external_token_comment] = true,
  },
  [10] = {
    [ts_external_token_comment] = true,
    [ts_external_token_RBRACE] = true,
  },
  [11] = {
    [ts_external_token_comment] = true,
    [ts_external_token_RBRACK] = true,
  },
  [12] = {
    [ts_external_token_comment] = true,
    [ts_external_token_RPAREN] = true,
  },
  [13] = {
    [ts_external_token_comment] = true,
  },
  [14] = {
    [ts_external_token__string_content] = true,
    [ts_external_token_string_end] = true,
    [ts_external_token_comment] = true,
  },
  [15] = {
    [ts_external_token__dedent] = true,
    [ts_external_token_comment] = true,
  },
  [16] = {
    [ts_external_token__newline] = true,
    [ts_external_token__indent] = true,
    [ts_external_token_comment] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym___future__] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_print] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_del] = ACTIONS(1),
    [anon_sym_raise] = ACTIONS(1),
    [anon_sym_pass] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_elif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_match] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_except] = ACTIONS(1),
    [anon_sym_except_STAR] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_def] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_nonlocal] = ACTIONS(1),
    [anon_sym_exec] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_lambda] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_AT_EQ] = ACTIONS(1),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [sym_ellipsis] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym__not_escape_sequence] = ACTIONS(1),
    [sym_type_conversion] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_none] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(5),
    [sym__newline] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
    [sym_string_start] = ACTIONS(1),
    [sym__string_content] = ACTIONS(1),
    [sym_string_end] = ACTIONS(1),
  },
  [1] = {
    [sym_module] = STATE(2310),
    [sym__statement] = STATE(52),
    [sym__simple_statements] = STATE(52),
    [sym_import_statement] = STATE(1841),
    [sym_future_import_statement] = STATE(1841),
    [sym_import_from_statement] = STATE(1841),
    [sym_print_statement] = STATE(1841),
    [sym_assert_statement] = STATE(1841),
    [sym_expression_statement] = STATE(1841),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1841),
    [sym_delete_statement] = STATE(1841),
    [sym_raise_statement] = STATE(1841),
    [sym_pass_statement] = STATE(1841),
    [sym_break_statement] = STATE(1841),
    [sym_continue_statement] = STATE(1841),
    [sym_if_statement] = STATE(52),
    [sym_match_statement] = STATE(52),
    [sym_for_statement] = STATE(52),
    [sym_while_statement] = STATE(52),
    [sym_try_statement] = STATE(52),
    [sym_with_statement] = STATE(52),
    [sym_function_definition] = STATE(52),
    [sym_global_statement] = STATE(1841),
    [sym_nonlocal_statement] = STATE(1841),
    [sym_exec_statement] = STATE(1841),
    [sym_class_definition] = STATE(52),
    [sym_decorated_definition] = STATE(52),
    [sym_decorator] = STATE(1568),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(52),
    [aux_sym_decorated_definition_repeat1] = STATE(1568),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_match] = ACTIONS(37),
    [anon_sym_async] = ACTIONS(39),
    [anon_sym_for] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_def] = ACTIONS(49),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(57),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(79),
  },
  [2] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(652),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym_string_start] = ACTIONS(79),
  },
  [3] = {
    [sym__statement] = STATE(57),
    [sym__simple_statements] = STATE(57),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(57),
    [sym_match_statement] = STATE(57),
    [sym_for_statement] = STATE(57),
    [sym_while_statement] = STATE(57),
    [sym_try_statement] = STATE(57),
    [sym_with_statement] = STATE(57),
    [sym_function_definition] = STATE(57),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(57),
    [sym_decorated_definition] = STATE(57),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(649),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(57),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(79),
  },
  [4] = {
    [sym__statement] = STATE(57),
    [sym__simple_statements] = STATE(57),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(57),
    [sym_match_statement] = STATE(57),
    [sym_for_statement] = STATE(57),
    [sym_while_statement] = STATE(57),
    [sym_try_statement] = STATE(57),
    [sym_with_statement] = STATE(57),
    [sym_function_definition] = STATE(57),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(57),
    [sym_decorated_definition] = STATE(57),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(654),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(57),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(79),
  },
  [5] = {
    [sym__statement] = STATE(55),
    [sym__simple_statements] = STATE(55),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(55),
    [sym_match_statement] = STATE(55),
    [sym_for_statement] = STATE(55),
    [sym_while_statement] = STATE(55),
    [sym_try_statement] = STATE(55),
    [sym_with_statement] = STATE(55),
    [sym_function_definition] = STATE(55),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(55),
    [sym_decorated_definition] = STATE(55),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(593),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(55),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(79),
  },
  [6] = {
    [sym__statement] = STATE(54),
    [sym__simple_statements] = STATE(54),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(54),
    [sym_match_statement] = STATE(54),
    [sym_for_statement] = STATE(54),
    [sym_while_statement] = STATE(54),
    [sym_try_statement] = STATE(54),
    [sym_with_statement] = STATE(54),
    [sym_function_definition] = STATE(54),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(54),
    [sym_decorated_definition] = STATE(54),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(1601),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(54),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(105),
    [sym_string_start] = ACTIONS(79),
  },
  [7] = {
    [sym__statement] = STATE(57),
    [sym__simple_statements] = STATE(57),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(57),
    [sym_match_statement] = STATE(57),
    [sym_for_statement] = STATE(57),
    [sym_while_statement] = STATE(57),
    [sym_try_statement] = STATE(57),
    [sym_with_statement] = STATE(57),
    [sym_function_definition] = STATE(57),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(57),
    [sym_decorated_definition] = STATE(57),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(574),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(57),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(79),
  },
  [8] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(727),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym_string_start] = ACTIONS(79),
  },
  [9] = {
    [sym__statement] = STATE(58),
    [sym__simple_statements] = STATE(58),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(58),
    [sym_match_statement] = STATE(58),
    [sym_for_statement] = STATE(58),
    [sym_while_statement] = STATE(58),
    [sym_try_statement] = STATE(58),
    [sym_with_statement] = STATE(58),
    [sym_function_definition] = STATE(58),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(58),
    [sym_decorated_definition] = STATE(58),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(631),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(58),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(79),
  },
  [10] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(576),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym_string_start] = ACTIONS(79),
  },
  [11] = {
    [sym__statement] = STATE(57),
    [sym__simple_statements] = STATE(57),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(57),
    [sym_match_statement] = STATE(57),
    [sym_for_statement] = STATE(57),
    [sym_while_statement] = STATE(57),
    [sym_try_statement] = STATE(57),
    [sym_with_statement] = STATE(57),
    [sym_function_definition] = STATE(57),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(57),
    [sym_decorated_definition] = STATE(57),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(678),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(57),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(79),
  },
  [12] = {
    [sym__statement] = STATE(57),
    [sym__simple_statements] = STATE(57),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(57),
    [sym_match_statement] = STATE(57),
    [sym_for_statement] = STATE(57),
    [sym_while_statement] = STATE(57),
    [sym_try_statement] = STATE(57),
    [sym_with_statement] = STATE(57),
    [sym_function_definition] = STATE(57),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(57),
    [sym_decorated_definition] = STATE(57),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(728),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(57),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(79),
  },
  [13] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(739),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym_string_start] = ACTIONS(79),
  },
  [14] = {
    [sym__statement] = STATE(57),
    [sym__simple_statements] = STATE(57),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(57),
    [sym_match_statement] = STATE(57),
    [sym_for_statement] = STATE(57),
    [sym_while_statement] = STATE(57),
    [sym_try_statement] = STATE(57),
    [sym_with_statement] = STATE(57),
    [sym_function_definition] = STATE(57),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(57),
    [sym_decorated_definition] = STATE(57),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(721),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(57),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(79),
  },
  [15] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(662),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym_string_start] = ACTIONS(79),
  },
  [16] = {
    [sym__statement] = STATE(53),
    [sym__simple_statements] = STATE(53),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(53),
    [sym_match_statement] = STATE(53),
    [sym_for_statement] = STATE(53),
    [sym_while_statement] = STATE(53),
    [sym_try_statement] = STATE(53),
    [sym_with_statement] = STATE(53),
    [sym_function_definition] = STATE(53),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(53),
    [sym_decorated_definition] = STATE(53),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(599),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(53),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(79),
  },
  [17] = {
    [sym__statement] = STATE(54),
    [sym__simple_statements] = STATE(54),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(54),
    [sym_match_statement] = STATE(54),
    [sym_for_statement] = STATE(54),
    [sym_while_statement] = STATE(54),
    [sym_try_statement] = STATE(54),
    [sym_with_statement] = STATE(54),
    [sym_function_definition] = STATE(54),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(54),
    [sym_decorated_definition] = STATE(54),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(1579),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(54),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(105),
    [sym_string_start] = ACTIONS(79),
  },
  [18] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(686),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym_string_start] = ACTIONS(79),
  },
  [19] = {
    [sym__statement] = STATE(57),
    [sym__simple_statements] = STATE(57),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(57),
    [sym_match_statement] = STATE(57),
    [sym_for_statement] = STATE(57),
    [sym_while_statement] = STATE(57),
    [sym_try_statement] = STATE(57),
    [sym_with_statement] = STATE(57),
    [sym_function_definition] = STATE(57),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(57),
    [sym_decorated_definition] = STATE(57),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(658),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(57),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(79),
  },
  [20] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(680),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym_string_start] = ACTIONS(79),
  },
  [21] = {
    [sym__statement] = STATE(60),
    [sym__simple_statements] = STATE(60),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(60),
    [sym_match_statement] = STATE(60),
    [sym_for_statement] = STATE(60),
    [sym_while_statement] = STATE(60),
    [sym_try_statement] = STATE(60),
    [sym_with_statement] = STATE(60),
    [sym_function_definition] = STATE(60),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(60),
    [sym_decorated_definition] = STATE(60),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(2094),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(60),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(111),
    [sym_string_start] = ACTIONS(79),
  },
  [22] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(713),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym_string_start] = ACTIONS(79),
  },
  [23] = {
    [sym__statement] = STATE(57),
    [sym__simple_statements] = STATE(57),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(57),
    [sym_match_statement] = STATE(57),
    [sym_for_statement] = STATE(57),
    [sym_while_statement] = STATE(57),
    [sym_try_statement] = STATE(57),
    [sym_with_statement] = STATE(57),
    [sym_function_definition] = STATE(57),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(57),
    [sym_decorated_definition] = STATE(57),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(684),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(57),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(79),
  },
  [24] = {
    [sym__statement] = STATE(57),
    [sym__simple_statements] = STATE(57),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(57),
    [sym_match_statement] = STATE(57),
    [sym_for_statement] = STATE(57),
    [sym_while_statement] = STATE(57),
    [sym_try_statement] = STATE(57),
    [sym_with_statement] = STATE(57),
    [sym_function_definition] = STATE(57),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(57),
    [sym_decorated_definition] = STATE(57),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(750),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(57),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(79),
  },
  [25] = {
    [sym__statement] = STATE(55),
    [sym__simple_statements] = STATE(55),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(55),
    [sym_match_statement] = STATE(55),
    [sym_for_statement] = STATE(55),
    [sym_while_statement] = STATE(55),
    [sym_try_statement] = STATE(55),
    [sym_with_statement] = STATE(55),
    [sym_function_definition] = STATE(55),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(55),
    [sym_decorated_definition] = STATE(55),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(610),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(55),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(79),
  },
  [26] = {
    [sym__statement] = STATE(57),
    [sym__simple_statements] = STATE(57),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(57),
    [sym_match_statement] = STATE(57),
    [sym_for_statement] = STATE(57),
    [sym_while_statement] = STATE(57),
    [sym_try_statement] = STATE(57),
    [sym_with_statement] = STATE(57),
    [sym_function_definition] = STATE(57),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(57),
    [sym_decorated_definition] = STATE(57),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(642),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(57),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(79),
  },
  [27] = {
    [sym__statement] = STATE(60),
    [sym__simple_statements] = STATE(60),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(60),
    [sym_match_statement] = STATE(60),
    [sym_for_statement] = STATE(60),
    [sym_while_statement] = STATE(60),
    [sym_try_statement] = STATE(60),
    [sym_with_statement] = STATE(60),
    [sym_function_definition] = STATE(60),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(60),
    [sym_decorated_definition] = STATE(60),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(2068),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(60),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(111),
    [sym_string_start] = ACTIONS(79),
  },
  [28] = {
    [sym__statement] = STATE(57),
    [sym__simple_statements] = STATE(57),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(57),
    [sym_match_statement] = STATE(57),
    [sym_for_statement] = STATE(57),
    [sym_while_statement] = STATE(57),
    [sym_try_statement] = STATE(57),
    [sym_with_statement] = STATE(57),
    [sym_function_definition] = STATE(57),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(57),
    [sym_decorated_definition] = STATE(57),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(689),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(57),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(79),
  },
  [29] = {
    [sym__statement] = STATE(60),
    [sym__simple_statements] = STATE(60),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(60),
    [sym_match_statement] = STATE(60),
    [sym_for_statement] = STATE(60),
    [sym_while_statement] = STATE(60),
    [sym_try_statement] = STATE(60),
    [sym_with_statement] = STATE(60),
    [sym_function_definition] = STATE(60),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(60),
    [sym_decorated_definition] = STATE(60),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(2064),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(60),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(111),
    [sym_string_start] = ACTIONS(79),
  },
  [30] = {
    [sym__statement] = STATE(56),
    [sym__simple_statements] = STATE(56),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(56),
    [sym_match_statement] = STATE(56),
    [sym_for_statement] = STATE(56),
    [sym_while_statement] = STATE(56),
    [sym_try_statement] = STATE(56),
    [sym_with_statement] = STATE(56),
    [sym_function_definition] = STATE(56),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(56),
    [sym_decorated_definition] = STATE(56),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(597),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(56),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(113),
    [sym_string_start] = ACTIONS(79),
  },
  [31] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(685),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym_string_start] = ACTIONS(79),
  },
  [32] = {
    [sym__statement] = STATE(57),
    [sym__simple_statements] = STATE(57),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(57),
    [sym_match_statement] = STATE(57),
    [sym_for_statement] = STATE(57),
    [sym_while_statement] = STATE(57),
    [sym_try_statement] = STATE(57),
    [sym_with_statement] = STATE(57),
    [sym_function_definition] = STATE(57),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(57),
    [sym_decorated_definition] = STATE(57),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(667),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(57),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(79),
  },
  [33] = {
    [sym__statement] = STATE(53),
    [sym__simple_statements] = STATE(53),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(53),
    [sym_match_statement] = STATE(53),
    [sym_for_statement] = STATE(53),
    [sym_while_statement] = STATE(53),
    [sym_try_statement] = STATE(53),
    [sym_with_statement] = STATE(53),
    [sym_function_definition] = STATE(53),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(53),
    [sym_decorated_definition] = STATE(53),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(614),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(53),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym_string_start] = ACTIONS(79),
  },
  [34] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(687),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym_string_start] = ACTIONS(79),
  },
  [35] = {
    [sym__statement] = STATE(57),
    [sym__simple_statements] = STATE(57),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(57),
    [sym_match_statement] = STATE(57),
    [sym_for_statement] = STATE(57),
    [sym_while_statement] = STATE(57),
    [sym_try_statement] = STATE(57),
    [sym_with_statement] = STATE(57),
    [sym_function_definition] = STATE(57),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(57),
    [sym_decorated_definition] = STATE(57),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(752),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(57),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(79),
  },
  [36] = {
    [sym__statement] = STATE(55),
    [sym__simple_statements] = STATE(55),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(55),
    [sym_match_statement] = STATE(55),
    [sym_for_statement] = STATE(55),
    [sym_while_statement] = STATE(55),
    [sym_try_statement] = STATE(55),
    [sym_with_statement] = STATE(55),
    [sym_function_definition] = STATE(55),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(55),
    [sym_decorated_definition] = STATE(55),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(598),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(55),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym_string_start] = ACTIONS(79),
  },
  [37] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(643),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym_string_start] = ACTIONS(79),
  },
  [38] = {
    [sym__statement] = STATE(58),
    [sym__simple_statements] = STATE(58),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(58),
    [sym_match_statement] = STATE(58),
    [sym_for_statement] = STATE(58),
    [sym_while_statement] = STATE(58),
    [sym_try_statement] = STATE(58),
    [sym_with_statement] = STATE(58),
    [sym_function_definition] = STATE(58),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(58),
    [sym_decorated_definition] = STATE(58),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(596),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(58),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym_string_start] = ACTIONS(79),
  },
  [39] = {
    [sym__statement] = STATE(60),
    [sym__simple_statements] = STATE(60),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(60),
    [sym_match_statement] = STATE(60),
    [sym_for_statement] = STATE(60),
    [sym_while_statement] = STATE(60),
    [sym_try_statement] = STATE(60),
    [sym_with_statement] = STATE(60),
    [sym_function_definition] = STATE(60),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(60),
    [sym_decorated_definition] = STATE(60),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(2082),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(60),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(111),
    [sym_string_start] = ACTIONS(79),
  },
  [40] = {
    [sym__statement] = STATE(60),
    [sym__simple_statements] = STATE(60),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(60),
    [sym_match_statement] = STATE(60),
    [sym_for_statement] = STATE(60),
    [sym_while_statement] = STATE(60),
    [sym_try_statement] = STATE(60),
    [sym_with_statement] = STATE(60),
    [sym_function_definition] = STATE(60),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(60),
    [sym_decorated_definition] = STATE(60),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(2087),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(60),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(111),
    [sym_string_start] = ACTIONS(79),
  },
  [41] = {
    [sym__statement] = STATE(60),
    [sym__simple_statements] = STATE(60),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(60),
    [sym_match_statement] = STATE(60),
    [sym_for_statement] = STATE(60),
    [sym_while_statement] = STATE(60),
    [sym_try_statement] = STATE(60),
    [sym_with_statement] = STATE(60),
    [sym_function_definition] = STATE(60),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(60),
    [sym_decorated_definition] = STATE(60),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(2080),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(60),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(111),
    [sym_string_start] = ACTIONS(79),
  },
  [42] = {
    [sym__statement] = STATE(60),
    [sym__simple_statements] = STATE(60),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(60),
    [sym_match_statement] = STATE(60),
    [sym_for_statement] = STATE(60),
    [sym_while_statement] = STATE(60),
    [sym_try_statement] = STATE(60),
    [sym_with_statement] = STATE(60),
    [sym_function_definition] = STATE(60),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(60),
    [sym_decorated_definition] = STATE(60),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(2050),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(60),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(111),
    [sym_string_start] = ACTIONS(79),
  },
  [43] = {
    [sym__statement] = STATE(60),
    [sym__simple_statements] = STATE(60),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(60),
    [sym_match_statement] = STATE(60),
    [sym_for_statement] = STATE(60),
    [sym_while_statement] = STATE(60),
    [sym_try_statement] = STATE(60),
    [sym_with_statement] = STATE(60),
    [sym_function_definition] = STATE(60),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(60),
    [sym_decorated_definition] = STATE(60),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(2111),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(60),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(111),
    [sym_string_start] = ACTIONS(79),
  },
  [44] = {
    [sym__statement] = STATE(56),
    [sym__simple_statements] = STATE(56),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(56),
    [sym_match_statement] = STATE(56),
    [sym_for_statement] = STATE(56),
    [sym_while_statement] = STATE(56),
    [sym_try_statement] = STATE(56),
    [sym_with_statement] = STATE(56),
    [sym_function_definition] = STATE(56),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(56),
    [sym_decorated_definition] = STATE(56),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(592),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(56),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(113),
    [sym_string_start] = ACTIONS(79),
  },
  [45] = {
    [sym__statement] = STATE(57),
    [sym__simple_statements] = STATE(57),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(57),
    [sym_match_statement] = STATE(57),
    [sym_for_statement] = STATE(57),
    [sym_while_statement] = STATE(57),
    [sym_try_statement] = STATE(57),
    [sym_with_statement] = STATE(57),
    [sym_function_definition] = STATE(57),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(57),
    [sym_decorated_definition] = STATE(57),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(710),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(57),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(79),
  },
  [46] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(663),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym_string_start] = ACTIONS(79),
  },
  [47] = {
    [sym__statement] = STATE(57),
    [sym__simple_statements] = STATE(57),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(57),
    [sym_match_statement] = STATE(57),
    [sym_for_statement] = STATE(57),
    [sym_while_statement] = STATE(57),
    [sym_try_statement] = STATE(57),
    [sym_with_statement] = STATE(57),
    [sym_function_definition] = STATE(57),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(57),
    [sym_decorated_definition] = STATE(57),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(712),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(57),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym_string_start] = ACTIONS(79),
  },
  [48] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(664),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym_string_start] = ACTIONS(79),
  },
  [49] = {
    [sym__statement] = STATE(56),
    [sym__simple_statements] = STATE(56),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(56),
    [sym_match_statement] = STATE(56),
    [sym_for_statement] = STATE(56),
    [sym_while_statement] = STATE(56),
    [sym_try_statement] = STATE(56),
    [sym_with_statement] = STATE(56),
    [sym_function_definition] = STATE(56),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(56),
    [sym_decorated_definition] = STATE(56),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(609),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(56),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(113),
    [sym_string_start] = ACTIONS(79),
  },
  [50] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(746),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym_string_start] = ACTIONS(79),
  },
  [51] = {
    [sym__statement] = STATE(62),
    [sym__simple_statements] = STATE(62),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(62),
    [sym_match_statement] = STATE(62),
    [sym_for_statement] = STATE(62),
    [sym_while_statement] = STATE(62),
    [sym_try_statement] = STATE(62),
    [sym_with_statement] = STATE(62),
    [sym_function_definition] = STATE(62),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(62),
    [sym_decorated_definition] = STATE(62),
    [sym_decorator] = STATE(1618),
    [sym_block] = STATE(704),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(62),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym_string_start] = ACTIONS(79),
  },
  [52] = {
    [sym__statement] = STATE(59),
    [sym__simple_statements] = STATE(59),
    [sym_import_statement] = STATE(1841),
    [sym_future_import_statement] = STATE(1841),
    [sym_import_from_statement] = STATE(1841),
    [sym_print_statement] = STATE(1841),
    [sym_assert_statement] = STATE(1841),
    [sym_expression_statement] = STATE(1841),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1841),
    [sym_delete_statement] = STATE(1841),
    [sym_raise_statement] = STATE(1841),
    [sym_pass_statement] = STATE(1841),
    [sym_break_statement] = STATE(1841),
    [sym_continue_statement] = STATE(1841),
    [sym_if_statement] = STATE(59),
    [sym_match_statement] = STATE(59),
    [sym_for_statement] = STATE(59),
    [sym_while_statement] = STATE(59),
    [sym_try_statement] = STATE(59),
    [sym_with_statement] = STATE(59),
    [sym_function_definition] = STATE(59),
    [sym_global_statement] = STATE(1841),
    [sym_nonlocal_statement] = STATE(1841),
    [sym_exec_statement] = STATE(1841),
    [sym_class_definition] = STATE(59),
    [sym_decorated_definition] = STATE(59),
    [sym_decorator] = STATE(1568),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(59),
    [aux_sym_decorated_definition_repeat1] = STATE(1568),
    [ts_builtin_sym_end] = ACTIONS(115),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_match] = ACTIONS(37),
    [anon_sym_async] = ACTIONS(39),
    [anon_sym_for] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_try] = ACTIONS(45),
    [anon_sym_with] = ACTIONS(47),
    [anon_sym_def] = ACTIONS(49),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(57),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(79),
  },
  [53] = {
    [sym__statement] = STATE(61),
    [sym__simple_statements] = STATE(61),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(61),
    [sym_match_statement] = STATE(61),
    [sym_for_statement] = STATE(61),
    [sym_while_statement] = STATE(61),
    [sym_try_statement] = STATE(61),
    [sym_with_statement] = STATE(61),
    [sym_function_definition] = STATE(61),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(61),
    [sym_decorated_definition] = STATE(61),
    [sym_decorator] = STATE(1618),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(61),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(117),
    [sym_string_start] = ACTIONS(79),
  },
  [54] = {
    [sym__statement] = STATE(61),
    [sym__simple_statements] = STATE(61),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(61),
    [sym_match_statement] = STATE(61),
    [sym_for_statement] = STATE(61),
    [sym_while_statement] = STATE(61),
    [sym_try_statement] = STATE(61),
    [sym_with_statement] = STATE(61),
    [sym_function_definition] = STATE(61),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(61),
    [sym_decorated_definition] = STATE(61),
    [sym_decorator] = STATE(1618),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(61),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(119),
    [sym_string_start] = ACTIONS(79),
  },
  [55] = {
    [sym__statement] = STATE(61),
    [sym__simple_statements] = STATE(61),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(61),
    [sym_match_statement] = STATE(61),
    [sym_for_statement] = STATE(61),
    [sym_while_statement] = STATE(61),
    [sym_try_statement] = STATE(61),
    [sym_with_statement] = STATE(61),
    [sym_function_definition] = STATE(61),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(61),
    [sym_decorated_definition] = STATE(61),
    [sym_decorator] = STATE(1618),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(61),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(121),
    [sym_string_start] = ACTIONS(79),
  },
  [56] = {
    [sym__statement] = STATE(61),
    [sym__simple_statements] = STATE(61),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(61),
    [sym_match_statement] = STATE(61),
    [sym_for_statement] = STATE(61),
    [sym_while_statement] = STATE(61),
    [sym_try_statement] = STATE(61),
    [sym_with_statement] = STATE(61),
    [sym_function_definition] = STATE(61),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(61),
    [sym_decorated_definition] = STATE(61),
    [sym_decorator] = STATE(1618),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(61),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(123),
    [sym_string_start] = ACTIONS(79),
  },
  [57] = {
    [sym__statement] = STATE(61),
    [sym__simple_statements] = STATE(61),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(61),
    [sym_match_statement] = STATE(61),
    [sym_for_statement] = STATE(61),
    [sym_while_statement] = STATE(61),
    [sym_try_statement] = STATE(61),
    [sym_with_statement] = STATE(61),
    [sym_function_definition] = STATE(61),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(61),
    [sym_decorated_definition] = STATE(61),
    [sym_decorator] = STATE(1618),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(61),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(125),
    [sym_string_start] = ACTIONS(79),
  },
  [58] = {
    [sym__statement] = STATE(61),
    [sym__simple_statements] = STATE(61),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(61),
    [sym_match_statement] = STATE(61),
    [sym_for_statement] = STATE(61),
    [sym_while_statement] = STATE(61),
    [sym_try_statement] = STATE(61),
    [sym_with_statement] = STATE(61),
    [sym_function_definition] = STATE(61),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(61),
    [sym_decorated_definition] = STATE(61),
    [sym_decorator] = STATE(1618),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(61),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(127),
    [sym_string_start] = ACTIONS(79),
  },
  [59] = {
    [sym__statement] = STATE(59),
    [sym__simple_statements] = STATE(59),
    [sym_import_statement] = STATE(1841),
    [sym_future_import_statement] = STATE(1841),
    [sym_import_from_statement] = STATE(1841),
    [sym_print_statement] = STATE(1841),
    [sym_assert_statement] = STATE(1841),
    [sym_expression_statement] = STATE(1841),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1841),
    [sym_delete_statement] = STATE(1841),
    [sym_raise_statement] = STATE(1841),
    [sym_pass_statement] = STATE(1841),
    [sym_break_statement] = STATE(1841),
    [sym_continue_statement] = STATE(1841),
    [sym_if_statement] = STATE(59),
    [sym_match_statement] = STATE(59),
    [sym_for_statement] = STATE(59),
    [sym_while_statement] = STATE(59),
    [sym_try_statement] = STATE(59),
    [sym_with_statement] = STATE(59),
    [sym_function_definition] = STATE(59),
    [sym_global_statement] = STATE(1841),
    [sym_nonlocal_statement] = STATE(1841),
    [sym_exec_statement] = STATE(1841),
    [sym_class_definition] = STATE(59),
    [sym_decorated_definition] = STATE(59),
    [sym_decorator] = STATE(1568),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(59),
    [aux_sym_decorated_definition_repeat1] = STATE(1568),
    [ts_builtin_sym_end] = ACTIONS(129),
    [sym_identifier] = ACTIONS(131),
    [anon_sym_import] = ACTIONS(134),
    [anon_sym_from] = ACTIONS(137),
    [anon_sym_LPAREN] = ACTIONS(140),
    [anon_sym_STAR] = ACTIONS(143),
    [anon_sym_print] = ACTIONS(146),
    [anon_sym_assert] = ACTIONS(149),
    [anon_sym_return] = ACTIONS(152),
    [anon_sym_del] = ACTIONS(155),
    [anon_sym_raise] = ACTIONS(158),
    [anon_sym_pass] = ACTIONS(161),
    [anon_sym_break] = ACTIONS(164),
    [anon_sym_continue] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(170),
    [anon_sym_match] = ACTIONS(173),
    [anon_sym_async] = ACTIONS(176),
    [anon_sym_for] = ACTIONS(179),
    [anon_sym_while] = ACTIONS(182),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_with] = ACTIONS(188),
    [anon_sym_def] = ACTIONS(191),
    [anon_sym_global] = ACTIONS(194),
    [anon_sym_nonlocal] = ACTIONS(197),
    [anon_sym_exec] = ACTIONS(200),
    [anon_sym_class] = ACTIONS(203),
    [anon_sym_AT] = ACTIONS(206),
    [anon_sym_LBRACK] = ACTIONS(209),
    [anon_sym_not] = ACTIONS(212),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_lambda] = ACTIONS(218),
    [anon_sym_yield] = ACTIONS(221),
    [sym_ellipsis] = ACTIONS(224),
    [anon_sym_LBRACE] = ACTIONS(227),
    [sym_integer] = ACTIONS(230),
    [sym_float] = ACTIONS(224),
    [anon_sym_await] = ACTIONS(233),
    [sym_true] = ACTIONS(230),
    [sym_false] = ACTIONS(230),
    [sym_none] = ACTIONS(230),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(236),
  },
  [60] = {
    [sym__statement] = STATE(61),
    [sym__simple_statements] = STATE(61),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(61),
    [sym_match_statement] = STATE(61),
    [sym_for_statement] = STATE(61),
    [sym_while_statement] = STATE(61),
    [sym_try_statement] = STATE(61),
    [sym_with_statement] = STATE(61),
    [sym_function_definition] = STATE(61),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(61),
    [sym_decorated_definition] = STATE(61),
    [sym_decorator] = STATE(1618),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(61),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(239),
    [sym_string_start] = ACTIONS(79),
  },
  [61] = {
    [sym__statement] = STATE(61),
    [sym__simple_statements] = STATE(61),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(61),
    [sym_match_statement] = STATE(61),
    [sym_for_statement] = STATE(61),
    [sym_while_statement] = STATE(61),
    [sym_try_statement] = STATE(61),
    [sym_with_statement] = STATE(61),
    [sym_function_definition] = STATE(61),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(61),
    [sym_decorated_definition] = STATE(61),
    [sym_decorator] = STATE(1618),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(61),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(131),
    [anon_sym_import] = ACTIONS(134),
    [anon_sym_from] = ACTIONS(137),
    [anon_sym_LPAREN] = ACTIONS(140),
    [anon_sym_STAR] = ACTIONS(143),
    [anon_sym_print] = ACTIONS(146),
    [anon_sym_assert] = ACTIONS(149),
    [anon_sym_return] = ACTIONS(152),
    [anon_sym_del] = ACTIONS(155),
    [anon_sym_raise] = ACTIONS(158),
    [anon_sym_pass] = ACTIONS(161),
    [anon_sym_break] = ACTIONS(164),
    [anon_sym_continue] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(241),
    [anon_sym_match] = ACTIONS(244),
    [anon_sym_async] = ACTIONS(247),
    [anon_sym_for] = ACTIONS(250),
    [anon_sym_while] = ACTIONS(253),
    [anon_sym_try] = ACTIONS(256),
    [anon_sym_with] = ACTIONS(259),
    [anon_sym_def] = ACTIONS(262),
    [anon_sym_global] = ACTIONS(194),
    [anon_sym_nonlocal] = ACTIONS(197),
    [anon_sym_exec] = ACTIONS(200),
    [anon_sym_class] = ACTIONS(265),
    [anon_sym_AT] = ACTIONS(206),
    [anon_sym_LBRACK] = ACTIONS(209),
    [anon_sym_not] = ACTIONS(212),
    [anon_sym_PLUS] = ACTIONS(215),
    [anon_sym_DASH] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_lambda] = ACTIONS(218),
    [anon_sym_yield] = ACTIONS(221),
    [sym_ellipsis] = ACTIONS(224),
    [anon_sym_LBRACE] = ACTIONS(227),
    [sym_integer] = ACTIONS(230),
    [sym_float] = ACTIONS(224),
    [anon_sym_await] = ACTIONS(233),
    [sym_true] = ACTIONS(230),
    [sym_false] = ACTIONS(230),
    [sym_none] = ACTIONS(230),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(129),
    [sym_string_start] = ACTIONS(236),
  },
  [62] = {
    [sym__statement] = STATE(61),
    [sym__simple_statements] = STATE(61),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_if_statement] = STATE(61),
    [sym_match_statement] = STATE(61),
    [sym_for_statement] = STATE(61),
    [sym_while_statement] = STATE(61),
    [sym_try_statement] = STATE(61),
    [sym_with_statement] = STATE(61),
    [sym_function_definition] = STATE(61),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_class_definition] = STATE(61),
    [sym_decorated_definition] = STATE(61),
    [sym_decorator] = STATE(1618),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [aux_sym_module_repeat1] = STATE(61),
    [aux_sym_decorated_definition_repeat1] = STATE(1618),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_match] = ACTIONS(83),
    [anon_sym_async] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(87),
    [anon_sym_while] = ACTIONS(89),
    [anon_sym_try] = ACTIONS(91),
    [anon_sym_with] = ACTIONS(93),
    [anon_sym_def] = ACTIONS(95),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_class] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(268),
    [sym_string_start] = ACTIONS(79),
  },
  [63] = {
    [sym_chevron] = STATE(1799),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_list_splat_pattern] = STATE(1125),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1617),
    [sym_primary_expression] = STATE(898),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_attribute] = STATE(1021),
    [sym_subscript] = STATE(1021),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(270),
    [anon_sym_SEMI] = ACTIONS(272),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(276),
    [anon_sym_COMMA] = ACTIONS(279),
    [anon_sym_as] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(282),
    [anon_sym_print] = ACTIONS(285),
    [anon_sym_GT_GT] = ACTIONS(287),
    [anon_sym_COLON_EQ] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_match] = ACTIONS(285),
    [anon_sym_async] = ACTIONS(285),
    [anon_sym_in] = ACTIONS(274),
    [anon_sym_STAR_STAR] = ACTIONS(274),
    [anon_sym_exec] = ACTIONS(285),
    [anon_sym_AT] = ACTIONS(274),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_not] = ACTIONS(296),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(299),
    [anon_sym_DASH] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(274),
    [anon_sym_SLASH_SLASH] = ACTIONS(274),
    [anon_sym_PIPE] = ACTIONS(274),
    [anon_sym_AMP] = ACTIONS(274),
    [anon_sym_CARET] = ACTIONS(274),
    [anon_sym_LT_LT] = ACTIONS(274),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_BANG_EQ] = ACTIONS(272),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_LT_GT] = ACTIONS(272),
    [anon_sym_is] = ACTIONS(274),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_PLUS_EQ] = ACTIONS(302),
    [anon_sym_DASH_EQ] = ACTIONS(302),
    [anon_sym_STAR_EQ] = ACTIONS(302),
    [anon_sym_SLASH_EQ] = ACTIONS(302),
    [anon_sym_AT_EQ] = ACTIONS(302),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(302),
    [anon_sym_PERCENT_EQ] = ACTIONS(302),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(302),
    [anon_sym_GT_GT_EQ] = ACTIONS(302),
    [anon_sym_LT_LT_EQ] = ACTIONS(302),
    [anon_sym_AMP_EQ] = ACTIONS(302),
    [anon_sym_CARET_EQ] = ACTIONS(302),
    [anon_sym_PIPE_EQ] = ACTIONS(302),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(304),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(272),
    [sym_string_start] = ACTIONS(79),
  },
  [64] = {
    [sym_named_expression] = STATE(1581),
    [sym__named_expression_lhs] = STATE(2295),
    [sym_list_splat_pattern] = STATE(1212),
    [sym_as_pattern] = STATE(1581),
    [sym_expression] = STATE(1677),
    [sym_primary_expression] = STATE(941),
    [sym_not_operator] = STATE(1581),
    [sym_boolean_operator] = STATE(1581),
    [sym_binary_operator] = STATE(1285),
    [sym_unary_operator] = STATE(1285),
    [sym_comparison_operator] = STATE(1581),
    [sym_lambda] = STATE(1581),
    [sym_attribute] = STATE(1285),
    [sym_subscript] = STATE(1285),
    [sym_call] = STATE(1285),
    [sym_list] = STATE(1285),
    [sym_set] = STATE(1285),
    [sym_tuple] = STATE(1285),
    [sym_dictionary] = STATE(1285),
    [sym_list_comprehension] = STATE(1285),
    [sym_dictionary_comprehension] = STATE(1285),
    [sym_set_comprehension] = STATE(1285),
    [sym_generator_expression] = STATE(1285),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_conditional_expression] = STATE(1581),
    [sym_concatenated_string] = STATE(1285),
    [sym_string] = STATE(938),
    [sym_await] = STATE(1285),
    [sym_identifier] = ACTIONS(306),
    [anon_sym_SEMI] = ACTIONS(272),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(308),
    [anon_sym_COMMA] = ACTIONS(279),
    [anon_sym_as] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(310),
    [anon_sym_print] = ACTIONS(312),
    [anon_sym_GT_GT] = ACTIONS(274),
    [anon_sym_COLON_EQ] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_match] = ACTIONS(312),
    [anon_sym_async] = ACTIONS(312),
    [anon_sym_in] = ACTIONS(274),
    [anon_sym_STAR_STAR] = ACTIONS(274),
    [anon_sym_exec] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(274),
    [anon_sym_LBRACK] = ACTIONS(314),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_not] = ACTIONS(316),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(318),
    [anon_sym_DASH] = ACTIONS(318),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(274),
    [anon_sym_SLASH_SLASH] = ACTIONS(274),
    [anon_sym_PIPE] = ACTIONS(274),
    [anon_sym_AMP] = ACTIONS(274),
    [anon_sym_CARET] = ACTIONS(274),
    [anon_sym_LT_LT] = ACTIONS(274),
    [anon_sym_TILDE] = ACTIONS(320),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_BANG_EQ] = ACTIONS(272),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_LT_GT] = ACTIONS(272),
    [anon_sym_is] = ACTIONS(274),
    [anon_sym_lambda] = ACTIONS(322),
    [anon_sym_PLUS_EQ] = ACTIONS(302),
    [anon_sym_DASH_EQ] = ACTIONS(302),
    [anon_sym_STAR_EQ] = ACTIONS(302),
    [anon_sym_SLASH_EQ] = ACTIONS(302),
    [anon_sym_AT_EQ] = ACTIONS(302),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(302),
    [anon_sym_PERCENT_EQ] = ACTIONS(302),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(302),
    [anon_sym_GT_GT_EQ] = ACTIONS(302),
    [anon_sym_LT_LT_EQ] = ACTIONS(302),
    [anon_sym_AMP_EQ] = ACTIONS(302),
    [anon_sym_CARET_EQ] = ACTIONS(302),
    [anon_sym_PIPE_EQ] = ACTIONS(302),
    [sym_ellipsis] = ACTIONS(324),
    [anon_sym_LBRACE] = ACTIONS(326),
    [sym_integer] = ACTIONS(328),
    [sym_float] = ACTIONS(324),
    [anon_sym_await] = ACTIONS(330),
    [sym_true] = ACTIONS(328),
    [sym_false] = ACTIONS(328),
    [sym_none] = ACTIONS(328),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(272),
    [sym_string_start] = ACTIONS(332),
  },
  [65] = {
    [sym_named_expression] = STATE(1581),
    [sym__named_expression_lhs] = STATE(2295),
    [sym_list_splat_pattern] = STATE(1212),
    [sym_as_pattern] = STATE(1581),
    [sym_expression] = STATE(1675),
    [sym_primary_expression] = STATE(941),
    [sym_not_operator] = STATE(1581),
    [sym_boolean_operator] = STATE(1581),
    [sym_binary_operator] = STATE(1285),
    [sym_unary_operator] = STATE(1285),
    [sym_comparison_operator] = STATE(1581),
    [sym_lambda] = STATE(1581),
    [sym_attribute] = STATE(1285),
    [sym_subscript] = STATE(1285),
    [sym_call] = STATE(1285),
    [sym_list] = STATE(1285),
    [sym_set] = STATE(1285),
    [sym_tuple] = STATE(1285),
    [sym_dictionary] = STATE(1285),
    [sym_list_comprehension] = STATE(1285),
    [sym_dictionary_comprehension] = STATE(1285),
    [sym_set_comprehension] = STATE(1285),
    [sym_generator_expression] = STATE(1285),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_conditional_expression] = STATE(1581),
    [sym_concatenated_string] = STATE(1285),
    [sym_string] = STATE(938),
    [sym_await] = STATE(1285),
    [sym_identifier] = ACTIONS(306),
    [anon_sym_SEMI] = ACTIONS(272),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(308),
    [anon_sym_COMMA] = ACTIONS(279),
    [anon_sym_as] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(310),
    [anon_sym_print] = ACTIONS(312),
    [anon_sym_GT_GT] = ACTIONS(274),
    [anon_sym_COLON_EQ] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_match] = ACTIONS(312),
    [anon_sym_async] = ACTIONS(312),
    [anon_sym_in] = ACTIONS(274),
    [anon_sym_STAR_STAR] = ACTIONS(274),
    [anon_sym_exec] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(274),
    [anon_sym_LBRACK] = ACTIONS(314),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_not] = ACTIONS(316),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(318),
    [anon_sym_DASH] = ACTIONS(318),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(274),
    [anon_sym_SLASH_SLASH] = ACTIONS(274),
    [anon_sym_PIPE] = ACTIONS(274),
    [anon_sym_AMP] = ACTIONS(274),
    [anon_sym_CARET] = ACTIONS(274),
    [anon_sym_LT_LT] = ACTIONS(274),
    [anon_sym_TILDE] = ACTIONS(320),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_BANG_EQ] = ACTIONS(272),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_LT_GT] = ACTIONS(272),
    [anon_sym_is] = ACTIONS(274),
    [anon_sym_lambda] = ACTIONS(322),
    [anon_sym_PLUS_EQ] = ACTIONS(302),
    [anon_sym_DASH_EQ] = ACTIONS(302),
    [anon_sym_STAR_EQ] = ACTIONS(302),
    [anon_sym_SLASH_EQ] = ACTIONS(302),
    [anon_sym_AT_EQ] = ACTIONS(302),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(302),
    [anon_sym_PERCENT_EQ] = ACTIONS(302),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(302),
    [anon_sym_GT_GT_EQ] = ACTIONS(302),
    [anon_sym_LT_LT_EQ] = ACTIONS(302),
    [anon_sym_AMP_EQ] = ACTIONS(302),
    [anon_sym_CARET_EQ] = ACTIONS(302),
    [anon_sym_PIPE_EQ] = ACTIONS(302),
    [sym_ellipsis] = ACTIONS(324),
    [anon_sym_LBRACE] = ACTIONS(326),
    [sym_integer] = ACTIONS(328),
    [sym_float] = ACTIONS(324),
    [anon_sym_await] = ACTIONS(330),
    [sym_true] = ACTIONS(328),
    [sym_false] = ACTIONS(328),
    [sym_none] = ACTIONS(328),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(272),
    [sym_string_start] = ACTIONS(332),
  },
  [66] = {
    [sym__simple_statements] = STATE(768),
    [sym_import_statement] = STATE(1841),
    [sym_future_import_statement] = STATE(1841),
    [sym_import_from_statement] = STATE(1841),
    [sym_print_statement] = STATE(1841),
    [sym_assert_statement] = STATE(1841),
    [sym_expression_statement] = STATE(1841),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1841),
    [sym_delete_statement] = STATE(1841),
    [sym_raise_statement] = STATE(1841),
    [sym_pass_statement] = STATE(1841),
    [sym_break_statement] = STATE(1841),
    [sym_continue_statement] = STATE(1841),
    [sym_global_statement] = STATE(1841),
    [sym_nonlocal_statement] = STATE(1841),
    [sym_exec_statement] = STATE(1841),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(336),
    [sym__indent] = ACTIONS(338),
    [sym_string_start] = ACTIONS(79),
  },
  [67] = {
    [sym__simple_statements] = STATE(580),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(340),
    [sym__indent] = ACTIONS(342),
    [sym_string_start] = ACTIONS(79),
  },
  [68] = {
    [sym__simple_statements] = STATE(718),
    [sym_import_statement] = STATE(1841),
    [sym_future_import_statement] = STATE(1841),
    [sym_import_from_statement] = STATE(1841),
    [sym_print_statement] = STATE(1841),
    [sym_assert_statement] = STATE(1841),
    [sym_expression_statement] = STATE(1841),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1841),
    [sym_delete_statement] = STATE(1841),
    [sym_raise_statement] = STATE(1841),
    [sym_pass_statement] = STATE(1841),
    [sym_break_statement] = STATE(1841),
    [sym_continue_statement] = STATE(1841),
    [sym_global_statement] = STATE(1841),
    [sym_nonlocal_statement] = STATE(1841),
    [sym_exec_statement] = STATE(1841),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(344),
    [sym__indent] = ACTIONS(346),
    [sym_string_start] = ACTIONS(79),
  },
  [69] = {
    [sym__simple_statements] = STATE(645),
    [sym_import_statement] = STATE(1841),
    [sym_future_import_statement] = STATE(1841),
    [sym_import_from_statement] = STATE(1841),
    [sym_print_statement] = STATE(1841),
    [sym_assert_statement] = STATE(1841),
    [sym_expression_statement] = STATE(1841),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1841),
    [sym_delete_statement] = STATE(1841),
    [sym_raise_statement] = STATE(1841),
    [sym_pass_statement] = STATE(1841),
    [sym_break_statement] = STATE(1841),
    [sym_continue_statement] = STATE(1841),
    [sym_global_statement] = STATE(1841),
    [sym_nonlocal_statement] = STATE(1841),
    [sym_exec_statement] = STATE(1841),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(348),
    [sym__indent] = ACTIONS(350),
    [sym_string_start] = ACTIONS(79),
  },
  [70] = {
    [sym__simple_statements] = STATE(568),
    [sym_import_statement] = STATE(1841),
    [sym_future_import_statement] = STATE(1841),
    [sym_import_from_statement] = STATE(1841),
    [sym_print_statement] = STATE(1841),
    [sym_assert_statement] = STATE(1841),
    [sym_expression_statement] = STATE(1841),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1841),
    [sym_delete_statement] = STATE(1841),
    [sym_raise_statement] = STATE(1841),
    [sym_pass_statement] = STATE(1841),
    [sym_break_statement] = STATE(1841),
    [sym_continue_statement] = STATE(1841),
    [sym_global_statement] = STATE(1841),
    [sym_nonlocal_statement] = STATE(1841),
    [sym_exec_statement] = STATE(1841),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(352),
    [sym__indent] = ACTIONS(354),
    [sym_string_start] = ACTIONS(79),
  },
  [71] = {
    [sym__simple_statements] = STATE(2102),
    [sym_import_statement] = STATE(2038),
    [sym_future_import_statement] = STATE(2038),
    [sym_import_from_statement] = STATE(2038),
    [sym_print_statement] = STATE(2038),
    [sym_assert_statement] = STATE(2038),
    [sym_expression_statement] = STATE(2038),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2038),
    [sym_delete_statement] = STATE(2038),
    [sym_raise_statement] = STATE(2038),
    [sym_pass_statement] = STATE(2038),
    [sym_break_statement] = STATE(2038),
    [sym_continue_statement] = STATE(2038),
    [sym_global_statement] = STATE(2038),
    [sym_nonlocal_statement] = STATE(2038),
    [sym_exec_statement] = STATE(2038),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(356),
    [sym__indent] = ACTIONS(358),
    [sym_string_start] = ACTIONS(79),
  },
  [72] = {
    [sym__simple_statements] = STATE(617),
    [sym_import_statement] = STATE(2002),
    [sym_future_import_statement] = STATE(2002),
    [sym_import_from_statement] = STATE(2002),
    [sym_print_statement] = STATE(2002),
    [sym_assert_statement] = STATE(2002),
    [sym_expression_statement] = STATE(2002),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2002),
    [sym_delete_statement] = STATE(2002),
    [sym_raise_statement] = STATE(2002),
    [sym_pass_statement] = STATE(2002),
    [sym_break_statement] = STATE(2002),
    [sym_continue_statement] = STATE(2002),
    [sym_global_statement] = STATE(2002),
    [sym_nonlocal_statement] = STATE(2002),
    [sym_exec_statement] = STATE(2002),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(360),
    [sym__indent] = ACTIONS(362),
    [sym_string_start] = ACTIONS(79),
  },
  [73] = {
    [sym__simple_statements] = STATE(666),
    [sym_import_statement] = STATE(1841),
    [sym_future_import_statement] = STATE(1841),
    [sym_import_from_statement] = STATE(1841),
    [sym_print_statement] = STATE(1841),
    [sym_assert_statement] = STATE(1841),
    [sym_expression_statement] = STATE(1841),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1841),
    [sym_delete_statement] = STATE(1841),
    [sym_raise_statement] = STATE(1841),
    [sym_pass_statement] = STATE(1841),
    [sym_break_statement] = STATE(1841),
    [sym_continue_statement] = STATE(1841),
    [sym_global_statement] = STATE(1841),
    [sym_nonlocal_statement] = STATE(1841),
    [sym_exec_statement] = STATE(1841),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(364),
    [sym__indent] = ACTIONS(366),
    [sym_string_start] = ACTIONS(79),
  },
  [74] = {
    [sym__simple_statements] = STATE(751),
    [sym_import_statement] = STATE(1841),
    [sym_future_import_statement] = STATE(1841),
    [sym_import_from_statement] = STATE(1841),
    [sym_print_statement] = STATE(1841),
    [sym_assert_statement] = STATE(1841),
    [sym_expression_statement] = STATE(1841),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1841),
    [sym_delete_statement] = STATE(1841),
    [sym_raise_statement] = STATE(1841),
    [sym_pass_statement] = STATE(1841),
    [sym_break_statement] = STATE(1841),
    [sym_continue_statement] = STATE(1841),
    [sym_global_statement] = STATE(1841),
    [sym_nonlocal_statement] = STATE(1841),
    [sym_exec_statement] = STATE(1841),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(368),
    [sym__indent] = ACTIONS(370),
    [sym_string_start] = ACTIONS(79),
  },
  [75] = {
    [sym__simple_statements] = STATE(626),
    [sym_import_statement] = STATE(1968),
    [sym_future_import_statement] = STATE(1968),
    [sym_import_from_statement] = STATE(1968),
    [sym_print_statement] = STATE(1968),
    [sym_assert_statement] = STATE(1968),
    [sym_expression_statement] = STATE(1968),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1968),
    [sym_delete_statement] = STATE(1968),
    [sym_raise_statement] = STATE(1968),
    [sym_pass_statement] = STATE(1968),
    [sym_break_statement] = STATE(1968),
    [sym_continue_statement] = STATE(1968),
    [sym_global_statement] = STATE(1968),
    [sym_nonlocal_statement] = STATE(1968),
    [sym_exec_statement] = STATE(1968),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(372),
    [sym__indent] = ACTIONS(374),
    [sym_string_start] = ACTIONS(79),
  },
  [76] = {
    [sym__simple_statements] = STATE(697),
    [sym_import_statement] = STATE(1841),
    [sym_future_import_statement] = STATE(1841),
    [sym_import_from_statement] = STATE(1841),
    [sym_print_statement] = STATE(1841),
    [sym_assert_statement] = STATE(1841),
    [sym_expression_statement] = STATE(1841),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1841),
    [sym_delete_statement] = STATE(1841),
    [sym_raise_statement] = STATE(1841),
    [sym_pass_statement] = STATE(1841),
    [sym_break_statement] = STATE(1841),
    [sym_continue_statement] = STATE(1841),
    [sym_global_statement] = STATE(1841),
    [sym_nonlocal_statement] = STATE(1841),
    [sym_exec_statement] = STATE(1841),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(376),
    [sym__indent] = ACTIONS(378),
    [sym_string_start] = ACTIONS(79),
  },
  [77] = {
    [sym__simple_statements] = STATE(734),
    [sym_import_statement] = STATE(1841),
    [sym_future_import_statement] = STATE(1841),
    [sym_import_from_statement] = STATE(1841),
    [sym_print_statement] = STATE(1841),
    [sym_assert_statement] = STATE(1841),
    [sym_expression_statement] = STATE(1841),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1841),
    [sym_delete_statement] = STATE(1841),
    [sym_raise_statement] = STATE(1841),
    [sym_pass_statement] = STATE(1841),
    [sym_break_statement] = STATE(1841),
    [sym_continue_statement] = STATE(1841),
    [sym_global_statement] = STATE(1841),
    [sym_nonlocal_statement] = STATE(1841),
    [sym_exec_statement] = STATE(1841),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(380),
    [sym__indent] = ACTIONS(382),
    [sym_string_start] = ACTIONS(79),
  },
  [78] = {
    [sym__simple_statements] = STATE(2066),
    [sym_import_statement] = STATE(2038),
    [sym_future_import_statement] = STATE(2038),
    [sym_import_from_statement] = STATE(2038),
    [sym_print_statement] = STATE(2038),
    [sym_assert_statement] = STATE(2038),
    [sym_expression_statement] = STATE(2038),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2038),
    [sym_delete_statement] = STATE(2038),
    [sym_raise_statement] = STATE(2038),
    [sym_pass_statement] = STATE(2038),
    [sym_break_statement] = STATE(2038),
    [sym_continue_statement] = STATE(2038),
    [sym_global_statement] = STATE(2038),
    [sym_nonlocal_statement] = STATE(2038),
    [sym_exec_statement] = STATE(2038),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(384),
    [sym__indent] = ACTIONS(386),
    [sym_string_start] = ACTIONS(79),
  },
  [79] = {
    [sym__simple_statements] = STATE(671),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(388),
    [sym__indent] = ACTIONS(390),
    [sym_string_start] = ACTIONS(79),
  },
  [80] = {
    [sym__simple_statements] = STATE(656),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(392),
    [sym__indent] = ACTIONS(394),
    [sym_string_start] = ACTIONS(79),
  },
  [81] = {
    [sym__simple_statements] = STATE(736),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(396),
    [sym__indent] = ACTIONS(398),
    [sym_string_start] = ACTIONS(79),
  },
  [82] = {
    [sym__simple_statements] = STATE(2073),
    [sym_import_statement] = STATE(2038),
    [sym_future_import_statement] = STATE(2038),
    [sym_import_from_statement] = STATE(2038),
    [sym_print_statement] = STATE(2038),
    [sym_assert_statement] = STATE(2038),
    [sym_expression_statement] = STATE(2038),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2038),
    [sym_delete_statement] = STATE(2038),
    [sym_raise_statement] = STATE(2038),
    [sym_pass_statement] = STATE(2038),
    [sym_break_statement] = STATE(2038),
    [sym_continue_statement] = STATE(2038),
    [sym_global_statement] = STATE(2038),
    [sym_nonlocal_statement] = STATE(2038),
    [sym_exec_statement] = STATE(2038),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(400),
    [sym__indent] = ACTIONS(402),
    [sym_string_start] = ACTIONS(79),
  },
  [83] = {
    [sym__simple_statements] = STATE(674),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(404),
    [sym__indent] = ACTIONS(406),
    [sym_string_start] = ACTIONS(79),
  },
  [84] = {
    [sym__simple_statements] = STATE(603),
    [sym_import_statement] = STATE(2002),
    [sym_future_import_statement] = STATE(2002),
    [sym_import_from_statement] = STATE(2002),
    [sym_print_statement] = STATE(2002),
    [sym_assert_statement] = STATE(2002),
    [sym_expression_statement] = STATE(2002),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2002),
    [sym_delete_statement] = STATE(2002),
    [sym_raise_statement] = STATE(2002),
    [sym_pass_statement] = STATE(2002),
    [sym_break_statement] = STATE(2002),
    [sym_continue_statement] = STATE(2002),
    [sym_global_statement] = STATE(2002),
    [sym_nonlocal_statement] = STATE(2002),
    [sym_exec_statement] = STATE(2002),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(408),
    [sym__indent] = ACTIONS(410),
    [sym_string_start] = ACTIONS(79),
  },
  [85] = {
    [sym__simple_statements] = STATE(623),
    [sym_import_statement] = STATE(2002),
    [sym_future_import_statement] = STATE(2002),
    [sym_import_from_statement] = STATE(2002),
    [sym_print_statement] = STATE(2002),
    [sym_assert_statement] = STATE(2002),
    [sym_expression_statement] = STATE(2002),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2002),
    [sym_delete_statement] = STATE(2002),
    [sym_raise_statement] = STATE(2002),
    [sym_pass_statement] = STATE(2002),
    [sym_break_statement] = STATE(2002),
    [sym_continue_statement] = STATE(2002),
    [sym_global_statement] = STATE(2002),
    [sym_nonlocal_statement] = STATE(2002),
    [sym_exec_statement] = STATE(2002),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(412),
    [sym__indent] = ACTIONS(414),
    [sym_string_start] = ACTIONS(79),
  },
  [86] = {
    [sym__simple_statements] = STATE(730),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(416),
    [sym__indent] = ACTIONS(418),
    [sym_string_start] = ACTIONS(79),
  },
  [87] = {
    [sym__simple_statements] = STATE(731),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(420),
    [sym__indent] = ACTIONS(422),
    [sym_string_start] = ACTIONS(79),
  },
  [88] = {
    [sym__simple_statements] = STATE(651),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(424),
    [sym__indent] = ACTIONS(426),
    [sym_string_start] = ACTIONS(79),
  },
  [89] = {
    [sym__simple_statements] = STATE(1561),
    [sym_import_statement] = STATE(1907),
    [sym_future_import_statement] = STATE(1907),
    [sym_import_from_statement] = STATE(1907),
    [sym_print_statement] = STATE(1907),
    [sym_assert_statement] = STATE(1907),
    [sym_expression_statement] = STATE(1907),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1907),
    [sym_delete_statement] = STATE(1907),
    [sym_raise_statement] = STATE(1907),
    [sym_pass_statement] = STATE(1907),
    [sym_break_statement] = STATE(1907),
    [sym_continue_statement] = STATE(1907),
    [sym_global_statement] = STATE(1907),
    [sym_nonlocal_statement] = STATE(1907),
    [sym_exec_statement] = STATE(1907),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(428),
    [sym__indent] = ACTIONS(430),
    [sym_string_start] = ACTIONS(79),
  },
  [90] = {
    [sym__simple_statements] = STATE(646),
    [sym_import_statement] = STATE(1841),
    [sym_future_import_statement] = STATE(1841),
    [sym_import_from_statement] = STATE(1841),
    [sym_print_statement] = STATE(1841),
    [sym_assert_statement] = STATE(1841),
    [sym_expression_statement] = STATE(1841),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1841),
    [sym_delete_statement] = STATE(1841),
    [sym_raise_statement] = STATE(1841),
    [sym_pass_statement] = STATE(1841),
    [sym_break_statement] = STATE(1841),
    [sym_continue_statement] = STATE(1841),
    [sym_global_statement] = STATE(1841),
    [sym_nonlocal_statement] = STATE(1841),
    [sym_exec_statement] = STATE(1841),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(432),
    [sym__indent] = ACTIONS(434),
    [sym_string_start] = ACTIONS(79),
  },
  [91] = {
    [sym__simple_statements] = STATE(644),
    [sym_import_statement] = STATE(1841),
    [sym_future_import_statement] = STATE(1841),
    [sym_import_from_statement] = STATE(1841),
    [sym_print_statement] = STATE(1841),
    [sym_assert_statement] = STATE(1841),
    [sym_expression_statement] = STATE(1841),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1841),
    [sym_delete_statement] = STATE(1841),
    [sym_raise_statement] = STATE(1841),
    [sym_pass_statement] = STATE(1841),
    [sym_break_statement] = STATE(1841),
    [sym_continue_statement] = STATE(1841),
    [sym_global_statement] = STATE(1841),
    [sym_nonlocal_statement] = STATE(1841),
    [sym_exec_statement] = STATE(1841),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(436),
    [sym__indent] = ACTIONS(438),
    [sym_string_start] = ACTIONS(79),
  },
  [92] = {
    [sym__simple_statements] = STATE(676),
    [sym_import_statement] = STATE(1841),
    [sym_future_import_statement] = STATE(1841),
    [sym_import_from_statement] = STATE(1841),
    [sym_print_statement] = STATE(1841),
    [sym_assert_statement] = STATE(1841),
    [sym_expression_statement] = STATE(1841),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1841),
    [sym_delete_statement] = STATE(1841),
    [sym_raise_statement] = STATE(1841),
    [sym_pass_statement] = STATE(1841),
    [sym_break_statement] = STATE(1841),
    [sym_continue_statement] = STATE(1841),
    [sym_global_statement] = STATE(1841),
    [sym_nonlocal_statement] = STATE(1841),
    [sym_exec_statement] = STATE(1841),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(440),
    [sym__indent] = ACTIONS(442),
    [sym_string_start] = ACTIONS(79),
  },
  [93] = {
    [sym__simple_statements] = STATE(2124),
    [sym_import_statement] = STATE(2038),
    [sym_future_import_statement] = STATE(2038),
    [sym_import_from_statement] = STATE(2038),
    [sym_print_statement] = STATE(2038),
    [sym_assert_statement] = STATE(2038),
    [sym_expression_statement] = STATE(2038),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2038),
    [sym_delete_statement] = STATE(2038),
    [sym_raise_statement] = STATE(2038),
    [sym_pass_statement] = STATE(2038),
    [sym_break_statement] = STATE(2038),
    [sym_continue_statement] = STATE(2038),
    [sym_global_statement] = STATE(2038),
    [sym_nonlocal_statement] = STATE(2038),
    [sym_exec_statement] = STATE(2038),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(444),
    [sym__indent] = ACTIONS(446),
    [sym_string_start] = ACTIONS(79),
  },
  [94] = {
    [sym__simple_statements] = STATE(2086),
    [sym_import_statement] = STATE(2038),
    [sym_future_import_statement] = STATE(2038),
    [sym_import_from_statement] = STATE(2038),
    [sym_print_statement] = STATE(2038),
    [sym_assert_statement] = STATE(2038),
    [sym_expression_statement] = STATE(2038),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2038),
    [sym_delete_statement] = STATE(2038),
    [sym_raise_statement] = STATE(2038),
    [sym_pass_statement] = STATE(2038),
    [sym_break_statement] = STATE(2038),
    [sym_continue_statement] = STATE(2038),
    [sym_global_statement] = STATE(2038),
    [sym_nonlocal_statement] = STATE(2038),
    [sym_exec_statement] = STATE(2038),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(448),
    [sym__indent] = ACTIONS(450),
    [sym_string_start] = ACTIONS(79),
  },
  [95] = {
    [sym__simple_statements] = STATE(611),
    [sym_import_statement] = STATE(1919),
    [sym_future_import_statement] = STATE(1919),
    [sym_import_from_statement] = STATE(1919),
    [sym_print_statement] = STATE(1919),
    [sym_assert_statement] = STATE(1919),
    [sym_expression_statement] = STATE(1919),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1919),
    [sym_delete_statement] = STATE(1919),
    [sym_raise_statement] = STATE(1919),
    [sym_pass_statement] = STATE(1919),
    [sym_break_statement] = STATE(1919),
    [sym_continue_statement] = STATE(1919),
    [sym_global_statement] = STATE(1919),
    [sym_nonlocal_statement] = STATE(1919),
    [sym_exec_statement] = STATE(1919),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(452),
    [sym__indent] = ACTIONS(454),
    [sym_string_start] = ACTIONS(79),
  },
  [96] = {
    [sym__simple_statements] = STATE(653),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(456),
    [sym__indent] = ACTIONS(458),
    [sym_string_start] = ACTIONS(79),
  },
  [97] = {
    [sym__simple_statements] = STATE(717),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(460),
    [sym__indent] = ACTIONS(462),
    [sym_string_start] = ACTIONS(79),
  },
  [98] = {
    [sym__simple_statements] = STATE(669),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(464),
    [sym__indent] = ACTIONS(466),
    [sym_string_start] = ACTIONS(79),
  },
  [99] = {
    [sym__simple_statements] = STATE(698),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(468),
    [sym__indent] = ACTIONS(470),
    [sym_string_start] = ACTIONS(79),
  },
  [100] = {
    [sym__simple_statements] = STATE(681),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(472),
    [sym__indent] = ACTIONS(474),
    [sym_string_start] = ACTIONS(79),
  },
  [101] = {
    [sym__simple_statements] = STATE(616),
    [sym_import_statement] = STATE(1979),
    [sym_future_import_statement] = STATE(1979),
    [sym_import_from_statement] = STATE(1979),
    [sym_print_statement] = STATE(1979),
    [sym_assert_statement] = STATE(1979),
    [sym_expression_statement] = STATE(1979),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1979),
    [sym_delete_statement] = STATE(1979),
    [sym_raise_statement] = STATE(1979),
    [sym_pass_statement] = STATE(1979),
    [sym_break_statement] = STATE(1979),
    [sym_continue_statement] = STATE(1979),
    [sym_global_statement] = STATE(1979),
    [sym_nonlocal_statement] = STATE(1979),
    [sym_exec_statement] = STATE(1979),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(476),
    [sym__indent] = ACTIONS(478),
    [sym_string_start] = ACTIONS(79),
  },
  [102] = {
    [sym__simple_statements] = STATE(660),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(480),
    [sym__indent] = ACTIONS(482),
    [sym_string_start] = ACTIONS(79),
  },
  [103] = {
    [sym__simple_statements] = STATE(679),
    [sym_import_statement] = STATE(1848),
    [sym_future_import_statement] = STATE(1848),
    [sym_import_from_statement] = STATE(1848),
    [sym_print_statement] = STATE(1848),
    [sym_assert_statement] = STATE(1848),
    [sym_expression_statement] = STATE(1848),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1848),
    [sym_delete_statement] = STATE(1848),
    [sym_raise_statement] = STATE(1848),
    [sym_pass_statement] = STATE(1848),
    [sym_break_statement] = STATE(1848),
    [sym_continue_statement] = STATE(1848),
    [sym_global_statement] = STATE(1848),
    [sym_nonlocal_statement] = STATE(1848),
    [sym_exec_statement] = STATE(1848),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(484),
    [sym__indent] = ACTIONS(486),
    [sym_string_start] = ACTIONS(79),
  },
  [104] = {
    [sym__simple_statements] = STATE(720),
    [sym_import_statement] = STATE(1841),
    [sym_future_import_statement] = STATE(1841),
    [sym_import_from_statement] = STATE(1841),
    [sym_print_statement] = STATE(1841),
    [sym_assert_statement] = STATE(1841),
    [sym_expression_statement] = STATE(1841),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1841),
    [sym_delete_statement] = STATE(1841),
    [sym_raise_statement] = STATE(1841),
    [sym_pass_statement] = STATE(1841),
    [sym_break_statement] = STATE(1841),
    [sym_continue_statement] = STATE(1841),
    [sym_global_statement] = STATE(1841),
    [sym_nonlocal_statement] = STATE(1841),
    [sym_exec_statement] = STATE(1841),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(488),
    [sym__indent] = ACTIONS(490),
    [sym_string_start] = ACTIONS(79),
  },
  [105] = {
    [sym__simple_statements] = STATE(1575),
    [sym_import_statement] = STATE(1907),
    [sym_future_import_statement] = STATE(1907),
    [sym_import_from_statement] = STATE(1907),
    [sym_print_statement] = STATE(1907),
    [sym_assert_statement] = STATE(1907),
    [sym_expression_statement] = STATE(1907),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1907),
    [sym_delete_statement] = STATE(1907),
    [sym_raise_statement] = STATE(1907),
    [sym_pass_statement] = STATE(1907),
    [sym_break_statement] = STATE(1907),
    [sym_continue_statement] = STATE(1907),
    [sym_global_statement] = STATE(1907),
    [sym_nonlocal_statement] = STATE(1907),
    [sym_exec_statement] = STATE(1907),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(492),
    [sym__indent] = ACTIONS(494),
    [sym_string_start] = ACTIONS(79),
  },
  [106] = {
    [sym__simple_statements] = STATE(2095),
    [sym_import_statement] = STATE(2038),
    [sym_future_import_statement] = STATE(2038),
    [sym_import_from_statement] = STATE(2038),
    [sym_print_statement] = STATE(2038),
    [sym_assert_statement] = STATE(2038),
    [sym_expression_statement] = STATE(2038),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2038),
    [sym_delete_statement] = STATE(2038),
    [sym_raise_statement] = STATE(2038),
    [sym_pass_statement] = STATE(2038),
    [sym_break_statement] = STATE(2038),
    [sym_continue_statement] = STATE(2038),
    [sym_global_statement] = STATE(2038),
    [sym_nonlocal_statement] = STATE(2038),
    [sym_exec_statement] = STATE(2038),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(496),
    [sym__indent] = ACTIONS(498),
    [sym_string_start] = ACTIONS(79),
  },
  [107] = {
    [sym__simple_statements] = STATE(2071),
    [sym_import_statement] = STATE(2038),
    [sym_future_import_statement] = STATE(2038),
    [sym_import_from_statement] = STATE(2038),
    [sym_print_statement] = STATE(2038),
    [sym_assert_statement] = STATE(2038),
    [sym_expression_statement] = STATE(2038),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2038),
    [sym_delete_statement] = STATE(2038),
    [sym_raise_statement] = STATE(2038),
    [sym_pass_statement] = STATE(2038),
    [sym_break_statement] = STATE(2038),
    [sym_continue_statement] = STATE(2038),
    [sym_global_statement] = STATE(2038),
    [sym_nonlocal_statement] = STATE(2038),
    [sym_exec_statement] = STATE(2038),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(500),
    [sym__indent] = ACTIONS(502),
    [sym_string_start] = ACTIONS(79),
  },
  [108] = {
    [sym__simple_statements] = STATE(749),
    [sym_import_statement] = STATE(1841),
    [sym_future_import_statement] = STATE(1841),
    [sym_import_from_statement] = STATE(1841),
    [sym_print_statement] = STATE(1841),
    [sym_assert_statement] = STATE(1841),
    [sym_expression_statement] = STATE(1841),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1841),
    [sym_delete_statement] = STATE(1841),
    [sym_raise_statement] = STATE(1841),
    [sym_pass_statement] = STATE(1841),
    [sym_break_statement] = STATE(1841),
    [sym_continue_statement] = STATE(1841),
    [sym_global_statement] = STATE(1841),
    [sym_nonlocal_statement] = STATE(1841),
    [sym_exec_statement] = STATE(1841),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(504),
    [sym__indent] = ACTIONS(506),
    [sym_string_start] = ACTIONS(79),
  },
  [109] = {
    [sym__simple_statements] = STATE(657),
    [sym_import_statement] = STATE(1841),
    [sym_future_import_statement] = STATE(1841),
    [sym_import_from_statement] = STATE(1841),
    [sym_print_statement] = STATE(1841),
    [sym_assert_statement] = STATE(1841),
    [sym_expression_statement] = STATE(1841),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1841),
    [sym_delete_statement] = STATE(1841),
    [sym_raise_statement] = STATE(1841),
    [sym_pass_statement] = STATE(1841),
    [sym_break_statement] = STATE(1841),
    [sym_continue_statement] = STATE(1841),
    [sym_global_statement] = STATE(1841),
    [sym_nonlocal_statement] = STATE(1841),
    [sym_exec_statement] = STATE(1841),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(508),
    [sym__indent] = ACTIONS(510),
    [sym_string_start] = ACTIONS(79),
  },
  [110] = {
    [sym__simple_statements] = STATE(602),
    [sym_import_statement] = STATE(1919),
    [sym_future_import_statement] = STATE(1919),
    [sym_import_from_statement] = STATE(1919),
    [sym_print_statement] = STATE(1919),
    [sym_assert_statement] = STATE(1919),
    [sym_expression_statement] = STATE(1919),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1919),
    [sym_delete_statement] = STATE(1919),
    [sym_raise_statement] = STATE(1919),
    [sym_pass_statement] = STATE(1919),
    [sym_break_statement] = STATE(1919),
    [sym_continue_statement] = STATE(1919),
    [sym_global_statement] = STATE(1919),
    [sym_nonlocal_statement] = STATE(1919),
    [sym_exec_statement] = STATE(1919),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(512),
    [sym__indent] = ACTIONS(514),
    [sym_string_start] = ACTIONS(79),
  },
  [111] = {
    [sym__simple_statements] = STATE(2092),
    [sym_import_statement] = STATE(2038),
    [sym_future_import_statement] = STATE(2038),
    [sym_import_from_statement] = STATE(2038),
    [sym_print_statement] = STATE(2038),
    [sym_assert_statement] = STATE(2038),
    [sym_expression_statement] = STATE(2038),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2038),
    [sym_delete_statement] = STATE(2038),
    [sym_raise_statement] = STATE(2038),
    [sym_pass_statement] = STATE(2038),
    [sym_break_statement] = STATE(2038),
    [sym_continue_statement] = STATE(2038),
    [sym_global_statement] = STATE(2038),
    [sym_nonlocal_statement] = STATE(2038),
    [sym_exec_statement] = STATE(2038),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(516),
    [sym__indent] = ACTIONS(518),
    [sym_string_start] = ACTIONS(79),
  },
  [112] = {
    [sym__simple_statements] = STATE(715),
    [sym_import_statement] = STATE(1841),
    [sym_future_import_statement] = STATE(1841),
    [sym_import_from_statement] = STATE(1841),
    [sym_print_statement] = STATE(1841),
    [sym_assert_statement] = STATE(1841),
    [sym_expression_statement] = STATE(1841),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1841),
    [sym_delete_statement] = STATE(1841),
    [sym_raise_statement] = STATE(1841),
    [sym_pass_statement] = STATE(1841),
    [sym_break_statement] = STATE(1841),
    [sym_continue_statement] = STATE(1841),
    [sym_global_statement] = STATE(1841),
    [sym_nonlocal_statement] = STATE(1841),
    [sym_exec_statement] = STATE(1841),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(520),
    [sym__indent] = ACTIONS(522),
    [sym_string_start] = ACTIONS(79),
  },
  [113] = {
    [sym__simple_statements] = STATE(613),
    [sym_import_statement] = STATE(1919),
    [sym_future_import_statement] = STATE(1919),
    [sym_import_from_statement] = STATE(1919),
    [sym_print_statement] = STATE(1919),
    [sym_assert_statement] = STATE(1919),
    [sym_expression_statement] = STATE(1919),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(1919),
    [sym_delete_statement] = STATE(1919),
    [sym_raise_statement] = STATE(1919),
    [sym_pass_statement] = STATE(1919),
    [sym_break_statement] = STATE(1919),
    [sym_continue_statement] = STATE(1919),
    [sym_global_statement] = STATE(1919),
    [sym_nonlocal_statement] = STATE(1919),
    [sym_exec_statement] = STATE(1919),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(524),
    [sym__indent] = ACTIONS(526),
    [sym_string_start] = ACTIONS(79),
  },
  [114] = {
    [sym_import_statement] = STATE(2117),
    [sym_future_import_statement] = STATE(2117),
    [sym_import_from_statement] = STATE(2117),
    [sym_print_statement] = STATE(2117),
    [sym_assert_statement] = STATE(2117),
    [sym_expression_statement] = STATE(2117),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2117),
    [sym_delete_statement] = STATE(2117),
    [sym_raise_statement] = STATE(2117),
    [sym_pass_statement] = STATE(2117),
    [sym_break_statement] = STATE(2117),
    [sym_continue_statement] = STATE(2117),
    [sym_global_statement] = STATE(2117),
    [sym_nonlocal_statement] = STATE(2117),
    [sym_exec_statement] = STATE(2117),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(528),
    [sym_string_start] = ACTIONS(79),
  },
  [115] = {
    [sym_import_statement] = STATE(2117),
    [sym_future_import_statement] = STATE(2117),
    [sym_import_from_statement] = STATE(2117),
    [sym_print_statement] = STATE(2117),
    [sym_assert_statement] = STATE(2117),
    [sym_expression_statement] = STATE(2117),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2117),
    [sym_delete_statement] = STATE(2117),
    [sym_raise_statement] = STATE(2117),
    [sym_pass_statement] = STATE(2117),
    [sym_break_statement] = STATE(2117),
    [sym_continue_statement] = STATE(2117),
    [sym_global_statement] = STATE(2117),
    [sym_nonlocal_statement] = STATE(2117),
    [sym_exec_statement] = STATE(2117),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(530),
    [sym_string_start] = ACTIONS(79),
  },
  [116] = {
    [sym_import_statement] = STATE(2117),
    [sym_future_import_statement] = STATE(2117),
    [sym_import_from_statement] = STATE(2117),
    [sym_print_statement] = STATE(2117),
    [sym_assert_statement] = STATE(2117),
    [sym_expression_statement] = STATE(2117),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2117),
    [sym_delete_statement] = STATE(2117),
    [sym_raise_statement] = STATE(2117),
    [sym_pass_statement] = STATE(2117),
    [sym_break_statement] = STATE(2117),
    [sym_continue_statement] = STATE(2117),
    [sym_global_statement] = STATE(2117),
    [sym_nonlocal_statement] = STATE(2117),
    [sym_exec_statement] = STATE(2117),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(532),
    [sym_string_start] = ACTIONS(79),
  },
  [117] = {
    [sym_import_statement] = STATE(2117),
    [sym_future_import_statement] = STATE(2117),
    [sym_import_from_statement] = STATE(2117),
    [sym_print_statement] = STATE(2117),
    [sym_assert_statement] = STATE(2117),
    [sym_expression_statement] = STATE(2117),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2117),
    [sym_delete_statement] = STATE(2117),
    [sym_raise_statement] = STATE(2117),
    [sym_pass_statement] = STATE(2117),
    [sym_break_statement] = STATE(2117),
    [sym_continue_statement] = STATE(2117),
    [sym_global_statement] = STATE(2117),
    [sym_nonlocal_statement] = STATE(2117),
    [sym_exec_statement] = STATE(2117),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(534),
    [sym_string_start] = ACTIONS(79),
  },
  [118] = {
    [sym_import_statement] = STATE(2117),
    [sym_future_import_statement] = STATE(2117),
    [sym_import_from_statement] = STATE(2117),
    [sym_print_statement] = STATE(2117),
    [sym_assert_statement] = STATE(2117),
    [sym_expression_statement] = STATE(2117),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2117),
    [sym_delete_statement] = STATE(2117),
    [sym_raise_statement] = STATE(2117),
    [sym_pass_statement] = STATE(2117),
    [sym_break_statement] = STATE(2117),
    [sym_continue_statement] = STATE(2117),
    [sym_global_statement] = STATE(2117),
    [sym_nonlocal_statement] = STATE(2117),
    [sym_exec_statement] = STATE(2117),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(536),
    [sym_string_start] = ACTIONS(79),
  },
  [119] = {
    [sym_import_statement] = STATE(2117),
    [sym_future_import_statement] = STATE(2117),
    [sym_import_from_statement] = STATE(2117),
    [sym_print_statement] = STATE(2117),
    [sym_assert_statement] = STATE(2117),
    [sym_expression_statement] = STATE(2117),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2117),
    [sym_delete_statement] = STATE(2117),
    [sym_raise_statement] = STATE(2117),
    [sym_pass_statement] = STATE(2117),
    [sym_break_statement] = STATE(2117),
    [sym_continue_statement] = STATE(2117),
    [sym_global_statement] = STATE(2117),
    [sym_nonlocal_statement] = STATE(2117),
    [sym_exec_statement] = STATE(2117),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(538),
    [sym_string_start] = ACTIONS(79),
  },
  [120] = {
    [sym_import_statement] = STATE(2117),
    [sym_future_import_statement] = STATE(2117),
    [sym_import_from_statement] = STATE(2117),
    [sym_print_statement] = STATE(2117),
    [sym_assert_statement] = STATE(2117),
    [sym_expression_statement] = STATE(2117),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2117),
    [sym_delete_statement] = STATE(2117),
    [sym_raise_statement] = STATE(2117),
    [sym_pass_statement] = STATE(2117),
    [sym_break_statement] = STATE(2117),
    [sym_continue_statement] = STATE(2117),
    [sym_global_statement] = STATE(2117),
    [sym_nonlocal_statement] = STATE(2117),
    [sym_exec_statement] = STATE(2117),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(540),
    [sym_string_start] = ACTIONS(79),
  },
  [121] = {
    [sym_import_statement] = STATE(2117),
    [sym_future_import_statement] = STATE(2117),
    [sym_import_from_statement] = STATE(2117),
    [sym_print_statement] = STATE(2117),
    [sym_assert_statement] = STATE(2117),
    [sym_expression_statement] = STATE(2117),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2117),
    [sym_delete_statement] = STATE(2117),
    [sym_raise_statement] = STATE(2117),
    [sym_pass_statement] = STATE(2117),
    [sym_break_statement] = STATE(2117),
    [sym_continue_statement] = STATE(2117),
    [sym_global_statement] = STATE(2117),
    [sym_nonlocal_statement] = STATE(2117),
    [sym_exec_statement] = STATE(2117),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(542),
    [sym_string_start] = ACTIONS(79),
  },
  [122] = {
    [sym_import_statement] = STATE(2117),
    [sym_future_import_statement] = STATE(2117),
    [sym_import_from_statement] = STATE(2117),
    [sym_print_statement] = STATE(2117),
    [sym_assert_statement] = STATE(2117),
    [sym_expression_statement] = STATE(2117),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2117),
    [sym_delete_statement] = STATE(2117),
    [sym_raise_statement] = STATE(2117),
    [sym_pass_statement] = STATE(2117),
    [sym_break_statement] = STATE(2117),
    [sym_continue_statement] = STATE(2117),
    [sym_global_statement] = STATE(2117),
    [sym_nonlocal_statement] = STATE(2117),
    [sym_exec_statement] = STATE(2117),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(544),
    [sym_string_start] = ACTIONS(79),
  },
  [123] = {
    [sym_import_statement] = STATE(2117),
    [sym_future_import_statement] = STATE(2117),
    [sym_import_from_statement] = STATE(2117),
    [sym_print_statement] = STATE(2117),
    [sym_assert_statement] = STATE(2117),
    [sym_expression_statement] = STATE(2117),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2117),
    [sym_delete_statement] = STATE(2117),
    [sym_raise_statement] = STATE(2117),
    [sym_pass_statement] = STATE(2117),
    [sym_break_statement] = STATE(2117),
    [sym_continue_statement] = STATE(2117),
    [sym_global_statement] = STATE(2117),
    [sym_nonlocal_statement] = STATE(2117),
    [sym_exec_statement] = STATE(2117),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(546),
    [sym_string_start] = ACTIONS(79),
  },
  [124] = {
    [sym_import_statement] = STATE(2117),
    [sym_future_import_statement] = STATE(2117),
    [sym_import_from_statement] = STATE(2117),
    [sym_print_statement] = STATE(2117),
    [sym_assert_statement] = STATE(2117),
    [sym_expression_statement] = STATE(2117),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2117),
    [sym_delete_statement] = STATE(2117),
    [sym_raise_statement] = STATE(2117),
    [sym_pass_statement] = STATE(2117),
    [sym_break_statement] = STATE(2117),
    [sym_continue_statement] = STATE(2117),
    [sym_global_statement] = STATE(2117),
    [sym_nonlocal_statement] = STATE(2117),
    [sym_exec_statement] = STATE(2117),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(548),
    [sym_string_start] = ACTIONS(79),
  },
  [125] = {
    [sym_import_statement] = STATE(2117),
    [sym_future_import_statement] = STATE(2117),
    [sym_import_from_statement] = STATE(2117),
    [sym_print_statement] = STATE(2117),
    [sym_assert_statement] = STATE(2117),
    [sym_expression_statement] = STATE(2117),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2117),
    [sym_delete_statement] = STATE(2117),
    [sym_raise_statement] = STATE(2117),
    [sym_pass_statement] = STATE(2117),
    [sym_break_statement] = STATE(2117),
    [sym_continue_statement] = STATE(2117),
    [sym_global_statement] = STATE(2117),
    [sym_nonlocal_statement] = STATE(2117),
    [sym_exec_statement] = STATE(2117),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(550),
    [sym_string_start] = ACTIONS(79),
  },
  [126] = {
    [sym_import_statement] = STATE(2117),
    [sym_future_import_statement] = STATE(2117),
    [sym_import_from_statement] = STATE(2117),
    [sym_print_statement] = STATE(2117),
    [sym_assert_statement] = STATE(2117),
    [sym_expression_statement] = STATE(2117),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2117),
    [sym_delete_statement] = STATE(2117),
    [sym_raise_statement] = STATE(2117),
    [sym_pass_statement] = STATE(2117),
    [sym_break_statement] = STATE(2117),
    [sym_continue_statement] = STATE(2117),
    [sym_global_statement] = STATE(2117),
    [sym_nonlocal_statement] = STATE(2117),
    [sym_exec_statement] = STATE(2117),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(552),
    [sym_string_start] = ACTIONS(79),
  },
  [127] = {
    [sym_import_statement] = STATE(2117),
    [sym_future_import_statement] = STATE(2117),
    [sym_import_from_statement] = STATE(2117),
    [sym_print_statement] = STATE(2117),
    [sym_assert_statement] = STATE(2117),
    [sym_expression_statement] = STATE(2117),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2117),
    [sym_delete_statement] = STATE(2117),
    [sym_raise_statement] = STATE(2117),
    [sym_pass_statement] = STATE(2117),
    [sym_break_statement] = STATE(2117),
    [sym_continue_statement] = STATE(2117),
    [sym_global_statement] = STATE(2117),
    [sym_nonlocal_statement] = STATE(2117),
    [sym_exec_statement] = STATE(2117),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(554),
    [sym_string_start] = ACTIONS(79),
  },
  [128] = {
    [sym_import_statement] = STATE(2117),
    [sym_future_import_statement] = STATE(2117),
    [sym_import_from_statement] = STATE(2117),
    [sym_print_statement] = STATE(2117),
    [sym_assert_statement] = STATE(2117),
    [sym_expression_statement] = STATE(2117),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2117),
    [sym_delete_statement] = STATE(2117),
    [sym_raise_statement] = STATE(2117),
    [sym_pass_statement] = STATE(2117),
    [sym_break_statement] = STATE(2117),
    [sym_continue_statement] = STATE(2117),
    [sym_global_statement] = STATE(2117),
    [sym_nonlocal_statement] = STATE(2117),
    [sym_exec_statement] = STATE(2117),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(556),
    [sym_string_start] = ACTIONS(79),
  },
  [129] = {
    [sym_import_statement] = STATE(2117),
    [sym_future_import_statement] = STATE(2117),
    [sym_import_from_statement] = STATE(2117),
    [sym_print_statement] = STATE(2117),
    [sym_assert_statement] = STATE(2117),
    [sym_expression_statement] = STATE(2117),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2117),
    [sym_delete_statement] = STATE(2117),
    [sym_raise_statement] = STATE(2117),
    [sym_pass_statement] = STATE(2117),
    [sym_break_statement] = STATE(2117),
    [sym_continue_statement] = STATE(2117),
    [sym_global_statement] = STATE(2117),
    [sym_nonlocal_statement] = STATE(2117),
    [sym_exec_statement] = STATE(2117),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(558),
    [sym_string_start] = ACTIONS(79),
  },
  [130] = {
    [sym_import_statement] = STATE(2117),
    [sym_future_import_statement] = STATE(2117),
    [sym_import_from_statement] = STATE(2117),
    [sym_print_statement] = STATE(2117),
    [sym_assert_statement] = STATE(2117),
    [sym_expression_statement] = STATE(2117),
    [sym_named_expression] = STATE(1539),
    [sym__named_expression_lhs] = STATE(2307),
    [sym_return_statement] = STATE(2117),
    [sym_delete_statement] = STATE(2117),
    [sym_raise_statement] = STATE(2117),
    [sym_pass_statement] = STATE(2117),
    [sym_break_statement] = STATE(2117),
    [sym_continue_statement] = STATE(2117),
    [sym_global_statement] = STATE(2117),
    [sym_nonlocal_statement] = STATE(2117),
    [sym_exec_statement] = STATE(2117),
    [sym_pattern] = STATE(1448),
    [sym_tuple_pattern] = STATE(1449),
    [sym_list_pattern] = STATE(1449),
    [sym_list_splat_pattern] = STATE(578),
    [sym_as_pattern] = STATE(1539),
    [sym_expression] = STATE(1580),
    [sym_primary_expression] = STATE(1010),
    [sym_not_operator] = STATE(1539),
    [sym_boolean_operator] = STATE(1539),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_comparison_operator] = STATE(1539),
    [sym_lambda] = STATE(1539),
    [sym_assignment] = STATE(2069),
    [sym_augmented_assignment] = STATE(2069),
    [sym_pattern_list] = STATE(1465),
    [sym_yield] = STATE(2069),
    [sym_attribute] = STATE(566),
    [sym_subscript] = STATE(566),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_conditional_expression] = STATE(1539),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_from] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_STAR] = ACTIONS(17),
    [anon_sym_print] = ACTIONS(19),
    [anon_sym_assert] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_match] = ACTIONS(334),
    [anon_sym_async] = ACTIONS(334),
    [anon_sym_global] = ACTIONS(51),
    [anon_sym_nonlocal] = ACTIONS(53),
    [anon_sym_exec] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_lambda] = ACTIONS(67),
    [anon_sym_yield] = ACTIONS(69),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(77),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(79),
  },
  [131] = {
    [sym_list_splat_pattern] = STATE(1125),
    [sym_primary_expression] = STATE(909),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_attribute] = STATE(1021),
    [sym_subscript] = STATE(1021),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(272),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(560),
    [anon_sym_COMMA] = ACTIONS(279),
    [anon_sym_as] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_print] = ACTIONS(564),
    [anon_sym_GT_GT] = ACTIONS(274),
    [anon_sym_COLON_EQ] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_COLON] = ACTIONS(291),
    [anon_sym_match] = ACTIONS(564),
    [anon_sym_async] = ACTIONS(564),
    [anon_sym_in] = ACTIONS(274),
    [anon_sym_STAR_STAR] = ACTIONS(274),
    [anon_sym_exec] = ACTIONS(564),
    [anon_sym_AT] = ACTIONS(274),
    [anon_sym_LBRACK] = ACTIONS(566),
    [anon_sym_EQ] = ACTIONS(291),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(568),
    [anon_sym_DASH] = ACTIONS(568),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(274),
    [anon_sym_SLASH_SLASH] = ACTIONS(274),
    [anon_sym_PIPE] = ACTIONS(274),
    [anon_sym_AMP] = ACTIONS(274),
    [anon_sym_CARET] = ACTIONS(274),
    [anon_sym_LT_LT] = ACTIONS(274),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_BANG_EQ] = ACTIONS(272),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_LT_GT] = ACTIONS(272),
    [anon_sym_is] = ACTIONS(274),
    [anon_sym_PLUS_EQ] = ACTIONS(302),
    [anon_sym_DASH_EQ] = ACTIONS(302),
    [anon_sym_STAR_EQ] = ACTIONS(302),
    [anon_sym_SLASH_EQ] = ACTIONS(302),
    [anon_sym_AT_EQ] = ACTIONS(302),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(302),
    [anon_sym_PERCENT_EQ] = ACTIONS(302),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(302),
    [anon_sym_GT_GT_EQ] = ACTIONS(302),
    [anon_sym_LT_LT_EQ] = ACTIONS(302),
    [anon_sym_AMP_EQ] = ACTIONS(302),
    [anon_sym_CARET_EQ] = ACTIONS(302),
    [anon_sym_PIPE_EQ] = ACTIONS(302),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(570),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(272),
    [sym_string_start] = ACTIONS(79),
  },
  [132] = {
    [sym_list_splat_pattern] = STATE(1212),
    [sym_primary_expression] = STATE(1012),
    [sym_binary_operator] = STATE(1285),
    [sym_unary_operator] = STATE(1285),
    [sym_attribute] = STATE(1285),
    [sym_subscript] = STATE(1285),
    [sym_call] = STATE(1285),
    [sym_list] = STATE(1285),
    [sym_set] = STATE(1285),
    [sym_tuple] = STATE(1285),
    [sym_dictionary] = STATE(1285),
    [sym_list_comprehension] = STATE(1285),
    [sym_dictionary_comprehension] = STATE(1285),
    [sym_set_comprehension] = STATE(1285),
    [sym_generator_expression] = STATE(1285),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_concatenated_string] = STATE(1285),
    [sym_string] = STATE(938),
    [sym_await] = STATE(1285),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_SEMI] = ACTIONS(572),
    [anon_sym_DOT] = ACTIONS(574),
    [anon_sym_LPAREN] = ACTIONS(308),
    [anon_sym_COMMA] = ACTIONS(572),
    [anon_sym_as] = ACTIONS(577),
    [anon_sym_STAR] = ACTIONS(310),
    [anon_sym_print] = ACTIONS(579),
    [anon_sym_GT_GT] = ACTIONS(574),
    [anon_sym_if] = ACTIONS(577),
    [anon_sym_COLON] = ACTIONS(572),
    [anon_sym_match] = ACTIONS(579),
    [anon_sym_async] = ACTIONS(579),
    [anon_sym_in] = ACTIONS(577),
    [anon_sym_STAR_STAR] = ACTIONS(574),
    [anon_sym_exec] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(574),
    [anon_sym_LBRACK] = ACTIONS(314),
    [anon_sym_EQ] = ACTIONS(577),
    [anon_sym_not] = ACTIONS(577),
    [anon_sym_and] = ACTIONS(577),
    [anon_sym_or] = ACTIONS(577),
    [anon_sym_PLUS] = ACTIONS(318),
    [anon_sym_DASH] = ACTIONS(318),
    [anon_sym_SLASH] = ACTIONS(574),
    [anon_sym_PERCENT] = ACTIONS(574),
    [anon_sym_SLASH_SLASH] = ACTIONS(574),
    [anon_sym_PIPE] = ACTIONS(574),
    [anon_sym_AMP] = ACTIONS(574),
    [anon_sym_CARET] = ACTIONS(574),
    [anon_sym_LT_LT] = ACTIONS(574),
    [anon_sym_TILDE] = ACTIONS(320),
    [anon_sym_LT] = ACTIONS(577),
    [anon_sym_LT_EQ] = ACTIONS(572),
    [anon_sym_EQ_EQ] = ACTIONS(572),
    [anon_sym_BANG_EQ] = ACTIONS(572),
    [anon_sym_GT_EQ] = ACTIONS(572),
    [anon_sym_GT] = ACTIONS(577),
    [anon_sym_LT_GT] = ACTIONS(572),
    [anon_sym_is] = ACTIONS(577),
    [anon_sym_PLUS_EQ] = ACTIONS(572),
    [anon_sym_DASH_EQ] = ACTIONS(572),
    [anon_sym_STAR_EQ] = ACTIONS(572),
    [anon_sym_SLASH_EQ] = ACTIONS(572),
    [anon_sym_AT_EQ] = ACTIONS(572),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(572),
    [anon_sym_PERCENT_EQ] = ACTIONS(572),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(572),
    [anon_sym_GT_GT_EQ] = ACTIONS(572),
    [anon_sym_LT_LT_EQ] = ACTIONS(572),
    [anon_sym_AMP_EQ] = ACTIONS(572),
    [anon_sym_CARET_EQ] = ACTIONS(572),
    [anon_sym_PIPE_EQ] = ACTIONS(572),
    [sym_ellipsis] = ACTIONS(324),
    [anon_sym_LBRACE] = ACTIONS(326),
    [sym_integer] = ACTIONS(328),
    [sym_float] = ACTIONS(324),
    [anon_sym_await] = ACTIONS(581),
    [sym_true] = ACTIONS(328),
    [sym_false] = ACTIONS(328),
    [sym_none] = ACTIONS(328),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(572),
    [sym_string_start] = ACTIONS(332),
  },
  [133] = {
    [sym_list_splat_pattern] = STATE(1212),
    [sym_primary_expression] = STATE(1012),
    [sym_binary_operator] = STATE(1285),
    [sym_unary_operator] = STATE(1285),
    [sym_attribute] = STATE(1285),
    [sym_subscript] = STATE(1285),
    [sym_call] = STATE(1285),
    [sym_list] = STATE(1285),
    [sym_set] = STATE(1285),
    [sym_tuple] = STATE(1285),
    [sym_dictionary] = STATE(1285),
    [sym_list_comprehension] = STATE(1285),
    [sym_dictionary_comprehension] = STATE(1285),
    [sym_set_comprehension] = STATE(1285),
    [sym_generator_expression] = STATE(1285),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_concatenated_string] = STATE(1285),
    [sym_string] = STATE(938),
    [sym_await] = STATE(1285),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_DOT] = ACTIONS(574),
    [anon_sym_LPAREN] = ACTIONS(308),
    [anon_sym_COMMA] = ACTIONS(572),
    [anon_sym_as] = ACTIONS(577),
    [anon_sym_STAR] = ACTIONS(310),
    [anon_sym_print] = ACTIONS(579),
    [anon_sym_GT_GT] = ACTIONS(583),
    [anon_sym_if] = ACTIONS(577),
    [anon_sym_COLON] = ACTIONS(572),
    [anon_sym_match] = ACTIONS(579),
    [anon_sym_async] = ACTIONS(579),
    [anon_sym_for] = ACTIONS(577),
    [anon_sym_in] = ACTIONS(577),
    [anon_sym_STAR_STAR] = ACTIONS(583),
    [anon_sym_exec] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(583),
    [anon_sym_LBRACK] = ACTIONS(314),
    [anon_sym_EQ] = ACTIONS(577),
    [anon_sym_not] = ACTIONS(577),
    [anon_sym_and] = ACTIONS(577),
    [anon_sym_or] = ACTIONS(577),
    [anon_sym_PLUS] = ACTIONS(320),
    [anon_sym_DASH] = ACTIONS(320),
    [anon_sym_SLASH] = ACTIONS(574),
    [anon_sym_PERCENT] = ACTIONS(583),
    [anon_sym_SLASH_SLASH] = ACTIONS(583),
    [anon_sym_PIPE] = ACTIONS(583),
    [anon_sym_AMP] = ACTIONS(583),
    [anon_sym_CARET] = ACTIONS(583),
    [anon_sym_LT_LT] = ACTIONS(583),
    [anon_sym_TILDE] = ACTIONS(320),
    [anon_sym_LT] = ACTIONS(577),
    [anon_sym_LT_EQ] = ACTIONS(572),
    [anon_sym_EQ_EQ] = ACTIONS(572),
    [anon_sym_BANG_EQ] = ACTIONS(572),
    [anon_sym_GT_EQ] = ACTIONS(572),
    [anon_sym_GT] = ACTIONS(577),
    [anon_sym_LT_GT] = ACTIONS(572),
    [anon_sym_is] = ACTIONS(577),
    [sym_ellipsis] = ACTIONS(324),
    [anon_sym_LBRACE] = ACTIONS(326),
    [anon_sym_RBRACE] = ACTIONS(572),
    [sym_type_conversion] = ACTIONS(572),
    [sym_integer] = ACTIONS(328),
    [sym_float] = ACTIONS(324),
    [anon_sym_await] = ACTIONS(581),
    [sym_true] = ACTIONS(328),
    [sym_false] = ACTIONS(328),
    [sym_none] = ACTIONS(328),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(332),
  },
  [134] = {
    [sym_list_splat_pattern] = STATE(1068),
    [sym_primary_expression] = STATE(926),
    [sym_binary_operator] = STATE(1134),
    [sym_unary_operator] = STATE(1134),
    [sym_attribute] = STATE(1134),
    [sym_subscript] = STATE(1134),
    [sym_call] = STATE(1134),
    [sym_list] = STATE(1134),
    [sym_set] = STATE(1134),
    [sym_tuple] = STATE(1134),
    [sym_dictionary] = STATE(1134),
    [sym_list_comprehension] = STATE(1134),
    [sym_dictionary_comprehension] = STATE(1134),
    [sym_set_comprehension] = STATE(1134),
    [sym_generator_expression] = STATE(1134),
    [sym_parenthesized_expression] = STATE(1134),
    [sym_concatenated_string] = STATE(1134),
    [sym_string] = STATE(896),
    [sym_await] = STATE(1134),
    [sym_identifier] = ACTIONS(586),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(588),
    [anon_sym_COMMA] = ACTIONS(279),
    [anon_sym_as] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(590),
    [anon_sym_print] = ACTIONS(592),
    [anon_sym_GT_GT] = ACTIONS(272),
    [anon_sym_COLON_EQ] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_COLON] = ACTIONS(274),
    [anon_sym_match] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(592),
    [anon_sym_in] = ACTIONS(274),
    [anon_sym_STAR_STAR] = ACTIONS(272),
    [anon_sym_exec] = ACTIONS(592),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(594),
    [anon_sym_EQ] = ACTIONS(274),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(596),
    [anon_sym_DASH] = ACTIONS(596),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(272),
    [anon_sym_SLASH_SLASH] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(272),
    [anon_sym_AMP] = ACTIONS(272),
    [anon_sym_CARET] = ACTIONS(272),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_TILDE] = ACTIONS(596),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_BANG_EQ] = ACTIONS(272),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_LT_GT] = ACTIONS(272),
    [anon_sym_is] = ACTIONS(274),
    [sym_ellipsis] = ACTIONS(598),
    [anon_sym_LBRACE] = ACTIONS(600),
    [anon_sym_RBRACE] = ACTIONS(272),
    [sym_type_conversion] = ACTIONS(272),
    [sym_integer] = ACTIONS(586),
    [sym_float] = ACTIONS(598),
    [anon_sym_await] = ACTIONS(602),
    [sym_true] = ACTIONS(586),
    [sym_false] = ACTIONS(586),
    [sym_none] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(604),
  },
  [135] = {
    [sym_list_splat_pattern] = STATE(1125),
    [sym_primary_expression] = STATE(909),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_attribute] = STATE(1021),
    [sym_subscript] = STATE(1021),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(272),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_from] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(560),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_print] = ACTIONS(564),
    [anon_sym_GT_GT] = ACTIONS(272),
    [anon_sym_COLON_EQ] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_match] = ACTIONS(564),
    [anon_sym_async] = ACTIONS(564),
    [anon_sym_in] = ACTIONS(274),
    [anon_sym_STAR_STAR] = ACTIONS(272),
    [anon_sym_exec] = ACTIONS(564),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(566),
    [anon_sym_EQ] = ACTIONS(274),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(272),
    [anon_sym_SLASH_SLASH] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(272),
    [anon_sym_AMP] = ACTIONS(272),
    [anon_sym_CARET] = ACTIONS(272),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_BANG_EQ] = ACTIONS(272),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_LT_GT] = ACTIONS(272),
    [anon_sym_is] = ACTIONS(274),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(570),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(272),
    [sym_string_start] = ACTIONS(79),
  },
  [136] = {
    [sym_list_splat_pattern] = STATE(1068),
    [sym_primary_expression] = STATE(926),
    [sym_binary_operator] = STATE(1134),
    [sym_unary_operator] = STATE(1134),
    [sym_attribute] = STATE(1134),
    [sym_subscript] = STATE(1134),
    [sym_call] = STATE(1134),
    [sym_list] = STATE(1134),
    [sym_set] = STATE(1134),
    [sym_tuple] = STATE(1134),
    [sym_dictionary] = STATE(1134),
    [sym_list_comprehension] = STATE(1134),
    [sym_dictionary_comprehension] = STATE(1134),
    [sym_set_comprehension] = STATE(1134),
    [sym_generator_expression] = STATE(1134),
    [sym_parenthesized_expression] = STATE(1134),
    [sym_concatenated_string] = STATE(1134),
    [sym_string] = STATE(896),
    [sym_await] = STATE(1134),
    [sym_identifier] = ACTIONS(586),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(588),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(590),
    [anon_sym_print] = ACTIONS(592),
    [anon_sym_GT_GT] = ACTIONS(272),
    [anon_sym_COLON_EQ] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_COLON] = ACTIONS(274),
    [anon_sym_match] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(592),
    [anon_sym_in] = ACTIONS(274),
    [anon_sym_STAR_STAR] = ACTIONS(272),
    [anon_sym_exec] = ACTIONS(592),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(594),
    [anon_sym_EQ] = ACTIONS(274),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(596),
    [anon_sym_DASH] = ACTIONS(596),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(272),
    [anon_sym_SLASH_SLASH] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(272),
    [anon_sym_AMP] = ACTIONS(272),
    [anon_sym_CARET] = ACTIONS(272),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_TILDE] = ACTIONS(596),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_BANG_EQ] = ACTIONS(272),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_LT_GT] = ACTIONS(272),
    [anon_sym_is] = ACTIONS(274),
    [sym_ellipsis] = ACTIONS(598),
    [anon_sym_LBRACE] = ACTIONS(600),
    [anon_sym_RBRACE] = ACTIONS(272),
    [sym_type_conversion] = ACTIONS(272),
    [sym_integer] = ACTIONS(586),
    [sym_float] = ACTIONS(598),
    [anon_sym_await] = ACTIONS(602),
    [sym_true] = ACTIONS(586),
    [sym_false] = ACTIONS(586),
    [sym_none] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(604),
  },
  [137] = {
    [sym_list_splat_pattern] = STATE(1273),
    [sym_primary_expression] = STATE(997),
    [sym_binary_operator] = STATE(1197),
    [sym_unary_operator] = STATE(1197),
    [sym_attribute] = STATE(1197),
    [sym_subscript] = STATE(1197),
    [sym_call] = STATE(1197),
    [sym_list] = STATE(1197),
    [sym_set] = STATE(1197),
    [sym_tuple] = STATE(1197),
    [sym_dictionary] = STATE(1197),
    [sym_list_comprehension] = STATE(1197),
    [sym_dictionary_comprehension] = STATE(1197),
    [sym_set_comprehension] = STATE(1197),
    [sym_generator_expression] = STATE(1197),
    [sym_parenthesized_expression] = STATE(1197),
    [sym_concatenated_string] = STATE(1197),
    [sym_string] = STATE(907),
    [sym_await] = STATE(1197),
    [sym_identifier] = ACTIONS(606),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(608),
    [anon_sym_RPAREN] = ACTIONS(272),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(610),
    [anon_sym_print] = ACTIONS(612),
    [anon_sym_GT_GT] = ACTIONS(272),
    [anon_sym_COLON_EQ] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_match] = ACTIONS(612),
    [anon_sym_async] = ACTIONS(612),
    [anon_sym_for] = ACTIONS(274),
    [anon_sym_in] = ACTIONS(274),
    [anon_sym_STAR_STAR] = ACTIONS(272),
    [anon_sym_exec] = ACTIONS(612),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(614),
    [anon_sym_EQ] = ACTIONS(616),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(618),
    [anon_sym_DASH] = ACTIONS(618),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(272),
    [anon_sym_SLASH_SLASH] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(272),
    [anon_sym_AMP] = ACTIONS(272),
    [anon_sym_CARET] = ACTIONS(272),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_TILDE] = ACTIONS(618),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_BANG_EQ] = ACTIONS(272),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_LT_GT] = ACTIONS(272),
    [anon_sym_is] = ACTIONS(274),
    [sym_ellipsis] = ACTIONS(620),
    [anon_sym_LBRACE] = ACTIONS(622),
    [sym_integer] = ACTIONS(606),
    [sym_float] = ACTIONS(620),
    [anon_sym_await] = ACTIONS(624),
    [sym_true] = ACTIONS(606),
    [sym_false] = ACTIONS(606),
    [sym_none] = ACTIONS(606),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(626),
  },
  [138] = {
    [sym_list_splat_pattern] = STATE(1212),
    [sym_primary_expression] = STATE(1012),
    [sym_binary_operator] = STATE(1285),
    [sym_unary_operator] = STATE(1285),
    [sym_attribute] = STATE(1285),
    [sym_subscript] = STATE(1285),
    [sym_call] = STATE(1285),
    [sym_list] = STATE(1285),
    [sym_set] = STATE(1285),
    [sym_tuple] = STATE(1285),
    [sym_dictionary] = STATE(1285),
    [sym_list_comprehension] = STATE(1285),
    [sym_dictionary_comprehension] = STATE(1285),
    [sym_set_comprehension] = STATE(1285),
    [sym_generator_expression] = STATE(1285),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_concatenated_string] = STATE(1285),
    [sym_string] = STATE(938),
    [sym_await] = STATE(1285),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_SEMI] = ACTIONS(572),
    [anon_sym_DOT] = ACTIONS(574),
    [anon_sym_from] = ACTIONS(577),
    [anon_sym_LPAREN] = ACTIONS(308),
    [anon_sym_COMMA] = ACTIONS(572),
    [anon_sym_as] = ACTIONS(577),
    [anon_sym_STAR] = ACTIONS(310),
    [anon_sym_print] = ACTIONS(579),
    [anon_sym_GT_GT] = ACTIONS(583),
    [anon_sym_if] = ACTIONS(577),
    [anon_sym_match] = ACTIONS(579),
    [anon_sym_async] = ACTIONS(579),
    [anon_sym_in] = ACTIONS(577),
    [anon_sym_STAR_STAR] = ACTIONS(583),
    [anon_sym_exec] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(583),
    [anon_sym_LBRACK] = ACTIONS(314),
    [anon_sym_EQ] = ACTIONS(577),
    [anon_sym_not] = ACTIONS(577),
    [anon_sym_and] = ACTIONS(577),
    [anon_sym_or] = ACTIONS(577),
    [anon_sym_PLUS] = ACTIONS(320),
    [anon_sym_DASH] = ACTIONS(320),
    [anon_sym_SLASH] = ACTIONS(574),
    [anon_sym_PERCENT] = ACTIONS(583),
    [anon_sym_SLASH_SLASH] = ACTIONS(583),
    [anon_sym_PIPE] = ACTIONS(583),
    [anon_sym_AMP] = ACTIONS(583),
    [anon_sym_CARET] = ACTIONS(583),
    [anon_sym_LT_LT] = ACTIONS(583),
    [anon_sym_TILDE] = ACTIONS(320),
    [anon_sym_LT] = ACTIONS(577),
    [anon_sym_LT_EQ] = ACTIONS(572),
    [anon_sym_EQ_EQ] = ACTIONS(572),
    [anon_sym_BANG_EQ] = ACTIONS(572),
    [anon_sym_GT_EQ] = ACTIONS(572),
    [anon_sym_GT] = ACTIONS(577),
    [anon_sym_LT_GT] = ACTIONS(572),
    [anon_sym_is] = ACTIONS(577),
    [sym_ellipsis] = ACTIONS(324),
    [anon_sym_LBRACE] = ACTIONS(326),
    [sym_integer] = ACTIONS(328),
    [sym_float] = ACTIONS(324),
    [anon_sym_await] = ACTIONS(581),
    [sym_true] = ACTIONS(328),
    [sym_false] = ACTIONS(328),
    [sym_none] = ACTIONS(328),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(572),
    [sym_string_start] = ACTIONS(332),
  },
  [139] = {
    [sym_list_splat_pattern] = STATE(1029),
    [sym_primary_expression] = STATE(931),
    [sym_binary_operator] = STATE(1020),
    [sym_unary_operator] = STATE(1020),
    [sym_attribute] = STATE(1020),
    [sym_subscript] = STATE(1020),
    [sym_call] = STATE(1020),
    [sym_list] = STATE(1020),
    [sym_set] = STATE(1020),
    [sym_tuple] = STATE(1020),
    [sym_dictionary] = STATE(1020),
    [sym_list_comprehension] = STATE(1020),
    [sym_dictionary_comprehension] = STATE(1020),
    [sym_set_comprehension] = STATE(1020),
    [sym_generator_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_concatenated_string] = STATE(1020),
    [sym_string] = STATE(893),
    [sym_await] = STATE(1020),
    [sym_identifier] = ACTIONS(628),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(630),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(632),
    [anon_sym_print] = ACTIONS(634),
    [anon_sym_GT_GT] = ACTIONS(272),
    [anon_sym_COLON_EQ] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_COLON] = ACTIONS(274),
    [anon_sym_match] = ACTIONS(634),
    [anon_sym_async] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(274),
    [anon_sym_in] = ACTIONS(274),
    [anon_sym_STAR_STAR] = ACTIONS(272),
    [anon_sym_exec] = ACTIONS(634),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(636),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(638),
    [anon_sym_DASH] = ACTIONS(638),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(272),
    [anon_sym_SLASH_SLASH] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(272),
    [anon_sym_AMP] = ACTIONS(272),
    [anon_sym_CARET] = ACTIONS(272),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_TILDE] = ACTIONS(638),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_BANG_EQ] = ACTIONS(272),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_LT_GT] = ACTIONS(272),
    [anon_sym_is] = ACTIONS(274),
    [sym_ellipsis] = ACTIONS(640),
    [anon_sym_LBRACE] = ACTIONS(642),
    [anon_sym_RBRACE] = ACTIONS(272),
    [sym_integer] = ACTIONS(628),
    [sym_float] = ACTIONS(640),
    [anon_sym_await] = ACTIONS(644),
    [sym_true] = ACTIONS(628),
    [sym_false] = ACTIONS(628),
    [sym_none] = ACTIONS(628),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(646),
  },
  [140] = {
    [sym_list_splat_pattern] = STATE(1212),
    [sym_primary_expression] = STATE(1012),
    [sym_binary_operator] = STATE(1285),
    [sym_unary_operator] = STATE(1285),
    [sym_attribute] = STATE(1285),
    [sym_subscript] = STATE(1285),
    [sym_call] = STATE(1285),
    [sym_list] = STATE(1285),
    [sym_set] = STATE(1285),
    [sym_tuple] = STATE(1285),
    [sym_dictionary] = STATE(1285),
    [sym_list_comprehension] = STATE(1285),
    [sym_dictionary_comprehension] = STATE(1285),
    [sym_set_comprehension] = STATE(1285),
    [sym_generator_expression] = STATE(1285),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_concatenated_string] = STATE(1285),
    [sym_string] = STATE(938),
    [sym_await] = STATE(1285),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(308),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(310),
    [anon_sym_print] = ACTIONS(579),
    [anon_sym_GT_GT] = ACTIONS(272),
    [anon_sym_COLON_EQ] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_COLON] = ACTIONS(274),
    [anon_sym_else] = ACTIONS(274),
    [anon_sym_match] = ACTIONS(579),
    [anon_sym_async] = ACTIONS(579),
    [anon_sym_in] = ACTIONS(274),
    [anon_sym_STAR_STAR] = ACTIONS(272),
    [anon_sym_exec] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(314),
    [anon_sym_EQ] = ACTIONS(274),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(320),
    [anon_sym_DASH] = ACTIONS(320),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(272),
    [anon_sym_SLASH_SLASH] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(272),
    [anon_sym_AMP] = ACTIONS(272),
    [anon_sym_CARET] = ACTIONS(272),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_TILDE] = ACTIONS(320),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_BANG_EQ] = ACTIONS(272),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_LT_GT] = ACTIONS(272),
    [anon_sym_is] = ACTIONS(274),
    [sym_ellipsis] = ACTIONS(324),
    [anon_sym_LBRACE] = ACTIONS(326),
    [sym_integer] = ACTIONS(328),
    [sym_float] = ACTIONS(324),
    [anon_sym_await] = ACTIONS(581),
    [sym_true] = ACTIONS(328),
    [sym_false] = ACTIONS(328),
    [sym_none] = ACTIONS(328),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(332),
  },
  [141] = {
    [sym_list_splat_pattern] = STATE(1068),
    [sym_primary_expression] = STATE(926),
    [sym_binary_operator] = STATE(1134),
    [sym_unary_operator] = STATE(1134),
    [sym_attribute] = STATE(1134),
    [sym_subscript] = STATE(1134),
    [sym_call] = STATE(1134),
    [sym_list] = STATE(1134),
    [sym_set] = STATE(1134),
    [sym_tuple] = STATE(1134),
    [sym_dictionary] = STATE(1134),
    [sym_list_comprehension] = STATE(1134),
    [sym_dictionary_comprehension] = STATE(1134),
    [sym_set_comprehension] = STATE(1134),
    [sym_generator_expression] = STATE(1134),
    [sym_parenthesized_expression] = STATE(1134),
    [sym_concatenated_string] = STATE(1134),
    [sym_string] = STATE(896),
    [sym_await] = STATE(1134),
    [sym_identifier] = ACTIONS(586),
    [anon_sym_DOT] = ACTIONS(574),
    [anon_sym_LPAREN] = ACTIONS(588),
    [anon_sym_COMMA] = ACTIONS(583),
    [anon_sym_as] = ACTIONS(574),
    [anon_sym_STAR] = ACTIONS(590),
    [anon_sym_print] = ACTIONS(592),
    [anon_sym_GT_GT] = ACTIONS(583),
    [anon_sym_COLON_EQ] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(574),
    [anon_sym_COLON] = ACTIONS(577),
    [anon_sym_match] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(592),
    [anon_sym_for] = ACTIONS(577),
    [anon_sym_in] = ACTIONS(574),
    [anon_sym_STAR_STAR] = ACTIONS(583),
    [anon_sym_exec] = ACTIONS(592),
    [anon_sym_AT] = ACTIONS(583),
    [anon_sym_LBRACK] = ACTIONS(594),
    [anon_sym_not] = ACTIONS(574),
    [anon_sym_and] = ACTIONS(574),
    [anon_sym_or] = ACTIONS(574),
    [anon_sym_PLUS] = ACTIONS(596),
    [anon_sym_DASH] = ACTIONS(596),
    [anon_sym_SLASH] = ACTIONS(574),
    [anon_sym_PERCENT] = ACTIONS(583),
    [anon_sym_SLASH_SLASH] = ACTIONS(583),
    [anon_sym_PIPE] = ACTIONS(583),
    [anon_sym_AMP] = ACTIONS(583),
    [anon_sym_CARET] = ACTIONS(583),
    [anon_sym_LT_LT] = ACTIONS(583),
    [anon_sym_TILDE] = ACTIONS(596),
    [anon_sym_LT] = ACTIONS(574),
    [anon_sym_LT_EQ] = ACTIONS(583),
    [anon_sym_EQ_EQ] = ACTIONS(583),
    [anon_sym_BANG_EQ] = ACTIONS(583),
    [anon_sym_GT_EQ] = ACTIONS(583),
    [anon_sym_GT] = ACTIONS(574),
    [anon_sym_LT_GT] = ACTIONS(583),
    [anon_sym_is] = ACTIONS(574),
    [sym_ellipsis] = ACTIONS(598),
    [anon_sym_LBRACE] = ACTIONS(600),
    [anon_sym_RBRACE] = ACTIONS(583),
    [sym_integer] = ACTIONS(586),
    [sym_float] = ACTIONS(598),
    [anon_sym_await] = ACTIONS(602),
    [sym_true] = ACTIONS(586),
    [sym_false] = ACTIONS(586),
    [sym_none] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(604),
  },
  [142] = {
    [sym_list_splat_pattern] = STATE(1068),
    [sym_primary_expression] = STATE(926),
    [sym_binary_operator] = STATE(1134),
    [sym_unary_operator] = STATE(1134),
    [sym_attribute] = STATE(1134),
    [sym_subscript] = STATE(1134),
    [sym_call] = STATE(1134),
    [sym_list] = STATE(1134),
    [sym_set] = STATE(1134),
    [sym_tuple] = STATE(1134),
    [sym_dictionary] = STATE(1134),
    [sym_list_comprehension] = STATE(1134),
    [sym_dictionary_comprehension] = STATE(1134),
    [sym_set_comprehension] = STATE(1134),
    [sym_generator_expression] = STATE(1134),
    [sym_parenthesized_expression] = STATE(1134),
    [sym_concatenated_string] = STATE(1134),
    [sym_string] = STATE(896),
    [sym_await] = STATE(1134),
    [sym_identifier] = ACTIONS(586),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(588),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(590),
    [anon_sym_print] = ACTIONS(592),
    [anon_sym_GT_GT] = ACTIONS(272),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_COLON] = ACTIONS(272),
    [anon_sym_match] = ACTIONS(592),
    [anon_sym_async] = ACTIONS(592),
    [anon_sym_in] = ACTIONS(274),
    [anon_sym_STAR_STAR] = ACTIONS(272),
    [anon_sym_exec] = ACTIONS(592),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(594),
    [anon_sym_EQ] = ACTIONS(274),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(596),
    [anon_sym_DASH] = ACTIONS(596),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(272),
    [anon_sym_SLASH_SLASH] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(272),
    [anon_sym_AMP] = ACTIONS(272),
    [anon_sym_CARET] = ACTIONS(272),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_TILDE] = ACTIONS(596),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_BANG_EQ] = ACTIONS(272),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_LT_GT] = ACTIONS(272),
    [anon_sym_is] = ACTIONS(274),
    [sym_ellipsis] = ACTIONS(598),
    [anon_sym_LBRACE] = ACTIONS(600),
    [anon_sym_RBRACE] = ACTIONS(272),
    [sym_type_conversion] = ACTIONS(272),
    [sym_integer] = ACTIONS(586),
    [sym_float] = ACTIONS(598),
    [anon_sym_await] = ACTIONS(602),
    [sym_true] = ACTIONS(586),
    [sym_false] = ACTIONS(586),
    [sym_none] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(604),
  },
  [143] = {
    [sym_list_splat_pattern] = STATE(1125),
    [sym_primary_expression] = STATE(909),
    [sym_binary_operator] = STATE(1021),
    [sym_unary_operator] = STATE(1021),
    [sym_attribute] = STATE(1021),
    [sym_subscript] = STATE(1021),
    [sym_call] = STATE(1021),
    [sym_list] = STATE(1021),
    [sym_set] = STATE(1021),
    [sym_tuple] = STATE(1021),
    [sym_dictionary] = STATE(1021),
    [sym_list_comprehension] = STATE(1021),
    [sym_dictionary_comprehension] = STATE(1021),
    [sym_set_comprehension] = STATE(1021),
    [sym_generator_expression] = STATE(1021),
    [sym_parenthesized_expression] = STATE(1021),
    [sym_concatenated_string] = STATE(1021),
    [sym_string] = STATE(891),
    [sym_await] = STATE(1021),
    [sym_identifier] = ACTIONS(75),
    [anon_sym_SEMI] = ACTIONS(272),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_from] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(560),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_print] = ACTIONS(564),
    [anon_sym_GT_GT] = ACTIONS(272),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_match] = ACTIONS(564),
    [anon_sym_async] = ACTIONS(564),
    [anon_sym_in] = ACTIONS(274),
    [anon_sym_STAR_STAR] = ACTIONS(272),
    [anon_sym_exec] = ACTIONS(564),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(566),
    [anon_sym_EQ] = ACTIONS(274),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(65),
    [anon_sym_DASH] = ACTIONS(65),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(272),
    [anon_sym_SLASH_SLASH] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(272),
    [anon_sym_AMP] = ACTIONS(272),
    [anon_sym_CARET] = ACTIONS(272),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_TILDE] = ACTIONS(65),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_BANG_EQ] = ACTIONS(272),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_LT_GT] = ACTIONS(272),
    [anon_sym_is] = ACTIONS(274),
    [sym_ellipsis] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(73),
    [sym_integer] = ACTIONS(75),
    [sym_float] = ACTIONS(71),
    [anon_sym_await] = ACTIONS(570),
    [sym_true] = ACTIONS(75),
    [sym_false] = ACTIONS(75),
    [sym_none] = ACTIONS(75),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(272),
    [sym_string_start] = ACTIONS(79),
  },
  [144] = {
    [sym_list_splat_pattern] = STATE(1212),
    [sym_primary_expression] = STATE(1012),
    [sym_binary_operator] = STATE(1285),
    [sym_unary_operator] = STATE(1285),
    [sym_attribute] = STATE(1285),
    [sym_subscript] = STATE(1285),
    [sym_call] = STATE(1285),
    [sym_list] = STATE(1285),
    [sym_set] = STATE(1285),
    [sym_tuple] = STATE(1285),
    [sym_dictionary] = STATE(1285),
    [sym_list_comprehension] = STATE(1285),
    [sym_dictionary_comprehension] = STATE(1285),
    [sym_set_comprehension] = STATE(1285),
    [sym_generator_expression] = STATE(1285),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_concatenated_string] = STATE(1285),
    [sym_string] = STATE(938),
    [sym_await] = STATE(1285),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_DOT] = ACTIONS(574),
    [anon_sym_LPAREN] = ACTIONS(308),
    [anon_sym_COMMA] = ACTIONS(572),
    [anon_sym_as] = ACTIONS(577),
    [anon_sym_STAR] = ACTIONS(310),
    [anon_sym_print] = ACTIONS(579),
    [anon_sym_GT_GT] = ACTIONS(583),
    [anon_sym_if] = ACTIONS(577),
    [anon_sym_COLON] = ACTIONS(572),
    [anon_sym_else] = ACTIONS(577),
    [anon_sym_match] = ACTIONS(579),
    [anon_sym_async] = ACTIONS(579),
    [anon_sym_in] = ACTIONS(577),
    [anon_sym_STAR_STAR] = ACTIONS(583),
    [anon_sym_exec] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(583),
    [anon_sym_LBRACK] = ACTIONS(314),
    [anon_sym_EQ] = ACTIONS(577),
    [anon_sym_not] = ACTIONS(577),
    [anon_sym_and] = ACTIONS(577),
    [anon_sym_or] = ACTIONS(577),
    [anon_sym_PLUS] = ACTIONS(320),
    [anon_sym_DASH] = ACTIONS(320),
    [anon_sym_SLASH] = ACTIONS(574),
    [anon_sym_PERCENT] = ACTIONS(583),
    [anon_sym_SLASH_SLASH] = ACTIONS(583),
    [anon_sym_PIPE] = ACTIONS(583),
    [anon_sym_AMP] = ACTIONS(583),
    [anon_sym_CARET] = ACTIONS(583),
    [anon_sym_LT_LT] = ACTIONS(583),
    [anon_sym_TILDE] = ACTIONS(320),
    [anon_sym_LT] = ACTIONS(577),
    [anon_sym_LT_EQ] = ACTIONS(572),
    [anon_sym_EQ_EQ] = ACTIONS(572),
    [anon_sym_BANG_EQ] = ACTIONS(572),
    [anon_sym_GT_EQ] = ACTIONS(572),
    [anon_sym_GT] = ACTIONS(577),
    [anon_sym_LT_GT] = ACTIONS(572),
    [anon_sym_is] = ACTIONS(577),
    [sym_ellipsis] = ACTIONS(324),
    [anon_sym_LBRACE] = ACTIONS(326),
    [sym_integer] = ACTIONS(328),
    [sym_float] = ACTIONS(324),
    [anon_sym_await] = ACTIONS(581),
    [sym_true] = ACTIONS(328),
    [sym_false] = ACTIONS(328),
    [sym_none] = ACTIONS(328),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(332),
  },
  [145] = {
    [sym_list_splat_pattern] = STATE(1273),
    [sym_primary_expression] = STATE(997),
    [sym_binary_operator] = STATE(1197),
    [sym_unary_operator] = STATE(1197),
    [sym_attribute] = STATE(1197),
    [sym_subscript] = STATE(1197),
    [sym_call] = STATE(1197),
    [sym_list] = STATE(1197),
    [sym_set] = STATE(1197),
    [sym_tuple] = STATE(1197),
    [sym_dictionary] = STATE(1197),
    [sym_list_comprehension] = STATE(1197),
    [sym_dictionary_comprehension] = STATE(1197),
    [sym_set_comprehension] = STATE(1197),
    [sym_generator_expression] = STATE(1197),
    [sym_parenthesized_expression] = STATE(1197),
    [sym_concatenated_string] = STATE(1197),
    [sym_string] = STATE(907),
    [sym_await] = STATE(1197),
    [sym_identifier] = ACTIONS(606),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(608),
    [anon_sym_RPAREN] = ACTIONS(279),
    [anon_sym_COMMA] = ACTIONS(279),
    [anon_sym_as] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(610),
    [anon_sym_print] = ACTIONS(612),
    [anon_sym_GT_GT] = ACTIONS(272),
    [anon_sym_COLON_EQ] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_match] = ACTIONS(612),
    [anon_sym_async] = ACTIONS(612),
    [anon_sym_for] = ACTIONS(274),
    [anon_sym_in] = ACTIONS(274),
    [anon_sym_STAR_STAR] = ACTIONS(272),
    [anon_sym_exec] = ACTIONS(612),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(614),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(618),
    [anon_sym_DASH] = ACTIONS(618),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(272),
    [anon_sym_SLASH_SLASH] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(272),
    [anon_sym_AMP] = ACTIONS(272),
    [anon_sym_CARET] = ACTIONS(272),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_TILDE] = ACTIONS(618),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_BANG_EQ] = ACTIONS(272),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_LT_GT] = ACTIONS(272),
    [anon_sym_is] = ACTIONS(274),
    [sym_ellipsis] = ACTIONS(620),
    [anon_sym_LBRACE] = ACTIONS(622),
    [sym_integer] = ACTIONS(606),
    [sym_float] = ACTIONS(620),
    [anon_sym_await] = ACTIONS(624),
    [sym_true] = ACTIONS(606),
    [sym_false] = ACTIONS(606),
    [sym_none] = ACTIONS(606),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(626),
  },
  [146] = {
    [sym_list_splat_pattern] = STATE(1212),
    [sym_primary_expression] = STATE(1012),
    [sym_binary_operator] = STATE(1285),
    [sym_unary_operator] = STATE(1285),
    [sym_attribute] = STATE(1285),
    [sym_subscript] = STATE(1285),
    [sym_call] = STATE(1285),
    [sym_list] = STATE(1285),
    [sym_set] = STATE(1285),
    [sym_tuple] = STATE(1285),
    [sym_dictionary] = STATE(1285),
    [sym_list_comprehension] = STATE(1285),
    [sym_dictionary_comprehension] = STATE(1285),
    [sym_set_comprehension] = STATE(1285),
    [sym_generator_expression] = STATE(1285),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_concatenated_string] = STATE(1285),
    [sym_string] = STATE(938),
    [sym_await] = STATE(1285),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(308),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(310),
    [anon_sym_print] = ACTIONS(579),
    [anon_sym_GT_GT] = ACTIONS(272),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_COLON] = ACTIONS(272),
    [anon_sym_else] = ACTIONS(274),
    [anon_sym_match] = ACTIONS(579),
    [anon_sym_async] = ACTIONS(579),
    [anon_sym_in] = ACTIONS(274),
    [anon_sym_STAR_STAR] = ACTIONS(272),
    [anon_sym_exec] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(314),
    [anon_sym_EQ] = ACTIONS(274),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(320),
    [anon_sym_DASH] = ACTIONS(320),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(272),
    [anon_sym_SLASH_SLASH] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(272),
    [anon_sym_AMP] = ACTIONS(272),
    [anon_sym_CARET] = ACTIONS(272),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_TILDE] = ACTIONS(320),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_BANG_EQ] = ACTIONS(272),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_LT_GT] = ACTIONS(272),
    [anon_sym_is] = ACTIONS(274),
    [sym_ellipsis] = ACTIONS(324),
    [anon_sym_LBRACE] = ACTIONS(326),
    [sym_integer] = ACTIONS(328),
    [sym_float] = ACTIONS(324),
    [anon_sym_await] = ACTIONS(581),
    [sym_true] = ACTIONS(328),
    [sym_false] = ACTIONS(328),
    [sym_none] = ACTIONS(328),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(332),
  },
  [147] = {
    [sym_list_splat_pattern] = STATE(1304),
    [sym_primary_expression] = STATE(1092),
    [sym_binary_operator] = STATE(1314),
    [sym_unary_operator] = STATE(1314),
    [sym_attribute] = STATE(1314),
    [sym_subscript] = STATE(1314),
    [sym_call] = STATE(1314),
    [sym_list] = STATE(1314),
    [sym_set] = STATE(1314),
    [sym_tuple] = STATE(1314),
    [sym_dictionary] = STATE(1314),
    [sym_list_comprehension] = STATE(1314),
    [sym_dictionary_comprehension] = STATE(1314),
    [sym_set_comprehension] = STATE(1314),
    [sym_generator_expression] = STATE(1314),
    [sym_parenthesized_expression] = STATE(1314),
    [sym_concatenated_string] = STATE(1314),
    [sym_string] = STATE(1011),
    [sym_await] = STATE(1314),
    [sym_identifier] = ACTIONS(648),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(272),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_print] = ACTIONS(654),
    [anon_sym_GT_GT] = ACTIONS(272),
    [anon_sym_COLON_EQ] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_match] = ACTIONS(654),
    [anon_sym_async] = ACTIONS(654),
    [anon_sym_in] = ACTIONS(274),
    [anon_sym_STAR_STAR] = ACTIONS(272),
    [anon_sym_exec] = ACTIONS(654),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(656),
    [anon_sym_EQ] = ACTIONS(274),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(658),
    [anon_sym_DASH] = ACTIONS(658),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(272),
    [anon_sym_SLASH_SLASH] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(272),
    [anon_sym_AMP] = ACTIONS(272),
    [anon_sym_CARET] = ACTIONS(272),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_TILDE] = ACTIONS(658),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_BANG_EQ] = ACTIONS(272),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_LT_GT] = ACTIONS(272),
    [anon_sym_is] = ACTIONS(274),
    [sym_ellipsis] = ACTIONS(660),
    [anon_sym_LBRACE] = ACTIONS(662),
    [sym_integer] = ACTIONS(648),
    [sym_float] = ACTIONS(660),
    [anon_sym_await] = ACTIONS(664),
    [sym_true] = ACTIONS(648),
    [sym_false] = ACTIONS(648),
    [sym_none] = ACTIONS(648),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(666),
  },
  [148] = {
    [sym_list_splat_pattern] = STATE(1029),
    [sym_primary_expression] = STATE(931),
    [sym_binary_operator] = STATE(1020),
    [sym_unary_operator] = STATE(1020),
    [sym_attribute] = STATE(1020),
    [sym_subscript] = STATE(1020),
    [sym_call] = STATE(1020),
    [sym_list] = STATE(1020),
    [sym_set] = STATE(1020),
    [sym_tuple] = STATE(1020),
    [sym_dictionary] = STATE(1020),
    [sym_list_comprehension] = STATE(1020),
    [sym_dictionary_comprehension] = STATE(1020),
    [sym_set_comprehension] = STATE(1020),
    [sym_generator_expression] = STATE(1020),
    [sym_parenthesized_expression] = STATE(1020),
    [sym_concatenated_string] = STATE(1020),
    [sym_string] = STATE(893),
    [sym_await] = STATE(1020),
    [sym_identifier] = ACTIONS(628),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(630),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(632),
    [anon_sym_print] = ACTIONS(634),
    [anon_sym_GT_GT] = ACTIONS(272),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_COLON] = ACTIONS(272),
    [anon_sym_match] = ACTIONS(634),
    [anon_sym_async] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(274),
    [anon_sym_in] = ACTIONS(274),
    [anon_sym_STAR_STAR] = ACTIONS(272),
    [anon_sym_exec] = ACTIONS(634),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(636),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(638),
    [anon_sym_DASH] = ACTIONS(638),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(272),
    [anon_sym_SLASH_SLASH] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(272),
    [anon_sym_AMP] = ACTIONS(272),
    [anon_sym_CARET] = ACTIONS(272),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_TILDE] = ACTIONS(638),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_BANG_EQ] = ACTIONS(272),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_LT_GT] = ACTIONS(272),
    [anon_sym_is] = ACTIONS(274),
    [sym_ellipsis] = ACTIONS(640),
    [anon_sym_LBRACE] = ACTIONS(642),
    [anon_sym_RBRACE] = ACTIONS(272),
    [sym_integer] = ACTIONS(628),
    [sym_float] = ACTIONS(640),
    [anon_sym_await] = ACTIONS(644),
    [sym_true] = ACTIONS(628),
    [sym_false] = ACTIONS(628),
    [sym_none] = ACTIONS(628),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(646),
  },
  [149] = {
    [sym_list_splat_pattern] = STATE(1304),
    [sym_primary_expression] = STATE(1092),
    [sym_binary_operator] = STATE(1314),
    [sym_unary_operator] = STATE(1314),
    [sym_attribute] = STATE(1314),
    [sym_subscript] = STATE(1314),
    [sym_call] = STATE(1314),
    [sym_list] = STATE(1314),
    [sym_set] = STATE(1314),
    [sym_tuple] = STATE(1314),
    [sym_dictionary] = STATE(1314),
    [sym_list_comprehension] = STATE(1314),
    [sym_dictionary_comprehension] = STATE(1314),
    [sym_set_comprehension] = STATE(1314),
    [sym_generator_expression] = STATE(1314),
    [sym_parenthesized_expression] = STATE(1314),
    [sym_concatenated_string] = STATE(1314),
    [sym_string] = STATE(1011),
    [sym_await] = STATE(1314),
    [sym_identifier] = ACTIONS(648),
    [anon_sym_DOT] = ACTIONS(574),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(583),
    [anon_sym_COMMA] = ACTIONS(583),
    [anon_sym_as] = ACTIONS(574),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_print] = ACTIONS(654),
    [anon_sym_GT_GT] = ACTIONS(583),
    [anon_sym_COLON_EQ] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(574),
    [anon_sym_match] = ACTIONS(654),
    [anon_sym_async] = ACTIONS(654),
    [anon_sym_for] = ACTIONS(577),
    [anon_sym_in] = ACTIONS(574),
    [anon_sym_STAR_STAR] = ACTIONS(583),
    [anon_sym_exec] = ACTIONS(654),
    [anon_sym_AT] = ACTIONS(583),
    [anon_sym_LBRACK] = ACTIONS(656),
    [anon_sym_not] = ACTIONS(574),
    [anon_sym_and] = ACTIONS(574),
    [anon_sym_or] = ACTIONS(574),
    [anon_sym_PLUS] = ACTIONS(658),
    [anon_sym_DASH] = ACTIONS(658),
    [anon_sym_SLASH] = ACTIONS(574),
    [anon_sym_PERCENT] = ACTIONS(583),
    [anon_sym_SLASH_SLASH] = ACTIONS(583),
    [anon_sym_PIPE] = ACTIONS(583),
    [anon_sym_AMP] = ACTIONS(583),
    [anon_sym_CARET] = ACTIONS(583),
    [anon_sym_LT_LT] = ACTIONS(583),
    [anon_sym_TILDE] = ACTIONS(658),
    [anon_sym_LT] = ACTIONS(574),
    [anon_sym_LT_EQ] = ACTIONS(583),
    [anon_sym_EQ_EQ] = ACTIONS(583),
    [anon_sym_BANG_EQ] = ACTIONS(583),
    [anon_sym_GT_EQ] = ACTIONS(583),
    [anon_sym_GT] = ACTIONS(574),
    [anon_sym_LT_GT] = ACTIONS(583),
    [anon_sym_is] = ACTIONS(574),
    [sym_ellipsis] = ACTIONS(660),
    [anon_sym_LBRACE] = ACTIONS(662),
    [sym_integer] = ACTIONS(648),
    [sym_float] = ACTIONS(660),
    [anon_sym_await] = ACTIONS(664),
    [sym_true] = ACTIONS(648),
    [sym_false] = ACTIONS(648),
    [sym_none] = ACTIONS(648),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(666),
  },
  [150] = {
    [sym_list_splat_pattern] = STATE(1327),
    [sym_primary_expression] = STATE(1066),
    [sym_binary_operator] = STATE(1331),
    [sym_unary_operator] = STATE(1331),
    [sym_attribute] = STATE(1331),
    [sym_subscript] = STATE(1331),
    [sym_call] = STATE(1331),
    [sym_list] = STATE(1331),
    [sym_set] = STATE(1331),
    [sym_tuple] = STATE(1331),
    [sym_dictionary] = STATE(1331),
    [sym_list_comprehension] = STATE(1331),
    [sym_dictionary_comprehension] = STATE(1331),
    [sym_set_comprehension] = STATE(1331),
    [sym_generator_expression] = STATE(1331),
    [sym_parenthesized_expression] = STATE(1331),
    [sym_concatenated_string] = STATE(1331),
    [sym_string] = STATE(963),
    [sym_await] = STATE(1331),
    [sym_identifier] = ACTIONS(668),
    [anon_sym_DOT] = ACTIONS(574),
    [anon_sym_LPAREN] = ACTIONS(670),
    [anon_sym_COMMA] = ACTIONS(583),
    [anon_sym_as] = ACTIONS(574),
    [anon_sym_STAR] = ACTIONS(672),
    [anon_sym_print] = ACTIONS(674),
    [anon_sym_GT_GT] = ACTIONS(583),
    [anon_sym_COLON_EQ] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(574),
    [anon_sym_match] = ACTIONS(674),
    [anon_sym_async] = ACTIONS(674),
    [anon_sym_for] = ACTIONS(577),
    [anon_sym_in] = ACTIONS(574),
    [anon_sym_STAR_STAR] = ACTIONS(583),
    [anon_sym_exec] = ACTIONS(674),
    [anon_sym_AT] = ACTIONS(583),
    [anon_sym_LBRACK] = ACTIONS(676),
    [anon_sym_RBRACK] = ACTIONS(583),
    [anon_sym_not] = ACTIONS(574),
    [anon_sym_and] = ACTIONS(574),
    [anon_sym_or] = ACTIONS(574),
    [anon_sym_PLUS] = ACTIONS(678),
    [anon_sym_DASH] = ACTIONS(678),
    [anon_sym_SLASH] = ACTIONS(574),
    [anon_sym_PERCENT] = ACTIONS(583),
    [anon_sym_SLASH_SLASH] = ACTIONS(583),
    [anon_sym_PIPE] = ACTIONS(583),
    [anon_sym_AMP] = ACTIONS(583),
    [anon_sym_CARET] = ACTIONS(583),
    [anon_sym_LT_LT] = ACTIONS(583),
    [anon_sym_TILDE] = ACTIONS(678),
    [anon_sym_LT] = ACTIONS(574),
    [anon_sym_LT_EQ] = ACTIONS(583),
    [anon_sym_EQ_EQ] = ACTIONS(583),
    [anon_sym_BANG_EQ] = ACTIONS(583),
    [anon_sym_GT_EQ] = ACTIONS(583),
    [anon_sym_GT] = ACTIONS(574),
    [anon_sym_LT_GT] = ACTIONS(583),
    [anon_sym_is] = ACTIONS(574),
    [sym_ellipsis] = ACTIONS(680),
    [anon_sym_LBRACE] = ACTIONS(682),
    [sym_integer] = ACTIONS(668),
    [sym_float] = ACTIONS(680),
    [anon_sym_await] = ACTIONS(684),
    [sym_true] = ACTIONS(668),
    [sym_false] = ACTIONS(668),
    [sym_none] = ACTIONS(668),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(686),
  },
  [151] = {
    [sym_list_splat_pattern] = STATE(1212),
    [sym_primary_expression] = STATE(1012),
    [sym_binary_operator] = STATE(1285),
    [sym_unary_operator] = STATE(1285),
    [sym_attribute] = STATE(1285),
    [sym_subscript] = STATE(1285),
    [sym_call] = STATE(1285),
    [sym_list] = STATE(1285),
    [sym_set] = STATE(1285),
    [sym_tuple] = STATE(1285),
    [sym_dictionary] = STATE(1285),
    [sym_list_comprehension] = STATE(1285),
    [sym_dictionary_comprehension] = STATE(1285),
    [sym_set_comprehension] = STATE(1285),
    [sym_generator_expression] = STATE(1285),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_concatenated_string] = STATE(1285),
    [sym_string] = STATE(938),
    [sym_await] = STATE(1285),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_DOT] = ACTIONS(574),
    [anon_sym_LPAREN] = ACTIONS(308),
    [anon_sym_RPAREN] = ACTIONS(572),
    [anon_sym_COMMA] = ACTIONS(572),
    [anon_sym_as] = ACTIONS(577),
    [anon_sym_STAR] = ACTIONS(310),
    [anon_sym_print] = ACTIONS(579),
    [anon_sym_GT_GT] = ACTIONS(583),
    [anon_sym_if] = ACTIONS(577),
    [anon_sym_match] = ACTIONS(579),
    [anon_sym_async] = ACTIONS(579),
    [anon_sym_for] = ACTIONS(577),
    [anon_sym_in] = ACTIONS(577),
    [anon_sym_STAR_STAR] = ACTIONS(583),
    [anon_sym_exec] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(583),
    [anon_sym_LBRACK] = ACTIONS(314),
    [anon_sym_EQ] = ACTIONS(577),
    [anon_sym_not] = ACTIONS(577),
    [anon_sym_and] = ACTIONS(577),
    [anon_sym_or] = ACTIONS(577),
    [anon_sym_PLUS] = ACTIONS(320),
    [anon_sym_DASH] = ACTIONS(320),
    [anon_sym_SLASH] = ACTIONS(574),
    [anon_sym_PERCENT] = ACTIONS(583),
    [anon_sym_SLASH_SLASH] = ACTIONS(583),
    [anon_sym_PIPE] = ACTIONS(583),
    [anon_sym_AMP] = ACTIONS(583),
    [anon_sym_CARET] = ACTIONS(583),
    [anon_sym_LT_LT] = ACTIONS(583),
    [anon_sym_TILDE] = ACTIONS(320),
    [anon_sym_LT] = ACTIONS(577),
    [anon_sym_LT_EQ] = ACTIONS(572),
    [anon_sym_EQ_EQ] = ACTIONS(572),
    [anon_sym_BANG_EQ] = ACTIONS(572),
    [anon_sym_GT_EQ] = ACTIONS(572),
    [anon_sym_GT] = ACTIONS(577),
    [anon_sym_LT_GT] = ACTIONS(572),
    [anon_sym_is] = ACTIONS(577),
    [sym_ellipsis] = ACTIONS(324),
    [anon_sym_LBRACE] = ACTIONS(326),
    [sym_integer] = ACTIONS(328),
    [sym_float] = ACTIONS(324),
    [anon_sym_await] = ACTIONS(581),
    [sym_true] = ACTIONS(328),
    [sym_false] = ACTIONS(328),
    [sym_none] = ACTIONS(328),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(332),
  },
  [152] = {
    [sym_list_splat_pattern] = STATE(1224),
    [sym_primary_expression] = STATE(1005),
    [sym_binary_operator] = STATE(1252),
    [sym_unary_operator] = STATE(1252),
    [sym_attribute] = STATE(1252),
    [sym_subscript] = STATE(1252),
    [sym_call] = STATE(1252),
    [sym_list] = STATE(1252),
    [sym_set] = STATE(1252),
    [sym_tuple] = STATE(1252),
    [sym_dictionary] = STATE(1252),
    [sym_list_comprehension] = STATE(1252),
    [sym_dictionary_comprehension] = STATE(1252),
    [sym_set_comprehension] = STATE(1252),
    [sym_generator_expression] = STATE(1252),
    [sym_parenthesized_expression] = STATE(1252),
    [sym_concatenated_string] = STATE(1252),
    [sym_string] = STATE(905),
    [sym_await] = STATE(1252),
    [sym_identifier] = ACTIONS(688),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(690),
    [anon_sym_COMMA] = ACTIONS(279),
    [anon_sym_as] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(692),
    [anon_sym_print] = ACTIONS(694),
    [anon_sym_GT_GT] = ACTIONS(272),
    [anon_sym_COLON_EQ] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_match] = ACTIONS(694),
    [anon_sym_async] = ACTIONS(694),
    [anon_sym_for] = ACTIONS(274),
    [anon_sym_in] = ACTIONS(274),
    [anon_sym_STAR_STAR] = ACTIONS(272),
    [anon_sym_exec] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(696),
    [anon_sym_RBRACK] = ACTIONS(279),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(698),
    [anon_sym_DASH] = ACTIONS(698),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(272),
    [anon_sym_SLASH_SLASH] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(272),
    [anon_sym_AMP] = ACTIONS(272),
    [anon_sym_CARET] = ACTIONS(272),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_TILDE] = ACTIONS(698),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_BANG_EQ] = ACTIONS(272),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_LT_GT] = ACTIONS(272),
    [anon_sym_is] = ACTIONS(274),
    [sym_ellipsis] = ACTIONS(700),
    [anon_sym_LBRACE] = ACTIONS(702),
    [sym_integer] = ACTIONS(688),
    [sym_float] = ACTIONS(700),
    [anon_sym_await] = ACTIONS(704),
    [sym_true] = ACTIONS(688),
    [sym_false] = ACTIONS(688),
    [sym_none] = ACTIONS(688),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(706),
  },
  [153] = {
    [sym_list_splat_pattern] = STATE(1224),
    [sym_primary_expression] = STATE(1005),
    [sym_binary_operator] = STATE(1252),
    [sym_unary_operator] = STATE(1252),
    [sym_attribute] = STATE(1252),
    [sym_subscript] = STATE(1252),
    [sym_call] = STATE(1252),
    [sym_list] = STATE(1252),
    [sym_set] = STATE(1252),
    [sym_tuple] = STATE(1252),
    [sym_dictionary] = STATE(1252),
    [sym_list_comprehension] = STATE(1252),
    [sym_dictionary_comprehension] = STATE(1252),
    [sym_set_comprehension] = STATE(1252),
    [sym_generator_expression] = STATE(1252),
    [sym_parenthesized_expression] = STATE(1252),
    [sym_concatenated_string] = STATE(1252),
    [sym_string] = STATE(905),
    [sym_await] = STATE(1252),
    [sym_identifier] = ACTIONS(688),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(690),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(692),
    [anon_sym_print] = ACTIONS(694),
    [anon_sym_GT_GT] = ACTIONS(272),
    [anon_sym_COLON_EQ] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_match] = ACTIONS(694),
    [anon_sym_async] = ACTIONS(694),
    [anon_sym_for] = ACTIONS(274),
    [anon_sym_in] = ACTIONS(274),
    [anon_sym_STAR_STAR] = ACTIONS(272),
    [anon_sym_exec] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(696),
    [anon_sym_RBRACK] = ACTIONS(272),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(698),
    [anon_sym_DASH] = ACTIONS(698),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(272),
    [anon_sym_SLASH_SLASH] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(272),
    [anon_sym_AMP] = ACTIONS(272),
    [anon_sym_CARET] = ACTIONS(272),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_TILDE] = ACTIONS(698),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_BANG_EQ] = ACTIONS(272),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_LT_GT] = ACTIONS(272),
    [anon_sym_is] = ACTIONS(274),
    [sym_ellipsis] = ACTIONS(700),
    [anon_sym_LBRACE] = ACTIONS(702),
    [sym_integer] = ACTIONS(688),
    [sym_float] = ACTIONS(700),
    [anon_sym_await] = ACTIONS(704),
    [sym_true] = ACTIONS(688),
    [sym_false] = ACTIONS(688),
    [sym_none] = ACTIONS(688),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(706),
  },
  [154] = {
    [sym_list_splat_pattern] = STATE(1304),
    [sym_primary_expression] = STATE(1092),
    [sym_binary_operator] = STATE(1314),
    [sym_unary_operator] = STATE(1314),
    [sym_attribute] = STATE(1314),
    [sym_subscript] = STATE(1314),
    [sym_call] = STATE(1314),
    [sym_list] = STATE(1314),
    [sym_set] = STATE(1314),
    [sym_tuple] = STATE(1314),
    [sym_dictionary] = STATE(1314),
    [sym_list_comprehension] = STATE(1314),
    [sym_dictionary_comprehension] = STATE(1314),
    [sym_set_comprehension] = STATE(1314),
    [sym_generator_expression] = STATE(1314),
    [sym_parenthesized_expression] = STATE(1314),
    [sym_concatenated_string] = STATE(1314),
    [sym_string] = STATE(1011),
    [sym_await] = STATE(1314),
    [sym_identifier] = ACTIONS(648),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(272),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_print] = ACTIONS(654),
    [anon_sym_GT_GT] = ACTIONS(272),
    [anon_sym_COLON_EQ] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_match] = ACTIONS(654),
    [anon_sym_async] = ACTIONS(654),
    [anon_sym_in] = ACTIONS(274),
    [anon_sym_STAR_STAR] = ACTIONS(272),
    [anon_sym_exec] = ACTIONS(654),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(656),
    [anon_sym_EQ] = ACTIONS(616),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(658),
    [anon_sym_DASH] = ACTIONS(658),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(272),
    [anon_sym_SLASH_SLASH] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(272),
    [anon_sym_AMP] = ACTIONS(272),
    [anon_sym_CARET] = ACTIONS(272),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_TILDE] = ACTIONS(658),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_BANG_EQ] = ACTIONS(272),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_LT_GT] = ACTIONS(272),
    [anon_sym_is] = ACTIONS(274),
    [sym_ellipsis] = ACTIONS(660),
    [anon_sym_LBRACE] = ACTIONS(662),
    [sym_integer] = ACTIONS(648),
    [sym_float] = ACTIONS(660),
    [anon_sym_await] = ACTIONS(664),
    [sym_true] = ACTIONS(648),
    [sym_false] = ACTIONS(648),
    [sym_none] = ACTIONS(648),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(666),
  },
  [155] = {
    [sym_list_splat_pattern] = STATE(1212),
    [sym_primary_expression] = STATE(1012),
    [sym_binary_operator] = STATE(1285),
    [sym_unary_operator] = STATE(1285),
    [sym_attribute] = STATE(1285),
    [sym_subscript] = STATE(1285),
    [sym_call] = STATE(1285),
    [sym_list] = STATE(1285),
    [sym_set] = STATE(1285),
    [sym_tuple] = STATE(1285),
    [sym_dictionary] = STATE(1285),
    [sym_list_comprehension] = STATE(1285),
    [sym_dictionary_comprehension] = STATE(1285),
    [sym_set_comprehension] = STATE(1285),
    [sym_generator_expression] = STATE(1285),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_concatenated_string] = STATE(1285),
    [sym_string] = STATE(938),
    [sym_await] = STATE(1285),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_SEMI] = ACTIONS(302),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(308),
    [anon_sym_COMMA] = ACTIONS(302),
    [anon_sym_STAR] = ACTIONS(310),
    [anon_sym_print] = ACTIONS(579),
    [anon_sym_GT_GT] = ACTIONS(274),
    [anon_sym_COLON] = ACTIONS(302),
    [anon_sym_match] = ACTIONS(579),
    [anon_sym_async] = ACTIONS(579),
    [anon_sym_STAR_STAR] = ACTIONS(274),
    [anon_sym_exec] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(274),
    [anon_sym_LBRACK] = ACTIONS(314),
    [anon_sym_EQ] = ACTIONS(302),
    [anon_sym_PLUS] = ACTIONS(318),
    [anon_sym_DASH] = ACTIONS(318),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(274),
    [anon_sym_SLASH_SLASH] = ACTIONS(274),
    [anon_sym_PIPE] = ACTIONS(274),
    [anon_sym_AMP] = ACTIONS(274),
    [anon_sym_CARET] = ACTIONS(274),
    [anon_sym_LT_LT] = ACTIONS(274),
    [anon_sym_TILDE] = ACTIONS(320),
    [anon_sym_PLUS_EQ] = ACTIONS(302),
    [anon_sym_DASH_EQ] = ACTIONS(302),
    [anon_sym_STAR_EQ] = ACTIONS(302),
    [anon_sym_SLASH_EQ] = ACTIONS(302),
    [anon_sym_AT_EQ] = ACTIONS(302),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(302),
    [anon_sym_PERCENT_EQ] = ACTIONS(302),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(302),
    [anon_sym_GT_GT_EQ] = ACTIONS(302),
    [anon_sym_LT_LT_EQ] = ACTIONS(302),
    [anon_sym_AMP_EQ] = ACTIONS(302),
    [anon_sym_CARET_EQ] = ACTIONS(302),
    [anon_sym_PIPE_EQ] = ACTIONS(302),
    [sym_ellipsis] = ACTIONS(324),
    [anon_sym_LBRACE] = ACTIONS(326),
    [sym_integer] = ACTIONS(328),
    [sym_float] = ACTIONS(324),
    [anon_sym_await] = ACTIONS(581),
    [sym_true] = ACTIONS(328),
    [sym_false] = ACTIONS(328),
    [sym_none] = ACTIONS(328),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(302),
    [sym_string_start] = ACTIONS(332),
  },
  [156] = {
    [sym_list_splat_pattern] = STATE(1212),
    [sym_primary_expression] = STATE(1012),
    [sym_binary_operator] = STATE(1285),
    [sym_unary_operator] = STATE(1285),
    [sym_attribute] = STATE(1285),
    [sym_subscript] = STATE(1285),
    [sym_call] = STATE(1285),
    [sym_list] = STATE(1285),
    [sym_set] = STATE(1285),
    [sym_tuple] = STATE(1285),
    [sym_dictionary] = STATE(1285),
    [sym_list_comprehension] = STATE(1285),
    [sym_dictionary_comprehension] = STATE(1285),
    [sym_set_comprehension] = STATE(1285),
    [sym_generator_expression] = STATE(1285),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_concatenated_string] = STATE(1285),
    [sym_string] = STATE(938),
    [sym_await] = STATE(1285),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_DOT] = ACTIONS(574),
    [anon_sym_LPAREN] = ACTIONS(308),
    [anon_sym_COMMA] = ACTIONS(572),
    [anon_sym_as] = ACTIONS(577),
    [anon_sym_STAR] = ACTIONS(310),
    [anon_sym_print] = ACTIONS(579),
    [anon_sym_GT_GT] = ACTIONS(583),
    [anon_sym_if] = ACTIONS(577),
    [anon_sym_COLON] = ACTIONS(572),
    [anon_sym_match] = ACTIONS(579),
    [anon_sym_async] = ACTIONS(579),
    [anon_sym_for] = ACTIONS(577),
    [anon_sym_in] = ACTIONS(577),
    [anon_sym_STAR_STAR] = ACTIONS(583),
    [anon_sym_exec] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(583),
    [anon_sym_LBRACK] = ACTIONS(314),
    [anon_sym_RBRACK] = ACTIONS(572),
    [anon_sym_not] = ACTIONS(577),
    [anon_sym_and] = ACTIONS(577),
    [anon_sym_or] = ACTIONS(577),
    [anon_sym_PLUS] = ACTIONS(320),
    [anon_sym_DASH] = ACTIONS(320),
    [anon_sym_SLASH] = ACTIONS(574),
    [anon_sym_PERCENT] = ACTIONS(583),
    [anon_sym_SLASH_SLASH] = ACTIONS(583),
    [anon_sym_PIPE] = ACTIONS(583),
    [anon_sym_AMP] = ACTIONS(583),
    [anon_sym_CARET] = ACTIONS(583),
    [anon_sym_LT_LT] = ACTIONS(583),
    [anon_sym_TILDE] = ACTIONS(320),
    [anon_sym_LT] = ACTIONS(577),
    [anon_sym_LT_EQ] = ACTIONS(572),
    [anon_sym_EQ_EQ] = ACTIONS(572),
    [anon_sym_BANG_EQ] = ACTIONS(572),
    [anon_sym_GT_EQ] = ACTIONS(572),
    [anon_sym_GT] = ACTIONS(577),
    [anon_sym_LT_GT] = ACTIONS(572),
    [anon_sym_is] = ACTIONS(577),
    [sym_ellipsis] = ACTIONS(324),
    [anon_sym_LBRACE] = ACTIONS(326),
    [sym_integer] = ACTIONS(328),
    [sym_float] = ACTIONS(324),
    [anon_sym_await] = ACTIONS(581),
    [sym_true] = ACTIONS(328),
    [sym_false] = ACTIONS(328),
    [sym_none] = ACTIONS(328),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(332),
  },
  [157] = {
    [sym_list_splat_pattern] = STATE(1273),
    [sym_primary_expression] = STATE(997),
    [sym_binary_operator] = STATE(1197),
    [sym_unary_operator] = STATE(1197),
    [sym_attribute] = STATE(1197),
    [sym_subscript] = STATE(1197),
    [sym_call] = STATE(1197),
    [sym_list] = STATE(1197),
    [sym_set] = STATE(1197),
    [sym_tuple] = STATE(1197),
    [sym_dictionary] = STATE(1197),
    [sym_list_comprehension] = STATE(1197),
    [sym_dictionary_comprehension] = STATE(1197),
    [sym_set_comprehension] = STATE(1197),
    [sym_generator_expression] = STATE(1197),
    [sym_parenthesized_expression] = STATE(1197),
    [sym_concatenated_string] = STATE(1197),
    [sym_string] = STATE(907),
    [sym_await] = STATE(1197),
    [sym_identifier] = ACTIONS(606),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(608),
    [anon_sym_RPAREN] = ACTIONS(272),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(610),
    [anon_sym_print] = ACTIONS(612),
    [anon_sym_GT_GT] = ACTIONS(272),
    [anon_sym_COLON_EQ] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_match] = ACTIONS(612),
    [anon_sym_async] = ACTIONS(612),
    [anon_sym_for] = ACTIONS(274),
    [anon_sym_in] = ACTIONS(274),
    [anon_sym_STAR_STAR] = ACTIONS(272),
    [anon_sym_exec] = ACTIONS(612),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(614),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(618),
    [anon_sym_DASH] = ACTIONS(618),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(272),
    [anon_sym_SLASH_SLASH] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(272),
    [anon_sym_AMP] = ACTIONS(272),
    [anon_sym_CARET] = ACTIONS(272),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_TILDE] = ACTIONS(618),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_BANG_EQ] = ACTIONS(272),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_LT_GT] = ACTIONS(272),
    [anon_sym_is] = ACTIONS(274),
    [sym_ellipsis] = ACTIONS(620),
    [anon_sym_LBRACE] = ACTIONS(622),
    [sym_integer] = ACTIONS(606),
    [sym_float] = ACTIONS(620),
    [anon_sym_await] = ACTIONS(624),
    [sym_true] = ACTIONS(606),
    [sym_false] = ACTIONS(606),
    [sym_none] = ACTIONS(606),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(626),
  },
  [158] = {
    [sym_list_splat_pattern] = STATE(1327),
    [sym_primary_expression] = STATE(1066),
    [sym_binary_operator] = STATE(1331),
    [sym_unary_operator] = STATE(1331),
    [sym_attribute] = STATE(1331),
    [sym_subscript] = STATE(1331),
    [sym_call] = STATE(1331),
    [sym_list] = STATE(1331),
    [sym_set] = STATE(1331),
    [sym_tuple] = STATE(1331),
    [sym_dictionary] = STATE(1331),
    [sym_list_comprehension] = STATE(1331),
    [sym_dictionary_comprehension] = STATE(1331),
    [sym_set_comprehension] = STATE(1331),
    [sym_generator_expression] = STATE(1331),
    [sym_parenthesized_expression] = STATE(1331),
    [sym_concatenated_string] = STATE(1331),
    [sym_string] = STATE(963),
    [sym_await] = STATE(1331),
    [sym_identifier] = ACTIONS(668),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(670),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(672),
    [anon_sym_print] = ACTIONS(674),
    [anon_sym_GT_GT] = ACTIONS(272),
    [anon_sym_COLON_EQ] = ACTIONS(289),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_COLON] = ACTIONS(274),
    [anon_sym_match] = ACTIONS(674),
    [anon_sym_async] = ACTIONS(674),
    [anon_sym_in] = ACTIONS(274),
    [anon_sym_STAR_STAR] = ACTIONS(272),
    [anon_sym_exec] = ACTIONS(674),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(676),
    [anon_sym_RBRACK] = ACTIONS(272),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(678),
    [anon_sym_DASH] = ACTIONS(678),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(272),
    [anon_sym_SLASH_SLASH] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(272),
    [anon_sym_AMP] = ACTIONS(272),
    [anon_sym_CARET] = ACTIONS(272),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_TILDE] = ACTIONS(678),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_BANG_EQ] = ACTIONS(272),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_LT_GT] = ACTIONS(272),
    [anon_sym_is] = ACTIONS(274),
    [sym_ellipsis] = ACTIONS(680),
    [anon_sym_LBRACE] = ACTIONS(682),
    [sym_integer] = ACTIONS(668),
    [sym_float] = ACTIONS(680),
    [anon_sym_await] = ACTIONS(684),
    [sym_true] = ACTIONS(668),
    [sym_false] = ACTIONS(668),
    [sym_none] = ACTIONS(668),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(686),
  },
  [159] = {
    [sym_list_splat_pattern] = STATE(1273),
    [sym_primary_expression] = STATE(997),
    [sym_binary_operator] = STATE(1197),
    [sym_unary_operator] = STATE(1197),
    [sym_attribute] = STATE(1197),
    [sym_subscript] = STATE(1197),
    [sym_call] = STATE(1197),
    [sym_list] = STATE(1197),
    [sym_set] = STATE(1197),
    [sym_tuple] = STATE(1197),
    [sym_dictionary] = STATE(1197),
    [sym_list_comprehension] = STATE(1197),
    [sym_dictionary_comprehension] = STATE(1197),
    [sym_set_comprehension] = STATE(1197),
    [sym_generator_expression] = STATE(1197),
    [sym_parenthesized_expression] = STATE(1197),
    [sym_concatenated_string] = STATE(1197),
    [sym_string] = STATE(907),
    [sym_await] = STATE(1197),
    [sym_identifier] = ACTIONS(606),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(608),
    [anon_sym_RPAREN] = ACTIONS(272),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(610),
    [anon_sym_print] = ACTIONS(612),
    [anon_sym_GT_GT] = ACTIONS(272),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_match] = ACTIONS(612),
    [anon_sym_async] = ACTIONS(612),
    [anon_sym_for] = ACTIONS(274),
    [anon_sym_in] = ACTIONS(274),
    [anon_sym_STAR_STAR] = ACTIONS(272),
    [anon_sym_exec] = ACTIONS(612),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(614),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(618),
    [anon_sym_DASH] = ACTIONS(618),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(272),
    [anon_sym_SLASH_SLASH] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(272),
    [anon_sym_AMP] = ACTIONS(272),
    [anon_sym_CARET] = ACTIONS(272),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_TILDE] = ACTIONS(618),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_BANG_EQ] = ACTIONS(272),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_LT_GT] = ACTIONS(272),
    [anon_sym_is] = ACTIONS(274),
    [sym_ellipsis] = ACTIONS(620),
    [anon_sym_LBRACE] = ACTIONS(622),
    [sym_integer] = ACTIONS(606),
    [sym_float] = ACTIONS(620),
    [anon_sym_await] = ACTIONS(624),
    [sym_true] = ACTIONS(606),
    [sym_false] = ACTIONS(606),
    [sym_none] = ACTIONS(606),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(626),
  },
  [160] = {
    [sym_list_splat_pattern] = STATE(1327),
    [sym_primary_expression] = STATE(1066),
    [sym_binary_operator] = STATE(1331),
    [sym_unary_operator] = STATE(1331),
    [sym_attribute] = STATE(1331),
    [sym_subscript] = STATE(1331),
    [sym_call] = STATE(1331),
    [sym_list] = STATE(1331),
    [sym_set] = STATE(1331),
    [sym_tuple] = STATE(1331),
    [sym_dictionary] = STATE(1331),
    [sym_list_comprehension] = STATE(1331),
    [sym_dictionary_comprehension] = STATE(1331),
    [sym_set_comprehension] = STATE(1331),
    [sym_generator_expression] = STATE(1331),
    [sym_parenthesized_expression] = STATE(1331),
    [sym_concatenated_string] = STATE(1331),
    [sym_string] = STATE(963),
    [sym_await] = STATE(1331),
    [sym_identifier] = ACTIONS(668),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(670),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(672),
    [anon_sym_print] = ACTIONS(674),
    [anon_sym_GT_GT] = ACTIONS(272),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_COLON] = ACTIONS(272),
    [anon_sym_match] = ACTIONS(674),
    [anon_sym_async] = ACTIONS(674),
    [anon_sym_in] = ACTIONS(274),
    [anon_sym_STAR_STAR] = ACTIONS(272),
    [anon_sym_exec] = ACTIONS(674),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(676),
    [anon_sym_RBRACK] = ACTIONS(272),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(678),
    [anon_sym_DASH] = ACTIONS(678),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(272),
    [anon_sym_SLASH_SLASH] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(272),
    [anon_sym_AMP] = ACTIONS(272),
    [anon_sym_CARET] = ACTIONS(272),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_TILDE] = ACTIONS(678),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_BANG_EQ] = ACTIONS(272),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_LT_GT] = ACTIONS(272),
    [anon_sym_is] = ACTIONS(274),
    [sym_ellipsis] = ACTIONS(680),
    [anon_sym_LBRACE] = ACTIONS(682),
    [sym_integer] = ACTIONS(668),
    [sym_float] = ACTIONS(680),
    [anon_sym_await] = ACTIONS(684),
    [sym_true] = ACTIONS(668),
    [sym_false] = ACTIONS(668),
    [sym_none] = ACTIONS(668),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(686),
  },
  [161] = {
    [sym_list_splat_pattern] = STATE(1304),
    [sym_primary_expression] = STATE(1092),
    [sym_binary_operator] = STATE(1314),
    [sym_unary_operator] = STATE(1314),
    [sym_attribute] = STATE(1314),
    [sym_subscript] = STATE(1314),
    [sym_call] = STATE(1314),
    [sym_list] = STATE(1314),
    [sym_set] = STATE(1314),
    [sym_tuple] = STATE(1314),
    [sym_dictionary] = STATE(1314),
    [sym_list_comprehension] = STATE(1314),
    [sym_dictionary_comprehension] = STATE(1314),
    [sym_set_comprehension] = STATE(1314),
    [sym_generator_expression] = STATE(1314),
    [sym_parenthesized_expression] = STATE(1314),
    [sym_concatenated_string] = STATE(1314),
    [sym_string] = STATE(1011),
    [sym_await] = STATE(1314),
    [sym_identifier] = ACTIONS(648),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(272),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(652),
    [anon_sym_print] = ACTIONS(654),
    [anon_sym_GT_GT] = ACTIONS(272),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_match] = ACTIONS(654),
    [anon_sym_async] = ACTIONS(654),
    [anon_sym_in] = ACTIONS(274),
    [anon_sym_STAR_STAR] = ACTIONS(272),
    [anon_sym_exec] = ACTIONS(654),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(656),
    [anon_sym_EQ] = ACTIONS(274),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(658),
    [anon_sym_DASH] = ACTIONS(658),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(272),
    [anon_sym_SLASH_SLASH] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(272),
    [anon_sym_AMP] = ACTIONS(272),
    [anon_sym_CARET] = ACTIONS(272),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_TILDE] = ACTIONS(658),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_BANG_EQ] = ACTIONS(272),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_LT_GT] = ACTIONS(272),
    [anon_sym_is] = ACTIONS(274),
    [sym_ellipsis] = ACTIONS(660),
    [anon_sym_LBRACE] = ACTIONS(662),
    [sym_integer] = ACTIONS(648),
    [sym_float] = ACTIONS(660),
    [anon_sym_await] = ACTIONS(664),
    [sym_true] = ACTIONS(648),
    [sym_false] = ACTIONS(648),
    [sym_none] = ACTIONS(648),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(666),
  },
  [162] = {
    [sym_list_splat_pattern] = STATE(1224),
    [sym_primary_expression] = STATE(1005),
    [sym_binary_operator] = STATE(1252),
    [sym_unary_operator] = STATE(1252),
    [sym_attribute] = STATE(1252),
    [sym_subscript] = STATE(1252),
    [sym_call] = STATE(1252),
    [sym_list] = STATE(1252),
    [sym_set] = STATE(1252),
    [sym_tuple] = STATE(1252),
    [sym_dictionary] = STATE(1252),
    [sym_list_comprehension] = STATE(1252),
    [sym_dictionary_comprehension] = STATE(1252),
    [sym_set_comprehension] = STATE(1252),
    [sym_generator_expression] = STATE(1252),
    [sym_parenthesized_expression] = STATE(1252),
    [sym_concatenated_string] = STATE(1252),
    [sym_string] = STATE(905),
    [sym_await] = STATE(1252),
    [sym_identifier] = ACTIONS(688),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(690),
    [anon_sym_COMMA] = ACTIONS(272),
    [anon_sym_as] = ACTIONS(274),
    [anon_sym_STAR] = ACTIONS(692),
    [anon_sym_print] = ACTIONS(694),
    [anon_sym_GT_GT] = ACTIONS(272),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_match] = ACTIONS(694),
    [anon_sym_async] = ACTIONS(694),
    [anon_sym_for] = ACTIONS(274),
    [anon_sym_in] = ACTIONS(274),
    [anon_sym_STAR_STAR] = ACTIONS(272),
    [anon_sym_exec] = ACTIONS(694),
    [anon_sym_AT] = ACTIONS(272),
    [anon_sym_LBRACK] = ACTIONS(696),
    [anon_sym_RBRACK] = ACTIONS(272),
    [anon_sym_not] = ACTIONS(274),
    [anon_sym_and] = ACTIONS(274),
    [anon_sym_or] = ACTIONS(274),
    [anon_sym_PLUS] = ACTIONS(698),
    [anon_sym_DASH] = ACTIONS(698),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(272),
    [anon_sym_SLASH_SLASH] = ACTIONS(272),
    [anon_sym_PIPE] = ACTIONS(272),
    [anon_sym_AMP] = ACTIONS(272),
    [anon_sym_CARET] = ACTIONS(272),
    [anon_sym_LT_LT] = ACTIONS(272),
    [anon_sym_TILDE] = ACTIONS(698),
    [anon_sym_LT] = ACTIONS(274),
    [anon_sym_LT_EQ] = ACTIONS(272),
    [anon_sym_EQ_EQ] = ACTIONS(272),
    [anon_sym_BANG_EQ] = ACTIONS(272),
    [anon_sym_GT_EQ] = ACTIONS(272),
    [anon_sym_GT] = ACTIONS(274),
    [anon_sym_LT_GT] = ACTIONS(272),
    [anon_sym_is] = ACTIONS(274),
    [sym_ellipsis] = ACTIONS(700),
    [anon_sym_LBRACE] = ACTIONS(702),
    [sym_integer] = ACTIONS(688),
    [sym_float] = ACTIONS(700),
    [anon_sym_await] = ACTIONS(704),
    [sym_true] = ACTIONS(688),
    [sym_false] = ACTIONS(688),
    [sym_none] = ACTIONS(688),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(706),
  },
  [163] = {
    [sym_list_splat_pattern] = STATE(1212),
    [sym_primary_expression] = STATE(1012),
    [sym_binary_operator] = STATE(1285),
    [sym_unary_operator] = STATE(1285),
    [sym_attribute] = STATE(1285),
    [sym_subscript] = STATE(1285),
    [sym_call] = STATE(1285),
    [sym_list] = STATE(1285),
    [sym_set] = STATE(1285),
    [sym_tuple] = STATE(1285),
    [sym_dictionary] = STATE(1285),
    [sym_list_comprehension] = STATE(1285),
    [sym_dictionary_comprehension] = STATE(1285),
    [sym_set_comprehension] = STATE(1285),
    [sym_generator_expression] = STATE(1285),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_concatenated_string] = STATE(1285),
    [sym_string] = STATE(938),
    [sym_await] = STATE(1285),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_DOT] = ACTIONS(274),
    [anon_sym_LPAREN] = ACTIONS(308),
    [anon_sym_COMMA] = ACTIONS(302),
    [anon_sym_STAR] = ACTIONS(310),
    [anon_sym_print] = ACTIONS(579),
    [anon_sym_GT_GT] = ACTIONS(274),
    [anon_sym_COLON] = ACTIONS(302),
    [anon_sym_match] = ACTIONS(579),
    [anon_sym_async] = ACTIONS(579),
    [anon_sym_STAR_STAR] = ACTIONS(274),
    [anon_sym_exec] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(274),
    [anon_sym_LBRACK] = ACTIONS(314),
    [anon_sym_EQ] = ACTIONS(302),
    [anon_sym_PLUS] = ACTIONS(318),
    [anon_sym_DASH] = ACTIONS(318),
    [anon_sym_SLASH] = ACTIONS(274),
    [anon_sym_PERCENT] = ACTIONS(274),
    [anon_sym_SLASH_SLASH] = ACTIONS(274),
    [anon_sym_PIPE] = ACTIONS(274),
    [anon_sym_AMP] = ACTIONS(274),
    [anon_sym_CARET] = ACTIONS(274),
    [anon_sym_LT_LT] = ACTIONS(274),
    [anon_sym_TILDE] = ACTIONS(320),
    [anon_sym_PLUS_EQ] = ACTIONS(302),
    [anon_sym_DASH_EQ] = ACTIONS(302),
    [anon_sym_STAR_EQ] = ACTIONS(302),
    [anon_sym_SLASH_EQ] = ACTIONS(302),
    [anon_sym_AT_EQ] = ACTIONS(302),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(302),
    [anon_sym_PERCENT_EQ] = ACTIONS(302),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(302),
    [anon_sym_GT_GT_EQ] = ACTIONS(302),
    [anon_sym_LT_LT_EQ] = ACTIONS(302),
    [anon_sym_AMP_EQ] = ACTIONS(302),
    [anon_sym_CARET_EQ] = ACTIONS(302),
    [anon_sym_PIPE_EQ] = ACTIONS(302),
    [sym_ellipsis] = ACTIONS(324),
    [anon_sym_LBRACE] = ACTIONS(326),
    [sym_integer] = ACTIONS(328),
    [sym_float] = ACTIONS(324),
    [anon_sym_await] = ACTIONS(581),
    [sym_true] = ACTIONS(328),
    [sym_false] = ACTIONS(328),
    [sym_none] = ACTIONS(328),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(332),
  },
  [164] = {
    [sym_list_splat_pattern] = STATE(1212),
    [sym_primary_expression] = STATE(1012),
    [sym_binary_operator] = STATE(1285),
    [sym_unary_operator] = STATE(1285),
    [sym_attribute] = STATE(1285),
    [sym_subscript] = STATE(1285),
    [sym_call] = STATE(1285),
    [sym_list] = STATE(1285),
    [sym_set] = STATE(1285),
    [sym_tuple] = STATE(1285),
    [sym_dictionary] = STATE(1285),
    [sym_list_comprehension] = STATE(1285),
    [sym_dictionary_comprehension] = STATE(1285),
    [sym_set_comprehension] = STATE(1285),
    [sym_generator_expression] = STATE(1285),
    [sym_parenthesized_expression] = STATE(1285),
    [sym_concatenated_string] = STATE(1285),
    [sym_string] = STATE(938),
    [sym_await] = STATE(1285),
    [sym_identifier] = ACTIONS(328),
    [anon_sym_DOT] = ACTIONS(574),
    [anon_sym_LPAREN] = ACTIONS(308),
    [anon_sym_COMMA] = ACTIONS(572),
    [anon_sym_STAR] = ACTIONS(310),
    [anon_sym_print] = ACTIONS(579),
    [anon_sym_GT_GT] = ACTIONS(574),
    [anon_sym_COLON] = ACTIONS(572),
    [anon_sym_match] = ACTIONS(579),
    [anon_sym_async] = ACTIONS(579),
    [anon_sym_STAR_STAR] = ACTIONS(574),
    [anon_sym_exec] = ACTIONS(579),
    [anon_sym_AT] = ACTIONS(574),
    [anon_sym_LBRACK] = ACTIONS(314),
    [anon_sym_EQ] = ACTIONS(572),
    [anon_sym_PLUS] = ACTIONS(318),
    [anon_sym_DASH] = ACTIONS(318),
    [anon_sym_SLASH] = ACTIONS(574),
    [anon_sym_PERCENT] = ACTIONS(574),
    [anon_sym_SLASH_SLASH] = ACTIONS(574),
    [anon_sym_PIPE] = ACTIONS(574),
    [anon_sym_AMP] = ACTIONS(574),
    [anon_sym_CARET] = ACTIONS(574),
    [anon_sym_LT_LT] = ACTIONS(574),
    [anon_sym_TILDE] = ACTIONS(320),
    [anon_sym_PLUS_EQ] = ACTIONS(572),
    [anon_sym_DASH_EQ] = ACTIONS(572),
    [anon_sym_STAR_EQ] = ACTIONS(572),
    [anon_sym_SLASH_EQ] = ACTIONS(572),
    [anon_sym_AT_EQ] = ACTIONS(572),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(572),
    [anon_sym_PERCENT_EQ] = ACTIONS(572),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(572),
    [anon_sym_GT_GT_EQ] = ACTIONS(572),
    [anon_sym_LT_LT_EQ] = ACTIONS(572),
    [anon_sym_AMP_EQ] = ACTIONS(572),
    [anon_sym_CARET_EQ] = ACTIONS(572),
    [anon_sym_PIPE_EQ] = ACTIONS(572),
    [sym_ellipsis] = ACTIONS(324),
    [anon_sym_LBRACE] = ACTIONS(326),
    [sym_integer] = ACTIONS(328),
    [sym_float] = ACTIONS(324),
    [anon_sym_await] = ACTIONS(581),
    [sym_true] = ACTIONS(328),
    [sym_false] = ACTIONS(328),
    [sym_none] = ACTIONS(328),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(332),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 29,
    ACTIONS(702), 1,
      anon_sym_LBRACE,
    ACTIONS(706), 1,
      sym_string_start,
    ACTIONS(708), 1,
      sym_identifier,
    ACTIONS(710), 1,
      anon_sym_LPAREN,
    ACTIONS(712), 1,
      anon_sym_STAR,
    ACTIONS(716), 1,
      anon_sym_LBRACK,
    ACTIONS(718), 1,
      anon_sym_RBRACK,
    ACTIONS(720), 1,
      anon_sym_not,
    ACTIONS(722), 1,
      anon_sym_lambda,
    ACTIONS(724), 1,
      anon_sym_yield,
    ACTIONS(726), 1,
      anon_sym_await,
    STATE(904), 1,
      sym_primary_expression,
    STATE(905), 1,
      sym_string,
    STATE(1268), 1,
      sym_list_splat_pattern,
    STATE(1488), 1,
      sym_expression,
    STATE(1840), 1,
      sym_pattern,
    STATE(2207), 1,
      sym__collection_elements,
    STATE(2209), 1,
      sym__patterns,
    STATE(2212), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(700), 2,
      sym_ellipsis,
      sym_float,
    STATE(1270), 2,
      sym_attribute,
      sym_subscript,
    STATE(2051), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(698), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(1880), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(688), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(714), 4,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
    STATE(1578), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1252), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
      sym_await,
  [121] = 29,
    ACTIONS(702), 1,
      anon_sym_LBRACE,
    ACTIONS(706), 1,
      sym_string_start,
    ACTIONS(708), 1,
      sym_identifier,
    ACTIONS(710), 1,
      anon_sym_LPAREN,
    ACTIONS(712), 1,
      anon_sym_STAR,
    ACTIONS(716), 1,
      anon_sym_LBRACK,
    ACTIONS(720), 1,
      anon_sym_not,
    ACTIONS(722), 1,
      anon_sym_lambda,
    ACTIONS(724), 1,
      anon_sym_yield,
    ACTIONS(726), 1,
      anon_sym_await,
    ACTIONS(728), 1,
      anon_sym_RBRACK,
    STATE(904), 1,
      sym_primary_expression,
    STATE(905), 1,
      sym_string,
    STATE(1268), 1,
      sym_list_splat_pattern,
    STATE(1500), 1,
      sym_expression,
    STATE(1840), 1,
      sym_pattern,
    STATE(2212), 1,
      sym__named_expression_lhs,
    STATE(2236), 1,
      sym__patterns,
    STATE(2283), 1,
      sym__collection_elements,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(700), 2,
      sym_ellipsis,
      sym_float,
    STATE(1270), 2,
      sym_attribute,
      sym_subscript,
    STATE(2051), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(698), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(1880), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(688), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(714), 4,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
    STATE(1578), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1252), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
      sym_await,
  [242] = 30,
    ACTIONS(622), 1,
      anon_sym_LBRACE,
    ACTIONS(626), 1,
      sym_string_start,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(734), 1,
      anon_sym_RPAREN,
    ACTIONS(736), 1,
      anon_sym_STAR,
    ACTIONS(740), 1,
      anon_sym_LBRACK,
    ACTIONS(742), 1,
      anon_sym_not,
    ACTIONS(744), 1,
      anon_sym_lambda,
    ACTIONS(746), 1,
      anon_sym_yield,
    ACTIONS(748), 1,
      anon_sym_await,
    STATE(907), 1,
      sym_string,
    STATE(934), 1,
      sym_primary_expression,
    STATE(1206), 1,
      sym_list_splat_pattern,
    STATE(1490), 1,
      sym_expression,
    STATE(1854), 1,
      sym_yield,
    STATE(1878), 1,
      sym_pattern,
    STATE(2222), 1,
      sym__named_expression_lhs,
    STATE(2289), 1,
      sym__collection_elements,
    STATE(2290), 1,
      sym__patterns,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(620), 2,
      sym_ellipsis,
      sym_float,
    STATE(1207), 2,
      sym_attribute,
      sym_subscript,
    STATE(1865), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    STATE(2103), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(618), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(606), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(738), 4,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
    STATE(1606), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1197), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
      sym_await,
  [365] = 29,
    ACTIONS(636), 1,
      anon_sym_LBRACK,
    ACTIONS(642), 1,
      anon_sym_LBRACE,
    ACTIONS(646), 1,
      sym_string_start,
    ACTIONS(750), 1,
      sym_identifier,
    ACTIONS(752), 1,
      anon_sym_LPAREN,
    ACTIONS(754), 1,
      anon_sym_COMMA,
    ACTIONS(756), 1,
      anon_sym_STAR,
    ACTIONS(760), 1,
      anon_sym_STAR_STAR,
    ACTIONS(762), 1,
      anon_sym_not,
    ACTIONS(764), 1,
      anon_sym_lambda,
    ACTIONS(766), 1,
      anon_sym_yield,
    ACTIONS(768), 1,
      anon_sym_RBRACE,
    ACTIONS(770), 1,
      anon_sym_await,
    STATE(890), 1,
      sym_primary_expression,
    STATE(893), 1,
      sym_string,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1473), 1,
      sym_expression,
    STATE(1664), 1,
      sym_pair,
    STATE(1986), 1,
      sym_dictionary_splat,
    STATE(2148), 1,
      sym__named_expression_lhs,
    STATE(2217), 1,
      sym__collection_elements,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(640), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(638), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2032), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(628), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(758), 4,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
    STATE(1540), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1020), 16,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
      sym_await,
  [486] = 29,
    ACTIONS(636), 1,
      anon_sym_LBRACK,
    ACTIONS(642), 1,
      anon_sym_LBRACE,
    ACTIONS(646), 1,
      sym_string_start,
    ACTIONS(750), 1,
      sym_identifier,
    ACTIONS(752), 1,
      anon_sym_LPAREN,
    ACTIONS(756), 1,
      anon_sym_STAR,
    ACTIONS(760), 1,
      anon_sym_STAR_STAR,
    ACTIONS(762), 1,
      anon_sym_not,
    ACTIONS(764), 1,
      anon_sym_lambda,
    ACTIONS(766), 1,
      anon_sym_yield,
    ACTIONS(770), 1,
      anon_sym_await,
    ACTIONS(772), 1,
      anon_sym_COMMA,
    ACTIONS(774), 1,
      anon_sym_RBRACE,
    STATE(890), 1,
      sym_primary_expression,
    STATE(893), 1,
      sym_string,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1478), 1,
      sym_expression,
    STATE(1671), 1,
      sym_pair,
    STATE(1962), 1,
      sym_dictionary_splat,
    STATE(2148), 1,
      sym__named_expression_lhs,
    STATE(2163), 1,
      sym__collection_elements,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(640), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(638), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2032), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(628), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(758), 4,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
    STATE(1540), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1020), 16,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
      sym_await,
  [607] = 29,
    ACTIONS(702), 1,
      anon_sym_LBRACE,
    ACTIONS(706), 1,
      sym_string_start,
    ACTIONS(708), 1,
      sym_identifier,
    ACTIONS(710), 1,
      anon_sym_LPAREN,
    ACTIONS(712), 1,
      anon_sym_STAR,
    ACTIONS(716), 1,
      anon_sym_LBRACK,
    ACTIONS(720), 1,
      anon_sym_not,
    ACTIONS(722), 1,
      anon_sym_lambda,
    ACTIONS(724), 1,
      anon_sym_yield,
    ACTIONS(726), 1,
      anon_sym_await,
    ACTIONS(776), 1,
      anon_sym_RBRACK,
    STATE(904), 1,
      sym_primary_expression,
    STATE(905), 1,
      sym_string,
    STATE(1268), 1,
      sym_list_splat_pattern,
    STATE(1500), 1,
      sym_expression,
    STATE(1840), 1,
      sym_pattern,
    STATE(2209), 1,
      sym__patterns,
    STATE(2212), 1,
      sym__named_expression_lhs,
    STATE(2283), 1,
      sym__collection_elements,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(700), 2,
      sym_ellipsis,
      sym_float,
    STATE(1270), 2,
      sym_attribute,
      sym_subscript,
    STATE(2051), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(698), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(1880), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(688), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(714), 4,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
    STATE(1578), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1252), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
      sym_await,
  [728] = 29,
    ACTIONS(702), 1,
      anon_sym_LBRACE,
    ACTIONS(706), 1,
      sym_string_start,
    ACTIONS(708), 1,
      sym_identifier,
    ACTIONS(710), 1,
      anon_sym_LPAREN,
    ACTIONS(712), 1,
      anon_sym_STAR,
    ACTIONS(716), 1,
      anon_sym_LBRACK,
    ACTIONS(720), 1,
      anon_sym_not,
    ACTIONS(722), 1,
      anon_sym_lambda,
    ACTIONS(724), 1,
      anon_sym_yield,
    ACTIONS(726), 1,
      anon_sym_await,
    ACTIONS(778), 1,
      anon_sym_RBRACK,
    STATE(904), 1,
      sym_primary_expression,
    STATE(905), 1,
      sym_string,
    STATE(1268), 1,
      sym_list_splat_pattern,
    STATE(1498), 1,
      sym_expression,
    STATE(1840), 1,
      sym_pattern,
    STATE(2200), 1,
      sym__collection_elements,
    STATE(2212), 1,
      sym__named_expression_lhs,
    STATE(2285), 1,
      sym__patterns,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(700), 2,
      sym_ellipsis,
      sym_float,
    STATE(1270), 2,
      sym_attribute,
      sym_subscript,
    STATE(2051), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(698), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(1880), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(688), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(714), 4,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
    STATE(1578), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1252), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
      sym_await,
  [849] = 29,
    ACTIONS(636), 1,
      anon_sym_LBRACK,
    ACTIONS(642), 1,
      anon_sym_LBRACE,
    ACTIONS(646), 1,
      sym_string_start,
    ACTIONS(750), 1,
      sym_identifier,
    ACTIONS(752), 1,
      anon_sym_LPAREN,
    ACTIONS(756), 1,
      anon_sym_STAR,
    ACTIONS(760), 1,
      anon_sym_STAR_STAR,
    ACTIONS(762), 1,
      anon_sym_not,
    ACTIONS(764), 1,
      anon_sym_lambda,
    ACTIONS(766), 1,
      anon_sym_yield,
    ACTIONS(770), 1,
      anon_sym_await,
    ACTIONS(780), 1,
      anon_sym_COMMA,
    ACTIONS(782), 1,
      anon_sym_RBRACE,
    STATE(890), 1,
      sym_primary_expression,
    STATE(893), 1,
      sym_string,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1479), 1,
      sym_expression,
    STATE(1659), 1,
      sym_pair,
    STATE(1999), 1,
      sym_dictionary_splat,
    STATE(2148), 1,
      sym__named_expression_lhs,
    STATE(2234), 1,
      sym__collection_elements,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(640), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(638), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    STATE(2032), 3,
      sym_list_splat,
      sym_parenthesized_list_splat,
      sym_yield,
    ACTIONS(628), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(758), 4,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
    STATE(1540), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1020), 16,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
      sym_await,
  [970] = 30,
    ACTIONS(622), 1,
      anon_sym_LBRACE,
    ACTIONS(626), 1,
      sym_string_start,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(736), 1,
      anon_sym_STAR,
    ACTIONS(740), 1,
      anon_sym_LBRACK,
    ACTIONS(742), 1,
      anon_sym_not,
    ACTIONS(744), 1,
      anon_sym_lambda,
    ACTIONS(746), 1,
      anon_sym_yield,
    ACTIONS(748), 1,
      anon_sym_await,
    ACTIONS(784), 1,
      anon_sym_RPAREN,
    STATE(907), 1,
      sym_string,
    STATE(934), 1,
      sym_primary_expression,
    STATE(1206), 1,
      sym_list_splat_pattern,
    STATE(1502), 1,
      sym_expression,
    STATE(1878), 1,
      sym_pattern,
    STATE(1889), 1,
      sym_yield,
    STATE(2222), 1,
      sym__named_expression_lhs,
    STATE(2239), 1,
      sym__collection_elements,
    STATE(2261), 1,
      sym__patterns,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(620), 2,
      sym_ellipsis,
      sym_float,
    STATE(1207), 2,
      sym_attribute,
      sym_subscript,
    STATE(1865), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    STATE(2103), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(618), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(606), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(738), 4,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
    STATE(1606), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1197), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
      sym_await,
  [1093] = 30,
    ACTIONS(622), 1,
      anon_sym_LBRACE,
    ACTIONS(626), 1,
      sym_string_start,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(736), 1,
      anon_sym_STAR,
    ACTIONS(740), 1,
      anon_sym_LBRACK,
    ACTIONS(742), 1,
      anon_sym_not,
    ACTIONS(744), 1,
      anon_sym_lambda,
    ACTIONS(746), 1,
      anon_sym_yield,
    ACTIONS(748), 1,
      anon_sym_await,
    ACTIONS(786), 1,
      anon_sym_RPAREN,
    STATE(907), 1,
      sym_string,
    STATE(934), 1,
      sym_primary_expression,
    STATE(1206), 1,
      sym_list_splat_pattern,
    STATE(1490), 1,
      sym_expression,
    STATE(1854), 1,
      sym_yield,
    STATE(1878), 1,
      sym_pattern,
    STATE(2222), 1,
      sym__named_expression_lhs,
    STATE(2261), 1,
      sym__patterns,
    STATE(2289), 1,
      sym__collection_elements,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(620), 2,
      sym_ellipsis,
      sym_float,
    STATE(1207), 2,
      sym_attribute,
      sym_subscript,
    STATE(1865), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    STATE(2103), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(618), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(606), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(738), 4,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
    STATE(1606), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1197), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_generator_expression,
      sym_parenthesized_expression,
      sym_concatenated_string,
      sym_await,
  [1216] = 31,
    ACTIONS(622), 1,
      anon_sym_LBRACE,
    ACTIONS(626), 1,
      sym_string_start,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_LPAREN,
    ACTIONS(736), 1,
      anon_sym_STAR,
    ACTIONS(740), 1,
      anon_sym_LBRACK,
    ACTIONS(742), 1,
      anon_sym_not,
    ACTIONS(744), 1,
      anon_sym_lambda,
    ACTIONS(746), 1,
      anon_sym_yield,
    ACTIONS(748), 1,
      anon_sym_await,
    ACTIONS(788), 1,
      anon_sym_RPAREN,
    STATE(907), 1,
      sym_string,
    STATE(934), 1,
      sym_primary_expression,
    STATE(1206), 1,
      sym_list_splat_pattern,
    STATE(1482), 1,
      sym_expression,
    STATE(1878), 1,
      sym_pattern,
    STATE(1914), 1,
      sym_yield,
    STATE(2046), 1,
      sym_parenthesized_list_splat,
    STATE(2049), 1,
      sym_list_splat,
    STATE(2216), 1,
      sym__collection_elements,
    STATE(2219), 1,
      sym__patterns,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(620), 2,
      sym_ellipsis,
      sym_float,
    STATE(1207), 2,
      sym_attribute,
      sym_subscript,
    STATE(2103), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(618), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(606), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(738), 4,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
    STATE(1606), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1197), 14,
      sym_binary_operator,
      sym_unary_o