/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.trace.Tracer;
import java.rmi.server.UID;
import java.sql.SQLException;
import java.sql.Savepoint;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class MysqlSavepoint
implements Savepoint {
    private String savepointName;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;

    private static String getUniqueId() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String uidStr = new UID().toString();
        int uidLength = uidStr.length();
        StringBuffer safeString = new StringBuffer(uidLength);
        int i = 0;
        while (i < uidLength) {
            char c = uidStr.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c)) {
                safeString.append(c);
            } else {
                safeString.append('_');
            }
            ++i;
        }
        String string = safeString.toString();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    MysqlSavepoint() throws SQLException {
        this(MysqlSavepoint.getUniqueId());
    }

    MysqlSavepoint(String name) throws SQLException {
        if (name == null || name.length() == 0) {
            throw SQLError.createSQLException("Savepoint name can not be NULL or empty", "S1009");
        }
        this.savepointName = name;
    }

    public int getSavepointId() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        throw SQLError.createSQLException("Only named savepoints are supported.", "S1C00");
    }

    public String getSavepointName() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String string = this.savepointName;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    static {
        Factory factory = new Factory("MysqlSavepoint.java", Class.forName("com.mysql.jdbc.MysqlSavepoint"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-getUniqueId-com.mysql.jdbc.MysqlSavepoint----java.lang.String-"), 41);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getSavepointId-com.mysql.jdbc.MysqlSavepoint---java.sql.SQLException:-int-"), 96);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getSavepointName-com.mysql.jdbc.MysqlSavepoint---java.sql.SQLException:-java.lang.String-"), 104);
    }
}

