/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Field;
import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.OperationNotSupportedException;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.RowData;
import com.mysql.jdbc.ServerPreparedStatement;
import com.mysql.jdbc.trace.Tracer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class CursorRowProvider
implements RowData {
    private static final int BEFORE_START_OF_ROWS = -1;
    private List fetchedRows;
    private int currentPositionInEntireResult = -1;
    private int currentPositionInFetchedRows = -1;
    private ResultSet owner;
    private boolean lastRowFetched = false;
    private Field[] fields;
    private MysqlIO mysql;
    private long statementIdOnServer;
    private ServerPreparedStatement prepStmt;
    private static final int SERVER_STATUS_LAST_ROW_SENT = 128;
    private boolean firstFetchCompleted = false;
    private boolean wasEmpty = false;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;
    private static final JoinPoint.StaticPart ajc$tjp_15;
    private static final JoinPoint.StaticPart ajc$tjp_16;
    private static final JoinPoint.StaticPart ajc$tjp_17;
    private static final JoinPoint.StaticPart ajc$tjp_18;
    private static final JoinPoint.StaticPart ajc$tjp_19;
    private static final JoinPoint.StaticPart ajc$tjp_20;
    private static final JoinPoint.StaticPart ajc$tjp_21;
    private static final JoinPoint.StaticPart ajc$tjp_22;
    private static final JoinPoint.StaticPart ajc$tjp_23;
    private static final JoinPoint.StaticPart ajc$tjp_24;

    public CursorRowProvider(MysqlIO ioChannel, ServerPreparedStatement creatingStatement, Field[] metadata) {
        this.fields = metadata;
        this.mysql = ioChannel;
        this.statementIdOnServer = creatingStatement.getServerStatementId();
        this.prepStmt = creatingStatement;
    }

    public boolean isAfterLast() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.lastRowFetched && this.currentPositionInFetchedRows > this.fetchedRows.size();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    public Object[] getAt(int n) throws SQLException {
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.notSupported();
        Object[] objectArray = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(objectArray, joinPoint);
        return null;
    }

    public boolean isBeforeFirst() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.currentPositionInEntireResult < 0;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    public void setCurrentRow(int n) throws SQLException {
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.notSupported();
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    public int getCurrentRowNumber() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.currentPositionInEntireResult + 1;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    public boolean isDynamic() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = true;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return true;
    }

    public boolean isEmpty() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.isBeforeFirst() && this.isAfterLast();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    public boolean isFirst() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.currentPositionInEntireResult == 0;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    public boolean isLast() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.lastRowFetched && this.currentPositionInFetchedRows == this.fetchedRows.size() - 1;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    public void addRow(byte[][] byArray) throws SQLException {
        byte[][] byArray2 = byArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)byArray2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.notSupported();
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    public void afterLast() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.notSupported();
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    public void beforeFirst() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.notSupported();
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    public void beforeLast() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.notSupported();
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    public void close() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.fields = null;
        this.owner = null;
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    public boolean hasNext() throws SQLException {
        int maxRows;
        boolean bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.fetchedRows != null && this.fetchedRows.size() == 0) {
            bl = false;
        } else if (this.owner != null && this.owner.owningStatement != null && (maxRows = this.owner.owningStatement.maxRows) != -1 && this.currentPositionInEntireResult + 1 > maxRows) {
            bl = false;
        } else if (this.currentPositionInEntireResult != -1) {
            if (this.currentPositionInFetchedRows < this.fetchedRows.size() - 1) {
                bl = true;
            } else if (this.currentPositionInFetchedRows == this.fetchedRows.size() && this.lastRowFetched) {
                bl = false;
            } else {
                this.fetchMoreRows();
                bl = this.fetchedRows.size() > 0;
            }
        } else {
            this.fetchMoreRows();
            bl = this.fetchedRows.size() > 0;
        }
        boolean bl2 = bl;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl2), joinPoint);
        return bl;
    }

    public void moveRowRelative(int n) throws SQLException {
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.notSupported();
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    public Object[] next() throws SQLException {
        Object[] objectArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        ++this.currentPositionInEntireResult;
        ++this.currentPositionInFetchedRows;
        if (this.fetchedRows != null && this.fetchedRows.size() == 0) {
            objectArray = null;
        } else {
            Object[] row;
            if (this.currentPositionInFetchedRows > this.fetchedRows.size() - 1) {
                this.fetchMoreRows();
                this.currentPositionInFetchedRows = 0;
            }
            objectArray = row = (Object[])this.fetchedRows.get(this.currentPositionInFetchedRows);
        }
        Object[] objectArray2 = objectArray;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(objectArray2, joinPoint);
        return objectArray;
    }

    private void fetchMoreRows() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.lastRowFetched) {
            this.fetchedRows = new ArrayList(0);
        } else {
            Object object = this.owner.connection.getMutex();
            synchronized (object) {
                int numRowsToFetch;
                boolean oldFirstFetchCompleted = this.firstFetchCompleted;
                if (!this.firstFetchCompleted) {
                    this.firstFetchCompleted = true;
                }
                if ((numRowsToFetch = this.owner.getFetchSize()) == 0) {
                    numRowsToFetch = this.prepStmt.getFetchSize();
                }
                if (numRowsToFetch == Integer.MIN_VALUE) {
                    numRowsToFetch = 1;
                }
                this.fetchedRows = this.mysql.fetchRowsViaCursor(this.fetchedRows, this.statementIdOnServer, this.fields, numRowsToFetch);
                this.currentPositionInFetchedRows = -1;
                if ((this.mysql.getServerStatus() & 0x80) != 0) {
                    this.lastRowFetched = true;
                    if (!oldFirstFetchCompleted && this.fetchedRows.size() == 0) {
                        this.wasEmpty = true;
                    }
                }
            }
        }
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    public void removeRow(int n) throws SQLException {
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.notSupported();
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    public int size() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = -1;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return -1;
    }

    private void nextRecord() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    private void notSupported() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        throw new OperationNotSupportedException();
    }

    /*
     * WARNING - void declaration
     */
    public void setOwner(ResultSet resultSet) {
        void rs;
        ResultSet resultSet2 = resultSet;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object)resultSet2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.owner = rs;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    public ResultSet getOwner() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        ResultSet resultSet = this.owner;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(resultSet, joinPoint);
        return resultSet;
    }

    public boolean wasEmpty() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.wasEmpty;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    static {
        Factory factory = new Factory("CursorRowProvider.java", Class.forName("com.mysql.jdbc.CursorRowProvider"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-isAfterLast-com.mysql.jdbc.CursorRowProvider----boolean-"), 127);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getAt-com.mysql.jdbc.CursorRowProvider-int:-ind:-java.sql.SQLException:-[Ljava.lang.Object;-"), 141);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-afterLast-com.mysql.jdbc.CursorRowProvider---java.sql.SQLException:-void-"), 246);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-beforeFirst-com.mysql.jdbc.CursorRowProvider---java.sql.SQLException:-void-"), 256);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-beforeLast-com.mysql.jdbc.CursorRowProvider---java.sql.SQLException:-void-"), 266);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-close-com.mysql.jdbc.CursorRowProvider---java.sql.SQLException:-void-"), 277);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-hasNext-com.mysql.jdbc.CursorRowProvider---java.sql.SQLException:-boolean-"), 290);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-moveRowRelative-com.mysql.jdbc.CursorRowProvider-int:-rows:-java.sql.SQLException:-void-"), 335);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-next-com.mysql.jdbc.CursorRowProvider---java.sql.SQLException:-[Ljava.lang.Object;-"), 347);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-fetchMoreRows-com.mysql.jdbc.CursorRowProvider---java.sql.SQLException:-void-"), 371);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-removeRow-com.mysql.jdbc.CursorRowProvider-int:-ind:-java.sql.SQLException:-void-"), 419);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-size-com.mysql.jdbc.CursorRowProvider----int-"), 428);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-isBeforeFirst-com.mysql.jdbc.CursorRowProvider---java.sql.SQLException:-boolean-"), 154);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-nextRecord-com.mysql.jdbc.CursorRowProvider---java.sql.SQLException:-void-"), 433);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-notSupported-com.mysql.jdbc.CursorRowProvider---java.sql.SQLException:-void-"), 436);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setOwner-com.mysql.jdbc.CursorRowProvider-com.mysql.jdbc.ResultSet:-rs:--void-"), 445);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getOwner-com.mysql.jdbc.CursorRowProvider----com.mysql.jdbc.ResultSet-"), 454);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-wasEmpty-com.mysql.jdbc.CursorRowProvider----boolean-"), 458);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setCurrentRow-com.mysql.jdbc.CursorRowProvider-int:-rowNumber:-java.sql.SQLException:-void-"), 166);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getCurrentRowNumber-com.mysql.jdbc.CursorRowProvider---java.sql.SQLException:-int-"), 177);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-isDynamic-com.mysql.jdbc.CursorRowProvider----boolean-"), 189);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-isEmpty-com.mysql.jdbc.CursorRowProvider---java.sql.SQLException:-boolean-"), 200);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-isFirst-com.mysql.jdbc.CursorRowProvider---java.sql.SQLException:-boolean-"), 211);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-isLast-com.mysql.jdbc.CursorRowProvider---java.sql.SQLException:-boolean-"), 222);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-addRow-com.mysql.jdbc.CursorRowProvider-[[B:-row:-java.sql.SQLException:-void-"), 236);
    }
}

