/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.index.IIndex;
import org.eclipse.jdt.internal.core.search.JavaSearchDocument;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.search.indexing.SaveIndex;
import org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.eclipse.jdt.internal.core.util.SimpleLookupTable;

public class IndexBinaryFolder
extends IndexRequest {
    IFolder folder;

    public IndexBinaryFolder(IFolder folder, IndexManager manager) {
        super(folder.getFullPath(), manager);
        this.folder = folder;
    }

    public boolean equals(Object o) {
        if (o instanceof IndexBinaryFolder) {
            return this.folder.equals(((IndexBinaryFolder)o).folder);
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        if (this.isCancelled) return true;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        if (!this.folder.isAccessible()) {
            return true;
        }
        IIndex index = this.manager.getIndexForUpdate(this.containerPath, true, true);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = this.manager.getMonitorFor(index);
        if (monitor == null) {
            return true;
        }
        try {
            try {
                monitor.enterRead();
                this.saveIfNecessary(index, monitor);
                String[] paths = index.queryInDocumentNames("");
                int max = paths == null ? 0 : paths.length;
                final SimpleLookupTable indexedFileNames = new SimpleLookupTable(max == 0 ? 33 : max + 11);
                String OK = "OK";
                String DELETED = "DELETED";
                if (max == 0) {
                    this.folder.accept(new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy proxy) {
                            if (IndexBinaryFolder.this.isCancelled) {
                                return false;
                            }
                            if (proxy.getType() == 1) {
                                IFile file;
                                if (Util.isClassFileName(proxy.getName()) && (file = (IFile)proxy.requestResource()).getLocation() != null) {
                                    indexedFileNames.put(new JavaSearchDocument(file, null).getPath(), file);
                                }
                                return false;
                            }
                            return true;
                        }
                    }, 0);
                } else {
                    int i = 0;
                    while (true) {
                        if (i >= max) {
                            final long indexLastModified = index.getIndexFile().lastModified();
                            this.folder.accept(new IResourceProxyVisitor(){

                                public boolean visit(IResourceProxy proxy) {
                                    if (IndexBinaryFolder.this.isCancelled) {
                                        return false;
                                    }
                                    if (proxy.getType() == 1) {
                                        IFile file;
                                        IPath location;
                                        if (Util.isClassFileName(proxy.getName()) && (location = (file = (IFile)proxy.requestResource()).getLocation()) != null) {
                                            String path;
                                            indexedFileNames.put(path, indexedFileNames.get(path = new JavaSearchDocument(file, null).getPath()) == null || indexLastModified < location.toFile().lastModified() ? file : "OK");
                                        }
                                        return false;
                                    }
                                    return true;
                                }
                            }, 0);
                            break;
                        }
                        indexedFileNames.put(paths[i], "DELETED");
                        ++i;
                    }
                }
                Object[] names = indexedFileNames.keyTable;
                Object[] values = indexedFileNames.valueTable;
                int i = 0;
                int length = names.length;
                while (true) {
                    block22: {
                        if (i < length) break block22;
                        this.manager.request(new SaveIndex(this.containerPath, this.manager));
                        break;
                    }
                    String name = (String)names[i];
                    if (name != null) {
                        if (this.isCancelled) {
                            Object var15_19 = null;
                            monitor.exitRead();
                            return false;
                        }
                        Object value = values[i];
                        if (value != "OK") {
                            if (value == "DELETED") {
                                this.manager.remove(name, this.containerPath);
                            } else {
                                this.manager.addBinary((IFile)value, this.containerPath);
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                if (JobManager.VERBOSE) {
                    JobManager.verbose("-> failed to index " + this.folder + " because of the following exception:");
                    e.printStackTrace();
                }
                this.manager.removeIndex(this.containerPath);
                Object var15_20 = null;
                monitor.exitRead();
                return false;
            }
            catch (IOException e) {
                if (JobManager.VERBOSE) {
                    JobManager.verbose("-> failed to index " + this.folder + " because of the following exception:");
                    e.printStackTrace();
                }
                this.manager.removeIndex(this.containerPath);
                Object var15_21 = null;
                monitor.exitRead();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var15_22 = null;
            monitor.exitRead();
            throw throwable;
        }
        {
            Object var15_23 = null;
            monitor.exitRead();
            return true;
        }
    }

    public int hashCode() {
        return this.folder.hashCode();
    }

    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing binary folder " + this.folder.getFullPath();
    }
}

