/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.classfmt.FieldInfo;
import org.eclipse.jdt.internal.compiler.classfmt.MethodInfo;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;

public class BinaryIndexer
extends AbstractIndexer
implements SuffixConstants {
    private static final char[] BYTE = "byte".toCharArray();
    private static final char[] CHAR = "char".toCharArray();
    private static final char[] DOUBLE = "double".toCharArray();
    private static final char[] FLOAT = "float".toCharArray();
    private static final char[] INT = "int".toCharArray();
    private static final char[] LONG = "long".toCharArray();
    private static final char[] SHORT = "short".toCharArray();
    private static final char[] BOOLEAN = "boolean".toCharArray();
    private static final char[] VOID = "void".toCharArray();
    private static final char[] INIT = "<init>".toCharArray();
    private static final char[] ONE_DOLLAR = "$".toCharArray();
    private static final char[] ONE_DOT = ".".toCharArray();

    public BinaryIndexer(SearchDocument document, String indexPath) {
        super(document, indexPath);
    }

    public void addTypeReference(char[] typeName) {
        typeName = CharOperation.replace(typeName, ONE_DOLLAR, ONE_DOT);
        super.addTypeReference(typeName);
    }

    private void convertToArrayType(char[][] parameterTypes, int counter, int arrayDim) {
        int length = parameterTypes[counter].length;
        char[] arrayType = new char[length + arrayDim * 2];
        System.arraycopy(parameterTypes[counter], 0, arrayType, 0, length);
        int i = 0;
        while (i < arrayDim) {
            arrayType[length + i * 2] = 91;
            arrayType[length + i * 2 + 1] = 93;
            ++i;
        }
        parameterTypes[counter] = arrayType;
    }

    private char[] convertToArrayType(char[] typeName, int arrayDim) {
        int length = typeName.length;
        char[] arrayType = new char[length + arrayDim * 2];
        System.arraycopy(typeName, 0, arrayType, 0, length);
        int i = 0;
        while (i < arrayDim) {
            arrayType[length + i * 2] = 91;
            arrayType[length + i * 2 + 1] = 93;
            ++i;
        }
        return arrayType;
    }

    private char[] decodeFieldType(char[] signature) throws ClassFormatException {
        if (signature == null) {
            return null;
        }
        int arrayDim = 0;
        int i = 0;
        int max = signature.length;
        while (i < max) {
            switch (signature[i]) {
                case 'B': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(BYTE, arrayDim);
                    }
                    return BYTE;
                }
                case 'C': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(CHAR, arrayDim);
                    }
                    return CHAR;
                }
                case 'D': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(DOUBLE, arrayDim);
                    }
                    return DOUBLE;
                }
                case 'F': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(FLOAT, arrayDim);
                    }
                    return FLOAT;
                }
                case 'I': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(INT, arrayDim);
                    }
                    return INT;
                }
                case 'J': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(LONG, arrayDim);
                    }
                    return LONG;
                }
                case 'L': {
                    int indexOfSemiColon = CharOperation.indexOf(';', signature, i + 1);
                    if (indexOfSemiColon == -1) {
                        throw new ClassFormatException(28);
                    }
                    if (arrayDim > 0) {
                        return this.convertToArrayType(this.replace('/', '.', CharOperation.subarray(signature, i + 1, indexOfSemiColon)), arrayDim);
                    }
                    return this.replace('/', '.', CharOperation.subarray(signature, i + 1, indexOfSemiColon));
                }
                case 'S': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(SHORT, arrayDim);
                    }
                    return SHORT;
                }
                case 'Z': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(BOOLEAN, arrayDim);
                    }
                    return BOOLEAN;
                }
                case 'V': {
                    return VOID;
                }
                case '[': {
                    ++arrayDim;
                    break;
                }
                default: {
                    throw new ClassFormatException(28);
                }
            }
            ++i;
        }
        return null;
    }

    private char[][] decodeParameterTypes(char[] signature) throws ClassFormatException {
        if (signature == null) {
            return null;
        }
        int indexOfClosingParen = CharOperation.lastIndexOf(')', signature);
        if (indexOfClosingParen == 1) {
            return null;
        }
        if (indexOfClosingParen == -1) {
            throw new ClassFormatException(28);
        }
        char[][] parameterTypes = new char[3][];
        int parameterTypesCounter = 0;
        int arrayDim = 0;
        int i = 1;
        while (i < indexOfClosingParen) {
            if (parameterTypesCounter == parameterTypes.length) {
                char[][] cArray = parameterTypes;
                parameterTypes = new char[parameterTypesCounter * 2][];
                System.arraycopy(cArray, 0, parameterTypes, 0, parameterTypesCounter);
            }
            switch (signature[i]) {
                case 'B': {
                    parameterTypes[parameterTypesCounter++] = BYTE;
                    if (arrayDim > 0) {
                        this.convertToArrayType(parameterTypes, parameterTypesCounter - 1, arrayDim);
                    }
                    arrayDim = 0;
                    break;
                }
                case 'C': {
                    parameterTypes[parameterTypesCounter++] = CHAR;
                    if (arrayDim > 0) {
                        this.convertToArrayType(parameterTypes, parameterTypesCounter - 1, arrayDim);
                    }
                    arrayDim = 0;
                    break;
                }
                case 'D': {
                    parameterTypes[parameterTypesCounter++] = DOUBLE;
                    if (arrayDim > 0) {
                        this.convertToArrayType(parameterTypes, parameterTypesCounter - 1, arrayDim);
                    }
                    arrayDim = 0;
                    break;
                }
                case 'F': {
                    parameterTypes[parameterTypesCounter++] = FLOAT;
                    if (arrayDim > 0) {
                        this.convertToArrayType(parameterTypes, parameterTypesCounter - 1, arrayDim);
                    }
                    arrayDim = 0;
                    break;
                }
                case 'I': {
                    parameterTypes[parameterTypesCounter++] = INT;
                    if (arrayDim > 0) {
                        this.convertToArrayType(parameterTypes, parameterTypesCounter - 1, arrayDim);
                    }
                    arrayDim = 0;
                    break;
                }
                case 'J': {
                    parameterTypes[parameterTypesCounter++] = LONG;
                    if (arrayDim > 0) {
                        this.convertToArrayType(parameterTypes, parameterTypesCounter - 1, arrayDim);
                    }
                    arrayDim = 0;
                    break;
                }
                case 'L': {
                    int indexOfSemiColon = CharOperation.indexOf(';', signature, i + 1);
                    if (indexOfSemiColon == -1) {
                        throw new ClassFormatException(28);
                    }
                    parameterTypes[parameterTypesCounter++] = this.replace('/', '.', CharOperation.subarray(signature, i + 1, indexOfSemiColon));
                    if (arrayDim > 0) {
                        this.convertToArrayType(parameterTypes, parameterTypesCounter - 1, arrayDim);
                    }
                    i = indexOfSemiColon;
                    arrayDim = 0;
                    break;
                }
                case 'S': {
                    parameterTypes[parameterTypesCounter++] = SHORT;
                    if (arrayDim > 0) {
                        this.convertToArrayType(parameterTypes, parameterTypesCounter - 1, arrayDim);
                    }
                    arrayDim = 0;
                    break;
                }
                case 'Z': {
                    parameterTypes[parameterTypesCounter++] = BOOLEAN;
                    if (arrayDim > 0) {
                        this.convertToArrayType(parameterTypes, parameterTypesCounter - 1, arrayDim);
                    }
                    arrayDim = 0;
                    break;
                }
                case '[': {
                    ++arrayDim;
                    break;
                }
                default: {
                    throw new ClassFormatException(28);
                }
            }
            ++i;
        }
        if (parameterTypes.length != parameterTypesCounter) {
            char[][] cArray = parameterTypes;
            parameterTypes = new char[parameterTypesCounter][];
            System.arraycopy(cArray, 0, parameterTypes, 0, parameterTypesCounter);
        }
        return parameterTypes;
    }

    private char[] decodeReturnType(char[] signature) throws ClassFormatException {
        if (signature == null) {
            return null;
        }
        int indexOfClosingParen = CharOperation.lastIndexOf(')', signature);
        if (indexOfClosingParen == -1) {
            throw new ClassFormatException(28);
        }
        int arrayDim = 0;
        int i = indexOfClosingParen + 1;
        int max = signature.length;
        while (i < max) {
            switch (signature[i]) {
                case 'B': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(BYTE, arrayDim);
                    }
                    return BYTE;
                }
                case 'C': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(CHAR, arrayDim);
                    }
                    return CHAR;
                }
                case 'D': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(DOUBLE, arrayDim);
                    }
                    return DOUBLE;
                }
                case 'F': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(FLOAT, arrayDim);
                    }
                    return FLOAT;
                }
                case 'I': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(INT, arrayDim);
                    }
                    return INT;
                }
                case 'J': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(LONG, arrayDim);
                    }
                    return LONG;
                }
                case 'L': {
                    int indexOfSemiColon = CharOperation.indexOf(';', signature, i + 1);
                    if (indexOfSemiColon == -1) {
                        throw new ClassFormatException(28);
                    }
                    if (arrayDim > 0) {
                        return this.convertToArrayType(this.replace('/', '.', CharOperation.subarray(signature, i + 1, indexOfSemiColon)), arrayDim);
                    }
                    return this.replace('/', '.', CharOperation.subarray(signature, i + 1, indexOfSemiColon));
                }
                case 'S': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(SHORT, arrayDim);
                    }
                    return SHORT;
                }
                case 'Z': {
                    if (arrayDim > 0) {
                        return this.convertToArrayType(BOOLEAN, arrayDim);
                    }
                    return BOOLEAN;
                }
                case 'V': {
                    return VOID;
                }
                case '[': {
                    ++arrayDim;
                    break;
                }
                default: {
                    throw new ClassFormatException(28);
                }
            }
            ++i;
        }
        return null;
    }

    private int extractArgCount(char[] signature) throws ClassFormatException {
        int indexOfClosingParen = CharOperation.lastIndexOf(')', signature);
        if (indexOfClosingParen == 1) {
            return 0;
        }
        if (indexOfClosingParen == -1) {
            throw new ClassFormatException(28);
        }
        int parameterTypesCounter = 0;
        int i = 1;
        while (i < indexOfClosingParen) {
            switch (signature[i]) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    ++parameterTypesCounter;
                    break;
                }
                case 'L': {
                    int indexOfSemiColon = CharOperation.indexOf(';', signature, i + 1);
                    if (indexOfSemiColon == -1) {
                        throw new ClassFormatException(28);
                    }
                    ++parameterTypesCounter;
                    i = indexOfSemiColon;
                    break;
                }
                case '[': {
                    break;
                }
                default: {
                    throw new ClassFormatException(28);
                }
            }
            ++i;
        }
        return parameterTypesCounter;
    }

    private char[] extractClassName(int[] constantPoolOffsets, ClassFileReader reader, int index) {
        int class_index = reader.u2At(constantPoolOffsets[index] + 1);
        int utf8Offset = constantPoolOffsets[reader.u2At(constantPoolOffsets[class_index] + 1)];
        return reader.utf8At(utf8Offset + 3, reader.u2At(utf8Offset + 1));
    }

    private char[] extractName(int[] constantPoolOffsets, ClassFileReader reader, int index) {
        int nameAndTypeIndex = reader.u2At(constantPoolOffsets[index] + 3);
        int utf8Offset = constantPoolOffsets[reader.u2At(constantPoolOffsets[nameAndTypeIndex] + 1)];
        return reader.utf8At(utf8Offset + 3, reader.u2At(utf8Offset + 1));
    }

    private char[] extractClassReference(int[] constantPoolOffsets, ClassFileReader reader, int index) {
        int utf8Offset = constantPoolOffsets[reader.u2At(constantPoolOffsets[index] + 1)];
        return reader.utf8At(utf8Offset + 3, reader.u2At(utf8Offset + 1));
    }

    private void extractReferenceFromConstantPool(byte[] contents, ClassFileReader reader) throws ClassFormatException {
        int[] constantPoolOffsets = reader.getConstantPoolOffsets();
        int constantPoolCount = constantPoolOffsets.length;
        int i = 1;
        while (i < constantPoolCount) {
            int tag = reader.u1At(constantPoolOffsets[i]);
            char[] name = null;
            char[] type = null;
            switch (tag) {
                case 9: {
                    name = this.extractName(constantPoolOffsets, reader, i);
                    this.addFieldReference(name);
                    break;
                }
                case 10: 
                case 11: {
                    name = this.extractName(constantPoolOffsets, reader, i);
                    type = this.extractType(constantPoolOffsets, reader, i);
                    if (CharOperation.equals(INIT, name)) {
                        char[] className = this.replace('/', '.', this.extractClassName(constantPoolOffsets, reader, i));
                        this.addConstructorReference(className, this.extractArgCount(type));
                        break;
                    }
                    this.addMethodReference(name, this.extractArgCount(type));
                    break;
                }
                case 7: {
                    name = this.replace('/', '.', this.extractClassReference(constantPoolOffsets, reader, i));
                    this.addTypeReference(name);
                    char[][] qualification = CharOperation.splitOn('.', name);
                    int j = 0;
                    int length = qualification.length;
                    while (j < length) {
                        this.addNameReference(qualification[j]);
                        ++j;
                    }
                    break;
                }
            }
            ++i;
        }
    }

    private char[] extractType(int[] constantPoolOffsets, ClassFileReader reader, int index) {
        int constantPoolIndex = reader.u2At(constantPoolOffsets[index] + 3);
        int utf8Offset = constantPoolOffsets[reader.u2At(constantPoolOffsets[constantPoolIndex] + 3)];
        return reader.utf8At(utf8Offset + 3, reader.u2At(utf8Offset + 1));
    }

    public void indexDocument() {
        try {
            FieldInfo[] fields;
            char[][] cArrayArray;
            byte[] contents = this.document.getByteContents();
            ClassFileReader reader = new ClassFileReader(contents, this.document.getPath().toCharArray());
            char[] className = this.replace('/', '.', reader.getName());
            int packageNameIndex = CharOperation.lastIndexOf('.', className);
            char[] packageName = null;
            char[] name = null;
            if (packageNameIndex >= 0) {
                packageName = CharOperation.subarray(className, 0, packageNameIndex);
                name = CharOperation.subarray(className, packageNameIndex + 1, className.length);
            } else {
                packageName = CharOperation.NO_CHAR;
                name = className;
            }
            char[] enclosingTypeName = null;
            if (reader.isNestedType()) {
                name = reader.isAnonymous() ? CharOperation.NO_CHAR : reader.getInnerSourceName();
                if (reader.isLocal() || reader.isAnonymous()) {
                    enclosingTypeName = IIndexConstants.ONE_ZERO;
                } else {
                    char[] fullEnclosingName = reader.getEnclosingTypeName();
                    int nameLength = fullEnclosingName.length - packageNameIndex - 1;
                    if (nameLength <= 0) {
                        return;
                    }
                    enclosingTypeName = new char[nameLength];
                    System.arraycopy(fullEnclosingName, packageNameIndex + 1, enclosingTypeName, 0, nameLength);
                }
            }
            if (name == null) {
                return;
            }
            char[][] superinterfaces = this.replace('/', '.', reader.getInterfaceNames());
            if (enclosingTypeName == null) {
                cArrayArray = null;
            } else {
                char[][] cArrayArray2 = new char[1][];
                cArrayArray = cArrayArray2;
                cArrayArray2[0] = enclosingTypeName;
            }
            char[][] enclosingTypeNames = cArrayArray;
            if (reader.isInterface()) {
                this.addInterfaceDeclaration(reader.getModifiers(), packageName, name, enclosingTypeNames, superinterfaces);
            } else {
                char[] superclass = this.replace('/', '.', reader.getSuperclassName());
                this.addClassDeclaration(reader.getModifiers(), packageName, name, enclosingTypeNames, superclass, superinterfaces);
            }
            MethodInfo[] methods = (MethodInfo[])reader.getMethods();
            if (methods != null) {
                int i = 0;
                int max = methods.length;
                while (i < max) {
                    MethodInfo method = methods[i];
                    char[] descriptor = method.getMethodDescriptor();
                    char[][] parameterTypes = this.decodeParameterTypes(descriptor);
                    char[] returnType = this.decodeReturnType(descriptor);
                    char[][] exceptionTypes = this.replace('/', '.', method.getExceptionTypeNames());
                    if (method.isConstructor()) {
                        this.addConstructorDeclaration(className, parameterTypes, exceptionTypes);
                    } else if (!method.isClinit()) {
                        this.addMethodDeclaration(method.getSelector(), parameterTypes, returnType, exceptionTypes);
                    }
                    ++i;
                }
            }
            if ((fields = (FieldInfo[])reader.getFields()) != null) {
                int i = 0;
                int max = fields.length;
                while (i < max) {
                    FieldInfo field = fields[i];
                    char[] fieldName = field.getName();
                    char[] fieldType = this.decodeFieldType(this.replace('/', '.', field.getTypeName()));
                    this.addFieldDeclaration(fieldType, fieldName);
                    ++i;
                }
            }
            this.extractReferenceFromConstantPool(contents, reader);
        }
        catch (ClassFormatException classFormatException) {
            // empty catch block
        }
    }

    private char[][] replace(char toBeReplaced, char newChar, char[][] array) {
        if (array == null) {
            return null;
        }
        int i = 0;
        int max = array.length;
        while (i < max) {
            this.replace(toBeReplaced, newChar, array[i]);
            ++i;
        }
        return array;
    }

    private char[] replace(char toBeReplaced, char newChar, char[] array) {
        if (array == null) {
            return null;
        }
        int i = 0;
        int max = array.length;
        while (i < max) {
            if (array[i] == toBeReplaced) {
                array[i] = newChar;
            }
            ++i;
        }
        return array;
    }
}

