/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.eclipse.core.internal.localstore.CoreFileSystemLibrary;
import org.eclipse.core.internal.localstore.IUnifiedTreeVisitor;
import org.eclipse.core.internal.localstore.UnifiedTreeNode;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.EmptyEnumeration;
import org.eclipse.core.internal.utils.Queue;
import org.eclipse.core.internal.utils.Sorter;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class UnifiedTree {
    protected IResource root;
    protected IPath rootLocalLocation;
    protected int level;
    protected Queue queue;
    protected ArrayList freeNodes = new ArrayList();
    protected Sorter sorter;
    protected static final UnifiedTreeNode levelMarker = new UnifiedTreeNode(null, null, 0L, null, null, false);
    protected static final UnifiedTreeNode childrenMarker = new UnifiedTreeNode(null, null, 0L, null, null, false);

    public UnifiedTree() {
    }

    public UnifiedTree(IResource root) {
        this.setRoot(root);
    }

    public void accept(IUnifiedTreeVisitor visitor) throws CoreException {
        this.accept(visitor, 2);
    }

    public void accept(IUnifiedTreeVisitor visitor, int depth) throws CoreException {
        Assert.isNotNull(this.root);
        this.initializeQueue();
        this.level = 0;
        while (this.isValidLevel(this.level, depth) && !this.queue.isEmpty()) {
            UnifiedTreeNode node = (UnifiedTreeNode)this.queue.remove();
            if (this.isChildrenMarker(node)) continue;
            if (this.isLevelMarker(node)) {
                ++this.level;
                continue;
            }
            if (visitor.visit(node)) {
                this.addNodeChildrenToQueue(node);
            } else {
                this.removeNodeChildrenFromQueue(node);
            }
            this.freeNodes.add(node);
        }
    }

    protected void addChildren(UnifiedTreeNode node) throws CoreException {
        IResource parent = node.getResource();
        int parentType = parent.getType();
        if (parentType == 1 && node.isFile()) {
            return;
        }
        String parentLocalLocation = node.getLocalLocation();
        Object[] list = this.getLocalList(node, parentLocalLocation);
        int localIndex = 0;
        if (parent.exists() && (parentType == 2 || parentType == 4)) {
            IResource target = null;
            UnifiedTreeNode child = null;
            IResource[] members = ((IContainer)parent).members(2);
            int workspaceIndex = 0;
            while (workspaceIndex < members.length) {
                int comp;
                target = members[workspaceIndex];
                String name = target.getName();
                String localName = list != null && localIndex < list.length ? (String)list[localIndex] : null;
                int n = comp = localName != null ? name.compareTo(localName) : -1;
                if (parentType == 4 && target.isLinked()) {
                    child = this.createChildForLinkedResource(target);
                    ++workspaceIndex;
                    if (comp == 0) {
                        ++localIndex;
                    }
                } else if (comp == 0) {
                    String localLocation = this.createChildLocation(parentLocalLocation, localName);
                    long stat = CoreFileSystemLibrary.getStat(localLocation);
                    child = this.createNode(target, stat, localLocation, localName, true);
                    ++localIndex;
                    ++workspaceIndex;
                } else if (comp > 0) {
                    child = this.createChildNodeFromFileSystem(node, parentLocalLocation, localName);
                    ++localIndex;
                } else {
                    child = this.createNode(target, 0L, null, null, true);
                    ++workspaceIndex;
                }
                if (child == null) continue;
                this.addChildToTree(node, child);
            }
        }
        this.addChildrenFromFileSystem(node, parentLocalLocation, list, localIndex);
        if (node.getFirstChild() != null) {
            this.addChildrenMarker();
        }
    }

    protected UnifiedTreeNode createChildForLinkedResource(IResource target) {
        IPath location = target.getLocation();
        long stat = 0L;
        String locationString = null;
        String name = null;
        if (location != null) {
            locationString = location.toOSString();
            name = location.lastSegment();
            stat = CoreFileSystemLibrary.getStat(locationString);
        }
        return this.createNode(target, stat, locationString, name, true);
    }

    protected void addChildrenFromFileSystem(UnifiedTreeNode node, String parentLocalLocation, Object[] list, int index) throws CoreException {
        if (list == null) {
            return;
        }
        int i = index;
        while (i < list.length) {
            String localName = (String)list[i];
            UnifiedTreeNode child = this.createChildNodeFromFileSystem(node, parentLocalLocation, localName);
            if (child != null) {
                this.addChildToTree(node, child);
            }
            ++i;
        }
    }

    protected void addChildrenMarker() {
        this.addElementToQueue(childrenMarker);
    }

    protected void addChildToTree(UnifiedTreeNode node, UnifiedTreeNode child) {
        if (node.getFirstChild() == null) {
            node.setFirstChild(child);
        }
        this.addElementToQueue(child);
    }

    protected void addElementToQueue(UnifiedTreeNode target) {
        this.queue.add(target);
    }

    protected String createChildLocation(String parentLocation, String childLocation) {
        if (parentLocation == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(parentLocation.length() + childLocation.length() + 1);
        buffer.append(parentLocation);
        buffer.append(File.separatorChar);
        buffer.append(childLocation);
        return buffer.toString();
    }

    protected void addNodeChildrenToQueue(UnifiedTreeNode node) throws CoreException {
        if (node.getFirstChild() != null) {
            return;
        }
        this.addChildren(node);
        if (this.queue.isEmpty()) {
            return;
        }
        UnifiedTreeNode nextNode = (UnifiedTreeNode)this.queue.peek();
        if (this.isLevelMarker(nextNode)) {
            this.addElementToQueue(levelMarker);
        }
    }

    protected void addRootToQueue() throws CoreException {
        UnifiedTreeNode node;
        long stat = 0L;
        String rootLocationString = null;
        String name = null;
        if (this.rootLocalLocation != null) {
            rootLocationString = this.rootLocalLocation.toOSString();
            name = this.rootLocalLocation.lastSegment();
            stat = CoreFileSystemLibrary.getStat(rootLocationString);
        }
        if (!(node = this.createNode(this.root, stat, rootLocationString, name, this.root.exists())).existsInFileSystem() && !node.existsInWorkspace()) {
            return;
        }
        this.addElementToQueue(node);
    }

    protected UnifiedTreeNode createChildNodeFromFileSystem(UnifiedTreeNode parent, String parentLocalLocation, String childName) throws CoreException {
        int type;
        IPath childPath = parent.getResource().getFullPath().append(childName);
        String location = this.createChildLocation(parentLocalLocation, childName);
        long stat = CoreFileSystemLibrary.getStat(location);
        int n = CoreFileSystemLibrary.isFile(stat) ? 1 : (type = CoreFileSystemLibrary.isFolder(stat) ? 2 : 0);
        if (type == 0) {
            return null;
        }
        Resource target = this.getWorkspace().newResource(childPath, type);
        return this.createNode(target, stat, location, childName, false);
    }

    protected UnifiedTreeNode createNodeFromFileSystem(IPath path, String location, String localName) throws CoreException {
        long stat = CoreFileSystemLibrary.getStat(location);
        UnifiedTreeNode node = this.createNode(null, stat, location, localName, false);
        int type = node.isFile() ? 1 : 2;
        Resource target = this.getWorkspace().newResource(path, type);
        node.setResource(target);
        return node;
    }

    protected UnifiedTreeNode createNode(IResource resource, long stat, String localLocation, String localName, boolean existsWorkspace) {
        UnifiedTreeNode node = null;
        int size = this.freeNodes.size();
        if (size > 0) {
            node = (UnifiedTreeNode)this.freeNodes.remove(size - 1);
            node.reuse(this, resource, stat, localLocation, localName, existsWorkspace);
            return node;
        }
        return new UnifiedTreeNode(this, resource, stat, localLocation, localName, existsWorkspace);
    }

    protected Enumeration getChildren(UnifiedTreeNode node) throws CoreException {
        UnifiedTreeNode child;
        if (node.getFirstChild() == null) {
            this.addNodeChildrenToQueue(node);
        }
        if (node.getFirstChild() == null) {
            return EmptyEnumeration.getEnumeration();
        }
        int index = this.queue.indexOf(node.getFirstChild());
        if (index == -1) {
            return EmptyEnumeration.getEnumeration();
        }
        ArrayList<UnifiedTreeNode> result = new ArrayList<UnifiedTreeNode>(10);
        while (!this.isChildrenMarker(child = (UnifiedTreeNode)this.queue.elementAt(index))) {
            result.add(child);
            index = this.queue.increment(index);
        }
        return Collections.enumeration(result);
    }

    protected String getLocalLocation(IResource target) {
        if (this.rootLocalLocation == null) {
            return null;
        }
        int segments = target.getFullPath().matchingFirstSegments(this.root.getFullPath());
        return this.rootLocalLocation.append(target.getFullPath().removeFirstSegments(segments)).toOSString();
    }

    protected int getLevel() {
        return this.level;
    }

    protected Object[] getLocalList(UnifiedTreeNode node, String location) {
        if (node.isFile() || location == null) {
            return null;
        }
        Object[] list = new File(location).list();
        if (list == null) {
            return list;
        }
        int size = list.length;
        if (size > 1) {
            this.quickSort((String[])list, 0, size - 1);
        }
        return list;
    }

    protected Workspace getWorkspace() {
        return (Workspace)this.root.getWorkspace();
    }

    protected void initializeQueue() throws CoreException {
        if (this.queue == null) {
            this.queue = new Queue(100, false);
        } else {
            this.queue.reset();
        }
        if (this.freeNodes == null) {
            this.freeNodes = new ArrayList(100);
        } else {
            this.freeNodes.clear();
        }
        this.addRootToQueue();
        this.addElementToQueue(levelMarker);
    }

    protected boolean isChildrenMarker(UnifiedTreeNode node) {
        return node == childrenMarker;
    }

    protected boolean isLevelMarker(UnifiedTreeNode node) {
        return node == levelMarker;
    }

    protected boolean isValidLevel(int level, int depth) {
        switch (depth) {
            case 2: {
                return true;
            }
            case 1: {
                return level <= 1;
            }
            case 0: {
                return level == 0;
            }
        }
        return false;
    }

    protected void removeNodeChildrenFromQueue(UnifiedTreeNode node) throws CoreException {
        UnifiedTreeNode first = node.getFirstChild();
        if (first == null) {
            return;
        }
        while (!first.equals(this.queue.removeTail())) {
        }
        node.setFirstChild(null);
    }

    public void setRoot(IResource root) {
        this.root = root;
        this.rootLocalLocation = root.getLocation();
    }

    protected void quickSort(String[] strings, int left, int right) {
        int originalLeft = left;
        int originalRight = right;
        String mid = strings[(left + right) / 2];
        while (true) {
            if (mid.compareTo(strings[left]) > 0) {
                ++left;
                continue;
            }
            while (strings[right].compareTo(mid) > 0) {
                --right;
            }
            if (left <= right) {
                String tmp = strings[left];
                strings[left] = strings[right];
                strings[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (originalLeft < right) {
            this.quickSort(strings, originalLeft, right);
        }
        if (left < originalRight) {
            this.quickSort(strings, left, originalRight);
        }
    }
}

