/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Iterator;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.patterns.AndTypePattern;
import org.aspectj.weaver.patterns.AnyTypePattern;
import org.aspectj.weaver.patterns.BindingTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.EllipsisTypePattern;
import org.aspectj.weaver.patterns.ExactTypePattern;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.NoTypePattern;
import org.aspectj.weaver.patterns.NotTypePattern;
import org.aspectj.weaver.patterns.OrTypePattern;
import org.aspectj.weaver.patterns.PatternNode;
import org.aspectj.weaver.patterns.WildTypePattern;

public abstract class TypePattern
extends PatternNode {
    public static final MatchKind STATIC = new MatchKind("STATIC");
    public static final MatchKind DYNAMIC = new MatchKind("DYNAMIC");
    public static final TypePattern ELLIPSIS = new EllipsisTypePattern();
    public static final TypePattern ANY = new AnyTypePattern();
    public static final TypePattern NO = new NoTypePattern();
    protected boolean includeSubtypes;
    public static final byte WILD = 1;
    public static final byte EXACT = 2;
    public static final byte BINDING = 3;
    public static final byte ELLIPSIS_KEY = 4;
    public static final byte ANY_KEY = 5;
    public static final byte NOT = 6;
    public static final byte OR = 7;
    public static final byte AND = 8;
    public static final byte NO_KEY = 9;

    protected TypePattern(boolean includeSubtypes) {
        this.includeSubtypes = includeSubtypes;
    }

    public boolean matchesStatically(ResolvedTypeX type) {
        if (this.includeSubtypes) {
            return this.matchesSubtypes(type);
        }
        return this.matchesExactly(type);
    }

    public abstract FuzzyBoolean matchesInstanceof(ResolvedTypeX var1);

    public final FuzzyBoolean matches(ResolvedTypeX type, MatchKind kind) {
        if (type == ResolvedTypeX.MISSING) {
            return FuzzyBoolean.NO;
        }
        if (kind == STATIC) {
            return FuzzyBoolean.fromBoolean(this.matchesStatically(type));
        }
        if (kind == DYNAMIC) {
            FuzzyBoolean ret = this.matchesInstanceof(type);
            return ret;
        }
        throw new IllegalArgumentException("kind must be DYNAMIC or STATIC");
    }

    protected abstract boolean matchesExactly(ResolvedTypeX var1);

    protected boolean matchesSubtypes(ResolvedTypeX type) {
        if (this.matchesExactly(type)) {
            return true;
        }
        Iterator i = type.getDirectSupertypes();
        while (i.hasNext()) {
            ResolvedTypeX superType = (ResolvedTypeX)i.next();
            if (!this.matchesSubtypes(superType)) continue;
            return true;
        }
        return false;
    }

    public TypeX resolveExactType(IScope scope, Bindings bindings) {
        TypePattern p = this.resolveBindings(scope, bindings, false, true);
        if (p == NO) {
            return ResolvedTypeX.MISSING;
        }
        return ((ExactTypePattern)p).getType();
    }

    public TypeX getExactType() {
        if (this instanceof ExactTypePattern) {
            return ((ExactTypePattern)this).getType();
        }
        return ResolvedTypeX.MISSING;
    }

    protected TypePattern notExactType(IScope s) {
        s.getMessageHandler().handleMessage(MessageUtil.error("exact type pattern required", this.getSourceLocation()));
        return NO;
    }

    public TypePattern resolveBindings(IScope scope, Bindings bindings, boolean allowBinding, boolean requireExactType) {
        return this;
    }

    public void postRead(ResolvedTypeX enclosingType) {
    }

    public boolean isStar() {
        return false;
    }

    public TypePattern remapAdviceFormals(IntMap bindings) {
        return this;
    }

    public static TypePattern read(DataInputStream s, ISourceContext context) throws IOException {
        byte key = s.readByte();
        switch (key) {
            case 1: {
                return WildTypePattern.read(s, context);
            }
            case 2: {
                return ExactTypePattern.read(s, context);
            }
            case 3: {
                return BindingTypePattern.read(s, context);
            }
            case 4: {
                return ELLIPSIS;
            }
            case 5: {
                return ANY;
            }
            case 9: {
                return NO;
            }
            case 6: {
                return NotTypePattern.read(s, context);
            }
            case 7: {
                return OrTypePattern.read(s, context);
            }
            case 8: {
                return AndTypePattern.read(s, context);
            }
        }
        throw new BCException("unknown TypePattern kind: " + key);
    }

    public boolean isIncludeSubtypes() {
        return this.includeSubtypes;
    }

    public static class MatchKind {
        private String name;

        public MatchKind(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

