package purviewapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/purview/mgmt/2020-12-01-preview/purview"
	"github.com/Azure/go-autorest/autorest"
	"github.com/gofrs/uuid"
)

// AccountsClientAPI contains the set of methods on the AccountsClient type.
type AccountsClientAPI interface {
	CheckNameAvailability(ctx context.Context, checkNameAvailabilityRequest purview.CheckNameAvailabilityRequest) (result purview.CheckNameAvailabilityResult, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, accountName string, account purview.Account) (result purview.AccountsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, accountName string) (result purview.AccountsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, accountName string) (result purview.Account, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string, skipToken string) (result purview.AccountListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string, skipToken string) (result purview.AccountListIterator, err error)
	ListBySubscription(ctx context.Context, skipToken string) (result purview.AccountListPage, err error)
	ListBySubscriptionComplete(ctx context.Context, skipToken string) (result purview.AccountListIterator, err error)
	ListKeys(ctx context.Context, resourceGroupName string, accountName string) (result purview.AccessKeys, err error)
	Update(ctx context.Context, resourceGroupName string, accountName string, accountUpdateParameters purview.AccountUpdateParameters) (result purview.AccountsUpdateFuture, err error)
}

var _ AccountsClientAPI = (*purview.AccountsClient)(nil)

// DefaultAccountsClientAPI contains the set of methods on the DefaultAccountsClient type.
type DefaultAccountsClientAPI interface {
	Get(ctx context.Context, scopeTenantID uuid.UUID, scopeType purview.ScopeType, scope string) (result purview.DefaultAccountPayload, err error)
	Remove(ctx context.Context, scopeTenantID uuid.UUID, scopeType purview.ScopeType, scope string) (result autorest.Response, err error)
	Set(ctx context.Context, defaultAccountPayload purview.DefaultAccountPayload) (result purview.DefaultAccountPayload, err error)
}

var _ DefaultAccountsClientAPI = (*purview.DefaultAccountsClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result purview.OperationListPage, err error)
	ListComplete(ctx context.Context) (result purview.OperationListIterator, err error)
}

var _ OperationsClientAPI = (*purview.OperationsClient)(nil)

// PrivateEndpointConnectionsClientAPI contains the set of methods on the PrivateEndpointConnectionsClient type.
type PrivateEndpointConnectionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, accountName string, privateEndpointConnectionName string, request purview.PrivateEndpointConnection) (result purview.PrivateEndpointConnection, err error)
	Delete(ctx context.Context, resourceGroupName string, accountName string, privateEndpointConnectionName string) (result purview.PrivateEndpointConnectionsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, accountName string, privateEndpointConnectionName string) (result purview.PrivateEndpointConnection, err error)
	ListByAccount(ctx context.Context, resourceGroupName string, accountName string, skipToken string) (result purview.PrivateEndpointConnectionListPage, err error)
	ListByAccountComplete(ctx context.Context, resourceGroupName string, accountName string, skipToken string) (result purview.PrivateEndpointConnectionListIterator, err error)
}

var _ PrivateEndpointConnectionsClientAPI = (*purview.PrivateEndpointConnectionsClient)(nil)

// PrivateLinkResourcesClientAPI contains the set of methods on the PrivateLinkResourcesClient type.
type PrivateLinkResourcesClientAPI interface {
	GetByGroupID(ctx context.Context, resourceGroupName string, accountName string, groupID string) (result purview.PrivateLinkResource, err error)
	ListByAccount(ctx context.Context, resourceGroupName string, accountName string) (result purview.PrivateLinkResourceListPage, err error)
	ListByAccountComplete(ctx context.Context, resourceGroupName string, accountName string) (result purview.PrivateLinkResourceListIterator, err error)
}

var _ PrivateLinkResourcesClientAPI = (*purview.PrivateLinkResourcesClient)(nil)
