package devices

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/iothub/mgmt/2016-02-03/devices"

// CloudToDeviceProperties the IoT hub cloud-to-device messaging properties.
type CloudToDeviceProperties struct {
	// MaxDeliveryCount - The max delivery count for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
	MaxDeliveryCount *int32 `json:"maxDeliveryCount,omitempty"`
	// DefaultTTLAsIso8601 - The default time to live for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
	DefaultTTLAsIso8601 *string             `json:"defaultTtlAsIso8601,omitempty"`
	Feedback            *FeedbackProperties `json:"feedback,omitempty"`
}

// ErrorDetails error details.
type ErrorDetails struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"Code,omitempty"`
	// HTTPStatusCode - READ-ONLY; The HTTP status code.
	HTTPStatusCode *string `json:"HttpStatusCode,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"Message,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *string `json:"Details,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetails.
func (ed ErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// EventHubConsumerGroupInfo the properties of the EventHubConsumerGroupInfo object.
type EventHubConsumerGroupInfo struct {
	autorest.Response `json:"-"`
	// Tags - The tags.
	Tags map[string]*string `json:"tags"`
	// ID - The Event Hub-compatible consumer group identifier.
	ID *string `json:"id,omitempty"`
	// Name - The Event Hub-compatible consumer group name.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubConsumerGroupInfo.
func (ehcgi EventHubConsumerGroupInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ehcgi.Tags != nil {
		objectMap["tags"] = ehcgi.Tags
	}
	if ehcgi.ID != nil {
		objectMap["id"] = ehcgi.ID
	}
	if ehcgi.Name != nil {
		objectMap["name"] = ehcgi.Name
	}
	return json.Marshal(objectMap)
}

// EventHubConsumerGroupsListResult the JSON-serialized array of Event Hub-compatible consumer group names
// with a next link.
type EventHubConsumerGroupsListResult struct {
	autorest.Response `json:"-"`
	// Value - The array of Event Hub-compatible consumer group names.
	Value *[]string `json:"value,omitempty"`
	// NextLink - READ-ONLY; The next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubConsumerGroupsListResult.
func (ehcglr EventHubConsumerGroupsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ehcglr.Value != nil {
		objectMap["value"] = ehcglr.Value
	}
	return json.Marshal(objectMap)
}

// EventHubConsumerGroupsListResultIterator provides access to a complete listing of string values.
type EventHubConsumerGroupsListResultIterator struct {
	i    int
	page EventHubConsumerGroupsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EventHubConsumerGroupsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventHubConsumerGroupsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EventHubConsumerGroupsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EventHubConsumerGroupsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EventHubConsumerGroupsListResultIterator) Response() EventHubConsumerGroupsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EventHubConsumerGroupsListResultIterator) Value() string {
	if !iter.page.NotDone() {
		return ""
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EventHubConsumerGroupsListResultIterator type.
func NewEventHubConsumerGroupsListResultIterator(page EventHubConsumerGroupsListResultPage) EventHubConsumerGroupsListResultIterator {
	return EventHubConsumerGroupsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ehcglr EventHubConsumerGroupsListResult) IsEmpty() bool {
	return ehcglr.Value == nil || len(*ehcglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ehcglr EventHubConsumerGroupsListResult) hasNextLink() bool {
	return ehcglr.NextLink != nil && len(*ehcglr.NextLink) != 0
}

// eventHubConsumerGroupsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ehcglr EventHubConsumerGroupsListResult) eventHubConsumerGroupsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ehcglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ehcglr.NextLink)))
}

// EventHubConsumerGroupsListResultPage contains a page of string values.
type EventHubConsumerGroupsListResultPage struct {
	fn     func(context.Context, EventHubConsumerGroupsListResult) (EventHubConsumerGroupsListResult, error)
	ehcglr EventHubConsumerGroupsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EventHubConsumerGroupsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventHubConsumerGroupsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ehcglr)
		if err != nil {
			return err
		}
		page.ehcglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EventHubConsumerGroupsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EventHubConsumerGroupsListResultPage) NotDone() bool {
	return !page.ehcglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EventHubConsumerGroupsListResultPage) Response() EventHubConsumerGroupsListResult {
	return page.ehcglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EventHubConsumerGroupsListResultPage) Values() []string {
	if page.ehcglr.IsEmpty() {
		return nil
	}
	return *page.ehcglr.Value
}

// Creates a new instance of the EventHubConsumerGroupsListResultPage type.
func NewEventHubConsumerGroupsListResultPage(cur EventHubConsumerGroupsListResult, getNextPage func(context.Context, EventHubConsumerGroupsListResult) (EventHubConsumerGroupsListResult, error)) EventHubConsumerGroupsListResultPage {
	return EventHubConsumerGroupsListResultPage{
		fn:     getNextPage,
		ehcglr: cur,
	}
}

// EventHubProperties the properties of the provisioned Event Hub-compatible endpoint used by the IoT hub.
type EventHubProperties struct {
	// RetentionTimeInDays - The retention time for device-to-cloud messages in days. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages
	RetentionTimeInDays *int64 `json:"retentionTimeInDays,omitempty"`
	// PartitionCount - The number of partitions for receiving device-to-cloud messages in the Event Hub-compatible endpoint. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
	PartitionCount *int32 `json:"partitionCount,omitempty"`
	// PartitionIds - READ-ONLY; The partition ids in the Event Hub-compatible endpoint.
	PartitionIds *[]string `json:"partitionIds,omitempty"`
	// Path - READ-ONLY; The Event Hub-compatible name.
	Path *string `json:"path,omitempty"`
	// Endpoint - READ-ONLY; The Event Hub-compatible endpoint.
	Endpoint *string `json:"endpoint,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubProperties.
func (ehp EventHubProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ehp.RetentionTimeInDays != nil {
		objectMap["retentionTimeInDays"] = ehp.RetentionTimeInDays
	}
	if ehp.PartitionCount != nil {
		objectMap["partitionCount"] = ehp.PartitionCount
	}
	return json.Marshal(objectMap)
}

// ExportDevicesRequest use to provide parameters when requesting an export of all devices in the IoT hub.
type ExportDevicesRequest struct {
	// ExportBlobContainerURI - The export blob container URI.
	ExportBlobContainerURI *string `json:"ExportBlobContainerUri,omitempty"`
	// ExcludeKeys - The value indicating whether keys should be excluded during export.
	ExcludeKeys *bool `json:"ExcludeKeys,omitempty"`
}

// FeedbackProperties the properties of the feedback queue for cloud-to-device messages.
type FeedbackProperties struct {
	// LockDurationAsIso8601 - The lock duration for the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
	LockDurationAsIso8601 *string `json:"lockDurationAsIso8601,omitempty"`
	// TTLAsIso8601 - The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
	TTLAsIso8601 *string `json:"ttlAsIso8601,omitempty"`
	// MaxDeliveryCount - The number of times the IoT hub attempts to deliver a message on the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
	MaxDeliveryCount *int32 `json:"maxDeliveryCount,omitempty"`
}

// ImportDevicesRequest use to provide parameters when requesting an import of all devices in the hub.
type ImportDevicesRequest struct {
	// InputBlobContainerURI - The input blob container URI.
	InputBlobContainerURI *string `json:"InputBlobContainerUri,omitempty"`
	// OutputBlobContainerURI - The output blob container URI.
	OutputBlobContainerURI *string `json:"OutputBlobContainerUri,omitempty"`
}

// IotHubCapacity ioT Hub capacity information.
type IotHubCapacity struct {
	// Minimum - READ-ONLY; The minimum number of units.
	Minimum *int64 `json:"minimum,omitempty"`
	// Maximum - READ-ONLY; The maximum number of units.
	Maximum *int64 `json:"maximum,omitempty"`
	// Default - READ-ONLY; The default number of units.
	Default *int64 `json:"default,omitempty"`
	// ScaleType - READ-ONLY; The type of the scaling enabled. Possible values include: 'IotHubScaleTypeAutomatic', 'IotHubScaleTypeManual', 'IotHubScaleTypeNone'
	ScaleType IotHubScaleType `json:"scaleType,omitempty"`
}

// MarshalJSON is the custom marshaler for IotHubCapacity.
func (ihc IotHubCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// IotHubDescription the description of the IoT hub.
type IotHubDescription struct {
	autorest.Response `json:"-"`
	// Subscriptionid - The subscription identifier.
	Subscriptionid *string `json:"subscriptionid,omitempty"`
	// Resourcegroup - The name of the resource group that contains the IoT hub. A resource group name uniquely identifies the resource group within the subscription.
	Resourcegroup *string `json:"resourcegroup,omitempty"`
	// Etag - The Etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal ETag convention.
	Etag       *string           `json:"etag,omitempty"`
	Properties *IotHubProperties `json:"properties,omitempty"`
	Sku        *IotHubSkuInfo    `json:"sku,omitempty"`
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for IotHubDescription.
func (ihd IotHubDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ihd.Subscriptionid != nil {
		objectMap["subscriptionid"] = ihd.Subscriptionid
	}
	if ihd.Resourcegroup != nil {
		objectMap["resourcegroup"] = ihd.Resourcegroup
	}
	if ihd.Etag != nil {
		objectMap["etag"] = ihd.Etag
	}
	if ihd.Properties != nil {
		objectMap["properties"] = ihd.Properties
	}
	if ihd.Sku != nil {
		objectMap["sku"] = ihd.Sku
	}
	if ihd.Location != nil {
		objectMap["location"] = ihd.Location
	}
	if ihd.Tags != nil {
		objectMap["tags"] = ihd.Tags
	}
	return json.Marshal(objectMap)
}

// IotHubDescriptionListResult the JSON-serialized array of IotHubDescription objects with a next link.
type IotHubDescriptionListResult struct {
	autorest.Response `json:"-"`
	// Value - The array of IotHubDescription objects.
	Value *[]IotHubDescription `json:"value,omitempty"`
	// NextLink - READ-ONLY; The next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for IotHubDescriptionListResult.
func (ihdlr IotHubDescriptionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ihdlr.Value != nil {
		objectMap["value"] = ihdlr.Value
	}
	return json.Marshal(objectMap)
}

// IotHubDescriptionListResultIterator provides access to a complete listing of IotHubDescription values.
type IotHubDescriptionListResultIterator struct {
	i    int
	page IotHubDescriptionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IotHubDescriptionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotHubDescriptionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IotHubDescriptionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IotHubDescriptionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IotHubDescriptionListResultIterator) Response() IotHubDescriptionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IotHubDescriptionListResultIterator) Value() IotHubDescription {
	if !iter.page.NotDone() {
		return IotHubDescription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IotHubDescriptionListResultIterator type.
func NewIotHubDescriptionListResultIterator(page IotHubDescriptionListResultPage) IotHubDescriptionListResultIterator {
	return IotHubDescriptionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ihdlr IotHubDescriptionListResult) IsEmpty() bool {
	return ihdlr.Value == nil || len(*ihdlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ihdlr IotHubDescriptionListResult) hasNextLink() bool {
	return ihdlr.NextLink != nil && len(*ihdlr.NextLink) != 0
}

// iotHubDescriptionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ihdlr IotHubDescriptionListResult) iotHubDescriptionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ihdlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ihdlr.NextLink)))
}

// IotHubDescriptionListResultPage contains a page of IotHubDescription values.
type IotHubDescriptionListResultPage struct {
	fn    func(context.Context, IotHubDescriptionListResult) (IotHubDescriptionListResult, error)
	ihdlr IotHubDescriptionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IotHubDescriptionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotHubDescriptionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ihdlr)
		if err != nil {
			return err
		}
		page.ihdlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IotHubDescriptionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IotHubDescriptionListResultPage) NotDone() bool {
	return !page.ihdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IotHubDescriptionListResultPage) Response() IotHubDescriptionListResult {
	return page.ihdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IotHubDescriptionListResultPage) Values() []IotHubDescription {
	if page.ihdlr.IsEmpty() {
		return nil
	}
	return *page.ihdlr.Value
}

// Creates a new instance of the IotHubDescriptionListResultPage type.
func NewIotHubDescriptionListResultPage(cur IotHubDescriptionListResult, getNextPage func(context.Context, IotHubDescriptionListResult) (IotHubDescriptionListResult, error)) IotHubDescriptionListResultPage {
	return IotHubDescriptionListResultPage{
		fn:    getNextPage,
		ihdlr: cur,
	}
}

// IotHubNameAvailabilityInfo the properties indicating whether a given IoT hub name is available.
type IotHubNameAvailabilityInfo struct {
	autorest.Response `json:"-"`
	// NameAvailable - READ-ONLY; The value which indicates whether the provided name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - READ-ONLY; The reason for unavailability. Possible values include: 'Invalid', 'AlreadyExists'
	Reason IotHubNameUnavailabilityReason `json:"reason,omitempty"`
	// Message - The detailed reason message.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for IotHubNameAvailabilityInfo.
func (ihnai IotHubNameAvailabilityInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ihnai.Message != nil {
		objectMap["message"] = ihnai.Message
	}
	return json.Marshal(objectMap)
}

// IotHubProperties the properties of an IoT hub.
type IotHubProperties struct {
	// AuthorizationPolicies - The shared access policies you can use to secure a connection to the IoT hub.
	AuthorizationPolicies *[]SharedAccessSignatureAuthorizationRule `json:"authorizationPolicies,omitempty"`
	// IPFilterRules - The IP filter rules.
	IPFilterRules *[]IPFilterRule `json:"ipFilterRules,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// HostName - READ-ONLY; The name of the host.
	HostName *string `json:"hostName,omitempty"`
	// EventHubEndpoints - The Event Hub-compatible endpoint properties. The possible keys to this dictionary are events and operationsMonitoringEvents. Both of these keys have to be present in the dictionary while making create or update calls for the IoT hub.
	EventHubEndpoints map[string]*EventHubProperties `json:"eventHubEndpoints"`
	// StorageEndpoints - The list of Azure Storage endpoints where you can upload files. Currently you can configure only one Azure Storage account and that MUST have its key as $default. Specifying more than one storage account causes an error to be thrown. Not specifying a value for this property when the enableFileUploadNotifications property is set to True, causes an error to be thrown.
	StorageEndpoints map[string]*StorageEndpointProperties `json:"storageEndpoints"`
	// MessagingEndpoints - The messaging endpoint properties for the file upload notification queue.
	MessagingEndpoints map[string]*MessagingEndpointProperties `json:"messagingEndpoints"`
	// EnableFileUploadNotifications - If True, file upload notifications are enabled.
	EnableFileUploadNotifications *bool                    `json:"enableFileUploadNotifications,omitempty"`
	CloudToDevice                 *CloudToDeviceProperties `json:"cloudToDevice,omitempty"`
	// Comments - Comments.
	Comments                       *string                         `json:"comments,omitempty"`
	OperationsMonitoringProperties *OperationsMonitoringProperties `json:"operationsMonitoringProperties,omitempty"`
	// Features - The capabilities and features enabled for the IoT hub. Possible values include: 'None', 'DeviceManagement'
	Features Capabilities `json:"features,omitempty"`
}

// MarshalJSON is the custom marshaler for IotHubProperties.
func (ihp IotHubProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ihp.AuthorizationPolicies != nil {
		objectMap["authorizationPolicies"] = ihp.AuthorizationPolicies
	}
	if ihp.IPFilterRules != nil {
		objectMap["ipFilterRules"] = ihp.IPFilterRules
	}
	if ihp.EventHubEndpoints != nil {
		objectMap["eventHubEndpoints"] = ihp.EventHubEndpoints
	}
	if ihp.StorageEndpoints != nil {
		objectMap["storageEndpoints"] = ihp.StorageEndpoints
	}
	if ihp.MessagingEndpoints != nil {
		objectMap["messagingEndpoints"] = ihp.MessagingEndpoints
	}
	if ihp.EnableFileUploadNotifications != nil {
		objectMap["enableFileUploadNotifications"] = ihp.EnableFileUploadNotifications
	}
	if ihp.CloudToDevice != nil {
		objectMap["cloudToDevice"] = ihp.CloudToDevice
	}
	if ihp.Comments != nil {
		objectMap["comments"] = ihp.Comments
	}
	if ihp.OperationsMonitoringProperties != nil {
		objectMap["operationsMonitoringProperties"] = ihp.OperationsMonitoringProperties
	}
	if ihp.Features != "" {
		objectMap["features"] = ihp.Features
	}
	return json.Marshal(objectMap)
}

// IotHubQuotaMetricInfo quota metrics properties.
type IotHubQuotaMetricInfo struct {
	// Name - READ-ONLY; The name of the quota metric.
	Name *string `json:"Name,omitempty"`
	// CurrentValue - READ-ONLY; The current value for the quota metric.
	CurrentValue *int64 `json:"CurrentValue,omitempty"`
	// MaxValue - READ-ONLY; The maximum value of the quota metric.
	MaxValue *int64 `json:"MaxValue,omitempty"`
}

// MarshalJSON is the custom marshaler for IotHubQuotaMetricInfo.
func (ihqmi IotHubQuotaMetricInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// IotHubQuotaMetricInfoListResult the JSON-serialized array of IotHubQuotaMetricInfo objects with a next
// link.
type IotHubQuotaMetricInfoListResult struct {
	autorest.Response `json:"-"`
	// Value - The array of quota metrics objects.
	Value *[]IotHubQuotaMetricInfo `json:"value,omitempty"`
	// NextLink - READ-ONLY; The next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for IotHubQuotaMetricInfoListResult.
func (ihqmilr IotHubQuotaMetricInfoListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ihqmilr.Value != nil {
		objectMap["value"] = ihqmilr.Value
	}
	return json.Marshal(objectMap)
}

// IotHubQuotaMetricInfoListResultIterator provides access to a complete listing of IotHubQuotaMetricInfo
// values.
type IotHubQuotaMetricInfoListResultIterator struct {
	i    int
	page IotHubQuotaMetricInfoListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IotHubQuotaMetricInfoListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotHubQuotaMetricInfoListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IotHubQuotaMetricInfoListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IotHubQuotaMetricInfoListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IotHubQuotaMetricInfoListResultIterator) Response() IotHubQuotaMetricInfoListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IotHubQuotaMetricInfoListResultIterator) Value() IotHubQuotaMetricInfo {
	if !iter.page.NotDone() {
		return IotHubQuotaMetricInfo{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IotHubQuotaMetricInfoListResultIterator type.
func NewIotHubQuotaMetricInfoListResultIterator(page IotHubQuotaMetricInfoListResultPage) IotHubQuotaMetricInfoListResultIterator {
	return IotHubQuotaMetricInfoListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ihqmilr IotHubQuotaMetricInfoListResult) IsEmpty() bool {
	return ihqmilr.Value == nil || len(*ihqmilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ihqmilr IotHubQuotaMetricInfoListResult) hasNextLink() bool {
	return ihqmilr.NextLink != nil && len(*ihqmilr.NextLink) != 0
}

// iotHubQuotaMetricInfoListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ihqmilr IotHubQuotaMetricInfoListResult) iotHubQuotaMetricInfoListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ihqmilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ihqmilr.NextLink)))
}

// IotHubQuotaMetricInfoListResultPage contains a page of IotHubQuotaMetricInfo values.
type IotHubQuotaMetricInfoListResultPage struct {
	fn      func(context.Context, IotHubQuotaMetricInfoListResult) (IotHubQuotaMetricInfoListResult, error)
	ihqmilr IotHubQuotaMetricInfoListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IotHubQuotaMetricInfoListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotHubQuotaMetricInfoListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ihqmilr)
		if err != nil {
			return err
		}
		page.ihqmilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IotHubQuotaMetricInfoListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IotHubQuotaMetricInfoListResultPage) NotDone() bool {
	return !page.ihqmilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IotHubQuotaMetricInfoListResultPage) Response() IotHubQuotaMetricInfoListResult {
	return page.ihqmilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IotHubQuotaMetricInfoListResultPage) Values() []IotHubQuotaMetricInfo {
	if page.ihqmilr.IsEmpty() {
		return nil
	}
	return *page.ihqmilr.Value
}

// Creates a new instance of the IotHubQuotaMetricInfoListResultPage type.
func NewIotHubQuotaMetricInfoListResultPage(cur IotHubQuotaMetricInfoListResult, getNextPage func(context.Context, IotHubQuotaMetricInfoListResult) (IotHubQuotaMetricInfoListResult, error)) IotHubQuotaMetricInfoListResultPage {
	return IotHubQuotaMetricInfoListResultPage{
		fn:      getNextPage,
		ihqmilr: cur,
	}
}

// IotHubResourceCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type IotHubResourceCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IotHubResourceClient) (IotHubDescription, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *IotHubResourceCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for IotHubResourceCreateOrUpdateFuture.Result.
func (future *IotHubResourceCreateOrUpdateFuture) result(client IotHubResourceClient) (ihd IotHubDescription, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ihd.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("devices.IotHubResourceCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ihd.Response.Response, err = future.GetResult(sender); err == nil && ihd.Response.Response.StatusCode != http.StatusNoContent {
		ihd, err = client.CreateOrUpdateResponder(ihd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "devices.IotHubResourceCreateOrUpdateFuture", "Result", ihd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IotHubResourceDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type IotHubResourceDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(IotHubResourceClient) (SetObject, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *IotHubResourceDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for IotHubResourceDeleteFuture.Result.
func (future *IotHubResourceDeleteFuture) result(client IotHubResourceClient) (so SetObject, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		so.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("devices.IotHubResourceDeleteFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if so.Response.Response, err = future.GetResult(sender); err == nil && so.Response.Response.StatusCode != http.StatusNoContent {
		so, err = client.DeleteResponder(so.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "devices.IotHubResourceDeleteFuture", "Result", so.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IotHubSkuDescription SKU properties.
type IotHubSkuDescription struct {
	// ResourceType - READ-ONLY; The type of the resource.
	ResourceType *string         `json:"resourceType,omitempty"`
	Sku          *IotHubSkuInfo  `json:"sku,omitempty"`
	Capacity     *IotHubCapacity `json:"capacity,omitempty"`
}

// MarshalJSON is the custom marshaler for IotHubSkuDescription.
func (ihsd IotHubSkuDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ihsd.Sku != nil {
		objectMap["sku"] = ihsd.Sku
	}
	if ihsd.Capacity != nil {
		objectMap["capacity"] = ihsd.Capacity
	}
	return json.Marshal(objectMap)
}

// IotHubSkuDescriptionListResult the JSON-serialized array of IotHubSkuDescription objects with a next
// link.
type IotHubSkuDescriptionListResult struct {
	autorest.Response `json:"-"`
	// Value - The array of IotHubSkuDescription.
	Value *[]IotHubSkuDescription `json:"value,omitempty"`
	// NextLink - READ-ONLY; The next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for IotHubSkuDescriptionListResult.
func (ihsdlr IotHubSkuDescriptionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ihsdlr.Value != nil {
		objectMap["value"] = ihsdlr.Value
	}
	return json.Marshal(objectMap)
}

// IotHubSkuDescriptionListResultIterator provides access to a complete listing of IotHubSkuDescription
// values.
type IotHubSkuDescriptionListResultIterator struct {
	i    int
	page IotHubSkuDescriptionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IotHubSkuDescriptionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotHubSkuDescriptionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IotHubSkuDescriptionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IotHubSkuDescriptionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IotHubSkuDescriptionListResultIterator) Response() IotHubSkuDescriptionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IotHubSkuDescriptionListResultIterator) Value() IotHubSkuDescription {
	if !iter.page.NotDone() {
		return IotHubSkuDescription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IotHubSkuDescriptionListResultIterator type.
func NewIotHubSkuDescriptionListResultIterator(page IotHubSkuDescriptionListResultPage) IotHubSkuDescriptionListResultIterator {
	return IotHubSkuDescriptionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ihsdlr IotHubSkuDescriptionListResult) IsEmpty() bool {
	return ihsdlr.Value == nil || len(*ihsdlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ihsdlr IotHubSkuDescriptionListResult) hasNextLink() bool {
	return ihsdlr.NextLink != nil && len(*ihsdlr.NextLink) != 0
}

// iotHubSkuDescriptionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ihsdlr IotHubSkuDescriptionListResult) iotHubSkuDescriptionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ihsdlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ihsdlr.NextLink)))
}

// IotHubSkuDescriptionListResultPage contains a page of IotHubSkuDescription values.
type IotHubSkuDescriptionListResultPage struct {
	fn     func(context.Context, IotHubSkuDescriptionListResult) (IotHubSkuDescriptionListResult, error)
	ihsdlr IotHubSkuDescriptionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IotHubSkuDescriptionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotHubSkuDescriptionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ihsdlr)
		if err != nil {
			return err
		}
		page.ihsdlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IotHubSkuDescriptionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IotHubSkuDescriptionListResultPage) NotDone() bool {
	return !page.ihsdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IotHubSkuDescriptionListResultPage) Response() IotHubSkuDescriptionListResult {
	return page.ihsdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IotHubSkuDescriptionListResultPage) Values() []IotHubSkuDescription {
	if page.ihsdlr.IsEmpty() {
		return nil
	}
	return *page.ihsdlr.Value
}

// Creates a new instance of the IotHubSkuDescriptionListResultPage type.
func NewIotHubSkuDescriptionListResultPage(cur IotHubSkuDescriptionListResult, getNextPage func(context.Context, IotHubSkuDescriptionListResult) (IotHubSkuDescriptionListResult, error)) IotHubSkuDescriptionListResultPage {
	return IotHubSkuDescriptionListResultPage{
		fn:     getNextPage,
		ihsdlr: cur,
	}
}

// IotHubSkuInfo information about the SKU of the IoT hub.
type IotHubSkuInfo struct {
	// Name - The name of the SKU. Possible values include: 'F1', 'S1', 'S2', 'S3'
	Name IotHubSku `json:"name,omitempty"`
	// Tier - READ-ONLY; The billing tier for the IoT hub. Possible values include: 'Free', 'Standard'
	Tier IotHubSkuTier `json:"tier,omitempty"`
	// Capacity - The number of provisioned IoT Hub units. See: https://docs.microsoft.com/azure/azure-subscription-service-limits#iot-hub-limits.
	Capacity *int64 `json:"capacity,omitempty"`
}

// MarshalJSON is the custom marshaler for IotHubSkuInfo.
func (ihsi IotHubSkuInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ihsi.Name != "" {
		objectMap["name"] = ihsi.Name
	}
	if ihsi.Capacity != nil {
		objectMap["capacity"] = ihsi.Capacity
	}
	return json.Marshal(objectMap)
}

// IPFilterRule the IP filter rules for the IoT hub.
type IPFilterRule struct {
	// FilterName - The name of the IP filter rule.
	FilterName *string `json:"filterName,omitempty"`
	// Action - The desired action for requests captured by this rule. Possible values include: 'Accept', 'Reject'
	Action IPFilterActionType `json:"action,omitempty"`
	// IPMask - A string that contains the IP address range in CIDR notation for the rule.
	IPMask *string `json:"ipMask,omitempty"`
}

// JobResponse the properties of the Job Response object.
type JobResponse struct {
	autorest.Response `json:"-"`
	// JobID - READ-ONLY; The job identifier.
	JobID *string `json:"jobId,omitempty"`
	// StartTimeUtc - READ-ONLY; The start time of the job.
	StartTimeUtc *date.TimeRFC1123 `json:"startTimeUtc,omitempty"`
	// EndTimeUtc - READ-ONLY; The time the job stopped processing.
	EndTimeUtc *date.TimeRFC1123 `json:"endTimeUtc,omitempty"`
	// Type - READ-ONLY; The type of the job. Possible values include: 'JobTypeUnknown', 'JobTypeExport', 'JobTypeImport', 'JobTypeBackup', 'JobTypeReadDeviceProperties', 'JobTypeWriteDeviceProperties', 'JobTypeUpdateDeviceConfiguration', 'JobTypeRebootDevice', 'JobTypeFactoryResetDevice', 'JobTypeFirmwareUpdate'
	Type JobType `json:"type,omitempty"`
	// Status - READ-ONLY; The status of the job. Possible values include: 'Unknown', 'Enqueued', 'Running', 'Completed', 'Failed', 'Cancelled'
	Status JobStatus `json:"status,omitempty"`
	// FailureReason - READ-ONLY; If status == failed, this string containing the reason for the failure.
	FailureReason *string `json:"failureReason,omitempty"`
	// StatusMessage - READ-ONLY; The status message for the job.
	StatusMessage *string `json:"statusMessage,omitempty"`
	// ParentJobID - READ-ONLY; The job identifier of the parent job, if any.
	ParentJobID *string `json:"parentJobId,omitempty"`
}

// MarshalJSON is the custom marshaler for JobResponse.
func (jr JobResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// JobResponseListResult the JSON-serialized array of JobResponse objects with a next link.
type JobResponseListResult struct {
	autorest.Response `json:"-"`
	// Value - The array of JobResponse objects.
	Value *[]JobResponse `json:"value,omitempty"`
	// NextLink - READ-ONLY; The next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for JobResponseListResult.
func (jrlr JobResponseListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jrlr.Value != nil {
		objectMap["value"] = jrlr.Value
	}
	return json.Marshal(objectMap)
}

// JobResponseListResultIterator provides access to a complete listing of JobResponse values.
type JobResponseListResultIterator struct {
	i    int
	page JobResponseListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobResponseListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobResponseListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobResponseListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobResponseListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobResponseListResultIterator) Response() JobResponseListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobResponseListResultIterator) Value() JobResponse {
	if !iter.page.NotDone() {
		return JobResponse{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobResponseListResultIterator type.
func NewJobResponseListResultIterator(page JobResponseListResultPage) JobResponseListResultIterator {
	return JobResponseListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jrlr JobResponseListResult) IsEmpty() bool {
	return jrlr.Value == nil || len(*jrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jrlr JobResponseListResult) hasNextLink() bool {
	return jrlr.NextLink != nil && len(*jrlr.NextLink) != 0
}

// jobResponseListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jrlr JobResponseListResult) jobResponseListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !jrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jrlr.NextLink)))
}

// JobResponseListResultPage contains a page of JobResponse values.
type JobResponseListResultPage struct {
	fn   func(context.Context, JobResponseListResult) (JobResponseListResult, error)
	jrlr JobResponseListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobResponseListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobResponseListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jrlr)
		if err != nil {
			return err
		}
		page.jrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobResponseListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobResponseListResultPage) NotDone() bool {
	return !page.jrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobResponseListResultPage) Response() JobResponseListResult {
	return page.jrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobResponseListResultPage) Values() []JobResponse {
	if page.jrlr.IsEmpty() {
		return nil
	}
	return *page.jrlr.Value
}

// Creates a new instance of the JobResponseListResultPage type.
func NewJobResponseListResultPage(cur JobResponseListResult, getNextPage func(context.Context, JobResponseListResult) (JobResponseListResult, error)) JobResponseListResultPage {
	return JobResponseListResultPage{
		fn:   getNextPage,
		jrlr: cur,
	}
}

// MessagingEndpointProperties the properties of the messaging endpoints used by this IoT hub.
type MessagingEndpointProperties struct {
	// LockDurationAsIso8601 - The lock duration. See: https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-file-upload.
	LockDurationAsIso8601 *string `json:"lockDurationAsIso8601,omitempty"`
	// TTLAsIso8601 - The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-file-upload.
	TTLAsIso8601 *string `json:"ttlAsIso8601,omitempty"`
	// MaxDeliveryCount - The number of times the IoT hub attempts to deliver a message. See: https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-file-upload.
	MaxDeliveryCount *int32 `json:"maxDeliveryCount,omitempty"`
}

// OperationInputs input values.
type OperationInputs struct {
	// Name - The name of the IoT hub to check.
	Name *string `json:"Name,omitempty"`
}

// OperationsMonitoringProperties the operations monitoring properties for the IoT hub. The possible keys
// to the dictionary are Connections, DeviceTelemetry, C2DCommands, DeviceIdentityOperations,
// FileUploadOperations.
type OperationsMonitoringProperties struct {
	Events map[string]*OperationMonitoringLevel `json:"events"`
}

// MarshalJSON is the custom marshaler for OperationsMonitoringProperties.
func (omp OperationsMonitoringProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if omp.Events != nil {
		objectMap["events"] = omp.Events
	}
	return json.Marshal(objectMap)
}

// RegistryStatistics identity registry statistics.
type RegistryStatistics struct {
	autorest.Response `json:"-"`
	// TotalDeviceCount - READ-ONLY; The total count of devices in the identity registry.
	TotalDeviceCount *int64 `json:"totalDeviceCount,omitempty"`
	// EnabledDeviceCount - READ-ONLY; The count of enabled devices in the identity registry.
	EnabledDeviceCount *int64 `json:"enabledDeviceCount,omitempty"`
	// DisabledDeviceCount - READ-ONLY; The count of disabled devices in the identity registry.
	DisabledDeviceCount *int64 `json:"disabledDeviceCount,omitempty"`
}

// MarshalJSON is the custom marshaler for RegistryStatistics.
func (rs RegistryStatistics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Resource the common properties of an Azure resource.
type Resource struct {
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// SetObject ...
type SetObject struct {
	autorest.Response `json:"-"`
	Value             interface{} `json:"value,omitempty"`
}

// SharedAccessSignatureAuthorizationRule the properties of an IoT hub shared access policy.
type SharedAccessSignatureAuthorizationRule struct {
	autorest.Response `json:"-"`
	// KeyName - The name of the shared access policy.
	KeyName *string `json:"keyName,omitempty"`
	// PrimaryKey - The primary key.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - The secondary key.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// Rights - The permissions assigned to the shared access policy. Possible values include: 'RegistryRead', 'RegistryWrite', 'ServiceConnect', 'DeviceConnect', 'RegistryReadRegistryWrite', 'RegistryReadServiceConnect', 'RegistryReadDeviceConnect', 'RegistryWriteServiceConnect', 'RegistryWriteDeviceConnect', 'ServiceConnectDeviceConnect', 'RegistryReadRegistryWriteServiceConnect', 'RegistryReadRegistryWriteDeviceConnect', 'RegistryReadServiceConnectDeviceConnect', 'RegistryWriteServiceConnectDeviceConnect', 'RegistryReadRegistryWriteServiceConnectDeviceConnect'
	Rights AccessRights `json:"rights,omitempty"`
}

// SharedAccessSignatureAuthorizationRuleListResult the list of shared access policies with a next link.
type SharedAccessSignatureAuthorizationRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of shared access policies.
	Value *[]SharedAccessSignatureAuthorizationRule `json:"value,omitempty"`
	// NextLink - READ-ONLY; The next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SharedAccessSignatureAuthorizationRuleListResult.
func (sasarlr SharedAccessSignatureAuthorizationRuleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sasarlr.Value != nil {
		objectMap["value"] = sasarlr.Value
	}
	return json.Marshal(objectMap)
}

// SharedAccessSignatureAuthorizationRuleListResultIterator provides access to a complete listing of
// SharedAccessSignatureAuthorizationRule values.
type SharedAccessSignatureAuthorizationRuleListResultIterator struct {
	i    int
	page SharedAccessSignatureAuthorizationRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SharedAccessSignatureAuthorizationRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SharedAccessSignatureAuthorizationRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SharedAccessSignatureAuthorizationRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SharedAccessSignatureAuthorizationRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SharedAccessSignatureAuthorizationRuleListResultIterator) Response() SharedAccessSignatureAuthorizationRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SharedAccessSignatureAuthorizationRuleListResultIterator) Value() SharedAccessSignatureAuthorizationRule {
	if !iter.page.NotDone() {
		return SharedAccessSignatureAuthorizationRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SharedAccessSignatureAuthorizationRuleListResultIterator type.
func NewSharedAccessSignatureAuthorizationRuleListResultIterator(page SharedAccessSignatureAuthorizationRuleListResultPage) SharedAccessSignatureAuthorizationRuleListResultIterator {
	return SharedAccessSignatureAuthorizationRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sasarlr SharedAccessSignatureAuthorizationRuleListResult) IsEmpty() bool {
	return sasarlr.Value == nil || len(*sasarlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sasarlr SharedAccessSignatureAuthorizationRuleListResult) hasNextLink() bool {
	return sasarlr.NextLink != nil && len(*sasarlr.NextLink) != 0
}

// sharedAccessSignatureAuthorizationRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sasarlr SharedAccessSignatureAuthorizationRuleListResult) sharedAccessSignatureAuthorizationRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sasarlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sasarlr.NextLink)))
}

// SharedAccessSignatureAuthorizationRuleListResultPage contains a page of
// SharedAccessSignatureAuthorizationRule values.
type SharedAccessSignatureAuthorizationRuleListResultPage struct {
	fn      func(context.Context, SharedAccessSignatureAuthorizationRuleListResult) (SharedAccessSignatureAuthorizationRuleListResult, error)
	sasarlr SharedAccessSignatureAuthorizationRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SharedAccessSignatureAuthorizationRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SharedAccessSignatureAuthorizationRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sasarlr)
		if err != nil {
			return err
		}
		page.sasarlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SharedAccessSignatureAuthorizationRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SharedAccessSignatureAuthorizationRuleListResultPage) NotDone() bool {
	return !page.sasarlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SharedAccessSignatureAuthorizationRuleListResultPage) Response() SharedAccessSignatureAuthorizationRuleListResult {
	return page.sasarlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SharedAccessSignatureAuthorizationRuleListResultPage) Values() []SharedAccessSignatureAuthorizationRule {
	if page.sasarlr.IsEmpty() {
		return nil
	}
	return *page.sasarlr.Value
}

// Creates a new instance of the SharedAccessSignatureAuthorizationRuleListResultPage type.
func NewSharedAccessSignatureAuthorizationRuleListResultPage(cur SharedAccessSignatureAuthorizationRuleListResult, getNextPage func(context.Context, SharedAccessSignatureAuthorizationRuleListResult) (SharedAccessSignatureAuthorizationRuleListResult, error)) SharedAccessSignatureAuthorizationRuleListResultPage {
	return SharedAccessSignatureAuthorizationRuleListResultPage{
		fn:      getNextPage,
		sasarlr: cur,
	}
}

// StorageEndpointProperties the properties of the Azure Storage endpoint for file upload.
type StorageEndpointProperties struct {
	// SasTTLAsIso8601 - The period of time for which the SAS URI generated by IoT Hub for file upload is valid. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload#file-upload-notification-configuration-options.
	SasTTLAsIso8601 *string `json:"sasTtlAsIso8601,omitempty"`
	// ConnectionString - The connection string for the Azure Storage account to which files are uploaded.
	ConnectionString *string `json:"connectionString,omitempty"`
	// ContainerName - The name of the root container where you upload files. The container need not exist but should be creatable using the connectionString specified.
	ContainerName *string `json:"containerName,omitempty"`
}
