//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package servicebus

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/servicebus/mgmt/2021-06-01-preview/servicebus"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AccessRights = original.AccessRights

const (
	AccessRightsListen AccessRights = original.AccessRightsListen
	AccessRightsManage AccessRights = original.AccessRightsManage
	AccessRightsSend   AccessRights = original.AccessRightsSend
)

type CreatedByType = original.CreatedByType

const (
	CreatedByTypeApplication     CreatedByType = original.CreatedByTypeApplication
	CreatedByTypeKey             CreatedByType = original.CreatedByTypeKey
	CreatedByTypeManagedIdentity CreatedByType = original.CreatedByTypeManagedIdentity
	CreatedByTypeUser            CreatedByType = original.CreatedByTypeUser
)

type DefaultAction = original.DefaultAction

const (
	DefaultActionAllow DefaultAction = original.DefaultActionAllow
	DefaultActionDeny  DefaultAction = original.DefaultActionDeny
)

type EndPointProvisioningState = original.EndPointProvisioningState

const (
	EndPointProvisioningStateCanceled  EndPointProvisioningState = original.EndPointProvisioningStateCanceled
	EndPointProvisioningStateCreating  EndPointProvisioningState = original.EndPointProvisioningStateCreating
	EndPointProvisioningStateDeleting  EndPointProvisioningState = original.EndPointProvisioningStateDeleting
	EndPointProvisioningStateFailed    EndPointProvisioningState = original.EndPointProvisioningStateFailed
	EndPointProvisioningStateSucceeded EndPointProvisioningState = original.EndPointProvisioningStateSucceeded
	EndPointProvisioningStateUpdating  EndPointProvisioningState = original.EndPointProvisioningStateUpdating
)

type EntityStatus = original.EntityStatus

const (
	EntityStatusActive          EntityStatus = original.EntityStatusActive
	EntityStatusCreating        EntityStatus = original.EntityStatusCreating
	EntityStatusDeleting        EntityStatus = original.EntityStatusDeleting
	EntityStatusDisabled        EntityStatus = original.EntityStatusDisabled
	EntityStatusReceiveDisabled EntityStatus = original.EntityStatusReceiveDisabled
	EntityStatusRenaming        EntityStatus = original.EntityStatusRenaming
	EntityStatusRestoring       EntityStatus = original.EntityStatusRestoring
	EntityStatusSendDisabled    EntityStatus = original.EntityStatusSendDisabled
	EntityStatusUnknown         EntityStatus = original.EntityStatusUnknown
)

type FilterType = original.FilterType

const (
	FilterTypeCorrelationFilter FilterType = original.FilterTypeCorrelationFilter
	FilterTypeSQLFilter         FilterType = original.FilterTypeSQLFilter
)

type KeySource = original.KeySource

const (
	KeySourceMicrosoftKeyVault KeySource = original.KeySourceMicrosoftKeyVault
)

type KeyType = original.KeyType

const (
	KeyTypePrimaryKey   KeyType = original.KeyTypePrimaryKey
	KeyTypeSecondaryKey KeyType = original.KeyTypeSecondaryKey
)

type ManagedServiceIdentityType = original.ManagedServiceIdentityType

const (
	ManagedServiceIdentityTypeNone                       ManagedServiceIdentityType = original.ManagedServiceIdentityTypeNone
	ManagedServiceIdentityTypeSystemAssigned             ManagedServiceIdentityType = original.ManagedServiceIdentityTypeSystemAssigned
	ManagedServiceIdentityTypeSystemAssignedUserAssigned ManagedServiceIdentityType = original.ManagedServiceIdentityTypeSystemAssignedUserAssigned
	ManagedServiceIdentityTypeUserAssigned               ManagedServiceIdentityType = original.ManagedServiceIdentityTypeUserAssigned
)

type NetworkRuleIPAction = original.NetworkRuleIPAction

const (
	NetworkRuleIPActionAllow NetworkRuleIPAction = original.NetworkRuleIPActionAllow
)

type PrivateLinkConnectionStatus = original.PrivateLinkConnectionStatus

const (
	PrivateLinkConnectionStatusApproved     PrivateLinkConnectionStatus = original.PrivateLinkConnectionStatusApproved
	PrivateLinkConnectionStatusDisconnected PrivateLinkConnectionStatus = original.PrivateLinkConnectionStatusDisconnected
	PrivateLinkConnectionStatusPending      PrivateLinkConnectionStatus = original.PrivateLinkConnectionStatusPending
	PrivateLinkConnectionStatusRejected     PrivateLinkConnectionStatus = original.PrivateLinkConnectionStatusRejected
)

type ProvisioningStateDR = original.ProvisioningStateDR

const (
	ProvisioningStateDRAccepted  ProvisioningStateDR = original.ProvisioningStateDRAccepted
	ProvisioningStateDRFailed    ProvisioningStateDR = original.ProvisioningStateDRFailed
	ProvisioningStateDRSucceeded ProvisioningStateDR = original.ProvisioningStateDRSucceeded
)

type PublicNetworkAccessFlag = original.PublicNetworkAccessFlag

const (
	PublicNetworkAccessFlagDisabled PublicNetworkAccessFlag = original.PublicNetworkAccessFlagDisabled
	PublicNetworkAccessFlagEnabled  PublicNetworkAccessFlag = original.PublicNetworkAccessFlagEnabled
)

type RoleDisasterRecovery = original.RoleDisasterRecovery

const (
	RoleDisasterRecoveryPrimary               RoleDisasterRecovery = original.RoleDisasterRecoveryPrimary
	RoleDisasterRecoveryPrimaryNotReplicating RoleDisasterRecovery = original.RoleDisasterRecoveryPrimaryNotReplicating
	RoleDisasterRecoverySecondary             RoleDisasterRecovery = original.RoleDisasterRecoverySecondary
)

type SkuName = original.SkuName

const (
	SkuNameBasic    SkuName = original.SkuNameBasic
	SkuNamePremium  SkuName = original.SkuNamePremium
	SkuNameStandard SkuName = original.SkuNameStandard
)

type SkuTier = original.SkuTier

const (
	SkuTierBasic    SkuTier = original.SkuTierBasic
	SkuTierPremium  SkuTier = original.SkuTierPremium
	SkuTierStandard SkuTier = original.SkuTierStandard
)

type UnavailableReason = original.UnavailableReason

const (
	UnavailableReasonInvalidName                           UnavailableReason = original.UnavailableReasonInvalidName
	UnavailableReasonNameInLockdown                        UnavailableReason = original.UnavailableReasonNameInLockdown
	UnavailableReasonNameInUse                             UnavailableReason = original.UnavailableReasonNameInUse
	UnavailableReasonNone                                  UnavailableReason = original.UnavailableReasonNone
	UnavailableReasonSubscriptionIsDisabled                UnavailableReason = original.UnavailableReasonSubscriptionIsDisabled
	UnavailableReasonTooManyNamespaceInCurrentSubscription UnavailableReason = original.UnavailableReasonTooManyNamespaceInCurrentSubscription
)

type AccessKeys = original.AccessKeys
type Action = original.Action
type ArmDisasterRecovery = original.ArmDisasterRecovery
type ArmDisasterRecoveryListResult = original.ArmDisasterRecoveryListResult
type ArmDisasterRecoveryListResultIterator = original.ArmDisasterRecoveryListResultIterator
type ArmDisasterRecoveryListResultPage = original.ArmDisasterRecoveryListResultPage
type ArmDisasterRecoveryProperties = original.ArmDisasterRecoveryProperties
type BaseClient = original.BaseClient
type CheckNameAvailability = original.CheckNameAvailability
type CheckNameAvailabilityResult = original.CheckNameAvailabilityResult
type ConnectionState = original.ConnectionState
type CorrelationFilter = original.CorrelationFilter
type DisasterRecoveryConfigsClient = original.DisasterRecoveryConfigsClient
type Encryption = original.Encryption
type ErrorAdditionalInfo = original.ErrorAdditionalInfo
type ErrorResponse = original.ErrorResponse
type ErrorResponseError = original.ErrorResponseError
type FailoverProperties = original.FailoverProperties
type FailoverPropertiesProperties = original.FailoverPropertiesProperties
type Identity = original.Identity
type KeyVaultProperties = original.KeyVaultProperties
type MessageCountDetails = original.MessageCountDetails
type MigrationConfigListResult = original.MigrationConfigListResult
type MigrationConfigListResultIterator = original.MigrationConfigListResultIterator
type MigrationConfigListResultPage = original.MigrationConfigListResultPage
type MigrationConfigProperties = original.MigrationConfigProperties
type MigrationConfigPropertiesProperties = original.MigrationConfigPropertiesProperties
type MigrationConfigsClient = original.MigrationConfigsClient
type MigrationConfigsCreateAndStartMigrationFuture = original.MigrationConfigsCreateAndStartMigrationFuture
type NWRuleSetIPRules = original.NWRuleSetIPRules
type NWRuleSetVirtualNetworkRules = original.NWRuleSetVirtualNetworkRules
type NamespacesClient = original.NamespacesClient
type NamespacesCreateOrUpdateFuture = original.NamespacesCreateOrUpdateFuture
type NamespacesDeleteFuture = original.NamespacesDeleteFuture
type NetworkRuleSet = original.NetworkRuleSet
type NetworkRuleSetListResult = original.NetworkRuleSetListResult
type NetworkRuleSetListResultIterator = original.NetworkRuleSetListResultIterator
type NetworkRuleSetListResultPage = original.NetworkRuleSetListResultPage
type NetworkRuleSetProperties = original.NetworkRuleSetProperties
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationsClient = original.OperationsClient
type PrivateEndpoint = original.PrivateEndpoint
type PrivateEndpointConnection = original.PrivateEndpointConnection
type PrivateEndpointConnectionListResult = original.PrivateEndpointConnectionListResult
type PrivateEndpointConnectionListResultIterator = original.PrivateEndpointConnectionListResultIterator
type PrivateEndpointConnectionListResultPage = original.PrivateEndpointConnectionListResultPage
type PrivateEndpointConnectionProperties = original.PrivateEndpointConnectionProperties
type PrivateEndpointConnectionsClient = original.PrivateEndpointConnectionsClient
type PrivateEndpointConnectionsDeleteFuture = original.PrivateEndpointConnectionsDeleteFuture
type PrivateLinkResource = original.PrivateLinkResource
type PrivateLinkResourceProperties = original.PrivateLinkResourceProperties
type PrivateLinkResourcesClient = original.PrivateLinkResourcesClient
type PrivateLinkResourcesListResult = original.PrivateLinkResourcesListResult
type QueuesClient = original.QueuesClient
type RegenerateAccessKeyParameters = original.RegenerateAccessKeyParameters
type Resource = original.Resource
type ResourceNamespacePatch = original.ResourceNamespacePatch
type Rule = original.Rule
type RuleListResult = original.RuleListResult
type RuleListResultIterator = original.RuleListResultIterator
type RuleListResultPage = original.RuleListResultPage
type Ruleproperties = original.Ruleproperties
type RulesClient = original.RulesClient
type SBAuthorizationRule = original.SBAuthorizationRule
type SBAuthorizationRuleListResult = original.SBAuthorizationRuleListResult
type SBAuthorizationRuleListResultIterator = original.SBAuthorizationRuleListResultIterator
type SBAuthorizationRuleListResultPage = original.SBAuthorizationRuleListResultPage
type SBAuthorizationRuleProperties = original.SBAuthorizationRuleProperties
type SBClientAffineProperties = original.SBClientAffineProperties
type SBNamespace = original.SBNamespace
type SBNamespaceListResult = original.SBNamespaceListResult
type SBNamespaceListResultIterator = original.SBNamespaceListResultIterator
type SBNamespaceListResultPage = original.SBNamespaceListResultPage
type SBNamespaceProperties = original.SBNamespaceProperties
type SBNamespaceUpdateParameters = original.SBNamespaceUpdateParameters
type SBQueue = original.SBQueue
type SBQueueListResult = original.SBQueueListResult
type SBQueueListResultIterator = original.SBQueueListResultIterator
type SBQueueListResultPage = original.SBQueueListResultPage
type SBQueueProperties = original.SBQueueProperties
type SBSku = original.SBSku
type SBSubscription = original.SBSubscription
type SBSubscriptionListResult = original.SBSubscriptionListResult
type SBSubscriptionListResultIterator = original.SBSubscriptionListResultIterator
type SBSubscriptionListResultPage = original.SBSubscriptionListResultPage
type SBSubscriptionProperties = original.SBSubscriptionProperties
type SBTopic = original.SBTopic
type SBTopicListResult = original.SBTopicListResult
type SBTopicListResultIterator = original.SBTopicListResultIterator
type SBTopicListResultPage = original.SBTopicListResultPage
type SBTopicProperties = original.SBTopicProperties
type SQLFilter = original.SQLFilter
type SQLRuleAction = original.SQLRuleAction
type Subnet = original.Subnet
type SubscriptionsClient = original.SubscriptionsClient
type SystemData = original.SystemData
type TopicsClient = original.TopicsClient
type TrackedResource = original.TrackedResource
type UserAssignedIdentity = original.UserAssignedIdentity
type UserAssignedIdentityProperties = original.UserAssignedIdentityProperties

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewArmDisasterRecoveryListResultIterator(page ArmDisasterRecoveryListResultPage) ArmDisasterRecoveryListResultIterator {
	return original.NewArmDisasterRecoveryListResultIterator(page)
}
func NewArmDisasterRecoveryListResultPage(cur ArmDisasterRecoveryListResult, getNextPage func(context.Context, ArmDisasterRecoveryListResult) (ArmDisasterRecoveryListResult, error)) ArmDisasterRecoveryListResultPage {
	return original.NewArmDisasterRecoveryListResultPage(cur, getNextPage)
}
func NewDisasterRecoveryConfigsClient(subscriptionID string) DisasterRecoveryConfigsClient {
	return original.NewDisasterRecoveryConfigsClient(subscriptionID)
}
func NewDisasterRecoveryConfigsClientWithBaseURI(baseURI string, subscriptionID string) DisasterRecoveryConfigsClient {
	return original.NewDisasterRecoveryConfigsClientWithBaseURI(baseURI, subscriptionID)
}
func NewMigrationConfigListResultIterator(page MigrationConfigListResultPage) MigrationConfigListResultIterator {
	return original.NewMigrationConfigListResultIterator(page)
}
func NewMigrationConfigListResultPage(cur MigrationConfigListResult, getNextPage func(context.Context, MigrationConfigListResult) (MigrationConfigListResult, error)) MigrationConfigListResultPage {
	return original.NewMigrationConfigListResultPage(cur, getNextPage)
}
func NewMigrationConfigsClient(subscriptionID string) MigrationConfigsClient {
	return original.NewMigrationConfigsClient(subscriptionID)
}
func NewMigrationConfigsClientWithBaseURI(baseURI string, subscriptionID string) MigrationConfigsClient {
	return original.NewMigrationConfigsClientWithBaseURI(baseURI, subscriptionID)
}
func NewNamespacesClient(subscriptionID string) NamespacesClient {
	return original.NewNamespacesClient(subscriptionID)
}
func NewNamespacesClientWithBaseURI(baseURI string, subscriptionID string) NamespacesClient {
	return original.NewNamespacesClientWithBaseURI(baseURI, subscriptionID)
}
func NewNetworkRuleSetListResultIterator(page NetworkRuleSetListResultPage) NetworkRuleSetListResultIterator {
	return original.NewNetworkRuleSetListResultIterator(page)
}
func NewNetworkRuleSetListResultPage(cur NetworkRuleSetListResult, getNextPage func(context.Context, NetworkRuleSetListResult) (NetworkRuleSetListResult, error)) NetworkRuleSetListResultPage {
	return original.NewNetworkRuleSetListResultPage(cur, getNextPage)
}
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return original.NewOperationListResultIterator(page)
}
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return original.NewOperationListResultPage(cur, getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateEndpointConnectionListResultIterator(page PrivateEndpointConnectionListResultPage) PrivateEndpointConnectionListResultIterator {
	return original.NewPrivateEndpointConnectionListResultIterator(page)
}
func NewPrivateEndpointConnectionListResultPage(cur PrivateEndpointConnectionListResult, getNextPage func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)) PrivateEndpointConnectionListResultPage {
	return original.NewPrivateEndpointConnectionListResultPage(cur, getNextPage)
}
func NewPrivateEndpointConnectionsClient(subscriptionID string) PrivateEndpointConnectionsClient {
	return original.NewPrivateEndpointConnectionsClient(subscriptionID)
}
func NewPrivateEndpointConnectionsClientWithBaseURI(baseURI string, subscriptionID string) PrivateEndpointConnectionsClient {
	return original.NewPrivateEndpointConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateLinkResourcesClient(subscriptionID string) PrivateLinkResourcesClient {
	return original.NewPrivateLinkResourcesClient(subscriptionID)
}
func NewPrivateLinkResourcesClientWithBaseURI(baseURI string, subscriptionID string) PrivateLinkResourcesClient {
	return original.NewPrivateLinkResourcesClientWithBaseURI(baseURI, subscriptionID)
}
func NewQueuesClient(subscriptionID string) QueuesClient {
	return original.NewQueuesClient(subscriptionID)
}
func NewQueuesClientWithBaseURI(baseURI string, subscriptionID string) QueuesClient {
	return original.NewQueuesClientWithBaseURI(baseURI, subscriptionID)
}
func NewRuleListResultIterator(page RuleListResultPage) RuleListResultIterator {
	return original.NewRuleListResultIterator(page)
}
func NewRuleListResultPage(cur RuleListResult, getNextPage func(context.Context, RuleListResult) (RuleListResult, error)) RuleListResultPage {
	return original.NewRuleListResultPage(cur, getNextPage)
}
func NewRulesClient(subscriptionID string) RulesClient {
	return original.NewRulesClient(subscriptionID)
}
func NewRulesClientWithBaseURI(baseURI string, subscriptionID string) RulesClient {
	return original.NewRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSBAuthorizationRuleListResultIterator(page SBAuthorizationRuleListResultPage) SBAuthorizationRuleListResultIterator {
	return original.NewSBAuthorizationRuleListResultIterator(page)
}
func NewSBAuthorizationRuleListResultPage(cur SBAuthorizationRuleListResult, getNextPage func(context.Context, SBAuthorizationRuleListResult) (SBAuthorizationRuleListResult, error)) SBAuthorizationRuleListResultPage {
	return original.NewSBAuthorizationRuleListResultPage(cur, getNextPage)
}
func NewSBNamespaceListResultIterator(page SBNamespaceListResultPage) SBNamespaceListResultIterator {
	return original.NewSBNamespaceListResultIterator(page)
}
func NewSBNamespaceListResultPage(cur SBNamespaceListResult, getNextPage func(context.Context, SBNamespaceListResult) (SBNamespaceListResult, error)) SBNamespaceListResultPage {
	return original.NewSBNamespaceListResultPage(cur, getNextPage)
}
func NewSBQueueListResultIterator(page SBQueueListResultPage) SBQueueListResultIterator {
	return original.NewSBQueueListResultIterator(page)
}
func NewSBQueueListResultPage(cur SBQueueListResult, getNextPage func(context.Context, SBQueueListResult) (SBQueueListResult, error)) SBQueueListResultPage {
	return original.NewSBQueueListResultPage(cur, getNextPage)
}
func NewSBSubscriptionListResultIterator(page SBSubscriptionListResultPage) SBSubscriptionListResultIterator {
	return original.NewSBSubscriptionListResultIterator(page)
}
func NewSBSubscriptionListResultPage(cur SBSubscriptionListResult, getNextPage func(context.Context, SBSubscriptionListResult) (SBSubscriptionListResult, error)) SBSubscriptionListResultPage {
	return original.NewSBSubscriptionListResultPage(cur, getNextPage)
}
func NewSBTopicListResultIterator(page SBTopicListResultPage) SBTopicListResultIterator {
	return original.NewSBTopicListResultIterator(page)
}
func NewSBTopicListResultPage(cur SBTopicListResult, getNextPage func(context.Context, SBTopicListResult) (SBTopicListResult, error)) SBTopicListResultPage {
	return original.NewSBTopicListResultPage(cur, getNextPage)
}
func NewSubscriptionsClient(subscriptionID string) SubscriptionsClient {
	return original.NewSubscriptionsClient(subscriptionID)
}
func NewSubscriptionsClientWithBaseURI(baseURI string, subscriptionID string) SubscriptionsClient {
	return original.NewSubscriptionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewTopicsClient(subscriptionID string) TopicsClient {
	return original.NewTopicsClient(subscriptionID)
}
func NewTopicsClientWithBaseURI(baseURI string, subscriptionID string) TopicsClient {
	return original.NewTopicsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAccessRightsValues() []AccessRights {
	return original.PossibleAccessRightsValues()
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleDefaultActionValues() []DefaultAction {
	return original.PossibleDefaultActionValues()
}
func PossibleEndPointProvisioningStateValues() []EndPointProvisioningState {
	return original.PossibleEndPointProvisioningStateValues()
}
func PossibleEntityStatusValues() []EntityStatus {
	return original.PossibleEntityStatusValues()
}
func PossibleFilterTypeValues() []FilterType {
	return original.PossibleFilterTypeValues()
}
func PossibleKeySourceValues() []KeySource {
	return original.PossibleKeySourceValues()
}
func PossibleKeyTypeValues() []KeyType {
	return original.PossibleKeyTypeValues()
}
func PossibleManagedServiceIdentityTypeValues() []ManagedServiceIdentityType {
	return original.PossibleManagedServiceIdentityTypeValues()
}
func PossibleNetworkRuleIPActionValues() []NetworkRuleIPAction {
	return original.PossibleNetworkRuleIPActionValues()
}
func PossiblePrivateLinkConnectionStatusValues() []PrivateLinkConnectionStatus {
	return original.PossiblePrivateLinkConnectionStatusValues()
}
func PossibleProvisioningStateDRValues() []ProvisioningStateDR {
	return original.PossibleProvisioningStateDRValues()
}
func PossiblePublicNetworkAccessFlagValues() []PublicNetworkAccessFlag {
	return original.PossiblePublicNetworkAccessFlagValues()
}
func PossibleRoleDisasterRecoveryValues() []RoleDisasterRecovery {
	return original.PossibleRoleDisasterRecoveryValues()
}
func PossibleSkuNameValues() []SkuName {
	return original.PossibleSkuNameValues()
}
func PossibleSkuTierValues() []SkuTier {
	return original.PossibleSkuTierValues()
}
func PossibleUnavailableReasonValues() []UnavailableReason {
	return original.PossibleUnavailableReasonValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
