// Emacs style mode select   -*- C++ -*-f
//-----------------------------------------------------------------------------
//
// $Id: info.c 1746 2025-04-10 09:37:38Z wesleyjohnson $
//
// Copyright (C) 1993-1996 by id Software, Inc.
// Portions Copyright (C) 1998-2016 by DooM Legacy Team.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
//
// $Log: info.c,v $
// Revision 1.12  2004/07/27 08:19:35  exl
// New fmod, fs functions, bugfix or 2, patrol nodes
//
// Revision 1.11  2001/03/30 17:12:49  bpereira
// no message
//
// Revision 1.10  2001/03/13 22:14:19  stroggonmeth
// Long time no commit. 3D floors, FraggleScript, portals, ect.
//
// Revision 1.9  2001/01/25 22:15:42  bpereira
// added heretic support
//
// Revision 1.8  2000/11/02 17:50:06  stroggonmeth
// Big 3Dfloors & FraggleScript commit!!
//
// Revision 1.7  2000/10/21 08:43:29  bpereira
// Revision 1.6  2000/08/31 14:30:55  bpereira
//
// Revision 1.5  2000/04/11 19:07:23  stroggonmeth
// Finished my logs, fixed a crashing bug.
//
// Revision 1.4  2000/04/09 02:30:56  stroggonmeth
// Fixed missing sprite def
//
// Revision 1.3  2000/04/04 00:32:45  stroggonmeth
// Initial Boom compatability plus few misc changes all around.
//
// Revision 1.2  2000/02/27 00:42:10  hurdler
// Revision 1.1.1.1  2000/02/22 20:32:33  hurdler
// Initial import into CVS (v1.29 pr3)
//
//
// DESCRIPTION:
//      Thing frame/state LUT,
//      generated by multigen utilitiy.
//      This one is the original DOOM version, preserved.
//
//-----------------------------------------------------------------------------

// Data.
#include "doomincl.h"
#include "d_items.h"
#include "p_mobj.h"
#include "m_fixed.h"
#include "sounds.h"
#include "action.h"



char *sprnames[NUMSPRITES_DEF+1] = {
// Doom
    "TROO","SHTG","PUNG","PISG","PISF","SHTF","SHT2","CHGG","CHGF","MISG",
    "MISF","SAWG","PLSG","PLSF","BFGG","BFGF","BLUD","PUFF","BAL1","BAL2",
    "PLSS","PLSE","MISL","BFS1","BFE1","BFE2","TFOG","IFOG","PLAY","POSS",
    "SPOS","VILE","FIRE","FATB","FBXP","SKEL","MANF","FATT","CPOS","SARG",
    "HEAD","BAL7","BOSS","BOS2","SKUL","SPID","BSPI","APLS","APBX","CYBR",
    "PAIN","SSWV","KEEN","BBRN","BOSF","ARM1","ARM2","BAR1","BEXP","FCAN",
    "BON1","BON2","BKEY","RKEY","YKEY","BSKU","RSKU","YSKU","STIM","MEDI",
    "SOUL","PINV","PSTR","PINS","MEGA","SUIT","PMAP","PVIS","CLIP","AMMO",
    "ROCK","BROK","CELL","CELP","SHEL","SBOX","BPAK","BFUG","MGUN","CSAW",
    "LAUN","PLAS","SHOT","SGN2","COLU","SMT2","GOR1","POL2","POL5","POL4",
    "POL3","POL1","POL6","GOR2","GOR3","GOR4","GOR5","SMIT","COL1","COL2",
    "COL3","COL4","CAND","CBRA","COL6","TRE1","TRE2","ELEC","CEYE","FSKU",
    "COL5","TBLU","TGRN","TRED","SMBT","SMGT","SMRT","HDB1","HDB2","HDB3",
    "HDB4","HDB5","HDB6","POB1","POB2","BRS1","TLMP","TLP2","SMOK","SPLA",
    "TNT1", //SoM: 4/8/2000: INVISIBLE SPRITE!
// Heretic
    "IMPX","ACLO","PTN1","SHLD","SHD2","BAGH","SPMP","INVS","PTN2","SOAR",
    "INVU","PWBK","EGGC","EGGM","FX01","SPHL","TRCH","FBMB","XPL1","ATLP",
    "PPOD","AMG1","SPSH","LVAS","SLDG","SKH1","SKH2","SKH3","SKH4","CHDL",
    "SRTC","SMPL","STGS","STGL","STCS","STCL","KFR1","BARL","BRPL","MOS1",
    "MOS2","WTRH","HCOR","KGZ1","KGZB","KGZG","KGZY","VLCO","VFBL","VTFB",
    "SFFI","TGLT","TELE","STFF","PUF3","PUF4","BEAK","WGNT","GAUN","PUF1",
    "WBLS","BLSR","FX18","FX17","WMCE","MACE","FX02","WSKL","HROD","FX00",
    "FX20","FX21","FX22","FX23","GWND","PUF2","WPHX","PHNX","FX04","FX08",
    "FX09","WBOW","CRBW","FX03",/*"BLOD","PLAY",*/"FDTH","BSKL","CHKN","MUMM",
    "FX15","BEAS","FRB1","SNKE","SNFX","HEAD","FX05","FX06","FX07","CLNK",
    "WZRD","FX11","FX10","KNIG","SPAX","RAXE","SRCR","FX14","SOR2","SDTH",
    "FX16","MNTR","FX12","FX13","AKYY","BKYY","CKYY","AMG2","AMM1","AMM2",
    "AMC1","AMC2","AMS1","AMS2","AMP1","AMP2","AMB1","AMB2",
// MBF
#ifdef DOGS
    "DOGS", // MBF
#endif
    "SPR0", "SPR1", "SPR2", "SPR3",  // May get used in future

    NULL /* shit! 19990907 by Kin */
};



// Indexed by action_e [ AI_acp1_start to AI_acp1_end ]
// actor actions, acp1, A_func(mobj_t *)
actionf_p1  action_acp1_table[ AI_acp1_end - AI_acp1_start ] =
{
// Doom acp1,
  A_FaceTarget,
  A_Look,
  A_Chase,
  A_Pain,
  A_Fall,
  A_XScream,
  A_Scream,
  A_PlayerScream,
  A_BFGSpray,
  A_Explode,
  A_PosAttack,
  A_SPosAttack,
  A_VileChase,
  A_VileStart,
  A_VileTarget,
  A_VileAttack,
  A_StartFire,
  A_Fire,
  A_FireCrackle,
  A_Tracer,
  A_SkelWhoosh,
  A_SkelFist,
  A_SkelMissile,
  A_FatRaise,
  A_FatAttack1,
  A_FatAttack2,
  A_FatAttack3,
  A_BossDeath,
  A_CPosAttack,
  A_CPosRefire,
  A_TroopAttack,
  A_SargAttack,
  A_HeadAttack,
  A_BruisAttack,
  A_SkullAttack,
  A_Metal,
  A_SpidRefire,
  A_BabyMetal,
  A_BspiAttack,
  A_Hoof,
  A_CyberAttack,
  A_PainAttack,
  A_PainDie,
  A_KeenDie,
  A_BrainPain,
  A_BrainScream,
  A_BrainDie,
  A_BrainAwake,
  A_BrainSpit,
  A_SpawnSound,
  A_SpawnFly,
  A_BrainExplode,

// Legacy extentions    
  A_SmokeTrailer,  // p_fab
  A_StartFS,       // Exl: Toxicfluff's FS actions

// [WDJ] MBF function ptrs, from MBF, EternityEngine.
  A_Detonate_MBF,  // Radius damage, variable damage
  A_Mushroom_MBF,  // Mushroom explosion
  A_Die_MBF,  // MBF, kill an object
  A_Spawn_MBF,  // SpawnMobj(x,y, parm2, parm1-1)
  A_Turn_MBF,  // Turn by parm1 degrees
  A_Face_MBF,  // Turn to face parm1 degrees
  A_Scratch_MBF,  // Melee attack
  A_PlaySound_MBF,  // Play Sound parm1
  A_RandomJump_MBF,  // Random transition to mobj state parm1
  A_LineEffect_MBF,  // Trigger line type parm1, tag = parm2
  A_KeepChasing_MBF,  // MBF, from EnternityEngine
   
#ifdef MBF21
  A_SpawnObject_MBF21,  // Spawn object
  A_MonsterProjectile_MBF21,  // Monster projectile attack
  A_MonsterBulletAttack_MBF21,  // Monster bullet attack
  A_MonsterMeleeAttack_MBF21,  // Monster melee attack
  A_NoiseAlert_MBF21,  // Alert nearby monsters
  A_HealChase_MBF21,  // Heal monster
  A_SeekTracer_MBF21,  // Seeker missile
  A_ClearTracer_MBF21,  // Clear target
  A_FindTracer_MBF21,  // Find target
  A_RadiusDamage_MBF21,
  A_JumpIfHealthBelow_MBF21,  // To state, if health below arg[1]
  A_JumpIfTargetInSight_MBF21,  // To state, if target in line-of-sight
  A_JumpIfTargetCloser_MBF21,  // To state, if target closer than args[1]
  A_JumpIfTracerInSight_MBF21,  // To state, if tracer in line-of-sight
  A_JumpIfTracerCloser_MBF21,  // To state, if target closer than args[1]
  A_JumpIfFlagsSet_MBF21,  // To state, if all arg thing flags are set
  A_AddFlags_MBF21,  // Set thing flags
  A_RemoveFlags_MBF21,  // Remove thing flags
#endif

#ifdef ETERNITY_ENGINE_BEX
// [WDJ] Code pointers that are BEX available in EternityEngine.
  A_Nailbomb,
#endif

#ifdef ETERNITY_ENGINE_GEN2
// haleyjd: start new eternity codeptrs
  A_StartScript,
  A_PlayerStartScript,
  A_SetFlags,
  A_UnSetFlags,
  A_BetaSkullAttack,
  A_GenRefire,
  A_FireGrenade,
  A_FireCustomBullets,
  A_FirePlayerMissile,
  A_CustomPlayerMelee,
  A_GenTracer,
  A_BFG11KHit,
  A_BouncingBFG,
  A_BFGBurst,
  A_FireOldBFG,
  A_Stop,
  A_PlayerThunk,
  A_MissileAttack,
  A_MissileSpread,
  A_BulletAttack,
  A_HealthJump,
  A_CounterJump,
  A_CounterSwitch,
  A_SetCounter,
  A_CopyCounter,
  A_CounterOp,
  A_SetTics,
  A_AproxDistance,
  A_ShowMessage,
  A_RandomWalk,
  A_TargetJump,
  A_ThingSummon,
  A_KillChildren,
  A_WeaponCtrJump,
  A_WeaponCtrSwitch,
  A_WeaponSetCtr,
  A_WeaponCopyCtr,
  A_WeaponCtrOp,
  A_AmbientThinker,
  A_SteamSpawn,
  A_EjectCasing,
  A_CasingThrust,
  A_JumpIfNoAmmo,
  A_CheckReloadEx,
#endif

#ifdef ETERNITY_ENGINE_NUKE_SPEC
// haleyjd 07/13/03: nuke specials
  A_PainNukeSpec,
  A_SorcNukeSpec,
#endif

// Heretic acp1
  A_MummyAttack,
  A_MummyAttack2,
  A_MummySoul,
  A_ImpMeAttack,
  A_ImpMsAttack,
  A_ImpMsAttack2,
//  A_ImpChargeAtk,
  A_ImpDeath,
  A_ImpXDeath1,
  A_ImpXDeath2,
  A_ImpExplode,
  A_ClinkAttack,
  A_BeastAttack,
  A_BeastPuff,
  A_MakePod,
  A_PodPain,
  A_RemovePod,
  A_KnightAttack,
  A_MinotaurDecide,
  A_MinotaurAtk1,
  A_MinotaurAtk2,
  A_MinotaurAtk3,
  A_MinotaurCharge,
  A_MntrFloorFire,
//  A_LichWhirlwind,
  A_HHeadAttack,   // LichAttack
  A_HeadIceImpact, // LichIceImpact
  A_HeadFireGrow,  // LichFireGrow
  A_GenWizard,
  A_WizAtk1,
  A_WizAtk2,
  A_WizAtk3,
  A_SorcererRise,
  A_SorSightSnd,
  A_SorRise,
  A_SorZap,
  A_Sor1Chase,
  A_Sor1Pain,
  A_Srcr1Attack,
  A_Srcr2Decide,
  A_Srcr2Attack,
  A_Sor2DthInit,
  A_Sor2DthLoop,
  A_SorDSph,
  A_SorDExp,
  A_SorDBon,
  A_SnakeAttack,
  A_SnakeAttack2,
  A_Feathers,
  A_ChicLook,
  A_ChicChase,
  A_ChicPain,
  A_ChicAttack,

  A_HScream,
  A_DripBlood,
  A_BlueSpark,
  A_VolcanoSet,
  A_VolcanoBlast,
  A_VolcBallImpact,

  A_FloatPuff,
  A_BoltSpark,
  A_PhoenixPuff,
  A_MacePL1Check,
  A_MaceBallImpact,
  A_MaceBallImpact2,
  A_DeathBallImpact,
  A_SkullRodPL2Seek,
  A_SkullRodStorm,
  A_SpawnRippers,
  A_AddPlayerRain,
  A_RainImpact,
  A_FlameSnd,
  A_FlameEnd,

  A_MummyFX1Seek,
  A_WhirlwindSeek,

  A_HBossDeath,
  A_FreeTargMobj,
  A_RestoreSpecialThing1,
  A_RestoreSpecialThing2,
  A_HideThing,
  A_UnHideThing,
  A_RestoreArtifact,
  A_InitKeyGizmo,
  A_SpawnTeleGlitter,
  A_SpawnTeleGlitter2,
  A_AccTeleGlitter,
  A_HideInCeiling,
  A_NoBlocking,
  A_AddPlayerCorpse,
  A_SkullPop,
  A_CheckBurnGone,
  A_CheckSkullFloor,
  A_CheckSkullDone,
  A_ContMobjSound,
  A_GhostOff,
//  A_PlayerSkull,
//  A_ClearSkin,

  A_ESound,

      
// haleyjd: Heretic pointers
#ifdef HERETIC_ETERNITY_ENGINE
// Unique to EternityEngine, parameterized.
  A_SpawnGlitter,
  A_AccelGlitter,
  A_SpawnAbove,
  A_HticDrop,  // Deprecated
  A_HticTracer,  // parameterized
  A_HticExplode,
  A_HticBossDeath,
#endif
   
#ifdef HEXEN
// haleyjd 10/04/08: Hexen pointers
  A_SetInvulnerable,
  A_UnSetInvulnerable,
  A_SetReflective,
  A_UnSetReflective,
  A_PigLook,
  A_PigChase,
  A_PigAttack,
  A_PigPain,
  A_HexenExplode,
  A_SerpentUnHide,
  A_SerpentHide,
  A_SerpentChase,
  A_RaiseFloorClip,
  A_LowerFloorClip,
  A_SerpentHumpDecide,
  A_SerpentWalk,
  A_SerpentCheckForAttack,
  A_SerpentChooseAttack,
  A_SerpentMeleeAttack,
  A_SerpentMissileAttack,
  A_SerpentSpawnGibs,
  A_SubTics,
  A_SerpentHeadCheck,
  A_CentaurAttack,
  A_CentaurAttack2,
  A_DropEquipment,
  A_CentaurDefend,
  A_BishopAttack,
  A_BishopAttack2,
  A_BishopMissileWeave,
  A_BishopDoBlur,
  A_SpawnBlur,
  A_BishopChase,
  A_BishopPainBlur,
  A_DragonInitFlight,
  A_DragonFlight,
  A_DragonFlap,
  A_DragonFX2,
  A_PainCounterBEQ,
  A_DemonAttack1,
  A_DemonAttack2,
  A_DemonDeath,
  A_Demon2Death,
  A_WraithInit,
  A_WraithRaiseInit,
  A_WraithRaise,
  A_WraithMelee,
  A_WraithMissile,
  A_WraithFX2,
  A_WraithFX3,
  A_WraithFX4,
  A_WraithLook,
  A_WraithChase,
  A_EttinAttack,
  A_DropMace,
  A_AffritSpawnRock,
  A_AffritRocks,
  A_SmBounce,
  A_AffritChase,
  A_AffritSplotch,
  A_IceGuyLook,
  A_IceGuyChase,
  A_IceGuyAttack,
  A_IceGuyDie,
  A_IceGuyMissileExplode,
  A_CheckFloor,
  A_FreezeDeath,
  A_IceSetTics,
  A_IceCheckHeadDone,
  A_FreezeDeathChunks,
#endif

};

// Indexed by action_e [ AP_acp2_start to AP_acp2_end ]
// player weapon actions, acp2, A_func(player *, pspdef_t *)
actionf_p2  action_acp2_table[ AP_acp2_end - AP_acp2_start ] =
{
// Doom and Heretic    
  A_WeaponReady,
  A_Lower,
  A_Raise,
  A_ReFire,
// Doom acp2
  A_Punch,
  A_FirePistol,
  A_FireShotgun,
  A_FireShotgun2,
  A_CheckReload,
  A_OpenShotgun2,
  A_LoadShotgun2,
  A_CloseShotgun2,
  A_FireCGun,
  A_FireMissile,
  A_FirePlasma,
  A_BFGsound,
  A_FireBFG,
  A_Saw,
  A_GunFlash,
  A_Light0,
  A_Light1,
  A_Light2,
// Heretic acp2
  A_StaffAttackPL1,
  A_StaffAttackPL2,
  A_GauntletAttack,
  A_FireBlasterPL1,
  A_FireBlasterPL2,
  A_FireMacePL1,
//  A_FireMacePL1B,  // Not DEH accessible, not used in any state
  A_FireMacePL2,
  A_FireSkullRodPL1,
  A_FireSkullRodPL2,
  A_FireGoldWandPL1,
  A_FireGoldWandPL2,    
  A_FirePhoenixPL1,
  A_InitPhoenixPL2,
  A_FirePhoenixPL2,
  A_ShutdownPhoenixPL2,
  A_FireCrossbowPL1,
  A_FireCrossbowPL2,
  A_BeakReady,
  A_BeakRaise,
  A_BeakAttackPL1,
  A_BeakAttackPL2,
// Other acp2
//  A_TicWeapon,    // Not DEH accessible, Not used in any state
  A_StartWeaponFS,  // Used in S_DUMMY2
#ifdef MBF21    
// MBF21 acp2
  A_WeaponProjectile_MBF21,    
  A_WeaponBulletAttack_MBF21,
  A_WeaponMeleeAttack_MBF21,
  A_WeaponSound_MBF21,
  A_WeaponAlert_MBF21,
  A_WeaponJump_MBF21,
  A_ConsumeAmmo_MBF21,
  A_CheckAmmo_MBF21,
  A_RefireTo_MBF21,
  A_GunFlashTo_MBF21,
#endif
};


// Fab note : frame is masked through FF_FRAMEMASK
//            FF_FULLBRIGHT (0x8000) activates the fullbright colormap
//
#define FFB   FF_FULLBRIGHT

//  sprite,   frame,tics, action,         next,          ext_id
state_t states[NUMSTATES_EXT] =
{
// The S_NULL state is hardcoded as dead, used to stop.
  {SPR_TROO,    0, -1,AI_NULL,         S_NULL         }, // S_NULL
// Player weapon, functions are acp2 (player, psp)
  {SPR_SHTG,    4,  0,AP_Light0,       S_NULL         }, // S_LIGHTDONE
  {SPR_PUNG,    0,  1,AP_WeaponReady,  S_PUNCH        }, // S_PUNCH
  {SPR_PUNG,    0,  1,AP_Lower,        S_PUNCHDOWN    }, // S_PUNCHDOWN
  {SPR_PUNG,    0,  1,AP_Raise,        S_PUNCHUP      }, // S_PUNCHUP
  {SPR_PUNG,    1,  4,AI_NULL,         S_PUNCH2       }, // S_PUNCH1
  {SPR_PUNG,    2,  4,AP_Punch,        S_PUNCH3       }, // S_PUNCH2
  {SPR_PUNG,    3,  5,AI_NULL,         S_PUNCH4       }, // S_PUNCH3
  {SPR_PUNG,    2,  4,AI_NULL,         S_PUNCH5       }, // S_PUNCH4
  {SPR_PUNG,    1,  5,AP_ReFire,       S_PUNCH        }, // S_PUNCH5
  {SPR_PISG,    0,  1,AP_WeaponReady,  S_PISTOL       }, // S_PISTOL
  {SPR_PISG,    0,  1,AP_Lower,        S_PISTOLDOWN   }, // S_PISTOLDOWN
  {SPR_PISG,    0,  1,AP_Raise,        S_PISTOLUP     }, // S_PISTOLUP
  {SPR_PISG,    0,  4,AI_NULL,         S_PISTOL2      }, // S_PISTOL1
  {SPR_PISG,    1,  6,AP_FirePistol,   S_PISTOL3      }, // S_PISTOL2
  {SPR_PISG,    2,  4,AI_NULL,         S_PISTOL4      }, // S_PISTOL3
  {SPR_PISG,    1,  5,AP_ReFire,       S_PISTOL       }, // S_PISTOL4
  {SPR_PISF,FFB|0,  7,AP_Light1,       S_LIGHTDONE    }, // S_PISTOLFLASH
  {SPR_SHTG,    0,  1,AP_WeaponReady,  S_SGUN         }, // S_SGUN
  {SPR_SHTG,    0,  1,AP_Lower,        S_SGUNDOWN     }, // S_SGUNDOWN
  {SPR_SHTG,    0,  1,AP_Raise,        S_SGUNUP       }, // S_SGUNUP
  {SPR_SHTG,    0,  3,AI_NULL,         S_SGUN2        }, // S_SGUN1
  {SPR_SHTG,    0,  7,AP_FireShotgun,  S_SGUN3        }, // S_SGUN2
  {SPR_SHTG,    1,  5,AI_NULL,         S_SGUN4        }, // S_SGUN3
  {SPR_SHTG,    2,  5,AI_NULL,         S_SGUN5        }, // S_SGUN4
  {SPR_SHTG,    3,  4,AI_NULL,         S_SGUN6        }, // S_SGUN5
  {SPR_SHTG,    2,  5,AI_NULL,         S_SGUN7        }, // S_SGUN6
  {SPR_SHTG,    1,  5,AI_NULL,         S_SGUN8        }, // S_SGUN7
  {SPR_SHTG,    0,  3,AI_NULL,         S_SGUN9        }, // S_SGUN8
  {SPR_SHTG,    0,  7,AP_ReFire,       S_SGUN         }, // S_SGUN9
  {SPR_SHTF,FFB|0,  4,AP_Light1,       S_SGUNFLASH2   }, // S_SGUNFLASH1
  {SPR_SHTF,FFB|1,  3,AP_Light2,       S_LIGHTDONE    }, // S_SGUNFLASH2
  {SPR_SHT2,    0,  1,AP_WeaponReady,  S_DSGUN        }, // S_DSGUN
  {SPR_SHT2,    0,  1,AP_Lower,        S_DSGUNDOWN    }, // S_DSGUNDOWN
  {SPR_SHT2,    0,  1,AP_Raise,        S_DSGUNUP      }, // S_DSGUNUP
  {SPR_SHT2,    0,  3,AI_NULL,         S_DSGUN2       }, // S_DSGUN1
  {SPR_SHT2,    0,  7,AP_FireShotgun2 ,S_DSGUN3       }, // S_DSGUN2
  {SPR_SHT2,    1,  7,AI_NULL,         S_DSGUN4       }, // S_DSGUN3
  {SPR_SHT2,    2,  7,AP_CheckReload,  S_DSGUN5       }, // S_DSGUN4
  {SPR_SHT2,    3,  7,AP_OpenShotgun2 ,S_DSGUN6       }, // S_DSGUN5
  {SPR_SHT2,    4,  7,AI_NULL,         S_DSGUN7       }, // S_DSGUN6
  {SPR_SHT2,    5,  7,AP_LoadShotgun2 ,S_DSGUN8       }, // S_DSGUN7
  {SPR_SHT2,    6,  6,AI_NULL,         S_DSGUN9       }, // S_DSGUN8
  {SPR_SHT2,    7,  6,AP_CloseShotgun2,S_DSGUN10      }, // S_DSGUN9
  {SPR_SHT2,    0,  5,AP_ReFire,       S_DSGUN        }, // S_DSGUN10
  {SPR_SHT2,    1,  7,AI_NULL,         S_DSNR2        }, // S_DSNR1
  {SPR_SHT2,    0,  3,AI_NULL,         S_DSGUNDOWN    }, // S_DSNR2
  {SPR_SHT2,FFB|8,  5,AP_Light1,       S_DSGUNFLASH2  }, // S_DSGUNFLASH1
  {SPR_SHT2,FFB|9,  4,AP_Light2,       S_LIGHTDONE    }, // S_DSGUNFLASH2
  {SPR_CHGG,    0,  1,AP_WeaponReady,  S_CHAIN        }, // S_CHAIN
  {SPR_CHGG,    0,  1,AP_Lower,        S_CHAINDOWN    }, // S_CHAINDOWN
  {SPR_CHGG,    0,  1,AP_Raise,        S_CHAINUP      }, // S_CHAINUP
  {SPR_CHGG,    0,  4,AP_FireCGun,     S_CHAIN2       }, // S_CHAIN1
  {SPR_CHGG,    1,  4,AP_FireCGun,     S_CHAIN3       }, // S_CHAIN2
  {SPR_CHGG,    1,  0,AP_ReFire,       S_CHAIN        }, // S_CHAIN3
  {SPR_CHGF,FFB|0,  5,AP_Light1,       S_LIGHTDONE    }, // S_CHAINFLASH1
  {SPR_CHGF,FFB|1,  5,AP_Light2,       S_LIGHTDONE    }, // S_CHAINFLASH2
  {SPR_MISG,    0,  1,AP_WeaponReady,  S_MISSILE      }, // S_MISSILE
  {SPR_MISG,    0,  1,AP_Lower,        S_MISSILEDOWN  }, // S_MISSILEDOWN
  {SPR_MISG,    0,  1,AP_Raise,        S_MISSILEUP    }, // S_MISSILEUP
  {SPR_MISG,    1,  8,AP_GunFlash,     S_MISSILE2     }, // S_MISSILE1
  {SPR_MISG,    1, 12,AP_FireMissile,  S_MISSILE3     }, // S_MISSILE2
  {SPR_MISG,    1,  0,AP_ReFire,       S_MISSILE      }, // S_MISSILE3
  {SPR_MISF,FFB|0,  3,AP_Light1,       S_MISSILEFLASH2}, // S_MISSILEFLASH1
  {SPR_MISF,FFB|1,  4,AI_NULL,         S_MISSILEFLASH3}, // S_MISSILEFLASH2
  {SPR_MISF,FFB|2,  4,AP_Light2,       S_MISSILEFLASH4}, // S_MISSILEFLASH3
  {SPR_MISF,FFB|3,  4,AP_Light2,       S_LIGHTDONE    }, // S_MISSILEFLASH4
  {SPR_SAWG,    2,  4,AP_WeaponReady,  S_SAWB         }, // S_SAW
  {SPR_SAWG,    3,  4,AP_WeaponReady,  S_SAW          }, // S_SAWB
  {SPR_SAWG,    2,  1,AP_Lower,        S_SAWDOWN      }, // S_SAWDOWN
  {SPR_SAWG,    2,  1,AP_Raise,        S_SAWUP        }, // S_SAWUP
  {SPR_SAWG,    0,  4,AP_Saw,          S_SAW2         }, // S_SAW1
  {SPR_SAWG,    1,  4,AP_Saw,          S_SAW3         }, // S_SAW2
  {SPR_SAWG,    1,  0,AP_ReFire,       S_SAW          }, // S_SAW3
  {SPR_PLSG,    0,  1,AP_WeaponReady,  S_PLASMA       }, // S_PLASMA
  {SPR_PLSG,    0,  1,AP_Lower,        S_PLASMADOWN   }, // S_PLASMADOWN
  {SPR_PLSG,    0,  1,AP_Raise,        S_PLASMAUP     }, // S_PLASMAUP
  {SPR_PLSG,    0,  3,AP_FirePlasma,   S_PLASMA2      }, // S_PLASMA1
  {SPR_PLSG,    1, 20,AP_ReFire,       S_PLASMA       }, // S_PLASMA2
  {SPR_PLSF,FFB|0,  4,AP_Light1,       S_LIGHTDONE    }, // S_PLASMAFLASH1
  {SPR_PLSF,FFB|1,  4,AP_Light1,       S_LIGHTDONE    }, // S_PLASMAFLASH2
  {SPR_BFGG,    0,  1,AP_WeaponReady,  S_BFG          }, // S_BFG
  {SPR_BFGG,    0,  1,AP_Lower,        S_BFGDOWN      }, // S_BFGDOWN
  {SPR_BFGG,    0,  1,AP_Raise,        S_BFGUP        }, // S_BFGUP
  {SPR_BFGG,    0, 20,AP_BFGsound,     S_BFG2         }, // S_BFG1
  {SPR_BFGG,    1, 10,AP_GunFlash,     S_BFG3         }, // S_BFG2
  {SPR_BFGG,    1, 10,AP_FireBFG,      S_BFG4         }, // S_BFG3
  {SPR_BFGG,    1, 20,AP_ReFire,       S_BFG          }, // S_BFG4
  {SPR_BFGF,FFB|0, 11,AP_Light1,       S_BFGFLASH2    }, // S_BFGFLASH1
  {SPR_BFGF,FFB|1,  6,AP_Light2,       S_LIGHTDONE    }, // S_BFGFLASH2
// Things, functions are acp1 (mobj)
  {SPR_BLUD,    2,  8,AI_NULL,         S_BLOOD2       }, // S_BLOOD1
  {SPR_BLUD,    1,  8,AI_NULL,         S_BLOOD3       }, // S_BLOOD2
  {SPR_BLUD,    0,  8,AI_NULL,         S_NULL         }, // S_BLOOD3
  {SPR_PUFF,FFB|0,  4,AI_NULL,         S_PUFF2        }, // S_PUFF1
  {SPR_PUFF,    1,  4,AI_NULL,         S_PUFF3        }, // S_PUFF2
  {SPR_PUFF,    2,  4,AI_NULL,         S_PUFF4        }, // S_PUFF3
  {SPR_PUFF,    3,  4,AI_NULL,         S_NULL         }, // S_PUFF4
  {SPR_BAL1,FFB|0,  4,AI_NULL,         S_TBALL2       }, // S_TBALL1
  {SPR_BAL1,FFB|1,  4,AI_NULL,         S_TBALL1       }, // S_TBALL2
  {SPR_BAL1,FFB|2,  6,AI_NULL,         S_TBALLX2      }, // S_TBALLX1
  {SPR_BAL1,FFB|3,  6,AI_NULL,         S_TBALLX3      }, // S_TBALLX2
  {SPR_BAL1,FFB|4,  6,AI_NULL,         S_NULL         }, // S_TBALLX3
  {SPR_BAL2,FFB|0,  4,AI_NULL,         S_RBALL2       }, // S_RBALL1
  {SPR_BAL2,FFB|1,  4,AI_NULL,         S_RBALL1       }, // S_RBALL2
  {SPR_BAL2,FFB|2,  6,AI_NULL,         S_RBALLX2      }, // S_RBALLX1
  {SPR_BAL2,FFB|3,  6,AI_NULL,         S_RBALLX3      }, // S_RBALLX2
  {SPR_BAL2,FFB|4,  6,AI_NULL,         S_NULL         }, // S_RBALLX3
  {SPR_PLSS,FFB|0,  6,AI_NULL,         S_PLASBALL2    }, // S_PLASBALL
  {SPR_PLSS,FFB|1,  6,AI_NULL,         S_PLASBALL     }, // S_PLASBALL2
  {SPR_PLSE,FFB|0,  4,AI_NULL,         S_PLASEXP2     }, // S_PLASEXP
  {SPR_PLSE,FFB|1,  4,AI_NULL,         S_PLASEXP3     }, // S_PLASEXP2
  {SPR_PLSE,FFB|2,  4,AI_NULL,         S_PLASEXP4     }, // S_PLASEXP3
  {SPR_PLSE,FFB|3,  4,AI_NULL,         S_PLASEXP5     }, // S_PLASEXP4
  {SPR_PLSE,FFB|4,  4,AI_NULL,         S_NULL         }, // S_PLASEXP5
  {SPR_MISL,FFB|0,  1,AI_NULL,         S_ROCKET       }, // S_ROCKET
  {SPR_BFS1,FFB|0,  4,AI_NULL,         S_BFGSHOT2     }, // S_BFGSHOT
  {SPR_BFS1,FFB|1,  4,AI_NULL,         S_BFGSHOT      }, // S_BFGSHOT2
  {SPR_BFE1,FFB|0,  8,AI_NULL,         S_BFGLAND2     }, // S_BFGLAND
  {SPR_BFE1,FFB|1,  8,AI_NULL,         S_BFGLAND3     }, // S_BFGLAND2
  {SPR_BFE1,FFB|2,  8,AI_BFGSpray,     S_BFGLAND4     }, // S_BFGLAND3
  {SPR_BFE1,FFB|3,  8,AI_NULL,         S_BFGLAND5     }, // S_BFGLAND4
  {SPR_BFE1,FFB|4,  8,AI_NULL,         S_BFGLAND6     }, // S_BFGLAND5
  {SPR_BFE1,FFB|5,  8,AI_NULL,         S_NULL         }, // S_BFGLAND6
  {SPR_BFE2,FFB|0,  8,AI_NULL,         S_BFGEXP2      }, // S_BFGEXP
  {SPR_BFE2,FFB|1,  8,AI_NULL,         S_BFGEXP3      }, // S_BFGEXP2
  {SPR_BFE2,FFB|2,  8,AI_NULL,         S_BFGEXP4      }, // S_BFGEXP3
  {SPR_BFE2,FFB|3,  8,AI_NULL,         S_NULL         }, // S_BFGEXP4
  {SPR_MISL,FFB|1,  8,AI_Explode,      S_EXPLODE2     }, // S_EXPLODE1
  {SPR_MISL,FFB|2,  6,AI_NULL,         S_EXPLODE3     }, // S_EXPLODE2
  {SPR_MISL,FFB|3,  4,AI_NULL,         S_NULL         }, // S_EXPLODE3
  {SPR_TFOG,FFB|0,  6,AI_NULL,         S_TFOG01       }, // S_TFOG
  {SPR_TFOG,FFB|1,  6,AI_NULL,         S_TFOG02       }, // S_TFOG01
  {SPR_TFOG,FFB|0,  6,AI_NULL,         S_TFOG2        }, // S_TFOG02
  {SPR_TFOG,FFB|1,  6,AI_NULL,         S_TFOG3        }, // S_TFOG2
  {SPR_TFOG,FFB|2,  6,AI_NULL,         S_TFOG4        }, // S_TFOG3
  {SPR_TFOG,FFB|3,  6,AI_NULL,         S_TFOG5        }, // S_TFOG4
  {SPR_TFOG,FFB|4,  6,AI_NULL,         S_TFOG6        }, // S_TFOG5
  {SPR_TFOG,FFB|5,  6,AI_NULL,         S_TFOG7        }, // S_TFOG6
  {SPR_TFOG,FFB|6,  6,AI_NULL,         S_TFOG8        }, // S_TFOG7
  {SPR_TFOG,FFB|7,  6,AI_NULL,         S_TFOG9        }, // S_TFOG8
  {SPR_TFOG,FFB|8,  6,AI_NULL,         S_TFOG10       }, // S_TFOG9
  {SPR_TFOG,FFB|9,  6,AI_NULL,         S_NULL         }, // S_TFOG10
  {SPR_IFOG,FFB|0,  6,AI_NULL,         S_IFOG01       }, // S_IFOG
  {SPR_IFOG,FFB|1,  6,AI_NULL,         S_IFOG02       }, // S_IFOG01
  {SPR_IFOG,FFB|0,  6,AI_NULL,         S_IFOG2        }, // S_IFOG02
  {SPR_IFOG,FFB|1,  6,AI_NULL,         S_IFOG3        }, // S_IFOG2
  {SPR_IFOG,FFB|2,  6,AI_NULL,         S_IFOG4        }, // S_IFOG3
  {SPR_IFOG,FFB|3,  6,AI_NULL,         S_IFOG5        }, // S_IFOG4
  {SPR_IFOG,FFB|4,  6,AI_NULL,         S_NULL         }, // S_IFOG5
// Things, functions are acp1 (mobj)
  {SPR_PLAY,    0, -1,AI_NULL,         S_NULL         }, // S_PLAY
  {SPR_PLAY,    0,  4,AI_NULL,         S_PLAY_RUN2    }, // S_PLAY_RUN1
  {SPR_PLAY,    1,  4,AI_NULL,         S_PLAY_RUN3    }, // S_PLAY_RUN2
  {SPR_PLAY,    2,  4,AI_NULL,         S_PLAY_RUN4    }, // S_PLAY_RUN3
  {SPR_PLAY,    3,  4,AI_NULL,         S_PLAY_RUN1    }, // S_PLAY_RUN4
  {SPR_PLAY,    4, 12,AI_NULL,         S_PLAY         }, // S_PLAY_ATK1
  {SPR_PLAY,FFB|5,  6,AI_NULL,         S_PLAY_ATK1    }, // S_PLAY_ATK2
  {SPR_PLAY,    6,  4,AI_NULL,         S_PLAY_PAIN2   }, // S_PLAY_PAIN
  {SPR_PLAY,    6,  4,AI_Pain,         S_PLAY         }, // S_PLAY_PAIN2
  {SPR_PLAY,    7, 10,AI_NULL,         S_PLAY_DIE2    }, // S_PLAY_DIE1
  {SPR_PLAY,    8, 10,AI_PlayerScream ,S_PLAY_DIE3    }, // S_PLAY_DIE2
  {SPR_PLAY,    9, 10,AI_Fall,         S_PLAY_DIE4    }, // S_PLAY_DIE3
  {SPR_PLAY,   10, 10,AI_NULL,         S_PLAY_DIE5    }, // S_PLAY_DIE4
  {SPR_PLAY,   11, 10,AI_NULL,         S_PLAY_DIE6    }, // S_PLAY_DIE5
  {SPR_PLAY,   12, 10,AI_NULL,         S_PLAY_DIE7    }, // S_PLAY_DIE6
  {SPR_PLAY,   13, -1,AI_NULL,         S_NULL         }, // S_PLAY_DIE7
  {SPR_PLAY,   14,  5,AI_NULL,         S_PLAY_XDIE2   }, // S_PLAY_XDIE1
  {SPR_PLAY,   15,  5,AI_XScream,      S_PLAY_XDIE3   }, // S_PLAY_XDIE2
  {SPR_PLAY,   16,  5,AI_Fall,         S_PLAY_XDIE4   }, // S_PLAY_XDIE3
  {SPR_PLAY,   17,  5,AI_NULL,         S_PLAY_XDIE5   }, // S_PLAY_XDIE4
  {SPR_PLAY,   18,  5,AI_NULL,         S_PLAY_XDIE6   }, // S_PLAY_XDIE5
  {SPR_PLAY,   19,  5,AI_NULL,         S_PLAY_XDIE7   }, // S_PLAY_XDIE6
  {SPR_PLAY,   20,  5,AI_NULL,         S_PLAY_XDIE8   }, // S_PLAY_XDIE7
  {SPR_PLAY,   21,  5,AI_NULL,         S_PLAY_XDIE9   }, // S_PLAY_XDIE8
  {SPR_PLAY,   22, -1,AI_NULL,         S_NULL         }, // S_PLAY_XDIE9
// Things, functions are acp1 (mobj)
  {SPR_POSS,    0, 10,AI_Look,         S_POSS_STND2   }, // S_POSS_STND
  {SPR_POSS,    1, 10,AI_Look,         S_POSS_STND    }, // S_POSS_STND2
  {SPR_POSS,    0,  4,AI_Chase,        S_POSS_RUN2    }, // S_POSS_RUN1
  {SPR_POSS,    0,  4,AI_Chase,        S_POSS_RUN3    }, // S_POSS_RUN2
  {SPR_POSS,    1,  4,AI_Chase,        S_POSS_RUN4    }, // S_POSS_RUN3
  {SPR_POSS,    1,  4,AI_Chase,        S_POSS_RUN5    }, // S_POSS_RUN4
  {SPR_POSS,    2,  4,AI_Chase,        S_POSS_RUN6    }, // S_POSS_RUN5
  {SPR_POSS,    2,  4,AI_Chase,        S_POSS_RUN7    }, // S_POSS_RUN6
  {SPR_POSS,    3,  4,AI_Chase,        S_POSS_RUN8    }, // S_POSS_RUN7
  {SPR_POSS,    3,  4,AI_Chase,        S_POSS_RUN1    }, // S_POSS_RUN8
  {SPR_POSS,    4, 10,AI_FaceTarget,   S_POSS_ATK2    }, // S_POSS_ATK1
  {SPR_POSS,    5,  8,AI_PosAttack,    S_POSS_ATK3    }, // S_POSS_ATK2
  {SPR_POSS,    4,  8,AI_NULL,         S_POSS_RUN1    }, // S_POSS_ATK3
  {SPR_POSS,    6,  3,AI_NULL,         S_POSS_PAIN2   }, // S_POSS_PAIN
  {SPR_POSS,    6,  3,AI_Pain,         S_POSS_RUN1    }, // S_POSS_PAIN2
  {SPR_POSS,    7,  5,AI_NULL,         S_POSS_DIE2    }, // S_POSS_DIE1
  {SPR_POSS,    8,  5,AI_Scream,       S_POSS_DIE3    }, // S_POSS_DIE2
  {SPR_POSS,    9,  5,AI_Fall,         S_POSS_DIE4    }, // S_POSS_DIE3
  {SPR_POSS,   10,  5,AI_NULL,         S_POSS_DIE5    }, // S_POSS_DIE4
  {SPR_POSS,   11, -1,AI_NULL,         S_NULL         }, // S_POSS_DIE5
  {SPR_POSS,   12,  5,AI_NULL,         S_POSS_XDIE2   }, // S_POSS_XDIE1
  {SPR_POSS,   13,  5,AI_XScream,      S_POSS_XDIE3   }, // S_POSS_XDIE2
  {SPR_POSS,   14,  5,AI_Fall,         S_POSS_XDIE4   }, // S_POSS_XDIE3
  {SPR_POSS,   15,  5,AI_NULL,         S_POSS_XDIE5   }, // S_POSS_XDIE4
  {SPR_POSS,   16,  5,AI_NULL,         S_POSS_XDIE6   }, // S_POSS_XDIE5
  {SPR_POSS,   17,  5,AI_NULL,         S_POSS_XDIE7   }, // S_POSS_XDIE6
  {SPR_POSS,   18,  5,AI_NULL,         S_POSS_XDIE8   }, // S_POSS_XDIE7
  {SPR_POSS,   19,  5,AI_NULL,         S_POSS_XDIE9   }, // S_POSS_XDIE8
  {SPR_POSS,   20, -1,AI_NULL,         S_NULL         }, // S_POSS_XDIE9
  {SPR_POSS,   10,  5,AI_NULL,         S_POSS_RAISE2  }, // S_POSS_RAISE1
  {SPR_POSS,    9,  5,AI_NULL,         S_POSS_RAISE3  }, // S_POSS_RAISE2
  {SPR_POSS,    8,  5,AI_NULL,         S_POSS_RAISE4  }, // S_POSS_RAISE3
  {SPR_POSS,    7,  5,AI_NULL,         S_POSS_RUN1    }, // S_POSS_RAISE4
// Things, functions are acp1 (mobj)
  {SPR_SPOS,    0, 10,AI_Look,         S_SPOS_STND2   }, // S_SPOS_STND
  {SPR_SPOS,    1, 10,AI_Look,         S_SPOS_STND    }, // S_SPOS_STND2
  {SPR_SPOS,    0,  3,AI_Chase,        S_SPOS_RUN2    }, // S_SPOS_RUN1
  {SPR_SPOS,    0,  3,AI_Chase,        S_SPOS_RUN3    }, // S_SPOS_RUN2
  {SPR_SPOS,    1,  3,AI_Chase,        S_SPOS_RUN4    }, // S_SPOS_RUN3
  {SPR_SPOS,    1,  3,AI_Chase,        S_SPOS_RUN5    }, // S_SPOS_RUN4
  {SPR_SPOS,    2,  3,AI_Chase,        S_SPOS_RUN6    }, // S_SPOS_RUN5
  {SPR_SPOS,    2,  3,AI_Chase,        S_SPOS_RUN7    }, // S_SPOS_RUN6
  {SPR_SPOS,    3,  3,AI_Chase,        S_SPOS_RUN8    }, // S_SPOS_RUN7
  {SPR_SPOS,    3,  3,AI_Chase,        S_SPOS_RUN1    }, // S_SPOS_RUN8
  {SPR_SPOS,    4, 10,AI_FaceTarget,   S_SPOS_ATK2    }, // S_SPOS_ATK1
  {SPR_SPOS,FFB|5, 10,AI_SPosAttack,   S_SPOS_ATK3    }, // S_SPOS_ATK2
  {SPR_SPOS,    4, 10,AI_NULL,         S_SPOS_RUN1    }, // S_SPOS_ATK3
  {SPR_SPOS,    6,  3,AI_NULL,         S_SPOS_PAIN2   }, // S_SPOS_PAIN
  {SPR_SPOS,    6,  3,AI_Pain,         S_SPOS_RUN1    }, // S_SPOS_PAIN2
  {SPR_SPOS,    7,  5,AI_NULL,         S_SPOS_DIE2    }, // S_SPOS_DIE1
  {SPR_SPOS,    8,  5,AI_Scream,       S_SPOS_DIE3    }, // S_SPOS_DIE2
  {SPR_SPOS,    9,  5,AI_Fall,         S_SPOS_DIE4    }, // S_SPOS_DIE3
  {SPR_SPOS,   10,  5,AI_NULL,         S_SPOS_DIE5    }, // S_SPOS_DIE4
  {SPR_SPOS,   11, -1,AI_NULL,         S_NULL         }, // S_SPOS_DIE5
  {SPR_SPOS,   12,  5,AI_NULL,         S_SPOS_XDIE2   }, // S_SPOS_XDIE1
  {SPR_SPOS,   13,  5,AI_XScream,      S_SPOS_XDIE3   }, // S_SPOS_XDIE2
  {SPR_SPOS,   14,  5,AI_Fall,         S_SPOS_XDIE4   }, // S_SPOS_XDIE3
  {SPR_SPOS,   15,  5,AI_NULL,         S_SPOS_XDIE5   }, // S_SPOS_XDIE4
  {SPR_SPOS,   16,  5,AI_NULL,         S_SPOS_XDIE6   }, // S_SPOS_XDIE5
  {SPR_SPOS,   17,  5,AI_NULL,         S_SPOS_XDIE7   }, // S_SPOS_XDIE6
  {SPR_SPOS,   18,  5,AI_NULL,         S_SPOS_XDIE8   }, // S_SPOS_XDIE7
  {SPR_SPOS,   19,  5,AI_NULL,         S_SPOS_XDIE9   }, // S_SPOS_XDIE8
  {SPR_SPOS,   20, -1,AI_NULL,         S_NULL         }, // S_SPOS_XDIE9
  {SPR_SPOS,   11,  5,AI_NULL,         S_SPOS_RAISE2  }, // S_SPOS_RAISE1
  {SPR_SPOS,   10,  5,AI_NULL,         S_SPOS_RAISE3  }, // S_SPOS_RAISE2
  {SPR_SPOS,    9,  5,AI_NULL,         S_SPOS_RAISE4  }, // S_SPOS_RAISE3
  {SPR_SPOS,    8,  5,AI_NULL,         S_SPOS_RAISE5  }, // S_SPOS_RAISE4
  {SPR_SPOS,    7,  5,AI_NULL,         S_SPOS_RUN1    }, // S_SPOS_RAISE5
// Things, functions are acp1 (mobj)
  {SPR_VILE,    0, 10,AI_Look,         S_VILE_STND2   }, // S_VILE_STND
  {SPR_VILE,    1, 10,AI_Look,         S_VILE_STND    }, // S_VILE_STND2
  {SPR_VILE,    0,  2,AI_VileChase,    S_VILE_RUN2    }, // S_VILE_RUN1
  {SPR_VILE,    0,  2,AI_VileChase,    S_VILE_RUN3    }, // S_VILE_RUN2
  {SPR_VILE,    1,  2,AI_VileChase,    S_VILE_RUN4    }, // S_VILE_RUN3
  {SPR_VILE,    1,  2,AI_VileChase,    S_VILE_RUN5    }, // S_VILE_RUN4
  {SPR_VILE,    2,  2,AI_VileChase,    S_VILE_RUN6    }, // S_VILE_RUN5
  {SPR_VILE,    2,  2,AI_VileChase,    S_VILE_RUN7    }, // S_VILE_RUN6
  {SPR_VILE,    3,  2,AI_VileChase,    S_VILE_RUN8    }, // S_VILE_RUN7
  {SPR_VILE,    3,  2,AI_VileChase,    S_VILE_RUN9    }, // S_VILE_RUN8
  {SPR_VILE,    4,  2,AI_VileChase,    S_VILE_RUN10   }, // S_VILE_RUN9
  {SPR_VILE,    4,  2,AI_VileChase,    S_VILE_RUN11   }, // S_VILE_RUN10
  {SPR_VILE,    5,  2,AI_VileChase,    S_VILE_RUN12   }, // S_VILE_RUN11
  {SPR_VILE,    5,  2,AI_VileChase,    S_VILE_RUN1    }, // S_VILE_RUN12
  {SPR_VILE,FFB|6,  0,AI_VileStart,    S_VILE_ATK2    }, // S_VILE_ATK1
  {SPR_VILE,FFB|6, 10,AI_FaceTarget,   S_VILE_ATK3    }, // S_VILE_ATK2
  {SPR_VILE,FFB|7,  8,AI_VileTarget,   S_VILE_ATK4    }, // S_VILE_ATK3
  {SPR_VILE,FFB|8,  8,AI_FaceTarget,   S_VILE_ATK5    }, // S_VILE_ATK4
  {SPR_VILE,FFB|9,  8,AI_FaceTarget,   S_VILE_ATK6    }, // S_VILE_ATK5
  {SPR_VILE,FFB|10,  8,AI_FaceTarget,   S_VILE_ATK7    }, // S_VILE_ATK6
  {SPR_VILE,FFB|11,  8,AI_FaceTarget,   S_VILE_ATK8    }, // S_VILE_ATK7
  {SPR_VILE,FFB|12,  8,AI_FaceTarget,   S_VILE_ATK9    }, // S_VILE_ATK8
  {SPR_VILE,FFB|13,  8,AI_FaceTarget,   S_VILE_ATK10   }, // S_VILE_ATK9
  {SPR_VILE,FFB|14,  8,AI_VileAttack,   S_VILE_ATK11   }, // S_VILE_ATK10
  {SPR_VILE,FFB|15, 20,AI_NULL,         S_VILE_RUN1    }, // S_VILE_ATK11
  {SPR_VILE,FFB|26, 10,AI_NULL,         S_VILE_HEAL2   }, // S_VILE_HEAL1
  {SPR_VILE,FFB|27, 10,AI_NULL,         S_VILE_HEAL3   }, // S_VILE_HEAL2
  {SPR_VILE,FFB|28, 10,AI_NULL,         S_VILE_RUN1    }, // S_VILE_HEAL3
  {SPR_VILE,   16,  5,AI_NULL,         S_VILE_PAIN2   }, // S_VILE_PAIN
  {SPR_VILE,   16,  5,AI_Pain,         S_VILE_RUN1    }, // S_VILE_PAIN2
  {SPR_VILE,   16,  7,AI_NULL,         S_VILE_DIE2    }, // S_VILE_DIE1
  {SPR_VILE,   17,  7,AI_Scream,       S_VILE_DIE3    }, // S_VILE_DIE2
  {SPR_VILE,   18,  7,AI_Fall,         S_VILE_DIE4    }, // S_VILE_DIE3
  {SPR_VILE,   19,  7,AI_NULL,         S_VILE_DIE5    }, // S_VILE_DIE4
  {SPR_VILE,   20,  7,AI_NULL,         S_VILE_DIE6    }, // S_VILE_DIE5
  {SPR_VILE,   21,  7,AI_NULL,         S_VILE_DIE7    }, // S_VILE_DIE6
  {SPR_VILE,   22,  7,AI_NULL,         S_VILE_DIE8    }, // S_VILE_DIE7
  {SPR_VILE,   23,  5,AI_NULL,         S_VILE_DIE9    }, // S_VILE_DIE8
  {SPR_VILE,   24,  5,AI_NULL,         S_VILE_DIE10   }, // S_VILE_DIE9
  {SPR_VILE,   25, -1,AI_NULL,         S_NULL         }, // S_VILE_DIE10
// Things, functions are acp1 (mobj)
  {SPR_FIRE,FFB|0,  2,AI_StartFire,    S_FIRE2        }, // S_FIRE1
  {SPR_FIRE,FFB|1,  2,AI_Fire,         S_FIRE3        }, // S_FIRE2
  {SPR_FIRE,FFB|0,  2,AI_Fire,         S_FIRE4        }, // S_FIRE3
  {SPR_FIRE,FFB|1,  2,AI_Fire,         S_FIRE5        }, // S_FIRE4
  {SPR_FIRE,FFB|2,  2,AI_FireCrackle,  S_FIRE6        }, // S_FIRE5
  {SPR_FIRE,FFB|1,  2,AI_Fire,         S_FIRE7        }, // S_FIRE6
  {SPR_FIRE,FFB|2,  2,AI_Fire,         S_FIRE8        }, // S_FIRE7
  {SPR_FIRE,FFB|1,  2,AI_Fire,         S_FIRE9        }, // S_FIRE8
  {SPR_FIRE,FFB|2,  2,AI_Fire,         S_FIRE10       }, // S_FIRE9
  {SPR_FIRE,FFB|3,  2,AI_Fire,         S_FIRE11       }, // S_FIRE10
  {SPR_FIRE,FFB|2,  2,AI_Fire,         S_FIRE12       }, // S_FIRE11
  {SPR_FIRE,FFB|3,  2,AI_Fire,         S_FIRE13       }, // S_FIRE12
  {SPR_FIRE,FFB|2,  2,AI_Fire,         S_FIRE14       }, // S_FIRE13
  {SPR_FIRE,FFB|3,  2,AI_Fire,         S_FIRE15       }, // S_FIRE14
  {SPR_FIRE,FFB|4,  2,AI_Fire,         S_FIRE16       }, // S_FIRE15
  {SPR_FIRE,FFB|3,  2,AI_Fire,         S_FIRE17       }, // S_FIRE16
  {SPR_FIRE,FFB|4,  2,AI_Fire,         S_FIRE18       }, // S_FIRE17
  {SPR_FIRE,FFB|3,  2,AI_Fire,         S_FIRE19       }, // S_FIRE18
  {SPR_FIRE,FFB|4,  2,AI_FireCrackle,  S_FIRE20       }, // S_FIRE19
  {SPR_FIRE,FFB|5,  2,AI_Fire,         S_FIRE21       }, // S_FIRE20
  {SPR_FIRE,FFB|4,  2,AI_Fire,         S_FIRE22       }, // S_FIRE21
  {SPR_FIRE,FFB|5,  2,AI_Fire,         S_FIRE23       }, // S_FIRE22
  {SPR_FIRE,FFB|4,  2,AI_Fire,         S_FIRE24       }, // S_FIRE23
  {SPR_FIRE,FFB|5,  2,AI_Fire,         S_FIRE25       }, // S_FIRE24
  {SPR_FIRE,FFB|6,  2,AI_Fire,         S_FIRE26       }, // S_FIRE25
  {SPR_FIRE,FFB|7,  2,AI_Fire,         S_FIRE27       }, // S_FIRE26
  {SPR_FIRE,FFB|6,  2,AI_Fire,         S_FIRE28       }, // S_FIRE27
  {SPR_FIRE,FFB|7,  2,AI_Fire,         S_FIRE29       }, // S_FIRE28
  {SPR_FIRE,FFB|6,  2,AI_Fire,         S_FIRE30       }, // S_FIRE29
  {SPR_FIRE,FFB|7,  2,AI_Fire,         S_NULL         }, // S_FIRE30
// Things, functions are acp1 (mobj)
  {SPR_PUFF,    1,  4,AI_NULL,         S_SMOKE2       }, // S_SMOKE1
  {SPR_PUFF,    2,  4,AI_NULL,         S_SMOKE3       }, // S_SMOKE2
  {SPR_PUFF,    1,  4,AI_NULL,         S_SMOKE4       }, // S_SMOKE3
  {SPR_PUFF,    2,  4,AI_NULL,         S_SMOKE5       }, // S_SMOKE4
  {SPR_PUFF,    3,  4,AI_NULL,         S_NULL         }, // S_SMOKE5
  {SPR_FATB,FFB|0,  2,AI_Tracer,       S_TRACER2      }, // S_TRACER
  {SPR_FATB,FFB|1,  2,AI_Tracer,       S_TRACER       }, // S_TRACER2
  {SPR_FBXP,FFB|0,  8,AI_NULL,         S_TRACEEXP2    }, // S_TRACEEXP1
  {SPR_FBXP,FFB|1,  6,AI_NULL,         S_TRACEEXP3    }, // S_TRACEEXP2
  {SPR_FBXP,FFB|2,  4,AI_NULL,         S_NULL         }, // S_TRACEEXP3
// Things, functions are acp1 (mobj)
  {SPR_SKEL,    0, 10,AI_Look,         S_SKEL_STND2   }, // S_SKEL_STND
  {SPR_SKEL,    1, 10,AI_Look,         S_SKEL_STND    }, // S_SKEL_STND2
  {SPR_SKEL,    0,  2,AI_Chase,        S_SKEL_RUN2    }, // S_SKEL_RUN1
  {SPR_SKEL,    0,  2,AI_Chase,        S_SKEL_RUN3    }, // S_SKEL_RUN2
  {SPR_SKEL,    1,  2,AI_Chase,        S_SKEL_RUN4    }, // S_SKEL_RUN3
  {SPR_SKEL,    1,  2,AI_Chase,        S_SKEL_RUN5    }, // S_SKEL_RUN4
  {SPR_SKEL,    2,  2,AI_Chase,        S_SKEL_RUN6    }, // S_SKEL_RUN5
  {SPR_SKEL,    2,  2,AI_Chase,        S_SKEL_RUN7    }, // S_SKEL_RUN6
  {SPR_SKEL,    3,  2,AI_Chase,        S_SKEL_RUN8    }, // S_SKEL_RUN7
  {SPR_SKEL,    3,  2,AI_Chase,        S_SKEL_RUN9    }, // S_SKEL_RUN8
  {SPR_SKEL,    4,  2,AI_Chase,        S_SKEL_RUN10   }, // S_SKEL_RUN9
  {SPR_SKEL,    4,  2,AI_Chase,        S_SKEL_RUN11   }, // S_SKEL_RUN10
  {SPR_SKEL,    5,  2,AI_Chase,        S_SKEL_RUN12   }, // S_SKEL_RUN11
  {SPR_SKEL,    5,  2,AI_Chase,        S_SKEL_RUN1    }, // S_SKEL_RUN12
  {SPR_SKEL,    6,  0,AI_FaceTarget,   S_SKEL_FIST2   }, // S_SKEL_FIST1
  {SPR_SKEL,    6,  6,AI_SkelWhoosh,   S_SKEL_FIST3   }, // S_SKEL_FIST2
  {SPR_SKEL,    7,  6,AI_FaceTarget,   S_SKEL_FIST4   }, // S_SKEL_FIST3
  {SPR_SKEL,    8,  6,AI_SkelFist,     S_SKEL_RUN1    }, // S_SKEL_FIST4
  {SPR_SKEL,FFB|9,  0,AI_FaceTarget,   S_SKEL_MISS2   }, // S_SKEL_MISS1
  {SPR_SKEL,FFB|9, 10,AI_FaceTarget,   S_SKEL_MISS3   }, // S_SKEL_MISS2
  {SPR_SKEL,   10, 10,AI_SkelMissile,  S_SKEL_MISS4   }, // S_SKEL_MISS3
  {SPR_SKEL,   10, 10,AI_FaceTarget,   S_SKEL_RUN1    }, // S_SKEL_MISS4
  {SPR_SKEL,   11,  5,AI_NULL,         S_SKEL_PAIN2   }, // S_SKEL_PAIN
  {SPR_SKEL,   11,  5,AI_Pain,         S_SKEL_RUN1    }, // S_SKEL_PAIN2
  {SPR_SKEL,   11,  7,AI_NULL,         S_SKEL_DIE2    }, // S_SKEL_DIE1
  {SPR_SKEL,   12,  7,AI_NULL,         S_SKEL_DIE3    }, // S_SKEL_DIE2
  {SPR_SKEL,   13,  7,AI_Scream,       S_SKEL_DIE4    }, // S_SKEL_DIE3
  {SPR_SKEL,   14,  7,AI_Fall,         S_SKEL_DIE5    }, // S_SKEL_DIE4
  {SPR_SKEL,   15,  7,AI_NULL,         S_SKEL_DIE6    }, // S_SKEL_DIE5
  {SPR_SKEL,   16, -1,AI_NULL,         S_NULL         }, // S_SKEL_DIE6
  {SPR_SKEL,   16,  5,AI_NULL,         S_SKEL_RAISE2  }, // S_SKEL_RAISE1
  {SPR_SKEL,   15,  5,AI_NULL,         S_SKEL_RAISE3  }, // S_SKEL_RAISE2
  {SPR_SKEL,   14,  5,AI_NULL,         S_SKEL_RAISE4  }, // S_SKEL_RAISE3
  {SPR_SKEL,   13,  5,AI_NULL,         S_SKEL_RAISE5  }, // S_SKEL_RAISE4
  {SPR_SKEL,   12,  5,AI_NULL,         S_SKEL_RAISE6  }, // S_SKEL_RAISE5
  {SPR_SKEL,   11,  5,AI_NULL,         S_SKEL_RUN1    }, // S_SKEL_RAISE6
// Things, functions are acp1 (mobj)
  {SPR_MANF,FFB|0,  4,AI_NULL,         S_FATSHOT2     }, // S_FATSHOT1
  {SPR_MANF,FFB|1,  4,AI_NULL,         S_FATSHOT1     }, // S_FATSHOT2
  {SPR_MISL,FFB|1,  8,AI_NULL,         S_FATSHOTX2    }, // S_FATSHOTX1
  {SPR_MISL,FFB|2,  6,AI_NULL,         S_FATSHOTX3    }, // S_FATSHOTX2
  {SPR_MISL,FFB|3,  4,AI_NULL,         S_NULL         }, // S_FATSHOTX3
  {SPR_FATT,    0, 15,AI_Look,         S_FATT_STND2   }, // S_FATT_STND
  {SPR_FATT,    1, 15,AI_Look,         S_FATT_STND    }, // S_FATT_STND2
  {SPR_FATT,    0,  4,AI_Chase,        S_FATT_RUN2    }, // S_FATT_RUN1
  {SPR_FATT,    0,  4,AI_Chase,        S_FATT_RUN3    }, // S_FATT_RUN2
  {SPR_FATT,    1,  4,AI_Chase,        S_FATT_RUN4    }, // S_FATT_RUN3
  {SPR_FATT,    1,  4,AI_Chase,        S_FATT_RUN5    }, // S_FATT_RUN4
  {SPR_FATT,    2,  4,AI_Chase,        S_FATT_RUN6    }, // S_FATT_RUN5
  {SPR_FATT,    2,  4,AI_Chase,        S_FATT_RUN7    }, // S_FATT_RUN6
  {SPR_FATT,    3,  4,AI_Chase,        S_FATT_RUN8    }, // S_FATT_RUN7
  {SPR_FATT,    3,  4,AI_Chase,        S_FATT_RUN9    }, // S_FATT_RUN8
  {SPR_FATT,    4,  4,AI_Chase,        S_FATT_RUN10   }, // S_FATT_RUN9
  {SPR_FATT,    4,  4,AI_Chase,        S_FATT_RUN11   }, // S_FATT_RUN10
  {SPR_FATT,    5,  4,AI_Chase,        S_FATT_RUN12   }, // S_FATT_RUN11
  {SPR_FATT,    5,  4,AI_Chase,        S_FATT_RUN1    }, // S_FATT_RUN12
  {SPR_FATT,    6, 20,AI_FatRaise,     S_FATT_ATK2    }, // S_FATT_ATK1
  {SPR_FATT,FFB|7, 10,AI_FatAttack1,   S_FATT_ATK3    }, // S_FATT_ATK2
  {SPR_FATT,    8,  5,AI_FaceTarget,   S_FATT_ATK4    }, // S_FATT_ATK3
  {SPR_FATT,    6,  5,AI_FaceTarget,   S_FATT_ATK5    }, // S_FATT_ATK4
  {SPR_FATT,FFB|7, 10,AI_FatAttack2,   S_FATT_ATK6    }, // S_FATT_ATK5
  {SPR_FATT,    8,  5,AI_FaceTarget,   S_FATT_ATK7    }, // S_FATT_ATK6
  {SPR_FATT,    6,  5,AI_FaceTarget,   S_FATT_ATK8    }, // S_FATT_ATK7
  {SPR_FATT,FFB|7, 10,AI_FatAttack3,   S_FATT_ATK9    }, // S_FATT_ATK8
  {SPR_FATT,    8,  5,AI_FaceTarget,   S_FATT_ATK10   }, // S_FATT_ATK9
  {SPR_FATT,    6,  5,AI_FaceTarget,   S_FATT_RUN1    }, // S_FATT_ATK10
  {SPR_FATT,    9,  3,AI_NULL,         S_FATT_PAIN2   }, // S_FATT_PAIN
  {SPR_FATT,    9,  3,AI_Pain,         S_FATT_RUN1    }, // S_FATT_PAIN2
  {SPR_FATT,   10,  6,AI_NULL,         S_FATT_DIE2    }, // S_FATT_DIE1
  {SPR_FATT,   11,  6,AI_Scream,       S_FATT_DIE3    }, // S_FATT_DIE2
  {SPR_FATT,   12,  6,AI_Fall,         S_FATT_DIE4    }, // S_FATT_DIE3
  {SPR_FATT,   13,  6,AI_NULL,         S_FATT_DIE5    }, // S_FATT_DIE4
  {SPR_FATT,   14,  6,AI_NULL,         S_FATT_DIE6    }, // S_FATT_DIE5
  {SPR_FATT,   15,  6,AI_NULL,         S_FATT_DIE7    }, // S_FATT_DIE6
  {SPR_FATT,   16,  6,AI_NULL,         S_FATT_DIE8    }, // S_FATT_DIE7
  {SPR_FATT,   17,  6,AI_NULL,         S_FATT_DIE9    }, // S_FATT_DIE8
  {SPR_FATT,   18,  6,AI_NULL,         S_FATT_DIE10   }, // S_FATT_DIE9
  {SPR_FATT,   19, -1,AI_BossDeath,    S_NULL         }, // S_FATT_DIE10
  {SPR_FATT,   17,  5,AI_NULL,         S_FATT_RAISE2  }, // S_FATT_RAISE1
  {SPR_FATT,   16,  5,AI_NULL,         S_FATT_RAISE3  }, // S_FATT_RAISE2
  {SPR_FATT,   15,  5,AI_NULL,         S_FATT_RAISE4  }, // S_FATT_RAISE3
  {SPR_FATT,   14,  5,AI_NULL,         S_FATT_RAISE5  }, // S_FATT_RAISE4
  {SPR_FATT,   13,  5,AI_NULL,         S_FATT_RAISE6  }, // S_FATT_RAISE5
  {SPR_FATT,   12,  5,AI_NULL,         S_FATT_RAISE7  }, // S_FATT_RAISE6
  {SPR_FATT,   11,  5,AI_NULL,         S_FATT_RAISE8  }, // S_FATT_RAISE7
  {SPR_FATT,   10,  5,AI_NULL,         S_FATT_RUN1    }, // S_FATT_RAISE8
// Things, functions are acp1 (mobj)
  {SPR_CPOS,    0, 10,AI_Look,         S_CPOS_STND2   }, // S_CPOS_STND
  {SPR_CPOS,    1, 10,AI_Look,         S_CPOS_STND    }, // S_CPOS_STND2
  {SPR_CPOS,    0,  3,AI_Chase,        S_CPOS_RUN2    }, // S_CPOS_RUN1
  {SPR_CPOS,    0,  3,AI_Chase,        S_CPOS_RUN3    }, // S_CPOS_RUN2
  {SPR_CPOS,    1,  3,AI_Chase,        S_CPOS_RUN4    }, // S_CPOS_RUN3
  {SPR_CPOS,    1,  3,AI_Chase,        S_CPOS_RUN5    }, // S_CPOS_RUN4
  {SPR_CPOS,    2,  3,AI_Chase,        S_CPOS_RUN6    }, // S_CPOS_RUN5
  {SPR_CPOS,    2,  3,AI_Chase,        S_CPOS_RUN7    }, // S_CPOS_RUN6
  {SPR_CPOS,    3,  3,AI_Chase,        S_CPOS_RUN8    }, // S_CPOS_RUN7
  {SPR_CPOS,    3,  3,AI_Chase,        S_CPOS_RUN1    }, // S_CPOS_RUN8
  {SPR_CPOS,    4, 10,AI_FaceTarget,   S_CPOS_ATK2    }, // S_CPOS_ATK1
  {SPR_CPOS,FFB|5,  4,AI_CPosAttack,   S_CPOS_ATK3    }, // S_CPOS_ATK2
  {SPR_CPOS,FFB|4,  4,AI_CPosAttack,   S_CPOS_ATK4    }, // S_CPOS_ATK3
  {SPR_CPOS,    5,  1,AI_CPosRefire,   S_CPOS_ATK2    }, // S_CPOS_ATK4
  {SPR_CPOS,    6,  3,AI_NULL,         S_CPOS_PAIN2   }, // S_CPOS_PAIN
  {SPR_CPOS,    6,  3,AI_Pain,         S_CPOS_RUN1    }, // S_CPOS_PAIN2
  {SPR_CPOS,    7,  5,AI_NULL,         S_CPOS_DIE2    }, // S_CPOS_DIE1
  {SPR_CPOS,    8,  5,AI_Scream,       S_CPOS_DIE3    }, // S_CPOS_DIE2
  {SPR_CPOS,    9,  5,AI_Fall,         S_CPOS_DIE4    }, // S_CPOS_DIE3
  {SPR_CPOS,   10,  5,AI_NULL,         S_CPOS_DIE5    }, // S_CPOS_DIE4
  {SPR_CPOS,   11,  5,AI_NULL,         S_CPOS_DIE6    }, // S_CPOS_DIE5
  {SPR_CPOS,   12,  5,AI_NULL,         S_CPOS_DIE7    }, // S_CPOS_DIE6
  {SPR_CPOS,   13, -1,AI_NULL,         S_NULL         }, // S_CPOS_DIE7
  {SPR_CPOS,   14,  5,AI_NULL,         S_CPOS_XDIE2   }, // S_CPOS_XDIE1
  {SPR_CPOS,   15,  5,AI_XScream,      S_CPOS_XDIE3   }, // S_CPOS_XDIE2
  {SPR_CPOS,   16,  5,AI_Fall,         S_CPOS_XDIE4   }, // S_CPOS_XDIE3
  {SPR_CPOS,   17,  5,AI_NULL,         S_CPOS_XDIE5   }, // S_CPOS_XDIE4
  {SPR_CPOS,   18,  5,AI_NULL,         S_CPOS_XDIE6   }, // S_CPOS_XDIE5
  {SPR_CPOS,   19, -1,AI_NULL,         S_NULL         }, // S_CPOS_XDIE6
  {SPR_CPOS,   13,  5,AI_NULL,         S_CPOS_RAISE2  }, // S_CPOS_RAISE1
  {SPR_CPOS,   12,  5,AI_NULL,         S_CPOS_RAISE3  }, // S_CPOS_RAISE2
  {SPR_CPOS,   11,  5,AI_NULL,         S_CPOS_RAISE4  }, // S_CPOS_RAISE3
  {SPR_CPOS,   10,  5,AI_NULL,         S_CPOS_RAISE5  }, // S_CPOS_RAISE4
  {SPR_CPOS,    9,  5,AI_NULL,         S_CPOS_RAISE6  }, // S_CPOS_RAISE5
  {SPR_CPOS,    8,  5,AI_NULL,         S_CPOS_RAISE7  }, // S_CPOS_RAISE6
  {SPR_CPOS,    7,  5,AI_NULL,         S_CPOS_RUN1    }, // S_CPOS_RAISE7
// Things, functions are acp1 (mobj)
  {SPR_TROO,    0, 10,AI_Look,         S_TROO_STND2   }, // S_TROO_STND
  {SPR_TROO,    1, 10,AI_Look,         S_TROO_STND    }, // S_TROO_STND2
  {SPR_TROO,    0,  3,AI_Chase,        S_TROO_RUN2    }, // S_TROO_RUN1
  {SPR_TROO,    0,  3,AI_Chase,        S_TROO_RUN3    }, // S_TROO_RUN2
  {SPR_TROO,    1,  3,AI_Chase,        S_TROO_RUN4    }, // S_TROO_RUN3
  {SPR_TROO,    1,  3,AI_Chase,        S_TROO_RUN5    }, // S_TROO_RUN4
  {SPR_TROO,    2,  3,AI_Chase,        S_TROO_RUN6    }, // S_TROO_RUN5
  {SPR_TROO,    2,  3,AI_Chase,        S_TROO_RUN7    }, // S_TROO_RUN6
  {SPR_TROO,    3,  3,AI_Chase,        S_TROO_RUN8    }, // S_TROO_RUN7
  {SPR_TROO,    3,  3,AI_Chase,        S_TROO_RUN1    }, // S_TROO_RUN8
  {SPR_TROO,    4,  8,AI_FaceTarget,   S_TROO_ATK2    }, // S_TROO_ATK1
  {SPR_TROO,    5,  8,AI_FaceTarget,   S_TROO_ATK3    }, // S_TROO_ATK2
  {SPR_TROO,    6,  6,AI_TroopAttack,  S_TROO_RUN1    }, // S_TROO_ATK3
  {SPR_TROO,    7,  2,AI_NULL,         S_TROO_PAIN2   }, // S_TROO_PAIN
  {SPR_TROO,    7,  2,AI_Pain,         S_TROO_RUN1    }, // S_TROO_PAIN2
  {SPR_TROO,    8,  8,AI_NULL,         S_TROO_DIE2    }, // S_TROO_DIE1
  {SPR_TROO,    9,  8,AI_Scream,       S_TROO_DIE3    }, // S_TROO_DIE2
  {SPR_TROO,   10,  6,AI_NULL,         S_TROO_DIE4    }, // S_TROO_DIE3
  {SPR_TROO,   11,  6,AI_Fall,         S_TROO_DIE5    }, // S_TROO_DIE4
  {SPR_TROO,   12, -1,AI_NULL,         S_NULL         }, // S_TROO_DIE5
  {SPR_TROO,   13,  5,AI_NULL,         S_TROO_XDIE2   }, // S_TROO_XDIE1
  {SPR_TROO,   14,  5,AI_XScream,      S_TROO_XDIE3   }, // S_TROO_XDIE2
  {SPR_TROO,   15,  5,AI_NULL,         S_TROO_XDIE4   }, // S_TROO_XDIE3
  {SPR_TROO,   16,  5,AI_Fall,         S_TROO_XDIE5   }, // S_TROO_XDIE4
  {SPR_TROO,   17,  5,AI_NULL,         S_TROO_XDIE6   }, // S_TROO_XDIE5
  {SPR_TROO,   18,  5,AI_NULL,         S_TROO_XDIE7   }, // S_TROO_XDIE6
  {SPR_TROO,   19,  5,AI_NULL,         S_TROO_XDIE8   }, // S_TROO_XDIE7
  {SPR_TROO,   20, -1,AI_NULL,         S_NULL         }, // S_TROO_XDIE8
  {SPR_TROO,   12,  8,AI_NULL,         S_TROO_RAISE2  }, // S_TROO_RAISE1
  {SPR_TROO,   11,  8,AI_NULL,         S_TROO_RAISE3  }, // S_TROO_RAISE2
  {SPR_TROO,   10,  6,AI_NULL,         S_TROO_RAISE4  }, // S_TROO_RAISE3
  {SPR_TROO,    9,  6,AI_NULL,         S_TROO_RAISE5  }, // S_TROO_RAISE4
  {SPR_TROO,    8,  6,AI_NULL,         S_TROO_RUN1    }, // S_TROO_RAISE5
// Things, functions are acp1 (mobj)
  {SPR_SARG,    0, 10,AI_Look,         S_SARG_STND2   }, // S_SARG_STND
  {SPR_SARG,    1, 10,AI_Look,         S_SARG_STND    }, // S_SARG_STND2
  {SPR_SARG,    0,  2,AI_Chase,        S_SARG_RUN2    }, // S_SARG_RUN1
  {SPR_SARG,    0,  2,AI_Chase,        S_SARG_RUN3    }, // S_SARG_RUN2
  {SPR_SARG,    1,  2,AI_Chase,        S_SARG_RUN4    }, // S_SARG_RUN3
  {SPR_SARG,    1,  2,AI_Chase,        S_SARG_RUN5    }, // S_SARG_RUN4
  {SPR_SARG,    2,  2,AI_Chase,        S_SARG_RUN6    }, // S_SARG_RUN5
  {SPR_SARG,    2,  2,AI_Chase,        S_SARG_RUN7    }, // S_SARG_RUN6
  {SPR_SARG,    3,  2,AI_Chase,        S_SARG_RUN8    }, // S_SARG_RUN7
  {SPR_SARG,    3,  2,AI_Chase,        S_SARG_RUN1    }, // S_SARG_RUN8
  {SPR_SARG,    4,  8,AI_FaceTarget,   S_SARG_ATK2    }, // S_SARG_ATK1
  {SPR_SARG,    5,  8,AI_FaceTarget,   S_SARG_ATK3    }, // S_SARG_ATK2
  {SPR_SARG,    6,  8,AI_SargAttack,   S_SARG_RUN1    }, // S_SARG_ATK3
  {SPR_SARG,    7,  2,AI_NULL,         S_SARG_PAIN2   }, // S_SARG_PAIN
  {SPR_SARG,    7,  2,AI_Pain,         S_SARG_RUN1    }, // S_SARG_PAIN2
  {SPR_SARG,    8,  8,AI_NULL,         S_SARG_DIE2    }, // S_SARG_DIE1
  {SPR_SARG,    9,  8,AI_Scream,       S_SARG_DIE3    }, // S_SARG_DIE2
  {SPR_SARG,   10,  4,AI_NULL,         S_SARG_DIE4    }, // S_SARG_DIE3
  {SPR_SARG,   11,  4,AI_Fall,         S_SARG_DIE5    }, // S_SARG_DIE4
  {SPR_SARG,   12,  4,AI_NULL,         S_SARG_DIE6    }, // S_SARG_DIE5
  {SPR_SARG,   13, -1,AI_NULL,         S_NULL         }, // S_SARG_DIE6
  {SPR_SARG,   13,  5,AI_NULL,         S_SARG_RAISE2  }, // S_SARG_RAISE1
  {SPR_SARG,   12,  5,AI_NULL,         S_SARG_RAISE3  }, // S_SARG_RAISE2
  {SPR_SARG,   11,  5,AI_NULL,         S_SARG_RAISE4  }, // S_SARG_RAISE3
  {SPR_SARG,   10,  5,AI_NULL,         S_SARG_RAISE5  }, // S_SARG_RAISE4
  {SPR_SARG,    9,  5,AI_NULL,         S_SARG_RAISE6  }, // S_SARG_RAISE5
  {SPR_SARG,    8,  5,AI_NULL,         S_SARG_RUN1    }, // S_SARG_RAISE6
// Things, functions are acp1 (mobj)
  {SPR_HEAD,    0, 10,AI_Look,         S_HEAD_STND    }, // S_HEAD_STND
  {SPR_HEAD,    0,  3,AI_Chase,        S_HEAD_RUN1    }, // S_HEAD_RUN1
  {SPR_HEAD,    1,  5,AI_FaceTarget,   S_HEAD_ATK2    }, // S_HEAD_ATK1
  {SPR_HEAD,    2,  5,AI_FaceTarget,   S_HEAD_ATK3    }, // S_HEAD_ATK2
  {SPR_HEAD,FFB|3,  5,AI_HeadAttack,   S_HEAD_RUN1    }, // S_HEAD_ATK3
  {SPR_HEAD,    4,  3,AI_NULL,         S_HEAD_PAIN2   }, // S_HEAD_PAIN
  {SPR_HEAD,    4,  3,AI_Pain,         S_HEAD_PAIN3   }, // S_HEAD_PAIN2
  {SPR_HEAD,    5,  6,AI_NULL,         S_HEAD_RUN1    }, // S_HEAD_PAIN3
  {SPR_HEAD,    6,  8,AI_NULL,         S_HEAD_DIE2    }, // S_HEAD_DIE1
  {SPR_HEAD,    7,  8,AI_Scream,       S_HEAD_DIE3    }, // S_HEAD_DIE2
  {SPR_HEAD,    8,  8,AI_NULL,         S_HEAD_DIE4    }, // S_HEAD_DIE3
  {SPR_HEAD,    9,  8,AI_NULL,         S_HEAD_DIE5    }, // S_HEAD_DIE4
  {SPR_HEAD,   10,  8,AI_Fall,         S_HEAD_DIE6    }, // S_HEAD_DIE5
  {SPR_HEAD,   11, -1,AI_NULL,         S_NULL         }, // S_HEAD_DIE6
  {SPR_HEAD,   11,  8,AI_NULL,         S_HEAD_RAISE2  }, // S_HEAD_RAISE1
  {SPR_HEAD,   10,  8,AI_NULL,         S_HEAD_RAISE3  }, // S_HEAD_RAISE2
  {SPR_HEAD,    9,  8,AI_NULL,         S_HEAD_RAISE4  }, // S_HEAD_RAISE3
  {SPR_HEAD,    8,  8,AI_NULL,         S_HEAD_RAISE5  }, // S_HEAD_RAISE4
  {SPR_HEAD,    7,  8,AI_NULL,         S_HEAD_RAISE6  }, // S_HEAD_RAISE5
  {SPR_HEAD,    6,  8,AI_NULL,         S_HEAD_RUN1    }, // S_HEAD_RAISE6
  {SPR_BAL7,FFB|0,  4,AI_NULL,         S_BRBALL2      }, // S_BRBALL1
  {SPR_BAL7,FFB|1,  4,AI_NULL,         S_BRBALL1      }, // S_BRBALL2
  {SPR_BAL7,FFB|2,  6,AI_NULL,         S_BRBALLX2     }, // S_BRBALLX1
  {SPR_BAL7,FFB|3,  6,AI_NULL,         S_BRBALLX3     }, // S_BRBALLX2
  {SPR_BAL7,FFB|4,  6,AI_NULL,         S_NULL         }, // S_BRBALLX3
// Things, functions are acp1 (mobj)
  {SPR_BOSS,    0, 10,AI_Look,         S_BOSS_STND2   }, // S_BOSS_STND
  {SPR_BOSS,    1, 10,AI_Look,         S_BOSS_STND    }, // S_BOSS_STND2
  {SPR_BOSS,    0,  3,AI_Chase,        S_BOSS_RUN2    }, // S_BOSS_RUN1
  {SPR_BOSS,    0,  3,AI_Chase,        S_BOSS_RUN3    }, // S_BOSS_RUN2
  {SPR_BOSS,    1,  3,AI_Chase,        S_BOSS_RUN4    }, // S_BOSS_RUN3
  {SPR_BOSS,    1,  3,AI_Chase,        S_BOSS_RUN5    }, // S_BOSS_RUN4
  {SPR_BOSS,    2,  3,AI_Chase,        S_BOSS_RUN6    }, // S_BOSS_RUN5
  {SPR_BOSS,    2,  3,AI_Chase,        S_BOSS_RUN7    }, // S_BOSS_RUN6
  {SPR_BOSS,    3,  3,AI_Chase,        S_BOSS_RUN8    }, // S_BOSS_RUN7
  {SPR_BOSS,    3,  3,AI_Chase,        S_BOSS_RUN1    }, // S_BOSS_RUN8
  {SPR_BOSS,    4,  8,AI_FaceTarget,   S_BOSS_ATK2    }, // S_BOSS_ATK1
  {SPR_BOSS,    5,  8,AI_FaceTarget,   S_BOSS_ATK3    }, // S_BOSS_ATK2
  {SPR_BOSS,    6,  8,AI_BruisAttack,  S_BOSS_RUN1    }, // S_BOSS_ATK3
  {SPR_BOSS,    7,  2,AI_NULL,         S_BOSS_PAIN2   }, // S_BOSS_PAIN
  {SPR_BOSS,    7,  2,AI_Pain,         S_BOSS_RUN1    }, // S_BOSS_PAIN2
  {SPR_BOSS,    8,  8,AI_NULL,         S_BOSS_DIE2    }, // S_BOSS_DIE1
  {SPR_BOSS,    9,  8,AI_Scream,       S_BOSS_DIE3    }, // S_BOSS_DIE2
  {SPR_BOSS,   10,  8,AI_NULL,         S_BOSS_DIE4    }, // S_BOSS_DIE3
  {SPR_BOSS,   11,  8,AI_Fall,         S_BOSS_DIE5    }, // S_BOSS_DIE4
  {SPR_BOSS,   12,  8,AI_NULL,         S_BOSS_DIE6    }, // S_BOSS_DIE5
  {SPR_BOSS,   13,  8,AI_NULL,         S_BOSS_DIE7    }, // S_BOSS_DIE6
  {SPR_BOSS,   14, -1,AI_BossDeath,    S_NULL         }, // S_BOSS_DIE7
  {SPR_BOSS,   14,  8,AI_NULL,         S_BOSS_RAISE2  }, // S_BOSS_RAISE1
  {SPR_BOSS,   13,  8,AI_NULL,         S_BOSS_RAISE3  }, // S_BOSS_RAISE2
  {SPR_BOSS,   12,  8,AI_NULL,         S_BOSS_RAISE4  }, // S_BOSS_RAISE3
  {SPR_BOSS,   11,  8,AI_NULL,         S_BOSS_RAISE5  }, // S_BOSS_RAISE4
  {SPR_BOSS,   10,  8,AI_NULL,         S_BOSS_RAISE6  }, // S_BOSS_RAISE5
  {SPR_BOSS,    9,  8,AI_NULL,         S_BOSS_RAISE7  }, // S_BOSS_RAISE6
  {SPR_BOSS,    8,  8,AI_NULL,         S_BOSS_RUN1    }, // S_BOSS_RAISE7
  {SPR_BOS2,    0, 10,AI_Look,         S_BOS2_STND2   }, // S_BOS2_STND
  {SPR_BOS2,    1, 10,AI_Look,         S_BOS2_STND    }, // S_BOS2_STND2
  {SPR_BOS2,    0,  3,AI_Chase,        S_BOS2_RUN2    }, // S_BOS2_RUN1
  {SPR_BOS2,    0,  3,AI_Chase,        S_BOS2_RUN3    }, // S_BOS2_RUN2
  {SPR_BOS2,    1,  3,AI_Chase,        S_BOS2_RUN4    }, // S_BOS2_RUN3
  {SPR_BOS2,    1,  3,AI_Chase,        S_BOS2_RUN5    }, // S_BOS2_RUN4
  {SPR_BOS2,    2,  3,AI_Chase,        S_BOS2_RUN6    }, // S_BOS2_RUN5
  {SPR_BOS2,    2,  3,AI_Chase,        S_BOS2_RUN7    }, // S_BOS2_RUN6
  {SPR_BOS2,    3,  3,AI_Chase,        S_BOS2_RUN8    }, // S_BOS2_RUN7
  {SPR_BOS2,    3,  3,AI_Chase,        S_BOS2_RUN1    }, // S_BOS2_RUN8
  {SPR_BOS2,    4,  8,AI_FaceTarget,   S_BOS2_ATK2    }, // S_BOS2_ATK1
  {SPR_BOS2,    5,  8,AI_FaceTarget,   S_BOS2_ATK3    }, // S_BOS2_ATK2
  {SPR_BOS2,    6,  8,AI_BruisAttack,  S_BOS2_RUN1    }, // S_BOS2_ATK3
  {SPR_BOS2,    7,  2,AI_NULL,         S_BOS2_PAIN2   }, // S_BOS2_PAIN
  {SPR_BOS2,    7,  2,AI_Pain,         S_BOS2_RUN1    }, // S_BOS2_PAIN2
  {SPR_BOS2,    8,  8,AI_NULL,         S_BOS2_DIE2    }, // S_BOS2_DIE1
  {SPR_BOS2,    9,  8,AI_Scream,       S_BOS2_DIE3    }, // S_BOS2_DIE2
  {SPR_BOS2,   10,  8,AI_NULL,         S_BOS2_DIE4    }, // S_BOS2_DIE3
  {SPR_BOS2,   11,  8,AI_Fall,         S_BOS2_DIE5    }, // S_BOS2_DIE4
  {SPR_BOS2,   12,  8,AI_NULL,         S_BOS2_DIE6    }, // S_BOS2_DIE5
  {SPR_BOS2,   13,  8,AI_NULL,         S_BOS2_DIE7    }, // S_BOS2_DIE6
  {SPR_BOS2,   14, -1,AI_NULL,         S_NULL         }, // S_BOS2_DIE7
  {SPR_BOS2,   14,  8,AI_NULL,         S_BOS2_RAISE2  }, // S_BOS2_RAISE1
  {SPR_BOS2,   13,  8,AI_NULL,         S_BOS2_RAISE3  }, // S_BOS2_RAISE2
  {SPR_BOS2,   12,  8,AI_NULL,         S_BOS2_RAISE4  }, // S_BOS2_RAISE3
  {SPR_BOS2,   11,  8,AI_NULL,         S_BOS2_RAISE5  }, // S_BOS2_RAISE4
  {SPR_BOS2,   10,  8,AI_NULL,         S_BOS2_RAISE6  }, // S_BOS2_RAISE5
  {SPR_BOS2,    9,  8,AI_NULL,         S_BOS2_RAISE7  }, // S_BOS2_RAISE6
  {SPR_BOS2,    8,  8,AI_NULL,         S_BOS2_RUN1    }, // S_BOS2_RAISE7
// Things, functions are acp1 (mobj)
  {SPR_SKUL,FFB|0, 10,AI_Look,         S_SKULL_STND2  }, // S_SKULL_STND
  {SPR_SKUL,FFB|1, 10,AI_Look,         S_SKULL_STND   }, // S_SKULL_STND2
  {SPR_SKUL,FFB|0,  6,AI_Chase,        S_SKULL_RUN2   }, // S_SKULL_RUN1
  {SPR_SKUL,FFB|1,  6,AI_Chase,        S_SKULL_RUN1   }, // S_SKULL_RUN2
  {SPR_SKUL,FFB|2, 10,AI_FaceTarget,   S_SKULL_ATK2   }, // S_SKULL_ATK1
  {SPR_SKUL,FFB|3,  4,AI_SkullAttack,  S_SKULL_ATK3   }, // S_SKULL_ATK2
  {SPR_SKUL,FFB|2,  4,AI_NULL,         S_SKULL_ATK4   }, // S_SKULL_ATK3
  {SPR_SKUL,FFB|3,  4,AI_NULL,         S_SKULL_ATK3   }, // S_SKULL_ATK4
  {SPR_SKUL,FFB|4,  3,AI_NULL,         S_SKULL_PAIN2  }, // S_SKULL_PAIN
  {SPR_SKUL,FFB|4,  3,AI_Pain,         S_SKULL_RUN1   }, // S_SKULL_PAIN2
  {SPR_SKUL,FFB|5,  6,AI_NULL,         S_SKULL_DIE2   }, // S_SKULL_DIE1
  {SPR_SKUL,FFB|6,  6,AI_Scream,       S_SKULL_DIE3   }, // S_SKULL_DIE2
  {SPR_SKUL,FFB|7,  6,AI_NULL,         S_SKULL_DIE4   }, // S_SKULL_DIE3
  {SPR_SKUL,FFB|8,  6,AI_Fall,         S_SKULL_DIE5   }, // S_SKULL_DIE4
  {SPR_SKUL,    9,  6,AI_NULL,         S_SKULL_DIE6   }, // S_SKULL_DIE5
  {SPR_SKUL,   10,  6,AI_NULL,         S_NULL         }, // S_SKULL_DIE6
// Things, functions are acp1 (mobj)
  {SPR_SPID,    0, 10,AI_Look,         S_SPID_STND2   }, // S_SPID_STND
  {SPR_SPID,    1, 10,AI_Look,         S_SPID_STND    }, // S_SPID_STND2
  {SPR_SPID,    0,  3,AI_Metal,        S_SPID_RUN2    }, // S_SPID_RUN1
  {SPR_SPID,    0,  3,AI_Chase,        S_SPID_RUN3    }, // S_SPID_RUN2
  {SPR_SPID,    1,  3,AI_Chase,        S_SPID_RUN4    }, // S_SPID_RUN3
  {SPR_SPID,    1,  3,AI_Chase,        S_SPID_RUN5    }, // S_SPID_RUN4
  {SPR_SPID,    2,  3,AI_Metal,        S_SPID_RUN6    }, // S_SPID_RUN5
  {SPR_SPID,    2,  3,AI_Chase,        S_SPID_RUN7    }, // S_SPID_RUN6
  {SPR_SPID,    3,  3,AI_Chase,        S_SPID_RUN8    }, // S_SPID_RUN7
  {SPR_SPID,    3,  3,AI_Chase,        S_SPID_RUN9    }, // S_SPID_RUN8
  {SPR_SPID,    4,  3,AI_Metal,        S_SPID_RUN10   }, // S_SPID_RUN9
  {SPR_SPID,    4,  3,AI_Chase,        S_SPID_RUN11   }, // S_SPID_RUN10
  {SPR_SPID,    5,  3,AI_Chase,        S_SPID_RUN12   }, // S_SPID_RUN11
  {SPR_SPID,    5,  3,AI_Chase,        S_SPID_RUN1    }, // S_SPID_RUN12
  {SPR_SPID,FFB|0, 20,AI_FaceTarget,   S_SPID_ATK2    }, // S_SPID_ATK1
  {SPR_SPID,FFB|6,  4,AI_SPosAttack,   S_SPID_ATK3    }, // S_SPID_ATK2
  {SPR_SPID,FFB|7,  4,AI_SPosAttack,   S_SPID_ATK4    }, // S_SPID_ATK3
  {SPR_SPID,FFB|7,  1,AI_SpidRefire,   S_SPID_ATK2    }, // S_SPID_ATK4
  {SPR_SPID,    8,  3,AI_NULL,         S_SPID_PAIN2   }, // S_SPID_PAIN
  {SPR_SPID,    8,  3,AI_Pain,         S_SPID_RUN1    }, // S_SPID_PAIN2
  {SPR_SPID,    9, 20,AI_Scream,       S_SPID_DIE2    }, // S_SPID_DIE1
  {SPR_SPID,   10, 10,AI_Fall,         S_SPID_DIE3    }, // S_SPID_DIE2
  {SPR_SPID,   11, 10,AI_NULL,         S_SPID_DIE4    }, // S_SPID_DIE3
  {SPR_SPID,   12, 10,AI_NULL,         S_SPID_DIE5    }, // S_SPID_DIE4
  {SPR_SPID,   13, 10,AI_NULL,         S_SPID_DIE6    }, // S_SPID_DIE5
  {SPR_SPID,   14, 10,AI_NULL,         S_SPID_DIE7    }, // S_SPID_DIE6
  {SPR_SPID,   15, 10,AI_NULL,         S_SPID_DIE8    }, // S_SPID_DIE7
  {SPR_SPID,   16, 10,AI_NULL,         S_SPID_DIE9    }, // S_SPID_DIE8
  {SPR_SPID,   17, 10,AI_NULL,         S_SPID_DIE10   }, // S_SPID_DIE9
  {SPR_SPID,   18, 30,AI_NULL,         S_SPID_DIE11   }, // S_SPID_DIE10
  {SPR_SPID,   18, -1,AI_BossDeath,    S_NULL         }, // S_SPID_DIE11
// Things, functions are acp1 (mobj)
  {SPR_BSPI,    0, 10,AI_Look,         S_BSPI_STND2   }, // S_BSPI_STND
  {SPR_BSPI,    1, 10,AI_Look,         S_BSPI_STND    }, // S_BSPI_STND2
  {SPR_BSPI,    0, 20,AI_NULL,         S_BSPI_RUN1    }, // S_BSPI_SIGHT
  {SPR_BSPI,    0,  3,AI_BabyMetal,    S_BSPI_RUN2    }, // S_BSPI_RUN1
  {SPR_BSPI,    0,  3,AI_Chase,        S_BSPI_RUN3    }, // S_BSPI_RUN2
  {SPR_BSPI,    1,  3,AI_Chase,        S_BSPI_RUN4    }, // S_BSPI_RUN3
  {SPR_BSPI,    1,  3,AI_Chase,        S_BSPI_RUN5    }, // S_BSPI_RUN4
  {SPR_BSPI,    2,  3,AI_Chase,        S_BSPI_RUN6    }, // S_BSPI_RUN5
  {SPR_BSPI,    2,  3,AI_Chase,        S_BSPI_RUN7    }, // S_BSPI_RUN6
  {SPR_BSPI,    3,  3,AI_BabyMetal,    S_BSPI_RUN8    }, // S_BSPI_RUN7
  {SPR_BSPI,    3,  3,AI_Chase,        S_BSPI_RUN9    }, // S_BSPI_RUN8
  {SPR_BSPI,    4,  3,AI_Chase,        S_BSPI_RUN10   }, // S_BSPI_RUN9
  {SPR_BSPI,    4,  3,AI_Chase,        S_BSPI_RUN11   }, // S_BSPI_RUN10
  {SPR_BSPI,    5,  3,AI_Chase,        S_BSPI_RUN12   }, // S_BSPI_RUN11
  {SPR_BSPI,    5,  3,AI_Chase,        S_BSPI_RUN1    }, // S_BSPI_RUN12
  {SPR_BSPI,FFB|0, 20,AI_FaceTarget,   S_BSPI_ATK2    }, // S_BSPI_ATK1
  {SPR_BSPI,FFB|6,  4,AI_BspiAttack,   S_BSPI_ATK3    }, // S_BSPI_ATK2
  {SPR_BSPI,FFB|7,  4,AI_NULL,         S_BSPI_ATK4    }, // S_BSPI_ATK3
  {SPR_BSPI,FFB|7,  1,AI_SpidRefire,   S_BSPI_ATK2    }, // S_BSPI_ATK4
  {SPR_BSPI,    8,  3,AI_NULL,         S_BSPI_PAIN2   }, // S_BSPI_PAIN
  {SPR_BSPI,    8,  3,AI_Pain,         S_BSPI_RUN1    }, // S_BSPI_PAIN2
  {SPR_BSPI,    9, 20,AI_Scream,       S_BSPI_DIE2    }, // S_BSPI_DIE1
  {SPR_BSPI,   10,  7,AI_Fall,         S_BSPI_DIE3    }, // S_BSPI_DIE2
  {SPR_BSPI,   11,  7,AI_NULL,         S_BSPI_DIE4    }, // S_BSPI_DIE3
  {SPR_BSPI,   12,  7,AI_NULL,         S_BSPI_DIE5    }, // S_BSPI_DIE4
  {SPR_BSPI,   13,  7,AI_NULL,         S_BSPI_DIE6    }, // S_BSPI_DIE5
  {SPR_BSPI,   14,  7,AI_NULL,         S_BSPI_DIE7    }, // S_BSPI_DIE6
  {SPR_BSPI,   15, -1,AI_BossDeath,    S_NULL         }, // S_BSPI_DIE7
  {SPR_BSPI,   15,  5,AI_NULL,         S_BSPI_RAISE2  }, // S_BSPI_RAISE1
  {SPR_BSPI,   14,  5,AI_NULL,         S_BSPI_RAISE3  }, // S_BSPI_RAISE2
  {SPR_BSPI,   13,  5,AI_NULL,         S_BSPI_RAISE4  }, // S_BSPI_RAISE3
  {SPR_BSPI,   12,  5,AI_NULL,         S_BSPI_RAISE5  }, // S_BSPI_RAISE4
  {SPR_BSPI,   11,  5,AI_NULL,         S_BSPI_RAISE6  }, // S_BSPI_RAISE5
  {SPR_BSPI,   10,  5,AI_NULL,         S_BSPI_RAISE7  }, // S_BSPI_RAISE6
  {SPR_BSPI,    9,  5,AI_NULL,         S_BSPI_RUN1    }, // S_BSPI_RAISE7
  {SPR_APLS,FFB|0,  5,AI_NULL,         S_ARACH_PLAZ2  }, // S_ARACH_PLAZ
  {SPR_APLS,FFB|1,  5,AI_NULL,         S_ARACH_PLAZ   }, // S_ARACH_PLAZ2
  {SPR_APBX,FFB|0,  5,AI_NULL,         S_ARACH_PLEX2  }, // S_ARACH_PLEX
  {SPR_APBX,FFB|1,  5,AI_NULL,         S_ARACH_PLEX3  }, // S_ARACH_PLEX2
  {SPR_APBX,FFB|2,  5,AI_NULL,         S_ARACH_PLEX4  }, // S_ARACH_PLEX3
  {SPR_APBX,FFB|3,  5,AI_NULL,         S_ARACH_PLEX5  }, // S_ARACH_PLEX4
  {SPR_APBX,FFB|4,  5,AI_NULL,         S_NULL         }, // S_ARACH_PLEX5
// Things, functions are acp1 (mobj)
  {SPR_CYBR,    0, 10,AI_Look,         S_CYBER_STND2  }, // S_CYBER_STND
  {SPR_CYBR,    1, 10,AI_Look,         S_CYBER_STND   }, // S_CYBER_STND2
  {SPR_CYBR,    0,  3,AI_Hoof,         S_CYBER_RUN2   }, // S_CYBER_RUN1
  {SPR_CYBR,    0,  3,AI_Chase,        S_CYBER_RUN3   }, // S_CYBER_RUN2
  {SPR_CYBR,    1,  3,AI_Chase,        S_CYBER_RUN4   }, // S_CYBER_RUN3
  {SPR_CYBR,    1,  3,AI_Chase,        S_CYBER_RUN5   }, // S_CYBER_RUN4
  {SPR_CYBR,    2,  3,AI_Chase,        S_CYBER_RUN6   }, // S_CYBER_RUN5
  {SPR_CYBR,    2,  3,AI_Chase,        S_CYBER_RUN7   }, // S_CYBER_RUN6
  {SPR_CYBR,    3,  3,AI_Metal,        S_CYBER_RUN8   }, // S_CYBER_RUN7
  {SPR_CYBR,    3,  3,AI_Chase,        S_CYBER_RUN1   }, // S_CYBER_RUN8
  {SPR_CYBR,    4,  6,AI_FaceTarget,   S_CYBER_ATK2   }, // S_CYBER_ATK1
  {SPR_CYBR,    5, 12,AI_CyberAttack,  S_CYBER_ATK3   }, // S_CYBER_ATK2
  {SPR_CYBR,    4, 12,AI_FaceTarget,   S_CYBER_ATK4   }, // S_CYBER_ATK3
  {SPR_CYBR,    5, 12,AI_CyberAttack,  S_CYBER_ATK5   }, // S_CYBER_ATK4
  {SPR_CYBR,    4, 12,AI_FaceTarget,   S_CYBER_ATK6   }, // S_CYBER_ATK5
  {SPR_CYBR,    5, 12,AI_CyberAttack,  S_CYBER_RUN1   }, // S_CYBER_ATK6
  {SPR_CYBR,    6, 10,AI_Pain,         S_CYBER_RUN1   }, // S_CYBER_PAIN
  {SPR_CYBR,    7, 10,AI_NULL,         S_CYBER_DIE2   }, // S_CYBER_DIE1
  {SPR_CYBR,    8, 10,AI_Scream,       S_CYBER_DIE3   }, // S_CYBER_DIE2
  {SPR_CYBR,    9, 10,AI_NULL,         S_CYBER_DIE4   }, // S_CYBER_DIE3
  {SPR_CYBR,   10, 10,AI_NULL,         S_CYBER_DIE5   }, // S_CYBER_DIE4
  {SPR_CYBR,   11, 10,AI_NULL,         S_CYBER_DIE6   }, // S_CYBER_DIE5
  {SPR_CYBR,   12, 10,AI_Fall,         S_CYBER_DIE7   }, // S_CYBER_DIE6
  {SPR_CYBR,   13, 10,AI_NULL,         S_CYBER_DIE8   }, // S_CYBER_DIE7
  {SPR_CYBR,   14, 10,AI_NULL,         S_CYBER_DIE9   }, // S_CYBER_DIE8
  {SPR_CYBR,   15, 30,AI_NULL,         S_CYBER_DIE10  }, // S_CYBER_DIE9
  {SPR_CYBR,   15, -1,AI_BossDeath,    S_NULL         }, // S_CYBER_DIE10
  {SPR_PAIN,    0, 10,AI_Look,         S_PAIN_STND    }, // S_PAIN_STND
  {SPR_PAIN,    0,  3,AI_Chase,        S_PAIN_RUN2    }, // S_PAIN_RUN1
  {SPR_PAIN,    0,  3,AI_Chase,        S_PAIN_RUN3    }, // S_PAIN_RUN2
  {SPR_PAIN,    1,  3,AI_Chase,        S_PAIN_RUN4    }, // S_PAIN_RUN3
  {SPR_PAIN,    1,  3,AI_Chase,        S_PAIN_RUN5    }, // S_PAIN_RUN4
  {SPR_PAIN,    2,  3,AI_Chase,        S_PAIN_RUN6    }, // S_PAIN_RUN5
  {SPR_PAIN,    2,  3,AI_Chase,        S_PAIN_RUN1    }, // S_PAIN_RUN6
  {SPR_PAIN,    3,  5,AI_FaceTarget,   S_PAIN_ATK2    }, // S_PAIN_ATK1
  {SPR_PAIN,    4,  5,AI_FaceTarget,   S_PAIN_ATK3    }, // S_PAIN_ATK2
  {SPR_PAIN,FFB|5,  5,AI_FaceTarget,   S_PAIN_ATK4    }, // S_PAIN_ATK3
  {SPR_PAIN,FFB|5,  0,AI_PainAttack,   S_PAIN_RUN1    }, // S_PAIN_ATK4
  {SPR_PAIN,    6,  6,AI_NULL,         S_PAIN_PAIN2   }, // S_PAIN_PAIN
  {SPR_PAIN,    6,  6,AI_Pain,         S_PAIN_RUN1    }, // S_PAIN_PAIN2
  {SPR_PAIN,FFB|7,  8,AI_NULL,         S_PAIN_DIE2    }, // S_PAIN_DIE1
  {SPR_PAIN,FFB|8,  8,AI_Scream,       S_PAIN_DIE3    }, // S_PAIN_DIE2
  {SPR_PAIN,FFB|9,  8,AI_NULL,         S_PAIN_DIE4    }, // S_PAIN_DIE3
  {SPR_PAIN,FFB|10,  8,AI_NULL,         S_PAIN_DIE5    }, // S_PAIN_DIE4
  {SPR_PAIN,FFB|11,  8,AI_PainDie,      S_PAIN_DIE6    }, // S_PAIN_DIE5
  {SPR_PAIN,FFB|12,  8,AI_NULL,         S_NULL         }, // S_PAIN_DIE6
  {SPR_PAIN,   12,  8,AI_NULL,         S_PAIN_RAISE2  }, // S_PAIN_RAISE1
  {SPR_PAIN,   11,  8,AI_NULL,         S_PAIN_RAISE3  }, // S_PAIN_RAISE2
  {SPR_PAIN,   10,  8,AI_NULL,         S_PAIN_RAISE4  }, // S_PAIN_RAISE3
  {SPR_PAIN,    9,  8,AI_NULL,         S_PAIN_RAISE5  }, // S_PAIN_RAISE4
  {SPR_PAIN,    8,  8,AI_NULL,         S_PAIN_RAISE6  }, // S_PAIN_RAISE5
  {SPR_PAIN,    7,  8,AI_NULL,         S_PAIN_RUN1    }, // S_PAIN_RAISE6
  {SPR_SSWV,    0, 10,AI_Look,         S_SSWV_STND2   }, // S_SSWV_STND
  {SPR_SSWV,    1, 10,AI_Look,         S_SSWV_STND    }, // S_SSWV_STND2
  {SPR_SSWV,    0,  3,AI_Chase,        S_SSWV_RUN2    }, // S_SSWV_RUN1
  {SPR_SSWV,    0,  3,AI_Chase,        S_SSWV_RUN3    }, // S_SSWV_RUN2
  {SPR_SSWV,    1,  3,AI_Chase,        S_SSWV_RUN4    }, // S_SSWV_RUN3
  {SPR_SSWV,    1,  3,AI_Chase,        S_SSWV_RUN5    }, // S_SSWV_RUN4
  {SPR_SSWV,    2,  3,AI_Chase,        S_SSWV_RUN6    }, // S_SSWV_RUN5
  {SPR_SSWV,    2,  3,AI_Chase,        S_SSWV_RUN7    }, // S_SSWV_RUN6
  {SPR_SSWV,    3,  3,AI_Chase,        S_SSWV_RUN8    }, // S_SSWV_RUN7
  {SPR_SSWV,    3,  3,AI_Chase,        S_SSWV_RUN1    }, // S_SSWV_RUN8
  {SPR_SSWV,    4, 10,AI_FaceTarget,   S_SSWV_ATK2    }, // S_SSWV_ATK1
  {SPR_SSWV,    5, 10,AI_FaceTarget,   S_SSWV_ATK3    }, // S_SSWV_ATK2
  {SPR_SSWV,FFB|6,  4,AI_CPosAttack,   S_SSWV_ATK4    }, // S_SSWV_ATK3
  {SPR_SSWV,    5,  6,AI_FaceTarget,   S_SSWV_ATK5    }, // S_SSWV_ATK4
  {SPR_SSWV,FFB|6,  4,AI_CPosAttack,   S_SSWV_ATK6    }, // S_SSWV_ATK5
  {SPR_SSWV,    5,  1,AI_CPosRefire,   S_SSWV_ATK2    }, // S_SSWV_ATK6
  {SPR_SSWV,    7,  3,AI_NULL,         S_SSWV_PAIN2   }, // S_SSWV_PAIN
  {SPR_SSWV,    7,  3,AI_Pain,         S_SSWV_RUN1    }, // S_SSWV_PAIN2
  {SPR_SSWV,    8,  5,AI_NULL,         S_SSWV_DIE2    }, // S_SSWV_DIE1
  {SPR_SSWV,    9,  5,AI_Scream,       S_SSWV_DIE3    }, // S_SSWV_DIE2
  {SPR_SSWV,   10,  5,AI_Fall,         S_SSWV_DIE4    }, // S_SSWV_DIE3
  {SPR_SSWV,   11,  5,AI_NULL,         S_SSWV_DIE5    }, // S_SSWV_DIE4
  {SPR_SSWV,   12, -1,AI_NULL,         S_NULL         }, // S_SSWV_DIE5
  {SPR_SSWV,   13,  5,AI_NULL,         S_SSWV_XDIE2   }, // S_SSWV_XDIE1
  {SPR_SSWV,   14,  5,AI_XScream,      S_SSWV_XDIE3   }, // S_SSWV_XDIE2
  {SPR_SSWV,   15,  5,AI_Fall,         S_SSWV_XDIE4   }, // S_SSWV_XDIE3
  {SPR_SSWV,   16,  5,AI_NULL,         S_SSWV_XDIE5   }, // S_SSWV_XDIE4
  {SPR_SSWV,   17,  5,AI_NULL,         S_SSWV_XDIE6   }, // S_SSWV_XDIE5
  {SPR_SSWV,   18,  5,AI_NULL,         S_SSWV_XDIE7   }, // S_SSWV_XDIE6
  {SPR_SSWV,   19,  5,AI_NULL,         S_SSWV_XDIE8   }, // S_SSWV_XDIE7
  {SPR_SSWV,   20,  5,AI_NULL,         S_SSWV_XDIE9   }, // S_SSWV_XDIE8
  {SPR_SSWV,   21, -1,AI_NULL,         S_NULL         }, // S_SSWV_XDIE9
  {SPR_SSWV,   12,  5,AI_NULL,         S_SSWV_RAISE2  }, // S_SSWV_RAISE1
  {SPR_SSWV,   11,  5,AI_NULL,         S_SSWV_RAISE3  }, // S_SSWV_RAISE2
  {SPR_SSWV,   10,  5,AI_NULL,         S_SSWV_RAISE4  }, // S_SSWV_RAISE3
  {SPR_SSWV,    9,  5,AI_NULL,         S_SSWV_RAISE5  }, // S_SSWV_RAISE4
  {SPR_SSWV,    8,  5,AI_NULL,         S_SSWV_RUN1    }, // S_SSWV_RAISE5
// Things, functions are acp1 (mobj)
  {SPR_KEEN,    0, -1,AI_NULL,         S_KEENSTND     }, // S_KEENSTND
  {SPR_KEEN,    0,  6,AI_NULL,         S_COMMKEEN2    }, // S_COMMKEEN
  {SPR_KEEN,    1,  6,AI_NULL,         S_COMMKEEN3    }, // S_COMMKEEN2
  {SPR_KEEN,    2,  6,AI_Scream,       S_COMMKEEN4    }, // S_COMMKEEN3
  {SPR_KEEN,    3,  6,AI_NULL,         S_COMMKEEN5    }, // S_COMMKEEN4
  {SPR_KEEN,    4,  6,AI_NULL,         S_COMMKEEN6    }, // S_COMMKEEN5
  {SPR_KEEN,    5,  6,AI_NULL,         S_COMMKEEN7    }, // S_COMMKEEN6
  {SPR_KEEN,    6,  6,AI_NULL,         S_COMMKEEN8    }, // S_COMMKEEN7
  {SPR_KEEN,    7,  6,AI_NULL,         S_COMMKEEN9    }, // S_COMMKEEN8
  {SPR_KEEN,    8,  6,AI_NULL,         S_COMMKEEN10   }, // S_COMMKEEN9
  {SPR_KEEN,    9,  6,AI_NULL,         S_COMMKEEN11   }, // S_COMMKEEN10
  {SPR_KEEN,   10,  6,AI_KeenDie,      S_COMMKEEN12   }, // S_COMMKEEN11
  {SPR_KEEN,   11, -1,AI_NULL,         S_NULL         }, // S_COMMKEEN12
  {SPR_KEEN,   12,  4,AI_NULL,         S_KEENPAIN2    }, // S_KEENPAIN
  {SPR_KEEN,   12,  8,AI_Pain,         S_KEENSTND     }, // S_KEENPAIN2
  {SPR_BBRN,    0, -1,AI_NULL,         S_NULL         }, // S_BRAIN
  {SPR_BBRN,    1, 36,AI_BrainPain,    S_BRAIN        }, // S_BRAIN_PAIN
  {SPR_BBRN,    0,100,AI_BrainScream,  S_BRAIN_DIE2   }, // S_BRAIN_DIE1
  {SPR_BBRN,    0, 10,AI_NULL,         S_BRAIN_DIE3   }, // S_BRAIN_DIE2
  {SPR_BBRN,    0, 10,AI_NULL,         S_BRAIN_DIE4   }, // S_BRAIN_DIE3
  {SPR_BBRN,    0, -1,AI_BrainDie,     S_NULL         }, // S_BRAIN_DIE4
  {SPR_SSWV,    0, 10,AI_Look,         S_BRAINEYE     }, // S_BRAINEYE
  {SPR_SSWV,    0,181,AI_BrainAwake,   S_BRAINEYE1    }, // S_BRAINEYESEE
  {SPR_SSWV,    0,150,AI_BrainSpit,    S_BRAINEYE1    }, // S_BRAINEYE1
  {SPR_BOSF,FFB|0,  3,AI_SpawnSound,   S_SPAWN2       }, // S_SPAWN1
  {SPR_BOSF,FFB|1,  3,AI_SpawnFly,     S_SPAWN3       }, // S_SPAWN2
  {SPR_BOSF,FFB|2,  3,AI_SpawnFly,     S_SPAWN4       }, // S_SPAWN3
  {SPR_BOSF,FFB|3,  3,AI_SpawnFly,     S_SPAWN1       }, // S_SPAWN4
// Things, functions are acp1 (mobj)
  {SPR_FIRE,FFB|0,  4,AI_Fire,         S_SPAWNFIRE2   }, // S_SPAWNFIRE1
  {SPR_FIRE,FFB|1,  4,AI_Fire,         S_SPAWNFIRE3   }, // S_SPAWNFIRE2
  {SPR_FIRE,FFB|2,  4,AI_Fire,         S_SPAWNFIRE4   }, // S_SPAWNFIRE3
  {SPR_FIRE,FFB|3,  4,AI_Fire,         S_SPAWNFIRE5   }, // S_SPAWNFIRE4
  {SPR_FIRE,FFB|4,  4,AI_Fire,         S_SPAWNFIRE6   }, // S_SPAWNFIRE5
  {SPR_FIRE,FFB|5,  4,AI_Fire,         S_SPAWNFIRE7   }, // S_SPAWNFIRE6
  {SPR_FIRE,FFB|6,  4,AI_Fire,         S_SPAWNFIRE8   }, // S_SPAWNFIRE7
  {SPR_FIRE,FFB|7,  4,AI_Fire,         S_NULL         },             // S_SPAWNFIRE8
  {SPR_MISL,FFB|1, 10,AI_NULL,         S_BRAINEXPLODE2}, // S_BRAINEXPLODE1
  {SPR_MISL,FFB|2, 10,AI_NULL,         S_BRAINEXPLODE3}, // S_BRAINEXPLODE2
  {SPR_MISL,FFB|3, 10,AI_BrainExplode ,S_NULL         }, // S_BRAINEXPLODE3
  {SPR_ARM1,    0,  6,AI_NULL,         S_ARM1A        }, // S_ARM1
  {SPR_ARM1,FFB|1,  7,AI_NULL,         S_ARM1         }, // S_ARM1A
  {SPR_ARM2,    0,  6,AI_NULL,         S_ARM2A        }, // S_ARM2
  {SPR_ARM2,FFB|1,  6,AI_NULL,         S_ARM2         }, // S_ARM2A
  {SPR_BAR1,    0,  6,AI_NULL,         S_BAR2         }, // S_BAR1
  {SPR_BAR1,    1,  6,AI_NULL,         S_BAR1         }, // S_BAR2
  {SPR_BEXP,FFB|0,  5,AI_NULL,         S_BEXP2        }, // S_BEXP
  {SPR_BEXP,FFB|1,  5,AI_Scream,       S_BEXP3        }, // S_BEXP2
  {SPR_BEXP,FFB|2,  5,AI_NULL,         S_BEXP4        }, // S_BEXP3
  {SPR_BEXP,FFB|3, 10,AI_Explode,      S_BEXP5        }, // S_BEXP4
  {SPR_BEXP,FFB|4, 10,AI_NULL,         S_NULL         }, // S_BEXP5
  {SPR_FCAN,FFB|0,  4,AI_NULL,         S_BBAR2        }, // S_BBAR1
  {SPR_FCAN,FFB|1,  4,AI_NULL,         S_BBAR3        }, // S_BBAR2
  {SPR_FCAN,FFB|2,  4,AI_NULL,         S_BBAR1        }, // S_BBAR3
  {SPR_BON1,    0,  6,AI_NULL,         S_BON1A        }, // S_BON1
  {SPR_BON1,    1,  6,AI_NULL,         S_BON1B        }, // S_BON1A
  {SPR_BON1,    2,  6,AI_NULL,         S_BON1C        }, // S_BON1B
  {SPR_BON1,    3,  6,AI_NULL,         S_BON1D        }, // S_BON1C
  {SPR_BON1,    2,  6,AI_NULL,         S_BON1E        }, // S_BON1D
  {SPR_BON1,    1,  6,AI_NULL,         S_BON1         }, // S_BON1E
  {SPR_BON2,    0,  6,AI_NULL,         S_BON2A        }, // S_BON2
  {SPR_BON2,    1,  6,AI_NULL,         S_BON2B        }, // S_BON2A
  {SPR_BON2,    2,  6,AI_NULL,         S_BON2C        }, // S_BON2B
  {SPR_BON2,    3,  6,AI_NULL,         S_BON2D        }, // S_BON2C
  {SPR_BON2,    2,  6,AI_NULL,         S_BON2E        }, // S_BON2D
  {SPR_BON2,    1,  6,AI_NULL,         S_BON2         }, // S_BON2E
  {SPR_BKEY,    0, 10,AI_NULL,         S_BKEY2        }, // S_BKEY
  {SPR_BKEY,FFB|1, 10,AI_NULL,         S_BKEY         }, // S_BKEY2
  {SPR_RKEY,    0, 10,AI_NULL,         S_RKEY2        }, // S_RKEY
  {SPR_RKEY,FFB|1, 10,AI_NULL,         S_RKEY         }, // S_RKEY2
  {SPR_YKEY,    0, 10,AI_NULL,         S_YKEY2        }, // S_YKEY
  {SPR_YKEY,FFB|1, 10,AI_NULL,         S_YKEY         }, // S_YKEY2
  {SPR_BSKU,    0, 10,AI_NULL,         S_BSKULL2      }, // S_BSKULL
  {SPR_BSKU,FFB|1, 10,AI_NULL,         S_BSKULL       }, // S_BSKULL2
  {SPR_RSKU,    0, 10,AI_NULL,         S_RSKULL2      }, // S_RSKULL
  {SPR_RSKU,FFB|1, 10,AI_NULL,         S_RSKULL       }, // S_RSKULL2
  {SPR_YSKU,    0, 10,AI_NULL,         S_YSKULL2      }, // S_YSKULL
  {SPR_YSKU,FFB|1, 10,AI_NULL,         S_YSKULL       }, // S_YSKULL2
  {SPR_STIM,    0, -1,AI_NULL,         S_NULL         }, // S_STIM
  {SPR_MEDI,    0, -1,AI_NULL,         S_NULL         }, // S_MEDI
  {SPR_SOUL,FFB|0,  6,AI_NULL,         S_SOUL2        }, // S_SOUL
  {SPR_SOUL,FFB|1,  6,AI_NULL,         S_SOUL3        }, // S_SOUL2
  {SPR_SOUL,FFB|2,  6,AI_NULL,         S_SOUL4        }, // S_SOUL3
  {SPR_SOUL,FFB|3,  6,AI_NULL,         S_SOUL5        }, // S_SOUL4
  {SPR_SOUL,FFB|2,  6,AI_NULL,         S_SOUL6        }, // S_SOUL5
  {SPR_SOUL,FFB|1,  6,AI_NULL,         S_SOUL         }, // S_SOUL6
  {SPR_PINV,FFB|0,  6,AI_NULL,         S_PINV2        }, // S_PINV
  {SPR_PINV,FFB|1,  6,AI_NULL,         S_PINV3        }, // S_PINV2
  {SPR_PINV,FFB|2,  6,AI_NULL,         S_PINV4        }, // S_PINV3
  {SPR_PINV,FFB|3,  6,AI_NULL,         S_PINV         }, // S_PINV4
  {SPR_PSTR,FFB|0, -1,AI_NULL,         S_NULL         }, // S_PSTR
  {SPR_PINS,FFB|0,  6,AI_NULL,         S_PINS2        }, // S_PINS
  {SPR_PINS,FFB|1,  6,AI_NULL,         S_PINS3        }, // S_PINS2
  {SPR_PINS,FFB|2,  6,AI_NULL,         S_PINS4        }, // S_PINS3
  {SPR_PINS,FFB|3,  6,AI_NULL,         S_PINS         }, // S_PINS4
  {SPR_MEGA,FFB|0,  6,AI_NULL,         S_MEGA2        }, // S_MEGA
  {SPR_MEGA,FFB|1,  6,AI_NULL,         S_MEGA3        }, // S_MEGA2
  {SPR_MEGA,FFB|2,  6,AI_NULL,         S_MEGA4        }, // S_MEGA3
  {SPR_MEGA,FFB|3,  6,AI_NULL,         S_MEGA         }, // S_MEGA4
  {SPR_SUIT,FFB|0, -1,AI_NULL,         S_NULL         }, // S_SUIT
  {SPR_PMAP,FFB|0,  6,AI_NULL,         S_PMAP2        }, // S_PMAP
  {SPR_PMAP,FFB|1,  6,AI_NULL,         S_PMAP3        }, // S_PMAP2
  {SPR_PMAP,FFB|2,  6,AI_NULL,         S_PMAP4        }, // S_PMAP3
  {SPR_PMAP,FFB|3,  6,AI_NULL,         S_PMAP5        }, // S_PMAP4
  {SPR_PMAP,FFB|2,  6,AI_NULL,         S_PMAP6        }, // S_PMAP5
  {SPR_PMAP,FFB|1,  6,AI_NULL,         S_PMAP         }, // S_PMAP6
  {SPR_PVIS,FFB|0,  6,AI_NULL,         S_PVIS2        }, // S_PVIS
  {SPR_PVIS,    1,  6,AI_NULL,         S_PVIS         }, // S_PVIS2
  {SPR_CLIP,    0, -1,AI_NULL,         S_NULL         }, // S_CLIP
  {SPR_AMMO,    0, -1,AI_NULL,         S_NULL         }, // S_AMMO
  {SPR_ROCK,    0, -1,AI_NULL,         S_NULL         }, // S_ROCK
  {SPR_BROK,    0, -1,AI_NULL,         S_NULL         }, // S_BROK
  {SPR_CELL,    0, -1,AI_NULL,         S_NULL         }, // S_CELL
  {SPR_CELP,    0, -1,AI_NULL,         S_NULL         }, // S_CELP
  {SPR_SHEL,    0, -1,AI_NULL,         S_NULL         }, // S_SHEL
  {SPR_SBOX,    0, -1,AI_NULL,         S_NULL         }, // S_SBOX
  {SPR_BPAK,    0, -1,AI_NULL,         S_NULL         }, // S_BPAK
  {SPR_BFUG,    0, -1,AI_NULL,         S_NULL         }, // S_BFUG
  {SPR_MGUN,    0, -1,AI_NULL,         S_NULL         }, // S_MGUN
  {SPR_CSAW,    0, -1,AI_NULL,         S_NULL         }, // S_CSAW
  {SPR_LAUN,    0, -1,AI_NULL,         S_NULL         }, // S_LAUN
  {SPR_PLAS,    0, -1,AI_NULL,         S_NULL         }, // S_PLAS
  {SPR_SHOT,    0, -1,AI_NULL,         S_NULL         }, // S_SHOT
  {SPR_SGN2,    0, -1,AI_NULL,         S_NULL         }, // S_SHOT2
  {SPR_COLU,FFB|0, -1,AI_NULL,         S_NULL         }, // S_COLU
  {SPR_SMT2,    0, -1,AI_NULL,         S_NULL         }, // S_STALAG
  {SPR_GOR1,    0, 10,AI_NULL,         S_BLOODYTWITCH2}, // S_BLOODYTWITCH
  {SPR_GOR1,    1, 15,AI_NULL,         S_BLOODYTWITCH3}, // S_BLOODYTWITCH2
  {SPR_GOR1,    2,  8,AI_NULL,         S_BLOODYTWITCH4}, // S_BLOODYTWITCH3
  {SPR_GOR1,    1,  6,AI_NULL,         S_BLOODYTWITCH }, // S_BLOODYTWITCH4
  {SPR_PLAY,   13, -1,AI_NULL,         S_NULL         }, // S_DEADTORSO
  {SPR_PLAY,   18, -1,AI_NULL,         S_NULL         }, // S_DEADBOTTOM
  {SPR_POL2,    0, -1,AI_NULL,         S_NULL         }, // S_HEADSONSTICK
  {SPR_POL5,    0, -1,AI_NULL,         S_NULL         }, // S_GIBS
  {SPR_POL4,    0, -1,AI_NULL,         S_NULL         }, // S_HEADONASTICK
  {SPR_POL3,FFB|0,  6,AI_NULL,         S_HEADCANDLES2 }, // S_HEADCANDLES
  {SPR_POL3,FFB|1,  6,AI_NULL,         S_HEADCANDLES  }, // S_HEADCANDLES2
  {SPR_POL1,    0, -1,AI_NULL,         S_NULL         }, // S_DEADSTICK
  {SPR_POL6,    0,  6,AI_NULL,         S_LIVESTICK2   }, // S_LIVESTICK
  {SPR_POL6,    1,  8,AI_NULL,         S_LIVESTICK    }, // S_LIVESTICK2
  {SPR_GOR2,    0, -1,AI_NULL,         S_NULL         }, // S_MEAT2
  {SPR_GOR3,    0, -1,AI_NULL,         S_NULL         }, // S_MEAT3
  {SPR_GOR4,    0, -1,AI_NULL,         S_NULL         }, // S_MEAT4
  {SPR_GOR5,    0, -1,AI_NULL,         S_NULL         }, // S_MEAT5
  {SPR_SMIT,    0, -1,AI_NULL,         S_NULL         }, // S_STALAGTITE
  {SPR_COL1,    0, -1,AI_NULL,         S_NULL         }, // S_TALLGRNCOL
  {SPR_COL2,    0, -1,AI_NULL,         S_NULL         }, // S_SHRTGRNCOL
  {SPR_COL3,    0, -1,AI_NULL,         S_NULL         }, // S_TALLREDCOL
  {SPR_COL4,    0, -1,AI_NULL,         S_NULL         }, // S_SHRTREDCOL
  {SPR_CAND,FFB|0, -1,AI_NULL,         S_NULL         }, // S_CANDLESTIK
  {SPR_CBRA,FFB|0, -1,AI_NULL,         S_NULL         }, // S_CANDELABRA
  {SPR_COL6,    0, -1,AI_NULL,         S_NULL         }, // S_SKULLCOL
  {SPR_TRE1,    0, -1,AI_NULL,         S_NULL         }, // S_TORCHTREE
  {SPR_TRE2,    0, -1,AI_NULL,         S_NULL         }, // S_BIGTREE
  {SPR_ELEC,    0, -1,AI_NULL,         S_NULL         }, // S_TECHPILLAR
  {SPR_CEYE,FFB|0,  6,AI_NULL,         S_EVILEYE2     }, // S_EVILEYE
  {SPR_CEYE,FFB|1,  6,AI_NULL,         S_EVILEYE3     }, // S_EVILEYE2
  {SPR_CEYE,FFB|2,  6,AI_NULL,         S_EVILEYE4     }, // S_EVILEYE3
  {SPR_CEYE,FFB|1,  6,AI_NULL,         S_EVILEYE      }, // S_EVILEYE4
  {SPR_FSKU,FFB|0,  6,AI_NULL,         S_FLOATSKULL2  }, // S_FLOATSKULL
  {SPR_FSKU,FFB|1,  6,AI_NULL,         S_FLOATSKULL3  }, // S_FLOATSKULL2
  {SPR_FSKU,FFB|2,  6,AI_NULL,         S_FLOATSKULL   }, // S_FLOATSKULL3
  {SPR_COL5,    0, 14,AI_NULL,         S_HEARTCOL2    }, // S_HEARTCOL
  {SPR_COL5,    1, 14,AI_NULL,         S_HEARTCOL     }, // S_HEARTCOL2
  {SPR_TBLU,FFB|0,  4,AI_NULL,         S_BLUETORCH2   }, // S_BLUETORCH
  {SPR_TBLU,FFB|1,  4,AI_NULL,         S_BLUETORCH3   }, // S_BLUETORCH2
  {SPR_TBLU,FFB|2,  4,AI_NULL,         S_BLUETORCH4   }, // S_BLUETORCH3
  {SPR_TBLU,FFB|3,  4,AI_NULL,         S_BLUETORCH    }, // S_BLUETORCH4
  {SPR_TGRN,FFB|0,  4,AI_NULL,         S_GREENTORCH2  }, // S_GREENTORCH
  {SPR_TGRN,FFB|1,  4,AI_NULL,         S_GREENTORCH3  }, // S_GREENTORCH2
  {SPR_TGRN,FFB|2,  4,AI_NULL,         S_GREENTORCH4  }, // S_GREENTORCH3
  {SPR_TGRN,FFB|3,  4,AI_NULL,         S_GREENTORCH   }, // S_GREENTORCH4
  {SPR_TRED,FFB|0,  4,AI_NULL,         S_REDTORCH2    }, // S_REDTORCH
  {SPR_TRED,FFB|1,  4,AI_NULL,         S_REDTORCH3    }, // S_REDTORCH2
  {SPR_TRED,FFB|2,  4,AI_NULL,         S_REDTORCH4    }, // S_REDTORCH3
  {SPR_TRED,FFB|3,  4,AI_NULL,         S_REDTORCH     }, // S_REDTORCH4
  {SPR_SMBT,FFB|0,  4,AI_NULL,         S_BTORCHSHRT2  }, // S_BTORCHSHRT
  {SPR_SMBT,FFB|1,  4,AI_NULL,         S_BTORCHSHRT3  }, // S_BTORCHSHRT2
  {SPR_SMBT,FFB|2,  4,AI_NULL,         S_BTORCHSHRT4  }, // S_BTORCHSHRT3
  {SPR_SMBT,FFB|3,  4,AI_NULL,         S_BTORCHSHRT   }, // S_BTORCHSHRT4
  {SPR_SMGT,FFB|0,  4,AI_NULL,         S_GTORCHSHRT2  }, // S_GTORCHSHRT
  {SPR_SMGT,FFB|1,  4,AI_NULL,         S_GTORCHSHRT3  }, // S_GTORCHSHRT2
  {SPR_SMGT,FFB|2,  4,AI_NULL,         S_GTORCHSHRT4  }, // S_GTORCHSHRT3
  {SPR_SMGT,FFB|3,  4,AI_NULL,         S_GTORCHSHRT   }, // S_GTORCHSHRT4
  {SPR_SMRT,FFB|0,  4,AI_NULL,         S_RTORCHSHRT2  }, // S_RTORCHSHRT
  {SPR_SMRT,FFB|1,  4,AI_NULL,         S_RTORCHSHRT3  }, // S_RTORCHSHRT2
  {SPR_SMRT,FFB|2,  4,AI_NULL,         S_RTORCHSHRT4  }, // S_RTORCHSHRT3
  {SPR_SMRT,FFB|3,  4,AI_NULL,         S_RTORCHSHRT   }, // S_RTORCHSHRT4
  {SPR_HDB1,    0, -1,AI_NULL,         S_NULL         }, // S_HANGNOGUTS
  {SPR_HDB2,    0, -1,AI_NULL,         S_NULL         }, // S_HANGBNOBRAIN
  {SPR_HDB3,    0, -1,AI_NULL,         S_NULL         }, // S_HANGTLOOKDN
  {SPR_HDB4,    0, -1,AI_NULL,         S_NULL         }, // S_HANGTSKULL
  {SPR_HDB5,    0, -1,AI_NULL,         S_NULL         }, // S_HANGTLOOKUP
  {SPR_HDB6,    0, -1,AI_NULL,         S_NULL         }, // S_HANGTNOBRAIN
  {SPR_POB1,    0, -1,AI_NULL,         S_NULL         }, // S_COLONGIBS
  {SPR_POB2,    0, -1,AI_NULL,         S_NULL         }, // S_SMALLPOOL
  {SPR_BRS1,    0, -1,AI_NULL,         S_NULL         }, // S_BRAINSTEM
  {SPR_TLMP,FFB|0,  4,AI_NULL,         S_TECHLAMP2    }, // S_TECHLAMP
  {SPR_TLMP,FFB|1,  4,AI_NULL,         S_TECHLAMP3    }, // S_TECHLAMP2
  {SPR_TLMP,FFB|2,  4,AI_NULL,         S_TECHLAMP4    }, // S_TECHLAMP3
  {SPR_TLMP,FFB|3,  4,AI_NULL,         S_TECHLAMP     }, // S_TECHLAMP4
  {SPR_TLP2,FFB|0,  4,AI_NULL,         S_TECH2LAMP2   }, // S_TECH2LAMP
  {SPR_TLP2,FFB|1,  4,AI_NULL,         S_TECH2LAMP3   }, // S_TECH2LAMP2
  {SPR_TLP2,FFB|2,  4,AI_NULL,         S_TECH2LAMP4   }, // S_TECH2LAMP3
  {SPR_TLP2,FFB|3,  4,AI_NULL,         S_TECH2LAMP    }, // S_TECH2LAMP4

    //smoke test
  {SPR_SMOK,    0,  4,AI_NULL,         S_SMOK2        }, // S_SMOK1
  {SPR_SMOK,    1,  5,AI_NULL,         S_SMOK3        }, // S_SMOK2
  {SPR_SMOK,    2,  6,AI_NULL,         S_SMOK4        }, // S_SMOK3
  {SPR_SMOK,    3,  7,AI_NULL,         S_SMOK5        }, // S_SMOK4
  {SPR_SMOK,    4,  8,AI_NULL,         S_NULL         }, // S_SMOK5

    //water splash test
  {SPR_SPLA,    0,  8,AI_NULL,         S_SPLASH2      }, // S_SPLASH1
  {SPR_SPLA,    1,  8,AI_NULL,         S_SPLASH3      }, // S_SPLASH2
  {SPR_SPLA,    2,  8,AI_NULL,         S_NULL         }, // S_SPLASH3

  {SPR_TNT1,    0, -1,AI_NULL,         S_TNT1          }, // S_TNT1    //SoM: 3/8/2000

    // heretic stuff

// Things, functions are acp1 (mobj)
  {SPR_ACLO,    4,1050, AI_FreeTargMobj,    S_NULL          },  // S_FREETARGMOBJ
  {SPR_PTN1,    0,   3, AI_NULL,            S_ITEM_PTN1_2   },  // S_ITEM_PTN1_1
  {SPR_PTN1,    1,   3, AI_NULL,            S_ITEM_PTN1_3   },  // S_ITEM_PTN1_2
  {SPR_PTN1,    2,   3, AI_NULL,            S_ITEM_PTN1_1   },  // S_ITEM_PTN1_3
  {SPR_SHLD,    0,  -1, AI_NULL,            S_NULL          },  // S_ITEM_SHLD1
  {SPR_SHD2,    0,  -1, AI_NULL,            S_NULL          },  // S_ITEM_SHD2_1
  {SPR_BAGH,    0,  -1, AI_NULL,            S_NULL          },  // S_ITEM_BAGH1
  {SPR_SPMP,    0,  -1, AI_NULL,            S_NULL          },  // S_ITEM_SPMP1
  {SPR_ACLO,    4,1400, AI_NULL,            S_HIDESPECIAL2  },  // S_HIDESPECIAL1
  {SPR_ACLO,    0,   4, AI_RestoreSpecialThing1, S_HIDESPECIAL3},// S_HIDESPECIAL2
  {SPR_ACLO,    1,   4, AI_NULL,            S_HIDESPECIAL4  },  // S_HIDESPECIAL3
  {SPR_ACLO,    0,   4, AI_NULL,            S_HIDESPECIAL5  },  // S_HIDESPECIAL4
  {SPR_ACLO,    1,   4, AI_NULL,            S_HIDESPECIAL6  },  // S_HIDESPECIAL5
  {SPR_ACLO,    2,   4, AI_NULL,            S_HIDESPECIAL7  },  // S_HIDESPECIAL6
  {SPR_ACLO,    1,   4, AI_NULL,            S_HIDESPECIAL8  },  // S_HIDESPECIAL7
  {SPR_ACLO,    2,   4, AI_NULL,            S_HIDESPECIAL9  },  // S_HIDESPECIAL8
  {SPR_ACLO,    3,   4, AI_NULL,            S_HIDESPECIAL10 },  // S_HIDESPECIAL9
  {SPR_ACLO,    2,   4, AI_NULL,            S_HIDESPECIAL11 },  // S_HIDESPECIAL10
  {SPR_ACLO,    3,   4, AI_RestoreSpecialThing2, S_NULL      },  // S_HIDESPECIAL11
  {SPR_ACLO,    3,   3, AI_NULL,            S_DORMANTARTI2  },  // S_DORMANTARTI1
  {SPR_ACLO,    2,   3, AI_NULL,            S_DORMANTARTI3  },  // S_DORMANTARTI2
  {SPR_ACLO,    3,   3, AI_NULL,            S_DORMANTARTI4  },  // S_DORMANTARTI3
  {SPR_ACLO,    2,   3, AI_NULL,            S_DORMANTARTI5  },  // S_DORMANTARTI4
  {SPR_ACLO,    1,   3, AI_NULL,            S_DORMANTARTI6  },  // S_DORMANTARTI5
  {SPR_ACLO,    2,   3, AI_NULL,            S_DORMANTARTI7  },  // S_DORMANTARTI6
  {SPR_ACLO,    1,   3, AI_NULL,            S_DORMANTARTI8  },  // S_DORMANTARTI7
  {SPR_ACLO,    0,   3, AI_NULL,            S_DORMANTARTI9  },  // S_DORMANTARTI8
  {SPR_ACLO,    1,   3, AI_NULL,            S_DORMANTARTI10 },  // S_DORMANTARTI9
  {SPR_ACLO,    0,   3, AI_NULL,            S_DORMANTARTI11 },  // S_DORMANTARTI10
  {SPR_ACLO,    0,1400, AI_HideThing,       S_DORMANTARTI12 },  // S_DORMANTARTI11
  {SPR_ACLO,    0,   3, AI_UnHideThing,     S_DORMANTARTI13 },  // S_DORMANTARTI12
  {SPR_ACLO,    1,   3, AI_NULL,            S_DORMANTARTI14 },  // S_DORMANTARTI13
  {SPR_ACLO,    0,   3, AI_NULL,            S_DORMANTARTI15 },  // S_DORMANTARTI14
  {SPR_ACLO,    1,   3, AI_NULL,            S_DORMANTARTI16 },  // S_DORMANTARTI15
  {SPR_ACLO,    2,   3, AI_NULL,            S_DORMANTARTI17 },  // S_DORMANTARTI16
  {SPR_ACLO,    1,   3, AI_NULL,            S_DORMANTARTI18 },  // S_DORMANTARTI17
  {SPR_ACLO,    2,   3, AI_NULL,            S_DORMANTARTI19 },  // S_DORMANTARTI18
  {SPR_ACLO,    3,   3, AI_NULL,            S_DORMANTARTI20 },  // S_DORMANTARTI19
  {SPR_ACLO,    2,   3, AI_NULL,            S_DORMANTARTI21 },  // S_DORMANTARTI20
  {SPR_ACLO,    3,   3, AI_RestoreArtifact,   S_NULL          },  // S_DORMANTARTI21
  {SPR_ACLO,    3,   3, AI_NULL,            S_DEADARTI2     },  // S_DEADARTI1
  {SPR_ACLO,    2,   3, AI_NULL,            S_DEADARTI3     },  // S_DEADARTI2
  {SPR_ACLO,    3,   3, AI_NULL,            S_DEADARTI4     },  // S_DEADARTI3
  {SPR_ACLO,    2,   3, AI_NULL,            S_DEADARTI5     },  // S_DEADARTI4
  {SPR_ACLO,    1,   3, AI_NULL,            S_DEADARTI6     },  // S_DEADARTI5
  {SPR_ACLO,    2,   3, AI_NULL,            S_DEADARTI7     },  // S_DEADARTI6
  {SPR_ACLO,    1,   3, AI_NULL,            S_DEADARTI8     },  // S_DEADARTI7
  {SPR_ACLO,    0,   3, AI_NULL,            S_DEADARTI9     },  // S_DEADARTI8
  {SPR_ACLO,    1,   3, AI_NULL,            S_DEADARTI10    },  // S_DEADARTI9
  {SPR_ACLO,    0,   3, AI_NULL,            S_NULL          },  // S_DEADARTI10
  {SPR_INVS,FFB|0, 350, AI_NULL,            S_ARTI_INVS1    },  // S_ARTI_INVS1
  {SPR_PTN2,    0,   4, AI_NULL,            S_ARTI_PTN2_2   },  // S_ARTI_PTN2_1
  {SPR_PTN2,    1,   4, AI_NULL,            S_ARTI_PTN2_3   },  // S_ARTI_PTN2_2
  {SPR_PTN2,    2,   4, AI_NULL,            S_ARTI_PTN2_1   },  // S_ARTI_PTN2_3
  {SPR_SOAR,    0,   5, AI_NULL,            S_ARTI_SOAR2    },  // S_ARTI_SOAR1
  {SPR_SOAR,    1,   5, AI_NULL,            S_ARTI_SOAR3    },  // S_ARTI_SOAR2
  {SPR_SOAR,    2,   5, AI_NULL,            S_ARTI_SOAR4    },  // S_ARTI_SOAR3
  {SPR_SOAR,    1,   5, AI_NULL,            S_ARTI_SOAR1    },  // S_ARTI_SOAR4
  {SPR_INVU,    0,   3, AI_NULL,            S_ARTI_INVU2    },  // S_ARTI_INVU1
  {SPR_INVU,    1,   3, AI_NULL,            S_ARTI_INVU3    },  // S_ARTI_INVU2
  {SPR_INVU,    2,   3, AI_NULL,            S_ARTI_INVU4    },  // S_ARTI_INVU3
  {SPR_INVU,    3,   3, AI_NULL,            S_ARTI_INVU1    },  // S_ARTI_INVU4
  {SPR_PWBK,    0, 350, AI_NULL,            S_ARTI_PWBK1    },  // S_ARTI_PWBK1
  {SPR_EGGC,    0,   6, AI_NULL,            S_ARTI_EGGC2    },  // S_ARTI_EGGC1
  {SPR_EGGC,    1,   6, AI_NULL,            S_ARTI_EGGC3    },  // S_ARTI_EGGC2
  {SPR_EGGC,    2,   6, AI_NULL,            S_ARTI_EGGC4    },  // S_ARTI_EGGC3
  {SPR_EGGC,    1,   6, AI_NULL,            S_ARTI_EGGC1    },  // S_ARTI_EGGC4
  {SPR_EGGM,    0,   4, AI_NULL,            S_EGGFX2        },  // S_EGGFX1
  {SPR_EGGM,    1,   4, AI_NULL,            S_EGGFX3        },  // S_EGGFX2
  {SPR_EGGM,    2,   4, AI_NULL,            S_EGGFX4        },  // S_EGGFX3
  {SPR_EGGM,    3,   4, AI_NULL,            S_EGGFX5        },  // S_EGGFX4
  {SPR_EGGM,    4,   4, AI_NULL,            S_EGGFX1        },  // S_EGGFX5
  {SPR_FX01,FFB|4,   3, AI_NULL,            S_EGGFXI1_2     },  // S_EGGFXI1_1
  {SPR_FX01,FFB|5,   3, AI_NULL,            S_EGGFXI1_3     },  // S_EGGFXI1_2
  {SPR_FX01,FFB|6,   3, AI_NULL,            S_EGGFXI1_4     },  // S_EGGFXI1_3
  {SPR_FX01,FFB|7,   3, AI_NULL,            S_NULL          },  // S_EGGFXI1_4
  {SPR_SPHL,    0, 350, AI_NULL,            S_ARTI_SPHL1    },  // S_ARTI_SPHL1
  {SPR_TRCH,FFB|0,   3, AI_NULL,            S_ARTI_TRCH2    },  // S_ARTI_TRCH1
  {SPR_TRCH,FFB|1,   3, AI_NULL,            S_ARTI_TRCH3    },  // S_ARTI_TRCH2
  {SPR_TRCH,FFB|2,   3, AI_NULL,            S_ARTI_TRCH1    },  // S_ARTI_TRCH3
  {SPR_FBMB,    4, 350, AI_NULL,            S_ARTI_FBMB1    },  // S_ARTI_FBMB1
  {SPR_FBMB,    0,  10, AI_NULL,            S_FIREBOMB2     },  // S_FIREBOMB1
  {SPR_FBMB,    1,  10, AI_NULL,            S_FIREBOMB3     },  // S_FIREBOMB2
  {SPR_FBMB,    2,  10, AI_NULL,            S_FIREBOMB4     },  // S_FIREBOMB3
  {SPR_FBMB,    3,  10, AI_NULL,            S_FIREBOMB5     },  // S_FIREBOMB4
  {SPR_FBMB,    4,   6, AI_HScream,         S_FIREBOMB6     },  // S_FIREBOMB5
  {SPR_XPL1,FFB|0,   4, AI_Explode,         S_FIREBOMB7     },  // S_FIREBOMB6
  {SPR_XPL1,FFB|1,   4, AI_NULL,            S_FIREBOMB8     },  // S_FIREBOMB7
  {SPR_XPL1,FFB|2,   4, AI_NULL,            S_FIREBOMB9     },  // S_FIREBOMB8
  {SPR_XPL1,FFB|3,   4, AI_NULL,            S_FIREBOMB10    },  // S_FIREBOMB9
  {SPR_XPL1,FFB|4,   4, AI_NULL,            S_FIREBOMB11    },  // S_FIREBOMB10
  {SPR_XPL1,FFB|5,   4, AI_NULL,            S_NULL          },  // S_FIREBOMB11
  {SPR_ATLP,    0,   4, AI_NULL,            S_ARTI_ATLP2    },  // S_ARTI_ATLP1
  {SPR_ATLP,    1,   4, AI_NULL,            S_ARTI_ATLP3    },  // S_ARTI_ATLP2
  {SPR_ATLP,    2,   4, AI_NULL,            S_ARTI_ATLP4    },  // S_ARTI_ATLP3
  {SPR_ATLP,    1,   4, AI_NULL,            S_ARTI_ATLP1    },  // S_ARTI_ATLP4
  {SPR_PPOD,    0,  10, AI_NULL,            S_POD_WAIT1     },  // S_POD_WAIT1
  {SPR_PPOD,    1,  14, AI_PodPain,         S_POD_WAIT1     },  // S_POD_PAIN1
  {SPR_PPOD,FFB|2,   5, AI_RemovePod,       S_POD_DIE2      },  // S_POD_DIE1
  {SPR_PPOD,FFB|3,   5, AI_HScream,         S_POD_DIE3      },  // S_POD_DIE2
  {SPR_PPOD,FFB|4,   5, AI_Explode,         S_POD_DIE4      },  // S_POD_DIE3
  {SPR_PPOD,FFB|5,  10, AI_NULL,            S_FREETARGMOBJ  },  // S_POD_DIE4
  {SPR_PPOD,    8,   3, AI_NULL,            S_POD_GROW2     },  // S_POD_GROW1
  {SPR_PPOD,    9,   3, AI_NULL,            S_POD_GROW3     },  // S_POD_GROW2
  {SPR_PPOD,   10,   3, AI_NULL,            S_POD_GROW4     },  // S_POD_GROW3
  {SPR_PPOD,   11,   3, AI_NULL,            S_POD_GROW5     },  // S_POD_GROW4
  {SPR_PPOD,   12,   3, AI_NULL,            S_POD_GROW6     },  // S_POD_GROW5
  {SPR_PPOD,   13,   3, AI_NULL,            S_POD_GROW7     },  // S_POD_GROW6
  {SPR_PPOD,   14,   3, AI_NULL,            S_POD_GROW8     },  // S_POD_GROW7
  {SPR_PPOD,   15,   3, AI_NULL,            S_POD_WAIT1     },  // S_POD_GROW8
  {SPR_PPOD,    6,   8, AI_NULL,            S_PODGOO2       },  // S_PODGOO1
  {SPR_PPOD,    7,   8, AI_NULL,            S_PODGOO1       },  // S_PODGOO2
  {SPR_PPOD,    6,  10, AI_NULL,            S_NULL          },  // S_PODGOOX
  {SPR_AMG1,    0,  35, AI_MakePod,         S_PODGENERATOR  },  // S_PODGENERATOR
  {SPR_SPSH,    0,   8, AI_NULL,            S_HSPLASH2      },  // S_HSPLASH1
  {SPR_SPSH,    1,   8, AI_NULL,            S_HSPLASH3      },  // S_HSPLASH2
  {SPR_SPSH,    2,   8, AI_NULL,            S_HSPLASH4      },  // S_HSPLASH3
  {SPR_SPSH,    3,  16, AI_NULL,            S_NULL          },  // S_HSPLASH4
  {SPR_SPSH,    3,  10, AI_NULL,            S_NULL          },  // S_SPLASHX
  {SPR_SPSH,    4,   5, AI_NULL,            S_SPLASHBASE2   },  // S_SPLASHBASE1
  {SPR_SPSH,    5,   5, AI_NULL,            S_SPLASHBASE3   },  // S_SPLASHBASE2
  {SPR_SPSH,    6,   5, AI_NULL,            S_SPLASHBASE4   },  // S_SPLASHBASE3
  {SPR_SPSH,    7,   5, AI_NULL,            S_SPLASHBASE5   },  // S_SPLASHBASE4
  {SPR_SPSH,    8,   5, AI_NULL,            S_SPLASHBASE6   },  // S_SPLASHBASE5
  {SPR_SPSH,    9,   5, AI_NULL,            S_SPLASHBASE7   },  // S_SPLASHBASE6
  {SPR_SPSH,   10,   5, AI_NULL,            S_NULL          },  // S_SPLASHBASE7
  {SPR_LVAS,FFB|0,   5, AI_NULL,            S_LAVASPLASH2   },  // S_LAVASPLASH1
  {SPR_LVAS,FFB|1,   5, AI_NULL,            S_LAVASPLASH3   },  // S_LAVASPLASH2
  {SPR_LVAS,FFB|2,   5, AI_NULL,            S_LAVASPLASH4   },  // S_LAVASPLASH3
  {SPR_LVAS,FFB|3,   5, AI_NULL,            S_LAVASPLASH5   },  // S_LAVASPLASH4
  {SPR_LVAS,FFB|4,   5, AI_NULL,            S_LAVASPLASH6   },  // S_LAVASPLASH5
  {SPR_LVAS,FFB|5,   5, AI_NULL,            S_NULL          },  // S_LAVASPLASH6
  {SPR_LVAS,FFB|6,   5, AI_NULL,            S_LAVASMOKE2    },  // S_LAVASMOKE1
  {SPR_LVAS,FFB|7,   5, AI_NULL,            S_LAVASMOKE3    },  // S_LAVASMOKE2
  {SPR_LVAS,FFB|8,   5, AI_NULL,            S_LAVASMOKE4    },  // S_LAVASMOKE3
  {SPR_LVAS,FFB|9,   5, AI_NULL,            S_LAVASMOKE5    },  // S_LAVASMOKE4
  {SPR_LVAS,FFB|10,   5, AI_NULL,            S_NULL          },  // S_LAVASMOKE5
  {SPR_SLDG,    0,   8, AI_NULL,            S_SLUDGECHUNK2  },  // S_SLUDGECHUNK1
  {SPR_SLDG,    1,   8, AI_NULL,            S_SLUDGECHUNK3  },  // S_SLUDGECHUNK2
  {SPR_SLDG,    2,   8, AI_NULL,            S_SLUDGECHUNK4  },  // S_SLUDGECHUNK3
  {SPR_SLDG,    3,   8, AI_NULL,            S_NULL          },  // S_SLUDGECHUNK4
  {SPR_SLDG,    3,   6, AI_NULL,            S_NULL          },  // S_SLUDGECHUNKX
  {SPR_SLDG,    4,   5, AI_NULL,            S_SLUDGESPLASH2 },  // S_SLUDGESPLASH1
  {SPR_SLDG,    5,   5, AI_NULL,            S_SLUDGESPLASH3 },  // S_SLUDGESPLASH2
  {SPR_SLDG,    6,   5, AI_NULL,            S_SLUDGESPLASH4 },  // S_SLUDGESPLASH3
  {SPR_SLDG,    7,   5, AI_NULL,            S_NULL          },  // S_SLUDGESPLASH4
  {SPR_SKH1,    0,  -1, AI_NULL,            S_NULL          },  // S_SKULLHANG70_1
  {SPR_SKH2,    0,  -1, AI_NULL,            S_NULL          },  // S_SKULLHANG60_1
  {SPR_SKH3,    0,  -1, AI_NULL,            S_NULL          },  // S_SKULLHANG45_1
  {SPR_SKH4,    0,  -1, AI_NULL,            S_NULL          },  // S_SKULLHANG35_1
  {SPR_CHDL,    0,   4, AI_NULL,            S_CHANDELIER2   },  // S_CHANDELIER1
  {SPR_CHDL,    1,   4, AI_NULL,            S_CHANDELIER3   },  // S_CHANDELIER2
  {SPR_CHDL,    2,   4, AI_NULL,            S_CHANDELIER1   },  // S_CHANDELIER3
  {SPR_SRTC,    0,   4, AI_NULL,            S_SERPTORCH2    },  // S_SERPTORCH1
  {SPR_SRTC,    1,   4, AI_NULL,            S_SERPTORCH3    },  // S_SERPTORCH2
  {SPR_SRTC,    2,   4, AI_NULL,            S_SERPTORCH1    },  // S_SERPTORCH3
  {SPR_SMPL,    0,  -1, AI_NULL,            S_NULL          },  // S_SMALLPILLAR
  {SPR_STGS,    0,  -1, AI_NULL,            S_NULL          },  // S_STALAGMITESMALL
  {SPR_STGL,    0,  -1, AI_NULL,            S_NULL          },  // S_STALAGMITELARGE
  {SPR_STCS,    0,  -1, AI_NULL,            S_NULL          },  // S_STALACTITESMALL
  {SPR_STCL,    0,  -1, AI_NULL,            S_NULL          },  // S_STALACTITELARGE
  {SPR_KFR1,FFB|0,   3, AI_NULL,            S_FIREBRAZIER2  },  // S_FIREBRAZIER1
  {SPR_KFR1,FFB|1,   3, AI_NULL,            S_FIREBRAZIER3  },  // S_FIREBRAZIER2
  {SPR_KFR1,FFB|2,   3, AI_NULL,            S_FIREBRAZIER4  },  // S_FIREBRAZIER3
  {SPR_KFR1,FFB|3,   3, AI_NULL,            S_FIREBRAZIER5  },  // S_FIREBRAZIER4
  {SPR_KFR1,FFB|4,   3, AI_NULL,            S_FIREBRAZIER6  },  // S_FIREBRAZIER5
  {SPR_KFR1,FFB|5,   3, AI_NULL,            S_FIREBRAZIER7  },  // S_FIREBRAZIER6
  {SPR_KFR1,FFB|6,   3, AI_NULL,            S_FIREBRAZIER8  },  // S_FIREBRAZIER7
  {SPR_KFR1,FFB|7,   3, AI_NULL,            S_FIREBRAZIER1  },  // S_FIREBRAZIER8
  {SPR_BARL,    0,  -1, AI_NULL,            S_NULL          },  // S_BARREL
  {SPR_BRPL,    0,  -1, AI_NULL,            S_NULL          },  // S_BRPILLAR
  {SPR_MOS1,    0,  -1, AI_NULL,            S_NULL          },  // S_MOSS1
  {SPR_MOS2,    0,  -1, AI_NULL,            S_NULL          },  // S_MOSS2
  {SPR_WTRH,FFB|0,   6, AI_NULL,            S_WALLTORCH2    },  // S_WALLTORCH1
  {SPR_WTRH,FFB|1,   6, AI_NULL,            S_WALLTORCH3    },  // S_WALLTORCH2
  {SPR_WTRH,FFB|2,   6, AI_NULL,            S_WALLTORCH1    },  // S_WALLTORCH3
  {SPR_HCOR,    0,  -1, AI_NULL,            S_NULL          },  // S_HANGINGCORPSE
  {SPR_KGZ1,    0,   1, AI_NULL,            S_KEYGIZMO2     },  // S_KEYGIZMO1
  {SPR_KGZ1,    0,   1, AI_InitKeyGizmo,    S_KEYGIZMO3     },  // S_KEYGIZMO2
  {SPR_KGZ1,    0,  -1, AI_NULL,            S_NULL          },  // S_KEYGIZMO3
  {SPR_KGZB,    0,   1, AI_NULL,            S_KGZ_START     },  // S_KGZ_START
  {SPR_KGZB,FFB|0,  -1, AI_NULL,            S_NULL          },  // S_KGZ_BLUEFLOAT1
  {SPR_KGZG,FFB|0,  -1, AI_NULL,            S_NULL          },  // S_KGZ_GREENFLOAT1
  {SPR_KGZY,FFB|0,  -1, AI_NULL,            S_NULL          },  // S_KGZ_YELLOWFLOAT1
  {SPR_VLCO,    0, 350, AI_NULL,            S_VOLCANO2      },  // S_VOLCANO1
  {SPR_VLCO,    0,  35, AI_VolcanoSet,      S_VOLCANO3      },  // S_VOLCANO2
  {SPR_VLCO,    1,   3, AI_NULL,            S_VOLCANO4      },  // S_VOLCANO3
  {SPR_VLCO,    2,   3, AI_NULL,            S_VOLCANO5      },  // S_VOLCANO4
  {SPR_VLCO,    3,   3, AI_NULL,            S_VOLCANO6      },  // S_VOLCANO5
  {SPR_VLCO,    1,   3, AI_NULL,            S_VOLCANO7      },  // S_VOLCANO6
  {SPR_VLCO,    2,   3, AI_NULL,            S_VOLCANO8      },  // S_VOLCANO7
  {SPR_VLCO,    3,   3, AI_NULL,            S_VOLCANO9      },  // S_VOLCANO8
  {SPR_VLCO,    4,  10, AI_VolcanoBlast,    S_VOLCANO2      },  // S_VOLCANO9
  {SPR_VFBL,    0,   4, AI_BeastPuff,       S_VOLCANOBALL2  },  // S_VOLCANOBALL1
  {SPR_VFBL,    1,   4, AI_BeastPuff,       S_VOLCANOBALL1  },  // S_VOLCANOBALL2
  {SPR_XPL1,    0,   4, AI_VolcBallImpact,  S_VOLCANOBALLX2 },  // S_VOLCANOBALLX1
  {SPR_XPL1,    1,   4, AI_NULL,            S_VOLCANOBALLX3 },  // S_VOLCANOBALLX2
  {SPR_XPL1,    2,   4, AI_NULL,            S_VOLCANOBALLX4 },  // S_VOLCANOBALLX3
  {SPR_XPL1,    3,   4, AI_NULL,            S_VOLCANOBALLX5 },  // S_VOLCANOBALLX4
  {SPR_XPL1,    4,   4, AI_NULL,            S_VOLCANOBALLX6 },  // S_VOLCANOBALLX5
  {SPR_XPL1,    5,   4, AI_NULL,            S_NULL          },  // S_VOLCANOBALLX6
  {SPR_VTFB,    0,   4, AI_NULL,            S_VOLCANOTBALL2 },  // S_VOLCANOTBALL1
  {SPR_VTFB,    1,   4, AI_NULL,            S_VOLCANOTBALL1 },  // S_VOLCANOTBALL2
  {SPR_SFFI,    2,   4, AI_NULL,            S_VOLCANOTBALLX2},  // S_VOLCANOTBALLX1
  {SPR_SFFI,    1,   4, AI_NULL,            S_VOLCANOTBALLX3},  // S_VOLCANOTBALLX2
  {SPR_SFFI,    0,   4, AI_NULL,            S_VOLCANOTBALLX4},  // S_VOLCANOTBALLX3
  {SPR_SFFI,    1,   4, AI_NULL,            S_VOLCANOTBALLX5},  // S_VOLCANOTBALLX4
  {SPR_SFFI,    2,   4, AI_NULL,            S_VOLCANOTBALLX6},  // S_VOLCANOTBALLX5
  {SPR_SFFI,    3,   4, AI_NULL,            S_VOLCANOTBALLX7},  // S_VOLCANOTBALLX6
  {SPR_SFFI,    4,   4, AI_NULL,            S_NULL          },  // S_VOLCANOTBALLX7
  {SPR_TGLT,    0,   8, AI_SpawnTeleGlitter, S_TELEGLITGEN1  },  // S_TELEGLITGEN1
  {SPR_TGLT,    5,   8, AI_SpawnTeleGlitter2, S_TELEGLITGEN2 },  // S_TELEGLITGEN2
  {SPR_TGLT,FFB|0,   2, AI_NULL,            S_TELEGLITTER1_2},  // S_TELEGLITTER1_1
  {SPR_TGLT,FFB|1,   2, AI_AccTeleGlitter,  S_TELEGLITTER1_3},  // S_TELEGLITTER1_2
  {SPR_TGLT,FFB|2,   2, AI_NULL,            S_TELEGLITTER1_4},  // S_TELEGLITTER1_3
  {SPR_TGLT,FFB|3,   2, AI_AccTeleGlitter,  S_TELEGLITTER1_5},  // S_TELEGLITTER1_4
  {SPR_TGLT,FFB|4,   2, AI_NULL,            S_TELEGLITTER1_1},  // S_TELEGLITTER1_5
  {SPR_TGLT,FFB|5,   2, AI_NULL,            S_TELEGLITTER2_2},  // S_TELEGLITTER2_1
  {SPR_TGLT,FFB|6,   2, AI_AccTeleGlitter,  S_TELEGLITTER2_3},  // S_TELEGLITTER2_2
  {SPR_TGLT,FFB|7,   2, AI_NULL,            S_TELEGLITTER2_4},  // S_TELEGLITTER2_3
  {SPR_TGLT,FFB|8,   2, AI_AccTeleGlitter,  S_TELEGLITTER2_5},  // S_TELEGLITTER2_4
  {SPR_TGLT,FFB|9,   2, AI_NULL,            S_TELEGLITTER2_1},  // S_TELEGLITTER2_5
  {SPR_TELE,FFB|0,   6, AI_NULL,            S_HTFOG2        },  // S_HTFOG1
  {SPR_TELE,FFB|1,   6, AI_NULL,            S_HTFOG3        },  // S_HTFOG2
  {SPR_TELE,FFB|2,   6, AI_NULL,            S_HTFOG4        },  // S_HTFOG3
  {SPR_TELE,FFB|3,   6, AI_NULL,            S_HTFOG5        },  // S_HTFOG4
  {SPR_TELE,FFB|4,   6, AI_NULL,            S_HTFOG6        },  // S_HTFOG5
  {SPR_TELE,FFB|5,   6, AI_NULL,            S_HTFOG7        },  // S_HTFOG6
  {SPR_TELE,FFB|6,   6, AI_NULL,            S_HTFOG8        },  // S_HTFOG7
  {SPR_TELE,FFB|7,   6, AI_NULL,            S_HTFOG9        },  // S_HTFOG8
  {SPR_TELE,FFB|6,   6, AI_NULL,            S_HTFOG10       },  // S_HTFOG9
  {SPR_TELE,FFB|5,   6, AI_NULL,            S_HTFOG11       },  // S_HTFOG10
  {SPR_TELE,FFB|4,   6, AI_NULL,            S_HTFOG12       },  // S_HTFOG11
  {SPR_TELE,FFB|3,   6, AI_NULL,            S_HTFOG13       },  // S_HTFOG12
  {SPR_TELE,FFB|2,   6, AI_NULL,            S_NULL          },  // S_HTFOG13
// Heretic player weapons, functions are acp2 (player, psp)
  {SPR_STFF,    0,   0, AP_Light0,          S_NULL          },  // S_HLIGHTDONE
  {SPR_STFF,    0,   1, AP_WeaponReady,     S_STAFFREADY    },  // S_STAFFREADY
  {SPR_STFF,    0,   1, AP_Lower,           S_STAFFDOWN     },  // S_STAFFDOWN
  {SPR_STFF,    0,   1, AP_Raise,           S_STAFFUP       },  // S_STAFFUP
  {SPR_STFF,    3,   4, AP_WeaponReady,     S_STAFFREADY2_2 },  // S_STAFFREADY2_1
  {SPR_STFF,    4,   4, AP_WeaponReady,     S_STAFFREADY2_3 },  // S_STAFFREADY2_2
  {SPR_STFF,    5,   4, AP_WeaponReady,     S_STAFFREADY2_1 },  // S_STAFFREADY2_3
  {SPR_STFF,    3,   1, AP_Lower,           S_STAFFDOWN2    },  // S_STAFFDOWN2
  {SPR_STFF,    3,   1, AP_Raise,           S_STAFFUP2      },  // S_STAFFUP2
  {SPR_STFF,    1,   6, AI_NULL,            S_STAFFATK1_2   },  // S_STAFFATK1_1
  {SPR_STFF,    2,   8, AP_StaffAttackPL1,  S_STAFFATK1_3   },  // S_STAFFATK1_2
  {SPR_STFF,    1,   8, AP_ReFire,          S_STAFFREADY    },  // S_STAFFATK1_3
  {SPR_STFF,    6,   6, AI_NULL,            S_STAFFATK2_2   },  // S_STAFFATK2_1
  {SPR_STFF,    7,   8, AP_StaffAttackPL2,  S_STAFFATK2_3   },  // S_STAFFATK2_2
  {SPR_STFF,    6,   8, AP_ReFire,          S_STAFFREADY2_1 },  // S_STAFFATK2_3
// Heretic weapon thing, functions are null
  {SPR_PUF3,FFB|0,   4, AI_NULL,            S_STAFFPUFF2    },  // S_STAFFPUFF1
  {SPR_PUF3,    1,   4, AI_NULL,            S_STAFFPUFF3    },  // S_STAFFPUFF2
  {SPR_PUF3,    2,   4, AI_NULL,            S_STAFFPUFF4    },  // S_STAFFPUFF3
  {SPR_PUF3,    3,   4, AI_NULL,            S_NULL          },  // S_STAFFPUFF4
// Heretic weapon thing, functions are null
  {SPR_PUF4,FFB|0,   4, AI_NULL,            S_STAFFPUFF2_2  },  // S_STAFFPUFF2_1
  {SPR_PUF4,FFB|1,   4, AI_NULL,            S_STAFFPUFF2_3  },  // S_STAFFPUFF2_2
  {SPR_PUF4,FFB|2,   4, AI_NULL,            S_STAFFPUFF2_4  },  // S_STAFFPUFF2_3
  {SPR_PUF4,FFB|3,   4, AI_NULL,            S_STAFFPUFF2_5  },  // S_STAFFPUFF2_4
  {SPR_PUF4,FFB|4,   4, AI_NULL,            S_STAFFPUFF2_6  },  // S_STAFFPUFF2_5
  {SPR_PUF4,FFB|5,   4, AI_NULL,            S_NULL          },  // S_STAFFPUFF2_6
// Heretic player weapons, functions are acp2 (player, psp)    
  {SPR_BEAK,    0,   1, AP_BeakReady,       S_BEAKREADY     },  // S_BEAKREADY
  {SPR_BEAK,    0,   1, AP_Lower,           S_BEAKDOWN      },  // S_BEAKDOWN
  {SPR_BEAK,    0,   1, AP_BeakRaise,       S_BEAKUP        },  // S_BEAKUP
  {SPR_BEAK,    0,  18, AP_BeakAttackPL1,   S_BEAKREADY     },  // S_BEAKATK1_1
  {SPR_BEAK,    0,  12, AP_BeakAttackPL2,   S_BEAKREADY     },  // S_BEAKATK2_1
  {SPR_WGNT,    0,  -1, AI_NULL,            S_NULL          },  // S_WGNT
  {SPR_GAUN,    0,   1, AP_WeaponReady,     S_GAUNTLETREADY },  // S_GAUNTLETREADY
  {SPR_GAUN,    0,   1, AP_Lower,           S_GAUNTLETDOWN  },  // S_GAUNTLETDOWN
  {SPR_GAUN,    0,   1, AP_Raise,           S_GAUNTLETUP    },  // S_GAUNTLETUP
  {SPR_GAUN,    6,   4, AP_WeaponReady,     S_GAUNTLETREADY2_2},// S_GAUNTLETREADY2_1
  {SPR_GAUN,    7,   4, AP_WeaponReady,     S_GAUNTLETREADY2_3},// S_GAUNTLETREADY2_2
  {SPR_GAUN,    8,   4, AP_WeaponReady,     S_GAUNTLETREADY2_1},// S_GAUNTLETREADY2_3
  {SPR_GAUN,    6,   1, AP_Lower,           S_GAUNTLETDOWN2 },  // S_GAUNTLETDOWN2
  {SPR_GAUN,    6,   1, AP_Raise,           S_GAUNTLETUP2   },  // S_GAUNTLETUP2
  {SPR_GAUN,    1,   4, AI_NULL,            S_GAUNTLETATK1_2},  // S_GAUNTLETATK1_1
  {SPR_GAUN,    2,   4, AI_NULL,            S_GAUNTLETATK1_3},  // S_GAUNTLETATK1_2
  {SPR_GAUN,FFB|3,   4, AP_GauntletAttack,  S_GAUNTLETATK1_4},  // S_GAUNTLETATK1_3
  {SPR_GAUN,FFB|4,   4, AP_GauntletAttack,  S_GAUNTLETATK1_5},  // S_GAUNTLETATK1_4
  {SPR_GAUN,FFB|5,   4, AP_GauntletAttack,  S_GAUNTLETATK1_6},  // S_GAUNTLETATK1_5
  {SPR_GAUN,    2,   4, AP_ReFire,          S_GAUNTLETATK1_7},  // S_GAUNTLETATK1_6
  {SPR_GAUN,    1,   4, AP_Light0,          S_GAUNTLETREADY },  // S_GAUNTLETATK1_7
  {SPR_GAUN,    9,   4, AI_NULL,            S_GAUNTLETATK2_2},  // S_GAUNTLETATK2_1
  {SPR_GAUN,   10,   4, AI_NULL,            S_GAUNTLETATK2_3},  // S_GAUNTLETATK2_2
  {SPR_GAUN,FFB|11,  4, AP_GauntletAttack,  S_GAUNTLETATK2_4},  // S_GAUNTLETATK2_3
  {SPR_GAUN,FFB|12,  4, AP_GauntletAttack,  S_GAUNTLETATK2_5},  // S_GAUNTLETATK2_4
  {SPR_GAUN,FFB|13,  4, AP_GauntletAttack,  S_GAUNTLETATK2_6},  // S_GAUNTLETATK2_5
  {SPR_GAUN,   10,   4, AP_ReFire,          S_GAUNTLETATK2_7},  // S_GAUNTLETATK2_6
  {SPR_GAUN,    9,   4, AP_Light0,          S_GAUNTLETREADY2_1},// S_GAUNTLETATK2_7
// Heretic weapon thing, functions are null
  {SPR_PUF1,FFB|0,   4, AI_NULL,            S_GAUNTLETPUFF1_2}, // S_GAUNTLETPUFF1_1
  {SPR_PUF1,FFB|1,   4, AI_NULL,            S_GAUNTLETPUFF1_3}, // S_GAUNTLETPUFF1_2
  {SPR_PUF1,FFB|2,   4, AI_NULL,            S_GAUNTLETPUFF1_4}, // S_GAUNTLETPUFF1_3
  {SPR_PUF1,FFB|3,   4, AI_NULL,            S_NULL          },  // S_GAUNTLETPUFF1_4
  {SPR_PUF1,FFB|4,   4, AI_NULL,            S_GAUNTLETPUFF2_2}, // S_GAUNTLETPUFF2_1
  {SPR_PUF1,FFB|5,   4, AI_NULL,            S_GAUNTLETPUFF2_3}, // S_GAUNTLETPUFF2_2
  {SPR_PUF1,FFB|6,   4, AI_NULL,            S_GAUNTLETPUFF2_4}, // S_GAUNTLETPUFF2_3
  {SPR_PUF1,FFB|7,   4, AI_NULL,            S_NULL          },  // S_GAUNTLETPUFF2_4
  {SPR_WBLS,    0,  -1, AI_NULL,            S_NULL          },  // S_BLSR
// Heretic player weapons, functions are acp2 (player, psp)
  {SPR_BLSR,    0,   1, AP_WeaponReady,     S_BLASTERREADY  },  // S_BLASTERREADY
  {SPR_BLSR,    0,   1, AP_Lower,           S_BLASTERDOWN   },  // S_BLASTERDOWN
  {SPR_BLSR,    0,   1, AP_Raise,           S_BLASTERUP     },  // S_BLASTERUP
  {SPR_BLSR,    1,   3, AI_NULL,            S_BLASTERATK1_2 },  // S_BLASTERATK1_1
  {SPR_BLSR,    2,   3, AI_NULL,            S_BLASTERATK1_3 },  // S_BLASTERATK1_2
  {SPR_BLSR,    3,   2, AP_FireBlasterPL1,  S_BLASTERATK1_4 },  // S_BLASTERATK1_3
  {SPR_BLSR,    2,   2, AI_NULL,            S_BLASTERATK1_5 },  // S_BLASTERATK1_4
  {SPR_BLSR,    1,   2, AI_NULL,            S_BLASTERATK1_6 },  // S_BLASTERATK1_5
  {SPR_BLSR,    0,   0, AP_ReFire,          S_BLASTERREADY  },  // S_BLASTERATK1_6
  {SPR_BLSR,    1,   0, AI_NULL,            S_BLASTERATK2_2 },  // S_BLASTERATK2_1
  {SPR_BLSR,    2,   0, AI_NULL,            S_BLASTERATK2_3 },  // S_BLASTERATK2_2
  {SPR_BLSR,    3,   3, AP_FireBlasterPL2,  S_BLASTERATK2_4 },  // S_BLASTERATK2_3
  {SPR_BLSR,    2,   4, AI_NULL,            S_BLASTERATK2_5 },  // S_BLASTERATK2_4
  {SPR_BLSR,    1,   4, AI_NULL,            S_BLASTERATK2_6 },  // S_BLASTERATK2_5
  {SPR_BLSR,    0,   0, AP_ReFire,          S_BLASTERREADY  },  // S_BLASTERATK2_6
// Things, functions are acp1 (mobj)
  {SPR_ACLO,    4, 200, AI_NULL,            S_BLASTERFX1_1  },  // S_BLASTERFX1_1
  {SPR_FX18,FFB|0,   3, AI_SpawnRippers,    S_BLASTERFXI1_2 },  // S_BLASTERFXI1_1
  {SPR_FX18,FFB|1,   3, AI_NULL,            S_BLASTERFXI1_3 },  // S_BLASTERFXI1_2
  {SPR_FX18,FFB|2,   4, AI_NULL,            S_BLASTERFXI1_4 },  // S_BLASTERFXI1_3
  {SPR_FX18,FFB|3,   4, AI_NULL,            S_BLASTERFXI1_5 },  // S_BLASTERFXI1_4
  {SPR_FX18,FFB|4,   4, AI_NULL,            S_BLASTERFXI1_6 },  // S_BLASTERFXI1_5
  {SPR_FX18,FFB|5,   4, AI_NULL,            S_BLASTERFXI1_7 },  // S_BLASTERFXI1_6
  {SPR_FX18,FFB|6,   4, AI_NULL,            S_NULL          },  // S_BLASTERFXI1_7
  {SPR_FX18,    7,   4, AI_NULL,            S_BLASTERSMOKE2 },  // S_BLASTERSMOKE1
  {SPR_FX18,    8,   4, AI_NULL,            S_BLASTERSMOKE3 },  // S_BLASTERSMOKE2
  {SPR_FX18,    9,   4, AI_NULL,            S_BLASTERSMOKE4 },  // S_BLASTERSMOKE3
  {SPR_FX18,   10,   4, AI_NULL,            S_BLASTERSMOKE5 },  // S_BLASTERSMOKE4
  {SPR_FX18,   11,   4, AI_NULL,            S_NULL          },  // S_BLASTERSMOKE5
  {SPR_FX18,   12,   4, AI_NULL,            S_RIPPER2       },  // S_RIPPER1
  {SPR_FX18,   13,   5, AI_NULL,            S_RIPPER1       },  // S_RIPPER2
  {SPR_FX18,FFB|14,  4, AI_NULL,            S_RIPPERX2      },  // S_RIPPERX1
  {SPR_FX18,FFB|15,  4, AI_NULL,            S_RIPPERX3      },  // S_RIPPERX2
  {SPR_FX18,FFB|16,  4, AI_NULL,            S_RIPPERX4      },  // S_RIPPERX3
  {SPR_FX18,FFB|17,  4, AI_NULL,            S_RIPPERX5      },  // S_RIPPERX4
  {SPR_FX18,FFB|18,  4, AI_NULL,            S_NULL          },  // S_RIPPERX5
  {SPR_FX17,FFB|0,   4, AI_NULL,            S_BLASTERPUFF1_2},  // S_BLASTERPUFF1_1
  {SPR_FX17,FFB|1,   4, AI_NULL,            S_BLASTERPUFF1_3},  // S_BLASTERPUFF1_2
  {SPR_FX17,FFB|2,   4, AI_NULL,            S_BLASTERPUFF1_4},  // S_BLASTERPUFF1_3
  {SPR_FX17,FFB|3,   4, AI_NULL,            S_BLASTERPUFF1_5},  // S_BLASTERPUFF1_4
  {SPR_FX17,FFB|4,   4, AI_NULL,            S_NULL          },  // S_BLASTERPUFF1_5
  {SPR_FX17,FFB|5,   3, AI_NULL,            S_BLASTERPUFF2_2},  // S_BLASTERPUFF2_1
  {SPR_FX17,FFB|6,   3, AI_NULL,            S_BLASTERPUFF2_3},  // S_BLASTERPUFF2_2
  {SPR_FX17,FFB|7,   4, AI_NULL,            S_BLASTERPUFF2_4},  // S_BLASTERPUFF2_3
  {SPR_FX17,FFB|8,   4, AI_NULL,            S_BLASTERPUFF2_5},  // S_BLASTERPUFF2_4
  {SPR_FX17,FFB|9,   4, AI_NULL,            S_BLASTERPUFF2_6},  // S_BLASTERPUFF2_5
  {SPR_FX17,FFB|10,  4, AI_NULL,            S_BLASTERPUFF2_7},  // S_BLASTERPUFF2_6
  {SPR_FX17,FFB|11,  4, AI_NULL,            S_NULL          },  // S_BLASTERPUFF2_7
  {SPR_WMCE,    0,  -1, AI_NULL,            S_NULL          },  // S_WMCE
// Heretic player weapons, functions are acp2 (player, psp)    
  {SPR_MACE,    0,   1, AP_WeaponReady,     S_MACEREADY     },  // S_MACEREADY
  {SPR_MACE,    0,   1, AP_Lower,           S_MACEDOWN      },  // S_MACEDOWN
  {SPR_MACE,    0,   1, AP_Raise,           S_MACEUP        },  // S_MACEUP
  {SPR_MACE,    1,   4, AI_NULL,            S_MACEATK1_2    },  // S_MACEATK1_1
  {SPR_MACE,    2,   3, AP_FireMacePL1,     S_MACEATK1_3    },  // S_MACEATK1_2
  {SPR_MACE,    3,   3, AP_FireMacePL1,     S_MACEATK1_4    },  // S_MACEATK1_3
  {SPR_MACE,    4,   3, AP_FireMacePL1,     S_MACEATK1_5    },  // S_MACEATK1_4
  {SPR_MACE,    5,   3, AP_FireMacePL1,     S_MACEATK1_6    },  // S_MACEATK1_5
  {SPR_MACE,    2,   4, AP_ReFire,          S_MACEATK1_7    },  // S_MACEATK1_6
  {SPR_MACE,    3,   4, AI_NULL,            S_MACEATK1_8    },  // S_MACEATK1_7
  {SPR_MACE,    4,   4, AI_NULL,            S_MACEATK1_9    },  // S_MACEATK1_8
  {SPR_MACE,    5,   4, AI_NULL,            S_MACEATK1_10   },  // S_MACEATK1_9
  {SPR_MACE,    1,   4, AI_NULL,            S_MACEREADY     },  // S_MACEATK1_10
  {SPR_MACE,    1,   4, AI_NULL,            S_MACEATK2_2    },  // S_MACEATK2_1
  {SPR_MACE,    3,   4, AP_FireMacePL2,     S_MACEATK2_3    },  // S_MACEATK2_2
  {SPR_MACE,    1,   4, AI_NULL,            S_MACEATK2_4    },  // S_MACEATK2_3
  {SPR_MACE,    0,   8, AP_ReFire,          S_MACEREADY     },  // S_MACEATK2_4
// Things, functions are acp1 (mobj)
  {SPR_FX02,    0,   4, AI_MacePL1Check,    S_MACEFX1_2     },  // S_MACEFX1_1
  {SPR_FX02,    1,   4, AI_MacePL1Check,    S_MACEFX1_1     },  // S_MACEFX1_2
  {SPR_FX02,FFB|5,   4, AI_MaceBallImpact,  S_MACEFXI1_2    },  // S_MACEFXI1_1
  {SPR_FX02,FFB|6,   4, AI_NULL,            S_MACEFXI1_3    },  // S_MACEFXI1_2
  {SPR_FX02,FFB|7,   4, AI_NULL,            S_MACEFXI1_4    },  // S_MACEFXI1_3
  {SPR_FX02,FFB|8,   4, AI_NULL,            S_MACEFXI1_5    },  // S_MACEFXI1_4
  {SPR_FX02,FFB|9,   4, AI_NULL,            S_NULL          },  // S_MACEFXI1_5
  {SPR_FX02,    2,   4, AI_NULL,            S_MACEFX2_2     },  // S_MACEFX2_1
  {SPR_FX02,    3,   4, AI_NULL,            S_MACEFX2_1     },  // S_MACEFX2_2
  {SPR_FX02,FFB|5,   4, AI_MaceBallImpact2, S_MACEFXI1_2    },  // S_MACEFXI2_1
  {SPR_FX02,    0,   4, AI_NULL,            S_MACEFX3_2     },  // S_MACEFX3_1
  {SPR_FX02,    1,   4, AI_NULL,            S_MACEFX3_1     },  // S_MACEFX3_2
  {SPR_FX02,    4,  99, AI_NULL,            S_MACEFX4_1     },  // S_MACEFX4_1
  {SPR_FX02,FFB|2,   4, AI_DeathBallImpact, S_MACEFXI1_2    },  // S_MACEFXI4_1
  {SPR_WSKL,    0,  -1, AI_NULL,            S_NULL          },  // S_WSKL
// Heretic player weapons, functions are acp2 (player, psp)    
  {SPR_HROD,    0,   1, AP_WeaponReady,     S_HORNRODREADY  },  // S_HORNRODREADY
  {SPR_HROD,    0,   1, AP_Lower,           S_HORNRODDOWN   },  // S_HORNRODDOWN
  {SPR_HROD,    0,   1, AP_Raise,           S_HORNRODUP     },  // S_HORNRODUP
  {SPR_HROD,    0,   4, AP_FireSkullRodPL1, S_HORNRODATK1_2 },  // S_HORNRODATK1_1
  {SPR_HROD,    1,   4, AP_FireSkullRodPL1, S_HORNRODATK1_3 },  // S_HORNRODATK1_2
  {SPR_HROD,    1,   0, AP_ReFire,          S_HORNRODREADY  },  // S_HORNRODATK1_3
  {SPR_HROD,    2,   2, AI_NULL,            S_HORNRODATK2_2 },  // S_HORNRODATK2_1
  {SPR_HROD,    3,   3, AI_NULL,            S_HORNRODATK2_3 },  // S_HORNRODATK2_2
  {SPR_HROD,    4,   2, AI_NULL,            S_HORNRODATK2_4 },  // S_HORNRODATK2_3
  {SPR_HROD,    5,   3, AI_NULL,            S_HORNRODATK2_5 },  // S_HORNRODATK2_4
  {SPR_HROD,    6,   4, AP_FireSkullRodPL2, S_HORNRODATK2_6 },  // S_HORNRODATK2_5
  {SPR_HROD,    5,   2, AI_NULL,            S_HORNRODATK2_7 },  // S_HORNRODATK2_6
  {SPR_HROD,    4,   3, AI_NULL,            S_HORNRODATK2_8 },  // S_HORNRODATK2_7
  {SPR_HROD,    3,   2, AI_NULL,            S_HORNRODATK2_9 },  // S_HORNRODATK2_8
  {SPR_HROD,    2,   2, AP_ReFire,          S_HORNRODREADY  },  // S_HORNRODATK2_9
// Things, functions are acp1 (mobj)
  {SPR_FX00,FFB|0,   6, AI_NULL,            S_HRODFX1_2     },  // S_HRODFX1_1
  {SPR_FX00,FFB|1,   6, AI_NULL,            S_HRODFX1_1     },  // S_HRODFX1_2
  {SPR_FX00,FFB|7,   5, AI_NULL,            S_HRODFXI1_2    },  // S_HRODFXI1_1
  {SPR_FX00,FFB|8,   5, AI_NULL,            S_HRODFXI1_3    },  // S_HRODFXI1_2
  {SPR_FX00,FFB|9,   4, AI_NULL,            S_HRODFXI1_4    },  // S_HRODFXI1_3
  {SPR_FX00,FFB|10,  4, AI_NULL,            S_HRODFXI1_5    },  // S_HRODFXI1_4
  {SPR_FX00,FFB|11,  3, AI_NULL,            S_HRODFXI1_6    },  // S_HRODFXI1_5
  {SPR_FX00,FFB|12,  3, AI_NULL,            S_NULL          },  // S_HRODFXI1_6
  {SPR_FX00,FFB|2,   3, AI_NULL,            S_HRODFX2_2     },  // S_HRODFX2_1
  {SPR_FX00,FFB|3,   3, AI_SkullRodPL2Seek, S_HRODFX2_3     },  // S_HRODFX2_2
  {SPR_FX00,FFB|4,   3, AI_NULL,            S_HRODFX2_4     },  // S_HRODFX2_3
  {SPR_FX00,FFB|5,   3, AI_SkullRodPL2Seek, S_HRODFX2_1     },  // S_HRODFX2_4
  {SPR_FX00,FFB|7,   5, AI_AddPlayerRain,   S_HRODFXI2_2    },  // S_HRODFXI2_1
  {SPR_FX00,FFB|8,   5, AI_NULL,            S_HRODFXI2_3    },  // S_HRODFXI2_2
  {SPR_FX00,FFB|9,   4, AI_NULL,            S_HRODFXI2_4    },  // S_HRODFXI2_3
  {SPR_FX00,FFB|10,  3, AI_NULL,            S_HRODFXI2_5    },  // S_HRODFXI2_4
  {SPR_FX00,FFB|11,  3, AI_NULL,            S_HRODFXI2_6    },  // S_HRODFXI2_5
  {SPR_FX00,FFB|12,  3, AI_NULL,            S_HRODFXI2_7    },  // S_HRODFXI2_6
  {SPR_FX00,    6,   1, AI_HideInCeiling,   S_HRODFXI2_8    },  // S_HRODFXI2_7
  {SPR_FX00,    6,   1, AI_SkullRodStorm,   S_HRODFXI2_8    },  // S_HRODFXI2_8
  {SPR_FX20,FFB|0,  -1, AI_NULL,            S_NULL          },  // S_RAINPLR1_1
  {SPR_FX21,FFB|0,  -1, AI_NULL,            S_NULL          },  // S_RAINPLR2_1
  {SPR_FX22,FFB|0,  -1, AI_NULL,            S_NULL          },  // S_RAINPLR3_1
  {SPR_FX23,FFB|0,  -1, AI_NULL,            S_NULL          },  // S_RAINPLR4_1
  {SPR_FX20,FFB|1,   4, AI_RainImpact,      S_RAINPLR1X_2   },  // S_RAINPLR1X_1
  {SPR_FX20,FFB|2,   4, AI_NULL,            S_RAINPLR1X_3   },  // S_RAINPLR1X_2
  {SPR_FX20,FFB|3,   4, AI_NULL,            S_RAINPLR1X_4   },  // S_RAINPLR1X_3
  {SPR_FX20,FFB|4,   4, AI_NULL,            S_RAINPLR1X_5   },  // S_RAINPLR1X_4
  {SPR_FX20,FFB|5,   4, AI_NULL,            S_NULL          },  // S_RAINPLR1X_5
  {SPR_FX21,FFB|1,   4, AI_RainImpact,      S_RAINPLR2X_2   },  // S_RAINPLR2X_1
  {SPR_FX21,FFB|2,   4, AI_NULL,            S_RAINPLR2X_3   },  // S_RAINPLR2X_2
  {SPR_FX21,FFB|3,   4, AI_NULL,            S_RAINPLR2X_4   },  // S_RAINPLR2X_3
  {SPR_FX21,FFB|4,   4, AI_NULL,            S_RAINPLR2X_5   },  // S_RAINPLR2X_4
  {SPR_FX21,FFB|5,   4, AI_NULL,            S_NULL          },  // S_RAINPLR2X_5
  {SPR_FX22,FFB|1,   4, AI_RainImpact,      S_RAINPLR3X_2   },  // S_RAINPLR3X_1
  {SPR_FX22,FFB|2,   4, AI_NULL,            S_RAINPLR3X_3   },  // S_RAINPLR3X_2
  {SPR_FX22,FFB|3,   4, AI_NULL,            S_RAINPLR3X_4   },  // S_RAINPLR3X_3
  {SPR_FX22,FFB|4,   4, AI_NULL,            S_RAINPLR3X_5   },  // S_RAINPLR3X_4
  {SPR_FX22,FFB|5,   4, AI_NULL,            S_NULL          },  // S_RAINPLR3X_5
  {SPR_FX23,FFB|1,   4, AI_RainImpact,      S_RAINPLR4X_2   },  // S_RAINPLR4X_1
  {SPR_FX23,FFB|2,   4, AI_NULL,            S_RAINPLR4X_3   },  // S_RAINPLR4X_2
  {SPR_FX23,FFB|3,   4, AI_NULL,            S_RAINPLR4X_4   },  // S_RAINPLR4X_3
  {SPR_FX23,FFB|4,   4, AI_NULL,            S_RAINPLR4X_5   },  // S_RAINPLR4X_4
  {SPR_FX23,FFB|5,   4, AI_NULL,            S_NULL          },  // S_RAINPLR4X_5
  {SPR_FX20,FFB|6,   4, AI_NULL,            S_RAINAIRXPLR1_2},  // S_RAINAIRXPLR1_1
  {SPR_FX21,FFB|6,   4, AI_NULL,            S_RAINAIRXPLR2_2},  // S_RAINAIRXPLR2_1
  {SPR_FX22,FFB|6,   4, AI_NULL,            S_RAINAIRXPLR3_2},  // S_RAINAIRXPLR3_1
  {SPR_FX23,FFB|6,   4, AI_NULL,            S_RAINAIRXPLR4_2},  // S_RAINAIRXPLR4_1
  {SPR_FX20,FFB|7,   4, AI_NULL,            S_RAINAIRXPLR1_3},  // S_RAINAIRXPLR1_2
  {SPR_FX21,FFB|7,   4, AI_NULL,            S_RAINAIRXPLR2_3},  // S_RAINAIRXPLR2_2
  {SPR_FX22,FFB|7,   4, AI_NULL,            S_RAINAIRXPLR3_3},  // S_RAINAIRXPLR3_2
  {SPR_FX23,FFB|7,   4, AI_NULL,            S_RAINAIRXPLR4_3},  // S_RAINAIRXPLR4_2
  {SPR_FX20,FFB|8,   4, AI_NULL,            S_NULL          },  // S_RAINAIRXPLR1_3
  {SPR_FX21,FFB|8,   4, AI_NULL,            S_NULL          },  // S_RAINAIRXPLR2_3
  {SPR_FX22,FFB|8,   4, AI_NULL,            S_NULL          },  // S_RAINAIRXPLR3_3
  {SPR_FX23,FFB|8,   4, AI_NULL,            S_NULL          },  // S_RAINAIRXPLR4_3
// Heretic player weapons, functions are acp2 (player, psp)    
  {SPR_GWND,    0,   1, AP_WeaponReady,     S_GOLDWANDREADY },  // S_GOLDWANDREADY
  {SPR_GWND,    0,   1, AP_Lower,           S_GOLDWANDDOWN  },  // S_GOLDWANDDOWN
  {SPR_GWND,    0,   1, AP_Raise,           S_GOLDWANDUP    },  // S_GOLDWANDUP
  {SPR_GWND,    1,   3, AI_NULL,            S_GOLDWANDATK1_2},  // S_GOLDWANDATK1_1
  {SPR_GWND,    2,   5, AP_FireGoldWandPL1, S_GOLDWANDATK1_3},  // S_GOLDWANDATK1_2
  {SPR_GWND,    3,   3, AI_NULL,            S_GOLDWANDATK1_4},  // S_GOLDWANDATK1_3
  {SPR_GWND,    3,   0, AP_ReFire,          S_GOLDWANDREADY },  // S_GOLDWANDATK1_4
  {SPR_GWND,    1,   3, AI_NULL,            S_GOLDWANDATK2_2},  // S_GOLDWANDATK2_1
  {SPR_GWND,    2,   4, AP_FireGoldWandPL2, S_GOLDWANDATK2_3},  // S_GOLDWANDATK2_2
  {SPR_GWND,    3,   3, AI_NULL,            S_GOLDWANDATK2_4},  // S_GOLDWANDATK2_3
  {SPR_GWND,    3,   0, AP_ReFire,          S_GOLDWANDREADY },  // S_GOLDWANDATK2_4
// Things, functions are acp1 (mobj)
  {SPR_FX01,FFB|0,   6, AI_NULL,            S_GWANDFX1_2    },  // S_GWANDFX1_1
  {SPR_FX01,FFB|1,   6, AI_NULL,            S_GWANDFX1_1    },  // S_GWANDFX1_2
  {SPR_FX01,FFB|4,   3, AI_NULL,            S_GWANDFXI1_2   },  // S_GWANDFXI1_1
  {SPR_FX01,FFB|5,   3, AI_NULL,            S_GWANDFXI1_3   },  // S_GWANDFXI1_2
  {SPR_FX01,FFB|6,   3, AI_NULL,            S_GWANDFXI1_4   },  // S_GWANDFXI1_3
  {SPR_FX01,FFB|7,   3, AI_NULL,            S_NULL          },  // S_GWANDFXI1_4
  {SPR_FX01,FFB|2,   6, AI_NULL,            S_GWANDFX2_2    },  // S_GWANDFX2_1
  {SPR_FX01,FFB|3,   6, AI_NULL,            S_GWANDFX2_1    },  // S_GWANDFX2_2
  {SPR_PUF2,FFB|0,   3, AI_NULL,            S_GWANDPUFF1_2  },  // S_GWANDPUFF1_1
  {SPR_PUF2,FFB|1,   3, AI_NULL,            S_GWANDPUFF1_3  },  // S_GWANDPUFF1_2
  {SPR_PUF2,FFB|2,   3, AI_NULL,            S_GWANDPUFF1_4  },  // S_GWANDPUFF1_3
  {SPR_PUF2,FFB|3,   3, AI_NULL,            S_GWANDPUFF1_5  },  // S_GWANDPUFF1_4
  {SPR_PUF2,FFB|4,   3, AI_NULL,            S_NULL          },  // S_GWANDPUFF1_5
  {SPR_WPHX,    0,  -1, AI_NULL,            S_NULL          },  // S_WPHX
// Heretic player weapons, functions are acp2 (player, psp)    
  {SPR_PHNX,    0,   1, AP_WeaponReady,     S_PHOENIXREADY  },  // S_PHOENIXREADY
  {SPR_PHNX,    0,   1, AP_Lower,           S_PHOENIXDOWN   },  // S_PHOENIXDOWN
  {SPR_PHNX,    0,   1, AP_Raise,           S_PHOENIXUP     },  // S_PHOENIXUP
  {SPR_PHNX,    1,   5, AI_NULL,            S_PHOENIXATK1_2 },  // S_PHOENIXATK1_1
  {SPR_PHNX,    2,   7, AP_FirePhoenixPL1,  S_PHOENIXATK1_3 },  // S_PHOENIXATK1_2
  {SPR_PHNX,    3,   4, AI_NULL,            S_PHOENIXATK1_4 },  // S_PHOENIXATK1_3
  {SPR_PHNX,    1,   4, AI_NULL,            S_PHOENIXATK1_5 },  // S_PHOENIXATK1_4
  {SPR_PHNX,    1,   0, AP_ReFire,          S_PHOENIXREADY  },  // S_PHOENIXATK1_5
  {SPR_PHNX,    1,   3, AP_InitPhoenixPL2,  S_PHOENIXATK2_2 },  // S_PHOENIXATK2_1
  {SPR_PHNX,FFB|2,   1, AP_FirePhoenixPL2,  S_PHOENIXATK2_3 },  // S_PHOENIXATK2_2
  {SPR_PHNX,    1,   4, AP_ReFire,          S_PHOENIXATK2_4 },  // S_PHOENIXATK2_3
  {SPR_PHNX,    1,   4, AP_ShutdownPhoenixPL2, S_PHOENIXREADY},  // S_PHOENIXATK2_4
// Things, functions are acp1 (mobj)
  {SPR_FX04,FFB|0,   4, AI_PhoenixPuff,     S_PHOENIXFX1_1  },  // S_PHOENIXFX1_1
  {SPR_FX08,FFB|0,   6, AI_Explode,         S_PHOENIXFXI1_2 },  // S_PHOENIXFXI1_1
  {SPR_FX08,FFB|1,   5, AI_NULL,            S_PHOENIXFXI1_3 },  // S_PHOENIXFXI1_2
  {SPR_FX08,FFB|2,   5, AI_NULL,            S_PHOENIXFXI1_4 },  // S_PHOENIXFXI1_3
  {SPR_FX08,FFB|3,   4, AI_NULL,            S_PHOENIXFXI1_5 },  // S_PHOENIXFXI1_4
  {SPR_FX08,FFB|4,   4, AI_NULL,            S_PHOENIXFXI1_6 },  // S_PHOENIXFXI1_5
  {SPR_FX08,FFB|5,   4, AI_NULL,            S_PHOENIXFXI1_7 },  // S_PHOENIXFXI1_6
  {SPR_FX08,FFB|6,   4, AI_NULL,            S_PHOENIXFXI1_8 },  // S_PHOENIXFXI1_7
  {SPR_FX08,FFB|7,   4, AI_NULL,            S_NULL          },  // S_PHOENIXFXI1_8
  {SPR_FX04,    1,   4, AI_NULL,            S_PHOENIXPUFF2  },  // S_PHOENIXPUFF1
  {SPR_FX04,    2,   4, AI_NULL,            S_PHOENIXPUFF3  },  // S_PHOENIXPUFF2
  {SPR_FX04,    3,   4, AI_NULL,            S_PHOENIXPUFF4  },  // S_PHOENIXPUFF3
  {SPR_FX04,    4,   4, AI_NULL,            S_PHOENIXPUFF5  },  // S_PHOENIXPUFF4
  {SPR_FX04,    5,   4, AI_NULL,            S_NULL          },  // S_PHOENIXPUFF5
  {SPR_FX09,FFB|0,   2, AI_NULL,            S_PHOENIXFX2_2  },  // S_PHOENIXFX2_1
  {SPR_FX09,FFB|1,   2, AI_NULL,            S_PHOENIXFX2_3  },  // S_PHOENIXFX2_2
  {SPR_FX09,FFB|0,   2, AI_NULL,            S_PHOENIXFX2_4  },  // S_PHOENIXFX2_3
  {SPR_FX09,FFB|1,   2, AI_NULL,            S_PHOENIXFX2_5  },  // S_PHOENIXFX2_4
  {SPR_FX09,FFB|0,   2, AI_NULL,            S_PHOENIXFX2_6  },  // S_PHOENIXFX2_5
  {SPR_FX09,FFB|1,   2, AI_FlameEnd,        S_PHOENIXFX2_7  },  // S_PHOENIXFX2_6
  {SPR_FX09,FFB|2,   2, AI_NULL,            S_PHOENIXFX2_8  },  // S_PHOENIXFX2_7
  {SPR_FX09,FFB|3,   2, AI_NULL,            S_PHOENIXFX2_9  },  // S_PHOENIXFX2_8
  {SPR_FX09,FFB|4,   2, AI_NULL,            S_PHOENIXFX2_10 },  // S_PHOENIXFX2_9
  {SPR_FX09,FFB|5,   2, AI_NULL,            S_NULL          },  // S_PHOENIXFX2_10
  {SPR_FX09,FFB|6,   3, AI_NULL,            S_PHOENIXFXI2_2 },  // S_PHOENIXFXI2_1
  {SPR_FX09,FFB|7,   3, AI_FloatPuff,       S_PHOENIXFXI2_3 },  // S_PHOENIXFXI2_2
  {SPR_FX09,FFB|8,   4, AI_NULL,            S_PHOENIXFXI2_4 },  // S_PHOENIXFXI2_3
  {SPR_FX09,FFB|9,   5, AI_NULL,            S_PHOENIXFXI2_5 },  // S_PHOENIXFXI2_4
  {SPR_FX09,FFB|10,  5, AI_NULL,            S_NULL          },  // S_PHOENIXFXI2_5
  {SPR_WBOW,    0,  -1, AI_NULL,            S_NULL          },  // S_WBOW
// Heretic player weapons, functions are acp2 (player, psp)
  {SPR_CRBW,    0,   1, AP_WeaponReady,     S_CRBOW2        },  // S_CRBOW1
  {SPR_CRBW,    0,   1, AP_WeaponReady,     S_CRBOW3        },  // S_CRBOW2
  {SPR_CRBW,    0,   1, AP_WeaponReady,     S_CRBOW4        },  // S_CRBOW3
  {SPR_CRBW,    0,   1, AP_WeaponReady,     S_CRBOW5        },  // S_CRBOW4
  {SPR_CRBW,    0,   1, AP_WeaponReady,     S_CRBOW6        },  // S_CRBOW5
  {SPR_CRBW,    0,   1, AP_WeaponReady,     S_CRBOW7        },  // S_CRBOW6
  {SPR_CRBW,    1,   1, AP_WeaponReady,     S_CRBOW8        },  // S_CRBOW7
  {SPR_CRBW,    1,   1, AP_WeaponReady,     S_CRBOW9        },  // S_CRBOW8
  {SPR_CRBW,    1,   1, AP_WeaponReady,     S_CRBOW10       },  // S_CRBOW9
  {SPR_CRBW,    1,   1, AP_WeaponReady,     S_CRBOW11       },  // S_CRBOW10
  {SPR_CRBW,    1,   1, AP_WeaponReady,     S_CRBOW12       },  // S_CRBOW11
  {SPR_CRBW,    1,   1, AP_WeaponReady,     S_CRBOW13       },  // S_CRBOW12
  {SPR_CRBW,    2,   1, AP_WeaponReady,     S_CRBOW14       },  // S_CRBOW13
  {SPR_CRBW,    2,   1, AP_WeaponReady,     S_CRBOW15       },  // S_CRBOW14
  {SPR_CRBW,    2,   1, AP_WeaponReady,     S_CRBOW16       },  // S_CRBOW15
  {SPR_CRBW,    2,   1, AP_WeaponReady,     S_CRBOW17       },  // S_CRBOW16
  {SPR_CRBW,    2,   1, AP_WeaponReady,     S_CRBOW18       },  // S_CRBOW17
  {SPR_CRBW,    2,   1, AP_WeaponReady,     S_CRBOW1        },  // S_CRBOW18
  {SPR_CRBW,    0,   1, AP_Lower,           S_CRBOWDOWN     },  // S_CRBOWDOWN
  {SPR_CRBW,    0,   1, AP_Raise,           S_CRBOWUP       },  // S_CRBOWUP
  {SPR_CRBW,    3,   6, AP_FireCrossbowPL1, S_CRBOWATK1_2   },  // S_CRBOWATK1_1
  {SPR_CRBW,    4,   3, AI_NULL,            S_CRBOWATK1_3   },  // S_CRBOWATK1_2
  {SPR_CRBW,    5,   3, AI_NULL,            S_CRBOWATK1_4   },  // S_CRBOWATK1_3
  {SPR_CRBW,    6,   3, AI_NULL,            S_CRBOWATK1_5   },  // S_CRBOWATK1_4
  {SPR_CRBW,    7,   3, AI_NULL,            S_CRBOWATK1_6   },  // S_CRBOWATK1_5
  {SPR_CRBW,    0,   4, AI_NULL,            S_CRBOWATK1_7   },  // S_CRBOWATK1_6
  {SPR_CRBW,    1,   4, AI_NULL,            S_CRBOWATK1_8   },  // S_CRBOWATK1_7
  {SPR_CRBW,    2,   5, AP_ReFire,          S_CRBOW1        },  // S_CRBOWATK1_8
  {SPR_CRBW,    3,   5, AP_FireCrossbowPL2, S_CRBOWATK2_2   },  // S_CRBOWATK2_1
  {SPR_CRBW,    4,   3, AI_NULL,            S_CRBOWATK2_3   },  // S_CRBOWATK2_2
  {SPR_CRBW,    5,   2, AI_NULL,            S_CRBOWATK2_4   },  // S_CRBOWATK2_3
  {SPR_CRBW,    6,   3, AI_NULL,            S_CRBOWATK2_5   },  // S_CRBOWATK2_4
  {SPR_CRBW,    7,   2, AI_NULL,            S_CRBOWATK2_6   },  // S_CRBOWATK2_5
  {SPR_CRBW,    0,   3, AI_NULL,            S_CRBOWATK2_7   },  // S_CRBOWATK2_6
  {SPR_CRBW,    1,   3, AI_NULL,            S_CRBOWATK2_8   },  // S_CRBOWATK2_7
  {SPR_CRBW,    2,   4, AP_ReFire,          S_CRBOW1        },  // S_CRBOWATK2_8
// Things, functions are acp1 (mobj)
  {SPR_FX03,FFB|1,   1, AI_NULL,            S_CRBOWFX1      },  // S_CRBOWFX1
  {SPR_FX03,FFB|7,   8, AI_NULL,            S_CRBOWFXI1_2   },  // S_CRBOWFXI1_1
  {SPR_FX03,FFB|8,   8, AI_NULL,            S_CRBOWFXI1_3   },  // S_CRBOWFXI1_2
  {SPR_FX03,FFB|9,   8, AI_NULL,            S_NULL          },  // S_CRBOWFXI1_3
  {SPR_FX03,FFB|1,   1, AI_BoltSpark,       S_CRBOWFX2      },  // S_CRBOWFX2
  {SPR_FX03,FFB|0,   1, AI_NULL,            S_CRBOWFX3      },  // S_CRBOWFX3
  {SPR_FX03,FFB|2,   8, AI_NULL,            S_CRBOWFXI3_2   },  // S_CRBOWFXI3_1
  {SPR_FX03,FFB|3,   8, AI_NULL,            S_CRBOWFXI3_3   },  // S_CRBOWFXI3_2
  {SPR_FX03,FFB|4,   8, AI_NULL,            S_NULL          },  // S_CRBOWFXI3_3
  {SPR_FX03,FFB|5,   8, AI_NULL,            S_CRBOWFX4_2    },  // S_CRBOWFX4_1
  {SPR_FX03,FFB|6,   8, AI_NULL,            S_NULL          },  // S_CRBOWFX4_2
/*
  {SPR_BLOD,    2,   8, AI_NULL,            S_HBLOOD2       },  // S_HBLOOD1
  {SPR_BLOD,    1,   8, AI_NULL,            S_HBLOOD3       },  // S_HBLOOD2
  {SPR_BLOD,    0,   8, AI_NULL,            S_NULL          },  // S_HBLOOD3
*/
  {SPR_BLUD,    2,   8, AI_NULL,            S_BLOODSPLATTER2},  // S_BLOODSPLATTER1
  {SPR_BLUD,    1,   8, AI_NULL,            S_BLOODSPLATTER3},  // S_BLOODSPLATTER2
  {SPR_BLUD,    0,   8, AI_NULL,            S_NULL          },  // S_BLOODSPLATTER3
  {SPR_BLUD,    0,   6, AI_NULL,            S_NULL          },  // S_BLOODSPLATTERX
/*
  {SPR_PLAY,    0,  -1, AI_NULL,            S_NULL          },  // S_PLAY
  {SPR_PLAY,    0,   4, AI_NULL,            S_PLAY_RUN2     },  // S_PLAY_RUN1
  {SPR_PLAY,    1,   4, AI_NULL,            S_PLAY_RUN3     },  // S_PLAY_RUN2
  {SPR_PLAY,    2,   4, AI_NULL,            S_PLAY_RUN4     },  // S_PLAY_RUN3
  {SPR_PLAY,    3,   4, AI_NULL,            S_PLAY_RUN1     },  // S_PLAY_RUN4
  {SPR_PLAY,    4,  12, AI_NULL,            S_PLAY          },  // S_PLAY_ATK1
  {SPR_PLAY,FFB|5,   6, AI_NULL,            S_PLAY_ATK1     },  // S_PLAY_ATK2
  {SPR_PLAY,    6,   4, AI_NULL,            S_PLAY_PAIN2    },  // S_PLAY_PAIN
  {SPR_PLAY,    6,   4, AI_Pain,            S_PLAY          },  // S_PLAY_PAIN2
  {SPR_PLAY,    7,   6, AI_NULL,            S_PLAY_DIE2     },  // S_PLAY_DIE1
  {SPR_PLAY,    8,   6, AI_HScream,         S_PLAY_DIE3     },  // S_PLAY_DIE2
  {SPR_PLAY,    9,   6, AI_NULL,            S_PLAY_DIE4     },  // S_PLAY_DIE3
  {SPR_PLAY,   10,   6, AI_NULL,            S_PLAY_DIE5     },  // S_PLAY_DIE4
  {SPR_PLAY,   11,   6, AI_NoBlocking,      S_PLAY_DIE6     },  // S_PLAY_DIE5
  {SPR_PLAY,   12,   6, AI_NULL,            S_PLAY_DIE7     },  // S_PLAY_DIE6
  {SPR_PLAY,   13,   6, AI_NULL,            S_PLAY_DIE8     },  // S_PLAY_DIE7
  {SPR_PLAY,   14,   6, AI_NULL,            S_PLAY_DIE9     },  // S_PLAY_DIE8
  {SPR_PLAY,   15,  -1, AI_AddPlayerCorpse, S_NULL          },  // S_PLAY_DIE9
  {SPR_PLAY,   16,   5, AI_HScream,         S_PLAY_XDIE2    },  // S_PLAY_XDIE1
  {SPR_PLAY,   17,   5, AI_SkullPop,        S_PLAY_XDIE3    },  // S_PLAY_XDIE2
  {SPR_PLAY,   18,   5, AI_NoBlocking,      S_PLAY_XDIE4    },  // S_PLAY_XDIE3
  {SPR_PLAY,   19,   5, AI_NULL,            S_PLAY_XDIE5    },  // S_PLAY_XDIE4
  {SPR_PLAY,   20,   5, AI_NULL,            S_PLAY_XDIE6    },  // S_PLAY_XDIE5
  {SPR_PLAY,   21,   5, AI_NULL,            S_PLAY_XDIE7    },  // S_PLAY_XDIE6
  {SPR_PLAY,   22,   5, AI_NULL,            S_PLAY_XDIE8    },  // S_PLAY_XDIE7
  {SPR_PLAY,   23,   5, AI_NULL,            S_PLAY_XDIE9    },  // S_PLAY_XDIE8
  {SPR_PLAY,   24,  -1, AI_AddPlayerCorpse, S_NULL          },  // S_PLAY_XDIE9
  {SPR_FDTH,FFB|0,   5, AI_FlameSnd,        S_PLAY_FDTH2    },  // S_PLAY_FDTH1
  {SPR_FDTH,FFB|1,   4, AI_NULL,            S_PLAY_FDTH3    },  // S_PLAY_FDTH2
  {SPR_FDTH,FFB|2,   5, AI_NULL,            S_PLAY_FDTH4    },  // S_PLAY_FDTH3
  {SPR_FDTH,FFB|3,   4, AI_HScream,         S_PLAY_FDTH5    },  // S_PLAY_FDTH4
  {SPR_FDTH,FFB|4,   5, AI_NULL,            S_PLAY_FDTH6    },  // S_PLAY_FDTH5
  {SPR_FDTH,FFB|5,   4, AI_NULL,            S_PLAY_FDTH7    },  // S_PLAY_FDTH6
  {SPR_FDTH,FFB|6,   5, AI_FlameSnd,        S_PLAY_FDTH8    },  // S_PLAY_FDTH7
  {SPR_FDTH,FFB|7,   4, AI_NULL,            S_PLAY_FDTH9    },  // S_PLAY_FDTH8
  {SPR_FDTH,FFB|8,   5, AI_NULL,            S_PLAY_FDTH10   },  // S_PLAY_FDTH9
  {SPR_FDTH,FFB|9,   4, AI_NULL,            S_PLAY_FDTH11   },  // S_PLAY_FDTH10
  {SPR_FDTH,FFB|10,  5, AI_NULL,            S_PLAY_FDTH12   },  // S_PLAY_FDTH11
  {SPR_FDTH,FFB|11,  4, AI_NULL,            S_PLAY_FDTH13   },  // S_PLAY_FDTH12
  {SPR_FDTH,FFB|12,  5, AI_NULL,            S_PLAY_FDTH14   },  // S_PLAY_FDTH13
  {SPR_FDTH,FFB|13,  4, AI_NULL,            S_PLAY_FDTH15   },  // S_PLAY_FDTH14
  {SPR_FDTH,FFB|14,  5, AI_NoBlocking,      S_PLAY_FDTH16   },  // S_PLAY_FDTH15
  {SPR_FDTH,FFB|15,  4, AI_NULL,            S_PLAY_FDTH17   },  // S_PLAY_FDTH16
  {SPR_FDTH,FFB|16,  5, AI_NULL,            S_PLAY_FDTH18   },  // S_PLAY_FDTH17
  {SPR_FDTH,FFB|17,  4, AI_NULL,            S_PLAY_FDTH19   },  // S_PLAY_FDTH18
  {SPR_ACLO,    4,  35, AI_CheckBurnGone,   S_PLAY_FDTH19   },  // S_PLAY_FDTH19
  {SPR_ACLO,    4,   8, AI_NULL,            S_NULL          },  // S_PLAY_FDTH20
*/
// Things, functions are acp1 (mobj)
  {SPR_BSKL,    0,   5, AI_CheckSkullFloor, S_BLOODYSKULL2  },  // S_BLOODYSKULL1
  {SPR_BSKL,    1,   5, AI_CheckSkullFloor, S_BLOODYSKULL3  },  // S_BLOODYSKULL2
  {SPR_BSKL,    2,   5, AI_CheckSkullFloor, S_BLOODYSKULL4  },  // S_BLOODYSKULL3
  {SPR_BSKL,    3,   5, AI_CheckSkullFloor, S_BLOODYSKULL5  },  // S_BLOODYSKULL4
  {SPR_BSKL,    4,   5, AI_CheckSkullFloor, S_BLOODYSKULL1  },  // S_BLOODYSKULL5
  {SPR_BSKL,    5,  16, AI_CheckSkullDone,  S_BLOODYSKULLX1 },  // S_BLOODYSKULLX1
  {SPR_BSKL,    5,1050, AI_NULL,            S_NULL          },  // S_BLOODYSKULLX2
  {SPR_CHKN,    0,  -1, AI_NULL,            S_NULL          },  // S_CHICPLAY
  {SPR_CHKN,    0,   3, AI_NULL,            S_CHICPLAY_RUN2 },  // S_CHICPLAY_RUN1
  {SPR_CHKN,    1,   3, AI_NULL,            S_CHICPLAY_RUN3 },  // S_CHICPLAY_RUN2
  {SPR_CHKN,    0,   3, AI_NULL,            S_CHICPLAY_RUN4 },  // S_CHICPLAY_RUN3
  {SPR_CHKN,    1,   3, AI_NULL,            S_CHICPLAY_RUN1 },  // S_CHICPLAY_RUN4
  {SPR_CHKN,    2,  12, AI_NULL,            S_CHICPLAY      },  // S_CHICPLAY_ATK1
  {SPR_CHKN,    3,   4, AI_Feathers,        S_CHICPLAY_PAIN2},  // S_CHICPLAY_PAIN
  {SPR_CHKN,    2,   4, AI_Pain,            S_CHICPLAY      },  // S_CHICPLAY_PAIN2
  {SPR_CHKN,    0,  10, AI_ChicLook,        S_CHICKEN_LOOK2 },  // S_CHICKEN_LOOK1
  {SPR_CHKN,    1,  10, AI_ChicLook,        S_CHICKEN_LOOK1 },  // S_CHICKEN_LOOK2
  {SPR_CHKN,    0,   3, AI_ChicChase,       S_CHICKEN_WALK2 },  // S_CHICKEN_WALK1
  {SPR_CHKN,    1,   3, AI_ChicChase,       S_CHICKEN_WALK1 },  // S_CHICKEN_WALK2
  {SPR_CHKN,    3,   5, AI_Feathers,        S_CHICKEN_PAIN2 },  // S_CHICKEN_PAIN1
  {SPR_CHKN,    2,   5, AI_ChicPain,        S_CHICKEN_WALK1 },  // S_CHICKEN_PAIN2
  {SPR_CHKN,    0,   8, AI_FaceTarget,      S_CHICKEN_ATK2  },  // S_CHICKEN_ATK1
  {SPR_CHKN,    2,  10, AI_ChicAttack,      S_CHICKEN_WALK1 },  // S_CHICKEN_ATK2
  {SPR_CHKN,    4,   6, AI_HScream,         S_CHICKEN_DIE2  },  // S_CHICKEN_DIE1
  {SPR_CHKN,    5,   6, AI_Feathers,        S_CHICKEN_DIE3  },  // S_CHICKEN_DIE2
  {SPR_CHKN,    6,   6, AI_NULL,            S_CHICKEN_DIE4  },  // S_CHICKEN_DIE3
  {SPR_CHKN,    7,   6, AI_NoBlocking,      S_CHICKEN_DIE5  },  // S_CHICKEN_DIE4
  {SPR_CHKN,    8,   6, AI_NULL,            S_CHICKEN_DIE6  },  // S_CHICKEN_DIE5
  {SPR_CHKN,    9,   6, AI_NULL,            S_CHICKEN_DIE7  },  // S_CHICKEN_DIE6
  {SPR_CHKN,   10,   6, AI_NULL,            S_CHICKEN_DIE8  },  // S_CHICKEN_DIE7
  {SPR_CHKN,   11,  -1, AI_NULL,            S_NULL          },  // S_CHICKEN_DIE8
  {SPR_CHKN,   12,   3, AI_NULL,            S_FEATHER2      },  // S_FEATHER1
  {SPR_CHKN,   13,   3, AI_NULL,            S_FEATHER3      },  // S_FEATHER2
  {SPR_CHKN,   14,   3, AI_NULL,            S_FEATHER4      },  // S_FEATHER3
  {SPR_CHKN,   15,   3, AI_NULL,            S_FEATHER5      },  // S_FEATHER4
  {SPR_CHKN,   16,   3, AI_NULL,            S_FEATHER6      },  // S_FEATHER5
  {SPR_CHKN,   15,   3, AI_NULL,            S_FEATHER7      },  // S_FEATHER6
  {SPR_CHKN,   14,   3, AI_NULL,            S_FEATHER8      },  // S_FEATHER7
  {SPR_CHKN,   13,   3, AI_NULL,            S_FEATHER1      },  // S_FEATHER8
  {SPR_CHKN,   13,   6, AI_NULL,            S_NULL          },  // S_FEATHERX
  {SPR_MUMM,    0,  10, AI_Look,           S_MUMMY_LOOK2   },  // S_MUMMY_LOOK1
  {SPR_MUMM,    1,  10, AI_Look,           S_MUMMY_LOOK1   },  // S_MUMMY_LOOK2
  {SPR_MUMM,    0,   4, AI_Chase,          S_MUMMY_WALK2   },  // S_MUMMY_WALK1
  {SPR_MUMM,    1,   4, AI_Chase,          S_MUMMY_WALK3   },  // S_MUMMY_WALK2
  {SPR_MUMM,    2,   4, AI_Chase,          S_MUMMY_WALK4   },  // S_MUMMY_WALK3
  {SPR_MUMM,    3,   4, AI_Chase,          S_MUMMY_WALK1   },  // S_MUMMY_WALK4
  {SPR_MUMM,    4,   6, AI_FaceTarget,      S_MUMMY_ATK2    },  // S_MUMMY_ATK1
  {SPR_MUMM,    5,   6, AI_MummyAttack,     S_MUMMY_ATK3    },  // S_MUMMY_ATK2
  {SPR_MUMM,    6,   6, AI_FaceTarget,      S_MUMMY_WALK1   },  // S_MUMMY_ATK3
  {SPR_MUMM,   23,   5, AI_FaceTarget,      S_MUMMYL_ATK2   },  // S_MUMMYL_ATK1
  {SPR_MUMM,FFB|24,  5, AI_FaceTarget,      S_MUMMYL_ATK3   },  // S_MUMMYL_ATK2
  {SPR_MUMM,   23,   5, AI_FaceTarget,      S_MUMMYL_ATK4   },  // S_MUMMYL_ATK3
  {SPR_MUMM,FFB|24,  5, AI_FaceTarget,      S_MUMMYL_ATK5   },  // S_MUMMYL_ATK4
  {SPR_MUMM,   23,   5, AI_FaceTarget,      S_MUMMYL_ATK6   },  // S_MUMMYL_ATK5
  {SPR_MUMM,FFB|24, 15, AI_MummyAttack2,    S_MUMMY_WALK1   },  // S_MUMMYL_ATK6
  {SPR_MUMM,    7,   4, AI_NULL,            S_MUMMY_PAIN2   },  // S_MUMMY_PAIN1
  {SPR_MUMM,    7,   4, AI_Pain,            S_MUMMY_WALK1   },  // S_MUMMY_PAIN2
  {SPR_MUMM,    8,   5, AI_NULL,            S_MUMMY_DIE2    },  // S_MUMMY_DIE1
  {SPR_MUMM,    9,   5, AI_HScream,         S_MUMMY_DIE3    },  // S_MUMMY_DIE2
  {SPR_MUMM,   10,   5, AI_MummySoul,       S_MUMMY_DIE4    },  // S_MUMMY_DIE3
  {SPR_MUMM,   11,   5, AI_NULL,            S_MUMMY_DIE5    },  // S_MUMMY_DIE4
  {SPR_MUMM,   12,   5, AI_NoBlocking,      S_MUMMY_DIE6    },  // S_MUMMY_DIE5
  {SPR_MUMM,   13,   5, AI_NULL,            S_MUMMY_DIE7    },  // S_MUMMY_DIE6
  {SPR_MUMM,   14,   5, AI_NULL,            S_MUMMY_DIE8    },  // S_MUMMY_DIE7
  {SPR_MUMM,   15,  -1, AI_NULL,            S_NULL          },  // S_MUMMY_DIE8
  {SPR_MUMM,   16,   5, AI_NULL,            S_MUMMY_SOUL2   },  // S_MUMMY_SOUL1
  {SPR_MUMM,   17,   5, AI_NULL,            S_MUMMY_SOUL3   },  // S_MUMMY_SOUL2
  {SPR_MUMM,   18,   5, AI_NULL,            S_MUMMY_SOUL4   },  // S_MUMMY_SOUL3
  {SPR_MUMM,   19,   9, AI_NULL,            S_MUMMY_SOUL5   },  // S_MUMMY_SOUL4
  {SPR_MUMM,   20,   5, AI_NULL,            S_MUMMY_SOUL6   },  // S_MUMMY_SOUL5
  {SPR_MUMM,   21,   5, AI_NULL,            S_MUMMY_SOUL7   },  // S_MUMMY_SOUL6
  {SPR_MUMM,   22,   5, AI_NULL,            S_NULL          },  // S_MUMMY_SOUL7
  {SPR_FX15,FFB|0,   5, AI_ContMobjSound,   S_MUMMYFX1_2    },  // S_MUMMYFX1_1
  {SPR_FX15,FFB|1,   5, AI_MummyFX1Seek,    S_MUMMYFX1_3    },  // S_MUMMYFX1_2
  {SPR_FX15,FFB|2,   5, AI_NULL,            S_MUMMYFX1_4    },  // S_MUMMYFX1_3
  {SPR_FX15,FFB|1,   5, AI_MummyFX1Seek,    S_MUMMYFX1_1    },  // S_MUMMYFX1_4
  {SPR_FX15,FFB|3,   5, AI_NULL,            S_MUMMYFXI1_2   },  // S_MUMMYFXI1_1
  {SPR_FX15,FFB|4,   5, AI_NULL,            S_MUMMYFXI1_3   },  // S_MUMMYFXI1_2
  {SPR_FX15,FFB|5,   5, AI_NULL,            S_MUMMYFXI1_4   },  // S_MUMMYFXI1_3
  {SPR_FX15,FFB|6,   5, AI_NULL,            S_NULL          },  // S_MUMMYFXI1_4
  {SPR_BEAS,    0,  10, AI_Look,           S_BEAST_LOOK2   },  // S_BEAST_LOOK1
  {SPR_BEAS,    1,  10, AI_Look,           S_BEAST_LOOK1   },  // S_BEAST_LOOK2
  {SPR_BEAS,    0,   3, AI_Chase,          S_BEAST_WALK2   },  // S_BEAST_WALK1
  {SPR_BEAS,    1,   3, AI_Chase,          S_BEAST_WALK3   },  // S_BEAST_WALK2
  {SPR_BEAS,    2,   3, AI_Chase,          S_BEAST_WALK4   },  // S_BEAST_WALK3
  {SPR_BEAS,    3,   3, AI_Chase,          S_BEAST_WALK5   },  // S_BEAST_WALK4
  {SPR_BEAS,    4,   3, AI_Chase,          S_BEAST_WALK6   },  // S_BEAST_WALK5
  {SPR_BEAS,    5,   3, AI_Chase,          S_BEAST_WALK1   },  // S_BEAST_WALK6
  {SPR_BEAS,    7,  10, AI_FaceTarget,      S_BEAST_ATK2    },  // S_BEAST_ATK1
  {SPR_BEAS,    8,  10, AI_BeastAttack,     S_BEAST_WALK1   },  // S_BEAST_ATK2
  {SPR_BEAS,    6,   3, AI_NULL,            S_BEAST_PAIN2   },  // S_BEAST_PAIN1
  {SPR_BEAS,    6,   3, AI_Pain,            S_BEAST_WALK1   },  // S_BEAST_PAIN2
  {SPR_BEAS,   17,   6, AI_NULL,            S_BEAST_DIE2    },  // S_BEAST_DIE1
  {SPR_BEAS,   18,   6, AI_HScream,         S_BEAST_DIE3    },  // S_BEAST_DIE2
  {SPR_BEAS,   19,   6, AI_NULL,            S_BEAST_DIE4    },  // S_BEAST_DIE3
  {SPR_BEAS,   20,   6, AI_NULL,            S_BEAST_DIE5    },  // S_BEAST_DIE4
  {SPR_BEAS,   21,   6, AI_NULL,            S_BEAST_DIE6    },  // S_BEAST_DIE5
  {SPR_BEAS,   22,   6, AI_NoBlocking,      S_BEAST_DIE7    },  // S_BEAST_DIE6
  {SPR_BEAS,   23,   6, AI_NULL,            S_BEAST_DIE8    },  // S_BEAST_DIE7
  {SPR_BEAS,   24,   6, AI_NULL,            S_BEAST_DIE9    },  // S_BEAST_DIE8
  {SPR_BEAS,   25,  -1, AI_NULL,            S_NULL          },  // S_BEAST_DIE9
  {SPR_BEAS,    9,   5, AI_NULL,            S_BEAST_XDIE2   },  // S_BEAST_XDIE1
  {SPR_BEAS,   10,   6, AI_HScream,         S_BEAST_XDIE3   },  // S_BEAST_XDIE2
  {SPR_BEAS,   11,   5, AI_NULL,            S_BEAST_XDIE4   },  // S_BEAST_XDIE3
  {SPR_BEAS,   12,   6, AI_NULL,            S_BEAST_XDIE5   },  // S_BEAST_XDIE4
  {SPR_BEAS,   13,   5, AI_NULL,            S_BEAST_XDIE6   },  // S_BEAST_XDIE5
  {SPR_BEAS,   14,   6, AI_NoBlocking,      S_BEAST_XDIE7   },  // S_BEAST_XDIE6
  {SPR_BEAS,   15,   5, AI_NULL,            S_BEAST_XDIE8   },  // S_BEAST_XDIE7
  {SPR_BEAS,   16,  -1, AI_NULL,            S_NULL          },  // S_BEAST_XDIE8
  {SPR_FRB1,    0,   2, AI_BeastPuff,       S_BEASTBALL2    },  // S_BEASTBALL1
  {SPR_FRB1,    0,   2, AI_BeastPuff,       S_BEASTBALL3    },  // S_BEASTBALL2
  {SPR_FRB1,    1,   2, AI_BeastPuff,       S_BEASTBALL4    },  // S_BEASTBALL3
  {SPR_FRB1,    1,   2, AI_BeastPuff,       S_BEASTBALL5    },  // S_BEASTBALL4
  {SPR_FRB1,    2,   2, AI_BeastPuff,       S_BEASTBALL6    },  // S_BEASTBALL5
  {SPR_FRB1,    2,   2, AI_BeastPuff,       S_BEASTBALL1    },  // S_BEASTBALL6
  {SPR_FRB1,    3,   4, AI_NULL,            S_BEASTBALLX2   },  // S_BEASTBALLX1
  {SPR_FRB1,    4,   4, AI_NULL,            S_BEASTBALLX3   },  // S_BEASTBALLX2
  {SPR_FRB1,    5,   4, AI_NULL,            S_BEASTBALLX4   },  // S_BEASTBALLX3
  {SPR_FRB1,    6,   4, AI_NULL,            S_BEASTBALLX5   },  // S_BEASTBALLX4
  {SPR_FRB1,    7,   4, AI_NULL,            S_NULL          },  // S_BEASTBALLX5
  {SPR_FRB1,    0,   4, AI_NULL,            S_BURNBALL2     },  // S_BURNBALL1
  {SPR_FRB1,    1,   4, AI_NULL,            S_BURNBALL3     },  // S_BURNBALL2
  {SPR_FRB1,    2,   4, AI_NULL,            S_BURNBALL4     },  // S_BURNBALL3
  {SPR_FRB1,    3,   4, AI_NULL,            S_BURNBALL5     },  // S_BURNBALL4
  {SPR_FRB1,    4,   4, AI_NULL,            S_BURNBALL6     },  // S_BURNBALL5
  {SPR_FRB1,    5,   4, AI_NULL,            S_BURNBALL7     },  // S_BURNBALL6
  {SPR_FRB1,    6,   4, AI_NULL,            S_BURNBALL8     },  // S_BURNBALL7
  {SPR_FRB1,    7,   4, AI_NULL,            S_NULL          },  // S_BURNBALL8
  {SPR_FRB1,FFB|0,   4, AI_NULL,            S_BURNBALLFB2   },  // S_BURNBALLFB1
  {SPR_FRB1,FFB|1,   4, AI_NULL,            S_BURNBALLFB3   },  // S_BURNBALLFB2
  {SPR_FRB1,FFB|2,   4, AI_NULL,            S_BURNBALLFB4   },  // S_BURNBALLFB3
  {SPR_FRB1,FFB|3,   4, AI_NULL,            S_BURNBALLFB5   },  // S_BURNBALLFB4
  {SPR_FRB1,FFB|4,   4, AI_NULL,            S_BURNBALLFB6   },  // S_BURNBALLFB5
  {SPR_FRB1,FFB|5,   4, AI_NULL,            S_BURNBALLFB7   },  // S_BURNBALLFB6
  {SPR_FRB1,FFB|6,   4, AI_NULL,            S_BURNBALLFB8   },  // S_BURNBALLFB7
  {SPR_FRB1,FFB|7,   4, AI_NULL,            S_NULL          },  // S_BURNBALLFB8
  {SPR_FRB1,    3,   4, AI_NULL,            S_PUFFY2        },  // S_PUFFY1
  {SPR_FRB1,    4,   4, AI_NULL,            S_PUFFY3        },  // S_PUFFY2
  {SPR_FRB1,    5,   4, AI_NULL,            S_PUFFY4        },  // S_PUFFY3
  {SPR_FRB1,    6,   4, AI_NULL,            S_PUFFY5        },  // S_PUFFY4
  {SPR_FRB1,    7,   4, AI_NULL,            S_NULL          },  // S_PUFFY5
  {SPR_SNKE,    0,  10, AI_Look,            S_SNAKE_LOOK2   },  // S_SNAKE_LOOK1
  {SPR_SNKE,    1,  10, AI_Look,            S_SNAKE_LOOK1   },  // S_SNAKE_LOOK2
  {SPR_SNKE,    0,   4, AI_Chase,           S_SNAKE_WALK2   },  // S_SNAKE_WALK1
  {SPR_SNKE,    1,   4, AI_Chase,           S_SNAKE_WALK3   },  // S_SNAKE_WALK2
  {SPR_SNKE,    2,   4, AI_Chase,           S_SNAKE_WALK4   },  // S_SNAKE_WALK3
  {SPR_SNKE,    3,   4, AI_Chase,           S_SNAKE_WALK1   },  // S_SNAKE_WALK4
  {SPR_SNKE,    5,   5, AI_FaceTarget,      S_SNAKE_ATK2    },  // S_SNAKE_ATK1
  {SPR_SNKE,    5,   5, AI_FaceTarget,      S_SNAKE_ATK3    },  // S_SNAKE_ATK2
  {SPR_SNKE,    5,   4, AI_SnakeAttack,     S_SNAKE_ATK4    },  // S_SNAKE_ATK3
  {SPR_SNKE,    5,   4, AI_SnakeAttack,     S_SNAKE_ATK5    },  // S_SNAKE_ATK4
  {SPR_SNKE,    5,   4, AI_SnakeAttack,     S_SNAKE_ATK6    },  // S_SNAKE_ATK5
  {SPR_SNKE,    5,   5, AI_FaceTarget,      S_SNAKE_ATK7    },  // S_SNAKE_ATK6
  {SPR_SNKE,    5,   5, AI_FaceTarget,      S_SNAKE_ATK8    },  // S_SNAKE_ATK7
  {SPR_SNKE,    5,   5, AI_FaceTarget,      S_SNAKE_ATK9    },  // S_SNAKE_ATK8
  {SPR_SNKE,    5,   4, AI_SnakeAttack2,    S_SNAKE_WALK1   },  // S_SNAKE_ATK9
  {SPR_SNKE,    4,   3, AI_NULL,            S_SNAKE_PAIN2   },  // S_SNAKE_PAIN1
  {SPR_SNKE,    4,   3, AI_Pain,            S_SNAKE_WALK1   },  // S_SNAKE_PAIN2
  {SPR_SNKE,    6,   5, AI_NULL,            S_SNAKE_DIE2    },  // S_SNAKE_DIE1
  {SPR_SNKE,    7,   5, AI_HScream,         S_SNAKE_DIE3    },  // S_SNAKE_DIE2
  {SPR_SNKE,    8,   5, AI_NULL,            S_SNAKE_DIE4    },  // S_SNAKE_DIE3
  {SPR_SNKE,    9,   5, AI_NULL,            S_SNAKE_DIE5    },  // S_SNAKE_DIE4
  {SPR_SNKE,   10,   5, AI_NULL,            S_SNAKE_DIE6    },  // S_SNAKE_DIE5
  {SPR_SNKE,   11,   5, AI_NULL,            S_SNAKE_DIE7    },  // S_SNAKE_DIE6
  {SPR_SNKE,   12,   5, AI_NoBlocking,      S_SNAKE_DIE8    },  // S_SNAKE_DIE7
  {SPR_SNKE,   13,   5, AI_NULL,            S_SNAKE_DIE9    },  // S_SNAKE_DIE8
  {SPR_SNKE,   14,   5, AI_NULL,            S_SNAKE_DIE10   },  // S_SNAKE_DIE9
  {SPR_SNKE,   15,  -1, AI_NULL,            S_NULL          },  // S_SNAKE_DIE10
  {SPR_SNFX,FFB|0,   5, AI_NULL,            S_SNAKEPRO_A2   },  // S_SNAKEPRO_A1
  {SPR_SNFX,FFB|1,   5, AI_NULL,            S_SNAKEPRO_A3   },  // S_SNAKEPRO_A2
  {SPR_SNFX,FFB|2,   5, AI_NULL,            S_SNAKEPRO_A4   },  // S_SNAKEPRO_A3
  {SPR_SNFX,FFB|3,   5, AI_NULL,            S_SNAKEPRO_A1   },  // S_SNAKEPRO_A4
  {SPR_SNFX,FFB|4,   5, AI_NULL,            S_SNAKEPRO_AX2  },  // S_SNAKEPRO_AX1
  {SPR_SNFX,FFB|5,   5, AI_NULL,            S_SNAKEPRO_AX3  },  // S_SNAKEPRO_AX2
  {SPR_SNFX,FFB|6,   4, AI_NULL,            S_SNAKEPRO_AX4  },  // S_SNAKEPRO_AX3
  {SPR_SNFX,FFB|7,   3, AI_NULL,            S_SNAKEPRO_AX5  },  // S_SNAKEPRO_AX4
  {SPR_SNFX,FFB|8,   3, AI_NULL,            S_NULL          },  // S_SNAKEPRO_AX5
  {SPR_SNFX,FFB|9,   6, AI_NULL,            S_SNAKEPRO_B2   },  // S_SNAKEPRO_B1
  {SPR_SNFX,FFB|10,  6, AI_NULL,            S_SNAKEPRO_B1   },  // S_SNAKEPRO_B2
  {SPR_SNFX,FFB|11,  5, AI_NULL,            S_SNAKEPRO_BX2  },  // S_SNAKEPRO_BX1
  {SPR_SNFX,FFB|12,  5, AI_NULL,            S_SNAKEPRO_BX3  },  // S_SNAKEPRO_BX2
  {SPR_SNFX,FFB|13,  4, AI_NULL,            S_SNAKEPRO_BX4  },  // S_SNAKEPRO_BX3
  {SPR_SNFX,FFB|14,  3, AI_NULL,            S_NULL          },  // S_SNAKEPRO_BX4
  {SPR_HHEAD,    0, 10, AI_Look,            S_HHEAD_LOOK    },  // S_HEAD_LOOK
  {SPR_HHEAD,    0,  4, AI_Chase,           S_HHEAD_FLOAT   },  // S_HEAD_FLOAT
  {SPR_HHEAD,    0,  5, AI_FaceTarget,      S_HHEAD_ATK2    },  // S_HEAD_ATK1
  {SPR_HHEAD,    1, 20, AI_HHeadAttack,     S_HHEAD_FLOAT   },  // S_HEAD_ATK2
  {SPR_HHEAD,    0,  4, AI_NULL,            S_HHEAD_PAIN2   },  // S_HEAD_PAIN1
  {SPR_HHEAD,    0,  4, AI_Pain,            S_HHEAD_FLOAT   },  // S_HEAD_PAIN2
  {SPR_HHEAD,    2,  7, AI_NULL,            S_HHEAD_DIE2    },  // S_HEAD_DIE1
  {SPR_HHEAD,    3,  7, AI_HScream,         S_HHEAD_DIE3    },  // S_HEAD_DIE2
  {SPR_HHEAD,    4,  7, AI_NULL,            S_HHEAD_DIE4    },  // S_HEAD_DIE3
  {SPR_HHEAD,    5,  7, AI_NULL,            S_HHEAD_DIE5    },  // S_HEAD_DIE4
  {SPR_HHEAD,    6,  7, AI_NoBlocking,      S_HHEAD_DIE6    },  // S_HEAD_DIE5
  {SPR_HHEAD,    7,  7, AI_NULL,            S_HHEAD_DIE7    },  // S_HEAD_DIE6
  {SPR_HHEAD,    8, -1, AI_HBossDeath,      S_NULL          },  // S_HEAD_DIE7
  {SPR_FX05,    0,   6, AI_NULL,            S_HHEADFX1_2    },  // S_HEADFX1_1
  {SPR_FX05,    1,   6, AI_NULL,            S_HHEADFX1_3    },  // S_HEADFX1_2
  {SPR_FX05,    2,   6, AI_NULL,            S_HHEADFX1_1    },  // S_HEADFX1_3
  {SPR_FX05,    3,   5, AI_HeadIceImpact,   S_HHEADFXI1_2   },  // S_HEADFXI1_1
  {SPR_FX05,    4,   5, AI_NULL,            S_HHEADFXI1_3   },  // S_HEADFXI1_2
  {SPR_FX05,    5,   5, AI_NULL,            S_HHEADFXI1_4   },  // S_HEADFXI1_3
  {SPR_FX05,    6,   5, AI_NULL,            S_NULL          },  // S_HEADFXI1_4
  {SPR_FX05,    7,   6, AI_NULL,            S_HHEADFX2_2    },  // S_HEADFX2_1
  {SPR_FX05,    8,   6, AI_NULL,            S_HHEADFX2_3    },  // S_HEADFX2_2
  {SPR_FX05,    9,   6, AI_NULL,            S_HHEADFX2_1    },  // S_HEADFX2_3
  {SPR_FX05,    3,   5, AI_NULL,            S_HHEADFXI2_2   },  // S_HEADFXI2_1
  {SPR_FX05,    4,   5, AI_NULL,            S_HHEADFXI2_3   },  // S_HEADFXI2_2
  {SPR_FX05,    5,   5, AI_NULL,            S_HHEADFXI2_4   },  // S_HEADFXI2_3
  {SPR_FX05,    6,   5, AI_NULL,            S_NULL          },  // S_HEADFXI2_4
  {SPR_FX06,    0,   4, AI_HeadFireGrow,    S_HHEADFX3_2    },  // S_HEADFX3_1
  {SPR_FX06,    1,   4, AI_HeadFireGrow,    S_HHEADFX3_3    },  // S_HEADFX3_2
  {SPR_FX06,    2,   4, AI_HeadFireGrow,    S_HHEADFX3_1    },  // S_HEADFX3_3
  {SPR_FX06,    0,   5, AI_NULL,            S_HHEADFX3_5    },  // S_HEADFX3_4
  {SPR_FX06,    1,   5, AI_NULL,            S_HHEADFX3_6    },  // S_HEADFX3_5
  {SPR_FX06,    2,   5, AI_NULL,            S_HHEADFX3_4    },  // S_HEADFX3_6
  {SPR_FX06,    3,   5, AI_NULL,            S_HHEADFXI3_2   },  // S_HEADFXI3_1
  {SPR_FX06,    4,   5, AI_NULL,            S_HHEADFXI3_3   },  // S_HEADFXI3_2
  {SPR_FX06,    5,   5, AI_NULL,            S_HHEADFXI3_4   },  // S_HEADFXI3_3
  {SPR_FX06,    6,   5, AI_NULL,            S_NULL          },  // S_HEADFXI3_4
  {SPR_FX07,    3,   3, AI_NULL,            S_HHEADFX4_2    },  // S_HEADFX4_1
  {SPR_FX07,    4,   3, AI_NULL,            S_HHEADFX4_3    },  // S_HEADFX4_2
  {SPR_FX07,    5,   3, AI_NULL,            S_HHEADFX4_4    },  // S_HEADFX4_3
  {SPR_FX07,    6,   3, AI_NULL,            S_HHEADFX4_5    },  // S_HEADFX4_4
  {SPR_FX07,    0,   3, AI_WhirlwindSeek,   S_HHEADFX4_6    },  // S_HEADFX4_5
  {SPR_FX07,    1,   3, AI_WhirlwindSeek,   S_HHEADFX4_7    },  // S_HEADFX4_6
  {SPR_FX07,    2,   3, AI_WhirlwindSeek,   S_HHEADFX4_5    },  // S_HEADFX4_7
  {SPR_FX07,    6,   4, AI_NULL,            S_HHEADFXI4_2   },  // S_HEADFXI4_1
  {SPR_FX07,    5,   4, AI_NULL,            S_HHEADFXI4_3   },  // S_HEADFXI4_2
  {SPR_FX07,    4,   4, AI_NULL,            S_HHEADFXI4_4   },  // S_HEADFXI4_3
  {SPR_FX07,    3,   4, AI_NULL,            S_NULL          },  // S_HEADFXI4_4
  {SPR_CLNK,    0,  10, AI_Look,            S_CLINK_LOOK2   },  // S_CLINK_LOOK1
  {SPR_CLNK,    1,  10, AI_Look,            S_CLINK_LOOK1   },  // S_CLINK_LOOK2
  {SPR_CLNK,    0,   3, AI_Chase,           S_CLINK_WALK2   },  // S_CLINK_WALK1
  {SPR_CLNK,    1,   3, AI_Chase,           S_CLINK_WALK3   },  // S_CLINK_WALK2
  {SPR_CLNK,    2,   3, AI_Chase,           S_CLINK_WALK4   },  // S_CLINK_WALK3
  {SPR_CLNK,    3,   3, AI_Chase,           S_CLINK_WALK1   },  // S_CLINK_WALK4
  {SPR_CLNK,    4,   5, AI_FaceTarget,      S_CLINK_ATK2    },  // S_CLINK_ATK1
  {SPR_CLNK,    5,   4, AI_FaceTarget,      S_CLINK_ATK3    },  // S_CLINK_ATK2
  {SPR_CLNK,    6,   7, AI_ClinkAttack,     S_CLINK_WALK1   },  // S_CLINK_ATK3
  {SPR_CLNK,    7,   3, AI_NULL,            S_CLINK_PAIN2   },  // S_CLINK_PAIN1
  {SPR_CLNK,    7,   3, AI_Pain,            S_CLINK_WALK1   },  // S_CLINK_PAIN2
  {SPR_CLNK,    8,   6, AI_NULL,            S_CLINK_DIE2    },  // S_CLINK_DIE1
  {SPR_CLNK,    9,   6, AI_NULL,            S_CLINK_DIE3    },  // S_CLINK_DIE2
  {SPR_CLNK,   10,   5, AI_HScream,         S_CLINK_DIE4    },  // S_CLINK_DIE3
  {SPR_CLNK,   11,   5, AI_NoBlocking,      S_CLINK_DIE5    },  // S_CLINK_DIE4
  {SPR_CLNK,   12,   5, AI_NULL,            S_CLINK_DIE6    },  // S_CLINK_DIE5
  {SPR_CLNK,   13,   5, AI_NULL,            S_CLINK_DIE7    },  // S_CLINK_DIE6
  {SPR_CLNK,   14,  -1, AI_NULL,            S_NULL          },  // S_CLINK_DIE7
  {SPR_WZRD,    0,  10, AI_Look,            S_WIZARD_LOOK2  },  // S_WIZARD_LOOK1
  {SPR_WZRD,    1,  10, AI_Look,            S_WIZARD_LOOK1  },  // S_WIZARD_LOOK2
  {SPR_WZRD,    0,   3, AI_Chase,           S_WIZARD_WALK2  },  // S_WIZARD_WALK1
  {SPR_WZRD,    0,   4, AI_Chase,           S_WIZARD_WALK3  },  // S_WIZARD_WALK2
  {SPR_WZRD,    0,   3, AI_Chase,           S_WIZARD_WALK4  },  // S_WIZARD_WALK3
  {SPR_WZRD,    0,   4, AI_Chase,           S_WIZARD_WALK5  },  // S_WIZARD_WALK4
  {SPR_WZRD,    1,   3, AI_Chase,           S_WIZARD_WALK6  },  // S_WIZARD_WALK5
  {SPR_WZRD,    1,   4, AI_Chase,           S_WIZARD_WALK7  },  // S_WIZARD_WALK6
  {SPR_WZRD,    1,   3, AI_Chase,           S_WIZARD_WALK8  },  // S_WIZARD_WALK7
  {SPR_WZRD,    1,   4, AI_Chase,           S_WIZARD_WALK1  },  // S_WIZARD_WALK8
  {SPR_WZRD,    2,   4, AI_WizAtk1,         S_WIZARD_ATK2   },  // S_WIZARD_ATK1
  {SPR_WZRD,    2,   4, AI_WizAtk2,         S_WIZARD_ATK3   },  // S_WIZARD_ATK2
  {SPR_WZRD,    2,   4, AI_WizAtk1,         S_WIZARD_ATK4   },  // S_WIZARD_ATK3
  {SPR_WZRD,    2,   4, AI_WizAtk2,         S_WIZARD_ATK5   },  // S_WIZARD_ATK4
  {SPR_WZRD,    2,   4, AI_WizAtk1,         S_WIZARD_ATK6   },  // S_WIZARD_ATK5
  {SPR_WZRD,    2,   4, AI_WizAtk2,         S_WIZARD_ATK7   },  // S_WIZARD_ATK6
  {SPR_WZRD,    2,   4, AI_WizAtk1,         S_WIZARD_ATK8   },  // S_WIZARD_ATK7
  {SPR_WZRD,    2,   4, AI_WizAtk2,         S_WIZARD_ATK9   },  // S_WIZARD_ATK8
  {SPR_WZRD,    3,  12, AI_WizAtk3,         S_WIZARD_WALK1  },  // S_WIZARD_ATK9
  {SPR_WZRD,    4,   3, AI_GhostOff,        S_WIZARD_PAIN2  },  // S_WIZARD_PAIN1
  {SPR_WZRD,    4,   3, AI_Pain,            S_WIZARD_WALK1  },  // S_WIZARD_PAIN2
  {SPR_WZRD,    5,   6, AI_GhostOff,        S_WIZARD_DIE2   },  // S_WIZARD_DIE1
  {SPR_WZRD,    6,   6, AI_HScream,         S_WIZARD_DIE3   },  // S_WIZARD_DIE2
  {SPR_WZRD,    7,   6, AI_NULL,            S_WIZARD_DIE4   },  // S_WIZARD_DIE3
  {SPR_WZRD,    8,   6, AI_NULL,            S_WIZARD_DIE5   },  // S_WIZARD_DIE4
  {SPR_WZRD,    9,   6, AI_NoBlocking,      S_WIZARD_DIE6   },  // S_WIZARD_DIE5
  {SPR_WZRD,   10,   6, AI_NULL,            S_WIZARD_DIE7   },  // S_WIZARD_DIE6
  {SPR_WZRD,   11,   6, AI_NULL,            S_WIZARD_DIE8   },  // S_WIZARD_DIE7
  {SPR_WZRD,   12,  -1, AI_NULL,            S_NULL          },  // S_WIZARD_DIE8
  {SPR_FX11,FFB|0,   6, AI_NULL,            S_WIZFX1_2      },  // S_WIZFX1_1
  {SPR_FX11,FFB|1,   6, AI_NULL,            S_WIZFX1_1      },  // S_WIZFX1_2
  {SPR_FX11,FFB|2,   5, AI_NULL,            S_WIZFXI1_2     },  // S_WIZFXI1_1
  {SPR_FX11,FFB|3,   5, AI_NULL,            S_WIZFXI1_3     },  // S_WIZFXI1_2
  {SPR_FX11,FFB|4,   5, AI_NULL,            S_WIZFXI1_4     },  // S_WIZFXI1_3
  {SPR_FX11,FFB|5,   5, AI_NULL,            S_WIZFXI1_5     },  // S_WIZFXI1_4
  {SPR_FX11,FFB|6,   5, AI_NULL,            S_NULL          },  // S_WIZFXI1_5
  {SPR_IMPX,    0,  10, AI_Look,            S_IMP_LOOK2     },  // S_IMP_LOOK1
  {SPR_IMPX,    1,  10, AI_Look,            S_IMP_LOOK3     },  // S_IMP_LOOK2
  {SPR_IMPX,    2,  10, AI_Look,            S_IMP_LOOK4     },  // S_IMP_LOOK3
  {SPR_IMPX,    1,  10, AI_Look,            S_IMP_LOOK1     },  // S_IMP_LOOK4
  {SPR_IMPX,    0,   3, AI_Chase,           S_IMP_FLY2      },  // S_IMP_FLY1
  {SPR_IMPX,    0,   3, AI_Chase,           S_IMP_FLY3      },  // S_IMP_FLY2
  {SPR_IMPX,    1,   3, AI_Chase,           S_IMP_FLY4      },  // S_IMP_FLY3
  {SPR_IMPX,    1,   3, AI_Chase,           S_IMP_FLY5      },  // S_IMP_FLY4
  {SPR_IMPX,    2,   3, AI_Chase,           S_IMP_FLY6      },  // S_IMP_FLY5
  {SPR_IMPX,    2,   3, AI_Chase,           S_IMP_FLY7      },  // S_IMP_FLY6
  {SPR_IMPX,    1,   3, AI_Chase,           S_IMP_FLY8      },  // S_IMP_FLY7
  {SPR_IMPX,    1,   3, AI_Chase,           S_IMP_FLY1      },  // S_IMP_FLY8
  {SPR_IMPX,    3,   6, AI_FaceTarget,      S_IMP_MEATK2    },  // S_IMP_MEATK1
  {SPR_IMPX,    4,   6, AI_FaceTarget,      S_IMP_MEATK3    },  // S_IMP_MEATK2
  {SPR_IMPX,    5,   6, AI_ImpMeAttack,     S_IMP_FLY1      },  // S_IMP_MEATK3
  {SPR_IMPX,    0,  10, AI_FaceTarget,      S_IMP_MSATK1_2  },  // S_IMP_MSATK1_1
  {SPR_IMPX,    1,   6, AI_ImpMsAttack,     S_IMP_MSATK1_3  },  // S_IMP_MSATK1_2
  {SPR_IMPX,    2,   6, AI_NULL,            S_IMP_MSATK1_4  },  // S_IMP_MSATK1_3
  {SPR_IMPX,    1,   6, AI_NULL,            S_IMP_MSATK1_5  },  // S_IMP_MSATK1_4
  {SPR_IMPX,    0,   6, AI_NULL,            S_IMP_MSATK1_6  },  // S_IMP_MSATK1_5
  {SPR_IMPX,    1,   6, AI_NULL,            S_IMP_MSATK1_3  },  // S_IMP_MSATK1_6
  {SPR_IMPX,    3,   6, AI_FaceTarget,      S_IMP_MSATK2_2  },  // S_IMP_MSATK2_1
  {SPR_IMPX,    4,   6, AI_FaceTarget,      S_IMP_MSATK2_3  },  // S_IMP_MSATK2_2
  {SPR_IMPX,    5,   6, AI_ImpMsAttack2,    S_IMP_FLY1      },  // S_IMP_MSATK2_3
  {SPR_IMPX,    6,   3, AI_NULL,            S_IMP_PAIN2     },  // S_IMP_PAIN1
  {SPR_IMPX,    6,   3, AI_Pain,            S_IMP_FLY1      },  // S_IMP_PAIN2
  {SPR_IMPX,    6,   4, AI_ImpDeath,        S_IMP_DIE2      },  // S_IMP_DIE1
  {SPR_IMPX,    7,   5, AI_NULL,            S_IMP_DIE2      },  // S_IMP_DIE2
  {SPR_IMPX,   18,   5, AI_ImpXDeath1,      S_IMP_XDIE2     },  // S_IMP_XDIE1
  {SPR_IMPX,   19,   5, AI_NULL,            S_IMP_XDIE3     },  // S_IMP_XDIE2
  {SPR_IMPX,   20,   5, AI_NULL,            S_IMP_XDIE4     },  // S_IMP_XDIE3
  {SPR_IMPX,   21,   5, AI_ImpXDeath2,      S_IMP_XDIE5     },  // S_IMP_XDIE4
  {SPR_IMPX,   22,   5, AI_NULL,            S_IMP_XDIE5     },  // S_IMP_XDIE5
  {SPR_IMPX,    8,   7, AI_ImpExplode,      S_IMP_CRASH2    },  // S_IMP_CRASH1
  {SPR_IMPX,    9,   7, AI_HScream,         S_IMP_CRASH3    },  // S_IMP_CRASH2
  {SPR_IMPX,   10,   7, AI_NULL,            S_IMP_CRASH4    },  // S_IMP_CRASH3
  {SPR_IMPX,   11,  -1, AI_NULL,            S_NULL          },  // S_IMP_CRASH4
  {SPR_IMPX,   23,   7, AI_NULL,            S_IMP_XCRASH2   },  // S_IMP_XCRASH1
  {SPR_IMPX,   24,   7, AI_NULL,            S_IMP_XCRASH3   },  // S_IMP_XCRASH2
  {SPR_IMPX,   25,  -1, AI_NULL,            S_NULL          },  // S_IMP_XCRASH3
  {SPR_IMPX,   12,   5, AI_NULL,            S_IMP_CHUNKA2   },  // S_IMP_CHUNKA1
  {SPR_IMPX,   13, 700, AI_NULL,            S_IMP_CHUNKA3   },  // S_IMP_CHUNKA2
  {SPR_IMPX,   14, 700, AI_NULL,            S_NULL          },  // S_IMP_CHUNKA3
  {SPR_IMPX,   15,   5, AI_NULL,            S_IMP_CHUNKB2   },  // S_IMP_CHUNKB1
  {SPR_IMPX,   16, 700, AI_NULL,            S_IMP_CHUNKB3   },  // S_IMP_CHUNKB2
  {SPR_IMPX,   17, 700, AI_NULL,            S_NULL          },  // S_IMP_CHUNKB3
  {SPR_FX10,FFB|0,   6, AI_NULL,            S_IMPFX2        },  // S_IMPFX1
  {SPR_FX10,FFB|1,   6, AI_NULL,            S_IMPFX3        },  // S_IMPFX2
  {SPR_FX10,FFB|2,   6, AI_NULL,            S_IMPFX1        },  // S_IMPFX3
  {SPR_FX10,FFB|3,   5, AI_NULL,            S_IMPFXI2       },  // S_IMPFXI1
  {SPR_FX10,FFB|4,   5, AI_NULL,            S_IMPFXI3       },  // S_IMPFXI2
  {SPR_FX10,FFB|5,   5, AI_NULL,            S_IMPFXI4       },  // S_IMPFXI3
  {SPR_FX10,FFB|6,   5, AI_NULL,            S_NULL          },  // S_IMPFXI4
  {SPR_KNIG,    0,  10, AI_Look,            S_KNIGHT_STND2  },  // S_KNIGHT_STND1
  {SPR_KNIG,    1,  10, AI_Look,            S_KNIGHT_STND1  },  // S_KNIGHT_STND2
  {SPR_KNIG,    0,   4, AI_Chase,           S_KNIGHT_WALK2  },  // S_KNIGHT_WALK1
  {SPR_KNIG,    1,   4, AI_Chase,           S_KNIGHT_WALK3  },  // S_KNIGHT_WALK2
  {SPR_KNIG,    2,   4, AI_Chase,           S_KNIGHT_WALK4  },  // S_KNIGHT_WALK3
  {SPR_KNIG,    3,   4, AI_Chase,           S_KNIGHT_WALK1  },  // S_KNIGHT_WALK4
  {SPR_KNIG,    4,  10, AI_FaceTarget,      S_KNIGHT_ATK2   },  // S_KNIGHT_ATK1
  {SPR_KNIG,    5,   8, AI_FaceTarget,      S_KNIGHT_ATK3   },  // S_KNIGHT_ATK2
  {SPR_KNIG,    6,   8, AI_KnightAttack,    S_KNIGHT_ATK4   },  // S_KNIGHT_ATK3
  {SPR_KNIG,    4,  10, AI_FaceTarget,      S_KNIGHT_ATK5   },  // S_KNIGHT_ATK4
  {SPR_KNIG,    5,   8, AI_FaceTarget,      S_KNIGHT_ATK6   },  // S_KNIGHT_ATK5
  {SPR_KNIG,    6,   8, AI_KnightAttack,    S_KNIGHT_WALK1  },  // S_KNIGHT_ATK6
  {SPR_KNIG,    7,   3, AI_NULL,            S_KNIGHT_PAIN2  },  // S_KNIGHT_PAIN1
  {SPR_KNIG,    7,   3, AI_Pain,            S_KNIGHT_WALK1  },  // S_KNIGHT_PAIN2
  {SPR_KNIG,    8,   6, AI_NULL,            S_KNIGHT_DIE2   },  // S_KNIGHT_DIE1
  {SPR_KNIG,    9,   6, AI_HScream,         S_KNIGHT_DIE3   },  // S_KNIGHT_DIE2
  {SPR_KNIG,   10,   6, AI_NULL,            S_KNIGHT_DIE4   },  // S_KNIGHT_DIE3
  {SPR_KNIG,   11,   6, AI_NoBlocking,      S_KNIGHT_DIE5   },  // S_KNIGHT_DIE4
  {SPR_KNIG,   12,   6, AI_NULL,            S_KNIGHT_DIE6   },  // S_KNIGHT_DIE5
  {SPR_KNIG,   13,   6, AI_NULL,            S_KNIGHT_DIE7   },  // S_KNIGHT_DIE6
  {SPR_KNIG,   14,  -1, AI_NULL,            S_NULL          },  // S_KNIGHT_DIE7
  {SPR_SPAX,FFB|0,   3, AI_ContMobjSound,   S_SPINAXE2      },  // S_SPINAXE1
  {SPR_SPAX,FFB|1,   3, AI_NULL,            S_SPINAXE3      },  // S_SPINAXE2
  {SPR_SPAX,FFB|2,   3, AI_NULL,            S_SPINAXE1      },  // S_SPINAXE3
  {SPR_SPAX,FFB|3,   6, AI_NULL,            S_SPINAXEX2     },  // S_SPINAXEX1
  {SPR_SPAX,FFB|4,   6, AI_NULL,            S_SPINAXEX3     },  // S_SPINAXEX2
  {SPR_SPAX,FFB|5,   6, AI_NULL,            S_NULL          },  // S_SPINAXEX3
  {SPR_RAXE,FFB|0,   5, AI_DripBlood,       S_REDAXE2       },  // S_REDAXE1
  {SPR_RAXE,FFB|1,   5, AI_DripBlood,       S_REDAXE1       },  // S_REDAXE2
  {SPR_RAXE,FFB|2,   6, AI_NULL,            S_REDAXEX2      },  // S_REDAXEX1
  {SPR_RAXE,FFB|3,   6, AI_NULL,            S_REDAXEX3      },  // S_REDAXEX2
  {SPR_RAXE,FFB|4,   6, AI_NULL,            S_NULL          },  // S_REDAXEX3
  {SPR_SRCR,    0,  10, AI_Look,            S_SRCR1_LOOK2   },  // S_SRCR1_LOOK1
  {SPR_SRCR,    1,  10, AI_Look,            S_SRCR1_LOOK1   },  // S_SRCR1_LOOK2
  {SPR_SRCR,    0,   5, AI_Sor1Chase,       S_SRCR1_WALK2   },  // S_SRCR1_WALK1
  {SPR_SRCR,    1,   5, AI_Sor1Chase,       S_SRCR1_WALK3   },  // S_SRCR1_WALK2
  {SPR_SRCR,    2,   5, AI_Sor1Chase,       S_SRCR1_WALK4   },  // S_SRCR1_WALK3
  {SPR_SRCR,    3,   5, AI_Sor1Chase,       S_SRCR1_WALK1   },  // S_SRCR1_WALK4
  {SPR_SRCR,   16,   6, AI_Sor1Pain,        S_SRCR1_WALK1   },  // S_SRCR1_PAIN1
  {SPR_SRCR,   16,   7, AI_FaceTarget,      S_SRCR1_ATK2    },  // S_SRCR1_ATK1
  {SPR_SRCR,   17,   6, AI_FaceTarget,      S_SRCR1_ATK3    },  // S_SRCR1_ATK2
  {SPR_SRCR,   18,  10, AI_Srcr1Attack,     S_SRCR1_WALK1   },  // S_SRCR1_ATK3
  {SPR_SRCR,   18,  10, AI_FaceTarget,      S_SRCR1_ATK5    },  // S_SRCR1_ATK4
  {SPR_SRCR,   16,   7, AI_FaceTarget,      S_SRCR1_ATK6    },  // S_SRCR1_ATK5
  {SPR_SRCR,   17,   6, AI_FaceTarget,      S_SRCR1_ATK7    },  // S_SRCR1_ATK6
  {SPR_SRCR,   18,  10, AI_Srcr1Attack,     S_SRCR1_WALK1   },  // S_SRCR1_ATK7
  {SPR_SRCR,    4,   7, AI_NULL,            S_SRCR1_DIE2    },  // S_SRCR1_DIE1
  {SPR_SRCR,    5,   7, AI_HScream,         S_SRCR1_DIE3    },  // S_SRCR1_DIE2
  {SPR_SRCR,    6,   7, AI_NULL,            S_SRCR1_DIE4    },  // S_SRCR1_DIE3
  {SPR_SRCR,    7,   6, AI_NULL,            S_SRCR1_DIE5    },  // S_SRCR1_DIE4
  {SPR_SRCR,    8,   6, AI_NULL,            S_SRCR1_DIE6    },  // S_SRCR1_DIE5
  {SPR_SRCR,    9,   6, AI_NULL,            S_SRCR1_DIE7    },  // S_SRCR1_DIE6
  {SPR_SRCR,   10,   6, AI_NULL,            S_SRCR1_DIE8    },  // S_SRCR1_DIE7
  {SPR_SRCR,   11,  25, AI_SorZap,          S_SRCR1_DIE9    },  // S_SRCR1_DIE8
  {SPR_SRCR,   12,   5, AI_NULL,            S_SRCR1_DIE10   },  // S_SRCR1_DIE9
  {SPR_SRCR,   13,   5, AI_NULL,            S_SRCR1_DIE11   },  // S_SRCR1_DIE10
  {SPR_SRCR,   14,   4, AI_NULL,            S_SRCR1_DIE12   },  // S_SRCR1_DIE11
  {SPR_SRCR,   11,  20, AI_SorZap,          S_SRCR1_DIE13   },  // S_SRCR1_DIE12
  {SPR_SRCR,   12,   5, AI_NULL,            S_SRCR1_DIE14   },  // S_SRCR1_DIE13
  {SPR_SRCR,   13,   5, AI_NULL,            S_SRCR1_DIE15   },  // S_SRCR1_DIE14
  {SPR_SRCR,   14,   4, AI_NULL,            S_SRCR1_DIE16   },  // S_SRCR1_DIE15
  {SPR_SRCR,   11,  12, AI_NULL,            S_SRCR1_DIE17   },  // S_SRCR1_DIE16
  {SPR_SRCR,   15,  -1, AI_SorcererRise,    S_NULL          },  // S_SRCR1_DIE17
// Things, functions are acp1 (mobj)
  {SPR_FX14,FFB|0,   6, AI_NULL,            S_SRCRFX1_2     },  // S_SRCRFX1_1
  {SPR_FX14,FFB|1,   6, AI_NULL,            S_SRCRFX1_3     },  // S_SRCRFX1_2
  {SPR_FX14,FFB|2,   6, AI_NULL,            S_SRCRFX1_1     },  // S_SRCRFX1_3
  {SPR_FX14,FFB|3,   5, AI_NULL,            S_SRCRFXI1_2    },  // S_SRCRFXI1_1
  {SPR_FX14,FFB|4,   5, AI_NULL,            S_SRCRFXI1_3    },  // S_SRCRFXI1_2
  {SPR_FX14,FFB|5,   5, AI_NULL,            S_SRCRFXI1_4    },  // S_SRCRFXI1_3
  {SPR_FX14,FFB|6,   5, AI_NULL,            S_SRCRFXI1_5    },  // S_SRCRFXI1_4
  {SPR_FX14,FFB|7,   5, AI_NULL,            S_NULL          },  // S_SRCRFXI1_5
  {SPR_SOR2,    0,   4, AI_NULL,            S_SOR2_RISE2    },  // S_SOR2_RISE1
  {SPR_SOR2,    1,   4, AI_NULL,            S_SOR2_RISE3    },  // S_SOR2_RISE2
  {SPR_SOR2,    2,   4, AI_SorRise,         S_SOR2_RISE4    },  // S_SOR2_RISE3
  {SPR_SOR2,    3,   4, AI_NULL,            S_SOR2_RISE5    },  // S_SOR2_RISE4
  {SPR_SOR2,    4,   4, AI_NULL,            S_SOR2_RISE6    },  // S_SOR2_RISE5
  {SPR_SOR2,    5,   4, AI_NULL,            S_SOR2_RISE7    },  // S_SOR2_RISE6
  {SPR_SOR2,    6,  12, AI_SorSightSnd,     S_SOR2_WALK1    },  // S_SOR2_RISE7
  {SPR_SOR2,   12,  10, AI_Look,            S_SOR2_LOOK2    },  // S_SOR2_LOOK1
  {SPR_SOR2,   13,  10, AI_Look,            S_SOR2_LOOK1    },  // S_SOR2_LOOK2
  {SPR_SOR2,   12,   4, AI_Chase,           S_SOR2_WALK2    },  // S_SOR2_WALK1
  {SPR_SOR2,   13,   4, AI_Chase,           S_SOR2_WALK3    },  // S_SOR2_WALK2
  {SPR_SOR2,   14,   4, AI_Chase,           S_SOR2_WALK4    },  // S_SOR2_WALK3
  {SPR_SOR2,   15,   4, AI_Chase,           S_SOR2_WALK1    },  // S_SOR2_WALK4
  {SPR_SOR2,   16,   3, AI_NULL,            S_SOR2_PAIN2    },  // S_SOR2_PAIN1
  {SPR_SOR2,   16,   6, AI_Pain,            S_SOR2_WALK1    },  // S_SOR2_PAIN2
  {SPR_SOR2,   17,   9, AI_Srcr2Decide,     S_SOR2_ATK2     },  // S_SOR2_ATK1
  {SPR_SOR2,   18,   9, AI_FaceTarget,      S_SOR2_ATK3     },  // S_SOR2_ATK2
  {SPR_SOR2,   19,  20, AI_Srcr2Attack,     S_SOR2_WALK1    },  // S_SOR2_ATK3
  {SPR_SOR2,   11,   6, AI_NULL,            S_SOR2_TELE2    },  // S_SOR2_TELE1
  {SPR_SOR2,   10,   6, AI_NULL,            S_SOR2_TELE3    },  // S_SOR2_TELE2
  {SPR_SOR2,    9,   6, AI_NULL,            S_SOR2_TELE4    },  // S_SOR2_TELE3
  {SPR_SOR2,    8,   6, AI_NULL,            S_SOR2_TELE5    },  // S_SOR2_TELE4
  {SPR_SOR2,    7,   6, AI_NULL,            S_SOR2_TELE6    },  // S_SOR2_TELE5
  {SPR_SOR2,    6,   6, AI_NULL,            S_SOR2_WALK1    },  // S_SOR2_TELE6
  {SPR_SDTH,    0,   8, AI_Sor2DthInit,     S_SOR2_DIE2     },  // S_SOR2_DIE1
  {SPR_SDTH,    1,   8, AI_NULL,            S_SOR2_DIE3     },  // S_SOR2_DIE2
  {SPR_SDTH,    2,   8, AI_SorDSph,         S_SOR2_DIE4     },  // S_SOR2_DIE3
  {SPR_SDTH,    3,   7, AI_NULL,            S_SOR2_DIE5     },  // S_SOR2_DIE4
  {SPR_SDTH,    4,   7, AI_NULL,            S_SOR2_DIE6     },  // S_SOR2_DIE5
  {SPR_SDTH,    5,   7, AI_Sor2DthLoop,     S_SOR2_DIE7     },  // S_SOR2_DIE6
  {SPR_SDTH,    6,   6, AI_SorDExp,         S_SOR2_DIE8     },  // S_SOR2_DIE7
  {SPR_SDTH,    7,   6, AI_NULL,            S_SOR2_DIE9     },  // S_SOR2_DIE8
  {SPR_SDTH,    8,  18, AI_NULL,            S_SOR2_DIE10    },  // S_SOR2_DIE9
  {SPR_SDTH,    9,   6, AI_NoBlocking,      S_SOR2_DIE11    },  // S_SOR2_DIE10
  {SPR_SDTH,   10,   6, AI_SorDBon,         S_SOR2_DIE12    },  // S_SOR2_DIE11
  {SPR_SDTH,   11,   6, AI_NULL,            S_SOR2_DIE13    },  // S_SOR2_DIE12
  {SPR_SDTH,   12,   6, AI_NULL,            S_SOR2_DIE14    },  // S_SOR2_DIE13
  {SPR_SDTH,   13,   6, AI_NULL,            S_SOR2_DIE15    },  // S_SOR2_DIE14
  {SPR_SDTH,   14,  -1, AI_HBossDeath,      S_NULL          },  // S_SOR2_DIE15
// Things, functions are acp1 (mobj)
  {SPR_FX16,FFB|0,   3, AI_BlueSpark,       S_SOR2FX1_2     },  // S_SOR2FX1_1
  {SPR_FX16,FFB|1,   3, AI_BlueSpark,       S_SOR2FX1_3     },  // S_SOR2FX1_2
  {SPR_FX16,FFB|2,   3, AI_BlueSpark,       S_SOR2FX1_1     },  // S_SOR2FX1_3
  {SPR_FX16,FFB|6,   5, AI_Explode,         S_SOR2FXI1_2    },  // S_SOR2FXI1_1
  {SPR_FX16,FFB|7,   5, AI_NULL,            S_SOR2FXI1_3    },  // S_SOR2FXI1_2
  {SPR_FX16,FFB|8,   5, AI_NULL,            S_SOR2FXI1_4    },  // S_SOR2FXI1_3
  {SPR_FX16,FFB|9,   5, AI_NULL,            S_SOR2FXI1_5    },  // S_SOR2FXI1_4
  {SPR_FX16,FFB|10,  5, AI_NULL,            S_SOR2FXI1_6    },  // S_SOR2FXI1_5
  {SPR_FX16,FFB|11,  5, AI_NULL,            S_NULL          },  // S_SOR2FXI1_6
  {SPR_FX16,FFB|3,  12, AI_NULL,            S_SOR2FXSPARK2  },  // S_SOR2FXSPARK1
  {SPR_FX16,FFB|4,  12, AI_NULL,            S_SOR2FXSPARK3  },  // S_SOR2FXSPARK2
  {SPR_FX16,FFB|5,  12, AI_NULL,            S_NULL          },  // S_SOR2FXSPARK3
  {SPR_FX11,FFB|0,  35, AI_NULL,            S_SOR2FX2_2     },  // S_SOR2FX2_1
  {SPR_FX11,FFB|0,   5, AI_GenWizard,       S_SOR2FX2_3     },  // S_SOR2FX2_2
  {SPR_FX11,FFB|1,   5, AI_NULL,            S_SOR2FX2_2     },  // S_SOR2FX2_3
  {SPR_FX11,FFB|2,   5, AI_NULL,            S_SOR2FXI2_2    },  // S_SOR2FXI2_1
  {SPR_FX11,FFB|3,   5, AI_NULL,            S_SOR2FXI2_3    },  // S_SOR2FXI2_2
  {SPR_FX11,FFB|4,   5, AI_NULL,            S_SOR2FXI2_4    },  // S_SOR2FXI2_3
  {SPR_FX11,FFB|5,   5, AI_NULL,            S_SOR2FXI2_5    },  // S_SOR2FXI2_4
  {SPR_FX11,FFB|6,   5, AI_NULL,            S_NULL          },  // S_SOR2FXI2_5
  {SPR_SOR2,    6,   8, AI_NULL,            S_SOR2TELEFADE2 },  // S_SOR2TELEFADE1
  {SPR_SOR2,    7,   6, AI_NULL,            S_SOR2TELEFADE3 },  // S_SOR2TELEFADE2
  {SPR_SOR2,    8,   6, AI_NULL,            S_SOR2TELEFADE4 },  // S_SOR2TELEFADE3
  {SPR_SOR2,    9,   6, AI_NULL,            S_SOR2TELEFADE5 },  // S_SOR2TELEFADE4
  {SPR_SOR2,   10,   6, AI_NULL,            S_SOR2TELEFADE6 },  // S_SOR2TELEFADE5
  {SPR_SOR2,   11,   6, AI_NULL,            S_NULL          },  // S_SOR2TELEFADE6
// Things, functions are acp1 (mobj)
  {SPR_MNTR,    0,  10, AI_Look,            S_MNTR_LOOK2    },  // S_MNTR_LOOK1
  {SPR_MNTR,    1,  10, AI_Look,            S_MNTR_LOOK1    },  // S_MNTR_LOOK2
  {SPR_MNTR,    0,   5, AI_Chase,           S_MNTR_WALK2    },  // S_MNTR_WALK1
  {SPR_MNTR,    1,   5, AI_Chase,           S_MNTR_WALK3    },  // S_MNTR_WALK2
  {SPR_MNTR,    2,   5, AI_Chase,           S_MNTR_WALK4    },  // S_MNTR_WALK3
  {SPR_MNTR,    3,   5, AI_Chase,           S_MNTR_WALK1    },  // S_MNTR_WALK4
  {SPR_MNTR,   21,  10, AI_FaceTarget,      S_MNTR_ATK1_2   },  // S_MNTR_ATK1_1
  {SPR_MNTR,   22,   7, AI_FaceTarget,      S_MNTR_ATK1_3   },  // S_MNTR_ATK1_2
  {SPR_MNTR,   23,  12, AI_MinotaurAtk1,    S_MNTR_WALK1    },  // S_MNTR_ATK1_3
  {SPR_MNTR,   21,  10, AI_MinotaurDecide,  S_MNTR_ATK2_2   },  // S_MNTR_ATK2_1
  {SPR_MNTR,   24,   4, AI_FaceTarget,      S_MNTR_ATK2_3   },  // S_MNTR_ATK2_2
  {SPR_MNTR,   25,   9, AI_MinotaurAtk2,    S_MNTR_WALK1    },  // S_MNTR_ATK2_3
  {SPR_MNTR,   21,  10, AI_FaceTarget,      S_MNTR_ATK3_2   },  // S_MNTR_ATK3_1
  {SPR_MNTR,   22,   7, AI_FaceTarget,      S_MNTR_ATK3_3   },  // S_MNTR_ATK3_2
  {SPR_MNTR,   23,  12, AI_MinotaurAtk3,    S_MNTR_WALK1    },  // S_MNTR_ATK3_3
  {SPR_MNTR,   23,  12, AI_NULL,            S_MNTR_ATK3_1   },  // S_MNTR_ATK3_4
  {SPR_MNTR,   20,   2, AI_MinotaurCharge,  S_MNTR_ATK4_1   },  // S_MNTR_ATK4_1
  {SPR_MNTR,    4,   3, AI_NULL,            S_MNTR_PAIN2    },  // S_MNTR_PAIN1
  {SPR_MNTR,    4,   6, AI_Pain,            S_MNTR_WALK1    },  // S_MNTR_PAIN2
  {SPR_MNTR,    5,   6, AI_NULL,            S_MNTR_DIE2     },  // S_MNTR_DIE1
  {SPR_MNTR,    6,   5, AI_NULL,            S_MNTR_DIE3     },  // S_MNTR_DIE2
  {SPR_MNTR,    7,   6, AI_HScream,         S_MNTR_DIE4     },  // S_MNTR_DIE3
  {SPR_MNTR,    8,   5, AI_NULL,            S_MNTR_DIE5     },  // S_MNTR_DIE4
  {SPR_MNTR,    9,   6, AI_NULL,            S_MNTR_DIE6     },  // S_MNTR_DIE5
  {SPR_MNTR,   10,   5, AI_NULL,            S_MNTR_DIE7     },  // S_MNTR_DIE6
  {SPR_MNTR,   11,   6, AI_NULL,            S_MNTR_DIE8     },  // S_MNTR_DIE7
  {SPR_MNTR,   12,   5, AI_NoBlocking,      S_MNTR_DIE9     },  // S_MNTR_DIE8
  {SPR_MNTR,   13,   6, AI_NULL,            S_MNTR_DIE10    },  // S_MNTR_DIE9
  {SPR_MNTR,   14,   5, AI_NULL,            S_MNTR_DIE11    },  // S_MNTR_DIE10
  {SPR_MNTR,   15,   6, AI_NULL,            S_MNTR_DIE12    },  // S_MNTR_DIE11
  {SPR_MNTR,   16,   5, AI_NULL,            S_MNTR_DIE13    },  // S_MNTR_DIE12
  {SPR_MNTR,   17,   6, AI_NULL,            S_MNTR_DIE14    },  // S_MNTR_DIE13
  {SPR_MNTR,   18,   5, AI_NULL,            S_MNTR_DIE15    },  // S_MNTR_DIE14
  {SPR_MNTR,   19,  -1, AI_HBossDeath,      S_NULL          },  // S_MNTR_DIE15
  {SPR_FX12,FFB|0,   6, AI_NULL,            S_MNTRFX1_2     },  // S_MNTRFX1_1
  {SPR_FX12,FFB|1,   6, AI_NULL,            S_MNTRFX1_1     },  // S_MNTRFX1_2
  {SPR_FX12,FFB|2,   5, AI_NULL,            S_MNTRFXI1_2    },  // S_MNTRFXI1_1
  {SPR_FX12,FFB|3,   5, AI_NULL,            S_MNTRFXI1_3    },  // S_MNTRFXI1_2
  {SPR_FX12,FFB|4,   5, AI_NULL,            S_MNTRFXI1_4    },  // S_MNTRFXI1_3
  {SPR_FX12,FFB|5,   5, AI_NULL,            S_MNTRFXI1_5    },  // S_MNTRFXI1_4
  {SPR_FX12,FFB|6,   5, AI_NULL,            S_MNTRFXI1_6    },  // S_MNTRFXI1_5
  {SPR_FX12,FFB|7,   5, AI_NULL,            S_NULL          },  // S_MNTRFXI1_6
  {SPR_FX13,    0,   2, AI_MntrFloorFire,   S_MNTRFX2_1     },  // S_MNTRFX2_1
  {SPR_FX13,FFB|8,   4, AI_Explode,         S_MNTRFXI2_2    },  // S_MNTRFXI2_1
  {SPR_FX13,FFB|9,   4, AI_NULL,            S_MNTRFXI2_3    },  // S_MNTRFXI2_2
  {SPR_FX13,FFB|10,  4, AI_NULL,            S_MNTRFXI2_4    },  // S_MNTRFXI2_3
  {SPR_FX13,FFB|11,  4, AI_NULL,            S_MNTRFXI2_5    },  // S_MNTRFXI2_4
  {SPR_FX13,FFB|12,  4, AI_NULL,            S_NULL          },  // S_MNTRFXI2_5
  {SPR_FX13,FFB|3,   4, AI_NULL,            S_MNTRFX3_2     },  // S_MNTRFX3_1
  {SPR_FX13,FFB|2,   4, AI_NULL,            S_MNTRFX3_3     },  // S_MNTRFX3_2
  {SPR_FX13,FFB|1,   5, AI_NULL,            S_MNTRFX3_4     },  // S_MNTRFX3_3
  {SPR_FX13,FFB|2,   5, AI_NULL,            S_MNTRFX3_5     },  // S_MNTRFX3_4
  {SPR_FX13,FFB|3,   5, AI_NULL,            S_MNTRFX3_6     },  // S_MNTRFX3_5
  {SPR_FX13,FFB|4,   5, AI_NULL,            S_MNTRFX3_7     },  // S_MNTRFX3_6
  {SPR_FX13,FFB|5,   4, AI_NULL,            S_MNTRFX3_8     },  // S_MNTRFX3_7
  {SPR_FX13,FFB|6,   4, AI_NULL,            S_MNTRFX3_9     },  // S_MNTRFX3_8
  {SPR_FX13,FFB|7,   4, AI_NULL,            S_NULL          },  // S_MNTRFX3_9
  {SPR_AKYY,FFB|0,   3, AI_NULL,            S_AKYY2         },  // S_AKYY1
  {SPR_AKYY,FFB|1,   3, AI_NULL,            S_AKYY3         },  // S_AKYY2
  {SPR_AKYY,FFB|2,   3, AI_NULL,            S_AKYY4         },  // S_AKYY3
  {SPR_AKYY,FFB|3,   3, AI_NULL,            S_AKYY5         },  // S_AKYY4
  {SPR_AKYY,FFB|4,   3, AI_NULL,            S_AKYY6         },  // S_AKYY5
  {SPR_AKYY,FFB|5,   3, AI_NULL,            S_AKYY7         },  // S_AKYY6
  {SPR_AKYY,FFB|6,   3, AI_NULL,            S_AKYY8         },  // S_AKYY7
  {SPR_AKYY,FFB|7,   3, AI_NULL,            S_AKYY9         },  // S_AKYY8
  {SPR_AKYY,FFB|8,   3, AI_NULL,            S_AKYY10        },  // S_AKYY9
  {SPR_AKYY,FFB|9,   3, AI_NULL,            S_AKYY1         },  // S_AKYY10
  {SPR_BKYY,FFB|0,   3, AI_NULL,            S_BKYY2         },  // S_BKYY1
  {SPR_BKYY,FFB|1,   3, AI_NULL,            S_BKYY3         },  // S_BKYY2
  {SPR_BKYY,FFB|2,   3, AI_NULL,            S_BKYY4         },  // S_BKYY3
  {SPR_BKYY,FFB|3,   3, AI_NULL,            S_BKYY5         },  // S_BKYY4
  {SPR_BKYY,FFB|4,   3, AI_NULL,            S_BKYY6         },  // S_BKYY5
  {SPR_BKYY,FFB|5,   3, AI_NULL,            S_BKYY7         },  // S_BKYY6
  {SPR_BKYY,FFB|6,   3, AI_NULL,            S_BKYY8         },  // S_BKYY7
  {SPR_BKYY,FFB|7,   3, AI_NULL,            S_BKYY9         },  // S_BKYY8
  {SPR_BKYY,FFB|8,   3, AI_NULL,            S_BKYY10        },  // S_BKYY9
  {SPR_BKYY,FFB|9,   3, AI_NULL,            S_BKYY1         },  // S_BKYY10
  {SPR_CKYY,FFB|0,   3, AI_NULL,            S_CKYY2         },  // S_CKYY1
  {SPR_CKYY,FFB|1,   3, AI_NULL,            S_CKYY3         },  // S_CKYY2
  {SPR_CKYY,FFB|2,   3, AI_NULL,            S_CKYY4         },  // S_CKYY3
  {SPR_CKYY,FFB|3,   3, AI_NULL,            S_CKYY5         },  // S_CKYY4
  {SPR_CKYY,FFB|4,   3, AI_NULL,            S_CKYY6         },  // S_CKYY5
  {SPR_CKYY,FFB|5,   3, AI_NULL,            S_CKYY7         },  // S_CKYY6
  {SPR_CKYY,FFB|6,   3, AI_NULL,            S_CKYY8         },  // S_CKYY7
  {SPR_CKYY,FFB|7,   3, AI_NULL,            S_CKYY9         },  // S_CKYY8
  {SPR_CKYY,FFB|8,   3, AI_NULL,            S_CKYY1         },  // S_CKYY9
  {SPR_AMG1,    0,  -1, AI_NULL,            S_NULL          },  // S_AMG1
  {SPR_AMG2,    0,   4, AI_NULL,            S_AMG2_2        },  // S_AMG2_1
  {SPR_AMG2,    1,   4, AI_NULL,            S_AMG2_3        },  // S_AMG2_2
  {SPR_AMG2,    2,   4, AI_NULL,            S_AMG2_1        },  // S_AMG2_3
  {SPR_AMM1,    0,  -1, AI_NULL,            S_NULL          },  // S_AMM1
  {SPR_AMM2,    0,  -1, AI_NULL,            S_NULL          },  // S_AMM2
  {SPR_AMC1,    0,  -1, AI_NULL,            S_NULL          },  // S_AMC1
  {SPR_AMC2,    0,   5, AI_NULL,            S_AMC2_2        },  // S_AMC2_1
  {SPR_AMC2,    1,   5, AI_NULL,            S_AMC2_3        },  // S_AMC2_2
  {SPR_AMC2,    2,   5, AI_NULL,            S_AMC2_1        },  // S_AMC2_3
  {SPR_AMS1,    0,   5, AI_NULL,            S_AMS1_2        },  // S_AMS1_1
  {SPR_AMS1,    1,   5, AI_NULL,            S_AMS1_1        },  // S_AMS1_2
  {SPR_AMS2,    0,   5, AI_NULL,            S_AMS2_2        },  // S_AMS2_1
  {SPR_AMS2,    1,   5, AI_NULL,            S_AMS2_1        },  // S_AMS2_2
  {SPR_AMP1,    0,   4, AI_NULL,            S_AMP1_2        },  // S_AMP1_1
  {SPR_AMP1,    1,   4, AI_NULL,            S_AMP1_3        },  // S_AMP1_2
  {SPR_AMP1,    2,   4, AI_NULL,            S_AMP1_1        },  // S_AMP1_3
  {SPR_AMP2,    0,   4, AI_NULL,            S_AMP2_2        },  // S_AMP2_1
  {SPR_AMP2,    1,   4, AI_NULL,            S_AMP2_3        },  // S_AMP2_2
  {SPR_AMP2,    2,   4, AI_NULL,            S_AMP2_1        },  // S_AMP2_3
  {SPR_AMB1,    0,   4, AI_NULL,            S_AMB1_2        },  // S_AMB1_1
  {SPR_AMB1,    1,   4, AI_NULL,            S_AMB1_3        },  // S_AMB1_2
  {SPR_AMB1,    2,   4, AI_NULL,            S_AMB1_1        },  // S_AMB1_3
  {SPR_AMB2,    0,   4, AI_NULL,            S_AMB2_2        },  // S_AMB2_1
  {SPR_AMB2,    1,   4, AI_NULL,            S_AMB2_3        },  // S_AMB2_2
  {SPR_AMB2,    2,   4, AI_NULL,            S_AMB2_1        },  // S_AMB2_3
  {SPR_AMG1,    0, 100, AI_ESound,          S_SND_WIND      },  // S_SND_WIND
  {SPR_AMG1,    0,  85, AI_ESound,          S_SND_WATERFALL },  // S_SND_WATERFALL

// Fragglescript
  {SPR_TROO,FFB|0,  4,  AI_StartFS,         S_DUMMY         },  // S_DUMMY
// use an acp2 sprite due to error detection
//  {SPR_TROO,FFB|0,  4,  AP_StartWeaponFS,   S_DUMMY2        },  // S_DUMMY2
  {SPR_PUNG,FFB|0,  4,  AP_StartWeaponFS,   S_DUMMY2        },  // S_DUMMY2,

   
// MBF
    // killough 8/9/98: grenade
  {SPR_MISL,FFB|0, 1000, AI_Die_MBF,  S_GRENADE},   // S_GRENADE

    // killough 8/10/98: variable damage explosion
  {SPR_MISL,FFB|1,    4, AI_Scream,   S_DETONATE2}, // S_DETONATE
  {SPR_MISL,FFB|2,    6, AI_Detonate_MBF, S_DETONATE3}, // S_DETONATE2
  {SPR_MISL,FFB|3,   10, AI_NULL,     S_NULL},      // S_DETONATE3

#ifdef DOGS
    // killough 7/19/98: Marine's best friend :)
// Things, functions are acp1 (mobj)
  {SPR_DOGS, 0, 10, AI_Look,    S_DOGS_STND2},  // S_DOGS_STND
  {SPR_DOGS, 1, 10, AI_Look,    S_DOGS_STND}, // S_DOGS_STND2
  {SPR_DOGS, 0,  2, AI_Chase,   S_DOGS_RUN2}, // S_DOGS_RUN1
  {SPR_DOGS, 0,  2, AI_Chase,   S_DOGS_RUN3}, // S_DOGS_RUN2
  {SPR_DOGS, 1,  2, AI_Chase,   S_DOGS_RUN4}, // S_DOGS_RUN3
  {SPR_DOGS, 1,  2, AI_Chase,   S_DOGS_RUN5}, // S_DOGS_RUN4
  {SPR_DOGS, 2,  2, AI_Chase,   S_DOGS_RUN6}, // S_DOGS_RUN5
  {SPR_DOGS, 2,  2, AI_Chase,   S_DOGS_RUN7}, // S_DOGS_RUN6
  {SPR_DOGS, 3,  2, AI_Chase,   S_DOGS_RUN8}, // S_DOGS_RUN7
  {SPR_DOGS, 3,  2, AI_Chase,   S_DOGS_RUN1}, // S_DOGS_RUN8
  {SPR_DOGS, 4,  8, AI_FaceTarget, S_DOGS_ATK2},  // S_DOGS_ATK1
  {SPR_DOGS, 5,  8, AI_FaceTarget, S_DOGS_ATK3},  // S_DOGS_ATK2
  {SPR_DOGS, 6,  8, AI_SargAttack, S_DOGS_RUN1},  // S_DOGS_ATK3
  {SPR_DOGS, 7,  2, AI_NULL,  S_DOGS_PAIN2}, // S_DOGS_PAIN
  {SPR_DOGS, 7,  2, AI_Pain,    S_DOGS_RUN1}, // S_DOGS_PAIN2
  {SPR_DOGS, 8,  8, AI_NULL,  S_DOGS_DIE2}, // S_DOGS_DIE1
  {SPR_DOGS, 9,  8, AI_Scream,  S_DOGS_DIE3}, // S_DOGS_DIE2
  {SPR_DOGS,10,  4, AI_NULL,  S_DOGS_DIE4}, // S_DOGS_DIE3
  {SPR_DOGS,11,  4, AI_Fall,    S_DOGS_DIE5}, // S_DOGS_DIE4
  {SPR_DOGS,12,  4, AI_NULL,  S_DOGS_DIE6}, // S_DOGS_DIE5
  {SPR_DOGS,13, -1, AI_NULL,  S_NULL},      // S_DOGS_DIE6
  {SPR_DOGS,13,  5, AI_NULL,  S_DOGS_RAISE2}, // S_DOGS_RAISE1
  {SPR_DOGS,12,  5, AI_NULL,  S_DOGS_RAISE3}, // S_DOGS_RAISE2
  {SPR_DOGS,11,  5, AI_NULL,  S_DOGS_RAISE4}, // S_DOGS_RAISE3
  {SPR_DOGS,10,  5, AI_NULL,  S_DOGS_RAISE5}, // S_DOGS_RAISE4
  {SPR_DOGS, 9,  5, AI_NULL,  S_DOGS_RAISE6}, // S_DOGS_RAISE5
  {SPR_DOGS, 8,  5, AI_NULL,  S_DOGS_RUN1},   // S_DOGS_RAISE6
#else
    // if dogs are disabled, dummy states are required for dehacked compatibility
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_STND
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_STND2
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_RUN1
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_RUN2
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_RUN3
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_RUN4
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_RUN5
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_RUN6
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_RUN7
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_RUN8
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_ATK1
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_ATK2
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_ATK3
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_PAIN
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_PAIN2
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_DIE1
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_DIE2
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_DIE3
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_DIE4
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_DIE5
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_DIE6
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_RAISE1
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_RAISE2
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_RAISE3
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_RAISE4
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_RAISE5
    { 0,0,-1,AI_NULL,S_NULL}, // S_DOGS_RAISE6
#endif
    // killough 10/98: mushroom effect
  {SPR_MISL,FFB|1,    8, AI_Mushroom_MBF, S_EXPLODE2},  // S_MUSHROOM

#ifdef ENABLE_VERMIN
  {SPR_TRASH,  0, -1,AI_NULL,         S_NULL        }, // S_TRASH
  {SPR_BOX,    0, -1,AI_NULL,         S_NULL        }, // S_BOX
  {SPR_RAT,    0, 10,AI_Look,         S_RAT_STND    }, // S_RAT_STND
  {SPR_RAT,    0,  6,AI_Flee,         S_RAT_RUN2    }, // S_RAT_RUN1
  {SPR_RAT,    1,  6,AI_Flee,         S_RAT_RUN3    }, // S_RAT_RUN2
  {SPR_RAT,    2,  6,AI_Flee,         S_RAT_RUN4    }, // S_RAT_RUN3
  {SPR_RAT,    3,  6,AI_Flee,         S_RAT_RUN1    }, // S_RAT_RUN4
  {SPR_RAT,    0, 10,AI_FaceTarget,   S_RAT_ATK2    }, // S_RAT_ATK1
  {SPR_RAT,    4,  8,AI_Bite,         S_RAT_RUN1    }, // S_RAT_ATK2
  {SPR_RAT,    5,  5,AI_Flee,         S_RAT_RUN1    }, // S_RAT_PAIN
  {SPR_RAT,    6,  5,AI_NULL,         S_RAT_DIE2    }, // S_RAT_DIE1
  {SPR_RAT,    6,  5,AI_Fall,         S_RAT_DIE3    }, // S_RAT_DIE2
  {SPR_RAT,    6, -1,AI_NULL,         S_NULL        }, // S_RAT_DIE3
  {SPR_RAT,    6,  5,AI_Fall,         S_RAT_XDIE2   }, // S_RAT_XDIE1
  {SPR_RAT,    6, -1,AI_Remove,       S_NULL        }, // S_RAT_XDIE2
  {SPR_VSPI,   0, 10,AI_Look,         S_VSPIDER_STND   }, // S_VSPIDER_STND
  {SPR_VSPI,   0,  6,AI_Flee,         S_VSPIDER_RUN2    }, // S_VSPIDER_RUN1
  {SPR_VSPI,   1,  6,AI_Flee,         S_VSPIDER_RUN3    }, // S_VSPIDER_RUN2
  {SPR_VSPI,   2,  6,AI_Flee,         S_VSPIDER_RUN4    }, // S_VSPIDER_RUN3
  {SPR_VSPI,   3,  6,AI_Flee,         S_VSPIDER_RUN1    }, // S_VSPIDER_RUN4
  {SPR_VSPI,   0, 10,AI_FaceTarget,   S_VSPIDER_ATK2    }, // S_VSPIDER_ATK1
  {SPR_VSPI,   4,  8,AI_Bite,         S_VSPIDER_RUN1    }, // S_VSPIDER_ATK2
  {SPR_VSPI,   5,  5,AI_Flee,         S_VSPIDER_RUN1    }, // S_VSPIDER_PAIN
  {SPR_VSPI,   6,  5,AI_NULL,         S_VSPIDER_DIE2    }, // S_VSPIDER_DIE1
  {SPR_VSPI,   6,  5,AI_Fall,         S_VSPIDER_DIE3    }, // S_VSPIDER_DIE2
  {SPR_VSPI,   6, -1,AI_NULL,         S_NULL        }, // S_VSPIDER_DIE3
  {SPR_VSPI,   6,  5,AI_Fall,         S_VSPIDER_XDIE2   }, // S_VSPIDER_XDIE1
  {SPR_VSPI,   6, -1,AI_Remove,       S_NULL        }, // S_VSPIDER_XDIE2
  {SPR_BAT,    0, 10,AI_Look,         S_BAT_STND    }, // S_BAT_STND
  {SPR_BAT,    1,  2,AI_Flee,         S_BAT_RUN2    }, // S_BAT_RUN1
  {SPR_BAT,    2,  2,AI_Flee,         S_BAT_RUN3    }, // S_BAT_RUN2
  {SPR_BAT,    3,  2,AI_Flee,         S_BAT_RUN4    }, // S_BAT_RUN3
  {SPR_BAT,    4,  2,AI_Look,         S_BAT_RUN1    }, // S_BAT_RUN4
  {SPR_BAT,    0, 10,AI_FaceTarget,   S_BAT_ATK2    }, // S_BAT_ATK1
  {SPR_BAT,    5,  4,AI_Bite,         S_BAT_RUN1    }, // S_BAT_ATK2
  {SPR_BAT,    5,  4,AI_Flee,         S_BAT_ATK1    }, // S_BAT_PAIN
  {SPR_BAT,    6,  4,AI_NULL,         S_BAT_DIE2    }, // S_BAT_DIE1
  {SPR_BAT,    6,  4,AI_Fall,         S_BAT_DIE3    }, // S_BAT_DIE2
  {SPR_BAT,    6, -1,AI_NULL,         S_NULL        }, // S_BAT_DIE3
  {SPR_BAT,    6,  4,AI_Fall,         S_BAT_XDIE2   }, // S_BAT_XDIE1
  {SPR_BAT,    6, -1,AI_Remove,       S_NULL        }, // S_BAT_XDIE2
  {SPR_VERM,    0, 10,AI_Look,        S_VERM_STND   }, // S_VERM_STND
  {SPR_VERM,    0,  6,AI_Flee,        S_VERM_RUN2   }, // S_VERM_RUN1
  {SPR_VERM,    1,  6,AI_Flee,        S_VERM_RUN3   }, // S_VERM_RUN2
  {SPR_VERM,    2,  6,AI_Flee,        S_VERM_RUN4   }, // S_VERM_RUN3
  {SPR_VERM,    3,  6,AI_Flee,        S_VERM_RUN1   }, // S_VERM_RUN4
  {SPR_VERM,    0, 10,AI_FaceTarget,  S_VERM_ATK2   }, // S_VERM_ATK1
  {SPR_VERM,    4,  8,AI_Bite,        S_VERM_RUN1   }, // S_VERM_ATK2
  {SPR_VERM,    5,  5,AI_Flee,        S_VERM_RUN1   }, // S_VERM_PAIN
  {SPR_VERM,    6,  5,AI_NULL,        S_VERM_DIE2   }, // S_VERM_DIE1
  {SPR_VERM,    6,  5,AI_Fall,        S_VERM_DIE3   }, // S_VERM_DIE2
  {SPR_VERM,    6, -1,AI_NULL,        S_NULL        }, // S_VERM_DIE3
  {SPR_VERM,    6,  5,AI_Fall,        S_VERM_XDIE2  }, // S_VERM_XDIE1
  {SPR_VERM,    6, -1,AI_Remove,      S_NULL        }, // S_VERM_XDIE2
#endif
  { 0,0,-1,AI_NULL,S_NULL}, // S_BLANK
};


mobjinfo_t mobjinfo[NUMMOBJTYPES] = {

    {           // MT_PLAYER
        -1,             // doomednum
        S_PLAY,         // spawnstate
        100,            // spawnhealth
        S_PLAY_RUN1,            // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        0,              // reactiontime
        sfx_None,               // attacksound
        S_PLAY_PAIN,            // painstate
        255,            // painchance
        sfx_plpain,             // painsound
        S_NULL,         // meleestate
        S_PLAY_ATK1,            // missilestate
        S_NULL,         // crashstate
        S_PLAY_DIE1,            // deathstate
        S_PLAY_XDIE1,           // xdeathstate
        sfx_pldeth,             // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        56*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID|MF_SHOOTABLE|MF_DROPOFF|MF_PICKUP|MF_NOTDMATCH,    // flags
        MF2_WINDTHRUST | MF2_FOOTCLIP | MF2_SLIDE | MF2_PASSMOBJ | MF2_TELESTOMP,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_POSSESSED
        3004,           // doomednum
        S_POSS_STND,            // spawnstate
        20,             // spawnhealth
        S_POSS_RUN1,            // seestate
        sfx_posit1,             // seesound
        sfx_posact,             // activesound
        8,              // reactiontime
        sfx_pistol,             // attacksound
        S_POSS_PAIN,            // painstate
        200,            // painchance
        sfx_popain,             // painsound
        0,              // meleestate
        S_POSS_ATK1,            // missilestate
        S_NULL,         // crashstate
        S_POSS_DIE1,            // deathstate
        S_POSS_XDIE1,           // xdeathstate
        sfx_podth1,             // deathsound
        S_POSS_RAISE1,  // raisestate
        8,              // speed
        20*FRACUNIT,            // radius
        56*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_SHOTGUY
        9,              // doomednum
        S_SPOS_STND,            // spawnstate
        30,             // spawnhealth
        S_SPOS_RUN1,            // seestate
        sfx_posit2,             // seesound
        sfx_posact,             // activesound
        8,              // reactiontime
        0,              // attacksound
        S_SPOS_PAIN,            // painstate
        170,            // painchance
        sfx_popain,             // painsound
        0,              // meleestate
        S_SPOS_ATK1,            // missilestate
        S_NULL,         // crashstate
        S_SPOS_DIE1,            // deathstate
        S_SPOS_XDIE1,           // xdeathstate
        sfx_podth2,             // deathsound
        S_SPOS_RAISE1,  // raisestate
        8,              // speed
        20*FRACUNIT,            // radius
        56*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_VILE
        64,             // doomednum
        S_VILE_STND,            // spawnstate
        700,            // spawnhealth
        S_VILE_RUN1,            // seestate
        sfx_vilsit,             // seesound
        sfx_vilact,             // activesound
        8,              // reactiontime
        0,              // attacksound
        S_VILE_PAIN,            // painstate
        10,             // painchance
        sfx_vipain,             // painsound
        0,              // meleestate
        S_VILE_ATK1,            // missilestate
        S_NULL,         // crashstate
        S_VILE_DIE1,            // deathstate
        S_NULL,         // xdeathstate
        sfx_vildth,             // deathsound
        S_NULL,         // raisestate
        15,             // speed
        20*FRACUNIT,            // radius
        56*FRACUNIT,            // height
        500,            // mass
        0,              // damage
        MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
# ifdef MBF21
        MF3_DMGIGNORED | MF3_NOTHRESHOLD | MF3_SHORTMRANGE,  // flags3
# else
        0,
# endif
#endif
        0,
    },

    {           // MT_FIRE
        -1,             // doomednum
        S_FIRE1,                // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT,  // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_UNDEAD
        66,             // doomednum
        S_SKEL_STND,            // spawnstate
        300,            // spawnhealth
        S_SKEL_RUN1,            // seestate
        sfx_skesit,             // seesound
        sfx_skeact,             // activesound
        8,              // reactiontime
        0,              // attacksound
        S_SKEL_PAIN,            // painstate
        100,            // painchance
        sfx_popain,             // painsound
        S_SKEL_FIST1,           // meleestate
        S_SKEL_MISS1,           // missilestate
        S_NULL,         // crashstate
        S_SKEL_DIE1,            // deathstate
        S_NULL,         // xdeathstate
        sfx_skedth,             // deathsound
        S_SKEL_RAISE1,  // raisestate
        10,             // speed
        20*FRACUNIT,            // radius
        56*FRACUNIT,            // height
        500,            // mass
        0,              // damage
        MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
# ifdef MBF21
        MF3_LONGMELEE | MF3_RANGEHALF,
# else
        0,
# endif
#endif
        0,
    },

    {           // MT_TRACER
        -1,             // doomednum
        S_TRACER,               // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_skeatk,             // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_TRACEEXP1,            // deathstate
        S_NULL,         // xdeathstate
        sfx_barexp,             // deathsound
        S_NULL,         // raisestate
        10*FRACUNIT,            // speed
        11*FRACUNIT,            // radius
        8*FRACUNIT,             // height
        100,            // mass
        10,             // damage
        MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT,  // flags
           // was not translucent in Boom
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_SMOKE
        -1,             // doomednum
        S_SMOKE1,               // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT,  // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_FATSO
        67,             // doomednum
        S_FATT_STND,            // spawnstate
        600,            // spawnhealth
        S_FATT_RUN1,            // seestate
        sfx_mansit,             // seesound
        sfx_posact,             // activesound
        8,              // reactiontime
        0,              // attacksound
        S_FATT_PAIN,            // painstate
        80,             // painchance
        sfx_mnpain,             // painsound
        0,              // meleestate
        S_FATT_ATK1,            // missilestate
        S_NULL,         // crashstate
        S_FATT_DIE1,            // deathstate
        S_NULL,         // xdeathstate
        sfx_mandth,             // deathsound
        S_FATT_RAISE1,  // raisestate
        8,              // speed
        48*FRACUNIT,            // radius
        64*FRACUNIT,            // height
        1000,           // mass
        0,              // damage
        MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
# ifdef MBF21
        MF3_MAP07_BOSS1,  // flags3
# else
        0,
# endif
#endif
        0,
    },

    {           // MT_FATSHOT
        -1,             // doomednum
        S_FATSHOT1,             // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_firsht,             // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_FATSHOTX1,            // deathstate
        S_NULL,         // xdeathstate
        sfx_firxpl,             // deathsound
        S_NULL,         // raisestate
        20*FRACUNIT,            // speed
        6*FRACUNIT,             // radius
        8*FRACUNIT,             // height
        100,            // mass
        8,              // damage
        MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT,  // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_CHAINGUY
        65,             // doomednum
        S_CPOS_STND,            // spawnstate
        70,             // spawnhealth
        S_CPOS_RUN1,            // seestate
        sfx_posit2,             // seesound
        sfx_posact,             // activesound
        8,              // reactiontime
        0,              // attacksound
        S_CPOS_PAIN,            // painstate
        170,            // painchance
        sfx_popain,             // painsound
        0,              // meleestate
        S_CPOS_ATK1,            // missilestate
        S_NULL,         // crashstate
        S_CPOS_DIE1,            // deathstate
        S_CPOS_XDIE1,   // xdeathstate
        sfx_podth2,             // deathsound
        S_CPOS_RAISE1,  // raisestate
        8,              // speed
        20*FRACUNIT,            // radius
        56*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_TROOP
        3001,           // doomednum
        S_TROO_STND,    // spawnstate
        60,             // spawnhealth
        S_TROO_RUN1,    // seestate
        sfx_bgsit1,             // seesound
        sfx_bgact,              // activesound
        8,              // reactiontime
        0,              // attacksound
        S_TROO_PAIN,            // painstate
        200,            // painchance
        sfx_popain,             // painsound
        S_TROO_ATK1,    // meleestate
        S_TROO_ATK1,    // missilestate
        S_NULL,         // crashstate
        S_TROO_DIE1,    // deathstate
        S_TROO_XDIE1,   // xdeathstate
        sfx_bgdth1,             // deathsound
        S_TROO_RAISE1,  // raisestate
        8,              // speed
        20*FRACUNIT,            // radius
        56*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_SERGEANT
        3002,           // doomednum
        S_SARG_STND,            // spawnstate
        150,            // spawnhealth
        S_SARG_RUN1,            // seestate
        sfx_sgtsit,             // seesound
        sfx_dmact,              // activesound
        8,              // reactiontime
        sfx_sgtatk,             // attacksound
        S_SARG_PAIN,            // painstate
        180,            // painchance
        sfx_dmpain,             // painsound
        S_SARG_ATK1,            // meleestate
        0,              // missilestate
        S_NULL,         // crashstate
        S_SARG_DIE1,            // deathstate
        S_NULL,         // xdeathstate
        sfx_sgtdth,             // deathsound
        S_SARG_RAISE1,  // raisestate
        10,             // speed
        30*FRACUNIT,            // radius
        56*FRACUNIT,            // height
        400,            // mass
        0,              // damage
        MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_SHADOWS
        58,             // doomednum
        S_SARG_STND,            // spawnstate
        150,            // spawnhealth
        S_SARG_RUN1,            // seestate
        sfx_sgtsit,             // seesound
        sfx_dmact,              // activesound
        8,              // reactiontime
        sfx_sgtatk,             // attacksound
        S_SARG_PAIN,            // painstate
        180,            // painchance
        sfx_dmpain,             // painsound
        S_SARG_ATK1,            // meleestate
        0,              // missilestate
        S_NULL,         // crashstate
        S_SARG_DIE1,            // deathstate
        S_NULL,         // xdeathstate
        sfx_sgtdth,             // deathsound
        S_SARG_RAISE1,  // raisestate
        10,             // speed
        30*FRACUNIT,            // radius
        56*FRACUNIT,            // height
        400,            // mass
        0,              // damage
        MF_SOLID|MF_SHOOTABLE|MF_SHADOW|MF_COUNTKILL,           // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_HEAD
        3005,           // doomednum
        S_HEAD_STND,            // spawnstate
        400,            // spawnhealth
        S_HEAD_RUN1,            // seestate
        sfx_cacsit,             // seesound
        sfx_dmact,              // activesound
        8,              // reactiontime
        0,              // attacksound
        S_HEAD_PAIN,            // painstate
        128,            // painchance
        sfx_dmpain,             // painsound
        0,              // meleestate
        S_HEAD_ATK1,            // missilestate
        S_NULL,         // crashstate
        S_HEAD_DIE1,            // deathstate
        S_NULL,         // xdeathstate
        sfx_cacdth,             // deathsound
        S_HEAD_RAISE1,  // raisestate
        8,              // speed
        31*FRACUNIT,            // radius
        56*FRACUNIT,            // height
        400,            // mass
        0,              // damage
        MF_SOLID|MF_SHOOTABLE|MF_FLOAT|MF_NOGRAVITY|MF_COUNTKILL,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_BRUISER
        3003,           // doomednum
        S_BOSS_STND,            // spawnstate
        1000,           // spawnhealth
        S_BOSS_RUN1,            // seestate
        sfx_brssit,             // seesound
        sfx_dmact,              // activesound
        8,              // reactiontime
        0,              // attacksound
        S_BOSS_PAIN,            // painstate
        50,             // painchance
        sfx_dmpain,             // painsound
        S_BOSS_ATK1,            // meleestate
        S_BOSS_ATK1,            // missilestate
        S_NULL,         // crashstate
        S_BOSS_DIE1,            // deathstate
        S_NULL,         // xdeathstate
        sfx_brsdth,             // deathsound
        S_BOSS_RAISE1,  // raisestate
        8,              // speed
        24*FRACUNIT,            // radius
        64*FRACUNIT,            // height
        1000,           // mass
        0,              // damage
        MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
# ifdef MBF21
        MF3_E1M8_BOSS,  // flags3
# else
        0,
# endif
#endif
        0,
    },

    {           // MT_BRUISERSHOT
        -1,             // doomednum
        S_BRBALL1,              // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_firsht,             // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_BRBALLX1,             // deathstate
        S_NULL,         // xdeathstate
        sfx_firxpl,             // deathsound
        S_NULL,         // raisestate
        15*FRACUNIT,            // speed
        6*FRACUNIT,             // radius
        8*FRACUNIT,             // height
        100,            // mass
        8,              // damage
        MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT,  // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_KNIGHT
        69,             // doomednum
        S_BOS2_STND,            // spawnstate
        500,            // spawnhealth
        S_BOS2_RUN1,            // seestate
        sfx_kntsit,             // seesound
        sfx_dmact,              // activesound
        8,              // reactiontime
        0,              // attacksound
        S_BOS2_PAIN,            // painstate
        50,             // painchance
        sfx_dmpain,             // painsound
        S_BOS2_ATK1,            // meleestate
        S_BOS2_ATK1,            // missilestate
        S_NULL,         // crashstate
        S_BOS2_DIE1,            // deathstate
        S_NULL,         // xdeathstate
        sfx_kntdth,             // deathsound
        S_BOS2_RAISE1,  // raisestate
        8,              // speed
        24*FRACUNIT,            // radius
        64*FRACUNIT,            // height
        1000,           // mass
        0,              // damage
        MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_SKULL
        3006,           // doomednum
        S_SKULL_STND,           // spawnstate
        100,            // spawnhealth
        S_SKULL_RUN1,           // seestate
        sfx_None,               // seesound
        sfx_dmact,              // activesound
        8,              // reactiontime
        sfx_sklatk,             // attacksound
        S_SKULL_PAIN,           // painstate
        256,            // painchance
        sfx_dmpain,             // painsound
        0,              // meleestate
        S_SKULL_ATK1,           // missilestate
        S_NULL,         // crashstate
        S_SKULL_DIE1,           // deathstate
        S_NULL,         // xdeathstate
        sfx_firxpl,             // deathsound
        S_NULL,         // raisestate
        8,              // speed
        16*FRACUNIT,            // radius
        56*FRACUNIT,            // height
        50,             // mass
        3,              // damage
        MF_SOLID|MF_SHOOTABLE|MF_FLOAT|MF_NOGRAVITY|MF_TRANSLUCENT, // flags
           // was not translucent in Boom
        0,
#ifdef MOBJ_HAS_FLAGS3
# ifdef MBF21
        MF3_RANGEHALF,
# else
        0,
# endif
#endif
        0,
    },

    {           // MT_SPIDER
        7,              // doomednum
        S_SPID_STND,            // spawnstate
        3000,           // spawnhealth
        S_SPID_RUN1,            // seestate
        sfx_spisit,             // seesound
        sfx_dmact,              // activesound
        8,              // reactiontime
        sfx_shotgn,             // attacksound
        S_SPID_PAIN,            // painstate
        40,             // painchance
        sfx_dmpain,             // painsound
        0,              // meleestate
        S_SPID_ATK1,            // missilestate
        S_NULL,         // crashstate
        S_SPID_DIE1,            // deathstate
        S_NULL,         // xdeathstate
        sfx_spidth,             // deathsound
        S_NULL,         // raisestate
        12,             // speed
        128*FRACUNIT,           // radius
        100*FRACUNIT,           // height
        1000,           // mass
        0,              // damage
        MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
# ifdef MBF21
        MF3_E3M8_BOSS | MF3_E4M8_BOSS | MF3_RANGEHALF | MF3_FULLVOLSOUNDS,  // flags3
# else
        0,
# endif
#endif
        0,
    },

    {           // MT_BABY
        68,             // doomednum
        S_BSPI_STND,            // spawnstate
        500,            // spawnhealth
        S_BSPI_SIGHT,           // seestate
        sfx_bspsit,             // seesound
        sfx_bspact,             // activesound
        8,              // reactiontime
        0,              // attacksound
        S_BSPI_PAIN,            // painstate
        128,            // painchance
        sfx_dmpain,             // painsound
        0,              // meleestate
        S_BSPI_ATK1,            // missilestate
        S_NULL,         // crashstate
        S_BSPI_DIE1,            // deathstate
        S_NULL,         // xdeathstate
        sfx_bspdth,             // deathsound
        S_BSPI_RAISE1,  // raisestate
        12,             // speed
        64*FRACUNIT,            // radius
        64*FRACUNIT,            // height
        600,            // mass
        0,              // damage
        MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
# ifdef MBF21
        MF3_MAP07_BOSS2,  // flags3
# else
        0,
# endif
#endif
        0,
    },

    {           // MT_CYBORG
        16,             // doomednum
        S_CYBER_STND,           // spawnstate
        4000,           // spawnhealth
        S_CYBER_RUN1,           // seestate
        sfx_cybsit,             // seesound
        sfx_dmact,              // activesound
        8,              // reactiontime
        0,              // attacksound
        S_CYBER_PAIN,           // painstate
        20,             // painchance
        sfx_dmpain,             // painsound
        0,              // meleestate
        S_CYBER_ATK1,           // missilestate
        S_NULL,         // crashstate
        S_CYBER_DIE1,           // deathstate
        S_NULL,         // xdeathstate
        sfx_cybdth,             // deathsound
        S_NULL,         // raisestate
        16,             // speed
        40*FRACUNIT,            // radius
        110*FRACUNIT,           // height
        1000,           // mass
        0,              // damage
        MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
# ifdef MBF21
        MF3_E2M8_BOSS | MF3_E4M6_BOSS | MF3_RANGEHALF | MF3_HIGHERMPROB | MF3_FULLVOLSOUNDS,  // flags3
# else
        0,
# endif
#endif
        0,
    },

    {           // MT_PAIN
        71,             // doomednum
        S_PAIN_STND,            // spawnstate
        400,            // spawnhealth
        S_PAIN_RUN1,            // seestate
        sfx_pesit,              // seesound
        sfx_dmact,              // activesound
        8,              // reactiontime
        0,              // attacksound
        S_PAIN_PAIN,            // painstate
        128,            // painchance
        sfx_pepain,             // painsound
        0,              // meleestate
        S_PAIN_ATK1,            // missilestate
        S_NULL,         // crashstate
        S_PAIN_DIE1,            // deathstate
        S_NULL,         // xdeathstate
        sfx_pedth,              // deathsound
        S_PAIN_RAISE1,  // raisestate
        8,              // speed
        31*FRACUNIT,            // radius
        56*FRACUNIT,            // height
        400,            // mass
        0,              // damage
        MF_SOLID|MF_SHOOTABLE|MF_FLOAT|MF_NOGRAVITY|MF_COUNTKILL,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_WOLFSS
        84,             // doomednum
        S_SSWV_STND,            // spawnstate
        50,             // spawnhealth
        S_SSWV_RUN1,            // seestate
        sfx_sssit,              // seesound
        sfx_posact,             // activesound
        8,              // reactiontime
        0,              // attacksound
        S_SSWV_PAIN,            // painstate
        170,            // painchance
        sfx_popain,             // painsound
        0,              // meleestate
        S_SSWV_ATK1,            // missilestate
        S_NULL,         // crashstate
        S_SSWV_DIE1,            // deathstate
        S_SSWV_XDIE1,           // xdeathstate
        sfx_ssdth,              // deathsound
        S_SSWV_RAISE1,  // raisestate
        8,              // speed
        20*FRACUNIT,            // radius
        56*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_KEEN
        72,             // doomednum
        S_KEENSTND,             // spawnstate
        100,            // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_KEENPAIN,             // painstate
        256,            // painchance
        sfx_keenpn,             // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_COMMKEEN,             // deathstate
        S_NULL,         // xdeathstate
        sfx_keendt,             // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        72*FRACUNIT,            // height
        10000000,               // mass
        0,              // damage
        MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY|MF_SHOOTABLE|MF_COUNTKILL,                // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_BOSSBRAIN
        88,             // doomednum
        S_BRAIN,                // spawnstate
        250,            // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_BRAIN_PAIN,           // painstate
        255,            // painchance
        sfx_bospn,              // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_BRAIN_DIE1,           // deathstate
        S_NULL,         // xdeathstate
        sfx_bosdth,             // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        64*FRACUNIT,            // height
        10000000,               // mass
        0,              // damage
        MF_SOLID|MF_SHOOTABLE,          // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_BOSSSPIT
        89,             // doomednum
        S_BRAINEYE,             // spawnstate
        1000,           // spawnhealth
        S_BRAINEYESEE,          // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        32*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_NOBLOCKMAP|MF_NOSECTOR,              // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_BOSSTARGET
        87,             // doomednum
        S_NULL,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        32*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_NOBLOCKMAP|MF_NOSECTOR,              // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_SPAWNSHOT
        -1,             // doomednum
        S_SPAWN1,               // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_bospit,             // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_firxpl,             // deathsound
        S_NULL,         // raisestate
        10*FRACUNIT,            // speed
        6*FRACUNIT,             // radius
        32*FRACUNIT,            // height
        100,            // mass
        3,              // damage
        MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_NOCLIP,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_SPAWNFIRE
        -1,             // doomednum
        S_SPAWNFIRE1,           // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT,  // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_BARREL
        2035,           // doomednum
        S_BAR1,         // spawnstate
        20,             // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_BEXP,         // deathstate
        S_NULL,         // xdeathstate
        sfx_barexp,             // deathsound
        S_NULL,         // raisestate
        0,              // speed
        10*FRACUNIT,            // radius
        32*FRACUNIT,            // height       //was 42
        100,            // mass
        0,              // damage
        MF_SOLID|MF_SHOOTABLE|MF_NOBLOOD,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_TROOPSHOT
        -1,             // doomednum
        S_TBALL1,               // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_firsht,             // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_TBALLX1,              // deathstate
        S_NULL,         // xdeathstate
        sfx_firxpl,             // deathsound
        S_NULL,         // raisestate
        10*FRACUNIT,            // speed
        6*FRACUNIT,             // radius
        8*FRACUNIT,             // height
        100,            // mass
        3,              // damage
        MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT,  // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_HEADSHOT
        -1,             // doomednum
        S_RBALL1,               // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_firsht,             // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_RBALLX1,              // deathstate
        S_NULL,         // xdeathstate
        sfx_firxpl,             // deathsound
        S_NULL,         // raisestate
        10*FRACUNIT,            // speed
        6*FRACUNIT,             // radius
        8*FRACUNIT,             // height
        100,            // mass
        5,              // damage
        MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT, // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_ROCKET
        -1,             // doomednum
        S_ROCKET,               // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_rlaunc,             // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_EXPLODE1,             // deathstate
        S_NULL,         // xdeathstate
        sfx_barexp,             // deathsound
        S_NULL,         // raisestate
        20*FRACUNIT,            // speed
        11*FRACUNIT,            // radius
        8*FRACUNIT,             // height
        100,            // mass
        20,             // damage
        MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_PLASMA
        -1,             // doomednum
        S_PLASBALL,             // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_plasma,             // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_PLASEXP,              // deathstate
        S_NULL,         // xdeathstate
        sfx_firxpl,             // deathsound
        S_NULL,         // raisestate
        25*FRACUNIT,            // speed
        13*FRACUNIT,            // radius
        8*FRACUNIT,             // height
        100,            // mass
        5,              // damage
        MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT,  // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_BFG
        -1,             // doomednum
        S_BFGSHOT,              // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_BFGLAND,              // deathstate
        S_NULL,         // xdeathstate
        sfx_rxplod,             // deathsound
        S_NULL,         // raisestate
        25*FRACUNIT,            // speed
        13*FRACUNIT,            // radius
        8*FRACUNIT,             // height
        100,            // mass
        100,            // damage
        MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT,  // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_ARACHPLAZ
        -1,             // doomednum
        S_ARACH_PLAZ,           // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_plasma,             // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_ARACH_PLEX,           // deathstate
        S_NULL,         // xdeathstate
        sfx_firxpl,             // deathsound
        S_NULL,         // raisestate
        25*FRACUNIT,            // speed
        13*FRACUNIT,            // radius
        8*FRACUNIT,             // height
        100,            // mass
        5,              // damage
        MF_NOBLOCKMAP|MF_MISSILE|MF_DROPOFF|MF_NOGRAVITY|MF_TRANSLUCENT,  // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_PUFF
        -1,             // doomednum
        S_PUFF1,                // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_NOBLOCKMAP|MF_NOGRAVITY|MF_NOCLIP|MF_TRANSLUCENT,  // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

        //WARNING: this mobj is hacked in g_downgrade (g_game.c)
    {           // MT_BLOOD
        -1,             // doomednum
        S_BLOOD1,               // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        3*FRACUNIT,            // radius
        0*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        0/*MF_NOBLOCKMAP*/,          // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_TFOG
        -1,             // doomednum
        S_TFOG,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT,  // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_IFOG
        -1,             // doomednum
        S_IFOG,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_NOBLOCKMAP|MF_NOGRAVITY|MF_TRANSLUCENT,  // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_TELEPORTMAN
        14,             // doomednum
        S_NULL,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_NOBLOCKMAP|MF_NOSECTOR,              // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_EXTRABFG
        -1,             // doomednum
        S_BFGEXP,               // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_NOBLOCKMAP|MF_NOGRAVITY,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC0
        2018,           // doomednum
        S_ARM1,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC1
        2019,           // doomednum
        S_ARM2,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC2
        2014,           // doomednum
        S_BON1,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL|MF_COUNTITEM,                // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC3
        2015,           // doomednum
        S_BON2,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL|MF_COUNTITEM,                // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC4
        5,              // doomednum
        S_BKEY,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL|MF_NOTDMATCH,                // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC5
        13,             // doomednum
        S_RKEY,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL|MF_NOTDMATCH,                // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC6
        6,              // doomednum
        S_YKEY,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL|MF_NOTDMATCH,                // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC7
        39,             // doomednum
        S_YSKULL,               // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL|MF_NOTDMATCH,                // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC8
        38,             // doomednum
        S_RSKULL,               // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL|MF_NOTDMATCH,                // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC9
        40,             // doomednum
        S_BSKULL,               // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL|MF_NOTDMATCH,                // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC10
        2011,           // doomednum
        S_STIM,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC11
        2012,           // doomednum
        S_MEDI,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC12
        2013,           // doomednum
        S_SOUL,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL|MF_COUNTITEM|MF_TRANSLUCENT,  // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_INV
        2022,           // doomednum
        S_PINV,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL|MF_COUNTITEM|MF_TRANSLUCENT,  // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC13
        2023,           // doomednum
        S_PSTR,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL|MF_COUNTITEM,                // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_INS
        2024,           // doomednum
        S_PINS,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL|MF_COUNTITEM|MF_TRANSLUCENT,  // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC14
        2025,           // doomednum
        S_SUIT,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC15
        2026,           // doomednum
        S_PMAP,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL|MF_COUNTITEM,                // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC16
        2045,           // doomednum
        S_PVIS,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL|MF_COUNTITEM,                // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MEGA
        83,             // doomednum
        S_MEGA,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL|MF_COUNTITEM|MF_TRANSLUCENT,  // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_CLIP
        2007,           // doomednum
        S_CLIP,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC17
        2048,           // doomednum
        S_AMMO,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC18
        2010,           // doomednum
        S_ROCK,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC19
        2046,           // doomednum
        S_BROK,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC20
        2047,           // doomednum
        S_CELL,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC21
        17,             // doomednum
        S_CELP,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC22
        2008,           // doomednum
        S_SHEL,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC23
        2049,           // doomednum
        S_SBOX,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC24
        8,              // doomednum
        S_BPAK,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_BFG9000
        2006,           // doomednum
        S_BFUG,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_CHAINGUN
        2002,           // doomednum
        S_MGUN,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_SHAINSAW
        2005,           // doomednum
        S_CSAW,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_ROCKETLAUNCH
        2003,           // doomednum
        S_LAUN,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_PLASMAGUN
        2004,           // doomednum
        S_PLAS,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_SHOTGUN
        2001,           // doomednum
        S_SHOT,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_SUPERSHOTGUN
        82,             // doomednum
        S_SHOT2,                // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPECIAL,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC29
        85,             // doomednum
        S_TECHLAMP,             // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        72*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC30
        86,             // doomednum
        S_TECH2LAMP,            // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        56*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC31
        2028,           // doomednum
        S_COLU,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        48*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC32
        30,             // doomednum
        S_TALLGRNCOL,           // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        52*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC33
        31,             // doomednum
        S_SHRTGRNCOL,           // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        40*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC34
        32,             // doomednum
        S_TALLREDCOL,           // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        52*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC35
        33,             // doomednum
        S_SHRTREDCOL,           // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        40*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC36
        37,             // doomednum
        S_SKULLCOL,             // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        40*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC37
        36,             // doomednum
        S_HEARTCOL,             // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        40*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC38
        41,             // doomednum
        S_EVILEYE,              // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC39
        42,             // doomednum
        S_FLOATSKULL,           // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        48*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC40
        43,             // doomednum
        S_TORCHTREE,            // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        64*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC41
        44,             // doomednum
        S_BLUETORCH,            // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        64*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC42
        45,             // doomednum
        S_GREENTORCH,           // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        64*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC43
        46,             // doomednum
        S_REDTORCH,             // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        64*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC44
        55,             // doomednum
        S_BTORCHSHRT,           // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        40*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC45
        56,             // doomednum
        S_GTORCHSHRT,           // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        40*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC46
        57,             // doomednum
        S_RTORCHSHRT,           // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        40*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC47
        47,             // doomednum
        S_STALAGTITE,           // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        40*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC48
        48,             // doomednum
        S_TECHPILLAR,           // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        120*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC49
        34,             // doomednum
        S_CANDLESTIK,           // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        0,              // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC50
        35,             // doomednum
        S_CANDELABRA,           // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        56*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC51
        49,             // doomednum
        S_BLOODYTWITCH,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        68*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,          // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC52
        50,             // doomednum
        S_MEAT2,                // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        84*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,          // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC53
        51,             // doomednum
        S_MEAT3,                // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        84*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,          // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC54
        52,             // doomednum
        S_MEAT4,                // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        68*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,          // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC55
        53,             // doomednum
        S_MEAT5,                // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        52*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,          // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC56
        59,             // doomednum
        S_MEAT2,                // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        84*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPAWNCEILING|MF_NOGRAVITY,           // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC57
        60,             // doomednum
        S_MEAT4,                // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        68*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPAWNCEILING|MF_NOGRAVITY,           // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC58
        61,             // doomednum
        S_MEAT3,                // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        52*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPAWNCEILING|MF_NOGRAVITY,           // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC59
        62,             // doomednum
        S_MEAT5,                // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        52*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPAWNCEILING|MF_NOGRAVITY,           // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC60
        63,             // doomednum
        S_BLOODYTWITCH,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        68*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SPAWNCEILING|MF_NOGRAVITY,           // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC61
        22,             // doomednum
        S_HEAD_DIE6,            // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        0,              // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC62
        15,             // doomednum
        S_PLAY_DIE7,            // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        0,              // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC63
        18,             // doomednum
        S_POSS_DIE5,            // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        0,              // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC64
        21,             // doomednum
        S_SARG_DIE6,            // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        0,              // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC65
        23,             // doomednum
        S_SKULL_DIE6,           // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        0,              // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC66
        20,             // doomednum
        S_TROO_DIE5,            // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        0,              // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC67
        19,             // doomednum
        S_SPOS_DIE5,            // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        0,              // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC68
        10,             // doomednum
        S_PLAY_XDIE9,           // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        0,              // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC69
        12,             // doomednum
        S_PLAY_XDIE9,           // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        0,              // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC70
        28,             // doomednum
        S_HEADSONSTICK,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        64*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC71
        24,             // doomednum
        S_GIBS,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        0,              // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC72
        27,             // doomednum
        S_HEADONASTICK,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        56*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC73
        29,             // doomednum
        S_HEADCANDLES,          // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        48*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC74
        25,             // doomednum
        S_DEADSTICK,            // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        64*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC75
        26,             // doomednum
        S_LIVESTICK,            // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        64*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC76
        54,             // doomednum
        S_BIGTREE,              // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        32*FRACUNIT,            // radius
        96*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC77
        70,             // doomednum
        S_BBAR1,                // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        30*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID,               // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC78
        73,             // doomednum
        S_HANGNOGUTS,           // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        88*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,          // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC79
        74,             // doomednum
        S_HANGBNOBRAIN,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        88*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,          // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC80
        75,             // doomednum
        S_HANGTLOOKDN,          // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        64*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,          // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC81
        76,             // doomednum
        S_HANGTSKULL,           // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        64*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,          // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC82
        77,             // doomednum
        S_HANGTLOOKUP,          // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        64*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,          // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC83
        78,             // doomednum
        S_HANGTNOBRAIN,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        16*FRACUNIT,            // radius
        64*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_SOLID|MF_SPAWNCEILING|MF_NOGRAVITY,          // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC84
        79,             // doomednum
        S_COLONGIBS,            // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,              // reactiontime
        sfx_None,               // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,               // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,               // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,            // mass
        0,              // damage
        MF_NOBLOCKMAP,          // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC85
        80,                     // doomednum
        S_SMALLPOOL,            // spawnstate
        1000,                   // spawnhealth
        S_NULL,                 // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,                      // reactiontime
        sfx_None,               // attacksound
        S_NULL,                 // painstate
        0,                      // painchance
        sfx_None,               // painsound
        S_NULL,                 // meleestate
        S_NULL,                 // missilestate
        S_NULL,         // crashstate
        S_NULL,                 // deathstate
        S_NULL,                 // xdeathstate
        sfx_None,               // deathsound
        S_NULL,                 // raisestate
        0,                      // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,                    // mass
        0,                      // damage
        MF_NOBLOCKMAP,          // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_MISC86
        81,                     // doomednum
        S_BRAINSTEM,            // spawnstate
        1000,                   // spawnhealth
        S_NULL,                 // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,                      // reactiontime
        sfx_None,               // attacksound
        S_NULL,                 // painstate
        0,                      // painchance
        sfx_None,               // painsound
        S_NULL,                 // meleestate
        S_NULL,                 // missilestate
        S_NULL,         // crashstate
        S_NULL,                 // deathstate
        S_NULL,                 // xdeathstate
        sfx_None,               // deathsound
        S_NULL,                 // raisestate
        0,                      // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,                    // mass
        0,                      // damage
        MF_NOBLOCKMAP,          // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    //added:26-02-98: chase camera
    {           // MT_CHASECAM
        -1,             // doomednum
        S_NULL,         // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,       // seesound
        sfx_None,       // activesound
        8,              // reactiontime
        sfx_None,       // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,       // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,       // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,    // radius
        16*FRACUNIT,    // height
        100,            // mass
        0,              // damage
        MF_NOBLOCKMAP|MF_NOSECTOR|MF_NOGRAVITY|MF_FLOAT,  // flags
        MF2_SLIDE|MF2_NOCLIPTHING,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },
    //added:9-06-98: spirit for movement prediction
    {           // MT_SPIRIT
        -1,             // doomednum                       -1,             // doomednum
        S_NULL,         // spawnstate                      S_PLAY,         // spawnstate
        1000,           // spawnhealth                     100,            // spawnhealth
        S_NULL,         // seestate                        S_PLAY_RUN1,    // seestate
        sfx_None,       // seesound                        sfx_None,       // seesound
        sfx_None,       // activesound                     sfx_None,       // activesound
        0,              // reactiontime                    0,              // reactiontime
        sfx_None,       // attacksound                     sfx_None,       // attacksound
        S_NULL,         // painstate                       S_PLAY_PAIN,    // painstate
        0,              // painchance                      255,            // painchance
        sfx_None,       // painsound                       sfx_plpain,     // painsound
        S_NULL,         // meleestate                      S_NULL,         // meleestate
        S_NULL,         // missilestate                    S_PLAY_ATK1,    // missilestate
        S_NULL,         // crashstate                    
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate                     S_PLAY_XDIE1,   // xdeathstate
        sfx_None,       // deathsound                      sfx_pldeth,     // deathsound
        S_NULL,         // raisestate                      S_NULL,         // raisestate
        0,              // speed                           0,              // speed
        16*FRACUNIT,    // radius                          16*FRACUNIT,    // radius
        56*FRACUNIT,    // height                          56*FRACUNIT,    // height
        100,            // mass                            100,            // mass
        0,              // damage                          0,              // damage
        /*MF_NOBLOCKMAP|MF_NOSECTOR|*/MF_DROPOFF,  // flags    MF_SOLID|MF_SHOOTABLE|MF_PICKUP|MF_NOTDMATCH,
        MF2_SLIDE,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_SMOK test v1.25 smoke from lava/slime damage
        -1,                     // doomednum
        S_SMOK1,                // spawnstate
        1000,                   // spawnhealth
        S_NULL,                 // seestate
        sfx_None,               // seesound
        sfx_None,               // activesound
        8,                      // reactiontime
        sfx_None,               // attacksound
        S_NULL,                 // painstate
        0,                      // painchance
        sfx_None,               // painsound
        S_NULL,                 // meleestate
        S_NULL,                 // missilestate
        S_NULL,         // crashstate
        S_NULL,                 // deathstate
        S_NULL,                 // xdeathstate
        sfx_None,               // deathsound
        S_NULL,                 // raisestate
        0,                      // speed
        20*FRACUNIT,            // radius
        16*FRACUNIT,            // height
        100,                    // mass
        0,                      // damage
        MF_NOBLOCKMAP|MF_NOGRAVITY|MF_NOCLIP,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {           // MT_SPLASH test
        -1,             // doomednum
        S_SPLASH1,      // spawnstate
        1000,           // spawnhealth
        S_NULL,         // seestate
        sfx_None,       // seesound
        sfx_None,       // activesound
        8,              // reactiontime
        sfx_None,       // attacksound
        S_NULL,         // painstate
        0,              // painchance
        sfx_None,       // painsound
        S_NULL,         // meleestate
        S_NULL,         // missilestate
        S_NULL,         // crashstate
        S_NULL,         // deathstate
        S_NULL,         // xdeathstate
        sfx_None,       // deathsound
        S_NULL,         // raisestate
        0,              // speed
        20*FRACUNIT,    // radius
        16*FRACUNIT,    // height
        100,            // mass
        0,              // damage
        MF_NOBLOCKMAP|MF_NOGRAVITY|MF_NOCLIP,             // flags
        0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    // For use with wind and current effects
    {   // MT_PUSH                       // phares
      5001,           // doomednum       //   |      //jff 5/11/98 deconflict
      S_TNT1,         // spawnstate      //   V      // with DOSDoom
      1000,           // spawnhealth
      S_NULL,         // seestate
      sfx_None,       // seesound
      sfx_None,       // activesound                              
      8,              // reactiontime                             
      sfx_None,       // attacksound                              
      S_NULL,         // painstate                                
      0,              // painchance                               
      sfx_None,       // painsound                                
      S_NULL,         // meleestate                               
      S_NULL,         // missilestate                             
      S_NULL,         // crashstate                             
      S_NULL,         // deathstate                               
      S_NULL,         // xdeathstate                              
      sfx_None,       // deathsound                               
      S_NULL,         // raisestate                                   
      0,              // speed                                    
      8*FRACUNIT,     // radius                                   
      8,              // height                                   
      10,             // mass                                     
      0,              // damage                                   
      MF_NOBLOCKMAP,  // flags
      0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    // For use with wind and current effects
    {   // MT_PULL
      5002,           // doomednum                   //jff 5/11/98 deconflict            
      S_TNT1,         // spawnstate                  // with DOSDoom        
      1000,           // spawnhealth                              
      S_NULL,         // seestate                                 
      sfx_None,       // seesound                                 
      sfx_None,       // activesound                              
      8,              // reactiontime                             
      sfx_None,       // attacksound                              
      S_NULL,         // painstate                                
      0,              // painchance                               
      sfx_None,       // painsound                                
      S_NULL,         // meleestate                               
      S_NULL,         // missilestate                             
      S_NULL,         // crashstate                             
      S_NULL,         // deathstate                               
      S_NULL,         // xdeathstate                              
      sfx_None,       // deathsound                               
      S_NULL,         // raisestate                                   
      0,              // speed                                    
      8*FRACUNIT,     // radius                                   
      8,              // height                                   
      10,             // mass                                     
      0,              // damage                                   
      MF_NOBLOCKMAP,  // flags
      0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },
    //SoM: Note that the above is thing type # 138

    //SoM: Dogs, and BetaBFG are NOT implemented! These things are here to
    //hold spaces.
    // [WDJ] MBF dogs implemented.
    // Marine's best friend :)      // killough 7/19/98
    {   // MT_DOGS
      888,            // doomednum
#ifdef DOGS
      S_DOGS_STND,    // spawnstate
      500,            // spawnhealth
      S_DOGS_RUN1,    // seestate
      sfx_dgsit,      // seesound
      sfx_dgact,      // activesound
      8,              // reactiontime
      sfx_dgatk,      // attacksound
      S_DOGS_PAIN,    // painstate
      180,            // painchance
      sfx_dgpain,     // painsound
      S_DOGS_ATK1,    // meleestate
      0,              // missilestate
      S_NULL,         // crashstate
      S_DOGS_DIE1,    // deathstate
      S_NULL,         // xdeathstate
      sfx_dgdth,      // deathsound
      S_DOGS_RAISE1,  // raisestate
      10,             // speed
      12*FRACUNIT,    // radius
      28*FRACUNIT,    // height
      100,            // mass
      0,              // damage
      MF_SOLID|MF_SHOOTABLE|MF_COUNTKILL, // flags
      0,              // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
#else
      // Dummy Dogs, does not use any name that is not present without DOGS.
      S_TNT1,         // spawnstate
      500,            // spawnhealth
      S_TNT1,         // seestate
      sfx_None,       // seesound
      sfx_None,       // activesound
      8,              // reactiontime
      sfx_None,       // attacksound
      S_TNT1,         // painstate
      180,            // painchance
      sfx_None,       // painsound
      S_TNT1,         // meleestate
      0,              // missilestate
      S_NULL,         // crashstate
      S_NULL,         // deathstate
      S_NULL,         // xdeathstate
      sfx_None,       // deathsound
      S_NULL,         // raisestate
      10,             // speed
      12*FRACUNIT,    // radius
      28*FRACUNIT,    // height
      100,            // mass
      0,              // damage
      MF_NOSECTOR|MF_NOBLOCKMAP, // flags
      0,              // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
#endif
    },

    {                   // MT_PLASMA1
      -1,               // doomednum
      S_TNT1,           // spawnstate
      1000,             // spawnhealth
      S_NULL,           // seestate
      sfx_None,         // seesound
      sfx_None,         // activesound
      8,                // reactiontime
      sfx_None,         // attacksound
      S_NULL,           // painstate
      0,                // painchance
      sfx_None,         // painsound
      S_NULL,           // meleestate
      S_NULL,           // missilestate
      S_NULL,           // crashstate
      S_TNT1,           // deathstate
      S_NULL,           // xdeathstate
      sfx_None,         // deathsound
      S_NULL,           // raisestate
      25*FRACUNIT,      // speed
      13*FRACUNIT,      // radius
      8*FRACUNIT,       // height
      100,              // mass
      4,                // damage
      MF_NOSECTOR|MF_NOBLOCKMAP, // flags
      0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {                   // MT_PLASMA2
      -1,               // doomednum
      S_TNT1,       // spawnstate
      1000,             // spawnhealth
      S_NULL,           // seestate
      sfx_None,         // seesound
      sfx_None,         // activesound
      8,                // reactiontime
      sfx_None,         // attacksound
      S_NULL,           // painstate
      0,                // painchance
      sfx_None,         // painsound
      S_NULL,           // meleestate
      S_NULL,           // missilestate
      S_NULL,           // crashstate
      S_TNT1,           // deathstate
      S_NULL,           // xdeathstate
      sfx_None,         // deathsound
      S_NULL,           // raisestate
      25*FRACUNIT,      // speed
      6*FRACUNIT,       // radius
      8*FRACUNIT,       // height
      100,              // mass
      4,                // damage
      MF_NOSECTOR|MF_NOBLOCKMAP, // flags
      0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    {   // MT_CAMERA
      5003,           // doomednum
      S_TNT1,         // spawnstate
      1000,           // spawnhealth
      S_NULL,         // seestate
      sfx_None,       // seesound
      sfx_None,       // activesound
      8,              // reactiontime
      sfx_None,       // attacksound
      S_NULL,         // painstate
      0,              // painchance
      sfx_None,       // painsound
      S_NULL,         // meleestate
      S_NULL,         // missilestate
      S_NULL,         // crashstate
      S_NULL,         // deathstate
      S_NULL,         // xdeathstate
      sfx_None,       // deathsound
      S_NULL,         // raisestate
      0,              // speed
      8*FRACUNIT,     // radius
      8,              // height
      10,             // mass
      0,              // damage
      MF_NOBLOCKMAP|MF_NOCLIP|MF_NOGRAVITY|MF_NOSECTOR,  // flags
      MF2_SLIDE,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },

    // SoM: Nodes for things like camera movement, and (eventually) monster
    // trails...
    {   // MT_NODE
      5004,           // doomednum
      S_TNT1,         // spawnstate
      1000,           // spawnhealth
      S_NULL,         // seestate
      sfx_None,       // seesound
      sfx_None,       // activesound
      8,              // reactiontime
      sfx_None,       // attacksound
      S_NULL,         // painstate
      0,              // painchance
      sfx_None,       // painsound
      S_NULL,         // meleestate
      S_NULL,         // missilestate
      S_NULL,         // crashstate
      S_NULL,         // deathstate
      S_NULL,         // xdeathstate
      sfx_None,       // deathsound
      S_NULL,         // raisestate
      0,              // speed
      16*FRACUNIT,    // radius
      8,              // height
      10,             // mass
      0,              // damage
      MF_NOBLOCKMAP|MF_NOCLIP|MF_NOSECTOR|MF_NOGRAVITY,  // flags
      0,
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
    },
//============================================================================
// Heretic data ! 
//============================================================================
    {                           // MT_MISC0
     -1,                        // doomednum
     S_ITEM_PTN1_1,             // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL,                // flags
     MF2_FLOATBOB,              // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_ITEMSHIELD1
     -1,                        // doomednum
     S_ITEM_SHLD1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL,                // flags
     MF2_FLOATBOB,              // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_ITEMSHIELD2
     -1,                        // doomednum
     S_ITEM_SHD2_1,             // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL,                // flags
     MF2_FLOATBOB,              // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MISC1
     -1,                        // doomednum
     S_ITEM_BAGH1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL | MF_COUNTITEM, // flags
     MF2_FLOATBOB,              // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MISC2
     -1,                        // doomednum
     S_ITEM_SPMP1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL | MF_COUNTITEM, // flags
     MF2_FLOATBOB,              // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_ARTIINVISIBILITY
     -1,                        // doomednum
     S_ARTI_INVS1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL | MF_SHADOW | MF_COUNTITEM,     // flags
     MF2_FLOATBOB,              // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MISC3
     -1,                        // doomednum
     S_ARTI_PTN2_1,             // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL | MF_COUNTITEM, // flags
     MF2_FLOATBOB,              // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_ARTIFLY
     83,                        // doomednum
     S_ARTI_SOAR1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL | MF_COUNTITEM, // flags
     MF2_FLOATBOB,              // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_ARTIINVULNERABILITY
     -1,                        // doomednum
     S_ARTI_INVU1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL | MF_COUNTITEM, // flags
     MF2_FLOATBOB,              // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_ARTITOMEOFPOWER
     -1,                        // doomednum
     S_ARTI_PWBK1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL | MF_COUNTITEM, // flags
     MF2_FLOATBOB,              // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_ARTIEGG
     -1,                        // doomednum
     S_ARTI_EGGC1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL | MF_COUNTITEM, // flags
     MF2_FLOATBOB,              // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_EGGFX
     -1,                        // doomednum
     S_EGGFX1,                  // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_EGGFXI1_1,               // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     18 * FRACUNIT,             // speed
     8 * FRACUNIT,              // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     1,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT,            // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_ARTISUPERHEAL
     -1,                        // doomednum
     S_ARTI_SPHL1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL | MF_COUNTITEM, // flags
     MF2_FLOATBOB,              // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MISC4
     -1,                        // doomednum
     S_ARTI_TRCH1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL | MF_COUNTITEM, // flags
     MF2_FLOATBOB,              // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MISC5
     -1,                        // doomednum
     S_ARTI_FBMB1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL | MF_COUNTITEM, // flags
     MF2_FLOATBOB,              // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_FIREBOMB
     -1,                        // doomednum
     S_FIREBOMB1,               // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_phohit,                // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOGRAVITY | MF_SHADOW,  // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_ARTITELEPORT
     -1,                        // doomednum
     S_ARTI_ATLP1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL | MF_COUNTITEM, // flags
     MF2_FLOATBOB,              // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_POD
     -1,                        // doomednum
     S_POD_WAIT1,               // spawnstate
     45,                        // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_POD_PAIN1,               // painstate
     255,                       // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_POD_DIE1,                // deathstate
     S_NULL,                    // xdeathstate
     sfx_podexp,                // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     16 * FRACUNIT,             // radius
     54 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SOLID | MF_NOBLOOD | MF_SHOOTABLE | MF_DROPOFF, // flags
     MF2_WINDTHRUST | MF2_PUSHABLE | MF2_SLIDE | MF2_PASSMOBJ | MF2_TELESTOMP,  // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_PODGOO
     -1,                        // doomednum
     S_PODGOO1,                 // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_PODGOOX,                 // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     2 * FRACUNIT,              // radius
     4 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF,   // flags
     MF2_NOTELEPORT | MF2_LOGRAV | MF2_CANNOTPUSH,   // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_PODGENERATOR
     -1,                        // doomednum
     S_PODGENERATOR,            // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_NOSECTOR,       // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_SPLASH
     -1,                        // doomednum
     S_HSPLASH1,                // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_SPLASHX,                 // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     2 * FRACUNIT,              // radius
     4 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF,   // flags
     MF2_NOTELEPORT | MF2_LOGRAV | MF2_CANNOTPUSH,      // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_SPLASHBASE
     -1,                        // doomednum
     S_SPLASHBASE1,             // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP,             // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_LAVASPLASH
     -1,                        // doomednum
     S_LAVASPLASH1,             // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP,             // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_LAVASMOKE
     -1,                        // doomednum
     S_LAVASMOKE1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SHADOW,  // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_SLUDGECHUNK
     -1,                        // doomednum
     S_SLUDGECHUNK1,            // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_SLUDGECHUNKX,            // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     2 * FRACUNIT,              // radius
     4 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF,   // flags
     MF2_NOTELEPORT | MF2_LOGRAV | MF2_CANNOTPUSH,     // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_SLUDGESPLASH
     -1,                        // doomednum
     S_SLUDGESPLASH1,           // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP,             // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_SKULLHANG70
     -1,                        // doomednum
     S_SKULLHANG70_1,           // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     70 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPAWNCEILING | MF_NOGRAVITY,    // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_SKULLHANG60
     -1,                        // doomednum
     S_SKULLHANG60_1,           // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     60 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPAWNCEILING | MF_NOGRAVITY,    // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_SKULLHANG45
     -1,                        // doomednum
     S_SKULLHANG45_1,           // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     45 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPAWNCEILING | MF_NOGRAVITY,    // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_SKULLHANG35
     -1,                        // doomednum
     S_SKULLHANG35_1,           // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     35 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPAWNCEILING | MF_NOGRAVITY,    // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_CHANDELIER
     -1,                        // doomednum
     S_CHANDELIER1,             // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     60 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPAWNCEILING | MF_NOGRAVITY,    // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_SERPTORCH
     -1,                        // doomednum
     S_SERPTORCH1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     12 * FRACUNIT,             // radius
     54 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SOLID,                  // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_SMALLPILLAR
     -1,                        // doomednum
     S_SMALLPILLAR,             // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     16 * FRACUNIT,             // radius
     34 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SOLID,                  // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_STALAGMITESMALL
     -1,                        // doomednum
     S_STALAGMITESMALL,         // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     8 * FRACUNIT,              // radius
     32 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SOLID,                  // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_STALAGMITELARGE
     -1,                        // doomednum
     S_STALAGMITELARGE,         // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     12 * FRACUNIT,             // radius
     64 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SOLID,                  // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_STALACTITESMALL
     -1,                        // doomednum
     S_STALACTITESMALL,         // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     8 * FRACUNIT,              // radius
     36 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SOLID | MF_SPAWNCEILING | MF_NOGRAVITY, // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_STALACTITELARGE
     -1,                        // doomednum
     S_STALACTITELARGE,         // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     12 * FRACUNIT,             // radius
     68 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SOLID | MF_SPAWNCEILING | MF_NOGRAVITY, // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MISC6
     76,                        // doomednum
     S_FIREBRAZIER1,            // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     16 * FRACUNIT,             // radius
     44 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SOLID,                  // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_BARREL
     -1,                        // doomednum
     S_BARREL,                  // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     12 * FRACUNIT,             // radius
     32 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SOLID,                  // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MISC7
     -1,                        // doomednum
     S_BRPILLAR,                // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     14 * FRACUNIT,             // radius
     128 * FRACUNIT,            // height
     100,                       // mass
     0,                         // damage
     MF_SOLID,                  // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MISC8
     -1,                        // doomednum
     S_MOSS1,                   // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     23 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPAWNCEILING | MF_NOGRAVITY,    // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MISC9
     -1,                        // doomednum
     S_MOSS2,                   // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     27 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPAWNCEILING | MF_NOGRAVITY,    // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MISC10
     -1,                        // doomednum
     S_WALLTORCH1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOGRAVITY,              // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MISC11
     -1,                        // doomednum
     S_HANGINGCORPSE,           // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     8 * FRACUNIT,              // radius
     104 * FRACUNIT,            // height
     100,                       // mass
     0,                         // damage
     MF_SOLID | MF_SPAWNCEILING | MF_NOGRAVITY, // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_KEYGIZMOBLUE
     94,                        // doomednum
     S_KEYGIZMO1,               // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     16 * FRACUNIT,             // radius
     50 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SOLID,                  // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_KEYGIZMOGREEN
     95,                        // doomednum
     S_KEYGIZMO1,               // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     16 * FRACUNIT,             // radius
     50 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SOLID,                  // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_KEYGIZMOYELLOW
     96,                        // doomednum
     S_KEYGIZMO1,               // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     16 * FRACUNIT,             // radius
     50 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SOLID,                  // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_KEYGIZMOFLOAT
     -1,                        // doomednum
     S_KGZ_START,               // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     16 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SOLID | MF_NOGRAVITY,   // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MISC12
     -1,                        // doomednum
     S_VOLCANO1,                // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     12 * FRACUNIT,             // radius
     20 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SOLID,                  // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_VOLCANOBLAST
     -1,                        // doomednum
     S_VOLCANOBALL1,            // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_VOLCANOBALLX1,           // deathstate
     S_NULL,                    // xdeathstate
     sfx_volhit,                // deathsound
     S_NULL,                    // raisestate
     2 * FRACUNIT,              // speed
     8 * FRACUNIT,              // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     2,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF,   // flags
     MF2_LOGRAV | MF2_NOTELEPORT | MF2_FIREDAMAGE,      // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_VOLCANOTBLAST
     -1,                        // doomednum
     S_VOLCANOTBALL1,           // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_VOLCANOTBALLX1,          // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     2 * FRACUNIT,              // speed
     8 * FRACUNIT,              // radius
     6 * FRACUNIT,              // height
     100,                       // mass
     1,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF,   // flags
     MF2_LOGRAV | MF2_NOTELEPORT | MF2_FIREDAMAGE,      // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_TELEGLITGEN
     -1,                        // doomednum
     S_TELEGLITGEN1,            // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_NOSECTOR,        // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_TELEGLITGEN2
     -1,                        // doomednum
     S_TELEGLITGEN2,            // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_NOSECTOR,        // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_TELEGLITTER
     -1,                        // doomednum
     S_TELEGLITTER1_1,          // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_MISSILE, // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_TELEGLITTER2
     -1,                        // doomednum
     S_TELEGLITTER2_1,          // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_MISSILE, // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },
/*
    {                           // MT_TFOG
     -1,                        // doomednum
     S_HTFOG1,                  // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_NOGRAVITY,      // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },
*/
/*
    {                           // MT_TELEPORTMAN
     14,                        // doomednum
     S_NULL,                    // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_NOSECTOR,       // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },
*/
    {                           // MT_STAFFPUFF
     -1,                        // doomednum
     S_STAFFPUFF1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_stfhit,                // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_NOGRAVITY,      // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_STAFFPUFF2
     -1,                        // doomednum
     S_STAFFPUFF2_1,            // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_stfpow,                // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_NOGRAVITY,      // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_BEAKPUFF
     -1,                        // doomednum
     S_STAFFPUFF1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_chicatk,               // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_NOGRAVITY,      // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MISC13
     -1,                        // doomednum
     S_WGNT,                    // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL,                // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_GAUNTLETPUFF1
     -1,                        // doomednum
     S_GAUNTLETPUFF1_1,         // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SHADOW,  // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_GAUNTLETPUFF2
     -1,                        // doomednum
     S_GAUNTLETPUFF2_1,         // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SHADOW,  // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MISC14
     -1,                        // doomednum
     S_BLSR,                    // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL,                // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_BLASTERFX1
     -1,                        // doomednum
     S_BLASTERFX1_1,            // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_BLASTERFXI1_1,           // deathstate
     S_NULL,                    // xdeathstate
     sfx_blshit,                // deathsound
     S_NULL,                    // raisestate
     184 * FRACUNIT,            // speed
     12 * FRACUNIT,             // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     2,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT,            // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_BLASTERSMOKE
     -1,                        // doomednum
     S_BLASTERSMOKE1,           // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SHADOW,  // flags
     MF2_NOTELEPORT | MF2_CANNOTPUSH,   // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_RIPPER
     -1,                        // doomednum
     S_RIPPER1,                 // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_RIPPERX1,                // deathstate
     S_NULL,                    // xdeathstate
     sfx_hrnhit,                // deathsound
     S_NULL,                    // raisestate
     14 * FRACUNIT,             // speed
     8 * FRACUNIT,              // radius
     6 * FRACUNIT,              // height
     100,                       // mass
     1,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_RIP,  // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_BLASTERPUFF1
     -1,                        // doomednum
     S_BLASTERPUFF1_1,          // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_NOGRAVITY,      // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_BLASTERPUFF2
     -1,                        // doomednum
     S_BLASTERPUFF2_1,          // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_NOGRAVITY,      // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_WMACE
     -1,                        // doomednum
     S_WMCE,                    // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL,                // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MACEFX1
     -1,                        // doomednum
     S_MACEFX1_1,               // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_lobsht,                // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_MACEFXI1_1,              // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     20 * FRACUNIT,             // speed
     8 * FRACUNIT,              // radius
     6 * FRACUNIT,              // height
     100,                       // mass
     2,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_FLOORBOUNCE | MF2_THRUGHOST | MF2_NOTELEPORT,  // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MACEFX2
     -1,                        // doomednum
     S_MACEFX2_1,               // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_MACEFXI2_1,              // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     10 * FRACUNIT,             // speed
     8 * FRACUNIT,              // radius
     6 * FRACUNIT,              // height
     100,                       // mass
     6,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF,   // flags
     MF2_LOGRAV | MF2_FLOORBOUNCE | MF2_THRUGHOST | MF2_NOTELEPORT,     // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MACEFX3
     -1,                        // doomednum
     S_MACEFX3_1,               // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_MACEFXI1_1,              // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     7 * FRACUNIT,              // speed
     8 * FRACUNIT,              // radius
     6 * FRACUNIT,              // height
     100,                       // mass
     4,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF,   // flags
     MF2_LOGRAV | MF2_FLOORBOUNCE | MF2_THRUGHOST | MF2_NOTELEPORT,     // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MACEFX4
     -1,                        // doomednum
     S_MACEFX4_1,               // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_MACEFXI4_1,              // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     7 * FRACUNIT,              // speed
     8 * FRACUNIT,              // radius
     6 * FRACUNIT,              // height
     100,                       // mass
     18,                        // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF,   // flags
     MF2_LOGRAV | MF2_FLOORBOUNCE | MF2_THRUGHOST | MF2_TELESTOMP,      // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_WSKULLROD
     -1,                        // doomednum
     S_WSKL,                    // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL,                // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_HORNRODFX1
     -1,                        // doomednum
     S_HRODFX1_1,               // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_hrnsht,                // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_HRODFXI1_1,              // deathstate
     S_NULL,                    // xdeathstate
     sfx_hrnhit,                // deathsound
     S_NULL,                    // raisestate
     22 * FRACUNIT,             // speed
     12 * FRACUNIT,             // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     3,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_WINDTHRUST | MF2_NOTELEPORT,   // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_HORNRODFX2
     -1,                        // doomednum
     S_HRODFX2_1,               // spawnstate
     4 * 35,                    // spawnhealth
     S_NULL,                    // seestate
     sfx_hrnsht,                // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_HRODFXI2_1,              // deathstate
     S_NULL,                    // xdeathstate
     sfx_ramphit,               // deathsound
     S_NULL,                    // raisestate
     22 * FRACUNIT,             // speed
     12 * FRACUNIT,             // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     10,                        // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT,            // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_RAINPLR1
     -1,                        // doomednum
     S_RAINPLR1_1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_RAINPLR1X_1,             // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     12 * FRACUNIT,             // speed
     5 * FRACUNIT,              // radius
     12 * FRACUNIT,             // height
     100,                       // mass
     5,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT,            // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_RAINPLR2
     -1,                        // doomednum
     S_RAINPLR2_1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_RAINPLR2X_1,             // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     12 * FRACUNIT,             // speed
     5 * FRACUNIT,              // radius
     12 * FRACUNIT,             // height
     100,                       // mass
     5,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT,            // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_RAINPLR3
     -1,                        // doomednum
     S_RAINPLR3_1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_RAINPLR3X_1,             // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     12 * FRACUNIT,             // speed
     5 * FRACUNIT,              // radius
     12 * FRACUNIT,             // height
     100,                       // mass
     5,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT,            // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_RAINPLR4
     -1,                        // doomednum
     S_RAINPLR4_1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_RAINPLR4X_1,             // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     12 * FRACUNIT,             // speed
     5 * FRACUNIT,              // radius
     12 * FRACUNIT,             // height
     100,                       // mass
     5,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT,            // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_GOLDWANDFX1
     -1,                        // doomednum
     S_GWANDFX1_1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_GWANDFXI1_1,             // deathstate
     S_NULL,                    // xdeathstate
     sfx_gldhit,                // deathsound
     S_NULL,                    // raisestate
     22 * FRACUNIT,             // speed
     10 * FRACUNIT,             // radius
     6 * FRACUNIT,              // height
     100,                       // mass
     2,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT,            // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_GOLDWANDFX2
     -1,                        // doomednum
     S_GWANDFX2_1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_GWANDFXI1_1,             // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     18 * FRACUNIT,             // speed
     10 * FRACUNIT,             // radius
     6 * FRACUNIT,              // height
     100,                       // mass
     1,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT,            // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_GOLDWANDPUFF1
     -1,                        // doomednum
     S_GWANDPUFF1_1,            // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_NOGRAVITY,      // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_GOLDWANDPUFF2
     -1,                        // doomednum
     S_GWANDFXI1_1,             // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_NOGRAVITY,      // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_WPHOENIXROD
     -1,                        // doomednum
     S_WPHX,                    // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL,                // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_PHOENIXFX1
     -1,                        // doomednum
     S_PHOENIXFX1_1,            // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_phosht,                // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_PHOENIXFXI1_1,           // deathstate
     S_NULL,                    // xdeathstate
     sfx_phohit,                // deathsound
     S_NULL,                    // raisestate
     20 * FRACUNIT,             // speed
     11 * FRACUNIT,             // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     20,                        // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_THRUGHOST | MF2_NOTELEPORT,    // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_PHOENIXPUFF
     -1,                        // doomednum
     S_PHOENIXPUFF1,            // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_SHADOW,  // flags
     MF2_NOTELEPORT | MF2_CANNOTPUSH,   // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_PHOENIXFX2
     -1,                        // doomednum
     S_PHOENIXFX2_1,            // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_PHOENIXFXI2_1,           // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     10 * FRACUNIT,             // speed
     6 * FRACUNIT,              // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     2,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_FIREDAMAGE,   // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MISC15
     -1,                        // doomednum
     S_WBOW,                    // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL,                // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_CRBOWFX1
     -1,                        // doomednum
     S_CRBOWFX1,                // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_bowsht,                // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_CRBOWFXI1_1,             // deathstate
     S_NULL,                    // xdeathstate
     sfx_hrnhit,                // deathsound
     S_NULL,                    // raisestate
     30 * FRACUNIT,             // speed
     11 * FRACUNIT,             // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     10,                        // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT,            // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_CRBOWFX2
     -1,                        // doomednum
     S_CRBOWFX2,                // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_bowsht,                // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_CRBOWFXI1_1,             // deathstate
     S_NULL,                    // xdeathstate
     sfx_hrnhit,                // deathsound
     S_NULL,                    // raisestate
     32 * FRACUNIT,             // speed
     11 * FRACUNIT,             // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     6,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT,            // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_CRBOWFX3
     -1,                        // doomednum
     S_CRBOWFX3,                // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_CRBOWFXI3_1,             // deathstate
     S_NULL,                    // xdeathstate
     sfx_hrnhit,                // deathsound
     S_NULL,                    // raisestate
     20 * FRACUNIT,             // speed
     11 * FRACUNIT,             // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     2,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_WINDTHRUST | MF2_THRUGHOST | MF2_NOTELEPORT,   // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_CRBOWFX4
     -1,                        // doomednum
     S_CRBOWFX4_1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP,             // flags
     MF2_LOGRAV,                // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },
/*
    {                           // MT_BLOOD
     -1,                        // doomednum
     S_HBLOOD1,                 // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP,             // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },
*/
    {                           // MT_BLOODSPLATTER
     -1,                        // doomednum
     S_BLOODSPLATTER1,          // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_BLOODSPLATTERX,          // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     2 * FRACUNIT,              // radius
     4 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF,   // flags
     MF2_NOTELEPORT | MF2_CANNOTPUSH,   // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },
/*
    {                           // MT_PLAYER
     -1,                        // doomednum
     S_PLAY,                    // spawnstate
     100,                       // spawnhealth
     S_PLAY_RUN1,               // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     0,                         // reactiontime
     sfx_None,                  // attacksound
     S_PLAY_PAIN,               // painstate
     255,                       // painchance
     sfx_plrpai,                // painsound
     S_NULL,                    // meleestate
     S_PLAY_ATK1,               // missilestate
     S_NULL,                    // crashstate
     S_PLAY_DIE1,               // deathstate
     S_PLAY_XDIE1,              // xdeathstate
     sfx_plrdth,                // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     16 * FRACUNIT,             // radius
     56 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SOLID | MF_SHOOTABLE | MF_DROPOFF | MF_PICKUP | MF_NOTDMATCH,   // flags
     MF2_WINDTHRUST | MF2_FOOTCLIP | MF2_SLIDE | MF2_PASSMOBJ | MF2_TELESTOMP,  // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },
*/
    {                           // MT_BLOODYSKULL
     -1,                        // doomednum
     S_BLOODYSKULL1,            // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     4 * FRACUNIT,              // radius
     4 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_DROPOFF,        // flags
     MF2_LOGRAV | MF2_CANNOTPUSH,       // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_CHICPLAYER
     -1,                        // doomednum
     S_CHICPLAY,                // spawnstate
     100,                       // spawnhealth
     S_CHICPLAY_RUN1,           // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     0,                         // reactiontime
     sfx_None,                  // attacksound
     S_CHICPLAY_PAIN,           // painstate
     255,                       // painchance
     sfx_chicpai,               // painsound
     S_NULL,                    // meleestate
     S_CHICPLAY_ATK1,           // missilestate
     S_NULL,                    // crashstate
     S_CHICKEN_DIE1,            // deathstate
     S_NULL,                    // xdeathstate
     sfx_chicdth,               // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     16 * FRACUNIT,             // radius
     24 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SOLID | MF_SHOOTABLE | MF_DROPOFF | MF_NOTDMATCH,       // flags
     MF2_WINDTHRUST | MF2_SLIDE | MF2_PASSMOBJ | MF2_FOOTCLIP | MF2_LOGRAV | MF2_TELESTOMP,     // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_CHICKEN
     -1,                        // doomednum
     S_CHICKEN_LOOK1,           // spawnstate
     10,                        // spawnhealth
     S_CHICKEN_WALK1,           // seestate
     sfx_chicpai,               // seesound
     sfx_chicact,               // activesound
     8,                         // reactiontime
     sfx_chicatk,               // attacksound
     S_CHICKEN_PAIN1,           // painstate
     200,                       // painchance
     sfx_chicpai,               // painsound
     S_CHICKEN_ATK1,            // meleestate
     0,                         // missilestate
     S_NULL,                    // crashstate
     S_CHICKEN_DIE1,            // deathstate
     S_NULL,                    // xdeathstate
     sfx_chicdth,               // deathsound
     S_NULL,                    // raisestate
     4,                         // speed
     9 * FRACUNIT,              // radius
     22 * FRACUNIT,             // height
     40,                        // mass
     0,                         // damage
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL | MF_DROPOFF,       // flags
     MF2_WINDTHRUST | MF2_FOOTCLIP | MF2_PASSMOBJ,      // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_FEATHER
     -1,                        // doomednum
     S_FEATHER1,                // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_FEATHERX,                // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     2 * FRACUNIT,              // radius
     4 * FRACUNIT,              // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF,   // flags
     MF2_NOTELEPORT | MF2_LOGRAV | MF2_CANNOTPUSH | MF2_WINDTHRUST,     // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MUMMY
     -1,                        // doomednum
     S_MUMMY_LOOK1,             // spawnstate
     80,                        // spawnhealth
     S_MUMMY_WALK1,             // seestate
     sfx_mumsit,                // seesound
     sfx_mumact,                // activesound
     8,                         // reactiontime
     sfx_mumat1,                // attacksound
     S_MUMMY_PAIN1,             // painstate
     128,                       // painchance
     sfx_mumpai,                // painsound
     S_MUMMY_ATK1,              // meleestate
     0,                         // missilestate
     S_NULL,                    // crashstate
     S_MUMMY_DIE1,              // deathstate
     S_NULL,                    // xdeathstate
     sfx_mumdth,                // deathsound
     S_NULL,                    // raisestate
     12,                        // speed
     22 * FRACUNIT,             // radius
     62 * FRACUNIT,             // height
     75,                        // mass
     0,                         // damage
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL,    // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ,       // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MUMMYLEADER
     -1,                        // doomednum
     S_MUMMY_LOOK1,             // spawnstate
     100,                       // spawnhealth
     S_MUMMY_WALK1,             // seestate
     sfx_mumsit,                // seesound
     sfx_mumact,                // activesound
     8,                         // reactiontime
     sfx_mumat1,                // attacksound
     S_MUMMY_PAIN1,             // painstate
     64,                        // painchance
     sfx_mumpai,                // painsound
     S_MUMMY_ATK1,              // meleestate
     S_MUMMYL_ATK1,             // missilestate
     S_NULL,                    // crashstate
     S_MUMMY_DIE1,              // deathstate
     S_NULL,                    // xdeathstate
     sfx_mumdth,                // deathsound
     S_NULL,                    // raisestate
     12,                        // speed
     22 * FRACUNIT,             // radius
     62 * FRACUNIT,             // height
     75,                        // mass
     0,                         // damage
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL,    // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ,       // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MUMMYGHOST
     -1,                        // doomednum
     S_MUMMY_LOOK1,             // spawnstate
     80,                        // spawnhealth
     S_MUMMY_WALK1,             // seestate
     sfx_mumsit,                // seesound
     sfx_mumact,                // activesound
     8,                         // reactiontime
     sfx_mumat1,                // attacksound
     S_MUMMY_PAIN1,             // painstate
     128,                       // painchance
     sfx_mumpai,                // painsound
     S_MUMMY_ATK1,              // meleestate
     0,                         // missilestate
     S_NULL,                    // crashstate
     S_MUMMY_DIE1,              // deathstate
     S_NULL,                    // xdeathstate
     sfx_mumdth,                // deathsound
     S_NULL,                    // raisestate
     12,                        // speed
     22 * FRACUNIT,             // radius
     62 * FRACUNIT,             // height
     75,                        // mass
     0,                         // damage
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL | MF_SHADOW,        // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ,       // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MUMMYLEADERGHOST
     -1,                        // doomednum
     S_MUMMY_LOOK1,             // spawnstate
     100,                       // spawnhealth
     S_MUMMY_WALK1,             // seestate
     sfx_mumsit,                // seesound
     sfx_mumact,                // activesound
     8,                         // reactiontime
     sfx_mumat1,                // attacksound
     S_MUMMY_PAIN1,             // painstate
     64,                        // painchance
     sfx_mumpai,                // painsound
     S_MUMMY_ATK1,              // meleestate
     S_MUMMYL_ATK1,             // missilestate
     S_NULL,                    // crashstate
     S_MUMMY_DIE1,              // deathstate
     S_NULL,                    // xdeathstate
     sfx_mumdth,                // deathsound
     S_NULL,                    // raisestate
     12,                        // speed
     22 * FRACUNIT,             // radius
     62 * FRACUNIT,             // height
     75,                        // mass
     0,                         // damage
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL | MF_SHADOW,        // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ,       // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MUMMYSOUL
     -1,                        // doomednum
     S_MUMMY_SOUL1,             // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_NOGRAVITY,      // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MUMMYFX1
     -1,                        // doomednum
     S_MUMMYFX1_1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_MUMMYFXI1_1,             // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     9 * FRACUNIT,              // speed
     8 * FRACUNIT,              // radius
     14 * FRACUNIT,             // height
     100,                       // mass
     4,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT,            // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_BEAST
     -1,                        // doomednum
     S_BEAST_LOOK1,             // spawnstate
     220,                       // spawnhealth
     S_BEAST_WALK1,             // seestate
     sfx_bstsit,                // seesound
     sfx_bstact,                // activesound
     8,                         // reactiontime
     sfx_bstatk,                // attacksound
     S_BEAST_PAIN1,             // painstate
     100,                       // painchance
     sfx_bstpai,                // painsound
     0,                         // meleestate
     S_BEAST_ATK1,              // missilestate
     S_NULL,                    // crashstate
     S_BEAST_DIE1,              // deathstate
     S_BEAST_XDIE1,             // xdeathstate
     sfx_bstdth,                // deathsound
     S_NULL,                    // raisestate
     14,                        // speed
     32 * FRACUNIT,             // radius
     74 * FRACUNIT,             // height
     200,                       // mass
     0,                         // damage
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL,    // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ,       // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_BEASTBALL
     -1,                        // doomednum
     S_BEASTBALL1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_BEASTBALLX1,             // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     12 * FRACUNIT,             // speed
     9 * FRACUNIT,              // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     4,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_WINDTHRUST | MF2_NOTELEPORT,   // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_BURNBALL
     -1,                        // doomednum
     S_BURNBALL1,               // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_BEASTBALLX1,             // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     10 * FRACUNIT,             // speed
     6 * FRACUNIT,              // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     2,                         // damage
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_MISSILE, // flags
     MF2_NOTELEPORT,            // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_BURNBALLFB
     -1,                        // doomednum
     S_BURNBALLFB1,             // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_BEASTBALLX1,             // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     10 * FRACUNIT,             // speed
     6 * FRACUNIT,              // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     2,                         // damage
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_MISSILE, // flags
     MF2_NOTELEPORT,            // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_PUFFY
     -1,                        // doomednum
     S_PUFFY1,                  // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_PUFFY1,                  // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     10 * FRACUNIT,             // speed
     6 * FRACUNIT,              // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     2,                         // damage
     MF_NOBLOCKMAP | MF_NOGRAVITY | MF_MISSILE, // flags
     MF2_NOTELEPORT,            // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_SNAKE
     92,                        // doomednum
     S_SNAKE_LOOK1,             // spawnstate
     280,                       // spawnhealth
     S_SNAKE_WALK1,             // seestate
     sfx_snksit,                // seesound
     sfx_snkact,                // activesound
     8,                         // reactiontime
     sfx_snkatk,                // attacksound
     S_SNAKE_PAIN1,             // painstate
     48,                        // painchance
     sfx_snkpai,                // painsound
     0,                         // meleestate
     S_SNAKE_ATK1,              // missilestate
     S_NULL,                    // crashstate
     S_SNAKE_DIE1,              // deathstate
     S_NULL,                    // xdeathstate
     sfx_snkdth,                // deathsound
     S_NULL,                    // raisestate
     10,                        // speed
     22 * FRACUNIT,             // radius
     70 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL,    // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ,       // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_SNAKEPRO_A
     -1,                        // doomednum
     S_SNAKEPRO_A1,             // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_SNAKEPRO_AX1,            // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     14 * FRACUNIT,             // speed
     12 * FRACUNIT,             // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     1,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_WINDTHRUST | MF2_NOTELEPORT,   // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_SNAKEPRO_B
     -1,                        // doomednum
     S_SNAKEPRO_B1,             // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_SNAKEPRO_BX1,            // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     14 * FRACUNIT,             // speed
     12 * FRACUNIT,             // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     3,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT,            // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_HEAD
     -1,                        // doomednum
     S_HHEAD_LOOK,              // spawnstate
     700,                       // spawnhealth
     S_HHEAD_FLOAT,             // seestate
     sfx_hedsit,                // seesound
     sfx_hedact,                // activesound
     8,                         // reactiontime
     sfx_hedat1,                // attacksound
     S_HHEAD_PAIN1,             // painstate
     32,                        // painchance
     sfx_hedpai,                // painsound
     0,                         // meleestate
     S_HHEAD_ATK1,              // missilestate
     S_NULL,                    // crashstate
     S_HHEAD_DIE1,              // deathstate
     S_NULL,                    // xdeathstate
     sfx_heddth,                // deathsound
     S_NULL,                    // raisestate
     6,                         // speed
     40 * FRACUNIT,             // radius
     72 * FRACUNIT,             // height
     325,                       // mass
     0,                         // damage
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL | MF_NOBLOOD,       // flags
     MF2_PASSMOBJ,              // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_HEADFX1
     -1,                        // doomednum
     S_HHEADFX1_1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_HHEADFXI1_1,             // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     13 * FRACUNIT,             // speed
     12 * FRACUNIT,             // radius
     6 * FRACUNIT,              // height
     100,                       // mass
     1,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_THRUGHOST,    // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_HEADFX2
     -1,                        // doomednum
     S_HHEADFX2_1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_HHEADFXI2_1,             // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     8 * FRACUNIT,              // speed
     12 * FRACUNIT,             // radius
     6 * FRACUNIT,              // height
     100,                       // mass
     3,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT,            // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_HEADFX3
     -1,                        // doomednum
     S_HHEADFX3_1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_HHEADFXI3_1,             // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     10 * FRACUNIT,             // speed
     14 * FRACUNIT,             // radius
     12 * FRACUNIT,             // height
     100,                       // mass
     5,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_WINDTHRUST | MF2_NOTELEPORT,   // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_WHIRLWIND
     -1,                        // doomednum
     S_HHEADFX4_1,              // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_HHEADFXI4_1,             // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     10 * FRACUNIT,             // speed
     16 * FRACUNIT,             // radius
     74 * FRACUNIT,             // height
     100,                       // mass
     1,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY | MF_SHADOW,        // flags
     MF2_NOTELEPORT,            // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_CLINK
     90,                        // doomednum
     S_CLINK_LOOK1,             // spawnstate
     150,                       // spawnhealth
     S_CLINK_WALK1,             // seestate
     sfx_clksit,                // seesound
     sfx_clkact,                // activesound
     8,                         // reactiontime
     sfx_clkatk,                // attacksound
     S_CLINK_PAIN1,             // painstate
     32,                        // painchance
     sfx_clkpai,                // painsound
     S_CLINK_ATK1,              // meleestate
     0,                         // missilestate
     S_NULL,                    // crashstate
     S_CLINK_DIE1,              // deathstate
     S_NULL,                    // xdeathstate
     sfx_clkdth,                // deathsound
     S_NULL,                    // raisestate
     14,                        // speed
     20 * FRACUNIT,             // radius
     64 * FRACUNIT,             // height
     75,                        // mass
     0,                         // damage
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL | MF_NOBLOOD,       // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ,       // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_WIZARD
     -1,                        // doomednum
     S_WIZARD_LOOK1,            // spawnstate
     180,                       // spawnhealth
     S_WIZARD_WALK1,            // seestate
     sfx_wizsit,                // seesound
     sfx_wizact,                // activesound
     8,                         // reactiontime
     sfx_wizatk,                // attacksound
     S_WIZARD_PAIN1,            // painstate
     64,                        // painchance
     sfx_wizpai,                // painsound
     0,                         // meleestate
     S_WIZARD_ATK1,             // missilestate
     S_NULL,                    // crashstate
     S_WIZARD_DIE1,             // deathstate
     S_NULL,                    // xdeathstate
     sfx_wizdth,                // deathsound
     S_NULL,                    // raisestate
     12,                        // speed
     16 * FRACUNIT,             // radius
     68 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL | MF_FLOAT | MF_NOGRAVITY,  // flags
     MF2_PASSMOBJ,              // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_WIZFX1
     -1,                        // doomednum
     S_WIZFX1_1,                // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_WIZFXI1_1,               // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     18 * FRACUNIT,             // speed
     10 * FRACUNIT,             // radius
     6 * FRACUNIT,              // height
     100,                       // mass
     3,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT,            // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_IMP
     -1,                        // doomednum
     S_IMP_LOOK1,               // spawnstate
     40,                        // spawnhealth
     S_IMP_FLY1,                // seestate
     sfx_impsit,                // seesound
     sfx_impact,                // activesound
     8,                         // reactiontime
     sfx_impat1,                // attacksound
     S_IMP_PAIN1,               // painstate
     200,                       // painchance
     sfx_imppai,                // painsound
     S_IMP_MEATK1,              // meleestate
     S_IMP_MSATK1_1,            // missilestate
     S_IMP_CRASH1,              // crashstate
     S_IMP_DIE1,                // deathstate
     S_IMP_XDIE1,               // xdeathstate
     sfx_impdth,                // deathsound
     S_NULL,                    // raisestate
     10,                        // speed
     16 * FRACUNIT,             // radius
     36 * FRACUNIT,             // height
     50,                        // mass
     0,                         // damage
     MF_SOLID | MF_SHOOTABLE | MF_FLOAT | MF_NOGRAVITY | MF_COUNTKILL,  // flags
     MF2_SPAWNFLOAT | MF2_PASSMOBJ,     // flags2
#ifdef MOBJ_HAS_FLAGS3
# ifdef MBF21
     MF3_RANGEHALF,
# else
     0,
# endif
#endif
        0,
     },

    {                           // MT_IMPLEADER
     -1,                        // doomednum
     S_IMP_LOOK1,               // spawnstate
     80,                        // spawnhealth
     S_IMP_FLY1,                // seestate
     sfx_impsit,                // seesound
     sfx_impact,                // activesound
     8,                         // reactiontime
     sfx_impat2,                // attacksound
     S_IMP_PAIN1,               // painstate
     200,                       // painchance
     sfx_imppai,                // painsound
     0,                         // meleestate
     S_IMP_MSATK2_1,            // missilestate
     S_IMP_CRASH1,              // crashstate
     S_IMP_DIE1,                // deathstate
     S_IMP_XDIE1,               // xdeathstate
     sfx_impdth,                // deathsound
     S_NULL,                    // raisestate
     10,                        // speed
     16 * FRACUNIT,             // radius
     36 * FRACUNIT,             // height
     50,                        // mass
     0,                         // damage
     MF_SOLID | MF_SHOOTABLE | MF_FLOAT | MF_NOGRAVITY | MF_COUNTKILL,  // flags
     MF2_SPAWNFLOAT | MF2_PASSMOBJ,     // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_IMPCHUNK1
     -1,                        // doomednum
     S_IMP_CHUNKA1,             // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP,             // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_IMPCHUNK2
     -1,                        // doomednum
     S_IMP_CHUNKB1,             // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP,             // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_IMPBALL
     -1,                        // doomednum
     S_IMPFX1,                  // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_IMPFXI1,                 // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     10 * FRACUNIT,             // speed
     8 * FRACUNIT,              // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     1,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_WINDTHRUST | MF2_NOTELEPORT,   // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_KNIGHT
     -1,                        // doomednum
     S_KNIGHT_STND1,            // spawnstate
     200,                       // spawnhealth
     S_KNIGHT_WALK1,            // seestate
     sfx_kgtsit,                // seesound
     sfx_kgtact,                // activesound
     8,                         // reactiontime
     sfx_kgtatk,                // attacksound
     S_KNIGHT_PAIN1,            // painstate
     100,                       // painchance
     sfx_kgtpai,                // painsound
     S_KNIGHT_ATK1,             // meleestate
     S_KNIGHT_ATK1,             // missilestate
     S_NULL,                    // crashstate
     S_KNIGHT_DIE1,             // deathstate
     S_NULL,                    // xdeathstate
     sfx_kgtdth,                // deathsound
     S_NULL,                    // raisestate
     12,                        // speed
     24 * FRACUNIT,             // radius
     78 * FRACUNIT,             // height
     150,                       // mass
     0,                         // damage
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL,    // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ,       // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_KNIGHTGHOST
     65,                        // doomednum
     S_KNIGHT_STND1,            // spawnstate
     200,                       // spawnhealth
     S_KNIGHT_WALK1,            // seestate
     sfx_kgtsit,                // seesound
     sfx_kgtact,                // activesound
     8,                         // reactiontime
     sfx_kgtatk,                // attacksound
     S_KNIGHT_PAIN1,            // painstate
     100,                       // painchance
     sfx_kgtpai,                // painsound
     S_KNIGHT_ATK1,             // meleestate
     S_KNIGHT_ATK1,             // missilestate
     S_NULL,                    // crashstate
     S_KNIGHT_DIE1,             // deathstate
     S_NULL,                    // xdeathstate
     sfx_kgtdth,                // deathsound
     S_NULL,                    // raisestate
     12,                        // speed
     24 * FRACUNIT,             // radius
     78 * FRACUNIT,             // height
     150,                       // mass
     0,                         // damage
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL | MF_SHADOW,        // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ,       // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_KNIGHTAXE
     -1,                        // doomednum
     S_SPINAXE1,                // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_SPINAXEX1,               // deathstate
     S_NULL,                    // xdeathstate
     sfx_hrnhit,                // deathsound
     S_NULL,                    // raisestate
     9 * FRACUNIT,              // speed
     10 * FRACUNIT,             // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     2,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_WINDTHRUST | MF2_NOTELEPORT | MF2_THRUGHOST,   // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_REDAXE
     -1,                        // doomednum
     S_REDAXE1,                 // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_REDAXEX1,                // deathstate
     S_NULL,                    // xdeathstate
     sfx_hrnhit,                // deathsound
     S_NULL,                    // raisestate
     9 * FRACUNIT,              // speed
     10 * FRACUNIT,             // radius
     8 * FRACUNIT,              // height
     100,                       // mass
     7,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_THRUGHOST,    // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_SORCERER1
     -1,                        // doomednum
     S_SRCR1_LOOK1,             // spawnstate
     2000,                      // spawnhealth
     S_SRCR1_WALK1,             // seestate
     sfx_sbtsit,                // seesound
     sfx_sbtact,                // activesound
     8,                         // reactiontime
     sfx_sbtatk,                // attacksound
     S_SRCR1_PAIN1,             // painstate
     56,                        // painchance
     sfx_sbtpai,                // painsound
     0,                         // meleestate
     S_SRCR1_ATK1,              // missilestate
     S_NULL,                    // crashstate
     S_SRCR1_DIE1,              // deathstate
     S_NULL,                    // xdeathstate
     sfx_sbtdth,                // deathsound
     S_NULL,                    // raisestate
     16,                        // speed
     28 * FRACUNIT,             // radius
     100 * FRACUNIT,            // height
     800,                       // mass
     0,                         // damage
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL,    // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ | MF2_BOSS,    // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_SRCRFX1
     -1,                        // doomednum
     S_SRCRFX1_1,               // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_SRCRFXI1_1,              // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     20 * FRACUNIT,             // speed
     10 * FRACUNIT,             // radius
     10 * FRACUNIT,             // height
     100,                       // mass
     10,                        // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_FIREDAMAGE,   // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_SORCERER2
     -1,                        // doomednum
     S_SOR2_LOOK1,              // spawnstate
     3500,                      // spawnhealth
     S_SOR2_WALK1,              // seestate
     sfx_sorsit,                // seesound
     sfx_soract,                // activesound
     8,                         // reactiontime
     sfx_soratk,                // attacksound
     S_SOR2_PAIN1,              // painstate
     32,                        // painchance
     sfx_sorpai,                // painsound
     0,                         // meleestate
     S_SOR2_ATK1,               // missilestate
     S_NULL,                    // crashstate
     S_SOR2_DIE1,               // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     14,                        // speed
     16 * FRACUNIT,             // radius
     70 * FRACUNIT,             // height
     300,                       // mass
     0,                         // damage
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL | MF_DROPOFF,       // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ | MF2_BOSS,    // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_SOR2FX1
     -1,                        // doomednum
     S_SOR2FX1_1,               // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_SOR2FXI1_1,              // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     20 * FRACUNIT,             // speed
     10 * FRACUNIT,             // radius
     6 * FRACUNIT,              // height
     100,                       // mass
     1,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT,            // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_SOR2FXSPARK
     -1,                        // doomednum
     S_SOR2FXSPARK1,            // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_NOGRAVITY,      // flags
     MF2_NOTELEPORT | MF2_CANNOTPUSH,   // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_SOR2FX2
     -1,                        // doomednum
     S_SOR2FX2_1,               // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_SOR2FXI2_1,              // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     6 * FRACUNIT,              // speed
     10 * FRACUNIT,             // radius
     6 * FRACUNIT,              // height
     100,                       // mass
     10,                        // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT,            // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_SOR2TELEFADE
     -1,                        // doomednum
     S_SOR2TELEFADE1,           // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP,             // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MINOTAUR
     -1,                         // doomednum
     S_MNTR_LOOK1,              // spawnstate
     3000,                      // spawnhealth
     S_MNTR_WALK1,              // seestate
     sfx_minsit,                // seesound
     sfx_minact,                // activesound
     8,                         // reactiontime
     sfx_minat1,                // attacksound
     S_MNTR_PAIN1,              // painstate
     25,                        // painchance
     sfx_minpai,                // painsound
     S_MNTR_ATK1_1,             // meleestate
     S_MNTR_ATK2_1,             // missilestate
     S_NULL,                    // crashstate
     S_MNTR_DIE1,               // deathstate
     S_NULL,                    // xdeathstate
     sfx_mindth,                // deathsound
     S_NULL,                    // raisestate
     16,                        // speed
     28 * FRACUNIT,             // radius
     100 * FRACUNIT,            // height
     800,                       // mass
     7,                         // damage
     MF_SOLID | MF_SHOOTABLE | MF_COUNTKILL | MF_DROPOFF,       // flags
     MF2_FOOTCLIP | MF2_PASSMOBJ | MF2_BOSS,    // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MNTRFX1
     -1,                        // doomednum
     S_MNTRFX1_1,               // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_MNTRFXI1_1,              // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     20 * FRACUNIT,             // speed
     10 * FRACUNIT,             // radius
     6 * FRACUNIT,              // height
     100,                       // mass
     3,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_FIREDAMAGE,   // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MNTRFX2
     -1,                        // doomednum
     S_MNTRFX2_1,               // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_MNTRFXI2_1,              // deathstate
     S_NULL,                    // xdeathstate
     sfx_phohit,                // deathsound
     S_NULL,                    // raisestate
     14 * FRACUNIT,             // speed
     5 * FRACUNIT,              // radius
     12 * FRACUNIT,             // height
     100,                       // mass
     4,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_FIREDAMAGE,   // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_MNTRFX3
     -1,                        // doomednum
     S_MNTRFX3_1,               // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_MNTRFXI2_1,              // deathstate
     S_NULL,                    // xdeathstate
     sfx_phohit,                // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     8 * FRACUNIT,              // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     4,                         // damage
     MF_NOBLOCKMAP | MF_MISSILE | MF_DROPOFF | MF_NOGRAVITY,    // flags
     MF2_NOTELEPORT | MF2_FIREDAMAGE,   // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_AKYY
     -1,                        // doomednum
     S_AKYY1,                   // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL | MF_NOTDMATCH, // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_BKYY
     -1,                        // doomednum
     S_BKYY1,                   // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL | MF_NOTDMATCH, // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_CKEY
     -1,                        // doomednum
     S_CKYY1,                   // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL | MF_NOTDMATCH, // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_AMGWNDWIMPY
     -1,                        // doomednum
     S_AMG1,                    // spawnstate
     AMMO_GWND_WIMPY,           // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL,                // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_AMGWNDHEFTY
     -1,                        // doomednum
     S_AMG2_1,                  // spawnstate
     AMMO_GWND_HEFTY,           // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL,                // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_AMMACEWIMPY
     -1,                        // doomednum
     S_AMM1,                    // spawnstate
     AMMO_MACE_WIMPY,           // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL,                // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_AMMACEHEFTY
     -1,                        // doomednum
     S_AMM2,                    // spawnstate
     AMMO_MACE_HEFTY,           // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL,                // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_AMCBOWWIMPY
     -1,                        // doomednum
     S_AMC1,                    // spawnstate
     AMMO_CBOW_WIMPY,           // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL,                // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_AMCBOWHEFTY
     -1,                        // doomednum
     S_AMC2_1,                  // spawnstate
     AMMO_CBOW_HEFTY,           // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL,                // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_AMSKRDWIMPY
     -1,                        // doomednum
     S_AMS1_1,                  // spawnstate
     AMMO_SKRD_WIMPY,           // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL,                // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_AMSKRDHEFTY
     -1,                        // doomednum
     S_AMS2_1,                  // spawnstate
     AMMO_SKRD_HEFTY,           // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL,                // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_AMPHRDWIMPY
     -1,                        // doomednum
     S_AMP1_1,                  // spawnstate
     AMMO_PHRD_WIMPY,           // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL,                // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_AMPHRDHEFTY
     -1,                        // doomednum
     S_AMP2_1,                  // spawnstate
     AMMO_PHRD_HEFTY,           // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL,                // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_AMBLSRWIMPY
     -1,                        // doomednum
     S_AMB1_1,                  // spawnstate
     AMMO_BLSR_WIMPY,           // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL,                // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_AMBLSRHEFTY
     -1,                        // doomednum
     S_AMB2_1,                  // spawnstate
     AMMO_BLSR_HEFTY,           // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_SPECIAL,                // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_SOUNDWIND
     -1,                        // doomednum
     S_SND_WIND,                // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_NOSECTOR,       // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_SOUNDWATERFALL
     -1,                        // doomednum
     S_SND_WATERFALL,           // spawnstate
     1000,                      // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     20 * FRACUNIT,             // radius
     16 * FRACUNIT,             // height
     100,                       // mass
     0,                         // damage
     MF_NOBLOCKMAP | MF_NOSECTOR,       // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },

    {                           // MT_UNK1
     -1,                        // doomednum
     0,                         // spawnstate
     1,                         // spawnhealth
     S_NULL,                    // seestate
     sfx_None,                  // seesound
     sfx_None,                  // activesound
     8,                         // reactiontime
     sfx_None,                  // attacksound
     S_NULL,                    // painstate
     0,                         // painchance
     sfx_None,                  // painsound
     S_NULL,                    // meleestate
     S_NULL,                    // missilestate
     S_NULL,                    // crashstate
     S_NULL,                    // deathstate
     S_NULL,                    // xdeathstate
     sfx_None,                  // deathsound
     S_NULL,                    // raisestate
     0,                         // speed
     1 * FRACUNIT,              // radius
     1 * FRACUNIT,              // height
     1,                         // mass
     0,                         // damage
     0,                         // flags
     0,                         // flags2
#ifdef MOBJ_HAS_FLAGS3
        0,
#endif
        0,
     },
};


