#!/bin/sh

set -ex

# binaryen version
VERSION='version_123'

# Ensure binaryen utilities are downloaded
curl -fL "https://github.com/WebAssembly/binaryen/releases/download/${VERSION}/binaryen-${VERSION}-x86_64-linux.tar.gz" \
       -o ./binaryen.tgz
tar -xvf ./binaryen.tgz

# Install binaryen utilities to system
install -m 0755 -o root -g root -t /usr/bin \
            ./binaryen-${VERSION}/bin/* && \
install -m 0644 -o root -g root -t /usr/include \
            ./binaryen-${VERSION}/include/* && \
install -m 0644 -o root -g root -t /usr/lib \
            ./binaryen-${VERSION}/lib/*
