// +build ignore

package main

import (
	"bytes"
	"fmt"
	"io/ioutil"
	"log"
	"os/exec"
)

const (
	toLower = 'a' - 'A'
)

func main() {
	toLowerTable := func() [256]byte {
		var a [256]byte
		for i := 0; i < 256; i++ {
			c := byte(i)
			if c >= 'A' && c <= 'Z' {
				c += toLower
			}
			a[i] = c
		}
		return a
	}()

	toUpperTable := func() [256]byte {
		var a [256]byte
		for i := 0; i < 256; i++ {
			c := byte(i)
			if c >= 'a' && c <= 'z' {
				c -= toLower
			}
			a[i] = c
		}
		return a
	}()

	w := new(bytes.Buffer)
	w.WriteString(`package bytes

// Code generated by go run bytesconv_table_gen.go; DO NOT EDIT.
// See bytesconv_table_gen.go for more information about these tables.
// 
// Source: https://github.com/valyala/fasthttp/blob/master/bytes_table_gen.go

`)
	fmt.Fprintf(w, "const (\n")
	fmt.Fprintf(w, "\ttoLowerTable = %q\n", toLowerTable)
	fmt.Fprintf(w, "\ttoUpperTable = %q\n", toUpperTable)
	fmt.Fprintf(w, ")\n")

	if err := ioutil.WriteFile("bytesconv_table.go", w.Bytes(), 0660); err != nil {
		log.Fatal(err)
	}

	if err := exec.Command("gofmt", "-w", "bytesconv_table.go").Run(); err != nil {
		log.Fatal(err)
	}
}
