/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.validation.validator;

import java.util.EnumSet;
import liquibase.repackaged.net.sf.jsqlparser.parser.feature.Feature;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.Alter;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.AlterExpression;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.AlterExpression$ColumnDropNotNull;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.AlterOperation;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationCapability;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationUtil;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.metadata.NamedObject;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.AbstractValidator;

public class AlterValidator
extends AbstractValidator<Alter> {
    @Override
    public void validate(Alter alter) {
        this.validateFeature(Feature.alterTable);
        this.validateOptionalFromItem(alter.getTable());
        alter.getAlterExpressions().forEach(alterExpression -> this.validate(alter, (AlterExpression)alterExpression));
    }

    public void validate(Alter object, AlterExpression alterExpression) {
        for (ValidationCapability validationCapability : this.getCapabilities()) {
            this.validateOptionalColumnName(validationCapability, alterExpression.getColumnOldName());
            this.validateOptionalColumnName(validationCapability, alterExpression.getColumnName());
            if (alterExpression.getColumnDropNotNullList() != null) {
                this.validateOptionalColumnNames(validationCapability, ValidationUtil.map(alterExpression.getColumnDropNotNullList(), AlterExpression$ColumnDropNotNull::getColumnName), new NamedObject[0]);
            }
            if (alterExpression.getColDataTypeList() != null) {
                boolean bl2 = !EnumSet.of(AlterOperation.ADD).contains((Object)alterExpression.getOperation());
                this.validateOptionalColumnNames(validationCapability, ValidationUtil.map(alterExpression.getColDataTypeList(), ColumnDefinition::getColumnName), bl2, NamedObject.table);
            }
            this.validateOptionalName(validationCapability, NamedObject.constraint, alterExpression.getConstraintName(), new NamedObject[0]);
            if (alterExpression.getPkColumns() != null) {
                this.validateOptionalColumnNames(validationCapability, alterExpression.getPkColumns(), new NamedObject[0]);
            }
            if (alterExpression.getFkColumns() != null) {
                this.validateName(validationCapability, NamedObject.table, alterExpression.getFkSourceTable());
                this.validateOptionalColumnNames(validationCapability, alterExpression.getFkColumns(), new NamedObject[0]);
                this.validateOptionalColumnNames(validationCapability, alterExpression.getFkSourceColumns(), new NamedObject[0]);
            }
            if (alterExpression.getUk()) {
                this.validateName(validationCapability, NamedObject.uniqueConstraint, alterExpression.getUkName());
                this.validateOptionalColumnNames(validationCapability, alterExpression.getUkColumns(), NamedObject.uniqueConstraint);
            }
            if (alterExpression.getIndex() == null) continue;
            this.validateName(validationCapability, NamedObject.index, alterExpression.getIndex().getName());
            if (alterExpression.getIndex().getColumns() == null) continue;
            this.validateOptionalColumnNames(validationCapability, alterExpression.getIndex().getColumnsNames(), NamedObject.index);
        }
    }
}

